<?php

class ArtworkLogoArchiveController extends RController
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'rights',
			//'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('@'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model' => $this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new ArtworkLogoArchive;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['ArtworkLogoArchive'])) {
			$model->attributes = $_POST['ArtworkLogoArchive'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id));
		}

		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['ArtworkLogoArchive'])) {
			$model->attributes = $_POST['ArtworkLogoArchive'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id));
		}

		$this->render('update', array(
			'model' => $model,
		));
	}

	 /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $artworkProof = $this->loadModel($id); //$this->loadModel($id)->delete();
            //$job = Jobs::model()->findByPk($model->ref_id);

            if (!$artworkProof) {
                throw new Exception("File not found!", 404);
            }

			$fileName = $artworkProof->logoImage;
            $filePath = 'files/artwork/' . $artworkProof->job_artowk_id . '/' . $artworkProof->logoImage;

            

            if (@unlink($filePath)) {
				if ($artworkProof->delete()) {
					SalesLog::createTblLog($artworkProof->job_artowk_id, 'JobArtwork', "Artwork proof [{$fileName}]  has been deleted.");
					echo json_encode(array('success' => true));
				} else {
					SalesLog::createTblLog($artworkProof->job_artowk_id, 'JobArtwork', "Artwork proof [{$fileName}]  cannot be deleted.");
					echo json_encode(array('success' => false));
				}			

                
            } else {
                SalesLog::createTblLog($artworkProof->job_artowk_id, 'JobArtwork', "Artwork proof [{$fileName}]  cannot be deleted.");
				echo json_encode(array('success' => false));
            }
        }
    }
	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider = new CActiveDataProvider('ArtworkLogoArchive');
		$this->render('index', array(
			'dataProvider' => $dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new ArtworkLogoArchive('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['ArtworkLogoArchive']))
			$model->attributes = $_GET['ArtworkLogoArchive'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = ArtworkLogoArchive::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'artwork-logo-archive-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionDropZoneUpload()
	{
		if (!isset($_POST['referenceId']) || !is_int(intval($_POST['referenceId']))) {
			exit;
		}
		
		$reference_id = $_POST['referenceId'];


		$uploadedFile = CUploadedFile::getInstanceByName('file');
		$originalFileName = $uploadedFile->getName(); // original uploaded file name 
		$path_parts = pathinfo($originalFileName);

		$modify_file_name = $originalFileName;//$path_parts['filename'] . '_' . time() . '.' . $path_parts['extension'];

		if ($type == FileInventory::TYPE_WEBSTORE_BANNER) {
			if (!in_array($path_parts['extension'], array('jpg', 'png'))) {
				throw new Exception("Bad request! Invalid File Types", 400);
			}
		}

		$dirPath = "files/artwork/{$reference_id}";

		if (!file_exists($dirPath)) {
			mkdir($dirPath, 0777, true);
		}


		$fileWithPath = $dirPath . '/' . $modify_file_name;

		// save with orginal file name , remove tempory file
		if ($uploadedFile->saveAs($fileWithPath, true)) {	
			
			$artworkProof = new ArtworkLogoArchive();
			$artworkProof->job_artowk_id = $reference_id;
			$artworkProof->logoImage = $modify_file_name;
			$artworkProof->createdDate = date('Y-m-d');
			$artworkProof->save(false);

			SalesLog::createTblLog($reference_id, 'JobArtwork', "Artwork file [{$originalFileName}]  was saved.");
			echo json_encode(array('success' => true, 'fileName' => $modify_file_name));
		} else {
			SalesLog::createTblLog($reference_id, 'JobArtwork', "Artwork file [{$originalFileName}]  was not saved.");
			echo json_encode(array('success' => false));
		}
	}

	public function actionDropZoneDelete() {
        $fileName = html_entity_decode($_POST['fileName']);
        $referenceId = $_POST['referenceId'];
        $criteria = new CDbCriteria;
        $criteria->addCondition('job_artowk_id = :refID AND logoImage = :fileName');
        $criteria->params = array(':refID' => $referenceId, ':fileName' => $fileName);
        $artworkProof = ArtworkLogoArchive::model()->find($criteria);

        if (!$artworkProof) {
            throw new Exception("File not found!", 404);
        }

        $filePath = 'files/artwork/' . $referenceId . '/' . $artworkProof->logoImage;

        if (unlink($filePath)) {
            if ($artworkProof->delete()) {
				SalesLog::createTblLog($referenceId, 'JobArtwork', "Artwork file [{$fileName}]  was removed.");
                echo json_encode(array('success' => true));
            }
        } else {
            throw new Exception("Cannot delete the file", 409);
        }
    }

	public function actionDownloadFile() {
        $id = intval($_GET['id']);
        $model = $this->loadModel($id);



        $filePath = 'files/artwork/' . $model->job_artowk_id . '/' . $model->logoImage;

        if (!file_exists($filePath)) {
            exit();
        }

        Yii::app()->getRequest()->sendFile($model->logoImage, file_get_contents($filePath));
    }
}
