<?php

class ConsolidatedPurchaseOrderController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'consolidate'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $model = $this->loadModel($id);
        $dtlmodel = new ConsolidatedPoDetail();
        $dtlmodel->consolidated_po_id = $model->id;

        $this->render('view', array(
            'model' => $model,
            'dtlmodel' => $dtlmodel
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new ConsolidatedPurchaseOrder;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['ConsolidatedPurchaseOrder'])) {
            $model->attributes = $_POST['ConsolidatedPurchaseOrder'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['ConsolidatedPurchaseOrder'])) {
            $model->attributes = $_POST['ConsolidatedPurchaseOrder'];
            $model->due_date = date('Y-m-d', strtotime($model->due_date));
            if ($model->save()) {
                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $model->due_date = date('d-m-Y', strtotime($model->due_date));

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);
            
            $deleted = ConsolidatedPoDetail::model()->deleteAll(array('condition'=>"consolidated_po_id = $model->id"));
            if($deleted){
                $model->delete();
            }

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('ConsolidatedPurchaseOrder');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new ConsolidatedPurchaseOrder('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['ConsolidatedPurchaseOrder']))
            $model->attributes = $_GET['ConsolidatedPurchaseOrder'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = ConsolidatedPurchaseOrder::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'consolidated-purchase-order-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionConsolidate() {
        $poId = $_GET['po'];
        $conInId = isset($_GET['conin']) ? $_GET['conin'] : null;
        $newcon = isset($_GET['newcon']) ? $_GET['newcon'] : null;
        $childpo = PurchaseOrders::model()->findByPk($poId);
        $transaction = Yii::app()->db->beginTransaction();
        try {
            $masterpo = null;
            if ($conInId) {
                $masterpo = ConsolidatedPurchaseOrder::model()->findByPk($conInId);
                $statusId = Status::model()->findByAttributes(array('name' => 'OPEN'))->id;
                if ($masterpo->status_id != $statusId) {
                    $transaction->rollback();
                    Yii::app()->user->setFlash('error', 'Can not proceed! Master purchase order has been closed!');
                    $this->redirect(array('purchaseOrders/view', 'id' => $poId));
                }
            } else if($newcon){
                $masterpo = $this->openNewMasterPO($childpo->supplier_id, $childpo->poType);
            }else {
                $masterpo = $this->loadMasterPO($childpo->supplier_id, $childpo->poType);
            }

            if (!$masterpo) {
                $masterpo = $this->openNewMasterPO($childpo->supplier_id, $childpo->poType);
            }
            foreach ($childpo->rel_po_dtl() as $podtl) {
                $this->consolidatePODtl($masterpo, $podtl);
            }

            $transaction->commit();
            $this->redirect(array('view', 'id' => $masterpo->id));
        } catch (Exception $e) {
            $transaction->rollback();
            Yii::app()->user->setFlash('error', $e->getMessage());
            $this->redirect(array('purchaseOrders/view', 'id' => $poId));
        }
    }

    

    public function loadMasterPO($supplierID, $poType) {
        $statusId = Status::model()->findByAttributes(array('name' => 'OPEN'))->id;
        $masterpo = ConsolidatedPurchaseOrder::model()->find(array('condition' => "supplier_id = {$supplierID} and status_id = {$statusId} and po_type = '{$poType}'", 'order' => "id desc"));

        return $masterpo;
    }

    public function openNewMasterPO($supplierID, $poType) {
        $statusId = Status::model()->findByAttributes(array('name' => 'OPEN'))->id;
        $masterpo = new ConsolidatedPurchaseOrder();
        $masterpo->supplier_id = $supplierID;
        $masterpo->po_type = $poType;
        $masterpo->status_id = $statusId;
        $dueInDates = (int) GlobalVars::get(GlobalVars::DUE_IN_X_DAYS);
        $dueDate = strtotime("+{$dueInDates} day");
        $masterpo->due_date = date('Y-m-d', $dueDate);
        $masterpo->created_date = date('Y-m-d H:i:s');
        $masterpo->created_by = Yii::app()->user->id;
        if ($masterpo->save(false)) {
            $masterpo->po_number = GlobalVars::get(GlobalVars::MASTER_PO_PREFIX) . sprintf("%04d", $masterpo->id);
            $masterpo->save();

            $mporul = Yii::app()->createUrl('consolidatedPurchaseOrder/view', array("id" => $masterpo->id));
            $mpolink = CHtml::link($masterpo->po_number, $mporul, array('target' => '_blank'));
            SalesLog::createTblLog($masterpo->id, SalesLog::CATEGORY_MASTER_PURCHASE_ORDER, "Master purchase order {$mpolink} has been created.");
        }

        return $masterpo;
    }

    public function consolidatePODtl($masterpo, $podtl) {
        $mpodtl = ConsolidatedPoDetail::model()->find(array('condition' => "child_po_id = {$podtl->po_id} and child_po_dtl_id = {$podtl->id}"));
        if (!$mpodtl) {
            $mpodtl = new ConsolidatedPoDetail();
            $mpodtl->consolidated_po_id = $masterpo->id;
            $mpodtl->child_po_id = $podtl->po_id;
            $mpodtl->job_id = $podtl->rel_po()->job_id;
            $mpodtl->child_po_dtl_id = $podtl->id;
            $mpodtl->detail_added_by = Yii::app()->user->id;
            $mpodtl->details_added_date = date('Y-m-d H:i:s');
            if ($mpodtl->save(false)) {
                $flowtype = "";

                if ($masterpo->po_type == "Purchase Product") {
                    $flowtype = "Product";
                } else if ($masterpo->po_type == "Purchase Product-Decoration") {
                    $flowtype = "Product-Decoration";
                }
                $this->addJobActivityFlow($mpodtl, $flowtype);

                $mpourl = Yii::app()->createUrl('consolidatedPurchaseOrder/view', array("id" => $masterpo->id));
                $mpolink = CHtml::link($masterpo->po_number, $mpourl, array('target' => '_blank'));

                $pourl = Yii::app()->createUrl('purchaseOrders/view', array("id" => $podtl->po_id));
                $polink = CHtml::link($podtl->rel_po()->poNum, $pourl, array('target' => '_blank'));

                $workorderdtl = $podtl->workorderDtl;
                $sodtl_breif = $workorderdtl->getBreifDetail();
                $comment = "Details of purchase order [{$polink}][$sodtl_breif] have been added to the master purchase order [{$mpolink}]";
                SalesLog::createSalesLogWithFollowup($podtl->rel_po()->quote_id, $podtl->rel_po()->workorder_id, $podtl->rel_po()->quoteNum, SalesLog::CATEGORY_JOB, $comment, 1, 1, 1, $masterpo->due_date);
            }
        }
    }

    private function addJobActivityFlow($mpodtl, $type) {
        /*
         * flow job id and activity must be unique - vertual composite unique key
         */
        $activity = JobActivityFlow::ACTIVITY_MASTER_PO_CONSOLIDATED;
        $jobactivityflow = JobActivityFlow::model()->find(array('condition' => "flowjob_id = {$mpodtl->rel_po_detail()->flowjob_id} and activity = '{$activity}'"));

        if (!$jobactivityflow) {
            $jobactivityflow = new JobActivityFlow();
        }

        $jobactivityflow->job_id = $mpodtl->job_id;
        $jobactivityflow->wrkorder_id = $mpodtl->rel_po()->workorder_id;
        $jobactivityflow->wrkorderDtl_id = $mpodtl->rel_po_detail()->workorderDtl_id;
        $jobactivityflow->flowjob_id = $mpodtl->rel_po_detail()->flowjob_id;
        $jobactivityflow->type = $type; //All types - Product, Decoration ,Product Decoration                            
        $jobactivityflow->activity = $activity;
        return $jobactivityflow->save();
    }

    public function actionClosempo($id) {
        $model = $this->loadModel($id);
        $statusId = Status::model()->findByAttributes(array('name' => 'CLOSED'))->id;
        $model->status_id = $statusId;
        if ($model->save(false)) {
            $consolidatedjobs = ConsolidatedPoDetail::model()->findAll(array('condition' => "consolidated_po_id = {$model->id}", 'group' => "job_id"));
            foreach ($consolidatedjobs as $condtl) {
                $mpourl = Yii::app()->createUrl('consolidatedPurchaseOrder/view', array("id" => $model->id));
                $mpolink = CHtml::link($model->po_number, $mpourl, array('target' => '_blank'));

                $comment = "Master purchase [$mpolink] order has been closed";

                SalesLog::createSalesLogWithFollowup($condtl->rel_po()->quote_id, $condtl->rel_po()->workorder_id, $condtl->rel_po()->quoteNum, SalesLog::CATEGORY_JOB, $comment, 1, 1, 1, $model->due_date);
            }
            Yii::app()->user->setFlash('success', "Master purchase [$mpolink] order has been closed");
        } else {
            Yii::app()->user->setFlash('error', "Cannot close the master purchase order [$model->po_number]");
        }

        $this->redirect(array('admin'));
    }
    
    public function actionReOpenMPO($id) {
        $model = $this->loadModel($id);
        $statusId = Status::model()->findByAttributes(array('name' => 'OPEN'))->id;
        $model->status_id = $statusId;
        if ($model->save(false)) {
            $consolidatedjobs = ConsolidatedPoDetail::model()->findAll(array('condition' => "consolidated_po_id = {$model->id}", 'group' => "job_id"));
            foreach ($consolidatedjobs as $condtl) {
                $mpourl = Yii::app()->createUrl('consolidatedPurchaseOrder/view', array("id" => $model->id));
                $mpolink = CHtml::link($model->po_number, $mpourl, array('target' => '_blank'));

                $comment = "Master purchase [$mpolink] order has been reopened";

                SalesLog::createSalesLogWithFollowup($condtl->rel_po()->quote_id, $condtl->rel_po()->workorder_id, $condtl->rel_po()->quoteNum, SalesLog::CATEGORY_JOB, $comment, 1, 1, 1, $model->due_date);
            }
            Yii::app()->user->setFlash('success', "Master purchase [$mpolink] order has been reopened");
        } else {
            Yii::app()->user->setFlash('error', "Cannot reopen the master purchase order [$model->po_number]");
        }

        $this->redirect(array('admin'));
    }

    public function actionPrint($id) {


        $model = $this->loadModel($id);


        $show_price = isset($_GET['price_show']) ? filter_var($_GET['price_show'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_decoration = isset($_GET['deco_show']) ? filter_var($_GET['deco_show'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_custmizedtl = isset($_GET['cutmz_show']) ? filter_var($_GET['cutmz_show'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_notes = isset($_GET['notes_show']) ? filter_var($_GET['notes_show'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_job_info = isset($_GET['jinfo']) ? filter_var($_GET['jinfo'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_weborder_info = isset($_GET['webordinfo']) ? filter_var($_GET['webordinfo'], FILTER_VALIDATE_BOOLEAN) : 1;
        $logosetup_flag = isset($_GET['logosetup_flag']) ? filter_var($_GET['logosetup_flag'], FILTER_VALIDATE_BOOLEAN) : 1;

        //this method is developed on 2006-07-28 by eranga
        //for now this new PDF generated method has applied only for purchase product-decoration
        $htmlcontent = null;
        if (in_array($model->po_type, array('Purchase Product'))) {
            $htmlcontent = $this->renderInternal('protected/views/consolidatedPurchaseOrder/po_jprd_pdf_html.php', array('model' => $model, 'show_price' => $show_price, 'show_decoration' => $show_decoration,
                'show_job_info' => $show_job_info, 'show_custmizedtl' => $show_custmizedtl,
                'show_notes' => $show_notes, 'show_weborder_info' => $show_weborder_info), true);
        } else if (in_array($model->po_type, array('Purchase Product-Decoration'))) {
            $htmlcontent = $this->renderInternal('protected/views/consolidatedPurchaseOrder/po_prod_deco_pdf_html.php', array('model' => $model, 'show_price' => $show_price, 'show_decoration' => $show_decoration,
                'show_job_info' => $show_job_info, 'show_custmizedtl' => $show_custmizedtl,
                'show_notes' => $show_notes, 'show_weborder_info' => $show_weborder_info, 'logosetup_flag' => $logosetup_flag), true);
        }


        $mpdf = new MPDFGenerator();
        //$mpdfHeader = '<img src="images/gg-logo-header.jpg" style="border-bottom: 1px solid #000;"/>';
        $mpdf->createPDF($htmlcontent, array('type' => 'I', 'filename' => $model->po_number), array('header' => null, 'title' => $this->pageTitle . ' - Purchase Order'));
    }

    public function actionFetchTotal() {
        $id = $_POST['id'];
        $podecodtls = ConsolidatedPoDetail::model()->findAll(array('condition' => "consolidated_po_id = $id"));
        $total = 0;
        foreach ($podecodtls as $data) {
            $total += $data->rel_po_detail()->getJobProductDecoration()->decoQty * $data->rel_po_detail()->getJobProductDecoration()->decoCostPrice;
        }

        $total = number_format($total, 2);

        echo json_encode(array('total' => $total));
    }

}
