<?php

require 'vendor/autoload.php';

// Use this class to deserialize error caught
use XeroAPI\XeroPHP\AccountingObjectSerializer;

class CustomerController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'ajaxFiledUpdate', 'fetchCustomerData', 'searchCustomer', 'createViaAjax'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {



        $model = $this->loadModel($id);
        $jobmodel = new Jobs('search');
        $jobmodel->cus_fref = $model->cuscus_fref;

        //$jobmodel->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $jobmodel->attributes = $_GET['Jobs'];



        $quote = new Quatation('search');
        $quote->cus_fref = $model->cuscus_fref;

        //$quote->unsetAttributes();  // clear any default values
        if (isset($_GET['Quatation']))
            $quote->attributes = $_GET['Quatation'];


        $response = $model->json_response;

        $this->render('view', array(
            'model' => $model,
            'jobmodel' => $jobmodel,
            'quote' => $quote,
            'response' => $response
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new Customer;
        $model->invoiceDueInXDays = 0;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Customer'])) {
            $model->attributes = $_POST['Customer'];
            if ($model->save()) {
                $model->cuscus_fref = $model->cussno;
                $model->cuscus = 'C' . $model->cussno;
                $model->save();
                $this->redirect(array('view', 'id' => $model->cussno));
            }
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);
        if (empty($model->invoiceDueInXDays)) {
            $model->invoiceDueInXDays = 0;
        }

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Customer'])) {
            $model->attributes = $_POST['Customer'];
            $model->cusameddt = date('Y-m-d');
            $model->cusametime = date('H:i:s');
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->cussno));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            //$this->loadModel($id)->delete();
            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    public function actionAdvanceDelete() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {

            $id = $_POST['id'];
            $deleted = 0;
            $data = array();
            // we only allow deletion via POST request
            if (!UsageChecker::customerInUse($id)) {
                $customer = $this->loadModel($id);
                $customerName = $customer->cusnam;
                $deleted = $customer->delete() ? 1 : 0;
                $data['status'] = $deleted;
                Yii::app()->user->setFlash('success', "Customer [ $customerName ] has been deleted successfully!");
            } else {
                $data['status'] = 0;
            }
        } else {
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
        }

        echo json_encode($data);
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Customer');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {

        $model = new Customer('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Customer']))
            $model->attributes = $_GET['Customer'];

        if (isset($_POST['reset_btn'])) {
            unset(Yii::app()->session['customer_expt_qry']);
        }

        if (isset($_POST['customer-exprt-btn']) && isset(Yii::app()->session['customer_expt_qry'])) {
            $this->exportAsExcel();
        }


        if (isset($_POST['Customer'])) {
            $model->attributes = $_POST['Customer'];

            //if ($model->validate()) {
            if (isset($_POST['import_btn']) && isset($_POST['Customer']['importFile'])) {
                $model->importFile = CUploadedFile::getInstance($model, 'importFile');
                $originalFileName = $model->importFile->name;

                if ($model->importFile && $model->importFile->getExtensionName() == "xml") {
                    $filenametobesave = 'files/tmp/' . time() . '.' . $model->importFile->getExtensionName();
                    $model->importFile->saveAs($filenametobesave);
                    $this->importFile($filenametobesave);
                    Yii::app()->user->setFlash('success', "The XML file [" . basename($originalFileName) . "] has been uploaded successfully!");
                } elseif ($model->importFile && $model->importFile->getExtensionName() == "csv") {
                    $filenametobesave = 'files/tmp/' . time() . '.' . $model->importFile->getExtensionName();
                    $model->importFile->saveAs($filenametobesave);
                    $this->importCSVFile($filenametobesave);
                    Yii::app()->user->setFlash('success', "The CSV file [" . basename($originalFileName) . "] has been uploaded successfully!");
                } else {
                    Yii::app()->user->setFlash('notice', "File is empty or incorrect file extensions");
                }
            }
            //}
        }

        $this->render('admin', array(
            'model' => $model,
        ));
    }
    
    public function actionMerge() {


        $model = new Customer('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Customer']))
            $model->attributes = $_GET['Customer'];



        //submit merge into selected customers

        if (isset($_POST['Customer']) && isset($_POST['customer-grid_c0'])) {

            $model->attributes = $_POST['Customer'];
            $mergeIntoCusId = $_POST['mergeIntoCusId'];
            $customerIdArr = $_POST['customer-grid_c0'];

            if (!$mergeIntoCusId) {
                Yii::app()->user->setFlash('notice', "Please select a customer to merge into!");
            }
            //remove merge into id from the customer ID array
            $to_remove = array($mergeIntoCusId);
            $customerIdArr = array_diff($customerIdArr, $to_remove);

            if (count($customerIdArr) === 1) {
                Yii::app()->user->setFlash('notice', "Please select at least two customers to merge!");
            }
            $transaction = Yii::app()->db->beginTransaction();

            try {
                
                unset($customerIdArr[$mergeIntoCusId]);

                $merger = new CustomerMerger();
                $merger->setCustomerToBeMergered($customerIdArr)
                        ->setCustomerMergeInto($mergeIntoCusId)
                        ->validate();

                if (!$merger->validated()) {

                    $transaction->rollback();
                    Yii::app()->user->setFlash('notice', implode('<br>', $merger->errors()));
                }

                if ($merger->validated()) {

                    $merger->merge()
                            ->writeLog();

                    

                   $transaction->commit();
                   
                   $customer = Customer::model()->findByPk($mergeIntoCusId);
                   Yii::app()->user->setFlash('success', "Customers have been merged into the [{$customer->cussno}][{$customer->cusnam}]. For more info please check the CRM under the 'Other' category.");
                }
            } catch (Exception $ex) {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', $ex->getMessage());
            }
        }

        $this->render('merge', array(
            'model' => $model,
        ));
    }

    protected function importCSVFile($file) {
        $fileHandler = fopen($file, 'r');
        if ($fileHandler) {
            $count = 0;
            while ($line = fgetcsv($fileHandler, 1000)) {
                $count++;
                if ($count < 2) { /* bypass the 1st and 2nd rows of the csv file */
                    continue;
                }
                try {
                    $companyName = $line[0];
                    $emailAddress = $line[1];
                    $firstName = $line[2];
                    $lastName = $line[3];
                    $contactName = $firstName . ' ' . $lastName;

                    $POAddress1 = $line[4];
                    $POAddress2 = $line[5];
                    $POAddress3 = $line[6] . ' ' . $line[7];
                    $POCity = $line[8];
                    $POState = $line[9];
                    $POPostalCode = $line[10];
                    $POCountry = $line[11];

                    $SAAddress1 = $line[13];
                    $SAAddress2 = $line[14];
                    $SAAddress3 = $line[15] . ' ' . $line[16];
                    $SACity = $line[17];
                    $SAState = $line[18];
                    $SAPostalCode = $line[19];
                    $SACountry = $line[20];

                    $phoneNumber = $line[21];
                    $faxNumber = $line[22];
                    $mobileNumber = $line[23];
                    $websiteURL = $line[32];

                    if (!trim($companyName)) {
                        continue;
                    }


                    $criteria = new CDbCriteria;
                    $criteria->addCondition('cusnam=:cusnam');
                    $criteria->params = array(':cusnam' => $companyName);

                    $customer = Customer::model()->find($criteria);

                    if (!$customer) {
                        $customer = New Customer;
                    }
                    $customer->cusnam = $companyName;
                    $customer->cusadd1 = $POAddress1;
                    $customer->cusadd2 = $POAddress2;
                    $customer->cusadd3 = $POAddress3;
                    $customer->custown = $POCity;
                    $customer->cusstate = $POState;
                    $customer->cuspostcode = $POPostalCode;


                    if ($country = Countries::model()->find("countryname = '$POCountry'")) {
                        $customer->cuscousno = $country->id;
                    }

                    $customer->custel = $phoneNumber;
                    $customer->cusmobtel = $mobileNumber;
                    $customer->cusfax = $faxNumber;
                    $customer->cusemail = trim($emailAddress) ?: '-';
                    $customer->cuscontact = $contactName;

                    $customer->shipAddress1 = $SAAddress1;
                    $customer->shipAddress2 = $SAAddress2;
                    $customer->shipAddress3 = $SAAddress3;
                    $customer->shipSub = $SACity;
                    $customer->shipState = $SAState;
                    $customer->shipPostalCode = $SAPostalCode;
                    if ($country = Countries::model()->find("countryname = '$SACountry'")) {
                        $customer->shipCountryId = $country->id;
                    }

                    $customer->websiteUrl = $websiteURL;

                    $customer->cusentddt = date('Y-m-d');
                    $customer->cusenttime = date('H:i:s');

                    $customer->cusameddt = date('Y-m-d');
                    $customer->cusametime = date('H:i:s');

                    if ($customer->save(false)) {
                        $customer->cuscus = $customer->cussno;
                        $customer->cuscus_fref = $customer->cussno;
                        if ($customer->save(false)) {
                            $this->builMasterCustomerRelationByCustomer($customer);
                        }
                    }

                    continue;
                } catch (Exception $e) {
                    //Illegel Offset Exception
                }
            }
        }
    }

    protected function builMasterCustomerRelationByCustomer(Customer $customer) {
        $criteria = new CDbCriteria;
        $criteria->addCondition('mcusnam=:mcusnam');
        $criteria->params = array(':mcusnam' => $customer->cusnam);

        $masterCustomer = MasterCustomer::model()->find($criteria);

        if (!$masterCustomer) {
            $masterCustomer = New MasterCustomer;
        } else {
            $customer->cusmcussno = $masterCustomer->mcussno;
            $customer->save(false);
        }

        $masterCustomer->mcusnam = $customer->cusnam;
        $masterCustomer->mcussnam = $customer->cusnam;
        $masterCustomer->mcusadd1 = $customer->cusadd1;
        $masterCustomer->mcusadd2 = $customer->cusadd2;
        $masterCustomer->mcusadd3 = $customer->cusadd3;
        $masterCustomer->mcustown = $customer->custown;
        $masterCustomer->mcusstate = $customer->cusstate;
        $masterCustomer->mcuspostcode = $customer->cuspostcode;



        $masterCustomer->mcuscousno = $customer->cuscousno;


        $masterCustomer->mcustel = $customer->custel;
        $masterCustomer->mcustel2 = $customer->cusmobtel;
        $masterCustomer->mcusfax = $customer->cusfax;
        $masterCustomer->mcusemail = $customer->cusemail;
        $masterCustomer->mcuscontact = $customer->cuscontact;

        $masterCustomer->shipAddress1 = $customer->shipAddress1;
        $masterCustomer->shipAddress2 = $customer->shipAddress2;
        $masterCustomer->shipAddress3 = $customer->shipAddress3;
        $masterCustomer->shipSub = $customer->shipSub;
        $masterCustomer->shipState = $customer->shipState;
        $masterCustomer->shipPostalCode = $customer->shipPostalCode;

        $masterCustomer->shipCountryId = $customer->shipCountryId;


        $masterCustomer->websiteUrl = $customer->websiteUrl;

        $masterCustomer->mcusentddt = date('Y-m-d');
        $masterCustomer->mcusenttime = date('H:i:s');

        $masterCustomer->mcusameddt = date('Y-m-d');
        $masterCustomer->mcusametime = date('H:i:s');
        $masterCustomer->xeroContactID = $customer->xeroContactID;

        if ($masterCustomer->save(false)) {
            $masterCustomer->mcuscus = $masterCustomer->mcussno;
            $masterCustomer->mcuscus_fref = $masterCustomer->mcussno;
            $masterCustomer->save(false);
        }
    }

    protected function importFile($file) {
        $xmldata = simplexml_load_file($file) or die("Failed to load xml file");
        foreach ($xmldata as $key => $value) {

            $xmlmodel = Customer::model()->find("cuscus_fref = '{$value->ACCOUNTNO}'");
            if (!$xmlmodel) {
                $xmlmodel = new Customer;
            }


            $xmlmodel->cusnam = htmlspecialchars($value->COMPANY);
            $xmlmodel->cuscus_fref = htmlspecialchars($value->ACCOUNTNO);
            $xmlmodel->cusadd1 = htmlspecialchars($value->ADDRESS1);
            $xmlmodel->cusadd2 = htmlspecialchars($value->ADDRESS2);
            $xmlmodel->cusadd3 = htmlspecialchars($value->ADDRESS3);
            $xmlmodel->custown = htmlspecialchars($value->CITY);
            $xmlmodel->cusstate = htmlspecialchars($value->STATE);
            $xmlmodel->cuspostcode = htmlspecialchars($value->ZIP);
            $xmlmodel->cuspostcode = htmlspecialchars($value->ZIP);

            $xmlmodel->cusemail = htmlspecialchars($value->UACCEMAIL);
            $xmlmodel->cusmobtel = htmlspecialchars($value->PHONE1);

            $xmlmodel->cuscontact = htmlspecialchars($value->CONTACT);

            $xmlmodel->cuscontactemail = htmlspecialchars($value->EMAIL);


            $xmlmodel->shipAddress1 = htmlspecialchars($value->UMAILADD1);
            $xmlmodel->shipAddress2 = htmlspecialchars($value->UMAILADD2);
            $xmlmodel->shipAddress3 = htmlspecialchars($value->UMAILADD3);
            $xmlmodel->shipSub = htmlspecialchars($value->UMAILSUB);
            $xmlmodel->shipState = htmlspecialchars($value->UMAILSTATE);
            $xmlmodel->shipPostalCode = htmlspecialchars($value->UMAILPCODE);

            $xmlmodel->cusentddt = date('Y-m-d');
            $xmlmodel->cusenttime = date('H:i:s');
            $xmlmodel->cusameddt = date('Y-m-d');
            $xmlmodel->cusametime = date('H:i:s');

            $xmlmodel->save();
        }
    }

    protected function exportAsExcel() {
        if (isset(Yii::app()->session['customer_expt_qry'])) {
            $query = Yii::app()->session['customer_expt_qry'];
            $query .= ' order by cusnam ASC';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('customer/admin'));
        }

        $reportName = "Customer List";
        Yii::import('ext.phpexcel.XPHPExcel');
        $objPHPExcel = XPHPExcel::createPHPExcel();
        $objPHPExcel->getProperties()->setCreator(Yii::app()->name)
                ->setLastModifiedBy(Yii::app()->name)
                ->setTitle($reportName)
                ->setSubject($reportName)
                ->setDescription($reportName)
                ->setKeywords($reportName)
                ->setCategory($reportName);

//        $objPHPExcel->setActiveSheetIndex(0)
//                ->setCellValue('E3', Yii::app()->name)
//                ->setCellValue('E4', Yii::app()->name . " - " . $reportName)
//                ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

        $column = array();

        //if(Yii::app()->session['invr_imageFlag'] == 1)
        $column['A'] = 'Category';
        $column['B'] = 'Industry';
        $column['C'] = 'Name';
        $column['D'] = 'Master Customer';
        $column['E'] = 'Address';
        $column['F'] = 'Telephone';
        $column['G'] = 'Mobile';
        $column['H'] = 'Email';
        $column['I'] = 'Contact';





        foreach ($column as $key => $val) {
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '1', $val);
        }

        $sheet = $objPHPExcel->getActiveSheet();


        foreach ($column as $key => $val) {
            $sheet->getColumnDimension($key)->setAutoSize(true);
        }


//        $sheet->mergeCells("E3:F3");
//        $sheet->mergeCells("E4:F4");
//        $sheet->mergeCells("E5:F5");
//        $sheet->mergeCells("E6:F6");
//
//        $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
//        $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));
//
//        $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
//        $sheet->getStyle("A9:AF9")->applyFromArray(array("font" => array("bold" => true)));

        $row = 2;
        $count = 1;
        foreach ($rawData as $item) {

            $customer = $this->loadModel($item['cussno']);



            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $row, $customer->category->name)
                    ->setCellValue('B' . $row, $customer->industry->name)
                    ->setCellValue('C' . $row, $item['cusnam'])
                    ->setCellValue('D' . $row, $customer->master->mcusnam)
                    ->setCellValue('E' . $row, $customer->getFullAddress())
                    ->setCellValue('F' . $row, $item['custel'])
                    ->setCellValue('G' . $row, $item['cusmobtel'])
                    ->setCellValue('H' . $row, $item['cusemail'])
                    ->setCellValue('I' . $row, $item['cuscontact']);


            $row++;
            $count++;
        }

        // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="MPVS2_CustomerExportList_' . date('dmY') . '.xls"');
        header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        Yii::app()->end();
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Customer::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'customer-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionAjaxFiledUpdate() {

        $data = array();
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $compositeID = $_POST['id'];
            $idsplit = explode('_', $compositeID);
            $tableKey = $idsplit[1];
            $field = $_POST['field'];
            $value = $_POST['value'];


            if (!empty($field) && !empty($tableKey) && !empty($value)) {
                $affectedrows = Yii::app()->db
                        ->createCommand("UPDATE customer SET {$field} = '{$value}' WHERE cussno = '{$tableKey}' LIMIT 1")
                        ->execute();

                $data['success'] = $affectedrows > 0 ? true : false;
            } else {
                $data['success'] = false;
            }
        } else {
            $data['success'] = false;
        }

        echo json_encode($data);
    }

    public function actionFetchCustomerData() {
        if (isset($_POST['cussno'])) {
            $id = $_POST['cussno'];
            $model = $this->loadModel($id);
        } else if (isset($_POST['cuscus_fref'])) {
            $cuscus_fref = $_POST['cuscus_fref'];
            $model = Customer::model()->find(array('condition' => "cuscus_fref = '{$cuscus_fref}'"));
        }

        $arr = array();
        $arr['add1'] = $model->cusadd1;
        $arr['add2'] = $model->cusadd2;
        $arr['add3'] = $model->cusadd3;
        $arr['town'] = $model->custown;
        $arr['state'] = $model->cusstate;
        $arr['postcode'] = $model->cuspostcode;
        $arr['tel'] = $model->custel;
        $arr['fax'] = $model->cusfax;
        $arr['email'] = $model->cusemail;
        $arr['discount'] = number_format($model->cusdispcn, 2);
        $arr['contact'] = $model->cuscontact;
        $arr['status_id'] = $model->status_id;
        echo json_encode($arr);
    }

    public function actionSearchCustomer() {

        $arr = array();
        $model = $this->loadModel($_POST['cussno']);

        $salesPerson = $model->master ? $model->master->salesPerson : null;

        $arr['cussno'] = $model->cussno;
        $arr['cuscus_fref'] = $model->cuscus_fref;
        $arr['cusnam'] = $model->cusnam;
        $arr['status_id'] = $model->status_id;
        $arr['salesPersonId'] = ($salesPerson ? $salesPerson->id : null);

        echo json_encode($arr);
    }

    public function actionCreateViaAjax() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $model = new Customer();
            $model->attributes = $_POST['Customer'];
            $model->cuscus_fref = time();
            if ($model->save()) {
                $model->cuscus_fref = $model->cussno;
                $model->cuscus = 'C' . $model->cussno;
                if ($model->save()) {
                    echo json_encode(array('success' => 'true', 'message' => '', 'customerId' => $model->cussno));
            }
            } else {
                echo json_encode(array('success' => 'false', 'message' => CHtml::errorSummary($model)));
        }
    }
    }

    public function actionUploadMyob($id) {
        if (myob_api_oauth::hasAccess()) {
            $model = $this->loadModel($id);
            $json = $model->getMYOBJson();

            if (!empty($model->myob_uuid) && !empty($model->myob_row_version)) {
                //then update
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/';
                $response = myob_api_oauth::putDetails($url, $json);
            } else {
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=DisplayID+eq+\'' . $model->cuscus . '\'';
                $response = myob_api_oauth::getDetails($url);

                $decoderes = json_decode($response, true);


                if (isset($decoderes["Items"])) {
                    $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'DisplayID', $model->cuscus);
                    $model->myob_uuid = $myob_res_fields['UID'];
                    $model->myob_row_version = $myob_res_fields['RowVersion'];
                    $model->save(false);
                    $json = $model->getMYOBJson();

                    if (!empty($model->myob_uuid) && !empty($model->myob_row_version)) {
                        //if so, then update the existing record

                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/';
                        $response = myob_api_oauth::putDetails($url, $json);
                    } else {
                        //insert new
                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/';
                        $response = myob_api_oauth::postDetails($url, $json);
                    }
                }
            }


            $decoderes = json_decode($response, true);


            if (isset($decoderes["Errors"]) || isset($decoderes["Message"])) {
                $model->json_response = $response;
                $model->save(false);
                Yii::app()->user->setFlash('notice', "Cannot upload the customer to MYOB!");
            } else {
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=DisplayID+eq+\'' . $model->cuscus . '\'';
                $response = myob_api_oauth::getDetails($url);

                $model->json_response = '';
                $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'DisplayID', $model->cuscus);
                $model->myob_uuid = $myob_res_fields['UID'];
                $model->myob_row_version = $myob_res_fields['RowVersion'];
                $model->save(false);
                Yii::app()->user->setFlash('success', "The customer has been uploaded to MYOB!");
            }




            Yii::app()->session['myob_cus'] = $id;

            $this->redirect(array('view', 'id' => $id));
        } else {
            //not connected to myob or session expired
            Yii::app()->user->setFlash('notice', "MYOB session has been expired! Please connect to MYOB first!");
            $this->redirect(array('view', 'id' => $id));
        }
    }

    public function actionTypeHeadCustomerList() {
        $term = Yii::app()->request->getQuery('term');
        $q = new CDbCriteria();
        $q->addSearchCondition('cusnam', $term);
        $customers = Customer::model()->findAll($q);
        $lists = array();
        foreach ($customers as $customer) {
            $salesPerson = $customer->master ? $customer->master->salesPerson : null;
            $lists[] = array(
                'id' => $customer->cussno,
                'name' => $customer->cusnam,
                'code' => $customer->cuscus_fref,
                'salesPersonId' => ($salesPerson ? $salesPerson->id : null)
            );
        }
        echo json_encode($lists);
    }

    public function actionSyncXero() {

        $storage = new StorageClass();
        if ($storage->getHasExpired()) {
            $this->redirect(array('xeroSetting/settings'));
        }



// Storage Classe uses sessions for storing token > extend to your DB of choice
        $storage = new StorageClass();
        $xeroTenantId = (string) $storage->getSession()['tenant_id'];

        if ($storage->getHasExpired()) {
            $provider = new \League\OAuth2\Client\Provider\GenericProvider(XeroSetting::getGenericProviderOptions());

            $newAccessToken = $provider->getAccessToken('refresh_token', [
                'refresh_token' => $storage->getRefreshToken()
            ]);

            // Save my token, expiration and refresh token
            $storage->setToken(
                    $newAccessToken->getToken(), $newAccessToken->getExpires(), $xeroTenantId, $newAccessToken->getRefreshToken(), $newAccessToken->getValues()["id_token"]);
        }

        $config = XeroAPI\XeroPHP\Configuration::getDefaultConfiguration()->setAccessToken((string) $storage->getSession()['token']);
        $config->setHost("https://api.xero.com/api.xro/2.0");

        $apiInstance = new XeroAPI\XeroPHP\Api\AccountingApi(
                new GuzzleHttp\Client(), $config
        );

        try {
            //Fetching contacts
            $this->xeroContactRecursive($apiInstance, $xeroTenantId);
        } catch (\XeroAPI\XeroPHP\ApiException $e) {
            $error = AccountingObjectSerializer::deserialize(
                            $e->getResponseBody(), '\XeroAPI\XeroPHP\Models\Accounting\Error', []
            );
            $message = "ApiException - " . $error->getElements()[0]["validation_errors"][0]["message"];
            //print_r($error->getElements()[0]["validation_errors"]);
            //$this->redirect(array('invoice/view','id'=>$model->id, 'xrerr'=>$message));
        }

        $this->redirect(array('admin'));
    }

    /**
     * @return \XeroAPI\XeroPHP\Models\Accounting\Contacts
     */
    public $pageCount = 1;

    private function xeroContactRecursive(XeroAPI\XeroPHP\Api\AccountingApi $apiInstance, $xeroTenantId) {
        $xeroContacts = $apiInstance->getContacts($xeroTenantId, null, 'IsCustomer=true', null, null, $this->pageCount, null);

        if ($contacts = $xeroContacts->getContacts()) {
            foreach ($contacts as $contact) {

                $criteria = new CDbCriteria;
                if ($contact->getContactId()) {
                    $criteria->addCondition("xeroContactID = '{$contact->getContactId()}' ");
                }

                $customer = Customer::model()->find($criteria);
                if (!$customer) {
                    $criteria = new CDbCriteria;
                    $criteria->addCondition("LOWER(cusnam) = :name");
                    $criteria->params = array(':name' => strtolower($contact->getName()));
                    $customer = Customer::model()->find($criteria);
                }
                if (!$customer) {
                    $customer = new Customer();
                }
                $customer->cusnam = $contact->getName();
                foreach ($contact->getAddresses() as $address) {
                    if ($address->getAddressType() == 'POBOX') {
                        $customer->cusadd1 = $address->getAddressLine1();
                        $customer->cusadd2 = $address->getAddressLine2();
                        $customer->cusadd3 = $address->getAddressLine3() . ' ' . $address->getAddressLine4();
                        $customer->custown = $address->getCity();
                        $customer->cusstate = $address->getRegion();
                        $customer->cuspostcode = $address->getPostalCode();
                    } else if ($address->getAddressType() == 'DELIVERY') {

                        $customer->shipAddress1 = $address->getAddressLine1();
                        $customer->shipAddress2 = $address->getAddressLine2();
                        $customer->shipAddress3 = $address->getAddressLine3() . ' ' . $address->getAddressLine4();
                        $customer->shipSub = $address->getCity();
                        $customer->shipState = $address->getRegion();
                        $customer->shipPostalCode = $address->getPostalCode();
                    }
                }

                foreach ($contact->getPhones() as $phone) {
                    if ($phone->getPhoneType() == 'DEFAULT') {
                        $customer->custel = $phone->getPhoneNumber();
                    } else if ($phone->getPhoneType() == 'MOBILE') {
                        $customer->cusmobtel = $phone->getPhoneNumber();
                    } else if ($phone->getPhoneType() == 'FAX') {
                        $customer->cusfax = $phone->getPhoneNumber();
                    }
                }



                $customer->cusemail = $contact->getEmailAddress();
                $customer->cuscontact = $contact->getFirstName() . ' ' . $contact->getLastName();
                $customer->xeroContactID = $contact->getContactId();

                if ($customer->save(false)) {
                    $customer->cuscus_fref = $customer->cussno;
                    $customer->cuscus = $customer->cussno;
                    $customer->save(false);
                    $this->builMasterCustomerRelationByCustomer($customer);
                }
            }
            $this->pageCount++;
            $this->xeroContactRecursive($apiInstance, $xeroTenantId);
        } else {
            return null;
        }
    }

    public function actionMYOBSyncronizeAll() {
        $auth = new MYOBAuth(MyobSetting::getSettings());
        if ($auth->checkAccess()) {

            $myobApiConnector = new MYOBApiConnector($auth);
            $myobApiConnector->setURLEndPoint('Contact/Customer/');

            /* create syncronizer object which has the syncronizing logics */
            $synchronizer = new MYOBSynchronizer($myobApiConnector, null);
            $synchronizer->setMYOBReferenceFinder(new MYOBCustomerReferenceFinder());
            /* just pull the records from MYOB and and update or insert into local DB */
            $synchronizer->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PULL);

            $synchronizer->syncronizeAll('Customer', $myobApiConnector->requestedURLGet());
        } else {
            throw new Exception('MYOB access denied!', 401);
        }

        //$this->redirect(array('view', 'id' => $id));
    }

    public function actionMYOBSyncronize() {
        $auth = new MYOBAuth(MyobSetting::getSettings());
        if ($auth->checkAccess()) {
            $id = (int) $_POST['id'];
            $model = $this->loadModel($id);

            $myobApiConnector = new MYOBApiConnector($auth);

            /* create syncronizer object which has the syncronizing logics */
            $synchronizer = new MYOBSynchronizer($myobApiConnector, $model);
            $synchronizer->setMYOBReferenceFinder(new MYOBCustomerReferenceFinder());
            $model->setSynchronizer($synchronizer);

            /* do syncorize */
            if ($model->myobSynchronize($myobApiConnector)) {
                echo json_encode(array('success' => true));
            } else {
                echo json_encode(array('success' => false));
            }
        }

        //$this->redirect(array('view', 'id' => $id));
    }

    public function actionRefreshFTP() {
        $this->render('ftp');
    }

    public function actionStatusReport() {

        $model = new Customer('searchStatus');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Customer']))
            $model->attributes = $_GET['Customer'];

        if (isset($_POST['reset_btn'])) {
            unset(Yii::app()->session['cus_sts_selcted']);
            unset(Yii::app()->session['cus_sts_datefrom']);
            unset(Yii::app()->session['cus_sts_dateto']);
            unset(Yii::app()->session['cus_urg_sts']);
        }

        if (isset($_POST['Customer']) && isset($_POST['Customer']['followupStatus']) && isset($_POST['go_btn'])) {
            $postStatusesArr = $_POST['Customer']['followupStatus'];
            Yii::app()->session['cus_sts_selcted'] = implode(',', $postStatusesArr);
        }

        if (isset($_POST['Customer']['datefrom']) && !empty($_POST['Customer']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['cus_sts_datefrom'] = date('Y-m-d', strtotime($_POST['Customer']['datefrom']));
        }

        if (isset(Yii::app()->session['cus_sts_datefrom'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['cus_sts_datefrom']));
        }

        if (isset($_POST['Customer']['dateto']) && !empty($_POST['Customer']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['cus_sts_dateto'] = date('Y-m-d', strtotime($_POST['Customer']['dateto']));
        }

        if (isset(Yii::app()->session['cus_sts_dateto'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['cus_sts_dateto']));
        }


        $this->render('status_report', array(
            'model' => $model,
        ));
    }

    public function actionGenerateStatusReportExcel() {
        if (isset(Yii::app()->session['customer_status_report_qry'])) {
            $query = Yii::app()->session['customer_status_report_qry'];
            $query .= ' ORDER By cusnam';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('statusReport'));
        }

        $reportName = "Customer Status Report";
        Yii::import('ext.phpexcel.XPHPExcel');
        $objPHPExcel = XPHPExcel::createPHPExcel();
        $objPHPExcel->getProperties()->setCreator(Yii::app()->name)
                ->setLastModifiedBy(Yii::app()->name)
                ->setTitle($reportName)
                ->setSubject($reportName)
                ->setDescription($reportName)
                ->setKeywords($reportName)
                ->setCategory($reportName);

        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('E3', Yii::app()->name)
                ->setCellValue('E4', Yii::app()->name . " - " . $reportName)
                ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

        $column = array();

        //if(Yii::app()->session['invr_imageFlag'] == 1)
        $column['A'] = 'No';
        $column['B'] = 'Category';
        $column['C'] = 'Industry';
        $column['D'] = 'Customer';
        $column['E'] = 'Master Customer';
        $column['F'] = 'Address';
        $column['G'] = 'Telephone';
        $column['H'] = 'Mobile';
        $column['I'] = 'Email';
        $column['J'] = 'Contact';
        $column['K'] = 'Follow-up Status';
        $column['L'] = 'Follow-up Date';

        foreach ($column as $key => $val) {
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '9', $val);
        }

        $sheet = $objPHPExcel->getActiveSheet();


        foreach ($column as $key => $val) {
            $sheet->getColumnDimension($key)->setAutoSize(true);
        }

        $sheet->mergeCells("E3:F3");
        $sheet->mergeCells("E4:F4");
        $sheet->mergeCells("E5:F5");
        $sheet->mergeCells("E6:F6");

        $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
        $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));

        $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
        $sheet->getStyle("A9:K9")->applyFromArray(array("font" => array("bold" => true)));

        $row = 11;
        $count = 1;
        foreach ($rawData as $item) {
            $customer = Customer::model()->findByPk($item['cussno']);
            $category = CustomerCategory::model()->findByPk($item['categoryId']);
            $industry = CustomerIndustry::model()->findByPk($item['industryId']);
            $masterCustomer = $item['cusmcussno'] ? MasterCustomer::model()->find("mcussno = " . $item['cusmcussno']) : null;
            $followupLog = $customer->getFollowupLog();
            $followupStatus = FollowupStatus::model()->findByPk($followupLog->followupSts_id);


            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $row, $count)
                    ->setCellValue('B' . $row, ($category ? $category->name : ''))
                    ->setCellValue('C' . $row, ($industry ? $industry->name : ''))
                    ->setCellValue('D' . $row, $item['cusnam'])
                    ->setCellValue('E' . $row, ($masterCustomer ? $masterCustomer->mcusnam : ''))
                    ->setCellValue('F' . $row, $customer->getFullAddress())
                    ->setCellValue('G' . $row, $item['custel'])
                    ->setCellValue('H' . $row, $item['cusmobtel'])
                    ->setCellValue('I' . $row, $item['cusemail'])
                    ->setCellValue('J' . $row, $item['cuscontact'])
                    ->setCellValue('K' . $row, ($followupStatus ? $followupStatus->status : ''))
                    ->setCellValue('L' . $row, ($followupLog ? date('Y-m-d', strtotime($followupLog->createdDtm)) : ''));


            $row++;
            $count++;
        }

        // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="CustomerStatusReport' . time() . '.xls"');
        header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        Yii::app()->end();
    }

    public function actionGenerateStatusPDF() {
        if (isset(Yii::app()->session['customer_status_report_qry'])) {
            $query = Yii::app()->session['customer_status_report_qry'];
            $query .= ' ORDER By cusnam';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('statusReport'));

            $htmlcontent = $this->renderInternal('protected/views/customer/status_report_pdf.php', array('rawData' => $rawData), true);

            $pdfCreator = new PlainPDFCreator(array(
                'title' => 'Customer -  Status Report',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => 'CustomertatusReport' . time() . '.pdf'
            ));

            $pdfCreator->generate();
        }
    }

}
