<?php

class DecorationController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
			'rights',
			//'accessControl', // perform access control for CRUD operations
		);
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'filterDecorations', 'createAjax', 'loadDecoCodes',
                    'loadDecoDesc','searchDecoration','createViaAjax','createMianType','adminMain','updateMain'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new Decoration;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Decoration'])) {
            $model->attributes = $_POST['Decoration'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->decsno));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }
    
    public function actionCreateMianType() {
        $model = new Decoration;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Decoration'])) {
            $model->attributes = $_POST['Decoration'];
            $model->deccustomyn = 'N';
            $model->decmaintypsno = 0;
            $model->decis_main_type = 'Y';
            $model->decis_shown_to_clients = 1;
            $model->decflag = 1;
            $model->decsupsno = 0;
            
            if ($model->save())
                $this->redirect(array('adminmain', 'id' => $model->decsno));
        }

        $this->render('createmain', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Decoration'])) {
            $model->attributes = $_POST['Decoration'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->decsno));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }
    
    public function actionUpdateMain($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Decoration'])) {
            $model->attributes = $_POST['Decoration'];
            if ($model->save())
                $this->redirect(array('adminmain', 'id' => $model->decsno));
        }

        $this->render('updatemain', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Decoration');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new Decoration('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Decoration']))
            $model->attributes = $_GET['Decoration'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }
    
    public function actionAdminMain() {
        $model = new Decoration('searchmian');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Decoration']))
            $model->attributes = $_GET['Decoration'];

        $this->render('adminmain', array(
            'model' => $model,
        ));
    }

    public function actionSearchDecoration() {

        $arr = array();
        $qty = $_POST['qty'];
        
        if(empty($qty) || $qty < 0){
            $qty = 1;
        }
        $decsno = $_POST['decsno'];
        $model = $this->loadModel($decsno);

        $arr['decsno'] = $model->decsno;
        $arr['decprtnam'] = $model->decprtnam;
        $arr['decnam'] = $model->decnam;
        
        
        
        $suppliermargin = $model->supplier?$model->supplier->supmrate:0; 
        $arr['decsupmarg'] = $suppliermargin?:floatval(GlobalVars::get("SupplierMarkUp"));
        
        $arr['decuntprice'] = $model->decuntprice;
        if (!empty($decsno)) {
            $decoPriceModel = DecorationPrice::model()->find(array('condition' => "dcpdecsno = '{$decsno}' and (dcpquantity <= $qty and dcpsquantity >= $qty)", 'order' => 'dcpquantity_break_level'));
            if ($decoPriceModel && $decoPriceModel->dcpprice) {
                $arr['decuntprice'] = $decoPriceModel->dcpprice;
            }
        }
        
        $arr['declogosetup'] =  $model->declogo_setup_charges;
        $arr['logoSetupUnitMarkupRate'] = $model->logoSetupUnitMarkupRate;

        echo json_encode($arr);
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Decoration::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    public function loadModelByCode($decocode) {
        $model = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $decocode)));
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'decoration-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionFilterDecorations() {

        $arr = array();
        $model = $this->loadModelByCode($_POST['decprtnam']);
        $arr['decorateDesc'] = $model->decnam;
        $arr['decprtnam'] = $model->decprtnam;


        echo json_encode($arr);
    }

    public function actionCreateAjax() {


        if (Yii::app()->request->isPostRequest) {
            $model = new Decoration;
            if (isset($_POST['Decoration'])) {

                $decoration = Decoration::model()->find(array('condition' => "decprtnam = '{$model->decprtnam}' and decnam = '{$model->decnam}'"));

                if (empty($decoration)) {
                    $model = new Decoration();
                    $model->attributes = $_POST['Decoration'];
                    $model->save(false);
                }
            }
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    public function actionLoadDecoCodes() {
        $data = Decoration::model()->findAll(array('condition' => "decprtnam <> decnam and decprtnam <> 'N/A' ", 'order' => 'decprtnam asc'));

        $data = CHtml::listData($data, 'decprtnam', 'decprtnam');
        echo CHtml::tag('option', array('value' => ''), CHtml::encode(''), true);
        foreach ($data as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
    }

    public function actionLoadDecoDesc() {
        $data = Decoration::model()->findAll(array('condition' => "decprtnam <> decnam and decprtnam <> 'N/A' ", 'order' => 'decnam asc'));

        $data = CHtml::listData($data, 'decprtnam', 'decnam');
        echo CHtml::tag('option', array('value' => ''), CHtml::encode(''), true);
        foreach ($data as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
    }
    
     public function actionCreateViaAjax(){
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $model = new Decoration();
            $model->attributes = $_POST['Decoration'];
            if($model->save()){
                echo $model->decsno;
            }
        }
     }

}
