<?php

class DecorationPriceController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'priceInQtyRange', 'createQtyBreak'
                    , 'saveQtyBreakFrom', 'saveQtyBreakTo', 'saveQtyBreakPrice', 'ajaxDelete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new DecorationPrice;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['DecorationPrice'])) {
            $model->attributes = $_POST['DecorationPrice'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->dcpsno));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['DecorationPrice'])) {
            $model->attributes = $_POST['DecorationPrice'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->dcpsno));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('DecorationPrice');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new DecorationPrice('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['DecorationPrice']))
            $model->attributes = $_GET['DecorationPrice'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    public function actionPriceQtyTableHTML() {
        $tblID = $_POST['tableID'];
        $existCostPrice = $_POST['existCostPrice'];
        
       if(isset($_POST['workorderdtlID'])){
            $workorderDtlID = $_POST['workorderdtlID'];
            $workorderdtlmodel = Workorderdetails::model()->findByPk($workorderDtlID);
            $decoration = $workorderdtlmodel->decoRel;
        }
        
        if(isset($_POST['quoteDtlID'])){
            $quoteDtlID = $_POST['quoteDtlID'];
            $quoteDtlmodel = QuoteProductDecoration::model()->find(array('condition'=>"quataiondetailsid = $quoteDtlID"));
            if(!empty($quoteDtlmodel)){
                $decoration = $quoteDtlmodel->decoRel;
            }
            
        }
        
        if(isset($_POST['itemID'])){
            $decsno = $_POST['itemID'];
            $decoration = Decoration::model()->findByPk($decsno);
        }
        
        
        if (!isset($_POST['itemID']) && isset($decoration) && !empty($decoration)) {
            $qtybreaks = DecorationPrice::model()->findAll(array('condition' => "dcpdecsno = '{$decoration->decsno}'", 'order' => "dcpquantity ASC"));
            echo $this->renderPartial('priceQtyTableHTML', array('qtybreaks' => $qtybreaks, 'tblID' => $tblID, 'existCostPrice'=>$existCostPrice), false, true);
        }else if (isset($_POST['itemID']) && isset($decoration) && !empty($decoration)) {
            $qtybreaks = DecorationPrice::model()->findAll(array('condition' => "dcpdecsno = '{$decoration->decsno}'", 'order' => "dcpquantity ASC"));
            echo $this->renderPartial('quoteNewpriceQtyTableHTML', array('qtybreaks' => $qtybreaks, 'tblID' => $tblID, 'existCostPrice'=>$existCostPrice), false, true);
        }else{
             echo '<div>No qty breaks details to show!</div>';
        }
    }

    public function actionAddPriceQtyTableHTML() {
        $decsno = $_POST['id'];
        $tblID = $_POST['tableID'];
        $qty = $_POST['qty'];

        $decoration = Decoration::model()->findByPk($decsno);
        if (!empty($decoration)) {
            $qtybreaks = DecorationPrice::model()->findAll(array('condition' => "dcpdecsno = '{$decoration->decsno}'", 'order' => "dcpquantity ASC"));
            echo $this->renderPartial('addPriceQtyTableHTML', array('qtybreaks' => $qtybreaks, 'tblID' => $tblID, 'qty' => $qty), false, true);
        } else {
            echo '<div>No qty breaks details to show!</div>';
        }
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = DecorationPrice::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'decoration-price-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionPriceInQtyRange() {
        $pricearr = array();
        $price = 0;
        if (isset($_POST)) {
            $decocode = $_POST['decprtnam'];
            $qty = $_POST['qty'];

            $decoration = Decoration::model()->find(array('condition' => "decprtnam = '{$decocode}'"));
            $decoprices = DecorationPrice::model()->findAll(array('condition' => "dcpdecsno = '{$decoration->decsno}'"));

            foreach ($decoprices as $decoprice) {
                if ($qty >= $decoprice->dcpquantity && $qty <= $decoprice->dcpsquantity) {
                    $price = $decoprice->dcpprice;
                    break;
                }
            }
            $pricearr['decoprice'] = $price;
        }

        echo json_encode($pricearr);
    }

    public function actionCreateQtyBreak() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['decsno'])) {
                $decsno = $_POST['decsno'];



                $lastdecoprice = DecorationPrice::model()->find(array('condition' => "dcpdecsno = '{$decsno}'", 'order' => 'dcpquantity_break_level DESC'));

                $quntitybreaklevel = 0;

                if (!empty($lastdecoprice)) {
                    $quntitybreaklevel = $lastdecoprice->dcpquantity_break_level + 1;
                } else {
                    $quntitybreaklevel = 1;
                }

                $decoprice = new DecorationPrice();
                $decoprice->dcpdecsno = $decsno;
                $decoprice->dcpquantity_break_level = $quntitybreaklevel;
                $decoprice->dcpucdnew = Yii::app()->user->username;
                $decoprice->dcpentddt = date('Y-m-d');
                $decoprice->dcpenttime = date('H:i:s a');


                $resultArr = array();
                if ($decoprice->save(false)) {
                    $resultArr['rowid'] = $decoprice->dcpsno;
                    echo json_encode($resultArr);
                } else {
                    throw new Exception;
                }
            }
        }
    }

    public function actionSaveQtyBreakFrom() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['dcpsno'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['dcpsno']);
                if (!empty($model)) {
                    $model->dcpquantity = $_POST['value'];

                    if ($model->save(false)) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionSaveQtyBreakTo() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['dcpsno'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['dcpsno']);
                if (!empty($model)) {
                    $model->dcpsquantity = $_POST['value'];

                    if ($model->save(false)) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionSaveQtyBreakPrice() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['dcpsno'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['dcpsno']);
                if (!empty($model)) {
                    $model->dcpprice = $_POST['value'];

                    if ($model->save(false)) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionAjaxDelete() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['dcpsno'])) {
                $pdpsno = $_POST['dcpsno'];
                $price = $this->loadModel($pdpsno);

                $price->delete();
            }
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

}
