<?php

class DeliveryDocketDetailsController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'updateFullQty', 'ajaxDelete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new DeliveryDocketDetails;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['DeliveryDocketDetails'])) {
            $model->attributes = $_POST['DeliveryDocketDetails'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['DeliveryDocketDetails'])) {
            $model->attributes = $_POST['DeliveryDocketDetails'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else {
            $this->loadModel($id)->delete();
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('DeliveryDocketDetails');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new DeliveryDocketDetails('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['DeliveryDocketDetails']))
            $model->attributes = $_GET['DeliveryDocketDetails'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = DeliveryDocketDetails::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'delivery-docket-details-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionUpdateFullQty() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (!isset($_POST['id'], $_POST['value'])) {
                throw new Exception("Bad request!", 400);
            }

            $modelId = intval($_POST['id']);
            $tryingQuantity = intval($_POST['value']);


            if ($model = $this->loadModel($modelId)) {
                $itemDOQtySql = "SELECT SUM(qty) itemDOQty FROM delivery_docket_details WHERE wrkorderDtlId = {$model->wrkorderDtlId}";
                $result = Yii::app()->db->createCommand($itemDOQtySql)->queryRow();
                
                $maxItemQty = $model->workorderdtl->prodQty;
                $itemDOQty = $result['itemDOQty'];
                $thisItemQty = $model->qty;
                
                $otherItemQty = $itemDOQty -  $thisItemQty;
                $allowedItemQty = $maxItemQty - abs($otherItemQty);
                
               
                
                if ($allowedItemQty < $tryingQuantity) {
                    echo json_encode(array('status' => false, 'status_code' => 304, 'error' => 'Quantity exceed!'));
                    exit();
                }

                if ($tryingQuantity === 0) {
                    echo json_encode(array('status' => false, 'error' => 'Zero quantity!'));
                    exit();
                }

                $model->qty = $tryingQuantity;
                if ($model->save(false)) {
                    echo json_encode(array('status' => true, '$allowedItemQty'=>$allowedItemQty));
                } else {
                    echo json_encode(array('status' => false, 'error' => 'Cannot save!'));
                }
            }
        }
    }

    /**
     * Delete item from a delivery docket
     * only allow to delete an item if there are more than one item in the docket otherwise user need to delete the complete DO to drop the last item
     * 
     * @return array json array
     */
    public function actionAjaxDelete() {

        if (Yii::app()->request->isPostRequest) {
            
           
            $model = $this->loadModel($_POST['id']);
            
            $allItems = DeliveryDocketDetails::model()->findAll("deliveryDocketId = {$model->deliveryDocketId}");
            
            if(count($allItems) <= 1){
                echo json_encode(array('success' => false, 'error' => 'Cannot delete last item, instead try to delete the delivery docket!'));
                exit();
            }
            $deleted = true;
            $transaction = Yii::app()->db->beginTransaction();

            $ddlabels = DeliveryDocketLabel::model()->findAll("delivery_docket_dtl_id = '$model->id'");
            if (!empty($ddlabels) && count($ddlabels) > 0) {
                $deleted = DeliveryDocketLabel::model()->deleteAll("delivery_docket_dtl_id = '$model->id'");
            }


            $itemdetail = '';
            if (!empty($model->workorderdtl->prdsrtdesc)) {
                $itemdetail .= $model->workorderdtl->productsku . '<br>' . trim($model->workorderdtl->prdsrtdesc);
            } else {
                $itemdetail .= $model->workorderdtl->custmproduct;
            }

            $itemdetail .= " Qty x " . $model->qty;
            SalesLog::createSalesLog($model->workorderdtl->workorder->quotationId, $model->workorderdtl->workorder->id, $model->workorderdtl->workorder->quotationNumber, 'Job', "Delivery Docket Details  ({$itemdetail}) for Delivery Docket {$model->deliverydocket->diliveryDocketNum} is deleted", 1, 0, 1);
            SalesLog::createSalesLog($model->workorderdtl->workorder->quotationId, $model->workorderdtl->workorder->id, $model->workorderdtl->workorder->quotationNumber, 'DeliveryDocket', "Delivery Docket Details  ({$itemdetail}) for Delivery Docket {$model->deliverydocket->diliveryDocketNum} is deleted", 1, 0, 1);


            $deleted = $model->delete();
            if ($deleted == true) {
                $transaction->commit();
                echo json_encode(array('success' => true));
            } else {
                $transaction->rollback();
                echo json_encode(array('success' => false, 'message' => 'Transaction has been rollbacked.'));
            }
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }
    
    public function actionDeleteMultipleRecords() {
        if (Yii::app()->request->isPostRequest) {
            $arrids = json_decode(stripslashes($_POST['doDtlArr']));
            
            if(!empty($arrids)){
                $criteria = new CDbCriteria;
                $criteria->addInCondition('id', $arrids);
                DeliveryDocketDetails::model()->deleteAll($criteria);
                
                $criteria2 = new CDbCriteria;
                $criteria2->addInCondition('delivery_docket_dtl_id', $arrids);
                DeliveryDocketLabel::model()->deleteAll($criteria2);
                
               echo json_encode(array('status'=>true));
            }
        }
        
    }

}
