<?php

class DeliveryDocketLabelController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'createLabel', 'savelblboxNum', 'savelblNote', 'savelblQty'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new DeliveryDocketLabel;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['DeliveryDocketLabel'])) {
            $model->attributes = $_POST['DeliveryDocketLabel'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['DeliveryDocketLabel'])) {
            $model->attributes = $_POST['DeliveryDocketLabel'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            $id = isset($_POST['id'])?$_POST['id']:0;

            $deleted = true;
            $model = $this->loadModel($id);
            $deleted = $model->delete();

            if ($deleted == true) {

                echo json_encode(array('success' => $id));
            } else {

                echo json_encode(array('success' => false, 'message' => 'Transaction has been rollbacked.'));
            }
        }
    }

    public function actionDeleteLbl() {
        if (Yii::app()->request->isPostRequest) {
            $id = $_POST['id'];
            $deleted = true;

            $model = $this->loadModel($id);

            $deleted = $model->delete();

            if ($deleted == true) {

                echo json_encode(array('success' => true));
            } else {

                echo json_encode(array('success' => false, 'message' => 'Transaction has been rollbacked.'));
            }
        }
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('DeliveryDocketLabel');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new DeliveryDocketLabel('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['DeliveryDocketLabel']))
            $model->attributes = $_GET['DeliveryDocketLabel'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = DeliveryDocketLabel::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'delivery-docket-label-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionCreateLabel() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'])) {
                $resultArr = array();
                $deliveryDocketDtlID = $_POST['id'];
                $deliverydocketDtl = DeliveryDocketDetails::model()->findByPk($deliveryDocketDtlID);


                $deliverydocketLbl = new DeliveryDocketLabel();
                $deliverydocketLbl->delivery_docket_id = $deliverydocketDtl->deliveryDocketId;
                $deliverydocketLbl->delivery_docket_dtl_id = $deliveryDocketDtlID;

                if ($deliverydocketLbl->save()) {
                    $resultArr['rowid'] = $deliverydocketLbl->id;
                    echo json_encode($resultArr);
                } else {
                    throw new Exception;
                }
            }
        }
    }

    public function actionSavelblboxNum() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->boxnum = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionSavelblNote() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->notes = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionSavelblQty() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (!isset($_POST['id'], $_POST['value'])) {
                throw new Exception('Bad request!', 400);
            }

            $modelId = intval($_POST['id']);
            $quantity = intval($_POST['value']);


            if ($model = $this->loadModel($modelId)) {
                //delivery docket detail
                $ddt = DeliveryDocketDetails::model()->findByPk($model->delivery_docket_dtl_id);

                //find total quantity by label for this ddt
                $lblQtySql = "SELECT SUM(quantity) lblQty FROM delivery_docket_labels WHERE delivery_docket_id = {$ddt->deliveryDocketId} AND delivery_docket_dtl_id = {$ddt->id}";
                $result = Yii::app()->db->createCommand($lblQtySql)->queryRow();

                $totalQtyToBe = ($result['lblQty'] - intval($model->quantity)) + $quantity;

                if ($ddt->qty < $totalQtyToBe) {
                    echo json_encode(array('status' => false, 'status_code' => 304 , 'error' => 'Quantity exceeds! ' . $result['lblQty'] . ' : ' . $quantity));
                    exit();
                }

                $model->quantity = $quantity;

                if (!$model->save()) {
                    echo json_encode(array('status' => false, 'error' => 'Cannot save new label quantity!'));
                    exit();
                }

                echo json_encode(array('status' => true));
                exit();
            } else {
                throw new Exception('Delivery label not found exception!', 404);
            }
        }
    }

}
