<?php

class DeliveryDocketsController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'printnote', 'getBalanceDOQty', 'printlbl'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $model = $this->loadModel($id);



        $this->render('view', array(
            'model' => $model,
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * 
     * 
     * 
     */
    public function actionCreateJobDO() {
        
    }

    public function actionCreate() {



        $model = new DeliveryDockets;
        $model->unsetAttributes();  // clear any default values
        $invoice = null;
        $job = null;
        if (isset($_GET['inv_id']) && !isset($_POST['DeliveryDockets'])) {
            $invoice_id = $_GET['inv_id'];
            $invoice = Invoice::model()->findByPk($invoice_id);
            $model->quoteId = $invoice->quote_id;
            $model->wrkorderId = $invoice->job->workorder->id;
            $model->jobId = $invoice->job_id;
            $model->invoiceId = $invoice->id;
            $model->invoice_number = $invoice->invoiceNum;

            //match shipping address of the customer
            $model->contactName = $invoice->customer->cuscontact;
            $model->companyName = $invoice->customer->cusnam;
            $model->companyAddress = $invoice->customer->shipAddress1;
            $model->companyAddress2 = $invoice->customer->shipAddress2;
            $model->companyAddress3 = $invoice->customer->shipAddress3;
            $model->town = $invoice->customer->shipSub;
            $model->state = $invoice->customer->shipState;
            $model->postalCode = $invoice->customer->shipPostalCode;
            $model->telephone1 = $invoice->customer->custel;
            $model->telephone2 = $invoice->customer->cusmobtel;
            $model->shippedBy = $invoice->job->shippingLineId;
            $model->createdBy = Yii::app()->user->id;
            $model->createdDtm = date('Y-m-d', strtotime('now'));

            if ($model->save()) {
                $model->diliveryDocketNum = 'DOGG' . (8000 + $model->id);
                $model->save();
                $invoicedetails = InvoiceDetail::model()->findAll(array('condition' => "invoice_id = '$invoice_id'"));
                foreach ($invoicedetails as $dtl) {
                    $deliverydocketDtl = new DeliveryDocketDetails();
                    $deliverydocketDtl->deliveryDocketId = $model->id;
                    $deliverydocketDtl->wrkorderId = $dtl->workorder_id;
                    $deliverydocketDtl->wrkorderDtlId = $dtl->wrkorderDtl_id;
                    $deliverydocketDtl->invoiceid = $invoice_id;
                    $deliverydocketDtl->invoiceDtlId = $dtl->id;
                    $deliverydocketDtl->jobId = $dtl->job_id;
                    $deliverydocketDtl->qty = $dtl->qty;
                    $deliverydocketDtl->save();
                }
                $url = Yii::app()->createUrl('deliveryDockets/view', array("id" => $model->id));
                $link = CHtml::link($model->diliveryDocketNum, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->quoteId, $model->job->workorder->id, $model->job->quoteNum, 'Job', "Delivery docket ({$link}) is created for invoice {$invoice->invoiceNum}", 1, 1, 1);

                SalesLog::createSalesLog($model->quoteId, $model->job->workorder->id, $model->job->quoteNum, 'DeliveryDocket', "Delivery docket ({$link}) is created for invoice {$invoice->invoiceNum}", 1, 1, 1);
            }

            $this->render('create', array(
                'model' => $model,
                'invoice' => $invoice,
            ));
        } else if (isset($_GET['job_id']) && !isset($_POST['DeliveryDockets'])) {
            $job_id = $_GET['job_id'];
            //avoid create DOs when refresh the page
            if (isset(Yii::app()->session['JOB_DO_OPEN']) && Yii::app()->session['JOB_DO_OPEN'] == $job_id) {
                if ($opendo = DeliveryDockets::model()->find(array("condition" => "jobId=:jobId", "params" => array(":jobId" => $job_id), "order" => "id DESC"))) {
                    $model = $opendo;
                }
            } else {
                $job = Jobs::model()->findByPk($job_id);
                $model->quoteId = $job->quote_id;
                $model->wrkorderId = $job->workorder->id;
                $model->jobId = $job_id;
                $model->companyName = $job->customer->cusnam;
                $model->companyAddress = $job->shipAddress1;
                $model->companyAddress2 = $job->shipAddress2;
                $model->companyAddress3 = $job->shipAddress3;
                $model->town = $job->shipSub;
                $model->state = $job->shipState;
                $model->postalCode = $job->shipPostalCode;
                $model->telephone1 = $job->customer->custel;
                $model->telephone2 = $job->customer->cusmobtel;
                $model->shippedBy = $job->shippingLineId;
                $model->createdBy = Yii::app()->user->id;
                $model->createdDtm = date('Y-m-d', strtotime('now'));

                if ($model->save()) {


                    /**
                     * check whether the details qty fulfill or not
                     * if not detail will be added to DO otherwise not
                     * 
                     * @return int items added to the do
                     */
                    if (!$this->detailsQtyFilter($model, $job)) {
                        //if no items then revoke the DO and redirect to the job
                        $model->delete();
                        Yii::app()->user->setFlash('notice', "Cannot create Delivery note. Delivery notes are completed!");
                        $this->redirect(array('jobs/view', 'id' => $job->id));
                        exit();
                    }

                    $model->diliveryDocketNum = 'DOGG' . (8000 + $model->id);
                    $model->save();
                    $url = Yii::app()->createUrl('deliveryDockets/view', array("id" => $model->id));
                    $link = CHtml::link($model->diliveryDocketNum, $url, array('target' => '_blank'));
                    SalesLog::createSalesLog($model->quoteId, $model->job->workorder->id, $model->job->quoteNum, 'Job', "Delivery docket ({$link}) is created for job {$job->jobNum}", 1, 1, 1);

                    SalesLog::createSalesLog($model->quoteId, $model->job->workorder->id, $model->job->quoteNum, 'DeliveryDocket', "Delivery docket ({$link}) is created for job {$job->jobNum}", 1, 1, 1);

                    //set session to stop create DO when refresh the page
                    Yii::app()->session['JOB_DO_OPEN'] = $job->id;
                }
            }


            $this->render('create', array(
                'model' => $model,
                'job' => $job,
            ));
        }

        if (isset($_POST['close-do-btn']) && isset($_POST['DeliveryDockets'])) {
            $model = $this->loadModel($_POST['DeliveryDockets']['id']);
            unset(Yii::app()->session['JOB_DO_OPEN']);
            unset(Yii::app()->session['INVOICE_DO_OPEN']);
            $this->redirect(array('view', 'id' => $model->id));
        }



        if (isset($_POST['update-do-btn']) && isset($_POST['DeliveryDockets'])) {

            $model = $this->loadModel($_POST['DeliveryDockets']['id']);
            $model->quoteId = $_POST['DeliveryDockets']['quoteId'];
            $model->wrkorderId = $_POST['DeliveryDockets']['wrkorderId'];
            $model->jobId = $_POST['DeliveryDockets']['jobId'];
            $model->invoiceId = $_POST['DeliveryDockets']['invoiceId'];
            $model->diliveryDocketNum = $_POST['DeliveryDockets']['diliveryDocketNum'];
            $model->contactName = $_POST['DeliveryDockets']['contactName'];
            $model->companyName = $_POST['DeliveryDockets']['companyName'];
            $model->companyAddress = $_POST['DeliveryDockets']['companyAddress'];
            $model->companyAddress2 = $_POST['DeliveryDockets']['companyAddress2'];
            $model->companyAddress3 = $_POST['DeliveryDockets']['companyAddress3'];
            $model->town = $_POST['DeliveryDockets']['town'];
            $model->state = $_POST['DeliveryDockets']['state'];
            $model->postalCode = $_POST['DeliveryDockets']['postalCode'];
            $model->telephone1 = $_POST['DeliveryDockets']['telephone1'];
            $model->telephone2 = $_POST['DeliveryDockets']['telephone2'];
            $model->shippedBy = $_POST['DeliveryDockets']['shippedBy'];
            $model->createdBy = Yii::app()->user->id;
            $model->createdDtm = date('Y-m-d', strtotime('now'));



            if ($model->save()) {

//                $model->diliveryDocketNum = 'DOGG' . (8000 + $model->id);
//                $model->save();


                $url = Yii::app()->createUrl('deliveryDockets/view', array("id" => $model->id));
                $link = CHtml::link($model->diliveryDocketNum, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->quoteId, $model->job->workorder->id, $model->job->quoteNum, 'Job', "Delivery docket ({$link}) is updated", 1, 1, 1);

                SalesLog::createSalesLog($model->quoteId, $model->job->workorder->id, $model->job->quoteNum, 'DeliveryDocket', "Delivery docket ({$link}) is updated", 1, 1, 1);
                $this->redirect(array('view', 'id' => $model->id));
            }
        }
    }

    private function detailsQtyFilter($model, $job) {
        $workorderdtls = Workorderdetails::model()->findAll(array('condition' => "workorderId = '{$model->wrkorderId}'"));



        $itemCountDO = 0;
        foreach ($workorderdtls as $dtl) {
            //find total quantity by label for this ddt
            $itemDOQtySql = "SELECT SUM(qty) itemDOQty FROM delivery_docket_details WHERE wrkorderDtlId = {$dtl->id}";
            $result = Yii::app()->db->createCommand($itemDOQtySql)->queryRow();
            $itemDOQty = $result['itemDOQty'];
            if ($dtl->prodQty > $itemDOQty) {
                $deliverydocketDtl = new DeliveryDocketDetails();
                $deliverydocketDtl->deliveryDocketId = $model->id;
                $deliverydocketDtl->wrkorderId = $model->wrkorderId;
                $deliverydocketDtl->wrkorderDtlId = $dtl->id;

                $deliverydocketDtl->jobId = $job->id;
                $deliverydocketDtl->qty = $dtl->prodQty - $itemDOQty;
                if ($deliverydocketDtl->save()) {
                    $itemCountDO++;
                }
            }
        }

        return $itemCountDO;
    }

    private function getDOCount($quoteid, $jobid) {
        $invs = Invoice::model()->findAll("quote_id = '{$quoteid}' and job_id = '{$jobid}'");
        return count($invs);
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {

        $model = $this->loadModel($id);
        $invoice = null;
        $model->invoice_number = null;
        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['DeliveryDockets'])) {

            $model->attributes = $_POST['DeliveryDockets'];
            $invoice = Invoice::model()->findByPk($model->invoiceId);
            if ($model->save()) {
                $url = Yii::app()->createUrl('deliveryDockets/view', array("id" => $model->id));
                $link = CHtml::link($model->diliveryDocketNum, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->quoteId, $model->job->workorder->id, $model->job->quoteNum, 'Job', "Delivery docket ({$link}) is updated for job {$model->job->jobNum}", 1, 1, 1);

                SalesLog::createSalesLog($model->quoteId, $model->job->workorder->id, $model->job->quoteNum, 'DeliveryDocket', "Delivery docket ({$link}) is updated for job {$model->job->jobNum}", 1, 1, 1);
            }
//            if ($model->save())
            $this->redirect(array('view', 'id' => $model->id));
        } else {


            $invoice = Invoice::model()->findByPk($model->invoiceId);
            if (!empty($invoice)) {
                $model->invoice_number = $invoice->invoiceNum;
            }


            $this->render('update', array(
                'model' => $model,
            ));
        }
    }

    public function actionGetBalanceDOQty() {

        $resultArr = array();
        $resultArr['balance_qty'] = -1;

        if (isset($_POST)) {
            $invoice_dtl_id = $_POST['id'];
            $invoicedtl = InvoiceDetail::model()->findByPk($invoice_dtl_id);

            $totalDOQty = 0;
            $deleiveryDocketDtls = DeliveryDocketDetails::model()->findAll("invoiceDtlId = '$invoice_dtl_id'");
            foreach ($deleiveryDocketDtls as $dtl) {
                $totalDOQty += $dtl->qty;
            }


            $resultArr['balance_qty'] = $invoicedtl->qty - $totalDOQty;
        }


        echo json_encode($resultArr);
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $transaction = Yii::app()->db->beginTransaction();
            $deleted = true;
            $model = $this->loadModel($id);
            $jobId = $model->jobId;
            $dddtlls = DeliveryDocketDetails::model()->findAll("deliveryDocketId = '$model->id'");
            $ddlebals = DeliveryDocketLabel::model()->findAll("delivery_docket_id = '$model->id'");

            if (!empty($dddtlls) && count($dddtlls) > 0) {
                $deleted = DeliveryDocketDetails::model()->deleteAll("deliveryDocketId = '$model->id'");
            }

            if (!empty($ddlebals) && count($ddlebals) > 0 && $deleted == true) {
                $deleted = DeliveryDocketLabel::model()->deleteAll("delivery_docket_id = '$model->id'");
            }


            if ($deleted == true) {
                $deleted = $model->delete();
                if ($deleted == true) {
                    if (isset(Yii::app()->session['JOB_DO_OPEN']) && Yii::app()->session['JOB_DO_OPEN'] == $jobId) {
                        unset(Yii::app()->session['JOB_DO_OPEN']);
                    }
                    $transaction->commit();
                } else {
                    $transaction->rollback();
                }
            } else {
                $transaction->rollback();
            }

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('DeliveryDockets');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {

        $model = new DeliveryDockets('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['DeliveryDockets']))
            $model->attributes = $_GET['DeliveryDockets'];

        if (isset($_GET['inv_id'])) {
            $invoice_id = $_GET['inv_id'];
            $model->invoiceId = $invoice_id;
        }

        if (isset($_GET['job_id'])) {
            $job_id = $_GET['job_id'];
            $model->jobId = $job_id;
        }

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    public function actionPrintnote($id) {

        $model = $this->loadModel($id);

        $url = Yii::app()->createUrl('deliveryDockets/view', array("id" => $model->id));
        $link = CHtml::link($model->diliveryDocketNum, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'DeliveryDocket Label ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quoteId, $model->invoice->job->workorder->id, $model->invoice->quoteNum, 'DeliveryDocket', "DeliveryDocket Label ({$link}) is printed", 1, 1, 1);
        }


        $htmlcontent = $this->renderInternal('protected/views/deliveryDockets/note_pdf.php', array('model' => $model), true);       
        
        
        $filename = str_replace("/", "-", $model->diliveryDocketNum);
        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);   
        
        $mpdf = new MpsDeliveryNotePdf;
        $mpdf->setMode(MpsPdf::MODE_CONTENT_GENERATOR)
        ->setModel($model)
        ->generate( $htmlcontent)
        ->output("{$sitePrefix}_DeliveryNote_{$filename}");
    }

    public function actionPrintlbl($id) {
        $model = $this->loadModel($id);
        $url = Yii::app()->createUrl('deliveryDockets/view', array("id" => $model->id));
        $link = CHtml::link($model->diliveryDocketNum, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'DeliveryDocket ({$link}) is printed'");

        if (empty($slog)) {

            SalesLog::createSalesLog($model->quoteId, $model->invoice->job->workorder->id, $model->invoice->quoteNum, 'DeliveryDocket', "DeliveryDocket ({$link}) is printed", 1, 1, 1);
        }


        $htmlcontent = $this->renderInternal('protected/views/deliveryDockets/label_pdf.php', array('model' => $model), true);



        $filename = str_replace("/", "-", $model->diliveryDocketNum);
        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);   
        
        $mpdf = new MpsDeliveryLabelPdf;
        $mpdf->setMode(MpsPdf::MODE_CONTENT_GENERATOR)
        ->setModel($model)
        ->generate( $htmlcontent)
        ->output("{$sitePrefix}_DeliveryLabel_{$filename}");
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = DeliveryDockets::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'delivery-dockets-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function getDileveryLabelRow() {
        
    }

}
