<?php

class EmailsController extends RController
{

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters()
    {
        return array(
            'rights',
            //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array(
                'allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id)
    {
        $model = $this->loadModel($id);
        $emailattachement = EmailAttachments::model()->find(array('condition' => "email_id = '{$id}'"));
        $this->render('view', array(
            'model' => $model,
            'emailattachement' => $emailattachement,
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate($id)
    {

        $model = new Emails;

        $fileInventoryModel = new FileInventory('search');
        $fileInventoryModel->unsetAttributes();  // clear any default values
        if (isset($_GET['FileInventory']))
            $fileInventoryModel->attributes = $_GET['FileInventory'];

        $show_price = isset($_GET['price_show']) ? filter_var($_GET['price_show'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_decoration = isset($_GET['deco_show']) ? filter_var($_GET['deco_show'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_custmizedtl = isset($_GET['cutmz_show']) ? filter_var($_GET['cutmz_show'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_notes = isset($_GET['notes_show']) ? filter_var($_GET['notes_show'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_job_info = isset($_GET['jinfo']) ? filter_var($_GET['jinfo'], FILTER_VALIDATE_BOOLEAN) : 1;
        $lngdesc_show = isset($_GET['lngdesc_show']) ? filter_var($_GET['lngdesc_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $show_weborder_info = isset($_GET['webordinfo']) ? filter_var($_GET['webordinfo'], FILTER_VALIDATE_BOOLEAN) : 1;
        $show_workorder_dtl_prices = isset($_GET['prices_show']) ? filter_var($_GET['prices_show'], FILTER_VALIDATE_BOOLEAN) : false;


        $parms_arr = array(
            'show_price' => $show_price, 'show_decoration' => $show_decoration, 'show_custmizedtl' => $show_custmizedtl, 'show_notes' => $show_notes, 'show_job_info' => $show_job_info
        );


        // $emailbody = new Emailbody();
        $emailattachement = new EmailAttachments();
        $purchaseorder = null;
        $workorder = null;
        $invoice = null;
        $quotation = null;

        if (!isset($_POST['yt0'])) {
            if (!empty(Yii::app()->user->email) && filter_var(Yii::app()->user->email, FILTER_VALIDATE_EMAIL)) {
                $model->fromaddress = Yii::app()->user->email;
            } else {
                //echo $_SERVER['SERVER_NAME'];
                $admin_email = GlobalVars::get('AdminEmail');
                if (!empty($admin_email) && filter_var($admin_email, FILTER_VALIDATE_EMAIL)) {
                    $model->fromaddress = $admin_email;
                } else {
                    $model->fromaddress = 'admin@' . $_SERVER['SERVER_NAME'];
                }
            }
            $model->ccemailaddresses = Yii::app()->user->email;
        }

        if (!isset($_POST['yt0']) && $_GET['type'] == 'PurchaseOrder') {

            $model->type = 'PO';

            $purchaseorder = PurchaseOrders::model()->findByPk($id);
            if (in_array($purchaseorder->poType, array('Purchase Product', 'Purchase Product-Decoration', 'Purchase Artwork'))) {

                $htmlcontent = null;
                if (in_array($purchaseorder->poType,  array('Purchase Product'))) {

                    $htmlcontent = $this->renderInternal('protected/views/purchaseOrders/po_jprd_pdf_html.php', array('model' => $purchaseorder), true);
                } else if (in_array($purchaseorder->poType,  array('Purchase Product-Decoration'))) {
                    $htmlcontent = $this->renderInternal('protected/views/purchaseOrders/po_jprd_deco_pdf_html.php', array('model' => $purchaseorder), true);
                } else if (in_array($purchaseorder->poType, array('Purchase Artwork'))) {
                    $htmlcontent = $this->renderInternal('protected/views/purchaseOrders/po_jartwrk_pdf_html.php', array('model' => $purchaseorder), true);
                }


                $filename = "files/" . $purchaseorder->poNum;

                $pdfCreator = new CommonPDFCreator(array(
                    'title' => 'Purchase Order',
                    'content' => $htmlcontent,
                    'pageNumber' => '{PAGENO}',
                    'outputFileName' => "{$filename}.pdf",
                    'outputFileType' => 'F'
                ));

                $pdfCreator->generate();





                $fileinventory = new FileInventory();
                $fileinventory->filename = $purchaseorder->poNum . '.pdf';
                $fileinventory->type = 'PO';
                $fileinventory->ref_id = $purchaseorder->id;

                $fileinventory->createdBy = Yii::app()->user->id;
                $fileinventory->createdDtm = date("Y-m-d g:i");

                $fileinventory->save();


                $model->subject = 'Purchase Order : ' . $purchaseorder->poNum;

                $model->toemailaddresses = $purchaseorder->supplier_->supemail;
                $model->fileattachment = $fileinventory->filename;


                $emailattachement->fileinventory_id = $fileinventory->id;


                //set file invenotry modal type
                $fileInventoryModel->type = 'JOB';
                $fileInventoryModel->ref_id = $purchaseorder->job->id;
            }
        } else if (!isset($_POST['yt0']) && $_GET['type'] == 'SalesOrder') {



            $workorder = Workorder::model()->findByPk($id);

            $model->type = 'WORKORDER';



            //get the email related format text for quote email
            $templateText = TemplateText::getTempleteText(TemplateText::TEMPLATE_SALES_ORDER_EMAIL);
            //Here we init template text formatter ( text replacer )
            $templateTextFormatter = new SalesOrderEmailTemplateTextFromatter($workorder);
            //formatter to decide the extra functionalites that needed for email quote text,  like online acceptance link                        
            $formattedTemplateText = $templateTextFormatter->format($templateText);


            $show_product_details = isset($_GET['prddshow']) == true ? $_GET['prddshow'] : 0;
            $show_custmz_details = isset($_GET['cutmz_show']) == true ? $_GET['cutmz_show'] : 0;
            $show_notes = isset($_GET['notes_show']) == true ? $_GET['notes_show'] : 0;

            $htmlcontent = $this->renderInternal('protected/views/workorder/so_pdf_html.php', array(
                'model' => $workorder,
                'show_product_details' => $show_product_details,
                'show_custmz_details' => $show_custmz_details,
                'show_notes' => $show_notes,
                'show_prices' => $show_workorder_dtl_prices,
            ), true);

            $filename = 'PS-' . $workorder->salesorderNumber;

            $pdfCreator = new CommonPDFCreator(array(
                'title' => 'Order Confirmation',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => "files/$filename.pdf",
                'outputFileType' => 'F'
            ));

            $pdfCreator->generate();



            //$fileinventory = $workorder->generatePDF($show_product_details, $show_custmz_details, $show_notes);

            $fileinventory = new FileInventory();
            $fileinventory->filename = $filename . '.pdf';
            $fileinventory->type = 'WORKORDER';
            $fileinventory->ref_id = $workorder->id;
            $fileinventory->createdBy = Yii::app()->user->id;
            $fileinventory->createdDtm = date("Y-m-d g:i");

            $fileinventory->save();

            $model->subject = 'Sales Order : ' . $workorder->salesorderNumber;

            $model->bodyText = $formattedTemplateText;

            $model->toemailaddresses = $workorder->quotation->customer->cusemail;
            $model->fileattachment = $fileinventory->filename;


            $emailattachement->fileinventory_id = $fileinventory->id;

            //set file invenotry modal type
            $fileInventoryModel->type = 'WORKORDER';
            $fileInventoryModel->ref_id = $workorder->id;
        } else if (!isset($_POST['yt0']) && $_GET['type'] == 'Invoice') {

            $model->type = 'INV';

            $invoice = Invoice::model()->findByPk($id);
            $htmlcontent = $this->renderInternal('protected/views/invoice/pdf_html.php', array(
                'model' => $invoice, 'show_price' => $show_price, 'show_decoration' => $show_decoration,
                'show_custmizedtl' => $show_custmizedtl, 'show_notes' => $show_notes, 'lngdesc_show' => $lngdesc_show
            ), true);

            $filename = "files/" . $invoice->invoiceNum;

            $pdfCreator = new CommonPDFCreator(array(
                'title' => 'Invoice',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => "{$filename}.pdf",
                'outputFileType' => 'F'
            ));

            $pdfCreator->generate();




            $fileinventory = new FileInventory();
            $fileinventory->filename = $invoice->invoiceNum . '.pdf';
            $fileinventory->type = 'INV';
            $fileinventory->ref_id = $invoice->id;

            $fileinventory->createdBy = Yii::app()->user->id;
            $fileinventory->createdDtm = date("Y-m-d g:i");

            $fileinventory->save();

            $model->subject = 'Invoice : ' . $invoice->invoiceNum;

            $model->toemailaddresses = $invoice->customer->cusemail;
            $model->fileattachment = $fileinventory->filename;

            $emailattachement->fileinventory_id = $fileinventory->id;

            //set file invenotry modal type
            $fileInventoryModel->type = 'INV';
            $fileInventoryModel->ref_id = $invoice->id;
        } else if (!isset($_POST['yt0']) && $_GET['type'] == 'Quote') {
            $model->type = 'Quote';

            $quotation = Quatation::model()->findByPk($id);

            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);

            $filename = $sitePrefix . $quotation->quoteno;
            $sourcefile = "files/{$filename}";

            //get the email related format text for quote email
            $templateText = TemplateText::getTempleteText(TemplateText::TEMPLATE_QUOTE_EMAIL);
            //Here we init template text formatter ( text replacer )
            $templateTextFormatter = new QuoteEmailTemplateTextFromatter($quotation);
            //formatter to decide the extra functionalites that needed for email quote text,  like online acceptance link                        
            $formattedTemplateText = $templateTextFormatter->format($templateText);



            $htmlcontent = $this->renderInternal('protected/views/quatation/quotePdf_html.php', array('model' => $quotation), true);


            $mpdf = new MpsQuotePdf;
            $mpdf->setMode(MpsPdf::MODE_CONTENT_GENERATOR)
                ->setModel($quotation)
                ->generate($htmlcontent)
                ->output("files/{$filename}", 'F');

            $fileinventory = new FileInventory();
            $fileinventory->filename = $filename . '.pdf';
            $fileinventory->type = 'Quote';
            $fileinventory->ref_id = $quotation->id;
            $fileinventory->createdBy = Yii::app()->user->id;
            $fileinventory->createdDtm = date("Y-m-d H:i:s");

            $fileinventory->save();

            $model->subject = 'Quotation : ' . $quotation->quoteno;

            $model->bodyText = $formattedTemplateText;

            $model->toemailaddresses = $quotation->customer->cusemail;
            $model->fileattachment = $fileinventory->filename;

            $emailattachement->fileinventory_id = $fileinventory->id;

            //set file invenotry modal type
            $fileInventoryModel->type = 'Quote';
            $fileInventoryModel->ref_id = $quotation->id;
        } else if (!isset($_POST['yt0']) && $_GET['type'] == Emails::TYPE_WEBSTORE_ORDER) {

            $model->type = FileInventory::TYPE_WEBSTORE_ORDER;

            $webstoreOrder = WebstoreOrder::model()->findByPk($id);
            $webstoreuser = WebstoreUser::model()->findByPk($webstoreOrder->webstore_user_id);

            if (!$approvalOperator = $webstoreuser->rel_approval_operator()) {
                Yii::app()->user->setFlash('notice', "Approval operator is not defined!");
                $this->redirect(array('webstoreOrder/view', 'id' => $id));
            }

            $filename = $webstoreOrder->orderNumber;
            $sourcefile = "files/{$filename}";

            //get the email related format text for quote email
            $templateText = TemplateText::getTempleteText(TemplateText::TEMPLATE_WEBSTORE_ORDER_EMAIL);
            //Here we init template text formatter ( text replacer )
            $templateTextFormatter = new WebstoreOrderEmailTemplateTextFromatter($webstoreOrder);
            //formatter to decide the extra functionalites that needed for email quote text,  like online acceptance link                        
            $formattedTemplateText = $templateTextFormatter->format($templateText);



            $htmlcontent = $this->renderInternal('protected/views/webstoreOrder/weborder_html.php', array('model' => $webstoreOrder), true);

            $pdfCreator = new CommonPDFCreator(array(
                'title' => 'Web Store Order',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => "{$sourcefile}.pdf",
                'outputFileType' => 'F'
            ));

            $pdfCreator->generate();





            $fileinventory = new FileInventory();
            $fileinventory->filename = $filename . '.pdf';
            $fileinventory->type = FileInventory::TYPE_WEBSTORE_ORDER;
            $fileinventory->ref_id = $webstoreOrder->id;
            $fileinventory->createdBy = Yii::app()->user->id;
            $fileinventory->createdDtm = date("Y-m-d H:i:s");

            $fileinventory->save();

            $model->subject = 'Web Store Order : ' . $webstoreOrder->orderNumber;

            $model->bodyText = $formattedTemplateText;





            $model->toemailaddresses = $approvalOperator->email;
            $model->fileattachment = $fileinventory->filename;

            $emailattachement->fileinventory_id = $fileinventory->id;
        } else if (!isset($_POST['yt0']) && $_GET['type'] == 'ArtworkApp') {
            $artwork = JobArtwork::model()->findByPk($id);

            $htmlcontent = $this->renderInternal('protected/views/jobArtwork/artwork_job_approval_pdf.php', array('model' => $artwork), true);

            $filename = $artwork->artworkjobNum . '.pdf';

            //$sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            $mpdf = new MpsArtworkApproval;
            $mpdf->setMode(MpsPdf::MODE_CONTENT_GENERATOR)
                ->setModel($model)
                ->generate($htmlcontent)
                ->output("files/{$artwork->artworkjobNum}", 'F');



            $fileinventory = new FileInventory();
            $fileinventory->filename = "{$artwork->artworkjobNum}.pdf";
            $fileinventory->type = $artwork->artworkInventoryType;
            $fileinventory->ref_id = $artwork->id;

            $fileinventory->createdBy = Yii::app()->user->id;
            $fileinventory->createdDtm = date("Y-m-d");

            $fileinventory->save(false);

            $model->subject = 'Artwork Approval : ' . $artwork->artworkjobNum;

            $model->toemailaddresses = $artwork->job->customer->cusemail;
            $model->fileattachment = $fileinventory->filename;

            $emailattachement->fileinventory_id = $fileinventory->id;

            //set file invenotry modal type
            $fileInventoryModel->type = 'ARTWORKJOB';
            $fileInventoryModel->ref_id = $artwork->id;

        } else if (!isset($_POST['yt0']) && $_GET['type'] == 'AwCusApp') {
            $artwork = JobArtwork::model()->findByPk($id);
            $artwork->artworkInventoryType = 'AwCusApp';
            $fileinventory = $artwork->generatePDF();

            $model->subject = 'Artwork Approval : ' . $artwork->artworkjobNum;

            $model->toemailaddresses = $artwork->job->customer->cusemail;
            $globalvar = GlobalVars::model()->find(array('condition' => "globalVar = 'AdminEmail'"));
            if (!empty($globalvar)) {
                $ccrecipients = $globalvar->value;
                $model->ccemailaddresses = $ccrecipients;
            }

            if (!empty($artwork->job->coordinator) && !empty($artwork->job->coordinator->email)) {
                $model->ccemailaddresses .= ';' . $artwork->job->coordinator->email;
            }

            $model->fileattachment = $fileinventory->filename;

            $emailattachement->fileinventory_id = $fileinventory->id;

            $proposedUsername = $artwork->job->customer->cusemail;
            $user = User::model()->find(array('condition' => "username = '{$proposedUsername}' and title = 'Customer'"));
            $logintext = "";
            if (empty($user)) {
                $user = new User();

                $user->username = $proposedUsername;
                $generatedPassword = User::generateRandomPassword();
                $user->password = md5($generatedPassword);
                $user->title = 'Customer';
                $user->email = $artwork->job->customer->cusemail;
                $user->cussno = $artwork->job->customer->cussno;
                if ($user->save()) {
                    $authassignment = new AuthAssignment();
                    $authassignment->itemname = 'Customer';
                    $authassignment->userid = $user->id;
                    $authassignment->data = 'N;';
                    if ($authassignment->save()) {
                        $logintext = "Please use following login details to get in to the system<br>Username : $proposedUsername<br>Password:$generatedPassword";
                    } else {
                        $allsaved = false;
                    }
                }
            } else {
                $logintext = 'Please use your login details to log in to our system and to do approval things';
            }

            $accessurl = 'http://gws-promosync.aranxa.com/' . Yii::app()->createUrl('jobArtwork/cusView', array('id' => $id));
            $mailbody = '<h1>Confirmation for ' . $artwork->artworkjobNum . '</h1>';
            $mailbody .= '<p>Please confirm or reject this artwork : <a href="' . $accessurl . '">' . $artwork->artworkjobNum . '</a>. click <a href="' . $accessurl . '">here</a> to see the artwork and do actions.</p>';
            $mailbody .= '<p>' . $logintext . '</p>';
            $mailbody .= '<p>For more details call : 000-0000-0000</p>';

            //$emailbody->bodytext = $mailbody;
            $model->bodyText = $mailbody;
        } else if (!isset($_POST['yt0']) && $_GET['type'] == 'SOCusApp') {
            $workorder = Workorder::model()->findByPk($id);
            $show_product_details = isset($_GET['prddshow']) == true ? $_GET['prddshow'] : 0;
            $show_custmz_details = isset($_GET['cutmz_show']) == true ? $_GET['cutmz_show'] : 0;
            $show_notes = isset($_GET['notes_show']) == true ? $_GET['notes_show'] : 0;
            $workorder->SOInventoryType = 'SOCusApp';
            $fileinventory = $workorder->generatePDF($show_product_details, $show_custmz_details, $show_notes);

            $model->toemailaddresses = $workorder->quotation->customer->cusemail;
            $model->subject = 'Sales Order Approval : ' . $workorder->salesorderNumber;
            $globalvar = GlobalVars::model()->find(array('condition' => "globalVar = 'AdminEmail'"));
            if (!empty($globalvar)) {
                $ccrecipients = $globalvar->value;
                $model->ccemailaddresses = $ccrecipients;
            }

            if (!empty($workorder->coordinator) && !empty($workorder->coordinator->email)) {
                $model->ccemailaddresses .= ';' . $workorder->coordinator->email;
            }
            $model->fileattachment = $fileinventory->filename;


            $emailattachement->fileinventory_id = $fileinventory->id;

            $proposedUsername = $workorder->quotation->customer->cusemail;
            $user = User::model()->find(array('condition' => "username = '{$proposedUsername}' and title = 'Customer'"));
            $logintext = "";
            if (empty($user)) {
                $user = new User();

                $user->username = $proposedUsername;
                $generatedPassword = User::generateRandomPassword();
                $user->password = md5($generatedPassword);
                $user->title = 'Customer';
                $user->email = $workorder->quotation->customer->cusemail;
                $user->cussno = $workorder->quotation->customer->cusemail;
                if ($user->save()) {
                    $authassignment = new AuthAssignment();
                    $authassignment->itemname = 'Customer';
                    $authassignment->userid = $user->id;
                    $authassignment->data = 'N;';
                    if ($authassignment->save()) {
                        $logintext = "Please use following login details to get in to the system<br>Username : $proposedUsername<br>Password:$generatedPassword";
                    } else {
                        $allsaved = false;
                    }
                }
            } else {
                $logintext = 'Please use your login details to log in to our system and to do approval things';
            }

            $accessurl = 'http://gws-promosync.aranxa.com/' . Yii::app()->createUrl('workorderdetails/cusView', array('id' => $id));
            $mailbody = '<h1>Confirmation for ' . $workorder->salesorderNumber . '</h1>';
            $mailbody .= '<p>Please confirm or reject this sales order : <a href="' . $accessurl . '">' . $workorder->salesorderNumber . '</a>. click <a href="' . $accessurl . '">here</a> to see the sales order and do actions.</p>';
            $mailbody .= '<p>' . $logintext . '</p>';
            $mailbody .= '<p>For more details call : 000-0000-0000</p>';

            //$emailbody->bodytext = $mailbody;
            $model->bodyText = $mailbody;
        } else if (!isset($_POST['yt0']) && $_GET['type'] == 'FollowUp' && $_GET['mode'] == FollowupStatus::JOB) {

            $followupStatus = FollowupStatus::model()->findByPk($id);
            $jobId = $_GET['jobId'];
            $job = Jobs::model()->findByPk($jobId);


            //get the email related format text for quote email
            $templateTextModel = TemplateText::model()->findByPk($followupStatus->email_template_text_id);
            $templateText = $templateTextModel ? $templateTextModel->contents : '';
            //Here we init template text formatter ( text replacer )
            $templateTextFormatter = new FollowUpEmailTemplateTextFromatter($job);
            //formatter to decide the extra functionalites that needed for email quote text,  like online acceptance link                        
            $formattedTemplateText = $templateTextFormatter->format($templateText);


            $model->subject = 'Follow up - ' . $followupStatus->status;

            $model->bodyText = $formattedTemplateText;

            $model->toemailaddresses = $job->customer->cusemail;

            $model->type = 'FollowUp';
        }

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Emails']) && isset($_POST['yt0'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $model->attributes = $_POST['Emails'];

            //check body text
            if (empty($model->bodyText)) {
                $transaction->rollback();
                Yii::app()->user->setFlash('notice', "Empty Body Text");
                $this->redirect($_PHP['SELF']); //$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
            }

            //$emailbody->attributes = $_POST['Emailbody'];
            $emailattachement->attributes = $_POST['EmailAttachments'];

            $model->createdBy = Yii::app()->user->id;
            $model->createdDtm = date("Y-m-d g:i");

            $fileinventory = FileInventory::model()->findByPk($emailattachement->fileinventory_id);

            if ($model->save()) {
                //$emailbody->email_id = $model->id;
                $emailattachement->email_id = $model->id;

                //$emailbody->save();
                $emailattachement->save(false);

                $mailer = Yii::app()->MultiMailer->to($model->toemailaddresses, 'Recipient');



                if (!filter_var($model->fromaddress, FILTER_VALIDATE_EMAIL)) {
                    $model->fromaddress = Yii::app()->user->username;


                    if (!filter_var(Yii::app()->user->username, FILTER_VALIDATE_EMAIL)) {

                        $model->fromaddress = GlobalVars::get('AdminEmail');
                        if (!filter_var($model->fromaddresse, FILTER_VALIDATE_EMAIL)) {
                            $model->fromaddress = 'admin@' . $_SERVER['SERVER_NAME'];
                        }
                    }
                }



                $mailer->from($model->fromaddress, $model->fromaddress);

                $mailer->to($model->toemailaddresses, '');





                if ($fileinventory->type == 'PO') {
                    $purchaseorder = PurchaseOrders::model()->findByPk($fileinventory->ref_id);

                    $mailer->subject($model->subject);
                } else if ($fileinventory->type == 'SO') {
                    $salesorder = Workorder::model()->findByPk($fileinventory->ref_id);

                    $lastAcceptLogAttributes = $salesorder->onlineAcceptenceLog->attributes;

                    $lastAcceptLogAttributes['link_expire_in'] = date('Y-m-d H:i:s', time() + (3600 * 24 * 7)); // expire in 7 days
                    $lastAcceptLogAttributes['status_id'] = WorkorderOnlineAcceptenceLog::LOG_STATUS_SENT;

                    $logId = WorkorderOnlineAcceptenceLog::write($lastAcceptLogAttributes);

                    $salesorder->so_online_acceptence_log_id = $logId;


                    $salesorder->updateFollowUpStatusByOnlineAcceptance($lastAcceptLogAttributes['status_id']);

                    SalesLog::addFollowUp(array(
                        'category' => SalesLog::CATEGORY_SALES_ORDER,
                        'tbl_id' => $salesorder->id,
                        'followupSts_id' => $salesorder->followupStatus
                    ));

                    $salesorder->save();

                    $mailer->subject($model->subject);
                } else if ($fileinventory->type == 'INV') {
                    $invoice = Invoice::model()->findByPk($fileinventory->ref_id);
                    $mailer->subject($model->subject);
                } else if ($fileinventory->type == 'Quote') {
                    $quotation = Quatation::model()->findByPk($fileinventory->ref_id);

                    $lastAcceptLogAttributes = $quotation->onlineAcceptenceLog->attributes;


                    $quotation->onlineAcceptenceLog->link_expire_in = date('Y-m-d H:i:s', time() + (3600 * 24 * 7)); // expire in 7 days
                    $quotation->onlineAcceptenceLog->status_id = QuoteOnlineAcceptenceLog::LOG_STATUS_SENT;
                    $quotation->onlineAcceptenceLog->enable_pay_later = $model->quoteAcceptanceEnablePayLater;
                    $quotation->onlineAcceptenceLog->enable_payment_gateway = $model->quoteAcceptanceEnablePaymentGateway;
                    $quotation->onlineAcceptenceLog->save(false);
                    
                    $quotation->updateFollowUpStatusByOnlineAcceptance($quotation->onlineAcceptenceLog->status_id);


                    SalesLog::createSalesLog($quotation->id, null, $quotation->quoteno, SalesLog::CATEGORY_QUOTATION, "Quotation has been sent to customer for approval.", 0, 0, 1);

                    $quotation->save(false);

                    $mailer->subject($model->subject);
                } else if ($fileinventory->type == 'ArtworkApp') {
                    $artwork = JobArtwork::model()->findByPk($fileinventory->ref_id);
                    $mailer->subject($model->subject);
                } else if ($fileinventory->type == 'AwCusApp') {

                    $artwork = JobArtwork::model()->findByPk($fileinventory->ref_id);
                    $mailer->subject($model->subject);

                    $mailbodytxt = trim($model->bodyText);
                    if (!empty($mailbodytxt)) {
                        $mailer->body($model->bodyText);
                    }

                    $mailer->attachment('files/' . $fileinventory->filename);

                    $artwork->job_status_id = 4; //Pending Approval
                    $artwork->approve_status_id = 4;
                    if ($artwork->save(false)) {
                        if ($mailer->send()) {
                            $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $artwork->id));
                            $link = CHtml::link($artwork->artworkjobNum, $url, array('target' => '_blank'));
                            $logtext = "Artowrk {$artwork->artworkjobNum} has been sent to customer for approval";
                            SalesLog::createSalesLog($artwork->job->workorder->quotationId, $artwork->job->workorder->id, $artwork->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
                            SalesLog::createTblLog($artwork->id, 'JobArtwork', $logtext);


                            Yii::app()->user->setFlash('success', "Artwork has been sent to approval.  {$artwork->artworkjobNum} ");
                            $transaction->commit();
                            $this->redirect(array('jobArtwork/view', 'id' => $id, 'send' => '1'));
                        } else {
                            $transaction->rollback();
                            Yii::app()->user->setFlash('error', "Error in sending artwork to approval.  {$artwork->artworkjobNum} ");
                            $this->redirect(array('jobArtwork/view', 'id' => $id, 'send' => '0'));
                        }
                    } else {
                        $transaction->rollback();
                        Yii::app()->user->setFlash('error', "Error in sending artwork to approval.  {$model->artworkjobNum} ");
                        $this->redirect(array('jobArtwork/view', 'wid' => $id, 'send' => '0'));
                    }
                } else if ($fileinventory->type == 'SOCusApp') {

                    $transaction = Yii::app()->db->beginTransaction();
                    $salesorder = Workorder::model()->findByPk($fileinventory->ref_id);
                    $mailer->subject($model->subject);

                    $mailbodytxt = trim($model->bodyText);
                    if (!empty($mailbodytxt)) {
                        $mailer->body($model->bodyText);
                    }

                    $mailer->attachment('files/' . $fileinventory->filename);


                    $salesorder->status_id = 4; //Pending Approval
                    if ($salesorder->save(false)) {

                        if ($mailer->send()) {
                            $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $salesorder->id));
                            $link = CHtml::link($salesorder->salesorderNumber, $url, array('target' => '_blank'));
                            SalesLog::createSalesLog($salesorder->quotationId, $salesorder->id, $salesorder->quotationNumber, 'Quotation', "Sales order ({$link}) has been sent to custoemr for approval", 0, 1, 1);
                            SalesLog::createSalesLog($salesorder->quotationId, $salesorder->id, $salesorder->quotationNumber, 'SalesOrder', "Sales order ({$link}) has been sent to custoemr for approval", 0, 1, 1);

                            //save email
                            //$trackmail = Emails::trackSave($recipient, $ccrecipients, $mailbody);
                            //end track email


                            $transaction->commit();
                            $this->redirect(array('workorderdetails/admin', 'wid' => $id, 'send' => '1'));
                        } else {
                            $transaction->rollback();
                            Yii::app()->user->setFlash('error', "Error in sending SO to approval.  {$salesorder->salesorderNumber}");
                            $this->redirect(array('workorderdetails/admin', 'wid' => $id, 'send' => '0'));
                        }
                    } else {
                        $transaction->rollback();
                        Yii::app()->user->setFlash('error', "Error in sending SO to approval.  {$salesorder->salesorderNumber}");
                        $this->redirect(array('workorderdetails/admin', 'wid' => $id, 'send' => '0'));
                    }
                } else if ($model->type == 'FollowUp') {
                    $mailer->subject($model->subject);
                }


                $mailbodytxt = trim($model->bodyText);
                if (!empty($mailbodytxt)) {
                    $mailer->body($model->bodyText);
                }

                if (in_array($fileinventory->type, array('PO', 'SO', 'INV', 'Quote', 'ArtworkApp', 'AwCusApp', 'SOCusApp'))) {
                    $mailer->attachment('files/' . $fileinventory->filename);

                    //extra attachment of PO
                    if ($fileinventory->type == 'PO') {
                        if (isset(Yii::app()->session[$model->type])) {
                            $fileAttachmentIds = array_filter(explode(',', Yii::app()->session[$model->type]));
                            foreach ($fileAttachmentIds as $id) {


                                $fileInventoryEmailattachement = new EmailAttachments();

                                $fileInventoryEmailattachement->email_id = $model->id;
                                $fileInventoryEmailattachement->fileinventory_id = $id;
                                $fileInventoryEmailattachement->ref_id = $fileinventory->ref_id;
                                $fileInventoryEmailattachement->type = $fileinventory->type;

                                if ($fileInventoryEmailattachement->save()) {
                                    $extraAttachment = FileInventory::model()->findByPk($id);
                                    $mailer->attachment("files/JOB/{$extraAttachment->filename}");
                                }
                            }
                        }
                    }
                }

                if ($mailer->send()) {

                    //unset extra attachments
                    unset(Yii::app()->session[$model->type]);

                    if ($fileinventory->type == 'ArtworkApp') {
                        $artwork = JobArtwork::model()->findByPk($fileinventory->ref_id);
                        $url = Yii::app()->createUrl('jobArtwork/print', array("id" => $artwork->id));
                        $link = CHtml::link($artwork->artworkjobNum, $url, array('target' => '_blank'));
                        SalesLog::createSalesLog($artwork->job->quote_id, $artwork->job->workorder_id, $artwork->job->quoteNum, 'Jobs', "Artwork($link) PDF is sent to approval", 1, 1, 1);
                        SalesLog::createTblLog($artwork->id, 'JobArtwork', "Artwork($link) PDF is sent to approval");
                    } else if ($fileinventory->type == 'ArtworkCusApp') {
                    }
                    $transaction->commit();
                    $this->redirect(array('admin'));
                } else {
                    $transaction->rollback();
                    Yii::app()->user->setFlash('error', "Email Sending Failed.");
                    $this->render('create', array(
                        'model' => $model,
                        //'emailbody' => $emailbody,
                        'emailattachement' => $emailattachement,
                        'purchaseorder' => $purchaseorder,
                        'workorder' => $workorder,
                        'quotation' => $quotation,
                        'fileInventoryModel' => $fileInventoryModel
                    ));
                }
            } else {
                $this->render('create', array(
                    'model' => $model,
                    //'emailbody' => $emailbody,
                    'emailattachement' => $emailattachement,
                    'purchaseorder' => $purchaseorder,
                    'workorder' => $workorder,
                    'quotation' => $quotation,
                    'fileInventoryModel' => $fileInventoryModel
                ));
            }
            //if($model->save())
            //$this->redirect(array('view','id'=>$model->id));
        }

        if (!isset($_POST['yt0'])) {
            $this->render('create', array(
                'model' => $model,
                //'emailbody' => $emailbody,
                'emailattachement' => $emailattachement,
                'purchaseorder' => $purchaseorder,
                'workorder' => $workorder,
                'invoice' => $invoice,
                'quotation' => $quotation,
                'fileInventoryModel' => $fileInventoryModel
            ));
        }
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id)
    {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Emails'])) {
            $model->attributes = $_POST['Emails'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id)
    {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex()
    {
        $dataProvider = new CActiveDataProvider('Emails');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin()
    {
        $model = new Emails('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Emails']))
            $model->attributes = $_GET['Emails'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id)
    {
        $model = Emails::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'emails-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionAddFileAttachments()
    {
        $emailType = $_POST['type'];
        $fileAttachmentIdString = $_POST['fileAttachmentIdString'];

        if (isset(Yii::app()->session[$emailType])) {
            Yii::app()->session[$emailType] .= ',' . $fileAttachmentIdString;
        } else {
            Yii::app()->session[$emailType] = $fileAttachmentIdString;
        }

        $fileAttachmentIds = array_filter(explode(',', $fileAttachmentIdString));

        $fileInventoryItems = [];
        foreach ($fileAttachmentIds as $id) {

            $fileInventory = FileInventory::model()->findByPk($id);
            $fileInventoryItems[$id] = $fileInventory->filename;
        }

        echo json_encode(array('fileInventoryItems' => $fileInventoryItems));
    }

    public function actionRemoveFileAttachments()
    {

        $emailType = $_POST['type'];
        $fileAttachmentId = $_POST['fileAttachmentId'];

        if (isset(Yii::app()->session[$emailType])) {
            $fileAttachmentIds = array_filter(explode(',', Yii::app()->session[$emailType]));

            if (($key = array_search($fileAttachmentId, $fileAttachmentIds)) !== false) {
                unset($fileAttachmentIds[$key]);
            }

            Yii::app()->session[$emailType] = implode(',', $fileAttachmentIds);

            echo json_encode(array('success' => true));
            exit;
        }

        echo json_encode(array('success' => false));
        exit;
    }
}
