<?php

class FileInventoryController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'uploadDocument', 'downloadFile', 'viewfile', 'fetchFields', 'updateDocument'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new FileInventory;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['FileInventory'])) {
            $model->attributes = $_POST['FileInventory'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['FileInventory'])) {
            $model->attributes = $_POST['FileInventory'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $inventoryFile = $this->loadModel($id); //$this->loadModel($id)->delete();
            //$job = Jobs::model()->findByPk($model->ref_id);

            if (!$inventoryFile) {
                throw new Exception("File not found!", 404);
            }

            $filePath = 'files/' . $inventoryFile->type . '/' . $inventoryFile->filename;

            //keep the copy of original model to use values after delete the original one
            $copyFileModel = new FileInventory();
            $copyFileModel->attributes = $inventoryFile->attributes;

            if (@unlink($filePath)) {
                if ($inventoryFile->delete()) {
                    $this->fileLog(array(
                        'file' => $copyFileModel,
                        'comment' => "File ($copyFileModel->filename) has been deleted."
                    ));
                    echo json_encode(array('success' => true));
                }
            } else {
                //cannot find the file, so just delete the file data from the inventory table
                if ($inventoryFile->delete()) {
                    $this->fileLog(array(
                        'file' => $copyFileModel,
                        'comment' => "File ($copyFileModel->filename) has been detached."
                    ));

                    echo json_encode(array('success' => true));
                }
            }
        }
    }

    public function actionDeleteProductImage($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $inventoryFile = $this->loadModel($id); //$this->loadModel($id)->delete();
            //$job = Jobs::model()->findByPk($model->ref_id);

            if (!$inventoryFile) {
                throw new Exception("File not found!", 404);
            }

            $filePath = 'images/product_img/' . $inventoryFile->filename;

            //keep the copy of original model to use values after delete the original one
            $copyFileModel = new FileInventory();
            $copyFileModel->attributes = $inventoryFile->attributes;

            if (@unlink($filePath)) {
                if ($inventoryFile->delete()) {
                    $this->fileLog(array(
                        'file' => $copyFileModel,
                        'comment' => "File ($copyFileModel->filename) has been deleted."
                    ));
                    echo json_encode(array('success' => true));
                }
            } else {
                //cannot find the file, so just delete the file data from the inventory table
                if ($inventoryFile->delete()) {
                    $this->fileLog(array(
                        'file' => $copyFileModel,
                        'comment' => "File ($copyFileModel->filename) has been detached."
                    ));

                    echo json_encode(array('success' => true));
                }
            }
        }
    }

    protected function fileLog($log = array()) {
        $inventoryFile = $log['file'];
        $comment = $log['comment'];
        if ($inventoryFile->type == 'JOB') {
            $job = Jobs::model()->findByPk($inventoryFile->ref_id);
            SalesLog::createSalesLog($job->quote_id, $job->workorder->id, $job->quoteNum, 'Job', $comment, 1, 1, 1);
            return;
        }

        if ($inventoryFile->type == 'QUOTATION') {
            $quote = Quatation::model()->findByPk($inventoryFile->ref_id);
            SalesLog::createSalesLog($quote->id, null, $quote->quoteno, 'Quotation', $comment, 1, 1, 1);
            return;
        }

        SalesLog::createTblLog($inventoryFile->ref_id, $inventoryFile->type, $comment);
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('FileInventory');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        
        $model = new FileInventory('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['FileInventory']))
            $model->attributes = $_GET['FileInventory'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = FileInventory::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'file-inventory-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionUploadDocument() {
        if (Yii::app()->request->isAjaxRequest) {



            $arr = array();
            $model = new FileInventory();
            $model->attributes = $_POST['FileInventory'];

            $uploadedFile = CUploadedFile::getInstance($model, 'filename');
            $documentrenamed = trim($model->documentfilename);
            if ($uploadedFile != null && !empty($documentrenamed)) {
                $fileName = $documentrenamed . '.' . $uploadedFile->getExtensionName();
            } else {
                $fileName = $uploadedFile;
            }

            $oldfilemodel = FileInventory::model()->find(array('condition' => "filename = '{$fileName}' and type = '{$model->type}' and ref_id = '{$model->ref_id}'"));

            $fileFolder = '';

            if ($model->type == 'JOB') {
                $job = Jobs::model()->findByPk($model->ref_id);
                $fileFolder = $job->jobNum;
            } else if ($model->type == 'Customer') {
                $customer = Customer::model()->findByPk($model->ref_id);
                $fileFolder = $customer->cuscus;
            } else {
                $fileFolder = $model->type . $model->ref_id;
            }


            $dirpath = Yii::app()->basePath . '/../files/' . $fileFolder;

            if (!file_exists($dirpath)) {
                mkdir($dirpath, 0777, true);
            }


            if ($oldfilemodel) {
                if (file_exists($dirpath . '/' . $fileName)) {
                    unlink($dirpath . '/' . $fileName);
                }

                $oldfilemodel->attributes = $_POST['FileInventory'];
                $oldfilemodel->filename = $fileName;
                $oldfilemodel->ref_id = intval($model->ref_id);
                $oldfilemodel->createdDtm = date('Y-m-d H:i:s');
                $oldfilemodel->createdBy = Yii::app()->user->id;

                if ($oldfilemodel->save()) {
                    $arr['success'] = true;
                } else {
                    $arr['success'] = false;
                }
            } else {
                $model->filename = $fileName;
                $model->ref_id = intval($model->ref_id);
                $model->createdDtm = date('Y-m-d H:i:s a');
                $model->createdBy = Yii::app()->user->id;
                if ($model->save()) {

                    $arr['success'] = true;
                } else {
                    $arr['success'] = false;
                }
            }



            if (!empty($uploadedFile)) {
                $arr['success'] = $uploadedFile->saveAs($dirpath . '/' . $fileName); // save images in given destination folder
            }

            if ($arr['success'] == true) {
                if ($model->type == 'JOB') {
                    $job = Jobs::model()->findByPk($model->ref_id);
                    SalesLog::createSalesLog($job->quote_id, $job->workorder->id, $job->quoteNum, 'Job', "New Document ($model->filename) is attached  ", 1, 1, 1);
                } else if ($model->type == 'Customer')
                    SalesLog::createTblLog($model->ref_id, 'Customer', "New Document ($model->filename) is attached  ");
                else
                    SalesLog::createTblLog($model->ref_id, $model->type, "New Document ($model->filename) is attached  ");
            }

            echo json_encode($arr);
        }
    }

    public function actionDownloadFile() {
        $id = intval($_GET['id']);
        $model = $this->loadModel($id);



        $filePath = 'files/' . $model->type . '/' . $model->filename;

        if (!file_exists($filePath)) {
            exit();
        }

        Yii::app()->getRequest()->sendFile($model->filename, file_get_contents($filePath));
    }
    
    public function actionDownloadProductImage() {
        $id = intval($_GET['id']);
        $model = $this->loadModel($id);



        $filePath = 'images/product_img/' . $model->filename;

        if (!file_exists($filePath)) {
            exit();
        }

        Yii::app()->getRequest()->sendFile($model->filename, file_get_contents($filePath));
    }

    public function actionViewfile($id) {
        $fileinventory = FileInventory::model()->findByPk($id);
        $file = Yii::app()->basePath . '/../files/' . $fileinventory->filename;
        header('Content-type: application/pdf');
        header("Content-Disposition: inline; filename='$file'");
        header('Content-Length: ' . filesize($file));
        readfile($file);
    }

    public function actionFetchFields() {
        if (isset($_POST['id'])) {
            $model = $this->loadModel($_POST['id']);
            $arr = array();
            $arr['id'] = $model->id;
            $filname = explode('.', $model->filename);
            $arr['documentfilename'] = $filname[0];
            $arr['comments'] = $model->comments;
            $arr['followup_sts_id'] = $model->followup_sts_id;

            echo json_encode($arr);
        }
    }

    public function actionUpdateDocument() {
        if (Yii::app()->request->isAjaxRequest) {



            $arr = array();
            $model = $this->loadModel($_POST['FileInventory']['id']);
            $existfilenamearr = explode('.', $model->filename);
            $model->attributes = $_POST['FileInventory'];

            $uploadedFile = CUploadedFile::getInstance($model, 'filename');
            $documentrenamed = trim($model->documentfilename);
            if ($uploadedFile != null && !empty($documentrenamed)) {

                //then new file has been uplaoded
                $fileName = $documentrenamed . '.' . $uploadedFile->getExtensionName();

                $oldfilemodel = FileInventory::model()->find(array('condition' => "filename = '{$fileName}' and type = '{$model->type}' and ref_id = '{$model->ref_id}'"));

                $fileFolder = '';

                if ($model->type == 'JOB') {
                    $job = Jobs::model()->findByPk($model->ref_id);
                    $fileFolder = $job->jobNum;
                } else if ($model->type == 'Customer') {
                    $customer = Customer::model()->findByPk($model->ref_id);
                    $fileFolder = $customer->cuscus;
                } else {
                    $fileFolder = $model->type . $model->ref_id;
                }


                $dirpath = Yii::app()->basePath . '/../files/' . $fileFolder;

                if (!file_exists($dirpath))
                    mkdir($dirpath, 0777, true);

                if (!empty($oldfilemodel)) {
                    if (file_exists($dirpath . '/' . $fileName)) {
                        unlink($dirpath . '/' . $fileName);
                    }
                }

                $uploadedFile->saveAs($dirpath . '/' . $fileName); // save images in given destination folder
                $model->filename = $fileName;
            } else if ($uploadedFile == null && !empty($documentrenamed)) {
                $output = 'there';
                if ($existfilenamearr[0] != $documentrenamed) {

                    $fileFolder = '';

                    if ($model->type == 'JOB') {
                        $job = Jobs::model()->findByPk($model->ref_id);
                        $fileFolder = $job->jobNum;
                    } else if ($model->type == 'Customer') {
                        $customer = Customer::model()->findByPk($model->ref_id);
                        $fileFolder = $customer->cuscus;
                    } else {
                        $fileFolder = $model->type . $model->ref_id;
                    }

                    $dirpath = Yii::app()->basePath . '/../files/' . $fileFolder;
                    rename(($dirpath . '/' . $existfilenamearr[0] . '.' . $existfilenamearr[1]), ($dirpath . '/' . $documentrenamed . '.' . $existfilenamearr[1]));

                    $model->filename = $documentrenamed . '.' . $existfilenamearr[1];
                } else {
                    $model->filename = ($existfilenamearr[0] . '.' . $existfilenamearr[1]);
                }
            } else {
                throw new CHttpException(404, 'Required fields cannot be empty.');
            }

            if ($model->save(false)) {

                $arr['success'] = true;
            } else {
                $arr['success'] = false;
            }

            if ($arr['success'] == true) {
                if ($model->type == 'JOB')
                    SalesLog::createSalesLog($job->quote_id, $job->workorder->id, $job->quoteNum, 'Job', "Attached document ($model->filename) is updated", 1, 1, 1);
                else if ($model->type == 'Customer')
                    SalesLog::createTblLog($model->ref_id, 'Customer', "Attached document ($model->filename) is updated");
                else
                    SalesLog::createTblLog($model->ref_id, $model->type, "Attached document ($model->filename) is updated");
            }

            echo $arr;
        }
    }

    public function actionDropZoneUpload() {
        if (!isset($_POST['referenceId']) || !is_int(intval($_POST['referenceId']))) {
            throw new Exception("Bad request! Referance ID not valid!", 400);
        }



        if (!isset($_POST['type']) || !preg_match('/^[a-zA-Z_]+$/', $_POST['type'])) {
            throw new Exception("Bad request! Type not valid!", 400);
        }
        $reference_id = $_POST['referenceId'];
        $type = $_POST['type']; //type of document related, such as CUSTOEMR, JOB, QUOTATION

        $uploadedFile = CUploadedFile::getInstanceByName('file');
        $originalFileName = $uploadedFile->getName(); // original uploaded file name 
        $path_parts = pathinfo($originalFileName);

        $modify_file_name = $path_parts['filename'] . '_' . time() . '.' . $path_parts['extension'];

        if ($type == FileInventory::TYPE_WEBSTORE_BANNER) {
            if (!in_array($path_parts['extension'], array('jpg', 'png'))) {
                throw new Exception("Bad request! Invalid File Types", 400);
            }
        }

        $fileData = array(
            'referenceId' => $reference_id,
            'type' => $type,
            'fileName' => $modify_file_name
        );

        //if inventory file not saved, please check the database table to make sure fields for not null or validation rules
        $inventoryFile = FileInventory::createFile($fileData);
        if ($inventoryFile) {
            $dirPath = 'files/' . $type;

            if (!file_exists($dirPath)) {
                mkdir($dirPath, 0777, true);
            }


            $fileWithPath = $dirPath . '/' . $modify_file_name;

            // save with orginal file name , remove tempory file
            if (!$uploadedFile->saveAs($fileWithPath, true)) {
                $inventoryFile->delete();
                throw new Exception('Cannot save uplaoded file!');
            } else {
                $this->fileLog(array(
                    'file' => $inventoryFile,
                    'comment' => "New Document ($inventoryFile->filename) has been attached."
                ));
            }

            echo json_encode(array('success' => true, 'fileName' => $modify_file_name));
        } else {
            throw new Exception('Cannot save uplaoded file!');
        }
    }

    public function actionDropZoneUploadProductImage() {


        if (!isset($_POST['type']) || !preg_match('/^[a-zA-Z_]+$/', $_POST['type'])) {
            throw new Exception("Bad request! Type not valid!", 400);
        }
        $reference_id = $_POST['referenceId'];
        $type = $_POST['type']; //type of document related, such as CUSTOEMR, JOB, QUOTATION

        $uploadedFile = CUploadedFile::getInstanceByName('file');
        $originalFileName = $uploadedFile->getName(); // original uploaded file name 
        $path_parts = pathinfo($originalFileName);



        if ($type == FileInventory::TYPE_PRODUCT_IMAGE) {
            if (!in_array($path_parts['extension'], array('jpg', 'png'))) {
                throw new Exception("Bad request! Invalid File Types", 400);
            }
        }

        $fileData = array(
            'referenceId' => $reference_id,
            'type' => $type,
            'fileName' => $originalFileName
        );

        //if inventory file not saved, please check the database table to make sure fields for not null or validation rules
        $inventoryFile = FileInventory::createFile($fileData);
        if ($inventoryFile) {
            $dirPath = 'images/product_img/';

            if (!file_exists($dirPath)) {
                mkdir($dirPath, 0777, true);
            }


            $fileWithPath = $dirPath . '/' . $originalFileName;

            // save with orginal file name , remove tempory file
            if (!$uploadedFile->saveAs($fileWithPath, true)) {
                $inventoryFile->delete();
                throw new Exception('Cannot save uplaoded file!');
            } else {
                $this->fileLog(array(
                    'file' => $inventoryFile,
                    'comment' => "New Document ($inventoryFile->filename) has been attached."
                ));
            }

            echo json_encode(array('success' => true, 'fileName' => $originalFileName));
        } else {
            throw new Exception('Cannot save uplaoded file!');
        }
    }

    public function actionDropZoneStore() {
        
    }

    public function actionDropZoneDelete() {
        $fileName = html_entity_decode($_POST['fileName']);
        $referenceId = $_POST['referenceId'];
        $criteria = new CDbCriteria;
        $criteria->addCondition('ref_id = :refID AND filename = :fileName');
        $criteria->params = array(':refID' => $referenceId, ':fileName' => $fileName);
        $inventoryFile = FileInventory::model()->find($criteria);

        if (!$inventoryFile) {
            throw new Exception("File not found!", 404);
        }

        $filePath = 'files/' . $inventoryFile->type . '/' . $inventoryFile->filename;

        if (unlink($filePath)) {
            if ($inventoryFile->delete()) {
                echo json_encode(array('success' => true));
            }
        } else {
            throw new Exception("Cannot delete the file", 409);
        }
    }

}
