<?php

class GoodsIssueNoteController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
			'rights',
			//'accessControl', // perform access control for CRUD operations
		);
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update','print'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete','updateComments'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $model = $this->loadModel($id);
        $job = Jobs::model()->findByPk($model->job_id);
        $this->render('view', array(
            'model' => $model,
            'job'=>$job,
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        //print_r($_POST);
        $model = new GoodsIssueNote;
        $dataProvider = null;        
        $supplierarr = array();
        $potypearr = array();
        $poarr = array();
        $po = new PurchaseOrders();
        $po->poType = 'Purchase Product-Decoration';
        $potype = '';
        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);
        $po->id = isset($_GET['po_id'])?$_GET['po_id']:null;
        
        if (isset($_POST['purchase-orders-grid_c0'])) {

            
            $poarr = $_POST['purchase-orders-grid_c0'];
            $jpdIDList = array();


            foreach ($poarr as $key => $val) {
                $po = PurchaseOrders::model()->findByPk($val);
                $poarr[] = $po->id;
                $supplierarr[] = $po->supplier_id;
                $potypearr[] = $po->poType;

                $potype = $po->poType;
                $jobproductdecorations = JobProductDecorations::model()->findAll("po_id = '{$po->id}'");

                foreach ($jobproductdecorations as $jpd) {
                    $jpdIDList[] = $jpd->id;
                }
            }



            $jpdStrIDs = implode(',', $jpdIDList);

            

            if (!empty($jpdStrIDs)) {
                $dataProvider = new CActiveDataProvider('JobProductDecorations', array(
                    'criteria' => array(
                        'condition' => " id in ({$jpdStrIDs})",
                    ),
                    'pagination' => false,
                ));
            }
        }
        
        
        if(isset($_POST['GoodsIssueDetails']) && isset($_POST['yt1'])){
            
            $model->attributes = $_POST['GoodsIssueNote'];          
            
            $wrkdtlarr = $_POST['GoodsIssueDetails'];
            
            $purchaseorder = PurchaseOrders::model()->findByPk($model->po_id);
            $purchaseorderDetails = PurchaseOrderDetails::model()->findAll("po_id = '{$purchaseorder->id}'");
            
            
            $job = Jobs::model()->findByPk($purchaseorder->job_id);
                
             
             $model->ginnum = 'GIN-' . $purchaseorder->quoteNum . '/' . date('Ymd') . '/' . (1 + $this->getGINCount($job->id));
             $model->job_id = $job->id;
             $model->workorder_id = $job->workorder_id;
             $model->supplier_id = $purchaseorder->supplier_id;
             $model->status_id = 1;//New
             $model->createdBy = Yii::app()->user->id;
             $model->createdDtm = date("Y-m-d g:i");
             
             if($model->save()){
                 foreach ($purchaseorderDetails as $podtl){
                     
                     
                     $jobproductdeco = JobProductDecorations::model()->find("id = '{$podtl->flowjob_id}' and job_id = '{$job->id}' and workorderDtl_id = '{$podtl->workorderDtl_id}' and po_id = '{$model->po_id}'");
                     $inventoryprod = InventoryProduct::model()->find("job_id = '{$job->id}' and wrkorder_id = '{$job->workorder_id}' and wrkorderDtl_id = '{$podtl->workorderDtl_id}'");
                     
                     $gindtls = new GoodsIssueDetails();
                     $gindtls->gin_id = $model->id;
                     $gindtls->po_id = $model->id;
                     $gindtls->wrkorder_id = $model->workorder_id;
                     $gindtls->wrkorderDtl_id = $podtl->workorderDtl_id;
                     $gindtls->job_id = $model->job_id;
                     //$gindtls->jobDtl_id = !empty($jobproduct) ? $jobproduct->id : null;
                     $gindtls->jobProdDocoDtl_id = !empty($jobproductdeco) ? $jobproductdeco->id : null;
                     $gindtls->qty = $jobproductdeco->decoQty;
                     
                     if($gindtls->save()){                        
                         
                         
                         if(!empty($jobproductdeco)){
                             $jobproductdeco->status_id = 7;//Goods Issued
                            $jobproductdeco->save();
                         }
                         
                         
                         if(!empty($inventoryprod)){
                             $inventoryprod->gin_id = $model->id;
                            $inventoryprod->ginDtls_id = $gindtls->id;
                            $inventoryprod->ginQty = $val;
                            $inventoryprod->goodsStatus_id = 7;//Goods Issued
                            $inventoryprod->save();
                         }
                         
                         
                         
                         
                         $activityflow = new JobActivityFlow();
                         $activityflow->job_id = $job->id;
                         $activityflow->wrkorder_id = $model->workorder_id;
                         $activityflow->wrkorderDtl_id = $key;
                         $activityflow->type = 'Product-Decoration';
                         $activityflow->activity = 'GIN Created';
                         $activityflow->flowjob_id = $jobproductdeco->id;
                         $activityflow->save();
                         
                         
                     }
                     
                 }
                 
                 $purchaseorder->status_id = 7;//Goods Issued
                 $purchaseorder->save();
                 $url = Yii::app()->createUrl('goodsIssueNote/view',array("id" => $model->id));
                 $link = CHtml::link($model->ginnum, $url, array('target'=>'_blank'));
                 
                 $urlpo = Yii::app()->createUrl('purchaseOrders/view',array("id" => $purchaseorder->id));
                 $linkpo = CHtml::link($purchaseorder->poNum, $urlpo, array('target'=>'_blank'));
                 SalesLog::createSalesLog($model->job->workorder->quotationId,$model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', "Goods issued note  ({$link}) is created for purchase order ({$linkpo}) and issued on {$model->issuedDtm}", 1, 1, 1);
                
                 
                 $this->redirect(array('view', 'id' => $model->id));
             }
             
        }

         
        $this->render('create', array(
            'model' => $model,
            'dataProvider' => $dataProvider,
            'selectdPO'=>$po,
        ));
    }
    
    private function getTodayGINCount() {
        $gin = GoodsIssueNote::model()->findAll("DATE_FORMAT(createdDtm, '%Y-%m-%d') = CURDATE()");
        return count($gin);
    }
    
    private function getGINCount($jobid) {
        $gin = GoodsIssueNote::model()->findAll("job_id = '{$jobid}'");
        return count($gin);
    }
    
    public function actionPrint($id) {
        $model = $this->loadModel($id);
        $url = Yii::app()->createUrl('goodsIssueNote/view',array("id" => $model->id));
        $link = CHtml::link($model->ginnum, $url, array('target'=>'_blank'));
        
        $slog = SalesLog::model()->find("comments = 'Goods issue note ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->porder->quote_id, $model->porder->workorder->id,$model->porder->quoteNum, 'Job', "Goods issue note ({$link}) is printed", 1, 1, 1);
            SalesLog::createSalesLog($model->porder->quote_id, $model->porder->workorder->id,$model->porder->quoteNum, $model->ginnum, "Goods issue note ({$link}) is printed", 1, 1, 1);
        }


        $pdf = Yii::createComponent('application.extensions.tcpdf.ETcPdf', 'P', 'cm', 'A4', true, 'UTF-8');
// create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


        spl_autoload_register(array('YiiBase', 'autoload'));

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Aranxa');
        $pdf->SetTitle($this->pageTitle . ' - Goods Issue Note');
        $pdf->SetSubject('Goods Issue Note');
// set default header data



        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, null, null);

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetFont('helvetica', '', 8, 'helvetica,Arial, sans-serif');
        $pdf->SetTextColor(0, 0, 0);
        $pdf->AddPage();

//Write the html
//Convert the Html to a pdf document

        $html = '<table style="width:100%;"><tr><td style="width:100%;text-align:right;font-size:1em;">' . $model->ginnum . '</td></tr></table><br/><br/>';

        $html .= '<table style="width:100%;"><tr><td style="width:100%;text-align:center;font-size:2em;">Goods Issue Note </td></tr></table><br/><br/>';

        $html .= '<table style="width:100%;border-bottom:1px solid black;border-top:1px solid black;padding:5px;">';

        $html .= '<tr><td style="width:50%;font-size:1.2em;"></td><td style="width:50%;font-size:1.2em;text-align:right;">Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->createdDtm)) . '</td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">PO Number : ' . $model->porder->poNum . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Supplier : ' . $model->porder->supplier_->supnam . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Address : ' .  $model->porder->supplier_->getFullAddress() . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">E-mail :  ' . $model->porder->supplier_->supemail . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Telephone :  ' . $model->porder->supplier_->suptel . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Issued Date :  ' . date(GlobalVars::get("DateFormat"),  strtotime($model->issuedDtm)) . ' </td></tr>';

        $html .= '</table><br/>';

        

        if (in_array($model->porder->poType, array('Purchase Product','Purchase Product-Decoration'))) {
            $html .= '<table style="width: 100%;height:100%;border:1px solid #000;padding:2px;">';
        }

        if (in_array($model->porder->poType, array('Purchase Product','Purchase Product-Decoration'))) {
            $html .= '<tr style="width: 100%;background-color:#DDD;">
                    <td style="width: 100%;border:1px solid #000;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <th style="width: 5%;text-align: center;" >No</th>
                                <th style="width: 20%;text-align: center;">Image</th>
                                <th style="width: 20%;text-align: center;">Product</th>
                                <th style="width: 30%;text-align: center;">Decoration</th>
                                <th style="width: 5%;text-align: center;">Qty</th>

                                <th style="width: 10%;text-align: center;">Cost Price</th>
                                <th style="width: 10%;text-align: center;">Amount</th>
                            </tr>

                        </table>
                    </td>

                </tr>';
        }


        if (in_array($model->porder->poType, array('Purchase Product','Purchase Product-Decoration'))) {

            $purchaseorderdetailsList = PurchaseOrderDetails::model()->findAll("po_id = '{$model->porder->id}'");

            $htmlbodyrows = '';

            foreach ($purchaseorderdetailsList as $record) {
                $this->count++;
                $this->rowtype = $this->count % 2;
                if (in_array($model->porder->poType, array('Purchase Product','Purchase Product-Decoration'))) {
                    $htmlbodyrows .= $this->getPurchaseProductHtml($model,$record);
                }
            }
        }

        $html .= $htmlbodyrows;





        if (in_array($model->porder->poType, array('Purchase Product','Purchase Product-Decoration'))) {
            $html .= '<tr style="width: 100%;background-color:#CCC;">
                    <td style="width: 100%;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <td style="width: 5%;"></td>
                                <td style="width: 20%;"></td>
                                <td style="width: 20%;"></td>
                                <td style="width: 30%;"><font style="font-size: 1.2em; font-weight: bold;">Total</font></td>
                                <td style="width: 5%;text-align: center;"><div style="font-size: 1.2em; font-weight: bold; text-align: center;" id="totprodqty">  ' . $model->porder->getProdQtyTotal() . ' </div></td>

                                <td style="width: 10%;text-align: right;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellexvat">  ' . number_format($model->porder->getProdCostTotal(), 2) . '</div></td>
                                <td style="width: 10%;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellincvat">  ' . number_format($model->porder->getProdAmountTotal(), 2) . '</div></td>
                                
                            </tr>
                        </table>
                    </td>


                </tr>';
        }

        if (in_array($model->porder->poType, array('Purchase Product'))) {
            $html .= '</table>';
        }

        $html .= '<br/><br/><table style="width:100%;border:1px solid #000;">';
        $html .= '<tr>
                    <td style="width:100%;font-size:1.2em;">' . $model->comments . '</td>
                    
                  </tr>';
        $html .= '</table><br/>';

//        $html .= '<br/><br/><br/><br/><table style="width:100%;">';
//
//        $html .= '<tr>
//                    <td style="width:50%;font-size:1.2em;text-align:center;">Customer Signature</td>
//                    <td style="width:50%;font-size:1.2em;text-align:center;">Authorized Officer</td>
//                  </tr>';
//
//
//        $html .= '</table><br/>';
// data loading
        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->lastPage();
        
        $filename = str_replace("/","-",$model->ginnum);
//Close and output PDF document
        $pdf->Output("{$filename}.pdf", 'I');
        Yii::app()->end();
    }

    var $rowtype = 0;
    var $count = 0;

    

    private function getPurchaseProductHtml($model,$podtl) {

        $record = Workorderdetails::model()->findByPk($podtl->workorderDtl_id);

        $html = '';

        $count = 0;


        $productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $record->productsku)));
        $decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $record->decprtnam)));
        $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $record->id)));



        $rowcolor = "background-color:#DDD;";

        $html .= '<tr style="width:100%;" nobr="true">            
                <td style="border-bottom:1px solid #000;">
                    <table style="width:100%;">
                            <tr   style="width:100%;">
                                <td style="width: 5%;"> ' . $this->count . ' </td>
                                <td style="width: 20%;"> <img src="' . $record->getImg() . '" /> </td>
                                <td style="width: 20%;"><div class="prodecs">';



        if (!empty($record->productsku)) {

            $html .= trim($record->productsku . '<br>' . $record->prdsrtdesc);
        } else {

            $html .= trim($record->custmproduct);
        }
        $html .= '</div>';



        $html .= '</td><td style="width: 30%;">';

        if (!empty($record->decprtnam)) {

            $html .= $record->decdesc;
        } else {

            $html .= $record->customdecoration;
        }


        $price = 0;
        
        if($model->porder->poType == 'Purchase Product'){
            $price = $record->prodCostPrice;
        }else if($model->porder->poType == 'Purchase Product-Decoration'){
            $price = $record->decoCostPrice;
        }
            
        
        $html .= '</td>
                                <td style="width: 5%;text-align: center;">
                                    ' . $record->prodQty . '
                                </td>
                                
                                <td style="width: 10%;text-align: right;">
                                   ' . number_format($price, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($price * $record->prodQty, 2) . '
                                </td>
                                                             
                                
                            </tr>
                            <tr  style="width:100%;">
                                <td colspan="10" style="width:100%;">
                                    <div  style="width:100%;">
                                        <table style="width:100%;">
                                            <tr style="width:100%;">
                                                <td style="width:100%;">
                                                    <table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:33%;text-align:center;" >Customization Details</th>
                                                            <th style="width:33%;text-align:center;" >Notes</th>
                                                            <th style="width:66%;text-align:center;" >Imagery</th>
                                                            
                                                        </tr>
                                                        <tr style="width:100%;">
                                                            <td style="width:33%;text-align:center;" >' . $record->customizationDetails . '</td>
                                                            <td style="width:66%;text-align:center;" >' . $record->notes . '</td>                                                            
                                                        </tr>
                                                    </table>
                                                </td> 
                                            </tr>
                                            <tr style="width:100%">
                                                <td style="width:100%">
                                                    <div  style="width:100%;">
                                                        <table   style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:10%;text-align:center;">#</th>
                                                            <th style="width:30%;text-align:center;">Size</th>
                                                            <th style="width:30%;text-align:center;">Quantity</th>
                                                            <th style="width:30%;text-align:center;">Color</th>
                                                            
                                            </tr>';


        $countrow = 0;
        foreach ($workordersizeqtycolors as $row) {
            $countrow++;

            $html .= '<tr style="width:100%;" >
                                                    <td style="width:10%;text-align:center;">' . $countrow . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['size'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['qty'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['color'] . '</td>
                                                    
                                                </tr>';
        }

        $html .= ' </table></div></td></tr></table></div></td> </tr> </table>                        
                        </td>
                    </tr>';

        return $html;
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['GoodsIssueNote'])) {
            $model->attributes = $_POST['GoodsIssueNote'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }
    
    public function actionUpdateComments() {
        $id = $_POST['id'];
        $specialcmnt = $_POST['text'];

        $model = $this->loadModel($id);
        $resultArr = array();
        if (!empty($model)) {

            $model->comments = $specialcmnt;
            if ($model->save()) {
                $resultArr['status'] = 'success';
            } else {
                $resultArr['status'] = 'error';
            }
        } else {
            $resultArr['status'] = 'error';
        }
        echo json_encode($resultArr);
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('GoodsIssueNote');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new GoodsIssueNote('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['GoodsIssueNote']))
            $model->attributes = $_GET['GoodsIssueNote'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = GoodsIssueNote::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'goods-issue-note-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
