<?php

class GoodsReceivedController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'print'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'print'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {

        $model = $this->loadModel($id);
        $job = Jobs::model()->findByPk($model->job_id);
        $this->render('view', array(
            'model' => $model,
            'job' => $job,
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {

        $model = new GoodsReceived;
        $dataProvider = null;
        $dataProviderArtwrk = null;
        $supplierarr = array();
        $potypearr = array();
        $poarr = array();

        $po = new PurchaseOrders('search');


        $po->unsetAttributes();  // clear any default values

        $po->id = isset($_GET['po_id']) ? $_GET['po_id'] : null;
        if (isset($_GET['po_id'])) {
            $workorderDetailId = $_GET['workorderDtlId'];
            $goodsreceive = GoodsReceived::model()->find(array('condition' => "po_id = '{$po->id}'"));
            $workorderDetail = Workorderdetails::model()->findByPk($workorderDetailId);
            $grnQty = GoodsReceived::grnQuanity($po->id, $workorderDetailId);
            if ($workorderDetail && $workorderDetail->prodQty == $grnQty) {
                $po2 = PurchaseOrders::model()->findByPk($po->id);
                Yii::app()->user->setFlash('error', "Goods already received ({$goodsreceive->grnnum}) for this purchase order ({$po2->poNum})");
                $this->redirect(array('jobs/view', 'id' => $goodsreceive->job_id));
            }
        }

        if (isset($_GET['PurchaseOrders']))
            $po->attributes = $_GET['PurchaseOrders'];

        $potype = '';


        //after select the po from the grid on the goods received form
        if (isset($_POST['purchase-orders-grid_c0'])) {

            $selectedPO = null;
            $poarr = $_POST['purchase-orders-grid_c0'];
            $podtlsidsList = array();


            foreach ($poarr as $key => $val) {
                if (empty($selectedPO))
                    $selectedPO = PurchaseOrders::model()->findByPk($val);
                $poarr[] = $selectedPO->id;
                $supplierarr[] = $selectedPO->supplier_id;
                $potypearr[] = $selectedPO->poType;

                $potype = $selectedPO->poType;
                $podtlsList = PurchaseOrderDetails::model()->findAll(
                        array('condition' => 'po_id=:poID', 'params' => array(':poID' => $val)));

                foreach ($podtlsList as $podtl) {
                    $podtlsidsList[] = $podtl->workorderDtl_id;
                }
            }

            $model->po_id = $selectedPO->id;

            $saleorderdtlsStr = implode(',', $podtlsidsList);

            $dataProvider = null;

            if (!empty($saleorderdtlsStr)) {
                $dataProvider = new CActiveDataProvider('Workorderdetails', array(
                    'criteria' => array(
                        'condition' => " id in ({$saleorderdtlsStr})",
                    ),
                    'pagination' => false,
                ));
            }

            if ($potype == 'Purchase  Embroidery Tape') {


                $poidstr = implode(',', $poarr);

                $artwrkinventList = InventoryArtWork::model()->findAll("embrTapePo_id in ({$poidstr})");
                $artwrkjobIdList = array();

                foreach ($artwrkinventList as $artwrkinv) {

                    $artwrkjobIdList[] = $artwrkinv->internaljob_id;
                }

                $artwrkjobIdStr = implode(',', $artwrkjobIdList);


                $dataProviderArtwrk = new CActiveDataProvider('InternalJobs', array(
                    'criteria' => array(
                        'condition' => " id in ({$artwrkjobIdStr})",
                    ),
                    'pagination' => false,
                ));
            }
        }

        //print_r($_POST);
        if (isset($_POST['btn_crt_grn']) && !isset($_POST['InternalJobs'])) {


            $transaction = Yii::app()->db->beginTransaction();
            $goodsreceivedDtlArr = isset($_POST['GoodsReceivedDtls']) ? $_POST['GoodsReceivedDtls'] : null;



            $model->attributes = $_POST['GoodsReceived'];



            if (!empty($model->receivedDate)) {
                $model->receivedDate = date(GlobalVars::MYSQL_DATETIME_FORMAT, strtotime($model->receivedDate));
            }


            $purchsOrdr = PurchaseOrders::model()->findByPk($model->po_id);


            $model->grnnum = 'GRN-' . $purchsOrdr->quoteNum . '/' . date('Ymd') . '/' . (1 + $this->getGRNCount($purchsOrdr->job_id));
            $model->job_id = $purchsOrdr->job_id;
            $model->wrkorder_id = $purchsOrdr->workorder_id;
            $model->supplier_id = $purchsOrdr->supplier_id;
            $model->createdDtm = date('Y-m-d H:i:s');
            $model->createdBy = Yii::app()->user->id;
            $model->status_id = 1; //New

            if ($model->save()) {
                $purchsOrdr->status_id = 9; //Goods Received
                $purchsOrdr->save();



                $purchase_order_dtls = PurchaseOrderDetails::model()->findAll("po_id = '{$purchsOrdr->id}'");

                foreach ($purchase_order_dtls as $po_dtl) {

                    //echo '$model->id ', $model->id, ' $po_dtl->workorderDtl_id ', $po_dtl->workorderDtl_id;                    exit();
                    $grnDetailQtyDone = GoodsReceived::grnQuanity($model->po_id, $po_dtl->workorderDtl_id);
                    $grnDetailQtyEntered = intval($goodsreceivedDtlArr[$po_dtl->workorderDtl_id]);
                    
                     //echo '$grnDetailQtyDone ' .$grnDetailQtyDone, ' $grnDetailQtyEntered ', $grnDetailQtyEntered, ' prodQty ', $po_dtl->workorderDtl->prodQty;
                     //exit();
                    
                    //if entered grn qty + current entered qty equals to full qty then all goods have been recieved
                    if( ($grnDetailQtyDone + $grnDetailQtyEntered) == $po_dtl->workorderDtl->prodQty ) {
                        $grnStatus = Status::SYS_STATUS_GOODS_RECEIVED;
                       
                    }
                    //if entered grn qty + current entered qty less than full qty then goods have been recieved partially
                    if( ($grnDetailQtyDone + $grnDetailQtyEntered) < $po_dtl->workorderDtl->prodQty ) {
                        $grnStatus = Status::SYS_STATUS_PARTIALLY_GOODS_RECEIVED;
                    }
                    
                    //if entered grn qty + current entered qty more than full qty then user entered qty is wrong, so reset the enterd qty
                    if( ($grnDetailQtyDone + $grnDetailQtyEntered) > $po_dtl->workorderDtl->prodQty ) {
                        $grnStatus = Status::SYS_STATUS_GOODS_RECEIVED;
                        $grnDetailQtyEntered = ($po_dtl->workorderDtl->prodQty - ($grnDetailQtyDone + $grnDetailQtyEntered)) > 0 ? ($po_dtl->workorderDtl->prodQty - ($grnDetailQtyDone + $grnDetailQtyEntered)) : 0;
                    }

                    $grndtl = new GoodsReceivedDtls();
                    $grndtl->grn_id = $model->id;
                    $grndtl->po_id = $model->po_id;
                    $grndtl->wrkorder_id = $model->wrkorder_id;
                    $grndtl->wrkorderDtl_id = $po_dtl->workorderDtl_id;
                    $grndtl->job_id = $model->job_id;
                    $grndtl->qty = $grnDetailQtyEntered;


                    if ($model->grnType == 'Product') {

                        $jobproduct = JobProducts::model()->find("id = '{$po_dtl->flowjob_id}' and po_id = '{$model->po_id}'");


                        $grndtl->jobDtl_id = $jobproduct->id;
                        $jobproduct->status_id = $grnStatus;
                        $jobproduct->save();

                        if ($model->addtoinventory == 1) {
                            $inventory = new Inventory();
                            $inventory->product_id = $po_dtl->workorderDtl->product->pdlsno;
                            $inventory->supplier_id = $purchsOrdr->supplier_id;
                            $inventory->qty = $grndtl->qty;
                            $inventory->status = $grnStatus;
                            $inventory->po_id = $purchsOrdr->id;
                            $inventory->grn_id = $model->id;
                            $inventory->createdBy = Yii::app()->user->id;
                            $inventory->createdDate = date('Y-m-d', strtotime('now'));
                            $inventory->save();
                        }
                    } else if ($model->grnType == 'Product-Decoration') {
                        $jobproductdeco = JobProductDecorations::model()
                                ->find("id = '{$po_dtl->flowjob_id}' and  po_id = '{$model->po_id}'");

                        $grndtl->jobDtl_id = $jobproductdeco->id;
                        $jobproductdeco->status_id = $grnStatus;
                        $jobproductdeco->save();

                        //check if the job is now completed

                        $jobproduct_decorations = JobProductDecorations::model()->findAll("job_id = '$model->job_id'");
                        $jobcompletedflag = true;
                        foreach ($jobproduct_decorations as $jbprddeco) {

                            if ($jbprddeco->status_id != 9) {
                                $jobcompletedflag = false;
                                break;
                            }
                        }

                        if ($jobcompletedflag == true) {
                            $job = Jobs::model()->findByPk($model->job_id);
                            $job->status_id = 17; //Job Completed
                            $job->save();

                            $url = Yii::app()->createUrl('jobs/view', array("id" => $model->id));
                            $link = CHtml::link($job->jobNum, $url, array('target' => '_blank'));

                            SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "All the steps of the job {$link} are completed.", 1, 1, 1);
                        }
                    }

                    if ($grndtl->save()) {
                        $jobactivityflow = new JobActivityFlow();
                        $jobactivityflow->job_id = $model->job_id;
                        $jobactivityflow->wrkorder_id = $model->wrkorder_id;
                        $jobactivityflow->wrkorderDtl_id = $po_dtl->workorderDtl_id;

                        if ($model->grnType == 'Product') {
                            $prodinventory = new InventoryProduct();
                            $prodinventory->job_id = $model->job_id;
                            $prodinventory->wrkorder_id = $model->wrkorder_id;
                            $prodinventory->wrkorderDtl_id = $grndtl->wrkorderDtl_id;
                            $wrkorderdtl = Workorderdetails::model()->findByPk($grndtl->wrkorderDtl_id);
                            $prodinventory->product_id = $wrkorderdtl->product->pdlsno;
                            $prodinventory->prdGrn_id = $model->id;
                            $prodinventory->prdGrnQty = $grndtl->qty;
                            $prodinventory->isDecoDone = 0;
                            $prodinventory->prdReceivedDtm = date('Y-m-d H:i:s');
                            $prodinventory->goodsStatus_id = $grnStatus;
                            $prodinventory->save();


                            $jobactivityflow->type = 'Product';
                            $jobactivityflow->activity = $grnStatus === Status::SYS_STATUS_GOODS_RECEIVED ? 'Goods Received' : 'Goods Received Partially';
                            $jobactivityflow->flowjob_id = $po_dtl->flowjob_id;
                            $jobactivityflow->save();
                        } else if ($model->grnType == 'Product-Decoration') {
//                            $prodinventory = InventoryProduct::model()
//                                    ->find("job_id = '{$model->job_id}' and wrkorder_id = '{$model->wrkorder_id}' and wrkorderDtl_id = '{$grndtl->wrkorderDtl_id}'");
//                                    $prodinventory->isDecoDone = 1;
//                                    $prodinventory->prodDecoGrn_id = $model->id;
//                                    $prodinventory->prdDecoGrnQty = $grndtl->qty;
//                                    $prodinventory->prdDecoReceivedDtm = date('Y-m-d H:i:s a');
//                                    $prodinventory->goodsStatus_id = 9;//Goods Received
//                                    $prodinventory->save();

                            $jobactivityflow->type = 'Product-Decoration';
                            $jobactivityflow->activity = $grnStatus === Status::SYS_STATUS_GOODS_RECEIVED ? 'Goods Received' : 'Goods Received Partially';
                            $jobactivityflow->flowjob_id = $po_dtl->flowjob_id;
                            $jobactivityflow->save();
                        }
                    }
                }
                $url = Yii::app()->createUrl('goodsReceived/view', array("id" => $model->id));
                $link = CHtml::link($model->grnnum, $url, array('target' => '_blank'));

                $urlpo = Yii::app()->createUrl('purchaseOrders/view', array("id" => $purchsOrdr->id));
                $linkpo = CHtml::link($purchsOrdr->poNum, $urlpo, array('target' => '_blank'));
                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Goods received note  ({$link}) is created for purchase order ({$linkpo}) which was expected on {$purchsOrdr->dueDate} and received on {$model->receivedDate}", 1, 1, 1);
            }
            $transaction->commit();
            $this->redirect(array('view', 'id' => $model->id));
        } else if (isset($_POST['btn_crt_grn']) && isset($_POST['InternalJobs'])) {
            $internalJobsIdList = $_POST['InternalJobs'];
            $jobid = 0;
            $po = null;




            foreach ($internalJobsIdList as $interanljobId) {
                $intrnlJob = InternalJobs::model()->findByPk($interanljobId);
                $jobid = $intrnlJob->job_id;

                $artwrkinvnt = InventoryArtWork::model()->find("internaljob_id = '{$interanljobId}'");

                $po = PurchaseOrders::model()->findByPk($artwrkinvnt->embrTapePo_id);
                break;
            }

            $job = Jobs::model()->findByPk($jobid);

            $model = new GoodsReceived();
            $model->attributes = $_POST['GoodsReceived'];
            if (!empty($model->receivedDate)) {
                $model->receivedDate = date(GlobalVars::MYSQL_DATETIME_FORMAT, strtotime($model->receivedDate));
            }
            $model->grnnum = 'GRN-' . $job->quoteNum . '/' . date('Ymd') . '/' . (1 + $this->getGRNCount($jobid));
            $model->job_id = $jobid;
            $model->wrkorder_id = $job->workorder_id;
            $model->po_id = !empty($po) ? $po->id : 0;
            $model->createdDtm = date('Y-m-d H:i:s a');
            $model->createdBy = Yii::app()->user->id;
            $model->status_id = 1; //New

            if ($model->save()) {
                $po->status_id = 9;
                $po->save();

                foreach ($internalJobsIdList as $interanljobId) {
                    $intrnlJob = InternalJobs::model()->findByPk($interanljobId);
                    $intrnlJob->status_id = 13; //Emb Tape Received
                    $intrnlJob->save();

                    $jobdtls = InternalJobsDetails::model()->findAll("internalJob_id = '{$interanljobId}'");
                    foreach ($jobdtls as $dtl) {
                        $newjobactivityflow = new JobActivityFlow();
                        $newjobactivityflow->job_id = $job->id;
                        $newjobactivityflow->wrkorder_id = $dtl->wrkorder_id;
                        $newjobactivityflow->wrkorderDtl_id = $dtl->wrkordrDtl_id;
                        $newjobactivityflow->type = 'Decoration';
                        $newjobactivityflow->activity = 'Emb Tape Received';

                        $newjobactivityflow->save();

                        $jobdecoration = JobDecorations::model()->find("internalJob_id = '{$interanljobId}' and workorderDtl_id = '{$dtl->wrkordrDtl_id}'");

                        $jobdecoration->status_id = 13; //Emb Tape Received
                        $jobdecoration->save();
                    }

                    $artwrkinvnt = InventoryArtWork::model()->find("internaljob_id = '{$interanljobId}'");
                    $artwrkinvnt->isEmbrTapeAvl = 1;
                    $artwrkinvnt->grn_id = $model->id;
                    $artwrkinvnt->save();
                }

                $url = Yii::app()->createUrl('goodsReceived/view', array("id" => $model->id));
                $link = CHtml::link($model->grnnum, $url, array('target' => '_blank'));

                $urlpo = Yii::app()->createUrl('purchaseOrders/view', array("id" => $po->id));
                $linkpo = CHtml::link($po->poNum, $urlpo, array('target' => '_blank'));

                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Goods received note  ({$link}) is created for embroidery tape purchase order ({$linkpo}) which was expected on {$purchsOrdr->dueDate} and received on {$model->receivedDate}", 1, 1, 1);

                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $result = array_unique($supplierarr);
        $resulttype = array_unique($potypearr);

        if (isset($_POST['purchase-orders-grid_c0']) && count($result) > 1) {
            Yii::app()->user->setFlash('notice', "Cannot create a GRN for different suppliers.");
            $this->render('create', array(
                'model' => $model,
            ));
        } else if (isset($_POST['purchase-orders-grid_c0']) && count($resulttype) > 1) {

            Yii::app()->user->setFlash('notice', "Cannot create a GRN for different purchasing order types.");
            $this->render('create', array(
                'model' => $model,
            ));
        } else {

            $this->render('create', array(
                'model' => $model,
                'po' => $po,
                'dataProvider' => $dataProvider,
                'dataProviderArtwrk' => $dataProviderArtwrk,
            ));
        }
    }

    private function getTodayGRNCount() {
        $grn = GoodsReceived::model()->findAll("DATE_FORMAT(createdDtm, '%Y-%m-%d') = CURDATE()");
        return count($grn);
    }

    private function getGRNCount($jobid) {
        $grn = GoodsReceived::model()->findAll("job_id = '{$jobid}'");
        return count($grn);
    }

    public function actionPrint($id) {
        $model = $this->loadModel($id);
        $url = Yii::app()->createUrl('goodsReceived/view', array("id" => $model->id));
        $link = CHtml::link($model->grnnum, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'Goods received note ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->porder->quote_id, $model->porder->workorder->id, $model->porder->quoteNum, 'Job', "Goods received note ({$link}) is printed", 1, 1, 1);
            SalesLog::createSalesLog($model->porder->quote_id, $model->porder->workorder->id, $model->porder->quoteNum, $model->grnnum, "Goods received note ({$link}) is printed", 1, 1, 1);
        }

        $htmlcontent = $this->renderInternal('protected/views/goodsReceived/grn_pdf.php', array('model' => $model), true);

        $filename = str_replace("/", "-", $model->grnnum);

        $pdfCreator = new CommonPDFCreator(array(
            'title' => 'Goods Receive Note',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "{$filename}.pdf"
        ));

        $pdfCreator->generate();
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['GoodsReceived'])) {
            $model->attributes = $_POST['GoodsReceived'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $transaction = Yii::app()->db->beginTransaction();
            $allSaved = true;
            $grn = $this->loadModel($id);
            $grnDetails = GoodsReceivedDtls::model()->findAll(array('condition' => "grn_id = {$grn->id}"));
            foreach ($grnDetails as $grnDtl) {
                if ($grn->grnType == 'Product') {
                    $poDetail = PurchaseOrderDetails::model()->find("po_id = {$grn->po_id} AND workorderDtl_id = $grnDtl->wrkorderDtl_id");

                    
                    if ($jobproduct = JobProducts::model()->find("id = {$poDetail->flowjob_id} AND po_id = {$grn->po_id}") ) {
                        $jobproduct->status_id = 5; //PO Created
                        if (!$jobproduct->save()) {
                            $allSaved = false;
                        }
                    }


                    $jobLog = JobActivityFlow::model()->find(array('condition' => "job_id = {$grnDtl->job_id} AND wrkorderDtl_id = {$grnDtl->wrkorderDtl_id} AND type = 'Product' AND flowjob_id = {$poDetail->flowjob_id} AND activity IN ( 'Goods Received Partially', 'Goods Received' )"));

                    if ($jobLog && !$jobLog->delete()) {
                        $allSaved = false;
                    }
                }
            }

            GoodsReceivedDtls::model()->deleteAll('grn_id = :grn_id', array(':grn_id' => $grn->id));
            Inventory::model()->deleteAll('grn_id = :grn_id', array(':grn_id' => $grn->id));

            $grnNumber = $grn->grnnum;
            $jobNumber = $grn->job->jobNum;
            if (!$grn->delete()) {
                $allSaved = false;
            }


            SalesLog::createSalesLog($grn->workorder->quotationId, $grn->workorder->id, $grn->workorder->quotationNumber, 'Job', "Goods received note ($grnNumber) has been deleted under the $jobNumber", 1, 1, 1);

            if ($allSaved) {
                $transaction->commit();
            } else {
                $transaction->rollback();
            }


            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('GoodsReceived');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new GoodsReceived('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['GoodsReceived']))
            $model->attributes = $_GET['GoodsReceived'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = GoodsReceived::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'goods-received-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
