<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GwsProductApiController
 *
 * @author Eranga
 */
class GwsProductApiController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionAdmin() {
        

        $postFields = GwsProductApi::getDefaultPostFields();
        
        

        $apiFilter = new GwsProductApiFilterForm;
        // collect user input data
        if (isset($_POST['GwsProductApiFilterForm']) && isset($_POST['api-search'])) {
            
            $apiFilter->attributes = $_POST['GwsProductApiFilterForm'];
            // validate user input and redirect to the previous page if valid
            if ($apiFilter->validate()) {
                
                $postFields["data"] = array(
                    "supplier" => (trim($apiFilter->supplier)?trim($apiFilter->supplier):""),
                    "product_code" => (trim($apiFilter->product_code)?trim($apiFilter->product_code):""),
                    "product_Name" => (trim($apiFilter->product_Name)?trim($apiFilter->product_Name):""),
                    "category" => (trim($apiFilter->category)?trim($apiFilter->category):"")
                );
            }
        }
        
         if (isset($_POST['GwsProductApiFilterForm']) && isset($_POST['api-clear-form'])) {
             $apiFilter->unsetAttributes();
         }

        

        $dataProvider = GwsProductApi::dataProvider($postFields);
        $apiResponse = GwsProductApi::getApiResponse();

       
        
        $this->render('admin', array(
            'apiFilter' => $apiFilter,
            'rawDatafiltersForm' => null,
            'dataProvider' => $dataProvider,
            'apiResponse' => $apiResponse
        ));
    }

    public function actionSearchProduct() {


        $postFields = GwsProductApi::getDefaultPostFields();



        if (isset($_POST['productCode']) && $productCode = $_POST['productCode']) {

            $postFields["data"] = array(
                "supplier" => "",
                "product_code" => $productCode,
                "product_Name" => "",
                "category" => ""
            );
        }



        $productData = GwsProductApi::productData($postFields);
        
        $response = array();
        if (isset($productData[0]) && $product = $productData[0]) {
            $response['prdlineID'] = 0;
            $response['longdesc'] = $product['long_desc'];
            $response['shortdesc'] = $product['short_desc'];
            $response['prdcode'] = $product['pro_code'];
            $response['prdimg'] = GwsProductApi::getImageFile($product);
            $response['pdluntprice'] = $product['srp'];
            $response['sellingPrice'] = 0;
            $response['pdlsupmargin'] =  floatval(GlobalVars::get("SupplierMarkUp"));
            $systemFreight = floatval(GlobalVars::get("SystemFreight"));
            $response['systemFreight'] = $systemFreight;
            $response['usdUnitFreightCost'] = 0;
            $response['usdUnitFreightMarkupRate'] = 0;
            $response['quoteLockSellPrice'] = (int) SystemOptions::getOptions()->quoteLockSellPrice ? true : false;
            $response['soLockSellPrice'] = (int) SystemOptions::getOptions()->soLockSellPrice ? true : false;

           if(isset($_POST['saveToLocalDb']) && $_POST['saveToLocalDb']) {
               self::saveToLocalDb($product);
           }
        }
        
        echo json_encode($response);
    }
    
    protected static function saveToLocalDb($apiProduct) {
        $localProduct = ProductLine::model()->find("pdlpdl = '{$apiProduct['pro_code']}'");
        
        if(!$localProduct) {
            $localProduct = new ProductLine();
            $localProduct->pdlprdline = $apiProduct['short_desc'];
            $localProduct->pdlpdl = $apiProduct['pro_code'];
            $localProduct->pdldes = $apiProduct['long_desc'];
            $localProduct->pdlflag = 1;
            $localProduct->pdlimage1 = $apiProduct['image1'];
            $localProduct->pdlimage2 = $apiProduct['image2'];
            $localProduct->pdlimage3 = $apiProduct['image3'];
            
            $supplier = Supplier::model()->find("supsup_fref = '{$apiProduct['supplier']}'");
            if($supplier){
                $localProduct->pdlsupsno = $supplier->supsno;
            }
            
            $localProduct->pdluntprice = $apiProduct['srp'];
            $localProduct->pdlentddt = date('Y-m-d');
            $localProduct->pdlenttime = date('H:i:s');
            $localProduct->pdlucdnew = Yii::app()->user->username;
            $localProduct->product_source = ProductLine::PRODUCT_SOURCE_GWS_API;
            
            return $localProduct->save(false);
            
        }
        
        return false;
    }

}
