<?php

class InternalJobsController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
			'rights',
			//'accessControl', // perform access control for CRUD operations
		);
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'jobdone', 'print', 'pendingArtwork'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {


        $model = $this->loadModel($id);

        $job = Jobs::model()->findByPk($model->job_id);

        

        


        $this->render('view', array(
            'model' => $model,
            'job' => $job,
            
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {

        $model = new InternalJobs;
        $followupdate = strtotime("+6 day");
        $model->followupDate = date(GlobalVars::get("DateFormat"), $followupdate);

        $jobid = $_GET['job_id'];
        $jobdecorationStrIds = str_replace('_', ',', $_GET['jd_ids']);


        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['InternalJobs']) && isset($_POST['yt0'])) {

            $model->attributes = $_POST['InternalJobs'];
            $job_decoration_ids = $_POST['JobDecorations']['ids'];

            $this->saveImage($model);
            $model->job_id = $jobid;
            
            $model->internaljobType = 'Artwork';
            $model->status_id = 1; //New
            $model->followupDate = date('Y-m-d H:s:i',  strtotime($model->followupDate));
            $model->dueDate = date('Y-m-d H:s:i',  strtotime($model->dueDate));
            $model->user_id = Yii::app()->user->id;
            $model->createdDtm = date('Y-m-d H:s:i');

            if ($model->save()) {
                $interjobnum = sprintf("%06s", $model->id);
                $model->interjobnum = 'IJ' . $interjobnum;

                $slogdetails = "";
                foreach ($job_decoration_ids as $key => $val) {

                    $job_decoration = JobDecorations::model()->findByPk($val);
                    $wrkorddtl = Workorderdetails::model()->findByPk($job_decoration->workorderDtl_id);

                    $slogdetails .=!empty($wrkorddtl->productsku) ? $wrkorddtl->prdsrtdesc . " x {$wrkorddtl->prodQty}," : $wrkorddtl->custmproduct . " x {$wrkorddtl->prodQty},";

                    $internalJbDtls = new InternalJobsDetails();
                    $internalJbDtls->internalJob_id = $model->id;
                    $internalJbDtls->wrkorder_id = $wrkorddtl->workorderId;
                    $internalJbDtls->wrkordrDtl_id = $wrkorddtl->id;
                    $internalJbDtls->jobflow_id = $val;

                    $internalJbDtls->save();


                    $job_decoration->isInternalJob = 1;
                    $job_decoration->internalJob_id = $model->id;
                    $job_decoration->decoJobType = 'Artwork Internal';
                    $job_decoration->status_id = 10; //Internal Proccessing
                    $job_decoration->user_id = Yii::app()->user->id;
                    $job_decoration->createdDtm = date('Y-m-d H:s:i');

                    $job_decoration->save();

                    $jobactivityflow = new JobActivityFlow();
                    $jobactivityflow->job_id = $jobid;
                    $jobactivityflow->wrkorder_id = $wrkorddtl->workorderId;
                    $jobactivityflow->wrkorderDtl_id = $wrkorddtl->id;
                    $jobactivityflow->type = 'Decoration';
                    $jobactivityflow->activity = 'Artwork Processing';
                    $jobactivityflow->flowjob_id = $val;
                    $jobactivityflow->save();
                }

                $model->job->status_id = 18; //Job In Progressing
                $model->job->save();
                $url = Yii::app()->createUrl('internalJobs/view',array("id" => $model->id));
                $link = CHtml::link($model->interjobnum, $url, array('target'=>'_blank'));
                SalesLog::createSalesLogWithFollowup($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', "An artwork ({$link}) is processing for the decoration of products ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);



                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $dataProvider = new CActiveDataProvider('JobDecorations', array(
            'criteria' => array(
                'condition' => " id in ({$jobdecorationStrIds})",
            ),
            'pagination' => false,
        ));

        $this->render('create', array(
            'model' => $model,
            'dataProvider' => $dataProvider,
        ));
    }

    private $image_path = '/images/artwork/';

    private function saveImage($model) {


        ////////////////
        $uploadedFile = CUploadedFile::getInstance($model, 'image');

        //print_r($uploadedFile);
        $path = '';

        if (is_object($uploadedFile)) {
            $fileName = $uploadedFile->getName();

            $model->image = $fileName;

            $path = Yii::app()->basePath . "/.." . $this->image_path . $fileName;



            $uploadedFile->saveAs($path);


            //$image = Yii::app()->image->load($path);
            //$image->resize(250, 250);
            //$image->save();
        }


        return $model;
    }

    private function getInterJobCount($jobid) {
        $interjobs = InternalJobs::model()->findAll("job_id = '{$jobid}'");
        return count($interjobs);
    }

    public function actionJobdone($id) {

        $model = $this->loadModel($id);
        $jobdtls = InternalJobsDetails::model()->findAll("internalJob_id = '{$model->id}'");

        $job = Jobs::model()->findByPk($model->job_id);

        $artworkinventory = new InventoryArtWork();
        $artworkinventory->job_id = $model->job_id;


        $artworkinventory->wrkord_id = $job->workorder_id;
        $artworkinventory->internaljob_id = $model->id;

        $artworkcount = count(InventoryArtWork::model()->findAll('job_id = "' . $job->id . '"'));
        $artworkinventory->artworkcode = 'AW/' . $job->quoteNum . '/' . (1 + $artworkcount);
        $artworkinventory->image = $model->image;
        $artworkinventory->createdDate = date('Y-m-d H:i:s a');
        $artworkinventory->user_id = Yii::app()->user->id;


        if ($artworkinventory->save()) {
            $model->status_id = 11; //Job Done
            if ($model->save()) {

                foreach ($jobdtls as $dtl) {
                    $jobactflow = JobActivityFlow::model()->find("job_id = '$job->id' and wrkorder_id = '$job->workorder_id' and wrkorderDtl_id = '$dtl->wrkordrDtl_id' and type = 'Decoration' and activity = 'Artwork Processing' and flowjob_id = '$dtl->jobflow_id'");

                    $jobactflow->activity = 'Artwork Done';
                    $jobactflow->save();


                    $jobdecoration = JobDecorations::model()->findByPk($dtl->jobflow_id);
                    $jobdecoration->status_id = 11; //Job Done
                    $jobdecoration->save();
                }
            }
            
            $url = Yii::app()->createUrl('internalJobs/view',array("id" => $model->id));
            $link = CHtml::link($model->interjobnum, $url, array('target'=>'_blank'));
            SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', "Artwork ({$artworkinventory->artworkcode}) is created for the internal job {$link}", 1, 1, 1);

            Yii::app()->user->setFlash('success', "Artwork ({$artworkinventory->artworkcode}) is created for the internal job {$model->interjobnum}");
            $this->redirect(array('view', 'id' => $model->id));
        }

        $this->redirect(array('admin', 'id' => $model->id));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['InternalJobs'])) {
            $model->attributes = $_POST['InternalJobs'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);
            $interjobdtls = InternalJobsDetails::model()->findAll(array('condition'=>"internalJob_id = '{$model->id}'"));
            foreach ($interjobdtls as $dtl){
                $activityflow = JobActivityFlow::model()->find(array('condition'=>"wrkorder_id = '{$dtl->wrkorder_id}' and wrkorderDtl_id = '{$dtl->wrkordrDtl_id}' and type = 'Decoration' and flowjob_id = '{$dtl->jobflow_id}'"));
                if(!empty($activityflow))$activityflow->delete();
                $dtl->delete();
            }
            
            $model->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('InternalJobs');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new InternalJobs('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['InternalJobs']))
            $model->attributes = $_GET['InternalJobs'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }
    
    public function actionPendingArtwork() {
        $model = new InternalJobs('searchpendingartwork');
        $model->unsetAttributes();  // clear any default values
        if (isset($_POST['InternalJobs']))
            $model->attributes = $_POST['InternalJobs'];

        $this->render('pending_artwork', array(
            'model' => $model,
        ));
    }

    public function actionPrint($id) {
        $model = $this->loadModel($id);
        $url = Yii::app()->createUrl('internalJobs/view',array("id" => $model->id));
        $link = CHtml::link($model->interjobnum, $url, array('target'=>'_blank'));
        $slog = SalesLog::model()->find("comments = 'Internal Job ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->job->quote_id, $model->job->workorder->id, $model->job->quoteNum, 'Job', "Internal Job ({$link}) is printed", 1, 1, 1);
            SalesLog::createSalesLog($model->job->quote_id, $model->job->workorder->id, $model->job->quoteNum, $model->interjobnum, "Internal Job ({$link}) is printed", 1, 1, 1);
        }


        $pdf = Yii::createComponent('application.extensions.tcpdf.ETcPdf', 'P', 'cm', 'A4', true, 'UTF-8');
// create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


        spl_autoload_register(array('YiiBase', 'autoload'));

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Aranxa');
        $pdf->SetTitle($this->pageTitle . ' - Internal Job');
        $pdf->SetSubject('Internal Job');
// set default header data



        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, null, null);

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetFont('helvetica', '', 8, 'helvetica,Arial, sans-serif');
        $pdf->SetTextColor(0, 0, 0);
        $pdf->AddPage();

//Write the html
//Convert the Html to a pdf document
        
        $html .= '<table style="width:100%;">
                    <tr><td style="width:100%;text-align:center;font-size:2em;">INTERNAL JOB (' . $model->internaljobType . ')</td></tr>
                    <tr><td style="width:100%;text-align:center;font-size:2em;">' . $model->interjobnum . '</td></tr>    
                  </table><br/><br/>';
        
        $html .= '<table style="width:100%;border-bottom:1px solid black;border-top:1px solid black;padding:5px;">';

        $html .= '<tr><td style="width:50%;font-size:1.2em;"></td><td style="width:50%;font-size:1.2em;text-align:right;">Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->createdDtm)) . '</td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Quotation Number : ' . $model->job->quoteNum . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Job Number : ' . $model->job->jobNum . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Status : ' . Status::model()->findByPk($model->status_id)->name . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Created By : ' . User::model()->findByPk($model->user_id)->username . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->createdDtm)) . ' </td></tr>';

        $html .= '</table><br/>';


        $html .= '<table style="width:100%;border-bottom:1px solid black;padding:5px;">';
        $imghtml = '';

        if (!empty($model->image) && file_exists('images/artwork/' . $model->image)) {
            $imghtml = '<img src="images/artwork/' . $model->image . '" style="max-width:150px;max-height:150px;width:auto;height:auto;"/>';
        } else {
            $imghtml = ' - No Image';
        }

        $html .= '<tr><td style="width:20%;font-size:1.2em;">Artwork Image </td><td style="width:80%;font-size:1.2em;text-align:left;"> ' . $imghtml . '  </td></tr>';


        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Comments : ' . $model->notation . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Quantity : 1 </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Follow Up Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->followupDate)) . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Expected Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)) . ' </td></tr>';

        $html .= '</table><br/>';

//        $html .= '<br/><br/><br/><br/><table style="width:100%;">';
//
//        $html .= '<tr>
//                    <td style="width:50%;font-size:1.2em;text-align:center;">Customer Signature</td>
//                    <td style="width:50%;font-size:1.2em;text-align:center;">Authorized Officer</td>
//                  </tr>';
//
//
//        $html .= '</table><br/>';





// data loading
        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->lastPage();
        
        $filename = str_replace("/","-",$model->interjobnum);
//Close and output PDF document
        $pdf->Output("{$filename}.pdf", 'I');
        Yii::app()->end();
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = InternalJobs::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'internal-jobs-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
