<?php

class InvoiceController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('index', 'view', 'create', 'update', 'admin',
                    'delete', 'print', 'updatespecialcmnt', 'ajaxSendPDFCSV', 'ajaxTotal', 'xeroUpdate', 'approve'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $model = $this->loadModel($id);
        //$job = Jobs::model()->findByPk($model->job_id);


        $invoiceDtls = InvoiceDetail::model()->findAll("invoice_id = '{$model->id}'");
        $wrkorderIds = array();
        $invoiceDtlIds = array();
        foreach ($invoiceDtls as $dtl) {
            $wrkorderIds[] = $dtl->wrkorderDtl_id;
            $invoiceDtlIds[] = $dtl->id;
        }

        $wrkorderIdsStr = implode(',', $wrkorderIds);

        $invoiceDtlsStr = implode(',', $invoiceDtlIds);
        if (!$invoiceDtlsStr) {
            $invoiceDtlsStr = '-1';
        }
        $invoiceDtlsDataProvider = new CActiveDataProvider('InvoiceDetail', array(
            'criteria' => array(
                'condition' => " id in ({$invoiceDtlsStr})",
            ),
            'pagination' => false,
        ));


        $deliverydockDtls = DeliveryDocketDetails::model()->findAll("invoiceid = '{$model->id}' ");
        $deliverydocketDtlsIds = array();
        foreach ($deliverydockDtls as $dtl) {
            $deliverydocketDtlsIds[] = $dtl->id;
        }
        $deliverydocketDtlsStr = implode(',', $deliverydocketDtlsIds);
        $deliverydocketDtlsDataProvider = new CActiveDataProvider('DeliveryDockets', array(
            'criteria' => array(
                'condition' => " id in ({$deliverydocketDtlsStr})",
            ),
            'pagination' => false,
        ));

        if (isset($_GET['xr'])) {
            Yii::app()->user->setFlash('success', "Invoice is successfully updated on Xero!");
        } else if (isset($_GET['xrp'])) {
            Yii::app()->user->setFlash('success', "Invoice payment is successfully updated on Xero!");
        } else if (isset($_GET['xrerr'])) {
            Yii::app()->user->setFlash('error', $_GET['xrerr']);
        }

        $response = $model->json_response;


        $this->render('view', array(
            'model' => $model,
            'invoiceDtlsDataProvider' => $invoiceDtlsDataProvider,
            'deliverydocketDtlsDataProvider' => $deliverydocketDtlsDataProvider,
            'response' => $response
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        //print_r($_POST);
        $model = new Invoice;
        $job = null;

        if (isset($_GET['id'])) {
            $job = Jobs::model()->findByPk($_GET['id']);
            //set due date based on customer terms
            if (!empty($job->customer)) {
                //due date setting first scenario - based on customer

                $payment_days_type;
                $payemnt_days = $job->customer->invoiceDueInXDays;


                if ($payemnt_days) {
                    $model->duedate = date(GlobalVars::get('DateFormat'), strtotime('now'));
                } else {
                    $model->duedate = date(GlobalVars::get('DateFormat'), strtotime("+{$payemnt_days} days"));
                }



                //due date setting - second scenario - based on system setting
                $systemPaymentTerm = PaymentTerm::model()->findByPk(SystemOptions::getOptions()->payment_type_id);
                if ($systemPaymentTerm) {
                    $payment_days_type = $systemPaymentTerm->type;
                    $payemnt_days = SystemOptions::getOptions()->payment_type_days ?: $systemPaymentTerm->days;
                }


                //due date setting third scenario - basaed on master customer payment terms - override first scenario
                $masterCustomer = $job->customer->master;

                if ($masterCustomer) {

                    $systemPaymentTerm = PaymentTerm::model()->findByPk($masterCustomer->payment_type_id);
                    if ($systemPaymentTerm) {
                        $payment_days_type = $systemPaymentTerm->type;
                        $payemnt_days = $masterCustomer->payment_type_days ?: $payemnt_days;
                    }
                }

                switch ($payment_days_type) {

                    case PaymentTerm::COD:
                        $model->duedate = date(GlobalVars::get('DateFormat'), strtotime('now'));
                        break;
                    case PaymentTerm::DAYS_AFTER_BILL_DATE:

                        $model->duedate = date(GlobalVars::get('DateFormat'), strtotime("+{$payemnt_days} days"));
                        break;
                    case PaymentTerm::OF_FOLLOWING_MONTH:
                        $model->duedate = date(GlobalVars::get('DateFormat'), strtotime("next month +{$payemnt_days} days"));
                        break;
                }
            }

            $model->surcharge_id = $job->workorder->surcharge_id;
            $model->surcharge_rate = $job->workorder->surcharge_rate;
        } else {
            Yii::app()->user->setFlash('error', "Cannot Proceed. You are trying to create an invoice without a job!");
            $this->redirect(array('admin'));
        }



        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Invoice'])) {
            $model->attributes = $_POST['Invoice'];
            $job = Jobs::model()->findByPk($model->job_id);
            //if($model->save())$this->redirect(array('view','id'=>$model->id));
        }

        if (isset($_POST['yt0']) && isset($_POST['available-invoice-details-grid_c0'])) {
            $model->quote_id = $job->quote_id;
            $model->quoteNum = $job->quoteNum;

            $model->customer_id = $job->customer->cussno;
            $model->createdDtm = date('Y-m-d H:i:s');
            $model->duedate = date('Y-m-d', strtotime($model->duedate));
            $model->createdBy = Yii::app()->user->id;
            $model->status_id = 1; //New

            $model->surcharge_id = $_POST['Invoice']['surcharge_id'];
            $model->surcharge_rate = $_POST['Invoice']['surcharge_rate'];

            if ($model->save()) {

                $model->invoiceNum = GlobalVars::get(GlobalVars::INVOICE_PREFIX) . (8000 + $model->id);
                $wrkorderDtlsarr = $_POST['available-invoice-details-grid_c0'];

                $totExVat = 0;
                $totIncvat = 0;

                foreach ($wrkorderDtlsarr as $dtl) {
                    $wrkorderDtl = Workorderdetails::model()->findByPk($dtl);

                    $invoicedtls = new InvoiceDetail();
                    $invoicedtls->invoice_id = $model->id;
                    $invoicedtls->quote_id = $model->quote_id;
                    $invoicedtls->job_id = $model->job_id;
                    $invoicedtls->workorder_id = $wrkorderDtl->workorderId;
                    $invoicedtls->wrkorderDtl_id = $dtl;
                    $invoicedtls->qty = $_POST['Workorderdetails']['prodQty'][$wrkorderDtl->id];
                    $invoicedtls->sellPriceExVat = $wrkorderDtl->sellPriceExVat;
                    $invoicedtls->sellPriceIncVat = $wrkorderDtl->sellPriceIncVat;
                    $invoicedtls->totExVat = $wrkorderDtl->sellPriceExVat * $invoicedtls->qty;
                    $invoicedtls->totIncVat = $wrkorderDtl->sellPriceIncVat * $invoicedtls->qty;

                    if ((int) SystemOptions::getOptions()->enbleXero && isset($_POST['Workorderdetails']['xero_account_id'])) { // Xero must be enable in system settings to be available this value
                        $invoicedtls->xero_account_id = $_POST['Workorderdetails']['xero_account_id'][$wrkorderDtl->id];
                    }

                    if (isset($_POST['Workorderdetails']['systemTaxRateId'])) {
                        $invoicedtls->systemTaxRateId = $_POST['Workorderdetails']['systemTaxRateId'][$wrkorderDtl->id];
                    }


                    $invoicedtls->save();
                    $totExVat += $invoicedtls->totExVat;
                    $totIncvat += $invoicedtls->totIncVat;
                }

                $model->amountExVat = $totExVat;
                $model->amountIncVat = $totIncvat;

                $model->save();

                //DeliveryDockets::model()->updateAll(array('invoiceId'=>$model->id),"jobId = '{$model->job->id}'");
                $url = Yii::app()->createUrl('invoice/view', array("id" => $model->id));
                $link = CHtml::link($model->invoiceNum, $url, array('target' => '_blank'));

                SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Job', "Invoice ({$link}) is created", 1, 1, 1);
                SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Job', "All delivery dockets related to the job is updated with the invoice  ({$link})", 1, 1, 1);

                SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Invoice', "Invoice ({$link}) is created", 1, 1, 1);

                $this->writeCsv($model);
                SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Job', "CSV file ({$model->invoiceNum}.csv) is created", 1, 1, 1);
                SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Invoice', "CSV file ({$model->invoiceNum}.csv) is created", 1, 1, 1);

                //$this->sendPDFCSV($model->id);
            }
            Yii::app()->user->setFlash('success', "Invoice ({$model->invoiceNum}) has been created successfully!");
            $this->redirect(array('view', 'id' => $model->id));
        } else {
            Yii::app()->user->setFlash('notice', "Please select products to invoice.");
        }

        $this->render('create', array(
            'model' => $model,
            'job' => $job,
        ));
    }

    private function writeCsv($model) {
        $invoiceDetails = InvoiceDetail::model()->findAll("invoice_id = '{$model->id}'");
        $salesperson = $model->job->workorder->quotation->ws_user;
        $namearr = explode(" ", $salesperson);
        $salespersonFirstName = strtoupper($namearr[0]);
        $salespersonLastname = '';
        foreach ($namearr as $key => $val) {
            if ($key != 0) {
                $salespersonLastname .= strtoupper($val) . " ";
            }
        }

        $csvheaders = 'Co./Last Name,First Name,Addr 1 - Line 1, - Line 2, - Line 3, - Line 4,Inclusive,Invoice #,Date,Customer PO,Ship Via,Delivery Status,Item Number,Quantity,Description,Price,Inc-Tax Price,Discount,Total,Inc-Tax Total,Job,Comment,Journal Memo,Salesperson Last Name,Salesperson First Name,Shipping Date,Referral Source,Tax Code,Non-GST Amount,GST Amount,LCT Amount,Freight Amount,Inc-Tax Freight Amount,Freight Tax Code,Freight Non-GST Amount,Freight GST Amount,Freight LCT Amount,Sale Status,Currency Code,Exchange Rate,Terms - Payment is Due,- Discount Days,- Balance Due Days,- % Discount,- % Monthly Charge,Amount Paid,Payment Method,Payment Notes,Name on Card,Card Number,Expiry Date,Authorisation Code,BSB,Account Number,Drawer/Account Name,Cheque Number,Category,Location ID,Card ID,Record ID' . "\n";
        $csv = '';




        $date = date("j/n/Y", strtotime(str_replace('-', '/', $model->createdDtm)));
        foreach ($invoiceDetails as $dtl) {
            $csv .= strtoupper(Yii::app()->params['companyName']) . ',,,,,,,';
            $csv .= $model->invoiceNum . ',' . $date . ',';
            $csv .= ucwords($model->customer->cusnam) . ',,P,';
            $csv .= $dtl->workorderdtl->productsku . ',' . $dtl->qty . ',' . $dtl->workorderdtl->prdsrtdesc . ',' . $dtl->sellPriceExVat . ',' . $dtl->sellPriceIncVat . ',,' . $dtl->totExVat . ',' . $dtl->totIncVat . ',,';
            $csv .= $model->comments . '  ' . $model->specialcmnt . ',,' . $salespersonLastname . ',' . $salespersonFirstName . ',,,,,';
            $csv .= number_format(($dtl->totIncVat - $dtl->totExVat), 2) . ',,,,,,,,';
            $csv .= 'Q,,,,,,,,,,,,,,,,,,,,,,';
            $csv .= $model->id . "\n";
        }

        $fullcsv = $csvheaders . $csv;

        $webroot = Yii::getPathOfAlias('webroot');
        $file = $webroot . DIRECTORY_SEPARATOR . 'csvinvoices' . DIRECTORY_SEPARATOR . $model->invoiceNum . '.csv';
        $csv_handler = fopen($file, 'w');
        fwrite($csv_handler, $fullcsv);
        fclose($csv_handler);

        $fileinventory = new FileInventory();
        $fileinventory->filename = $model->invoiceNum . '.csv';
        $fileinventory->type = 'CSV';
        $fileinventory->ref_id = $model->id;
        $fileinventory->save();
    }

    private function sendPDFCSV($id) {
        $model = $this->loadModel($id);
        $recipient = GlobalVars::model()->find(array("condition" => "globalVar = 'AdminEmail'"))->value;
        $parms_arr = array('show_price' => true, 'show_decoration' => true
            , 'show_custmizedtl' => true, 'show_notes' => true);
        $fileinventoryPDF = FileInventory::model()->find("type = 'INV' and ref_id = '$model->id'");
        if (empty($fileinventoryPDF))
            $fileinventoryPDF = $model->generatePDF($parms_arr);


        $fileinventoryCSV = FileInventory::model()->find("type = 'CSV' and ref_id = '$model->id'");
        if (empty($fileinventoryCSV))
            $this->writeCsv($model);

        $mailer = Yii::app()->MultiMailer->to($recipient, 'Recipient');
        $mailer->subject('Invoice PDF & CSV Files of ' . $model->invoiceNum);
        $mailer->body('Please find the attached CSV & PDF files for the invoice number : ' . $model->invoiceNum . ' herewith.');
        $mailer->attachment('files/' . (empty($fileinventoryPDF) ? ($model->invoiceNum . '.pdf') : $fileinventoryPDF->filename));
        $mailer->attachment('csvinvoices/' . (empty($fileinventoryCSV) ? ($model->invoiceNum . '.csv') : $fileinventoryCSV->filename));

        if ($mailer->send()) {
            return true;
        } else
            return false;
    }

    public function actionAjaxSendPDFCSV() {

        $id = $_POST['id'];
        $model = $this->loadModel($id);
        $recipient = GlobalVars::model()->find(array("condition" => "globalVar = 'AdminEmail'"))->value;

        $arr = array();
        if ($this->sendPDFCSV($id)) {
            $arr['status'] = 'success';
            $arr['inv_num'] = $model->invoiceNum;
            $arr['recipient_email'] = $recipient;
        } else {
            $arr['status'] = 'failed';
            $arr['inv_num'] = $model->invoiceNum;
            $arr['recipient_email'] = $recipient;
        }

        echo json_encode($arr);
    }

    private function getInvoiceCount($quoteid) {
        $invs = Invoice::model()->findAll("quote_id = '{$quoteid}'");
        return count($invs);
    }

    var $show_custmizedtl = true;
    var $show_notes = true;
    var $prod_column_width = 18;
    var $deco_column_width = 25;
    var $qty_column_width = 5;
    var $cost_column_width = 8;
    var $cutmz_column_width = 45;
    var $notes_column_width = 55;

    public function actionPrint($id) {
        $model = $this->loadModel($id);

        $show_price = isset($_GET['price_show']) ? filter_var($_GET['price_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $show_decoration = isset($_GET['deco_show']) ? filter_var($_GET['deco_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $lngdesc_show = isset($_GET['lngdesc_show']) ? filter_var($_GET['lngdesc_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $seperate_lines_show = isset($_GET['seperate_lines_show']) ? filter_var($_GET['seperate_lines_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $this->show_custmizedtl = isset($_GET['cutmz_show']) ? filter_var($_GET['cutmz_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $this->show_notes = isset($_GET['notes_show']) ? filter_var($_GET['notes_show'], FILTER_VALIDATE_BOOLEAN) : false;


        //payment term text
        $paymentTermText = '';
        //due date setting - second scenario - based on system setting
        $systemPaymentTerm = PaymentTerm::model()->findByPk(SystemOptions::getOptions()->payment_type_id);
        if ($systemPaymentTerm) {
            $paymentTermText =  $systemPaymentTerm->display_text;            
        }


       $masterCustomer = $model->job->customer->master;

        if ($masterCustomer) {

            $systemPaymentTerm = PaymentTerm::model()->findByPk($masterCustomer->payment_type_id);
            if ($systemPaymentTerm) {
                 $paymentTermText =  $systemPaymentTerm->display_text;      
            }
        }

        $url = Yii::app()->createUrl('invoice/view', array("id" => $model->id));
        $link = CHtml::link($model->invoiceNum, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'Invoice ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Invoice', "Invoice ({$link}) is printed", 1, 1, 1);
        }

        if (!$seperate_lines_show) {
            $htmlcontent = $this->renderInternal('protected/views/invoice/pdf_html.php', array('model' => $model, 'show_price' => $show_price, 'show_decoration' => $show_decoration,
                'show_custmizedtl' => $this->show_custmizedtl, 'show_notes' => $this->show_notes, 'lngdesc_show' => $lngdesc_show, 'paymentTermText' => $paymentTermText), true);
        } else {
            $htmlcontent = $this->renderInternal('protected/views/invoice/line_seperated_pdf_html.php', array('model' => $model, 'show_price' => $show_price, 'show_decoration' => $show_decoration,
                'show_custmizedtl' => $this->show_custmizedtl, 'show_notes' => $this->show_notes, 'lngdesc_show' => $lngdesc_show, 'paymentTermText' => $paymentTermText), true);
        }

        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        $mpdf = new MpsInvoicePdf;
        $mpdf->setMode(MpsPdf::MODE_CONTENT_GENERATOR)
            ->setModel($model)
            ->generate($htmlcontent)
            ->output("{$sitePrefix}_Invoice{$model->invoiceNum}");
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        //print_r($_POST);
        $model = $this->loadModel($id);
        if (in_array($model->duedate, array('0000-00-00 00:00:00', null, '1970-01-01 00:00:00', '1969-12-12 00:00:00'))) {
            $dueinXDays = 0;
            if (!empty($model->job->customer)) {
                if (empty($model->job->customer->invoiceDueInXDays)) {
                    $dueinXDays = 0;
                } else {
                    $dueinXDays = $model->job->customer->invoiceDueInXDays;
                }
            }
            $createddate = date('Y-m-d', strtotime($model->createdDtm));
            if (empty($dueinXDays)) {
                $model->duedate = $model->createdDtm;
            } else {
                $model->duedate = date('Y-m-d', strtotime($createddate . " +{$dueinXDays} days"));
            }
        }
        $model->duedate = date(GlobalVars::get("DateFormat"), strtotime($model->duedate));

        $job = Jobs::model()->findByPk($model->job_id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);
        /*
          if (isset($_POST['Invoice']) && isset($_POST['yt0']) && !empty($model)) {

          $duedate = (isset($_POST['Invoice']['duedate']) ? $_POST['Invoice']['duedate'] : null);
          $comments = (isset($_POST['Invoice']['comments']) ? $_POST['Invoice']['comments'] : '');
          $specialcmnt = (isset($_POST['Invoice']['specialcmnt']) ? $_POST['Invoice']['specialcmnt'] : '');

          if (empty($duedate)) {
          $model->duedate = date('Y-m-d', strtotime($model->createdDtm));
          } else {
          $model->duedate = date('Y-m-d', strtotime($duedate));
          }


          $model->comments = $comments;
          $model->specialcmnt = $specialcmnt;
          $model->save(false);
          //if($model->save())$this->redirect(array('view','id'=>$model->id));
          }


          if (isset($_POST['yt0']) && isset($_POST['available-invoice-details-grid_c0'])) {


          if (!empty($model)) {
          $invoiceDtlsarr = $_POST['available-invoice-details-grid_c0'];


          foreach ($invoiceDtlsarr as $dtl) {
          $invoicedtl = InvoiceDetail::model()->findByPk($dtl);

          if (isset($_POST['InvoiceDetail']['qty'][$invoicedtl->id])) {
          $invoicedtl->qty = $_POST['InvoiceDetail']['qty'][$invoicedtl->id];
          $invoicedtl->totExVat = $invoicedtl->qty * $invoicedtl->sellPriceExVat;
          $invoicedtl->totIncVat = $invoicedtl->qty * $invoicedtl->sellPriceIncVat;

          if ((int) SystemOptions::getOptions()->enbleXero && isset($_POST['InvoiceDetail']['xero_account_id'])) { // Xero must be enable in system settings to be available this value
          $invoicedtl->xero_account_id = $_POST['InvoiceDetail']['xero_account_id'][$invoicedtl->id];
          }

          if (isset($_POST['InvoiceDetail']['systemTaxRateId'])) {
          $invoicedtl->systemTaxRateId = $_POST['InvoiceDetail']['systemTaxRateId'][$invoicedtl->id];
          }
          }


          $invoicedtl->save();
          }

          $url = Yii::app()->createUrl('invoice/view', array("id" => $model->id));
          $link = CHtml::link($model->invoiceNum, $url, array('target' => '_blank'));

          DeliveryDockets::model()->updateAll(array('invoiceId' => $model->id), "jobId = '{$model->job->id}'");

          SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Job', "Invoice details of ({$link}) are updated", 1, 1, 1);
          SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Job', "All delivery dockets related to the job is updated with the invoice  ({$link})", 1, 1, 1);
          SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Invoice', "Invoice details of ({$link}) are updated", 1, 1, 1);

          $this->redirect(array('view', 'id' => $model->id));
          }
          } else {
          Yii::app()->user->setFlash('notice', "Please select products to invoice.");
          }

         */

        $this->render('update', array(
            'model' => $model,
            'job' => $job,
        ));
    }

    public function actionUpdateInvoiceViaAjax() {

        $id = $_POST['Invoice']['id'];
        $model = $this->loadModel($id);
        $comments = $_POST['Invoice']['comments'];
        $specialcmnt = $_POST['Invoice']['specialcmnt'];

        $duedate = $_POST['Invoice']['duedate'];

        $model->comments = $comments;
        $model->specialcmnt = $specialcmnt;

        $postedDateTime = DateTime::createFromFormat(GlobalVars::get(GlobalVars::DATE_FORMAT), $duedate);
        $dueDateSQLFormatted = $postedDateTime->format('Y-m-d');
        $model->duedate = $dueDateSQLFormatted;

        if ($model->save()) {
            $url = Yii::app()->createUrl('invoice/view', array("id" => $model->id));
            $link = CHtml::link($model->invoiceNum, $url, array('target' => '_blank'));

            $comment = "Invoice ({$link}) header has been updated";

            SalesLog::createSalesLogTblId($model->quote_id, $model->job->workorder->id, $model->quoteNum, $model->job->id, 'Job', $comment, 1, 1, 1);
            SalesLog::createSalesLogTblId($model->quote_id, $model->job->workorder->id, $model->quoteNum, $model->id, 'Invoice', $comment, 1, 1, 1);
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => true));
        }
    }

    public function actionUpdatespecialcmnt() {
        $id = $_POST['id'];
        $specialcmnt = $_POST['text'];

        $model = $this->loadModel($id);
        $resultArr = array();
        if (!empty($model)) {

            $model->specialcmnt = $specialcmnt;
            if ($model->save()) {
                $resultArr['status'] = 'success';
            } else {
                $resultArr['status'] = 'error';
            }
        } else {
            $resultArr['status'] = 'error';
        }
        echo json_encode($resultArr);
    }

    public function actionAjaxTotal() {
        $model = $this->loadModel($_POST['id']);
        $totalarr = array();
        $totalarr['sub_total'] = number_format($model->getTotExVat(), 3);
        $totalarr['gst_total'] = number_format($model->getGSTAmnt(), 3);
        $totalarr['total_amount'] = number_format($model->getTotIncVat(), 3);
        $totalarr['paid_amount'] = number_format($model->getPaidAmount(), 3);
        $totalarr['balance_amount'] = number_format($model->getBalanceAmnt(), 3);

        echo json_encode($totalarr);
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);
            if (InvoiceDetail::model()->deleteAll("invoice_id = '$model->id'")) {

                $invoicenum = $model->invoiceNum;
                $quoteid = $model->quote_id;
                $wrkordid = $model->job->workorder_id;
                $quotenum = $model->job->quoteNum;

                $model->delete();

                SalesLog::createSalesLog($quoteid, $wrkordid, $quotenum, 'Job', "Invoice ($invoicenum) is deleted ", 1, 1, 1);
                SalesLog::createSalesLog($quoteid, $wrkordid, $quotenum, 'Quotation', "Invoice ($invoicenum) is deleted ", 1, 1, 1);
            }
            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Invoice');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new Invoice('search');
        if (isset($_GET['Invoice']))
            $model->attributes = $_GET['Invoice'];

        if (isset($_GET['jobid'])) {
            $model->job_id = $_GET['jobid'];
        }

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    public function actionApprove($id) {
        $model = $this->loadModel($id);
        $model->status_id = 25; //Approved

        if ($model->save()) {
            Yii::app()->user->setFlash('success', "Invoice ($model->invoiceNum) approved.");
            $this->redirect(array('view', 'id' => $model->id));
        } else {
            Yii::app()->user->setFlash('notice', "Cannot approve the invoice {$model->invoiceNum}. Please try again.");
            $this->redirect(array('view', 'id' => $model->id));
        }
    }

    public function actionXeroUpdate($id) {
        $show_price = isset($_GET['price_show']) ? filter_var($_GET['price_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $show_decoration = isset($_GET['deco_show']) ? filter_var($_GET['deco_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $lngdesc_show = isset($_GET['lngdesc_show']) ? filter_var($_GET['lngdesc_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $seperate_lines_show = isset($_GET['seperate_lines_show']) ? filter_var($_GET['seperate_lines_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $show_custmizedtl = isset($_GET['cutmz_show']) ? filter_var($_GET['cutmz_show'], FILTER_VALIDATE_BOOLEAN) : false;
        $show_notes = isset($_GET['notes_show']) ? filter_var($_GET['notes_show'], FILTER_VALIDATE_BOOLEAN) : false;

        require 'vendor/autoload.php';

        $storage = new StorageClass();
        if ($storage->getHasExpired()) {
            $this->redirect(array('xeroSetting/settings'));
        }

        $model = $this->loadModel($id);
        $modelDetial = InvoiceDetail::model()->findAll(array('condition' => "invoice_id = '$id'"));
        if ($seperate_lines_show) {
            /* Items are seperated into individual lines. product, decoration, other cost etc. */
            $this->render('_xero_seperate', array(
                'model' => $model,
                'modelDetial' => $modelDetial,
                'queryParams' => array(
                    'show_decoration' => $show_decoration
                )
            ));
        } else {
            /* items are not seperated all details (product + decos + other cost etc.) wrapepd into each line */
            $this->render('xero_private', array(
                'model' => $model,
                'modelDetial' => $modelDetial
            ));
        }
    }

    function persistSession($response) {
        if (isset($response)) {
            $_SESSION['access_token'] = $response['oauth_token'];
            $_SESSION['oauth_token_secret'] = $response['oauth_token_secret'];
            if (isset($response['oauth_session_handle']))
                $_SESSION['session_handle'] = $response['oauth_session_handle'];
        } else {
            return false;
        }
    }

    function retrieveSession() {
        if (isset($_SESSION['access_token'])) {
            $response['oauth_token'] = $_SESSION['access_token'];
            $response['oauth_token_secret'] = $_SESSION['oauth_token_secret'];
            $response['oauth_session_handle'] = $_SESSION['session_handle'];
            return $response;
        } else {
            return false;
        }
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Invoice::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'invoice-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionUploadMyob($id) {

        if (myob_api_oauth::hasAccess()) {


            $model = $this->loadModel($id);
            $invoiceNumber = trim($model->invoiceNum);
            $json = $this->getjson($model);


            if (!empty($model->myob_uuid) && !empty($model->myob_row_version)) {
                //then update

                $response = myob_api_oauth::directPut($json, '/Sale/Order/Item/');
                $decoderes = json_decode($response, true);
                if (isset($decoderes["Errors"]) || isset($decoderes["Message"])) {

                    $response = myob_api_oauth::directGet('/Sale/Order/Item/?$filter=Number+eq+\'' . $invoiceNumber . '\'');
                    $decoderes = json_decode($response, true);
                    if (isset($decoderes["Items"])) {
                        $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'Number', $invoiceNumber);
                        $model->myob_uuid = $myob_res_fields['UID'];
                        $model->myob_row_version = $myob_res_fields['RowVersion'];
                        if ($model->save()) {
                            $this->redirect(array('uploadMyob', 'id' => $id));
                        }
                    }
                }
            } else {

                $response = myob_api_oauth::directGet('/Sale/Order/Item/?$filter=Number+eq+\'' . $invoiceNumber . '\'');
                $decoderes = json_decode($response, true);

                if (isset($decoderes["Items"])) {
                    $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'Number', $invoiceNumber);
                    $model->myob_uuid = $myob_res_fields['UID'];
                    $model->myob_row_version = $myob_res_fields['RowVersion'];
                    $json = $this->getjson($model);

                    if (!empty($model->myob_uuid) && !empty($model->myob_row_version)) {
                        //if so, then update the existing record
                        //$json = $this->getjson($model, $model->myob_uuid);
                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Sale/Order/Item/';
                        $response = myob_api_oauth::putDetails($url, $json);
                    } else {
                        //insert new
                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Sale/Order/Item/';
                        $response = myob_api_oauth::postDetails($url, $json);
                    }
                }
            }

            $decoderes = json_decode($response, true);

            if (isset($decoderes["Errors"]) || isset($decoderes["Message"])) {
                $model->json_response = $response;
                $model->save(false);
                Yii::app()->user->setFlash('notice', "Cannot upload the invoice to MYOB!");
                $url = Yii::app()->createUrl('invoice/view', array("id" => $model->id));
                $link = CHtml::link($model->invoiceNum, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Job', "Invoice ({$link}) uploading is failed on MYOB", 1, 1, 1);

                SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Invoice', "Invoice ({$link}) uploading is failed on MYOB", 1, 1, 1);
            } else {
                $response = myob_api_oauth::directGet('/Sale/Order/Item/?$filter=Number+eq+\'' . $invoiceNumber . '\'');

                $model->json_response = '';
                $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'Number', $invoiceNumber);
                $model->myob_uuid = $myob_res_fields['UID'];
                $model->myob_row_version = $myob_res_fields['RowVersion'];
                $model->save(false);
                Yii::app()->user->setFlash('success', "The invoice has been uploaded to MYOB!");
                $url = Yii::app()->createUrl('invoice/view', array("id" => $model->id));
                $link = CHtml::link($model->invoiceNum, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Job', "Invoice ({$link}) has been uploaded to MYOB ", 1, 1, 1);

                SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Invoice', "Invoice ({$link}) has been uploaded to MYOB", 1, 1, 1);
            }
            Yii::app()->session['myob_inv'] = $id;

            $this->redirect(array('view', 'id' => $id));
        } else {
            //not connected to myob or session expired
            Yii::app()->user->setFlash('notice', "MYOB session has been expired! Please connect to MYOB first!");
            $this->redirect(array('view', 'id' => $id));
        }
    }

    private function getjson($model) {

        //required - customer, Lines[].TaxCode, Item.UID
        //upload customer if MYOB doesn't have
        $myobsettings = MyobSetting::getSettings();

        $customerrel = $model->job->workorder->quotation->customer;
        $masterCustomer = $customerrel->master;
        if (!$customerrel) {
            Yii::app()->user->setFlash('notice', "Cannot proceed MYOB uploading. No customer detected!");
            $this->redirect(array('view', 'id' => $model->id));
        }

        if (!$masterCustomer) {
            Yii::app()->user->setFlash('notice', "Cannot proceed MYOB uploading. No master customer detected!");
            $this->redirect(array('view', 'id' => $model->id));
        }


        //first check
        if (!$masterCustomer->myob_uuid) {

            /*
             * Anyway first make sure customer is in MYOB or not
             * 
             */

            /*
             * get uploaded customers
             * find related (this) customer from MYOB response
             * and update the customer table with UID
             */
            $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=DisplayID+eq+\'' . $masterCustomer->displayIdMYOB . '\'';
            $customerResponse = myob_api_oauth::getDetails($url);
            $cusdecoderes = json_decode($customerResponse, true);

            if (isset($cusdecoderes["Items"])) {
                $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($customerResponse, 'DisplayID', $masterCustomer->displayIdMYOB);
                $masterCustomer->myob_uuid = $myob_res_fields['UID'];
                $masterCustomer->myob_row_version = $myob_res_fields['RowVersion'];
                $masterCustomer->save(false);
            }

            //second check
            if (!$masterCustomer->myob_uuid) {

                /*
                 * need to push customer to MYOB
                 * and get the uploaded customers' UID and save into customer table
                 */

                $customerJson = $masterCustomer->getMYOBJson();


                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/';
                $customerResponse = myob_api_oauth::putDetails($url, $customerJson);
                $cusdecoderes = json_decode($customerResponse, true);


                if (isset($cusdecoderes["Errors"]) || isset($cusdecoderes["Message"])) {
                    $model->json_response = $customerResponse;
                    $model->save(false);
                    Yii::app()->user->setFlash('notice', "Cannot upload the customer to MYOB!");
                    $this->redirect(array('view', 'id' => $model->id));
                }

                /*
                 * get uploaded customers
                 * find related (this) customer from MYOB response
                 * and update the customer table with UID
                 */
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=DisplayID+eq+\'' . $masterCustomer->displayIdMYOB . '\'';
                $customerResponse = myob_api_oauth::getDetails($url);
                $cusdecoderes = json_decode($customerResponse, true);


                if (isset($cusdecoderes["Errors"]) || isset($cusdecoderes["Message"])) {
                    $model->json_response = $customerResponse;
                    $model->save(false);
                    Yii::app()->user->setFlash('notice', "Cannot find the customer on MYOB!");
                    $this->redirect(array('view', 'id' => $model->id));
                }

                if (isset($cusdecoderes["Items"])) {
                    $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($customerResponse, 'DisplayID', $masterCustomer->displayIdMYOB);
                    $masterCustomer->myob_uuid = $myob_res_fields['UID'];
                    $masterCustomer->myob_row_version = $myob_res_fields['RowVersion'];
                    $masterCustomer->save(false);
                }
            }
        }
        //end customer uploading process

        /*
         * need to push product items to MYOB if doesn't have
         * and get MYOB UID and save it into product each product table
         */
        foreach ($model->rel_details() as $dtl) {
            $productrel = $dtl->workorderdtl->product;
            //first check
            if (!$productrel->myob_uuid) {

                /*
                 * Anyway check if the item is already there or not
                 * 
                 */

                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Inventory/Item/?$filter=Number+eq+\'' . $productrel->pdlsno . '\'';
                $productResponse = myob_api_oauth::getDetails($url);
                $prddecoderes = json_decode($productResponse, true);

                if (isset($prddecoderes["Items"])) {
                    $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($productResponse, 'Number', $productrel->pdlsno);
                    $productrel->myob_uuid = $myob_res_fields['UID'];
                    $productrel->myob_row_version = $myob_res_fields['RowVersion'];
                    $productrel->save(false);
                }

                //second check
                if (!$productrel->myob_uuid) {

                    $productJson = $productrel->getMYOBJson();
                    $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Inventory/Item/';
                    $productResponse = myob_api_oauth::putDetails($url, $productJson);
                    $prddecoderes = json_decode($productResponse, true);


                    if (isset($prddecoderes["Errors"]) || isset($prddecoderes["Message"])) {
                        $model->json_response = $productResponse;
                        $model->save(false);
                        Yii::app()->user->setFlash('notice', "Cannot upload the product [ " . $productrel->pdlpdl . " ] to MYOB!");
                        $this->redirect(array('view', 'id' => $model->id));
                    }
                    /*
                     * get uploaded products
                     * find related (this) product from MYOB response
                     * and update the product table with UID
                     */
                    $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Inventory/Item/?$filter=Number+eq+\'' . $productrel->pdlsno . '\'';
                    $productResponse = myob_api_oauth::getDetails($url);
                    $prddecoderes = json_decode($productResponse, true);


                    if (isset($prddecoderes["Errors"]) || isset($prddecoderes["Message"])) {
                        $model->json_response = $productResponse;
                        $model->save(false);
                        Yii::app()->user->setFlash('notice', "Cannot find the product [ " . $productrel->pdlpdl . " ] on MYOB!");
                        $this->redirect(array('view', 'id' => $model->id));
                    }

                    if (isset($prddecoderes["Items"])) {
                        $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($productResponse, 'Number', $productrel->pdlsno);
                        $productrel->myob_uuid = $myob_res_fields['UID'];
                        $productrel->myob_row_version = $myob_res_fields['RowVersion'];
                        $productrel->save(false);
                    }
                }
            }
        }

        //end product uploading process

        $customerPO = substr($model->job->customerpono, 0, 20);
        if (!$customerPO) {
            $customerPO = '';
        }

        $invarr = array(
            "Number" => substr($model->invoiceNum, 0, 8),
            "Date" => date('Y-m-d H:i:s', strtotime($model->createdDtm)),
            "CustomerPurchaseOrderNumber" => $customerPO,
            "Customer" => array(
                "UID" => $masterCustomer->myob_uuid,
            //"Name" => substr($model->customer->cusnam, 0, 50),
            //"DisplayID" => $model->customer->cuscus,
            ),
            "PromisedDate" => date('Y-m-d H:i:s', strtotime($model->duedate)),
            "BalanceDueAmount" => "0",
            "Status" => "Open",
            "IsTaxInclusive" => "false",
            "ReferralSource" => $model->job->jobNum
        );

        if (!empty($model->myob_uuid) && !empty($model->myob_row_version)) {
            $invarr["UID"] = $model->myob_uuid;
            $invarr["RowVersion"] = $model->myob_row_version;
        }

        $joburl = Yii::app()->createUrl("jobs/view", array("id" => $model->job->id));


        $taxcode = $model->myobTaxCodeId ? MyobTaxCode::model()->findByPk($model->myobTaxCodeId) : MyobTaxCode::model()->findByPk($myobsettings->inv_taxcode_id);
        $taxcodeuuid = $taxcode ? $taxcode->uuid : null;


        foreach ($model->rel_details() as $dtl) {

            if ($dtl->workorderdtl->product && $dtl->workorderdtl->product->myob_uuid) {
                /*
                 * include product desc + deco desc + size info to description
                 * 
                 */
                $description = '';
                if ($dtl->workorderdtl->prdsrtdesc) {
                    $description .= $dtl->workorderdtl->prdsrtdesc;
                }

                if ($dtl->workorderdtl->decdesc) {
                    $description .= ' / ' . $dtl->workorderdtl->decdesc;
                }

                $sizeqtycolors = Workorderdetailssizecolor::model()
                        ->findAll(array('condition' => 'workOrderDetailsId=:wrkOrdDtlID', 'params' => array(':wrkOrdDtlID' => $dtl->workorderdtl->id)));
                if (count($sizeqtycolors)) {
                    $description .= ' /Sizes:';
                    foreach ($sizeqtycolors as $row) {
                        $description .= ' [ ' . $row['size'] . ' - ' . $row['qty'] . ' - ' . $row['color'] . ' ]';
                    }
                }


                $invarr["Lines"][] = array(
                    //"Type" => "Transaction",                
                    "Description" => substr($description, 0, 255),
                    "ShipQuantity" => $dtl->qty,
                    "UnitPrice" => $dtl->sellPriceExVat,
                    "Total" => $dtl->totExVat,
                    "Item" => array(
                        "UID" => $dtl->workorderdtl->product->myob_uuid,
                        "Number" => $dtl->workorderdtl->product->pdlsno,
                        "Name" => $dtl->workorderdtl->product->pdlpdl,
                    ),
                    "TaxCode" => array(
                        "UID" => $taxcodeuuid,
                    ),
                );
            }
        }

        //$subTotal = round(PriceCalculator::getSubTotal($model), 2);
        //$gstTotal = round(PriceCalculator::getGSTTotal($model), 2);
        //$invarr["IsTaxInclusive"] = true;
        //$invarr["Subtotal"] = $subTotal;
        //$invarr["TotalTax"] = $gstTotal;
        //$invarr["TotalAmount"] = $subTotal + $gstTotal;
        //$invarr["Salesperson"] = $model->job->salesperson->name;
        return json_encode($invarr);
    }

    public function actionCalculateTotal() {

        $workorderId = $_POST['workorderId'];
        $surchargeId = $_POST['surchargeId'];
        $surchargeRate = $_POST['surchargeRate'];

        $workorder = Workorder::model()->findByPk($workorderId);
        $invoice = new Invoice();

        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        $subTotal = round(PriceCalculator::getSubTotal($workorder), $roundingPrecision);
        $subTotalWithSurcharge = $surchargeRate ? ($subTotal * $surchargeRate) : $subTotal;
        $gstTotal = ($subTotalWithSurcharge * floatval(GlobalVars::get('GST'))) - $subTotalWithSurcharge;

        $formatSubTotal = number_format($subTotal, $roundingPrecision);
        $formatGSTTotal = number_format($gstTotal, $roundingPrecision);
        $formattTotal = number_format(($subTotalWithSurcharge + $gstTotal), $roundingPrecision);
        $paidAmount = 0;
        $formatPaidAmount = number_format($paidAmount, $roundingPrecision);
        $balancedAmount = number_format(( round(($subTotalWithSurcharge + $gstTotal), $roundingPrecision) - $paidAmount), $roundingPrecision);

        echo json_encode([
            'subTotal' => $formatSubTotal,
            'subTotalWithSurcharge' => $subTotalWithSurcharge,
            'gstTotal' => $formatGSTTotal,
            'grandTotal' => $formattTotal,
            'paidAmount' => $formatPaidAmount,
            'balancedAmount' => $balancedAmount,
        ]);
    }

    public function actionMYOBSyncronize() {

        $auth = new MYOBAuth(MyobSetting::getSettings());
        if ($auth->checkAccess()) {
            $id = (int) $_POST['id'];
            $model = $this->loadModel($id);

            /* check each product item and do the needfull for MYOB */

            foreach ($model->rel_details() as $detailRecord) {
                $product = $detailRecord->workorderdtl->product;

                $myobApiConnectorPrd = new MYOBApiConnector($auth);
                $synchronizerPrd = new MYOBSynchronizer($myobApiConnectorPrd, $product);
                $synchronizerPrd->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_BOTH);
                $synchronizerPrd->setMYOBReferenceFinder(new MYOBItemReferenceFinder());
                $product->setSynchronizer($synchronizerPrd);
                $product->myobSynchronize($myobApiConnectorPrd);
            }

            $myobApiConnector = new MYOBApiConnector($auth);

            /* create syncronizer object which has the syncronizing logics */
            $synchronizer = new MYOBSynchronizer($myobApiConnector, $model);
            $synchronizer->setMYOBReferenceFinder(new MYOBInvoiceReferenceFinder());
            /* we only push invoices to MYOB and just update the myob references of the local records */
            $synchronizer->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PUSH);
            $model->setSynchronizer($synchronizer);

            /* do syncorize */
            if ($model->myobSynchronize($myobApiConnector)) {
                echo json_encode(array('success' => true));
            } else {
                echo json_encode(array('success' => false));
            }
        }

        //$this->redirect(array('view', 'id' => $id));
    }

    /**
     * Invoices will only be pushed to MYOB! it won't sync into local from MYOB but update the MYOB references of the invoices
     * This action can be called by automatically ( as set in the settings) or manually
     * it will checks the invoices which doesn't have MYOB references and try to push them into MYOB
     */
    public function actionMYOBSyncronizeAll() {

        $auth = new MYOBAuth(MyobSetting::getSettings());

        if ($auth->checkAccess()) {

            $myobInvoiceQueue = Invoice::model()->findAll(array('condition' => "myob_uuid IS NULL OR myob_uuid = ''", 'order' => 'id DESC', 'limit' => 100));


            $myobApiConnector = new MYOBApiConnector($auth);


            $totalTobeSync = count($myobInvoiceQueue);
            $count = 0;
            foreach ($myobInvoiceQueue as $model) {
                $count++;
                /* check each product item and do the needfull for MYOB */
                foreach ($model->rel_details() as $detailRecord) {
                    $product = $detailRecord->workorderdtl->product;
                    if ($product->myob_guid_uuid != trim(Yii::app()->session['myob_guid_uuid'])) {
                        $myobApiConnectorPrd = new MYOBApiConnector($auth);
                        $synchronizerPrd = new MYOBSynchronizer($myobApiConnectorPrd, $product);
                        $synchronizerPrd->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PUSH);
                        $synchronizerPrd->setMYOBReferenceFinder(new MYOBItemReferenceFinder());
                        $product->setSynchronizer($synchronizerPrd);
                        $product->myobSynchronize($myobApiConnectorPrd);
                    }
                }

                /* create syncronizer object which has the syncronizing logics */
                $synchronizer = new MYOBSynchronizer($myobApiConnector, $model);

                $synchronizer->setMYOBReferenceFinder(new MYOBInvoiceReferenceFinder());

                /* we only push invoices to MYOB and just update the myob references of the local records */
                $synchronizer->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PUSH);
                $model->setSynchronizer($synchronizer);

                /* do syncorize */
                $syncInfo = '';
                if ($model->myobSynchronize($myobApiConnector)) {
                    /* do something when success */
                }
                /* out put count streaming */
                echo $count . '/' . $totalTobeSync . '~'; /* "~" streaming seperator for the javascript spliting */
                echo str_pad('', 4096) . "\n";
                ob_flush();
                flush();
            }
        } else {
            throw new Exception('Access Denied!', 404);
        }

        //$this->redirect(array('view', 'id' => $id));
    }

    public function actionXeroQueue() {

        $model = new Invoice('searchXeroQueue');
        $model->unsetAttributes();
        if (isset($_GET['Invoice'])) {
            $model->attributes = $_GET['Invoice'];
        }

        $this->render('xero_queue', array(
            'model' => $model,
        ));
    }

    public function actionToggleXeroQueue($id) {
        $model = $this->loadModel($id);

        $model->xero_in_queue = !$model->xero_in_queue;


        //if invoice is being revoked from the queue then also set the TO BE SENT  flag to false;
        if (!$model->xero_in_queue) {
            $model->xero_to_be_sent = 0;
        }

        $success = $model->save(false);

        $comment = '';
        $url = Yii::app()->createUrl('invoice/view', array("id" => $model->id));
        $link = CHtml::link($model->invoiceNum, $url, array('target' => '_blank'));
        if ($model->xero_in_queue) {
            $comment = "Invoice ({$link}) has been added to the Xero queue";
        } else {
            $comment = "Invoice ({$link}) has been revoked from the Xero queue";
        }


        SalesLog::createSalesLogTblId(
                $model->quote_id, $model->job->workorder->id, $model->quoteNum, $model->id, 'Invoice', $comment, 1, 1, 1
        );

        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            echo json_encode(array('success' => $success));
        } else {
            $this->redirect(array('xeroQueue'));
        }
    }

    public function actionToggleXeroSync() {
        $id = $_POST['id'];
        $myobSync = $_POST['xeroSync'];
        $model = $this->loadModel($id);


        $model->xero_to_be_sent = $myobSync;

        $success = $model->save(false);

        $comment = '';
        $url = Yii::app()->createUrl('invoice/view', array("id" => $model->id));
        $link = CHtml::link($model->invoiceNum, $url, array('target' => '_blank'));
        if ($model->xero_to_be_sent) {
            $comment = "Invoice ({$link}) has been selected for the Xero sync";
        } else {
            $comment = "Invoice ({$link}) has been revoked from the Xero sync";
        }


        SalesLog::createSalesLogTblId(
                $model->quote_id, $model->job->workorder->id, $model->quoteNum, $model->id, 'Invoice', $comment, 1, 1, 1
        );

        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            echo json_encode(array('success' => $success));
        } else {
            $this->redirect(array('myobQueue', 'id' => $model->id));
        }
    }

    public function actionXeroQueuePush() {
        $storage = new StorageClass();
        if ($storage->getHasExpired()) {
            if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
                echo json_encode(array('success' => false, 'type' => 'auth'));
                exit();
            } else {
                Yii::app()->user->setFlash('success', "Authentication Error!");
                $this->redirect(array('xeroQueue'));
            }
        }

        // get $xeroTenantId 
        $storage = new StorageClass();
        $xeroTenantId = (string) $storage->getSession()['tenant_id'];

        //get xero api instance with required configs
        $xeroApiInstance = XeroAPI::getApiInstance();

        $invoicesToBeSync = Invoice::model()->findAll(array('condition' => "xero_in_queue = 1 AND xero_to_be_sent = 1"));


        $messages = [];
        foreach ($invoicesToBeSync as $invoice) {



            $xeroInvoiceApi = new XeroInvoiceApi($xeroApiInstance);
            if ($invoice->xero_invoice_id) {
                if (!$xeroInvoiceApi->updateXero($invoice->xero_invoice_id, $xeroInvoiceApi->getInvoice($invoice))) {

                    $comment = "Invoice [$invoice->invoiceNum} uploading to Xero failed! [{$xeroInvoiceApi->getErrorMessage()}]";
                    $messages[] = $comment;

                    SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->job->id, 'Job', $comment, 1, 0, 1);
                    SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->id, 'Invoice', $comment, 1, 0, 1);
                }
            }

            if (!$invoice->xero_invoice_id) {
                $xeroInvoice = $xeroInvoiceApi->getInvoice($invoice);



                if ($invoice->xero_invoice_id = $xeroInvoiceApi->createXero($xeroInvoice)) {

                    $invoice->xero_in_queue = null;
                    $invoice->xero_to_be_sent = null;
                    $invoice->save(false);

                    $comment = "Invoice [$invoice->invoiceNum} has been pushed to Xero successfully!";
                    $messages[] = $comment;
                    SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->job->id, 'Job', $comment, 1, 0, 1);
                    SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->id, 'Invoice', $comment, 1, 0, 1);
                } else {
                    $comment = "Invoice [$invoice->invoiceNum} uploading to Xero failed! [{$xeroInvoiceApi->getErrorMessage()}]";
                    $messages[] = $comment;
                    SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->job->id, 'Job', $comment, 1, 0, 1);
                    SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->id, 'Invoice', $comment, 1, 0, 1);
                }
            }
        }



        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            echo json_encode(array('success' => true, 'messages' => $messages));
        } else {
            Yii::app()->user->setFlash('success', "Invoice bulk uploading has been done!");
            $this->redirect(array('xeroQueue'));
        }
    }

}
