<?php

class InvoiceDetailController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new InvoiceDetail;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['InvoiceDetail'])) {
            $model->attributes = $_POST['InvoiceDetail'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['InvoiceDetail'])) {
            $model->attributes = $_POST['InvoiceDetail'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $invoiceDetail = $this->loadModel($id);

            $invoice = Invoice::model()->findByPk($invoiceDetail->invoice_id);
            
            $url = Yii::app()->createUrl('invoice/view', array("id" => $invoice->id));
            $link = CHtml::link($invoice->invoiceNum, $url, array('target' => '_blank'));
            
            $comment = "Invoice details [{$invoiceDetail->workorderdtl->productsku} x {$invoiceDetail->workorderdtl->prodQty} @ each {$invoiceDetail->workorderdtl->sellPriceExVat}] has been deleted from the ({$link})";

            SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->job->id, 'Job',  $comment, 1, 1, 1);
            SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->id, 'Invoice', $comment, 1, 1, 1);

            $invoiceDetail->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('InvoiceDetail');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new InvoiceDetail('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['InvoiceDetail']))
            $model->attributes = $_GET['InvoiceDetail'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = InvoiceDetail::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'invoice-detail-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionAddWorkorderDetailItems() {

        $invoiceId = $_POST['invoiceId'];
        $invoice = Invoice::model()->findByPk($invoiceId);
        $workorderdetailsIDs = $_POST['workorderdetailsIDs'];
        $transaction = Yii::app()->db->beginTransaction();
        $allSaved = true;
        $comment = '';
        foreach ($workorderdetailsIDs as $key => $wdid) {
            $workorderDetail = Workorderdetails::model()->findByPk($wdid);

            $invoiceDetail = new InvoiceDetail();
            $invoiceDetail->invoice_id = $invoice->id;
            $invoiceDetail->quote_id = $invoice->quote_id;
            $invoiceDetail->job_id = $invoice->job_id;
            $invoiceDetail->workorder_id = $workorderDetail->workorderId;
            $invoiceDetail->wrkorderDtl_id = $workorderDetail->id;
            $invoiceDetail->qty = $workorderDetail->prodQty;
            $invoiceDetail->sellPriceExVat = $workorderDetail->sellPriceExVat;
            $invoiceDetail->sellPriceIncVat = $workorderDetail->sellPriceIncVat;
            $invoiceDetail->totExVat = $workorderDetail->totExVat;
            $invoiceDetail->totIncVat = $workorderDetail->totIncVat;
            if($invoiceDetail->save(false)) {
                
                $comment .= "\n Invoice details [$workorderDetail->productsku x $workorderDetail->prodQty @ each $workorderDetail->sellPriceExVat] ";
            }
        }

        if ($allSaved) {

            $url = Yii::app()->createUrl('invoice/view', array("id" => $invoice->id));
            $link = CHtml::link($invoice->invoiceNum, $url, array('target' => '_blank'));
            
            $comment .= "have been added to the ({$link})";

            SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->job->id, 'Job',  $comment, 1, 1, 1);
            SalesLog::createSalesLogTblId($invoice->quote_id, $invoice->job->workorder->id, $invoice->quoteNum, $invoice->id, 'Invoice', $comment, 1, 1, 1);

            $transaction->commit();
            echo json_encode(array('success' => true));
        } else {
            $transaction->rollback();
            echo json_encode(array('success' => true));
        }
    }
    
    public function actionUpdateXeroExpensesAccount() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);
        $model->xero_account_id = $_POST['xeroExpensesAccountId'];
        $model->save(false);
        
    }
    
    public function actionUpdateInvoiceDetailQty() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);
        $model->qty = $_POST['invoiceDetailQty'];
        $model->save(false);
        
    }
    
    public function actionUpdateInvoiceDetailSystemTaxRate() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);
        $model->systemTaxRateId = $_POST['invoiceDetailSystemTaxRateId'];
        $model->save(false);
        
    }

    public function actionFetchDetailFlags() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);

        $flags = array();

        if ($model->hide_on_pdf) {

            //send flags which have value

            $flags[] = 'hide_on_pdf';
}



        echo json_encode(array('flags' => $flags));
    }
    
    public function actionUpdateDetailFlags() {
        $id = $_POST['id'];
        //whatever available here that means those attributes have been selected
        $flags = isset($_POST['flags']) ? $_POST['flags'] : array();
        $offFlags = isset($_POST['offFlags']) ? $_POST['offFlags'] : array();

        $model = $this->loadModel($id);
       
        //set new flags from the front-end updated options
        
        foreach ($flags as $attr) {

            $model->$attr = 1;
        }
        
        //turn off if there is no flags
        foreach ($offFlags as $attr) {

            $model->$attr = 0;
        }

        if ($model->save()) {
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => false));
        }
    }
    
    public function actionOnFlagsLabelsHtml() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);

        $html = $model->getOnFlagsLabelsHtml();
        
        

        echo json_encode(array('html' => $html));
    }

}
