<?php

class JobArtworkController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'done', 'doAsInternalJob',
                    'cancel', 'print', 'clientApproval', 'outstandingRpt', 'sendCustomerApproval', 'cusView', 'dueReport'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {

        $model = $this->loadModel($id);

        $subjobs = new SubArtworkJob('search');
        $subjobs->unsetAttributes();  // clear any default values
        if (isset($_GET['SubArtworkJob']))
            $subjobs->attributes = $_GET['SubArtworkJob'];
        $subjobs->jobCategory = 'Artwork';


        $artworksubjobs = new JobArtworkSubjob('search');

        $artworksubjobs->unsetAttributes();  // clear any default values
        if (isset($_GET['JobArtworkSubjob']))
            $artworksubjobs->attributes = $_GET['JobArtworkSubjob'];
        $artworksubjobs->jobArtworkId = $id;

        $criteria = new CDbCriteria;
        $criteria->compare('job_artowk_id', $model->id);
        $criteria->group = "workorder_detial_id";

        $decorationproducts = new CActiveDataProvider(new JobArtworkDetail(), array(
            'criteria' => $criteria,
            'pagination' => false,
        ));

        $this->render('view', array(
            'model' => $model,
            'decorationproducts' => $decorationproducts,
            'artworksubjobs' => $artworksubjobs,
            'subjobs' => $subjobs,
        ));
    }

    public function actionCusView($id) {
        $model = $this->loadModel($id);
        $criteria = new CDbCriteria;
        $criteria->compare('job_artowk_id', $model->id);

        $decorationproducts = new CActiveDataProvider(new JobArtworkDetail(), array(
            'criteria' => $criteria,
            'pagination' => false,
        ));

        $user = User::model()->findByPk(Yii::app()->user->id);

        $renderpage = 'cusview';
        if ($model->job->customer->cussno != $user->cussno) {
            $renderpage = 'error';
        }

        $this->render($renderpage, array(
            'model' => $model,
            'decorationproducts' => $decorationproducts
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        //print_r(Yii::app()->session['deco_ids_of_job_artwork_create_po']);
        $model = new JobArtwork;


        $subjobs = new SubArtworkJob('search');
        $subjobs->unsetAttributes();  // clear any default values
        if (isset($_GET['SubArtworkJob']))
            $subjobs->attributes = $_GET['SubArtworkJob'];

        $subjobs->jobCategory = 'Artwork';

        if (isset($_GET['job_id'])) {
            
            $model->job_id = $_GET['job_id'];
        }



        if (isset($_POST['JobArtwork'])) {

            $transaction = Yii::app()->db->beginTransaction();
            $allsaved = true;
            $model->unsetAttributes();  // clear any default values
            $model->attributes = $_POST['JobArtwork'];
            if (!empty($model->followupDate)) {
                $model->followupDate = date(GlobalVars::MYSQL_DATETIME_FORMAT, strtotime($model->followupDate));
            }
            if (!empty($model->dueDate)) {
                $model->dueDate = date(GlobalVars::MYSQL_DATETIME_FORMAT, strtotime($model->dueDate));
            }

            //$jobDecorationIDs = str_replace('_', ',', $model->job_deco_id_str);
            // $jobdecorationIDArr = explode(',', $jobDecorationIDs);
            if ($model->inventory_id > 0) {
                $model->jobType = JobArtwork::JOB_TYPE_USE_EXIST;
            } else {
                $model->jobType = JobArtwork::JOB_TYPE_INTERNAL_JOB;
            }

            $uploadedFile = CUploadedFile::getInstance($model, 'archiveImageLogo');
            if ($model->save()) {
                $number = sprintf("%06s", $model->id);
                $model->artworkjobNum = $number;
                if ($model->save()) {
                    $jobArtworkMultiDecorationArr = json_decode(Yii::app()->session['deco_ids_of_job_artwork_create_po'], true);
                    foreach ($jobArtworkMultiDecorationArr as $workorderDetailId => $artDecoArr) {
                        foreach ($artDecoArr as $key => $decoId) {
                            $jobdecoration = JobDecorations::model()->findByPk($decoId);
                            $jobartworkdtl = new JobArtworkDetail();
                            $jobartworkdtl->job_artowk_id = $model->id;
                            $jobartworkdtl->job_decoration_id = $decoId;
                            $jobartworkdtl->job_id = $model->job_id;
                            $jobartworkdtl->workorder_id = $jobdecoration->workorderDtl->workorderId;
                            $jobartworkdtl->workorder_detial_id = $jobdecoration->workorderDtl_id;
                            $jobartworkdtl->save();

                            $jobdecoration->artwork_id = $model->id;
                            $jobdecoration->status_id = 21; //Artwork Created
                            if (!$jobdecoration->save()) {
                                $allsaved = false;
                            }

                            $jobactivityflow = new JobActivityFlow();
                            $jobactivityflow->job_id = $model->job_id;
                            $jobactivityflow->wrkorder_id = $jobdecoration->workorderDtl->workorderId;
                            $jobactivityflow->wrkorderDtl_id = $jobdecoration->workorderDtl_id;
                            $jobactivityflow->type = 'Decoration';
                            $jobactivityflow->activity = 'Artwork Created';
                            $jobactivityflow->flowjob_id = $decoId;
                            if (!$jobactivityflow->save()) {
                                $allsaved = false;
                            }
                        }
                    }
                } else {
                    $allsaved = false;
                }

                $dirpath = Yii::app()->basePath . '/../images/artwork/job/' . $model->artworkjobNum;
                if (!file_exists($dirpath))
                    mkdir($dirpath, 0777, true);
                if (empty($model->inventory_id) && $uploadedFile != null) {
                    $imgarchive = new ArtworkLogoArchive();
                    $imgarchive->job_artowk_id = $model->id;
                    if ($imgarchive->save()) {
                        $archiveimgnumber = sprintf("%04s", $imgarchive->id);
                        $imgarchive->logoImage = ( $archiveimgnumber . '.' . $uploadedFile->getExtensionName());
                        $imgarchive->createdDate = date(GlobalVars::MYSQL_DATETIME_FORMAT);
                        if (!$imgarchive->save()) {
                            $allsaved = false;
                        }
                    } else {
                        $allsaved = false;
                    }



                    if (!$uploadedFile->saveAs($dirpath . '/' . $imgarchive->logoImage)) {
                        $allsaved = false;
                    }

                    list($width, $height) = getimagesize($dirpath . '/' . $imgarchive->logoImage);
                    if ($width > 600) {
                        $imagetoresize = $dirpath . '/' . $imgarchive->logoImage;
                        ImageGenerator::smart_resize_image($imagetoresize, null, 600, $height, true, $imagetoresize, true, false, 100);
                    }

                    $model->archiveImageLogo = $imgarchive->logoImage;
                } else if ($model->inventory_id > 0) {
                    $invenotry = InventoryArtWork::model()->findByPk($model->inventory_id);

                    $dirfrompath = Yii::app()->basePath . '/../images/artwork/inventory/' . $invenotry->image;

                    if (!empty($invenotry->image) && file_exists($dirfrompath)) {


                        $filenamearr = explode('.', $invenotry->image);

                        $imgarchive = new ArtworkLogoArchive();
                        $imgarchive->job_artowk_id = $model->id;
                        if ($imgarchive->save()) {
                            $archiveimgnumber = sprintf("%04s", $imgarchive->id);
                            $imgarchive->logoImage = ( $archiveimgnumber . '.' . $filenamearr[1]);
                            $imgarchive->createdDate = date(GlobalVars::MYSQL_DATETIME_FORMAT);
                            if (!$imgarchive->save()) {
                                $allsaved = false;
                            }
                        } else {
                            $allsaved = false;
                        }

                        copy($dirfrompath, ($dirpath . '/' . $imgarchive->logoImage));
                        $model->archiveImageLogo = $imgarchive->logoImage;
                    }
                }
                $model->job_status_id = 18;
                $model->createdDate = date(GlobalVars::MYSQL_DATETIME_FORMAT);
                $model->approve_status_id = 4;

                if ($model->save()) {
                    //save sub jobs

                    $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
                    $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));
                    if (isset($_POST['sub-artwork-job-grid_c0'])) {
                        $subjobarr = $_POST['sub-artwork-job-grid_c0'];
                        $dueDatesarr = $_POST['SubArtworkJob']['dueDate'];
                        foreach ($subjobarr as $key => $val) {
                            $jobssubtask = new JobArtworkSubjob();
                            $jobssubtask->subArtworkJobId = $val;
                            $jobssubtask->jobArtworkId = $model->id;
                            $jobssubtask->statusId = 1; //New
                            $jobssubtask->dueDate = date('Y-m-d', strtotime($dueDatesarr[$val]));
                            $jobssubtask->statusDate = date("y-m-d");
                            $jobssubtask->createdBy = Yii::app()->user->id;
                            if ($jobssubtask->save(false)) {

                                $allsaved = StatusLog::actionSave($jobssubtask->tableName(), $jobssubtask->id, $jobssubtask->statusId);
                                SalesLog::createTblLog($model->id, 'JobArtwork', 'New sub job (' . $jobssubtask->subjob->name . ') is added');
                            } else {

                                $allsaved = false;
                            }
                        }
                    }

                    //end sub jobs

                    $logtext = "";
                    if ($model->inventory_id > 0) {
                        $logtext = "Artwork Job ({$link}) is created by using existing artwork";
                    } else {
                        $logtext = "Artwork Job ({$link}) is created";
                    }
                    SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
                    SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);
                } else {
                    $allsaved = false;
                }
            } else {
                $allsaved = false;
            }

            if ($allsaved) {
                $transaction->commit();
                Yii::app()->user->setFlash('success', "Artwork ($model->artworkjobNum) successfully created.");
                $this->redirect(array('view', 'id' => $model->id));
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', "Cannot create artwork Please try again.");
            }
        }

        //default job priority
        $model->jobPriority = 10;
        $this->render('create', array(
            'model' => $model,
            'subjobs' => $subjobs,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);
        

        if (!isset($_POST['JobArtwork'])) {
            if (!empty($model->followupDate)) {
                $model->followupDate = date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime($model->followupDate));
            }
            if (!empty($model->dueDate)) {
                $model->dueDate = date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime($model->dueDate));
            }
        }


        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['JobArtwork'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $allsaved = true;
           
            $model->attributes = $_POST['JobArtwork'];

            if (!empty($model->followupDate)) {
                $model->followupDate = date(GlobalVars::MYSQL_DATETIME_FORMAT, strtotime($model->followupDate));
            }
            if (!empty($model->dueDate)) {
                $model->dueDate = date(GlobalVars::MYSQL_DATETIME_FORMAT, strtotime($model->dueDate));
            }

           

            $allsaved = $model->save();

            if ($allsaved) {
                $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
                $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));

                $logtext = "Artwork Job ({$link}) was updated";

                SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
                SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);
                $transaction->commit();
                Yii::app()->user->setFlash('success', "Artwork ({$model->artworkjobNum}) has been updated successfully.");
                $this->redirect(array('view', 'id' => $model->id));
            } else {
                Yii::app()->user->setFlash('error', "Cannot update artwork Please try again.");
                $transaction->rollback();
            }
        }



        $this->render('update', array(
            'model' => $model
        ));
    }

    public function actionAddSubJobs() {
        if (Yii::app()->request->isPostRequest) {
            if (isset($_POST['sub-artwork-job-grid_c0']) && isset($_POST['JobArtwork']) && isset($_POST['SubArtworkJob'])) {
                $jobartworkID = $_POST['JobArtwork']['id'];
                $subjobarr = $_POST['sub-artwork-job-grid_c0'];
                $dueDatesarr = $_POST['SubArtworkJob']['dueDate'];
                $returnMsgs = '';
                foreach ($subjobarr as $key => $val) {

                    $hassubjob = JobArtworkSubjob::model()->find(array('condition' => "subArtworkJobId = $val and jobArtworkId = $jobartworkID"));
                    if (empty($hassubjob)) {
                        $jobssubtask = new JobArtworkSubjob();
                        $jobssubtask->subArtworkJobId = $val;
                        $jobssubtask->jobArtworkId = $jobartworkID;
                        $jobssubtask->statusId = 1; //New
                        $jobssubtask->dueDate = date('Y-m-d', strtotime($dueDatesarr[$val]));
                        $jobssubtask->statusDate = date("y-m-d");
                        $jobssubtask->createdBy = Yii::app()->user->id;
                        if ($jobssubtask->save()) {
                            $allsaved = StatusLog::actionSave($jobssubtask->tableName(), $jobssubtask->id, $jobssubtask->statusId);
                            SalesLog::createTblLog($jobartworkID, 'JobArtwork', 'New sub job (' . $jobssubtask->subjob->name . ') is added');
                        } else {
                            $allsaved = false;
                        }
                    } else {
                        $returnMsgs .= "Sub job " . $hassubjob->subjob->name . " is already have.<br>";
                    }
                }
            }
        }
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('JobArtwork');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new JobArtwork('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['JobArtwork']))
            $model->attributes = $_GET['JobArtwork'];

        if (isset($_GET['pastdue']) && $_GET['pastdue'] == 1)
            $model->filterPastDue = true;

        if (empty($model->job_status_id))
            $model->job_status_id = 18; //Job In Progress to default

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    public function actionDueReport() {
        $model = new JobArtwork('searchDue(7)');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['JobArtwork']))
            $model->attributes = $_GET['JobArtwork'];

        $this->render('due_report', array(
            'model' => $model,
        ));
    }

    public function actionSendCustomerApproval($id) {
        $transaction = Yii::app()->db->beginTransaction();
        $model = $this->loadModel($id);
        $allsaved = true;
        $email_not_valid = '';
        //create logins for the customer
        $proposedUsername = $model->job->customer->cusemail;
        $user = User::model()->find(array('condition' => "username = '{$proposedUsername}' and title = 'Customer'"));
        $logintext = '';
        if (empty($user)) {
            $user = new User();

            $user->username = $proposedUsername;
            $generatedPassword = User::generateRandomPassword();
            $user->password = md5($generatedPassword);
            $user->title = 'Customer';
            $user->email = $model->job->customer->cusemail;
            $user->cussno = $model->job->customer->cussno;
            if ($user->save()) {
                $authassignment = new AuthAssignment();
                $authassignment->itemname = 'Customer';
                $authassignment->userid = $user->id;
                $authassignment->data = 'N;';
                if ($authassignment->save()) {
                    $logintext = "Please use following login details to get in to the system<br>Username : $proposedUsername<br>Password:$generatedPassword";
                } else {
                    $allsaved = false;
                }
            } else {
                $email_not_valid = '[ Customer email may be incorrect. ]';
                $allsaved = false;
            }
        } else {
            $logintext = 'Please use your login details to log in to our system and to do approval things';
        }

        $recipient = $model->job->customer->cusemail;
        $ccrecipients = ''; //
        $mailer = Yii::app()->MultiMailer->to($recipient, 'Recipient');
        //$mailer = Yii::app()->MultiMailer->to('rajaera@gmail.com', 'Recipient');
        $globalvar = GlobalVars::model()->find(array('condition' => "globalVar = 'AdminEmail'"));
        if (!empty($globalvar)) {
            $ccrecipients = $globalvar->value;
            $mailer->cc($ccrecipients);
        }

        $mailer->subject("Goodgear Artwork Confirmation for : $model->artworkjobNum");


        $accessurl = Yii::app()->getBaseUrl(true) . '/' . Yii::app()->createUrl('jobArtwork/cusView', array('id' => $id));
        $mailbody = '<h1>Confirmation for ' . $model->artworkjobNum . '</h1>';
        $mailbody .= '<p>Please confirm or reject this artwork : <a href="' . $accessurl . '">' . $model->artworkjobNum . '</a>. click <a href="' . $accessurl . '">here</a> to see the artwork and do actions.</p>';
        $mailbody .= '<p>' . $logintext . '</p>';
        $mailbody .= '<p>For more details call : 000-0000-0000</p>';
        $mailer->body($mailbody);

        $fileinventory = $model->generatePDF();
        $mailer->attachment('files/' . $fileinventory->filename);

        $model->job_status_id = 4; //Pending Approval
        $model->approve_status_id = 4;
        if ($model->save(false)) {
            if ($mailer->send()) {
                $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
                $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));
                $logtext = "Artowrk {$model->artworkjobNum} has been sent to customer for approval";
                SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
                SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);
                //save email
                $trackmail = Emails::trackSave($recipient, $ccrecipients, $mailbody);
                if ($allsaved == true) {
                    Yii::app()->user->setFlash('success', "Artwork has been sent to approval.  {$model->artworkjobNum} ");
                    $transaction->commit();
                    $this->redirect(array('jobArtwork/view', 'id' => $id, 'send' => '1'));
                } else {
                    $transaction->rollback();
                    Yii::app()->user->setFlash('error', "Error in sending artwork to approval.  {$model->artworkjobNum} $email_not_valid");
                    $this->redirect(array('jobArtwork/view', 'id' => $id, 'send' => '0'));
                }
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', "Error in sending artwork to approval.  {$model->artworkjobNum} ");
                $this->redirect(array('jobArtwork/view', 'id' => $id, 'send' => '0'));
            }
        } else {
            $transaction->rollback();
            Yii::app()->user->setFlash('error', "Error in sending artwork to approval.  {$model->artworkjobNum} ");
            $this->redirect(array('jobArtwork/view', 'wid' => $id, 'send' => '0'));
        }
    }

    public function actionCusApproval($id) {
        $model = $this->loadModel($id);
        $user = User::model()->findByPk(Yii::app()->user->id);


        if ($model->job->customer->cussno != $user->cussno) {

            $this->render('error');
        } else {
            $model->job_status_id = 22; //Approved By Client
            $model->approve_status_id = 22;
            if ($model->save(false)) {
                $mailer = Yii::app()->MultiMailer->to($model->job->customer->cusemail, 'Recipient');
                $globalvar = GlobalVars::model()->find(array('condition' => "globalVar = 'AdminEmail'"));
                if (!empty($globalvar)) {
                    $adminEmail = $globalvar->value;
                    $mailer->cc($adminEmail);
                }

                $mailer->subject("Artwork Job Approved : $model->artworkjobNum");


                $mailbody = 'Thank you for the approval';

                $mailer->body($mailbody);

                if ($mailer->send()) {
                    Yii::app()->user->setFlash('success', "Email sent for the approval");
                }
                Yii::app()->user->setFlash('success', "Artwork job successfully approved  message! {$model->artworkjobNum}");

                $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
                $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));
                $logtext = "Artowrk {$model->artworkjobNum} is approved by the client";
                SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
                SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);
                $this->redirect(array('workorder/cusAdmin'));
            } else {
                $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
                $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));
                $logtext = "Customer was trying to approve the artowrk job {$model->artworkjobNum} but failed.";
                SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
                SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);

                Yii::app()->user->setFlash('error', "Cannot approve artwork! contact the admin {$model->artworkjobNum}");
                $this->redirect(array('workorder/cusAdmin'));
            }
        }
    }

    public function actionCusReject($id) {

        $model = $this->loadModel($id);
        $criteria = new CDbCriteria;
        $criteria->compare('job_artowk_id', $model->id);

        $decorationproducts = new CActiveDataProvider(new JobArtworkDetail(), array(
            'criteria' => $criteria,
            'pagination' => false,
        ));
        $user = User::model()->findByPk(Yii::app()->user->id);
        if ($model->job->customer->cussno != $user->cussno) {

            $this->render('error');
        }

        if (isset($_POST['JobArtwork']) && isset($_POST['yt0'])) {
            if (isset($_POST['JobArtwork']['rejectionNote']) && !empty($_POST['JobArtwork']['rejectionNote'])) {
                $workorderID = $_POST['JobArtwork']['id'];
                $resontoreject = trim($_POST['JobArtwork']['rejectionNote']);

                $model = $this->loadModel($workorderID);
                $model->job_status_id = 18; //Job In Progressing
                $model->approve_status_id = 23; //Rejected By Client
                if ($model->save(false)) {
                    Yii::app()->user->setFlash('success', "Artwork successfully rejecetd  message! {$model->artworkjobNum}");
                    $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
                    $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));
                    $logtext = "Artowrk {$model->artworkjobNum} is rejected by the client due to '$resontoreject'";
                    SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
                    SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);
                    $this->redirect(array('workorder/cusAdmin'));
                } else {
                    $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
                    $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));
                    $logtext = "Customer was trying to reject the artowrk {$model->artworkjobNum} but failed!";
                    SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
                    SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);

                    Yii::app()->user->setFlash('error', "Cannot reject artwork message! contact the admin {$model->artworkjobNum}");
                    $this->redirect(array('workorder/cusAdmin'));
                }
            } else {
                Yii::app()->user->setFlash('error', "Please add a reason for artwork rejection.");
            }
        }

        $this->render('_cusRejectForm', array(
            'model' => $model,
            'decorationproducts' => $decorationproducts
        ));
    }

    public function actionOutstandingRpt() {

        $model = new JobArtwork('searchOutstanding');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['JobArtwork']))
            $model->attributes = $_GET['JobArtwork'];

        if (isset($_POST['JobArtwork']))
            $model->attributes = $_POST['JobArtwork'];

        if (isset($_POST['yt0'])) {

            $model->duedatefrom = null;
            $model->duedateto = null;
            $model->followupdatefrom = null;
            $model->followupdateto = null;
            $model->createddatefrom = null;
            $model->createddateto = null;
        }

        $this->render('rpt_outstanding', array(
            'model' => $model,
        ));
    }

    public function actionDone($id) {

        $model = $this->loadModel($id);
        $model->job_status_id = 11;
        if ($model->save()) {
            $inventoryArtwork = new InventoryArtWork();
            $inventoryArtwork->job_id = $model->job_id;
            $inventoryArtwork->wrkord_id = $model->job->workorder->id;
            $inventoryArtwork->image = $model->archiveImageLogo;
            $inventoryArtwork->productColor = $model->productColor;
            $inventoryArtwork->decorationType = $model->decorationType;
            $inventoryArtwork->logoName = $model->logoName;
            $inventoryArtwork->printSize = $model->printSize;
            $inventoryArtwork->printColor = $model->printColor;
            $inventoryArtwork->designNumber = $model->designNumber;
            $inventoryArtwork->isRepeatDesign = $model->isRepeatDesign;
            $inventoryArtwork->job_artowk_id = $model->id;
            $inventoryArtwork->createdDate = date(GlobalVars::MYSQL_DATETIME_FORMAT);
            $inventoryArtwork->user_id = Yii::app()->user->id;
            $inventoryArtwork->save();

            $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
            $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));

            $logtext = "Artwork Job ({$link}) is done";

            SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
            SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);

            SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', 'Artwork is saved to inventory', 1, 1, 1);
            SalesLog::createTblLog($model->id, 'JobArtwork', 'Artwork is saved to inventory');

            Yii::app()->user->setFlash('success', "Artwork Job  ({$model->artworkjobNum}) is done");
        }


        $this->redirect(array('view', 'id' => $model->id));
    }

    public function actionCancel($id) {

        $model = $this->loadModel($id);
        $model->job_status_id = 3;
        if ($model->save()) {
            $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
            $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));

            $logtext = "Artwork Job ({$link}) is canceled";

            SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
            SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);

            Yii::app()->user->setFlash('success', "Artwork Job  ({$model->artworkjobNum}) is canceled");
        }


        $this->redirect(array('view', 'id' => $model->id));
    }

    public function actionDoAsInternalJob($id) {

        $model = $this->loadModel($id);
        $model->jobType = JobArtwork::JOB_TYPE_INTERNAL_JOB;
        if ($model->save()) {
            $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
            $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));

            $logtext = "Type of Artwork Job ({$link}) is changed to Internal Job";

            SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);
            SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);

            Yii::app()->user->setFlash('success', "Type of Artwork Job ({$model->artworkjobNum})  is changed to Internal Job");
        }


        $this->redirect(array('view', 'id' => $model->id));
    }

    public function actionClientApproval() {

        if (isset($_POST['JobArtwork']) && isset($_POST['manual_appr_btn'])) {

            $id = $_POST['JobArtwork']['id'];
            $jobapprovalStatusID = $_POST['JobArtwork']['approve_status_id'];
            $rejectedReasonNote = trim($_POST['JobArtwork']['rejectionNote']);

            if ($jobapprovalStatusID == 23 && empty($rejectedReasonNote)) {
                Yii::app()->user->setFlash('notice', 'Must mention a reason to reject.');
                $this->redirect(array('view', 'id' => $id));
            }


            $model = $this->loadModel($id);
            $model->approve_status_id = $jobapprovalStatusID;
            $model->rejectionNote = $rejectedReasonNote;
            if ($model->approve_status_id == 23) {
                $model->job_status_id = 18; //Job In Progressing
            }

            if ($model->save()) {
                $url = Yii::app()->createUrl('jobArtwork/view', array("id" => $model->id));
                $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));

                if ($model->approve_status_id == 22)
                    $logtext = "Artwork Job ({$link}) is approved by the client";
                else if ($model->approve_status_id == 23) {

                    $logtext = "Artwork Job ({$link}) is rejecetd by the client";
                }


                SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1);

                if (!empty($rejectedReasonNote) && $model->approve_status_id == 23) {
                    SalesLog::createTblLog($model->id, 'JobArtwork', "Reason to reject the artwork($model->artworkjobNum) : " . $rejectedReasonNote);
                }
                SalesLog::createTblLog($model->id, 'JobArtwork', $logtext);






                $flashmsg = '';
                if ($model->approve_status_id == 22) {
                    $flashmsg = "Artwork Job ({$model->artworkjobNum})  is approved by the client";
                } else if ($model->approve_status_id == 23) {
                    $flashmsg = "Artwork Job ({$model->artworkjobNum})  is rejected by the client";
                }
                Yii::app()->user->setFlash('success', $flashmsg);
                $this->redirect(array('view', 'id' => $model->id));
            }
        } else {
            Yii::app()->user->setFlash('notice', 'Cannot complete the approval or rejection process.');
            $this->redirect(array('view', 'id' => $model->id));
        }
    }

    public function actionPrint($id) {
        $model = $this->loadModel($id);

        $user = User::model()->findByPk(Yii::app()->user->id);


        if (Yii::app()->user->title == 'Customer') {
            if ($model->job->customer->cussno != $user->cussno) {

                $this->render('error');
            }
        }

        $url = Yii::app()->createUrl('jobArtwork/print', array("id" => $model->id));
        $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'Artwork job ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->job->quote_id, $model->job->workorder_id, $model->job->quoteNum, 'Jobs', "Artworj job ({$link}) is printed", 1, 1, 1);
            SalesLog::createTblLog($model->id, 'JobArtwork', "Artwork job ({$link}) is printed");
        }
		
		$htmlcontent = $this->renderInternal('protected/views/jobArtwork/artwork_job_pdf.php', array('model' => $model), true);

		

		$sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        $mpdf = new MpsArtwork;
        $mpdf->setMode(MpsPdf::MODE_CONTENT_GENERATOR)
            ->setModel($model)
            ->generate($htmlcontent)
            ->output("{$sitePrefix}_{$model->artworkjobNum}");

        
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = JobArtwork::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'job-artwork-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
