<?php

class JobArtworkOnlineAcceptenceController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index', 'onlineAccept'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new JobArtworkOnlineAcceptenceLog;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['JobArtworkOnlineAcceptenceLog']))
		{
			$model->attributes=$_POST['JobArtworkOnlineAcceptenceLog'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['JobArtworkOnlineAcceptenceLog']))
		{
			$model->attributes=$_POST['JobArtworkOnlineAcceptenceLog'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex($id)
	{
		if ($jobArtoworkId = JobArtworkOnlineAcceptenceLog::validateLinkSecret($id)) {
			$artwork = JobArtwork::model()->findByPk($jobArtoworkId);
			$artwork_template = $this->renderInternal('protected/views/jobArtworkOnlineAcceptence/artwork_template.php', array('model' => $artwork), true);
			$this->render('index', array(
				'artwork' => $artwork,
				'artwork_template' => $artwork_template
			));
		} else {
			$this->render('error');
		}
	}

	public function actionOnlineAccept()
	{
		if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
			//check acceptance secert validaion
			$acceptType = $_POST['accepttype'];
			$linkSecret = $_POST['linkSecret'];
			$comment = $_POST['comment'];
			if ($jobArtoworkId = JobArtworkOnlineAcceptenceLog::validateLinkSecret($linkSecret)) {

				$transaction = Yii::app()->db->beginTransaction();

				$jobArtwork = JobArtwork::model()->findByPk($jobArtoworkId);

				if (intval($acceptType) == JobArtworkOnlineAcceptenceLog::LOG_STATUS_ACCEPT) {
					//get selected proof items when accepting the artwork
					//variable to hold form data query string
					$formData = null;
					//parse query string to  $formData as array
					parse_str($_POST['formData'], $formData);
					foreach ($formData['ArtworkLogoArchive']['id'] as $proofId => $proofImageName) {
						$proof = ArtworkLogoArchive::model()->findByPk($proofId);
						if ($proof) {
							$proof->customer_accepted = ArtworkLogoArchive::STATUS_CUSTOMER_ACCEPTED;
							if ($proof->save(false)) {
								$comment .= '<br/>[ proof : ' . $proof->logoImage .  ' ] is accepted.';
							}
						}
					}
				}
				
				//create new acceptace log
				$lastAcceptLogAttributes = $jobArtwork->onlineAcceptenceLog->attributes;

				$lastAcceptLogAttributes['link_active'] = JobArtworkOnlineAcceptenceLog::LINK_STATUS_INACTIVE;

				$acceptTypeMessageOnSuccess = '';
				$acceptTypeMessageOnFail = '';
				switch (intval($acceptType)) {
					case JobArtworkOnlineAcceptenceLog::LOG_STATUS_ACCEPT:
						$lastAcceptLogAttributes['status_id'] = JobArtworkOnlineAcceptenceLog::LOG_STATUS_ACCEPT;
						$acceptTypeMessageOnSuccess = 'Online Artwork Accepted!';
						$lastAcceptLogAttributes['cutomer_comment'] = htmlspecialchars($comment);
						$acceptTypeMessageOnFail = 'Online Artwork acceptance failed! Please contact admin or try again later!';
						break;

					case JobArtworkOnlineAcceptenceLog::LOG_STATUS_DECLINE:
						$lastAcceptLogAttributes['status_id'] = JobArtworkOnlineAcceptenceLog::LOG_STATUS_DECLINE;
						$acceptTypeMessageOnSuccess = 'Online Artwork Declined!';						
						$acceptTypeMessageOnFail = 'Online Artwork decline failed! Please contact admin or try again later!';

						break;
				}				
				
				
				$lastAcceptLogAttributes['user_data'] = json_encode($_SERVER);
				
				

				$logId = JobArtworkOnlineAcceptenceLog::write($lastAcceptLogAttributes);		

				$jobArtwork->job_artwork_online_acceptence_log_id = $logId;
				
				//diasable all other logs' links related this quote
				
				JobArtworkOnlineAcceptenceLog::dasableAllLinks($jobArtwork->id);
				
				$jobArtwork->updateFollowUpStatusByOnlineAcceptance($lastAcceptLogAttributes['status_id']);
					
				
				
				if ($jobArtwork->save(false)) {
					SalesLog::createTblLog($jobArtoworkId, SalesLog::CATEGORY_ARTWORK_JOB, "Artwork proofs acceptance for the link [$linkSecret] was done. [$comment]");

					$transaction->commit();
					//response array
					echo json_encode(array(
						'status' => 1, //success
						'message' => $acceptTypeMessageOnSuccess
					));
				} else {
					$transaction->rollback();
					//response array
					echo json_encode(array(
						'status' => 0, //failed
						'message' => $acceptTypeMessageOnFail
					));
				}
			} else {
				//response array
				echo json_encode(array(
					'status' => 0, //failed
					'message' => 'The request is not validated! Please don\'t repeat this request again!'
				));
			}
		} else {
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
		}
	}


	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new JobArtworkOnlineAcceptenceLog('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['JobArtworkOnlineAcceptenceLog']))
			$model->attributes=$_GET['JobArtworkOnlineAcceptenceLog'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=JobArtworkOnlineAcceptenceLog::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='job-artwork-online-acceptence-log-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
