<?php

class JobProductDecorationsController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'updateCommonDecoration'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {

        $model = new JobProductDecorations;



        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['JobProductDecorations'])) {
            $model->attributes = $_POST['JobProductDecorations'];



            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    public function actionCreateCopy($id) {


        $orginmodel = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);
        //$model->unsetAttributes();  // clear any default values
        if (isset($_POST['JobProductDecorations'])) {
            $model = new JobProductDecorations();
            $model->attributes = $_POST['JobProductDecorations'];


            $model->user_id = Yii::app()->user->id;
            $model->status_id = 1; //New

            if ($model->save()) {
                $url = Yii::app()->createUrl('jobProductDecorations/view', array("id" => $model->id));
                $link = CHtml::link(" Product-Decoration [$model->id] " . $model->decprtnam, $url, array('target' => '_blank'));
                SalesLog::createSalesLogWithFollowup($model->workorderDtl->workorder->quotationId, $model->workorderDtl->workorder->id, $model->workorderDtl->workorder->quotationNumber, 'Job', "New Copy of  {$link} [{$model->decdesc}] is created", 1, 1, 1, null);
                SalesLog::createSalesLogWithFollowup($model->workorderDtl->workorder->quotationId, $model->workorderDtl->workorder->id, $model->workorderDtl->workorder->quotationNumber, 'ProductDecoration', "New Copy of  {$link} [{$model->decdesc}] is created", 1, 1, 1, null);
                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $this->render('create', array(
            'model' => $orginmodel,
            'orginmodel' => $orginmodel,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);
        //$model->unsetAttributes();  // clear any default values
        if (isset($_POST['JobProductDecorations'])) {
            $model->attributes = $_POST['JobProductDecorations'];


            $model->user_id = Yii::app()->user->id;
            $model->status_id = 1; //New

            if ($model->save()){
                $url = Yii::app()->createUrl('jobProductDecorations/view', array("id" => $model->id));
                $link = CHtml::link(" Product-Decoration [$model->id] " . $model->decprtnam, $url, array('target' => '_blank'));
                SalesLog::createSalesLogWithFollowup($model->workorderDtl->workorder->quotationId, $model->workorderDtl->workorder->id, $model->workorderDtl->workorder->quotationNumber, 'Job', "{$link} [{$model->decdesc}] is updated", 1, 1, 1, null);
                SalesLog::createSalesLogWithFollowup($model->workorderDtl->workorder->quotationId, $model->workorderDtl->workorder->id, $model->workorderDtl->workorder->quotationNumber, 'ProductDecoration', "{$link} [{$model->decdesc}] is updated", 1, 1, 1, null);
                $this->redirect(array('view', 'id' => $model->id));
                
            }
                
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);

            $jobID = $model->job_id;
            $deocrationDesc = $model->decdesc;
            
            $quoteID = $model->workorderDtl->workorder->quotationId;
            $workorderID = $model->workorderDtl->workorder->id;
            $quoteNumber = $model->workorderDtl->workorder->quotationNumber;
            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if ($model->delete()) {
                SalesLog::createSalesLogWithFollowup($quoteID, $workorderID, $quoteNumber, 'Job', "Product-Decoration ID[$id] [{$deocrationDesc}] is deleted", 1, 1, 1, null);
                
                Yii::app()->user->setFlash('success', "Product-decoration ID[{$id}][{$deocrationDesc}] has been deleted!");
            } else {
                Yii::app()->user->setFlash('error', "Cannot delete product-decoration ID[{$id}][{$deocrationDesc}]. Please try again!");
            }
            $this->redirect(array('/jobs/view', 'id' => $jobID));
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('JobProductDecorations');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new JobProductDecorations('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['JobProductDecorations']))
            $model->attributes = $_GET['JobProductDecorations'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = JobProductDecorations::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'job-product-decorations-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionUpdateCommonDecoration() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['prodDecoID'])) {
                $resultArr = array();
                $proddecoID = $_POST['prodDecoID'];
                $model = $this->loadModel($proddecoID);
                if (!empty($model)) {
                    if (!empty($model->decprtnam)) {
                        $resultArr['success'] = (bool) JobProductDecorations::model()->updateAll(array('commondecoprtnam' => $model->decprtnam), "job_id = '{$model->job_id}'");
                    } else if (!empty($model->customdecoration)) {
                        $resultArr['success'] = (bool) JobProductDecorations::model()->updateAll(array('commondecocustom' => $model->customdecoration), "job_id = '{$model->job_id}'");
                    }
                } else {
                    throw new Exception;
                }

                echo json_encode($resultArr);
            }
        }
    }
    
    public function actionJobDone($id) {
        $model = $this->loadModel($id);
        $model->status_id = Status::SYS_STATUS_SUBJOB_DONE;
        if ($model->save()) {
            $decoitem = $model->workorderDtl->prdsrtdesc . '(' . $model->workorderDtl->productsku . ')';
            Yii::app()->user->setFlash('success', "Product-decoration job(s) have been completed for $decoitem");
            $this->redirect(array('jobs/view', 'id' => $model->job_id));
        }
    }

}
