<?php

class JobsController extends RController
{

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters()
    {
        return array(
            'rights',
            //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'admin'),
                'users' => array('@'),
            ),
            array(
                'allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array(
                    'admin', 'delete', 'jobsHandler', 'closesession',
                    'endDecoration', 'artworkallocate', 'productallocate', 'decorationNA', 'print',
                    'jobsComplete', 'jobadmin', 'summary', 'printSummary', 'statusReport', 'printStatusReport', 'uploadAjaxHeader', 'printSupplierReport', 'userDefinedStatusReport', 'outstandingJobs', 'generateOutstandingJobsExcel',
                    'generateOutstandingJobsPDF', 'joburgent', 'adminByCoordinator', 'bycoordinator',
                    'printCoordinatorReport', 'CRM', 'printCRM', 'jobFlow', 'cancel', 'financialOverView', 'dueReport'
                ),
                'users' => array('@'),
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id)
    {

        $model = $this->loadModel($id);
        $followupDate = trim($model->followupDate);
        if (in_array($followupDate, array(null, '0000-00-00', '1970-01-01'))) {
            $inxdays = GlobalVars::get("FollowInXDays");
            $followupdate = strtotime("+$inxdays day");
            $model->followupDate = date('Y-m-d', $followupdate); // followup date format to save to DB
            $model->save(false);
            $model->followupDate = date(GlobalVars::get("DateFormat"), $followupdate); // followup date format to show in view
        } else {
            $model->followupDate = date(GlobalVars::get("DateFormat"), strtotime($followupDate));
        }

        $duedate = trim($model->dueDate);
        if (in_array($duedate, array(null, '0000-00-00', '1970-01-01'))) {
            $dueinXdays = GlobalVars::get("DueInXDays");
            $duedate = strtotime("+$dueinXdays day");
            $model->dueDate = date('Y-m-d', $duedate); // due date format to save to DB
            $model->save(false);
            $model->dueDate = date(GlobalVars::get("DateFormat"), $duedate); // due date format to show in view
        } else {
            $model->dueDate = date(GlobalVars::get("DateFormat"), strtotime($duedate));
        }


        $this->render('view', array(
            'model' => $model,
        ));
    }

    public function actionFinancialOverView($id)
    {
        $model = $this->loadModel($id);
        $workorderdetails = new Workorderdetails();
        $workorderdetails->workorderId = $model->workorder_id;
        $this->render('financialOverView', array(
            'model' => $model,
            'workorderdetails' => $workorderdetails
        ));
    }

    public function actionPrintFinancialOV($id)
    {
        $model = $this->loadModel($id);

        $workorderdetails = new Workorderdetails();
        $workorderdetails->workorderId = $model->workorder_id;





        $htmlcontent = $this->renderInternal('protected/views/jobs/financialOverView_html.php', array('model' => $model, 'workorderdetails' => $workorderdetails), true);

        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        
        $pdfCreator = new PlainPDFCreator(array(
            'title' => 'Financial OverView',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "{$sitePrefix}_FinancialOverView_" . date('dmY') . '.pdf'
        ));

        $pdfCreator->generate();
    }

    public function actionCRM($id)
    {
        $model = $this->loadModel($id);

        $this->render('crm', array(
            'model' => $model,
        ));
    }

    public function actionSummary($id)
    {
        //print_r($_POST);
        $this->render('summery', array(
            'model' => $this->loadModel($id),
        ));
    }

    public function actionJobFlow()
    {
        $model = new Jobs('searchjobflow');
        $focussearcharr = null;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs'])) {
            $model->attributes = $_GET['Jobs'];
        }

        if ($_POST['unfocus-submit-btn']) {

            unset(Yii::app()->session['job_in_focus_id']);
        }

        if (isset(Yii::app()->session['job_in_focus_id'])) {
            $focused_on_id = Yii::app()->session['job_in_focus_id'];
            $jobinfocus = $this->loadModel($focused_on_id);
            $focussearcharr = $jobinfocus->focussearch($jobinfocus->id);
        }

        if (isset($_POST['Jobs']) && isset($_POST['focus-submit-btn']) && isset($_POST['focus-jobs-grid_c0'])) {
            $jobid = $_POST['focus-jobs-grid_c0'][0];

            $jobinfocus = $this->loadModel($jobid);
            $focussearcharr = $jobinfocus->focussearch($jobinfocus->id);
            Yii::app()->session['job_in_focus_id'] = $jobinfocus->id;
        }

        if (SystemOptions::getOptions()->jobDueUrgentAuto == true) {
            $this->daysPriorToCompletionChangeAutoUrgent($model);
        }



        $today = date('Y-m-d', strtotime('now'));
        $loggeduser = Yii::app()->user->id;
        $criteria = new CDbCriteria;
        $criteria->addCondition("isIntrnl = 0 and DATE_FORMAT(followupDtm, '%Y-%m-%d') <= '$today' and createdBy = '$loggeduser' and followedUp = 0 and followupDtm not in ( '0000-00-00 00:00:00', '1970-01-01 00:00:00')");

        $crmdataprovider = new CActiveDataProvider(new SalesLog(), array(
            'criteria' => $criteria,
            'pagination' => false,
            'sort' => array(
                'defaultOrder' => 'followupDtm asc',
            )
        ));

        $criteria2 = new CDbCriteria;
        $criteria2->addCondition("status_id not in (3,17) and urgent_status in (19)");

        if (!User::isAdmin()) {
            $criteria2->addCondition('user_id = ' . Yii::app()->user->id);
        }

        $urgentjobprovider = new CActiveDataProvider(new Jobs(), array(
            'criteria' => $criteria2,
            'pagination' => false,
            'sort' => array(
                'defaultOrder' => 'dueDate asc',
            )
        ));




        $this->render('jobflow', array(
            'model' => $model,
            'focussearcharr' => $focussearcharr,
            'crmdataprovider' => $crmdataprovider,
            'urgentjobprovider' => $urgentjobprovider
        ));
    }

    public function actionToggleDashboardJobComplete()
    {
        if (isset(Yii::app()->session['show_dashboard_completed_jobs'])) {
            unset(Yii::app()->session['show_dashboard_completed_jobs']);
        } else {
            Yii::app()->session['show_dashboard_completed_jobs'] = true;
        }

        echo 'success';
    }

    private function daysPriorToCompletionChangeAutoUrgent($model)
    {
        $JobUrgentAutoPriorDate = (int) GlobalVars::get('JobUrgentAutoPriorDate');
        if ($JobUrgentAutoPriorDate > 0) {
            $priorduedate = date('Y-m-d', strtotime("+$JobUrgentAutoPriorDate day"));


            $urgentJobNumArr = array();
            $jobs = Jobs::model()->findAll(array('condition' => "dueDate = '{$priorduedate}' and status_id not in (17,3) and urgent_status not in (19)"));
            if (!empty($jobs) && count($jobs) > 0) {
                foreach ($jobs as $record) {
                    $record->urgent_status = 19;
                    if ($record->save(false)) {
                        SalesLog::createSalesLog($record->quote_id, $record->workorder_id, $record->quoteNum, 'Job', 'Status is changed to "URGENT" automatically due to ' . $JobUrgentAutoPriorDate . ' days prior to completion. (determined based on the system settings)', 1, 0, 1);
                        $urgentJobNumArr[] = $record->jobNum;
                    }
                }
                $urgentJobNumStr = implode(',', $urgentJobNumArr);
                Yii::app()->user->setFlash('success', "Status of following jobs [ $urgentJobNumStr ] have been changed to 'URGENT' automatically due to $JobUrgentAutoPriorDate days prior to completion.");
            }
        }
    }

    public function actionSetJobFocus($id)
    {
        $model = $this->loadModel($id);
        Yii::app()->session['job_in_focus_id'] = $id;

        $this->redirect(isset($_GET['returnUrl']) ? $_GET['returnUrl'] : array('view', 'id' => $id));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate()
    {

        $customerId = isset($_POST['customerId']) ? $_POST['customerId'] : exit;
        $customer = Customer::model()->findByPk($customerId);

        if(!$customer) {
            exit;
        }

        //count the job creating cliks and use it to stop if too much repetitive
        Yii::app()->session['job_create_count'] = isset(Yii::app()->session['job_create_count']) ? (Yii::app()->session['job_create_count'] + 1) : 1;

        if (Yii::app()->session['job_create_count'] > 5) {

            echo json_encode(array('status' => false, 'message' => "Too much job creatings. Please logout and login again to create new job!")); 
            exit;           
        }

        $transaction = Yii::app()->db->beginTransaction();
        try {

            $factory = new JobFactory;
            $factory->setCustomer($customer);
            $job = $factory->create();

            if (!$job) {                
                $transaction->rollback();
                echo json_encode(array('status' => false, 'message' =>  "Something went wrong! Cannot create new job")); 
            }

            //Set order statuses
            $job->order_base_type = Status::ORDER_BASE_TYPE_JOB;
            $job->save(false);
            $job->workorder->order_base_type = Status::ORDER_BASE_TYPE_JOB;
            $job->workorder->save(false);
            $job->quotation->order_base_type = Status::ORDER_BASE_TYPE_JOB;
            $job->quotation->save(false);

            $transaction->commit();

            $urlQuote = Yii::app()->createUrl('quatation/view', array("id" =>$job->quote_id));
            $linkQuote = CHtml::link($job->quoteNum, $urlQuote, array('target' => '_blank'));

            $urlSO = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $job->workorder->id));
            $linkSO = CHtml::link($job->workorder->salesorderNumber, $urlSO, array('target' => '_blank'));

            $urljob = Yii::app()->createUrl('jobs/view', array("id" => $job->id));
            $linkjob = CHtml::link($job->jobNum, $urljob, array('target' => '_blank'));
            //SalesLog::createSalesLog($job->quote_id,  $job->workorder->id, $job->quoteNum, 'Job', "New dummy job ({$linkjob}) has been created [{$job->jobNum}]", 1, 0, 1);
            SalesLog::createSalesLogTblId($job->quote_id, $job->workorder->id, $job->quoteNum,  $job->quote_id, SalesLog::CATEGORY_QUOTATION, "Quote ({$linkQuote}) created by dummy ({$linkjob})  ", 1, 0, 1);
            SalesLog::createSalesLogTblId($job->quote_id, $job->workorder->id, $job->quoteNum,  $job->id, SalesLog::CATEGORY_SALES_ORDER, "Sales Order ({$linkSO}) created by ({$linkjob})", 1, 0, 1);
            SalesLog::createSalesLogTblId($job->quote_id, $job->workorder->id, $job->quoteNum,  $job->id, 'Job', "New dummy job ({$linkjob}) has been created", 1, 0, 1);
            
            echo json_encode(array('status' => true, 'message' =>  "{$job->jobNum} has been created successfully!")); 
            exit;
        } catch (Exception $ex) {
                        
            echo json_encode(array('status' => false, 'message' => "Cannot create a job [{$ex->getMessage()}]"));    
            $transaction->rollback();
            exit;
        }
    }

    public function actionCreateCopy($id)
    {
        if (Yii::app()->request->isPostRequest) {
            $transaction = Yii::app()->db->beginTransaction();
            $allsaved = true;
            $orginalJob = $this->loadModel($id);
            $originalWorkOrder = $orginalJob->workorder;
            $copyWorkOrder = new Workorder();
            $copyWorkOrder->setAttributes($originalWorkOrder->attributes);
            $workorderquotes = Workorder::model()->findAll("quotationId = '{$originalWorkOrder->quotationId}'");
            $quotecount = count($workorderquotes);
            unset($copyWorkOrder->id);
            $copyWorkOrder->salesorderNumber = "SO-" . $originalWorkOrder->quotationNumber . "-" . (1 + $quotecount);
            $copyWorkOrder->createddate = date("Y-m-d H:i:s");
            $copyWorkOrder->createdby = Yii::app()->user->id;
            if ($copyWorkOrder->save(false)) {
                //copy job
                $copyjob = new Jobs();
                $copyjob->setAttributes($orginalJob->attributes);
                unset($copyjob->id);
                $copyjob->workorder_id = $copyWorkOrder->id;
                $copyjob->jobNum = 'JOB-' . $copyWorkOrder->quotation->quoteno . '-' . $copyWorkOrder->id;
                $copyjob->status_id = 1; //new
                $copyjob->createdDtm = date('Y-m-d H:i:s');
                $copyjob->user_id = Yii::app()->user->id;
                $copyjob->urgent_status = 20;
                $copyjob->originalJobId = $orginalJob->id;
                if (!$copyjob->save(false)) {
                    $allsaved = false;
                }
                $originalWorkOrderDetails = Workorderdetails::model()->findAll(array('condition' => "workorderId = '{$originalWorkOrder->id}'"));
                foreach ($originalWorkOrderDetails as $orginalDtl) {
                    $copyWorkOrderDtl = new Workorderdetails();
                    $copyWorkOrderDtl->setAttributes($orginalDtl->attributes);
                    unset($copyWorkOrderDtl->id);
                    $copyWorkOrderDtl->workorderId = $copyWorkOrder->id;
                    $copyWorkOrderDtl->createdby = Yii::app()->user->id;
                    $copyWorkOrderDtl->createddate = date("Y-m-d H:i:s");
                    if ($copyWorkOrderDtl->save(false)) {

                        $job_product = new JobProducts();
                        $job_product->job_id = $copyjob->id;
                        $job_product->workorderDtl_id = $copyWorkOrderDtl->id;
                        $job_product->qty = $copyWorkOrderDtl->prodQty;
                        $job_product->prodCostPrice = $copyWorkOrderDtl->prodCostPrice;
                        $job_product->status_id = 1; //New
                        $job_product->user_id = Yii::app()->user->id;

                        $allsaved = $job_product->save(false);


                        //copy workorder details decorations     
                        $originalWorkorderDecorations = WorkorderDetailsDecoration::model()->findAll(array('condition' => "workorder_detail_id = '{$orginalDtl->id}'"));


                        foreach ($originalWorkorderDecorations as $orginalDecoDtl) {
                            $copyWorkOrderDecorationDetail = new WorkorderDetailsDecoration();
                            $copyWorkOrderDecorationDetail->setAttributes($orginalDecoDtl->attributes);
                            unset($copyWorkOrderDecorationDetail->id);
                            $copyWorkOrderDecorationDetail->work_order_id = $copyWorkOrder->id;
                            $copyWorkOrderDecorationDetail->workorder_detail_id = $copyWorkOrderDtl->id;

                            if ($copyWorkOrderDecorationDetail->save(false)) {

                                $job_decoration = new JobDecorations();
                                $job_decoration->job_id = $copyjob->id;
                                $job_decoration->workorderDtl_id = $copyWorkOrderDtl->id;
                                $job_decoration->decprtnam = $copyWorkOrderDecorationDetail->decprtnam;
                                $job_decoration->decdesc = $copyWorkOrderDecorationDetail->decdesc;
                                $job_decoration->customdecoration = $copyWorkOrderDecorationDetail->customdecoration;
                                $job_decoration->decoQty = $copyWorkOrderDecorationDetail->quantity;
                                $job_decoration->decoCostPrice = $copyWorkOrderDecorationDetail->cost_price;
                                $job_decoration->decosupref = $copyWorkOrderDecorationDetail->supref;
                                $job_decoration->customizationDetails = $copyWorkOrderDtl->customizationDetails;
                                $job_decoration->status_id = 1; //New
                                $job_decoration->user_id = Yii::app()->user->id;
                                $job_decoration->createdDtm = date('Y-m-d H:i:s');
                                $job_decoration->work_order_detail_decoration_id = $copyWorkOrderDecorationDetail->id;
                                $allsaved = $job_decoration->save(false);

                                $job_product_decoration = new JobProductDecorations();
                                $job_product_decoration->job_id = $copyjob->id;
                                $job_product_decoration->workorderDtl_id = $copyWorkOrderDtl->id;
                                $job_product_decoration->decprtnam = $copyWorkOrderDecorationDetail->decprtnam;
                                $job_product_decoration->decdesc = $copyWorkOrderDecorationDetail->decdesc;
                                $job_product_decoration->customdecoration = $copyWorkOrderDecorationDetail->customdecoration;
                                $job_product_decoration->decoQty = $copyWorkOrderDecorationDetail->quantity;
                                $job_product_decoration->decoCostPrice = $copyWorkOrderDecorationDetail->cost_price;
                                $job_product_decoration->decosupref = $copyWorkOrderDecorationDetail->supref;
                                $job_product_decoration->customizationDetails = $copyWorkOrderDtl->customizationDetails;
                                $job_product_decoration->user_id = Yii::app()->user->id;
                                $job_product_decoration->status_id = 1; //New

                                $job_product_decoration->work_order_detail_decoration_id = $copyWorkOrderDecorationDetail->id;

                                $allsaved = $job_product_decoration->save(false);
                            } else {
                                $allsaved = false;
                            }
                        }
                        //copy qty breaks
                        $originalWorkOrderDtlSizeQtyClrs = Workorderdetailssizecolor::model()->findAll(array('condition' => "workOrderDetailsId = '{$orginalDtl->id}'"));
                        foreach ($originalWorkOrderDtlSizeQtyClrs as $orgSizeQtyClr) {
                            $copyWorkOrderSizeQtyClr = new Workorderdetailssizecolor();
                            $copyWorkOrderSizeQtyClr->setAttributes($orgSizeQtyClr->attributes);
                            unset($copyWorkOrderSizeQtyClr->id);
                            $copyWorkOrderSizeQtyClr->workOrderDetailsId = $copyWorkOrderDtl->id;

                            if (!$copyWorkOrderSizeQtyClr->save(false))
                                $allsaved = false;
                        }                        
                    } else {
                        $allsaved = false;
                    }
                }
            } else {
                $allsaved = false;
            }

            //copy job
            if ($allsaved == true) {
                $transaction->commit();
                Yii::app()->user->setFlash('success', "New job ({$copyjob->jobNum}) has been successfully created as a copy of the job ({$orginalJob->jobNum})");
                $urljob = Yii::app()->createUrl('jobs/view', array("id" => $copyjob->id));
                $linkjob = CHtml::link($copyjob->jobNum, $urljob, array('target' => '_blank'));

                $urlso = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $copyWorkOrder->id));
                $linkso = CHtml::link($copyWorkOrder->salesorderNumber, $urlso, array('target' => '_blank'));

                SalesLog::createSalesLog($copyjob->quote_id, $copyWorkOrder->id, $copyjob->quoteNum, 'Quotation', "New sales order ({$linkso}) is created and converted to a job ({$linkjob})", 1, 0, 1);
                SalesLog::createSalesLog($copyjob->quote_id, $copyWorkOrder->id, $copyjob->quoteNum, 'Job', "New copy of job ({$linkjob}) is created from the job $orginalJob->jobNum", 1, 0, 1);

                $this->redirect(array('admin'));
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', "Cannot create a copy from the job ($orginalJob->jobNum)");

                $this->redirect(array('view', 'id' => $id));
            }
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    public function actionClosesession()
    {
        unset(Yii::app()->session['job']);
        unset(Yii::app()->session['job_activity']);
        unset(Yii::app()->session['job_sales_dtls']);
        unset(Yii::app()->session['job_sales_dtls_deco']);
        $this->redirect(array('admin'));
    }

    public function actionJobsHandler()
    {
        $model = null;
        $job_activity = $_POST['jobactivity'];
        if (isset($_POST['Jobs'])) {
            $model = $this->loadModel($_POST['Jobs']['id']);
        }

        if (isset($_POST['sales-order-grid_c0']) && isset($_POST['jobactivity']) && !empty($model)) {

            $job_product_ids = implode('_', $_POST['sales-order-grid_c0']);



            $pocreated = false;
            foreach ($_POST['sales-order-grid_c0'] as $jobproductid) {
                $jobproduct = JobProducts::model()->findByPk($jobproductid);
                if (!empty($jobproduct)) {
                    if ($jobproduct->po_id > 0)
                        $pocreated = true;
                }
            }

            if ($job_activity == JobActivity::model()->find('activity="Not Applicable"')->id) {
                //when purchasing is not applicable for the selected products
                $notapplicable = false;
                foreach ($_POST['sales-order-grid_c0'] as $jp_id) {

                    $jobdecoration = JobProducts::model()->findByPk($jp_id);
                    $activtyflow = JobActivityFlow::model()->find("job_id = '{$model->id}' and wrkorderDtl_id = '{$jobdecoration->workorderDtl_id}' and type = 'Product' and activity = 'Not Applicable' and flowjob_id = '$jp_id'");
                    if (!empty($activtyflow))
                        $notapplicable = true;
                }

                if ($notapplicable == true) {
                    Yii::app()->user->setFlash('notice', "Cannot apply this task! There are some jobs in progressing.");
                    $this->redirect(array('view', 'id' => $model->id));
                } else {
                    $this->redirect(array('decorationNA', 'job_id' => $model->id, 'jp_ids' => $job_product_ids));
                }
            } else if ($pocreated == false) {
                //Yii::app()->session['job'] = $model->id;
                //Yii::app()->session['job_activity'] = $_POST['jobactivity'];
                //Yii::app()->session['job_product_ids'] = implode(',', $_POST['sales-order-grid_c0']);

                if ($job_activity == JobActivity::model()->find('activity="Purchase Products"')->id) {


                    $this->redirect(array('purchaseOrders/create', 'job_id' => $model->id, 'job_activity' => $job_activity, 'jp_ids' => $job_product_ids));
                }
            } else {
                Yii::app()->user->setFlash('notice', "Cannot proceed. Purchuse order(s) have already created for selected item(s).");
                $this->redirect(array('view', 'id' => $model->id));
            }
            //            else if ($_POST['jobactivity'] == JobActivity::model()->find('activity="Allocate From Inventory"')->id) {
            //                $this->redirect(array('productallocate'));
            //            }
        } else if (isset($_POST['sales-order-decoration-grid_c0']) && isset($_POST['jobactivity']) && !empty($model)) {

            $job_decoration_ids = implode('_', $_POST['sales-order-decoration-grid_c0']);
            if ($_POST['jobactivity'] == JobActivity::model()->find('activity="Artwork Job"')->id) {
                $this->redirect(array('jobArtwork/create', 'job_id' => $model->id, 'jd_ids' => $job_decoration_ids));
            } else if ($_POST['jobactivity'] == JobActivity::model()->find('activity="Artwork (Internal Job)"')->id) {
                $artworkcreated = false;


                foreach ($_POST['sales-order-decoration-grid_c0'] as $flowid) {
                    $intrnjobdtl = InternalJobsDetails::model()->find("jobflow_id = '$flowid'");

                    if (!empty($intrnjobdtl)) {
                        $artworkcreated = true;
                        break;
                    }
                }

                if ($artworkcreated == false) {
                    $this->redirect(array('internalJobs/create', 'job_id' => $model->id, 'jd_ids' => $job_decoration_ids));
                } else if ($artworkcreated == true) {
                    Yii::app()->user->setFlash('notice', "Cannot proceed. Artwork decoration has taken place for the some of selected items.");
                    $this->redirect(array('view', 'id' => $model->id));
                }
            } else if ($_POST['jobactivity'] == JobActivity::model()->find('activity="Purchase Artwork"')->id) {


                $purchaseartwork = false;
                foreach ($_POST['sales-order-decoration-grid_c0'] as $jd_id) {


                    $jobdecoration2 = JobDecorations::model()->find("id = '$jd_id' and decoJobType = 'Purchase Artwork' and (po_id is not null or po_id <> '') ");

                    if (!empty($jobdecoration2))
                        $purchaseartwork = true;
                }

                if ($purchaseartwork == true) {
                    Yii::app()->user->setFlash('notice', "Cannot proceed. Purchuse order(s) have already created for selected item(s).");
                    $this->redirect(array('view', 'id' => $model->id));
                } else {

                    $this->redirect(array('purchaseOrders/purchaseArtwork', 'job_id' => $model->id, 'jd_ids' => $job_decoration_ids));
                }
            } else if ($_POST['jobactivity'] == JobActivity::model()->find('activity="Artwork (Use Exist)"')->id) {

                $artworkallocate = false;
                foreach ($_POST['sales-order-decoration-grid_c0'] as $jd_id) {


                    $jobdecoration2 = JobDecorations::model()->find("id = '$jd_id' and job_id = '{$model->id}' and decoJobType = 'Inventory Artwork' ");

                    if (!empty($jobdecoration2))
                        $artworkallocate = true;
                }
                if ($artworkallocate == true) {
                    Yii::app()->user->setFlash('notice', "Cannot proceed. Artwork(s) have already allocated  for the some selected items.");
                    $this->redirect(array('view', 'id' => $model->id));
                } else {
                    $this->redirect(array('artworkallocate', 'job_id' => $model->id, 'jd_ids' => $job_decoration_ids));
                }
            } else if ($_POST['jobactivity'] == JobActivity::model()->find('activity="Not Applicable"')->id) {

                $notapplicable = false;
                foreach ($_POST['sales-order-decoration-grid_c0'] as $jd_id) {

                    $jobdecoration = JobDecorations::model()->findByPk($jd_id);
                    $activtyflow = JobActivityFlow::model()->find("job_id = '{$model->id}' and wrkorderDtl_id = '{$jobdecoration->workorderDtl_id}' and type = 'Decoration' and activity = 'Not Applicable' and flowjob_id = '$jd_id'");
                    if (!empty($activtyflow))
                        $notapplicable = true;
                }

                if ($notapplicable == true) {
                    Yii::app()->user->setFlash('notice', "Cannot apply this task! There are some jobs in progressing.");
                    $this->redirect(array('view', 'id' => $model->id));
                } else {
                    $this->redirect(array('decorationNA', 'job_id' => $model->id, 'jd_ids' => $job_decoration_ids));
                }
            }
        } else if (isset($_POST['salesorder-product-decoration-grid_c0']) && isset($_POST['jobactivity'])) {
            //start
            $job_decoration_product_ids = implode('_', $_POST['salesorder-product-decoration-grid_c0']);

            $commondecoID = 0;
            if (isset($_POST['usedeco']))
                $commondecoID = $_POST['usedeco'][0];

            if ($job_activity == JobActivity::model()->find('activity="Purchase Product-Decoration"')->id) {




                //$allhavejobs = true;
                $pocreated = false;

                foreach ($_POST['salesorder-product-decoration-grid_c0'] as $jdp_id) {

                    $job_decoration_product = JobProductDecorations::model()->findByPk($jdp_id);

                    if (!empty($job_decoration_product->po_id))
                        $pocreated = true;
                }

                if ($pocreated == false) {

                    $this->redirect(array('purchaseOrders/create', 'job_id' => $model->id, 'job_activity' => $job_activity, 'jpd_ids' => $job_decoration_product_ids, 'comndecid' => $commondecoID));
                } else if ($pocreated == true) {
                    Yii::app()->user->setFlash('notice', "Cannot proceed. Purchuse order(s) have already created for selected item(s).");
                    $this->redirect(array('view', 'id' => $model->id));
                }
                //                else if ($allhavejobs == false) {
                //                    Yii::app()->user->setFlash('notice', "Cannot proceed. Some of products have no jobs");
                //                    $this->redirect(array('view', 'id' => $job->id));
                //                }
            } else if ($_POST['jobactivity'] == JobActivity::model()->find('activity="Sub Jobs"')->id) {
                //Sub Jobs
                $this->redirect(array('pdSubJob/create', 'job_id' => $model->id, 'jpd_ids' => $job_decoration_product_ids));
                //end sub jobs
            } else if ($_POST['jobactivity'] == JobActivity::model()->find('activity="Not Applicable"')->id) {

                $notapplicable = false;
                foreach ($_POST['salesorder-product-decoration-grid_c0'] as $jd_id) {

                    $jobprddecoration = JobProductDecorations::model()->findByPk($jd_id);
                    $activtyflow = JobActivityFlow::model()->find("job_id = '{$model->id}' and wrkorderDtl_id = '{$jobprddecoration->workorderDtl_id}' and type = 'Product-Decoration' and activity = 'Not Applicable' and flowjob_id = '$jd_id'");
                    if (!empty($activtyflow))
                        $notapplicable = true;
                }

                if ($notapplicable == true) {
                    Yii::app()->user->setFlash('notice', "Cannot apply this task! There are some jobs in progressing.");
                    $this->redirect(array('view', 'id' => $model->id));
                } else {
                    $this->redirect(array('decorationNA', 'job_id' => $model->id, 'jpd_ids' => $job_decoration_product_ids));
                }
            } else {
                Yii::app()->user->setFlash('notice', "Unexpected conditions. Please try again!");
                $this->redirect(array('view', 'id' => $model->id));
            }
            //end product-decoration
        } else {
            Yii::app()->user->setFlash('notice', "Please select at least one item to proceed.");
            $this->redirect(array('view', 'id' => $model->id));
        }

        //        if (!isset($_POST['sales-order-grid_c0']) || !isset($_POST['sales-order-decoration-grid_c0']) || !isset($_POST['salesorder-product-decoration-grid_c0'])) {
        //            Yii::app()->user->setFlash('notice', "Please select item(s) for jobs");
        //            $this->redirect(array('view', 'id' => $model->id));
        //        }
    }

    public function actionProductDecorationSubJobs()
    {
        print_r($_POST);
        $subjobs = new SubArtworkJob('search');
        $subjobs->unsetAttributes();  // clear any default values
        if (isset($_GET['SubArtworkJob']))
            $subjobs->attributes = $_GET['SubArtworkJob'];



        if (isset($_GET['job_id']) && isset($_GET['jpd_ids'])) {
            $job_id = $_GET['job_id'];
            $job_product_decoration_ids = $_GET['jpd_ids'];
            $job = Jobs::model()->findByPk($job_id);
            $salesorder = $job->workorder;
            $jobproductdecorationStrIds = str_replace('_', ',', $job_product_decoration_ids);
            $dataProvider = null;

            if (!empty($jobproductdecorationStrIds)) {
                $dataProvider = new CActiveDataProvider('JobProductDecorations', array(
                    'criteria' => array(
                        'condition' => " id in ({$jobproductdecorationStrIds})",
                    ),
                    'pagination' => false,
                ));
            }

            $this->render('pdsubjobs', array(
                'job' => $job,
                'salesorder' => $salesorder,
                'dataProvider' => $dataProvider,
                'subjobs' => $subjobs,
            ));
        }
    }

    public function actionArtworkallocate()
    {
        //print_r($_POST);
        $model = null;



        if (isset($_GET['job_id']) && isset($_GET['jd_ids']) && !isset($_POST['yt0'])) {
            $model = $this->loadModel($_GET['job_id']);
            $jobdecorationStrIds = str_replace('_', ',', $_GET['jd_ids']);

            $dataProvider = new CActiveDataProvider('JobDecorations', array(
                'criteria' => array(
                    'condition' => " id in ({$jobdecorationStrIds})",
                ),
                'pagination' => false,
            ));

            $this->render('artworkallocate', array(
                'model' => $model,
                'dataProvider' => $dataProvider,
            ));
        } else if (isset($_POST['yt0']) && isset($_POST['InventoryArtWork'])) {
            $artworkarr = $_POST['inventory-art-work-grid_c0'];
            $artwork = InventoryArtWork::model()->findByPk($artworkarr[0]);
            $jobdecorationarr = $_POST['JobDecorations'];
            $jobs_id = $_POST['Jobs']['id'];
            //$job = Jobs::model()->findByPk($jobs_id);
            $slogdetails = "";
            foreach ($jobdecorationarr as $dtlsid) {
                $jobdecoration = JobDecorations::model()->findByPk($dtlsid);
                $wrkorddtl = $jobdecoration->workorderDtl;

                $slogdetails .= !empty($wrkorddtl->productsku) ? $wrkorddtl->prdsrtdesc . " x {$wrkorddtl->prodQty}," : $wrkorddtl->custmproduct . " x {$wrkorddtl->prodQty},";




                $jobdecoration->decoJobType = 'Inventory Artwork';
                $jobdecoration->artwork_id = $artwork->id;

                $jobdecoration->status_id = 16; //Artwork Allocated
                $jobdecoration->user_id = Yii::app()->user->id;
                $jobdecoration->createdDtm = date("Y-m-d g:i");

                $jobdecoration->save();

                $jobactivityflow = new JobActivityFlow();
                $jobactivityflow->job_id = $jobs_id;
                $jobactivityflow->wrkorder_id = $wrkorddtl->workorderId;
                $jobactivityflow->wrkorderDtl_id = $dtlsid;
                $jobactivityflow->type = 'Decoration';
                $jobactivityflow->activity = 'Artwork Allocated';
                $jobactivityflow->flowjob_id = $dtlsid;
                $jobactivityflow->save();
            }

            $job = Jobs::model()->findByPk($jobs_id);
            $job->status_id = 18; //Job In Progressing
            $job->save();

            $url = Yii::app()->createUrl('inventoryArtWork/view', array("id" => $artwork->id));
            $link = CHtml::link($artwork->artworkcode, $url, array('target' => '_blank'));
            SalesLog::createSalesLog($job->workorder->quotationId, $job->workorder->id, $job->workorder->quotationNumber, 'Job', "Artwork ({$link}) is allocated for the decoration of products ($slogdetails) ", 1, 1, 1);


            $this->redirect(array('view', 'id' => $jobs_id));
        } else {
            $this->redirect(array('view', 'id' => $model->id));
        }
    }

    public function actionEndDecoration()
    {
        if (isset($_GET['job_id']) && isset($_GET['wodtls_id'])) {
            $jobdecoration = JobDecorations::model()->findByPk($_GET['jd_id']);

            $jobactivityflow = new JobActivityFlow();
            $jobactivityflow->job_id = $jobdecoration->job_id;
            $jobactivityflow->wrkorder_id = $jobdecoration->workorderDtl->workorderId;
            $jobactivityflow->wrkorderDtl_id = $jobdecoration->workorderDtl_id;
            $jobactivityflow->type = 'Decoration';
            $jobactivityflow->activity = 'Job End';
            $jobactivityflow->flowjob_id = $jobdecoration->id;
            $jobactivityflow->save();
            $this->redirect(array('view', 'id' => $jobdecoration->job_id));
        }
    }

    public function actionDecorationNA()
    {
        if (isset($_GET['job_id']) && isset($_GET['jd_ids'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $allsaved = true;
            $job = $this->loadModel($_GET['job_id']);

            $jobdecorationArr = explode('_', $_GET['jd_ids']);


            foreach ($jobdecorationArr as $dtlid) {

                $jobdecoration = JobDecorations::model()->findByPk($dtlid);

                $jobactivityflow = new JobActivityFlow();
                $jobactivityflow->job_id = $job->id;
                $jobactivityflow->wrkorder_id = $job->workorder_id;
                $jobactivityflow->wrkorderDtl_id = $jobdecoration->workorderDtl_id;
                $jobactivityflow->type = 'Decoration';
                $jobactivityflow->activity = 'Not Applicable';
                $jobactivityflow->flowjob_id = $dtlid;
                if (!$jobactivityflow->save())
                    $allsaved = false;


                $jobactivityflow2 = new JobActivityFlow();
                $jobactivityflow2->job_id = $job->id;
                $jobactivityflow2->wrkorder_id = $job->workorder_id;
                $jobactivityflow2->wrkorderDtl_id = $jobdecoration->workorderDtl_id;
                $jobactivityflow2->type = 'Decoration';
                $jobactivityflow2->activity = 'Job End';
                $jobactivityflow2->flowjob_id = $dtlid;
                if (!$jobactivityflow2->save())
                    $allsaved = false;
            }

            if ($allsaved) {
                $transaction->commit();
                Yii::app()->user->setFlash('success', "Successfully applied");
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', "Failed to applly 'Not Applicable'");
            }

            $this->redirect(array('view', 'id' => $job->id));
        } else if (isset($_GET['job_id']) && isset($_GET['jpd_ids'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $allsaved = true;
            $job = $this->loadModel($_GET['job_id']);

            $jobdecorationArr = explode('_', $_GET['jpd_ids']);


            foreach ($jobdecorationArr as $dtlid) {

                $jobprddecoration = JobProductDecorations::model()->findByPk($dtlid);

                $jobactivityflow = new JobActivityFlow();
                $jobactivityflow->job_id = $job->id;
                $jobactivityflow->wrkorder_id = $job->workorder_id;
                $jobactivityflow->wrkorderDtl_id = $jobprddecoration->workorderDtl_id;
                $jobactivityflow->type = 'Product-Decoration';
                $jobactivityflow->activity = 'Not Applicable';
                $jobactivityflow->flowjob_id = $dtlid;
                if (!$jobactivityflow->save())
                    $allsaved = false;


                $jobactivityflow2 = new JobActivityFlow();
                $jobactivityflow2->job_id = $job->id;
                $jobactivityflow2->wrkorder_id = $job->workorder_id;
                $jobactivityflow2->wrkorderDtl_id = $jobprddecoration->workorderDtl_id;
                $jobactivityflow2->type = 'Product-Decoration';
                $jobactivityflow2->activity = 'Job End';
                $jobactivityflow2->flowjob_id = $dtlid;
                if (!$jobactivityflow2->save())
                    $allsaved = false;
            }


            if ($allsaved) {
                $transaction->commit();
                Yii::app()->user->setFlash('success', "Successfully applied");
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', "Failed to applly 'Not Applicable'");
            }

            $this->redirect(array('view', 'id' => $job->id));
        } else if (isset($_GET['job_id']) && isset($_GET['jp_ids'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $allsaved = true;
            $job = $this->loadModel($_GET['job_id']);


            $jobproductArr = explode('_', $_GET['jp_ids']);

            foreach ($jobproductArr as $dtlid) {

                $jobproduct = JobProducts::model()->findByPk($dtlid);

                $jobactivityflow = new JobActivityFlow();
                $jobactivityflow->job_id = $job->id;
                $jobactivityflow->wrkorder_id = $job->workorder_id;
                $jobactivityflow->wrkorderDtl_id = $jobproduct->workorderDtl_id;
                $jobactivityflow->type = 'Product';
                $jobactivityflow->activity = 'Not Applicable';
                $jobactivityflow->flowjob_id = $dtlid;
                if (!$jobactivityflow->save())
                    $allsaved = false;


                $jobactivityflow2 = new JobActivityFlow();
                $jobactivityflow2->job_id = $job->id;
                $jobactivityflow2->wrkorder_id = $job->workorder_id;
                $jobactivityflow2->wrkorderDtl_id = $jobproduct->workorderDtl_id;
                $jobactivityflow2->type = 'Product';
                $jobactivityflow2->activity = 'Job End';
                $jobactivityflow2->flowjob_id = $dtlid;
                if (!$jobactivityflow2->save())
                    $allsaved = false;
            }


            if ($allsaved) {
                $transaction->commit();
                Yii::app()->user->setFlash('success', "Successfully applied");
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', "Failed to applly 'Not Applicable'");
            }

            $this->redirect(array('view', 'id' => $job->id));
        }
    }

    public function actionJobsComplete($id)
    {
        $model = $this->loadModel($id);
        $status = Status::model()->find(array('condition' => "name = 'Job Completed'"));
        if (!$status) {
            Yii::app()->user->setFlash('notice', "Cannot complete the {$model->jobNum}. System status cannot be found! Please contact your admin!");
            $this->redirect(array('view', 'id' => $model->id));
        }
        $model->status_id = $status->id;

        $followupstats = FollowupStatus::model()->find(array('condition' => "status = 'Job Completed' and type = 'Job'"));
        if (!$followupstats) {
            Yii::app()->user->setFlash('notice', "Cannot complete the {$model->jobNum}. Followup status cannot be found! Please contact your admin!");
            $this->redirect(array('view', 'id' => $model->id));
        }

        $model->followupStatus = $followupstats->id;

        if ($model->save()) {
            //add crm status
            $salesLog = new SalesLog();
            $salesLog->quoteId = $model->workorder->quotationId;
            $salesLog->workorderId = $model->workorder->id;
            $salesLog->quoteNum = $model->workorder->quotationNumber;
            $salesLog->comments = "Internal process has taken place. Both system and user followup status have been changed as 'Job Complete'";
            $salesLog->category = 'Job';
            $salesLog->tbl_id = $model->id;
            $salesLog->followupSts_id = $model->followupStatus;
            $salesLog->save(false);

            //close all the PO related to the job
            $relatedPOs = PurchaseOrders::model()->findAll("job_id = {$model->id}");

            foreach ($relatedPOs as $po) {
                $po->followup_status_id = SystemOptions::getOptions()->poFollowupStatusForCompleted;
                $po->mapFollowupStatusForSystemStatus();
                $po->save(false);
            }

            //close all production jobs
            $jobProducts = JobProducts::model()->findAll("job_id = {$model->id}");

            foreach ($jobProducts as $jp) {
                $jp->status_id = Status::SYS_STATUS_SUBJOB_DONE;
                $jp->save();
            }

            //close all production jobs
            $jobProductDecorations = JobProductDecorations::model()->findAll("job_id = {$model->id}");

            foreach ($jobProductDecorations as $jpd) {
                $jpd->status_id = Status::SYS_STATUS_SUBJOB_DONE;
                $jpd->save();
            }

            Yii::app()->user->setFlash('success', "Job {$model->jobNum} successfully completed");
            $this->redirect(array('view', 'id' => $model->id));
        } else {
            Yii::app()->user->setFlash('notice', "Cannot complete the {$model->jobNum}. Please try again.");
            $this->redirect(array('view', 'id' => $model->id));
        }
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id)
    {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Jobs'])) {
            $model->attributes = $_POST['Jobs'];
            if ($model->save()) {
                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Job header updated ", 1, 1, 1);
                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    public function actionCancel($id)
    {

        $model = $this->loadModel($id);

        if (isset($_POST['Jobs']) && !empty($_POST['Jobs']['cancel_reason'])) {
            $model = $this->loadModel($_POST['Jobs']['id']);
            $reasontxt = $_POST['Jobs']['cancel_reason'];
            $model->status_id = 3;
            if ($model->save()) {
                if (isset(Yii::app()->session['job_in_focus_id'])) {
                    if (Yii::app()->session['job_in_focus_id'] == $model->id) {
                        unset(Yii::app()->session['job_in_focus_id']);
                    }
                }

                $followupstats = FollowupStatus::model()->find(array('condition' => "type = 'Job' and status = 'Job Cancelled'"));
                //add crm status
                $salesLog = new SalesLog();
                $salesLog->quoteId = $model->workorder->quotationId;
                $salesLog->workorderId = $model->workorder->id;
                $salesLog->quoteNum = $model->workorder->quotationNumber;

                $salesLog->category = 'Job';
                $salesLog->tbl_id = $model->id;
                $salesLog->followupSts_id = $followupstats->id;
                if ($salesLog->save(false)) {
                    $url = Yii::app()->createUrl('jobs/view', array("id" => $model->id));
                    $link = CHtml::link($model->jobNum, $url, array('target' => '_blank'));

                    SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Quotation', "Job ($link) is cancelled due to {$reasontxt} ", 0, 1, 1);
                    SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Job ($link) is cancelled due to {$reasontxt} ", 0, 1, 1);

                    Yii::app()->user->setFlash('success', "$model->jobNum has been cancelled successfully.");
                    $this->redirect(array('admin'));
                }
            } else {
                Yii::app()->user->setFlash('error', "Cannot cancelled the job.");
            }
        }

        $this->render('_cancel', array(
            'model' => $model,
        ));
    }

    public function actionCancelRevoke($id)
    {

        $model = $this->loadModel($id);
        $status = Status::model()->find(array('condition' => "name = 'Job In Progress'"));
        $model->status_id = $status->id;

        if ($model->save()) {
            $followupstats = FollowupStatus::model()->find(array('condition' => "type = 'Job' and status = 'Cancelled job reinstated'"));
            //add crm status
            $salesLog = new SalesLog();
            $salesLog->quoteId = $model->workorder->quotationId;
            $salesLog->workorderId = $model->workorder->id;
            $salesLog->quoteNum = $model->workorder->quotationNumber;

            $salesLog->category = 'Job';
            $salesLog->tbl_id = $model->id;
            $salesLog->followupSts_id = $followupstats->id;
            if ($salesLog->save(false)) {
                SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Status is changed to {$followupstats->status}", 1, 1, 1);
                Yii::app()->user->setFlash('success', "Job has been reinstated successfully.");
            }
        } else {
            Yii::app()->user->setFlash('error', "Cannot reinstate the job!");
        }

        $this->redirect(array('view', 'id' => $model->id));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id)
    {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex()
    {
        $dataProvider = new CActiveDataProvider('Jobs');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin()
    {
        //        $xmlWidget = new XMLWidget();
        //        $testjobs = Jobs::model()->findAll(array('order'=>'id desc','limit'=>10));
        //        $xmlWidget->models = $testjobs;
        //        $xmloutput = $xmlWidget->runJobs();
        //        file_put_contents('someFile.xml', $xmloutput);

        $model = new Jobs('search');

        if (isset($_POST['Jobs']['show_completed_jobs'])) {

            if ($_POST['Jobs']['show_completed_jobs'] == 1) {
                $model->show_completed_jobs = 1;
                Yii::app()->session['show_completed_jobs'] = true;
            } else {
                unset(Yii::app()->session['show_completed_jobs']);
                $model->show_completed_jobs = 0;
            }
        }

        if (isset($_POST['Jobs']['show_cancelled_jobs'])) {

            if ($_POST['Jobs']['show_cancelled_jobs'] == 1) {
                $model->show_cancelled_jobs = 1;
                Yii::app()->session['show_cancelled_jobs'] = true;
            } else {
                unset(Yii::app()->session['show_cancelled_jobs']);
                $model->show_cancelled_jobs = 0;
            }
        }

        //$model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        if (isset($_GET['pastdue']) && $_GET['pastdue'] == 1)
            $model->filterPastDue = true;

        if (isset($_GET['urgent']) && $_GET['urgent'] == 1)
            $model->urgent_status = 19;

        if (isset($_GET['newjb']) && $_GET['newjb'] == 1)
            $model->status_id = 1;

        if (isset($_GET['prgjb']) && $_GET['prgjb'] == 1)
            $model->status_id = 18;

        if (isset($_GET['totout']) && $_GET['totout'] == 1)
            $model->totout = true;

        if (isset($_GET['xnameprd']) && $_GET['xnameprd'] == 1)
            $model->isXNameProduction = 1;

        $selectcustomers = new Customer('search');
        $selectcustomers->unsetAttributes();  // clear any default values   
        if (isset($_GET['Customer']))
            $selectcustomers->attributes = $_GET['Customer'];


        $this->render('admin', array(
            'model' => $model,
            'selectcustomers' => $selectcustomers
        ));
    }

    public function actionDueReport()
    {
        $model = new Jobs('searchDue(7)');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        $this->render('due_report', array(
            'model' => $model,
        ));
    }

    public function actionAdminByCoordinator()
    {
        $model = new Jobs('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        $this->render('admin_by_coordinator', array(
            'model' => $model,
        ));
    }

    public function actionJobadmin()
    {
        $model = new Jobs('searchSummary');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        $this->render('jobadmin', array(
            'model' => $model,
        ));
    }

    public function actionCustomReport()
    {

        $model = new Jobs('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs'])) {
            $model->attributes = $_GET['Jobs'];
            if (isset(Yii::app()->session['customrpt_dt_frm']))
                $model->datefrom = Yii::app()->session['customrpt_dt_frm'];
            if (isset(Yii::app()->session['customrpt_dt_to']))
                $model->dateto = Yii::app()->session['customrpt_dt_to'];
        }


        //this array will hold the user selected fields
        $selectedFields = array();
        $userID = Yii::app()->user->id;
        $customReport = null;
        //check whether this user has already selcted fields
        $customReport = CustomReport::model()->find(array('condition' => "typeOfRpt = 'JOB_CUSTOM_REPORT' and userId = '{$userID}'"));
        if (!empty($customReport)) {
            //if user has a history of selcted fields then retrieve those into selected array
            $selectedFields = explode(',', $customReport->selectedFields);
        }

        //if user hit the "Create" btn
        if (isset($_POST['yt0'])) {
            //save post array to another array
            $postarr = $_POST;
            //remove selected fields if have
            $selectedFields = array();
            //iterate post array and insert selected fields which has value "1" into "selectedFields" array
            foreach ($postarr as $key => $val) {
                if ($val == 1) {
                    $selectedFields[] = $key;
                }
            }
            //convert selected fields array into string to be possible to insert into database table
            $selectedFieldsStr = implode(',', $selectedFields);

            //if this user already has selected fields history
            if (!empty($customReport)) {
                //replace with new selected records
                $customReport->selectedFields = $selectedFieldsStr;
                $customReport->save();
            } else {
                //if user is new then create new insert record with selcted fields
                $customReport = new CustomReport();
                $customReport->typeOfRpt = 'JOB_CUSTOM_REPORT';
                $customReport->selectedFields = $selectedFieldsStr;
                $customReport->userId = Yii::app()->user->id;
                $customReport->createdDate = date('Y-m-d', strtotime('now'));
                $customReport->save();
            }
        }


        if (isset($_POST['Jobs']) && isset($_POST['cus-jobsearch-btn'])) {
            $model->attributes = $_POST['Jobs'];
            if (!empty($model->datefrom)) {
                Yii::app()->session['customrpt_dt_frm'] = $model->datefrom;
            }
            if (!empty($model->dateto)) {
                Yii::app()->session['customrpt_dt_to'] = $model->dateto;
            }
        }

        if (isset($_POST['Jobs']) && isset($_POST['cus-jobsearch-reset'])) {
            unset(Yii::app()->session['customrpt_dt_frm']);
            unset(Yii::app()->session['customrpt_dt_to']);
        }

        if (empty($model->datefrom) && !empty(Yii::app()->session['customrpt_dt_frm'])) {
            $model->datefrom = Yii::app()->session['customrpt_dt_frm'];
        }
        if (empty($model->dateto) && !empty(Yii::app()->session['customrpt_dt_to'])) {
            $model->dateto = Yii::app()->session['customrpt_dt_to'];
        }
        //print_r($_POST);


        $this->render('custom_report', array(
            'model' => $model,
            'customReport' => $customReport,
            'selectedFields' => $selectedFields,
        ));
    }

    public function actionCustomReportExcel()
    {
        if (isset(Yii::app()->session['job_cus_rpt_qry'])) {
            $query = Yii::app()->session['job_cus_rpt_qry'];


            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData) && count($rawData) == 0)
                $this->redirect(array('customReport'));



            Yii::import('ext.phpexcel.XPHPExcel');
            $objPHPExcel = XPHPExcel::createPHPExcel();
            $objPHPExcel->getProperties()->setCreator(Yii::app()->name)
                ->setLastModifiedBy(Yii::app()->name)
                ->setTitle("Job Custom Report")
                ->setSubject("Job Custom Report")
                ->setDescription("Job Custom Report")
                ->setKeywords("Job Custom Report")
                ->setCategory("Job Custom Report");



            $userID = Yii::app()->user->id;
            $customReport = null;
            //check whether this user has already selcted fields
            $customReport = CustomReport::model()->find(array('condition' => "typeOfRpt = 'JOB_CUSTOM_REPORT' and userId = '{$userID}'"));
            $selectedFields = array();
            if (!empty($customReport)) {
                //if user has a history of selcted fields then retrieve those into selected array
                $selectedFields = explode(',', $customReport->selectedFields);
            }

            $column = array();
            $columnLetter = 'A';
            $numberOfColumns = 3;

            //if(Yii::app()->session['invr_imageFlag'] == 1)
            $column[$columnLetter] = 'No';
            $column[++$columnLetter] = 'Created Date';
            $column[++$columnLetter] = 'Job Number';
            if (in_array("job_name", $selectedFields)) {
                $column[++$columnLetter] = 'Job Name';
                ++$numberOfColumns;
            }
            if (in_array("quote_number", $selectedFields)) {
                $column[++$columnLetter] = 'Quotation Number';
                ++$numberOfColumns;
            }
            if (in_array("so_number", $selectedFields)) {
                $column[++$columnLetter] = 'Sales Order';
                ++$numberOfColumns;
            }
            if (in_array("master_customer", $selectedFields)) {
                $column[++$columnLetter] = 'Master Customer';
                ++$numberOfColumns;
            }
            if (in_array("customer", $selectedFields)) {
                $column[++$columnLetter] = 'Customer';
                ++$numberOfColumns;
            }
            if (in_array("sales_person", $selectedFields)) {
                $column[++$columnLetter] = 'Sales Person';
                ++$numberOfColumns;
            }
            $column[++$columnLetter] = 'Status';
            ++$numberOfColumns;
            if (in_array("due_date", $selectedFields)) {
                $column[++$columnLetter] = 'Due Date';
                ++$numberOfColumns;
            }
            if (in_array("urgent_field", $selectedFields)) {
                $column[++$columnLetter] = 'Urgent Status';
                ++$numberOfColumns;
            }
            if (in_array("offshore", $selectedFields)) {
                $column[++$columnLetter] = 'Offshore/Normal';
                ++$numberOfColumns;
            }

            $columnEndLetter = $columnLetter;


            $titleStartColumn = (int) ($numberOfColumns / 2);
            $titleStartLetter = 'A';
            for ($i = 0; $i < $titleStartColumn; $i++) {
                $titleStartLetter++;
            }

            $datefrom = '';
            if (isset(Yii::app()->session['customrpt_dt_frm'])) {
                $datefrom = date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime(Yii::app()->session['customrpt_dt_frm']));
            }
            $dateto = '';
            if (isset(Yii::app()->session['customrpt_dt_to'])) {
                $dateto = date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime(Yii::app()->session['customrpt_dt_to']));
            }

            $datetitle = '';
            if (!empty($datefrom) && !empty($dateto)) {
                $datetitle = "Date From :  $datefrom    To   $dateto";
            } else if (!empty($datefrom) && empty($dateto)) {
                $datetitle = "Date From : $datefrom";
            } else if (empty($datefrom) && !empty($dateto)) {
                $datetitle = "Date To : $dateto";
            }

            if (!empty($datetitle)) {
                $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($titleStartLetter . '2', $datetitle);
            }

            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue($titleStartLetter . '3', Yii::app()->name)
                ->setCellValue($titleStartLetter . '4', Yii::app()->name . " - Job Custom Report ")
                ->setCellValue($titleStartLetter . '6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

            foreach ($column as $key => $val) {
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '9', $val);
            }

            $sheet = $objPHPExcel->getActiveSheet();


            foreach ($column as $key => $val) {
                $sheet->getColumnDimension($key)->setAutoSize(true);
            }


            $mergeToCellLetter = $titleStartLetter;
            ++$mergeToCellLetter;
            $sheet->mergeCells("{$titleStartLetter}3:{$mergeToCellLetter}3");
            $sheet->mergeCells("{$titleStartLetter}4:{$mergeToCellLetter}4");
            $sheet->mergeCells("{$titleStartLetter}5:{$mergeToCellLetter}5");
            $sheet->mergeCells("{$titleStartLetter}6:{$mergeToCellLetter}6");

            $sheet->getStyle("{$titleStartLetter}3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
            $sheet->getStyle("{$titleStartLetter}4")->applyFromArray(array("font" => array("bold" => true)));

            $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
            $sheet->getStyle("A9:{$columnEndLetter}9")->applyFromArray(array("font" => array("bold" => true)));

            $row = 12;
            $count = 1;
            foreach ($rawData as $item) {
                $duedate = date(GlobalVars::get("DateFormat"), strtotime($item['dueDate']));
                if (empty($item['dueDate']))
                    $duedate = "Not Set";
                $columnLetter = 'A';
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($columnLetter . $row, $count);
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, date(GlobalVars::get("DateFormat"), strtotime($item['createdDtm'])));
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, $item['jobNum']);
                if (in_array("job_name", $selectedFields))
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, $item['jobname']);
                if (in_array("quote_number", $selectedFields))
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, $item['quoteNum']);
                if (in_array("so_number", $selectedFields))
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, Workorder::model()->findByPk($item['workorder_id'])->salesorderNumber);
                if (in_array("master_customer", $selectedFields))
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, MasterCustomer::model()->find(array('condition' => "mcussno = '{$item['mastercusno']}'"))->mcusnam);
                if (in_array("customer", $selectedFields))
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, Customer::model()->find(array('condition' => "cuscus_fref = '{$item['cus_fref']}'"))->cusnam);
                if (in_array("sales_person", $selectedFields))
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, $item['ws_user']);
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, Status::model()->findByPk($item['status_id'])->name);
                if (in_array("due_date", $selectedFields))
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, $duedate);
                if (in_array("urgent_field", $selectedFields))
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, Status::model()->findByPk($item['urgent_status'])->name);
                if (in_array("offshore", $selectedFields))
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(++$columnLetter . $row, ($item['isXNameProduction'] ? "OFFSHORE" : "NORMAL"));


                $row++;
                $count++;
            }

            // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            header('Content-Disposition: attachment;filename="'.$sitePrefix.'_CustomerJobs_' . date('dmY') . '.xls"');
            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');

            // If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');

            Yii::app()->end();
        } else {
            $this->redirect(array('customReport'));
        }
    }

    public function actionStatusReport()
    {

        $model = new Jobs('searchstatus');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        if (isset($_POST['reset_btn'])) {
            unset(Yii::app()->session['job_sts_selcted']);
            unset(Yii::app()->session['job_sts_datefrom']);
            unset(Yii::app()->session['job_sts_dateto']);
            unset(Yii::app()->session['job_urg_sts']);
        }

        if (isset($_POST['Jobs']) && isset($_POST['Jobs']['followupStatus']) && isset($_POST['go_btn'])) {
            $postStatusesArr = $_POST['Jobs']['followupStatus'];
            Yii::app()->session['job_sts_selcted'] = implode(',', $postStatusesArr);
        }

        if (isset($_POST['Jobs']) && isset($_POST['Jobs']['urgent_status']) && isset($_POST['go_btn'])) {

            Yii::app()->session['job_urg_sts'] = $_POST['Jobs']['urgent_status'];
        }

        if (isset(Yii::app()->session['job_urg_sts'])) {
            $model->urgent_status = Yii::app()->session['job_urg_sts'];
        }

        if (isset($_POST['Jobs']['datefrom']) && !empty($_POST['Jobs']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['job_sts_datefrom'] = date('Y-m-d', strtotime($_POST['Jobs']['datefrom']));
        }

        if (isset(Yii::app()->session['job_sts_datefrom'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['job_sts_datefrom']));
        }

        if (isset($_POST['Jobs']['dateto']) && !empty($_POST['Jobs']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['job_sts_dateto'] = date('Y-m-d', strtotime($_POST['Jobs']['dateto']));
        }

        if (isset(Yii::app()->session['job_sts_dateto'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['job_sts_dateto']));
        }


        $this->render('statusReport', array(
            'model' => $model,
        ));
    }

    public function actionBycoordinator()
    {

        $model = new Jobs('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        if (isset($_POST['Jobs'])) {
            $model->attributes = $_POST['Jobs'];
        }

        $this->render('by_coordinator_report', array(
            'model' => $model,
        ));
    }

    public function actionByXNameProduction()
    {

        $model = new Jobs('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        if (isset($_POST['Jobs'])) {
            $model->attributes = $_POST['Jobs'];
        }

        $model->isXNameProduction = 1;

        $this->render('by_x_name_production', array(
            'model' => $model,
        ));
    }

    public function actionOutstandingJobs()
    {

        $model = new Jobs('searchoutstandingjobs');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        if (isset($_POST['Jobs'])) {
            $model->attributes = $_POST['Jobs'];
        }

        $this->render('outstanding_jobs', array(
            'model' => $model,
        ));
    }

    public function actionWithoutInvoice()
    {

        $model = new Jobs('searchJobsWithoutInvoice');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        if (isset($_POST['Jobs'])) {
            $model->attributes = $_POST['Jobs'];
        }

        $this->render('jobs_without_invoice', array(
            'model' => $model,
        ));
    }

    public function actionOutjobclrcoded()
    {

        $model = new Jobs('searchoutstandingjobs');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        if (isset($_POST['Jobs'])) {
            $model->attributes = $_POST['Jobs'];
        }

        $this->render('colorcoded_outstndjobs', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id)
    {
        $model = Jobs::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'jobs-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    private $lngdesc_show = false;
    private $price_show = false;
    private $crm_show = false;

    public function actionPrint($id)
    {
        if (isset($_GET['lngdesc_show'])) {
            $this->lngdesc_show = ($_GET['lngdesc_show'] == 'true' ? true : false);
        }

        if (isset($_GET['price_show'])) {
            $this->price_show = ($_GET['price_show'] == 'true' ? true : false);
        }

        if (isset($_GET['crm_show'])) {
            $this->crm_show = ($_GET['crm_show'] == 'true' ? true : false);
        }


        $model = $this->loadModel($id);
        $url = Yii::app()->createUrl('jobs/view', array("id" => $model->id));
        $link = CHtml::link($model->jobNum, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'Job sheet ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quote_id, $model->workorder->id, $model->quoteNum, 'Job', "Job sheet ({$link}) is printed", 1, 1, 1);
        }


        $contentFile = 'protected/views/jobs/job_sheet_html.php';
        $htmlcontent = $this->renderInternal($contentFile, array(
            'model' => $model,
            'lngdesc_show' => $this->lngdesc_show,
            'price_show' => $this->price_show,
            'crm_show' => $this->crm_show
        ), true);

        $pdfCreator = new PlainPDFCreator(array(
            'title' => 'Job Sheet',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "MPVS2_{$model->jobNum}.pdf"
        ));

        $pdfCreator->generate();
    }

    public function actionPrintJobFinance($id)
    {
        if (isset($_GET['lngdesc_show']))
            $this->lngdesc_show = ($_GET['lngdesc_show'] == 'true' ? true : false);
        if (isset($_GET['price_show']))
            $this->price_show = ($_GET['price_show'] == 'true' ? true : false);

        $model = $this->loadModel($id);
        $url = Yii::app()->createUrl('jobs/view', array("id" => $model->id));
        $link = CHtml::link($model->jobNum, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'Job sheet ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quote_id, $model->workorder->id, $model->quoteNum, 'Job', "Job sheet ({$link}) is printed", 1, 1, 1);
        }



        $htmlcontent = $this->renderInternal('protected/views/jobs/job_sheet_html_finance.php', array('model' => $model, 'lngdesc_show' => $this->lngdesc_show, 'price_show' => $this->price_show), true);




        $pdfCreator = new PlainPDFCreator(array(
            'title' => 'Job Finance',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => $model->jobNum . '.pdf'
        ));

        $pdfCreator->generate();
    }

    public function actionPrintSummary($id)
    {
        $model = $this->loadModel($id);
        $url = Yii::app()->createUrl('jobs/view', array("id" => $model->id));
        $link = CHtml::link($model->jobNum, $url, array('target' => '_blank'));

        $slog = SalesLog::model()->find("comments = 'Summary report for ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Summary report for ({$link}) is printed", 1, 1, 1);
            SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Report', "Summary report for ({$link}) is printed", 1, 1, 1);
        }

        $htmlcontent = $this->renderInternal('protected/views/jobs/summery_pdf.php', array('model' => $model), true);

        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        $pdfCreator = new PlainPDFCreator(array(
            'title' => 'Job Summary Report',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "{$sitePrefix}_JobSummary_" . date('dmY') . ".pdf"
        ));

        $pdfCreator->generate();
    }

    public function actionPrintCoordinatorReport($corid, $datefrom, $dateto)
    {

        $coordinator = null;
        if (!empty($corid)) {
            $coordinator = User::model()->findByPk($corid);
        }



        $htmlcontent = $this->renderInternal('protected/views/jobs/coordinator_report_pdf.php', array('coordinator' => $coordinator, 'datefrom' => $datefrom, 'dateto' => $dateto), true);

        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        $pdfCreator = new PlainPDFCreator(array(
            'title' => 'Job Coordinator Report',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "{$sitePrefix}_JobsByCoordinator_" . date('dmY') . ".pdf"
        ));

        $pdfCreator->generate();
    }

    public function actionPrintStatusReport($status_id, $urgent_id)
    {
        $status = null;
        $urgent_status = null;
        if (!empty($status_id)) {
            $status = Status::model()->findByPk($status_id);
        }

        if (!empty($urgent_id)) {
            $urgent_status = Status::model()->findByPk($urgent_id);
        }


        $htmlcontent = $this->renderInternal('protected/views/jobs/status_report_pdf.php', array('status' => $status, 'urgent_status' => $urgent_status), true);

        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        $pdfCreator = new PlainPDFCreator(array(
            'title' => 'Job Status Report',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "{$sitePrefix}_JobStstusReport_" . date('dmY') . ".pdf"
        ));

        $pdfCreator->generate();
    }

    public function actionUploadAjaxHeader()
    {
        if (Yii::app()->request->isAjaxRequest) {

            $modelId = intval($_POST['modelId']);
            $typeNamePair = $_POST['typeNamePair'];
            $filedValue = htmlspecialchars($_POST['fieldValue']);
            $typeNamePairArr = explode('.', $typeNamePair);

            $type = $typeNamePairArr[0];
            $fieldName = $typeNamePairArr[1];

            if (!ctype_alpha($type)) {                
                exit();
            }

            //fields trying to update on job or other models should be declared in this white list
            if (!in_array($fieldName, array(
                'jobname', 'mastercusno', 'customerpono', 'cus_fref',
                'notation', 'followupStatus', 'ws_user_id', 'followupDate',
                'dueDate', 'prd_cordinator_id', 'cusnam',
                'cusadd1', 'cusadd2', 'cusadd3', 'custown',
                'cusstate', 'cuspostcode', 'custel', 'cusmobtel',
                'cusfax', 'cusemail', 'shipAddress1', 'shipAddress2', 'shipAddress3',
                'shipSub', 'shipPostalCode', 'shipState', 'shipContactName', 'shipSendVia', 'shippingLineId'
            ))) {                
                exit();
            }

            if ($type === 'job') {
                if (in_array($fieldName, array('followupDate', 'dueDate'))) {
                    if ($job = Jobs::model()->findByPk($modelId)) {
                        $oldFiledValue = $job->{$fieldName};
                        $job->{$fieldName} = date('Y-m-d', strtotime($filedValue));
                        $job->save(false);
                    }
                    //					$saved = Jobs::model()->updateByPk($modelId, array(
                    //						"$fieldName" => date('Y-m-d', strtotime($filedValue))
                    //					));
                } else {
                    if ($job = Jobs::model()->findByPk($modelId)) {
                        $oldFiledValue = $job->{$fieldName};
                        $job->{$fieldName} = $filedValue;
                        $job->save(false);
                    }
                }
            } else if ($type === 'customer') {
                $saved = Customer::model()->updateByPk($modelId, array(
                    "$fieldName" => $filedValue
                ));
            }

            if ($type === 'job') {

                $model = $this->loadModel($modelId);
                $allsaved = true;

                if ($fieldName === 'jobname' && $model->jobname !== $oldFiledValue) {


                    SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Job name is updated as $filedValue", 1, 1, 1);
                }



                if (strtolower($fieldName) == strtolower('followupStatus')) {



                    $statusname = trim(FollowupStatus::model()->findByPk($model->followupStatus)->status);
                    //add crm status
                    $salesLog = new SalesLog();
                    $salesLog->quoteId = $model->workorder->quotationId;
                    $salesLog->workorderId = $model->workorder->id;
                    $salesLog->quoteNum = $model->workorder->quotationNumber;

                    $salesLog->category = 'Job';
                    $salesLog->tbl_id = $model->id;
                    $salesLog->followupSts_id = $model->followupStatus;
                    $salesLog->comments = "Status is changed to $statusname";
                    $salesLog->isIntrnl = 1;
                    $salesLog->isExtrnl = 1;
                    $salesLog->isTechnical = 1;
                    if ($salesLog->save(false)) {


                        if ($statusname == 'Job Completed') {
                            $arr['followupStatus'] = $statusname;
                            $model->status_id = Status::SYS_STATUS_JOB_COMPLETED;
                            if ($model->save(false)) {
                                //close all the related POs
                                //close all the PO related to the job
                                $relatedPOs = PurchaseOrders::model()->findAll("job_id = {$model->id}");

                                foreach ($relatedPOs as $po) {
                                    $po->followup_status_id = SystemOptions::getOptions()->poFollowupStatusForCompleted;
                                    $po->mapFollowupStatusForSystemStatus();
                                    $po->save(false);
                                }
                                //close all production jobs
                                $jobProducts = JobProducts::model()->findAll("job_id = {$model->id}");

                                foreach ($jobProducts as $jp) {
                                    $jp->status_id = Status::SYS_STATUS_SUBJOB_DONE;
                                    $jp->save();
                                }

                                //close all production jobs
                                $jobProductDecorations = JobProductDecorations::model()->findAll("job_id = {$model->id}");

                                foreach ($jobProductDecorations as $jpd) {
                                    $jpd->status_id = Status::SYS_STATUS_SUBJOB_DONE;
                                    $jpd->save();
                                }
                            }
                        } else {
                            $model->status_id = Status::SYS_STATUS_JOB_IN_PROGRESS;
                            $model->save(false);
                            //also delete log details as in 'completed job' for this job, otherwise job will be not shown though the status is changed
                            $followupstats = FollowupStatus::model()->find(array('condition' => "status = 'Job Completed' and type = 'Job'"));
                            SalesLog::model()->deleteAll("category = 'Job' and followupSts_id = {$followupstats->id} AND tbl_id = {$model->id}");
                            $arr['followupStatus'] = 'not compared to : ' . $statusname;
                        }
                        //SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Status is changed to $statusname", 1, 1, 1);
                    }

                    $followupterm = FollowupStatus::model()->findByPk($model->followupStatus);
                    echo json_encode(array('status' => true, 'send_email' => $followupterm->send_email_onchange_followup, 'email_template_id' => $followupterm->email_template_text_id));
                    exit();
                }

                if ($fieldName === 'ws_user_id' && $model->ws_user_id !== $filedValue) {

                    $salesperson = SalesPerson::model()->findByPk($model->ws_user_id);
                    if (!empty($salesperson)) {
                        $workorder = Workorder::model()->findByPk($model->workorder_id);
                        $workorder->ws_user = $salesperson->name;
                        $workorder->ws_user_id = $model->ws_user_id;
                        $allsaved = $workorder->save(false);

                        SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Sales person is changed to $salesperson->name", 1, 1, 1);
                        SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Quotation', "Sales person is changed to $salesperson->name", 1, 1, 1);
                    }
                }

                if ($fieldName === 'prd_cordinator_id' && $model->prd_cordinator_id !== $filedValue) {


                    //also edit coordinator in workorder
                    $model->workorder->prd_cordinator_id = $model->prd_cordinator_id;
                    $model->workorder->save(false);

                    $cordinatorname = User::model()->findByPk($model->prd_cordinator_id)->username;
                    SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Production Cordinator is changed to $cordinatorname", 1, 1, 1);
                    SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Quotation', "Production Cordinator is changed to $cordinatorname", 1, 1, 1);
                }

                if ($fieldName === 'customerpono' && trim($model->customerpono) && empty($filedValue)) {

                    SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Customer PO # is removed.", 1, 1, 1);
                    $salesorder = Workorder::model()->findByPk($model->workorder->id);
                    $salesorder->customerpono = $model->customerpono;
                    if ($salesorder->save(false)) {
                        SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Quotation', "Customer PO # is removed.", 1, 1, 1);
                    }
                }
                //				else if ($model->customerpono !== $filedValue) {
                //
                //					SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Customer PO # is changed to {$model->customerpono}", 1, 1, 1);
                //
                //					$salesorder = Workorder::model()->findByPk($model->workorder->id);
                //					$salesorder->customerpono = $model->customerpono;
                //					if ($salesorder->save(false)) {
                //						SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Quotation', "Customer PO # is changed to {$model->customerpono}", 1, 1, 1);
                //					}
                //				}




                if ($fieldName === 'followupDate' && !empty($model->followupDate) && empty($filedValue)) {
                    $followupDate = date(GlobalVars::get("DateFormat"), strtotime($filedValue));
                    if (date(GlobalVars::get("DateFormat"), strtotime($model->followupDate)) != $followupDate) {


                        SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Follow-Up date is updated to $followupDate", 1, 1, 1);
                        $model->followupDate = date('Y-m-d', strtotime($followupDate));
                    }
                }

                if ($fieldName === 'dueDate' && !empty($model->dueDate) && empty($filedValue)) {
                    $dueDate = date(GlobalVars::get("DateFormat"), strtotime($filedValue));
                    if (date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)) != $dueDate) {
                        $model->dueDate = date('Y-m-d', strtotime($dueDate));
                        //also edit duedate in workorder
                        $model->workorder->dueDate = $model->dueDate;
                        $model->workorder->save(false);

                        SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Due date is updated to $dueDate", 1, 1, 1);
                        SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Quotation', "Due date is updated to $dueDate", 1, 1, 1);
                    }
                }
            }

            echo json_encode(array('status' => true));
        }
    }

    public function actionPrintSupplierReport($id)
    {
        $model = $this->loadModel($id);

        $htmlcontent = $this->renderInternal('protected/views/jobs/supplier_report_pdf.php', array('model' => $model), true);


        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        $pdfCreator = new PlainPDFCreator(array(
            'title' => 'Job Supplier Report',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "{$sitePrefix}_SupplierReportOnJob_{$model->jobNum}.pdf"
        ));

        $pdfCreator->generate();
    }

    public function actionUserDefinedStatusReport($id)
    {
        $model = $this->loadModel($id);

        $htmlcontent = $this->renderInternal('protected/views/jobs/userdefined_status_report_pdf.php', array('model' => $model), true);



        $pdfCreator = new PlainPDFCreator(array(
            'title' => 'Job - User Defined Status Report',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "statusreport-{$model->jobNum}.pdf"
        ));

        $pdfCreator->generate();
    }

    public function actionPrintCRM($id)
    {
        $model = $this->loadModel($id);


        $htmlcontent = $this->renderInternal('protected/views/jobs/job_crm_pdf.php', array('model' => $model), true);

        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        $pdfCreator = new PlainPDFCreator(array(
            'title' => 'Job -  CRM Report',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "{$sitePrefix}_JobCRM_Report_{$model->jobNum}.pdf"
        ));

        $pdfCreator->generate();
    }

    public function actionGenerateOutstandingJobsExcel()
    {
        if (isset(Yii::app()->session['out_jobrpt_qry'])) {
            $query = Yii::app()->session['out_jobrpt_qry'];
            $query .= ' order by dueDate ASC';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('outstandingJobs'));
        }


        Yii::import('ext.phpexcel.XPHPExcel');
        $objPHPExcel = XPHPExcel::createPHPExcel();
        $objPHPExcel->getProperties()->setCreator("Goodgear")
            ->setLastModifiedBy("Goodgear")
            ->setTitle("Outstanding Jobs List")
            ->setSubject("Outstanding Jobs List")
            ->setDescription("Outstanding Jobs List")
            ->setKeywords("Outstanding Jobs List")
            ->setCategory("Outstanding Jobs List");

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('E3', 'Googear')
            ->setCellValue('E4', "Googear - Outstanding Jobs List")
            ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

        $column = array();

        //if(Yii::app()->session['invr_imageFlag'] == 1)
        $column['A'] = 'No';
        $column['B'] = 'Created Date';
        $column['C'] = 'Job No';
        $column['D'] = 'Quote No';
        $column['E'] = 'SO No';
        $column['F'] = 'Master Customer';
        $column['G'] = 'Customer';
        $column['H'] = 'Sales Person';
        $column['I'] = 'Status';
        $column['J'] = 'Due Date';

        foreach ($column as $key => $val) {
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '9', $val);
        }

        $sheet = $objPHPExcel->getActiveSheet();


        foreach ($column as $key => $val) {
            $sheet->getColumnDimension($key)->setAutoSize(true);
        }

        $sheet->mergeCells("E3:F3");
        $sheet->mergeCells("E4:F4");
        $sheet->mergeCells("E5:F5");
        $sheet->mergeCells("E6:F6");

        $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
        $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));

        $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
        $sheet->getStyle("A9:I9")->applyFromArray(array("font" => array("bold" => true)));

        $row = 11;
        $count = 1;
        foreach ($rawData as $item) {
            $duedate = date(GlobalVars::get("DateFormat"), strtotime($item['dueDate']));
            if (empty($item['dueDate']))
                $duedate = "Not Set";
            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . $row, $count)
                ->setCellValue('B' . $row, date(GlobalVars::get("DateFormat"), strtotime($item['createdDtm'])))
                ->setCellValue('C' . $row, $item['jobNum'])
                ->setCellValue('D' . $row, $item['quoteNum'])
                ->setCellValue('E' . $row, Workorder::model()->findByPk($item['workorder_id'])->salesorderNumber)
                ->setCellValue('F' . $row, MasterCustomer::model()->find(array('condition' => "mcussno = '{$item['mastercusno']}'"))->mcusnam)
                ->setCellValue('G' . $row, Customer::model()->find(array('condition' => "cuscus_fref = '{$item['cus_fref']}'"))->cusnam)
                ->setCellValue('H' . $row, $item['ws_user'])
                ->setCellValue('I' . $row, Status::model()->findByPk($item['status_id'])->name)
                ->setCellValue('J' . $row, $duedate);


            $row++;
            $count++;
        }

        // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        header('Content-Disposition: attachment;filename="'.$sitePrefix.'_OutstandingJobsList.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        Yii::app()->end();
    }

    public function actionGenerateOutstandingJobsPDF()
    {
        if (isset(Yii::app()->session['out_jobrpt_qry'])) {

            $query = Yii::app()->session['out_jobrpt_qry'];
            $query .= ' order by dueDate ASC';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('outstandingPOs'));

            $htmlcontent = $this->renderInternal('protected/views/jobs/job_outstanding_list_pdf.php', array('rawData' => $rawData), true);

            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            $pdfCreator = new PlainPDFCreator(array(
                'title' => 'Job -  Outstanding List',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => "{$sitePrefix}_OutstandingJobsList_" . date('dmY') . ".pdf"
            ));

            $pdfCreator->generate();
        }
    }

    public function actionJoburgent()
    {
        $id = $_GET['id'];
        $urgent = $_GET['urgent'];

        $model = $this->loadModel($id);
        $model->urgent_status = $urgent;
        if ($model->save()) {
            if ($urgent == 19) {
                SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Marked as urgent job", 1, 1, 1);
            } else {
                SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Changet to normal job from urgent job", 1, 1, 1);
            }

            $this->redirect(array('view', 'id' => $model->id));
        } else {
            Yii::app()->user->setFlash('error', "Cannot mark the job as urgent. Please try again.");
            $this->redirect(array('view', 'id' => $model->id));
        }
    }

    public function actionXNameProduction($id)
    {
        $model = $this->loadModel($id);
        $logtext = '';
        if ($model->isXNameProduction == false) {
            $model->isXNameProduction = 1;
            $logtext = "Job is marked as a offshore production job";
        } else {
            $model->isXNameProduction = 0;
            $logtext = "Offshore production is revoked";
        }

        if ($model->save()) {
            SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', $logtext, 1, 1, 1);
            $this->redirect(array('view', 'id' => $model->id));
        } else {
            Yii::app()->user->setFlash('error', "Cannot mark the job as offshore production. Please try again.");
            $this->redirect(array('view', 'id' => $model->id));
        }
    }

    public function actionGenerateStatusReport()
    {
        if (isset(Yii::app()->session['job_sts_qry'])) {
            $query = Yii::app()->session['job_sts_qry'];
            $query .= ' order by createdDtm DESC';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('statusReport'));
        }

        $reportName = "Job Status Report";
        Yii::import('ext.phpexcel.XPHPExcel');
        $objPHPExcel = XPHPExcel::createPHPExcel();
        $objPHPExcel->getProperties()->setCreator(Yii::app()->name)
            ->setLastModifiedBy(Yii::app()->name)
            ->setTitle($reportName)
            ->setSubject($reportName)
            ->setDescription($reportName)
            ->setKeywords($reportName)
            ->setCategory($reportName);

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('E3', Yii::app()->name)
            ->setCellValue('E4', Yii::app()->name . " - " . $reportName)
            ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

        $column = array();

        //if(Yii::app()->session['invr_imageFlag'] == 1)
        $column['A'] = 'No';
        $column['B'] = 'Due Date';
        $column['C'] = 'Job Number';
        $column['D'] = 'Quotation Number';
        $column['E'] = 'Sales Order Number';
        $column['F'] = 'Master Customer';
        $column['G'] = 'Customer';
        $column['H'] = 'Sales Person';
        $column['I'] = 'Follow-up Status';
        $column['J'] = 'Urgent Status';
        $column['K'] = 'Created Date';

        foreach ($column as $key => $val) {
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '9', $val);
        }

        $sheet = $objPHPExcel->getActiveSheet();


        foreach ($column as $key => $val) {
            $sheet->getColumnDimension($key)->setAutoSize(true);
        }

        $sheet->mergeCells("E3:F3");
        $sheet->mergeCells("E4:F4");
        $sheet->mergeCells("E5:F5");
        $sheet->mergeCells("E6:F6");

        $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
        $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));

        $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
        $sheet->getStyle("A9:K9")->applyFromArray(array("font" => array("bold" => true)));

        $row = 11;
        $count = 1;
        foreach ($rawData as $item) {
            $job = $this->loadModel($item['id']);
            $mastercus = '';
            $customer = '';
            if (!empty($quote->customer)) {
                $customer = $job->customer->cusnam;
                if (!empty($job->customer->master)) {
                    $mastercus = $job->customer->master->mcusnam;
                }
            }

            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . $row, $count)
                ->setCellValue('B' . $row, Refiner::getdatetext($item['dueDate'], GlobalVars::get("DateFormat")))
                ->setCellValue('C' . $row, $item['jobNum'])
                ->setCellValue('D' . $row, $item['quoteNum'])
                ->setCellValue('E' . $row, Workorder::model()->findByPk($item['workorder_id'])->salesorderNumber)
                ->setCellValue('F' . $row, $mastercus)
                ->setCellValue('G' . $row, $customer)
                ->setCellValue('H' . $row, $item['ws_user'])
                ->setCellValue('I' . $row, $job->getFollowupStatus())
                ->setCellValue('J' . $row, Status::model()->findByPk($item['urgent_status'])->name)
                ->setCellValue('K' . $row, date(GlobalVars::get("DateFormat"), strtotime($item['createdDtm'])));


            $row++;
            $count++;
        }

        // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        header('Content-Disposition: attachment;filename="'.$sitePrefix.'_JobStatusReport_' . date('dmY') . '.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        Yii::app()->end();
    }

    public function actionGenerateStatusPDF()
    {
        if (isset(Yii::app()->session['job_sts_qry'])) {
            $query = Yii::app()->session['job_sts_qry'];
            $query .= ' order by createdDtm DESC';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('statusReport'));

            $htmlcontent = $this->renderInternal('protected/views/jobs/job_status_report.php', array('rawData' => $rawData), true);

            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            $pdfCreator = new PlainPDFCreator(array(
                'title' => 'Job -  Status Report',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => "{$sitePrefix}_JobStatusReport_" . date('dmY') . ".pdf"
            ));

            $pdfCreator->generate();
        }
    }

    public function actionSalesperson()
    {
        //print_r($_POST);
        $model = new Jobs('searchSperson');
        $model->unsetAttributes();  // clear any default values
        $model->spersonDateFlag = 1;
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        if (isset($_POST['reset_btn'])) {

            unset(Yii::app()->session['sperson_selcted']);
            unset(Yii::app()->session['sperson_datefrom']);
            unset(Yii::app()->session['sperson_dateto']);
            unset(Yii::app()->session['sperson_filter_jobinprogress']);
            unset(Yii::app()->session['sperson_filter_jobinvoiced']);
            unset(Yii::app()->session['sperson_date_type_flag']);
            unset(Yii::app()->session['sperson_query']);
        }

        if (isset($_POST['Jobs']) && isset($_POST['go_btn'])) {
            if (isset($_POST['Jobs']['ws_user_id'])) {
                $postSPersonsArr = $_POST['Jobs']['ws_user_id'];
                Yii::app()->session['sperson_selcted'] = implode(',', $postSPersonsArr);
            }

            if (isset($_POST['Jobs']['sperson_filter_jobinprogress'])) {
                Yii::app()->session['sperson_filter_jobinprogress'] = $_POST['Jobs']['sperson_filter_jobinprogress'];
            }

            if (isset($_POST['Jobs']['sperson_filter_jobinvoiced'])) {
                Yii::app()->session['sperson_filter_jobinvoiced'] = $_POST['Jobs']['sperson_filter_jobinvoiced'];
            }

            if (isset($_POST['Jobs']['spersonDateFlag'])) {
                Yii::app()->session['sperson_date_type_flag'] = $_POST['Jobs']['spersonDateFlag'];
            }
        }


        if (isset($_POST['Jobs']['datefrom']) && !empty($_POST['Jobs']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['sperson_datefrom'] = date('Y-m-d', strtotime($_POST['Jobs']['datefrom']));
        }

        if (isset(Yii::app()->session['sperson_datefrom'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['sperson_datefrom']));
        }

        if (isset($_POST['Jobs']['dateto']) && !empty($_POST['Jobs']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['sperson_dateto'] = date('Y-m-d', strtotime($_POST['Jobs']['dateto']));
        }

        if (isset(Yii::app()->session['sperson_dateto'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['sperson_dateto']));
        }

        if (isset(Yii::app()->session['sperson_filter_jobinprogress'])) {
            $model->sperson_filter_jobinprogress = Yii::app()->session['sperson_filter_jobinprogress'];
        }

        if (isset(Yii::app()->session['sperson_filter_jobinvoiced'])) {
            $model->sperson_filter_jobinvoiced = Yii::app()->session['sperson_filter_jobinvoiced'];
        }
        if (isset(Yii::app()->session['sperson_date_type_flag'])) {
            $model->spersonDateFlag = Yii::app()->session['sperson_date_type_flag'];
        }


        $this->render('job_by_saleperson', array(
            'model' => $model,
        ));
    }

    public function actionPrintSalespersonPDF()
    {
        if (isset(Yii::app()->session['sperson_query'])) {

            $query = Yii::app()->session['sperson_query'];

            $rawData = Yii::app()->db->createCommand($query)->queryAll();

            if (empty($rawData)) {
                $this->redirect(array('salesperson'));
            }

            $htmlcontent = $this->renderInternal('protected/views/jobs/sperson_job_html.php', array('rawData' => $rawData), true);

            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            $pdfCreator = new PlainPDFCreator(array(
                'title' => 'Job -  By Salespersons',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => "{$sitePrefix}_SalespersonJobs_" . date('dmY')
            ));

            $pdfCreator->generate();
        }
    }

    public function actionLoadFollowUpdateModel()
    {
        $id = $_POST['id'];
        $model = $this->loadModel($id);
        echo $this->getFollowupDropDownHTML($model);
    }

    private function getFollowupDropDownHTML($model)
    {
        $listdata = FollowupStatus::model()->findAll(array('condition' => "type = 'Job'", 'order' => 'status'));
        $html = '<form id="flwup-stsup-form"><b>' . $model->jobNum . '</b>&nbsp;<select id="job-follow-up-update" jobid="' . $model->id . '" name="Jobs[followupStatus]">';
        $html .= '<option value="0">Select Status</option>';
        foreach ($listdata as $data) {
            if ($model->getFollowupStatusId() == $data->id) {
                $html .= '<option value="' . $data->id . '" selected>' . $data->status . '</option>';
            } else {
                $html .= '<option value="' . $data->id . '">' . $data->status . '</option>';
            }
        }
        $html .= '</select></form>';

        $html .= '<div id="upstats-msg" style="display:none;"><img src="images/loading.gif" width="25" height="25"/>&nbsp;Job follow-up status updating...</div>';
        $html .= '<div id="upstats-msg-done" style="display:none;color:green;font-weight:bold;">&nbsp;Job follow-up status updated!</div>';
        $html .= '<div id="upstats-msg-error" style="display:none;"><img src="images/updaterror.png" width="25" height="25"/>&nbsp;Cannot update job follow-up status!</div>';

        return $html;
    }

    public function actionUpdateAjaxStatus()
    {
        $arr = array();
        if (Yii::app()->request->isAjaxRequest) {
            $id = $_POST['Jobs']['id'];
            $model = $this->loadModel($id);

            if (isset($_POST['Jobs']['followupStatus']) && $model->followupStatus != $_POST['Jobs']['followupStatus']) {
                $arr['followupStatus'] = $_POST['Jobs']['followupStatus'];

                $model->followupStatus = $_POST['Jobs']['followupStatus'];

                //add crm status
                $salesLog = new SalesLog();
                $salesLog->quoteId = $model->workorder->quotationId;
                $salesLog->workorderId = $model->workorder->id;
                $salesLog->quoteNum = $model->workorder->quotationNumber;

                $salesLog->category = 'Job';
                $salesLog->tbl_id = $model->id;
                $salesLog->followupSts_id = $model->followupStatus;
                if ($salesLog->save(false)) {
                    $arr['success'] = 'true';
                    $statusname = trim(FollowupStatus::model()->findByPk($model->followupStatus)->status);
                    if ($statusname == 'Job Completed') {
                        $arr['followupStatus'] = $statusname;
                        $model->status_id = Status::SYS_STATUS_JOB_COMPLETED;
                        if ($model->save(false)) {
                            //close all the PO related to the job
                            $relatedPOs = PurchaseOrders::model()->findAll("job_id = {$model->id}");

                            foreach ($relatedPOs as $po) {
                                $po->followup_status_id = SystemOptions::getOptions()->poFollowupStatusForCompleted;
                                $po->mapFollowupStatusForSystemStatus();
                                $po->save(false);
                            }
                            //close all production jobs
                            $jobProducts = JobProducts::model()->findAll("job_id = {$model->id}");

                            foreach ($jobProducts as $jp) {
                                $jp->status_id = Status::SYS_STATUS_SUBJOB_DONE;
                                $jp->save();
                            }

                            //close all production jobs
                            $jobProductDecorations = JobProductDecorations::model()->findAll("job_id = {$model->id}");

                            foreach ($jobProductDecorations as $jpd) {
                                $jpd->status_id = Status::SYS_STATUS_SUBJOB_DONE;
                                $jpd->save();
                            }
                        }
                    } else {
                        $model->status_id = Status::SYS_STATUS_JOB_IN_PROGRESS;
                        $model->save(false);
                        //also delete log details as in 'completed job' for this job, otherwise job will be not shown though the status is changed
                        $followupstats = FollowupStatus::model()->find(array('condition' => "status = 'Job Completed' and type = 'Job'"));
                        SalesLog::model()->deleteAll("category = 'Job' and followupSts_id = {$followupstats->id} AND tbl_id = {$model->id}");
                    }
                    SalesLog::createSalesLog($model->quote_id, $model->workorder_id, $model->quoteNum, 'Job', "Status is changed to $statusname", 1, 1, 1);
                } else {
                    $arr['success'] = 'false';
                }
            } else {
                $arr['success'] = 'false';
            }
        } else {
            $arr['success'] = 'false';
        }





        echo json_encode($arr);
    }

    public function actionExportJobXML($id)
    {
        $id = $_GET['id'];
        $model = $this->loadModel($id);


        $dirpath = 'files/jobxml';
        if (!file_exists($dirpath)) {
            mkdir($dirpath, 0777);
        }

        $xmlWidget = new XMLWidget();
        $xmlWidget->model = $model;
        $xmloutput = $xmlWidget->runJob();
        $fileResource = $dirpath . '/' . "{$model->jobNum}.xml";
        file_put_contents($fileResource, $xmloutput);

        if (file_exists($fileResource)) {
            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            Yii::app()->getRequest()->sendFile("{$sitePrefix}_Job_{$model->jobNum}.xml", file_get_contents($fileResource));
        }
    }

    public function actionPostDecorationForActivity()
    {
        if (isset($_POST['jobactivity']) && $_POST['jobactivity'] == 8) {
            if (isset($_POST['JobProductDecorations'])) {
                
                $arr = $_POST['JobProductDecorations'];
                if (count($arr) > 0) {
                    $json_str = json_encode($arr, true);
                    Yii::app()->session['deco_ids_of_job_decoration_create_po'] = $json_str;

                    if (isset(Yii::app()->session['deco_ids_of_job_decoration_create_po'])) {
                        echo json_encode(array('status' => 'CREATE_DECORATION_PO'));
                    }
                } else {
                    echo json_encode(array('status' => 'NO_DECORATION_SELECETD'));
                }
            }
        }


        //$retun_arr = json_decode(Yii::app()->session['deco_ids_of_job_decoration_create_po'], true);
        //print_r($retun_arr);
    }


    public function actionPostOtherCostForActivity()
    {
        if (isset($_POST['jobactivity']) && $_POST['jobactivity'] == 12) {
            if (isset($_POST['JobProductOtherCost'])) {
                
                $arr = $_POST['JobProductOtherCost'];
                if (count($arr) > 0) {
                    $json_str = json_encode($arr, true);
                    Yii::app()->session['othercost_ids_of_job_othercost_create_po'] = $json_str;

                    if (isset(Yii::app()->session['othercost_ids_of_job_othercost_create_po'])) {
                        echo json_encode(array('status' => 'CREATE_OTHERCOST_PO'));
                    }
                } else {
                    echo json_encode(array('status' => 'NO_OTHERCOST_SELECETD'));
                }
            }
        }


        //$retun_arr = json_decode(Yii::app()->session['deco_ids_of_job_decoration_create_po'], true);
        //print_r($retun_arr);
    }

    public function actionPostArtworkForActivity()
    {
        if (isset($_POST['jobactivity']) && $_POST['jobactivity'] == 10) {
            if (isset($_POST['JobDecorations'])) {
                //JobProductDecorations[16][][{0:9,1:13}] where '16' will be work order details id and '9' and '13' will be JobProductDecorations ids	
                $arr = $_POST['JobDecorations'];
                if (count($arr) > 0) {
                    $json_str = json_encode($arr, true);
                    Yii::app()->session['deco_ids_of_job_artwork_create_po'] = $json_str;

                    if (isset(Yii::app()->session['deco_ids_of_job_artwork_create_po'])) {
                        echo json_encode(array('status' => 'CREATE_ARTWORK_DECORATION_PO'));
                    }
                } else {
                    echo json_encode(array('status' => 'NO_ARTWORK_SELECETD'));
                }
            }
        }
        //$retun_arr = json_decode(Yii::app()->session['deco_ids_of_job_decoration_create_po'], true);
        //print_r($retun_arr);
    }

    public function actionGrossProfitReport()
    {
        //print_r($_POST);
        $model = new Jobs('searchGrossProfit');
        $model->unsetAttributes();  // clear any default values
        $model->spersonDateFlag = 1;
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];

        if (isset($_POST['reset_btn'])) {

            unset(Yii::app()->session['sperson_selcted']);
            unset(Yii::app()->session['sperson_datefrom']);
            unset(Yii::app()->session['sperson_dateto']);

            unset(Yii::app()->session['sperson_gross_profit_query']);
        }

        if (isset($_POST['Jobs']) && isset($_POST['go_btn'])) {
            if (isset($_POST['Jobs']['ws_user_id'])) {
                $postSPersonsArr = $_POST['Jobs']['ws_user_id'];
                Yii::app()->session['sperson_selcted'] = implode(',', $postSPersonsArr);
            }
        }


        if (isset($_POST['Jobs']['datefrom']) && !empty($_POST['Jobs']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['sperson_datefrom'] = date('Y-m-d', strtotime($_POST['Jobs']['datefrom']));
        }

        if (isset(Yii::app()->session['sperson_datefrom'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['sperson_datefrom']));
        }

        if (isset($_POST['Jobs']['dateto']) && !empty($_POST['Jobs']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['sperson_dateto'] = date('Y-m-d', strtotime($_POST['Jobs']['dateto']));
        }

        if (isset(Yii::app()->session['sperson_dateto'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['sperson_dateto']));
        }




        $this->render('gross_profit_report', array(
            'model' => $model,
        ));
    }

    public function actionPrintGrossProfitReportPDF()
    {
        if (isset(Yii::app()->session['sperson_gross_profit_query'])) {

            $query = Yii::app()->session['sperson_gross_profit_query'];

            $rawData = Yii::app()->db->createCommand($query)->queryAll();

            if (empty($rawData)) {
                $this->redirect(array('grossProfitReport'));
            }

            $htmlcontent = $this->renderInternal('protected/views/jobs/gross_profit_report_html.php', array('rawData' => $rawData), true);

            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            $pdfCreator = new PlainPDFCreator(array(
                'title' => 'Job -  Gross Profit of Salesperson',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => $sitePrefix . '_GrossProfit_' . date('dmY')
            ));

            $pdfCreator->generate();
        }
    }

    public function actionItemsWithoutPORreport() {
        $model = new Jobs('searchJobItemsWithoutPOs');
        $model->unsetAttributes();  // clear any default values
        
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];      



        $this->render('job_item_without_po_report', array(
            'model' => $model,
        ));
    }

    /**
     * Delete all related data sequence including the quote itself ( quote, workorder, job, invoice , DO, PO )
     */
    public function actionDeleteSequence($id)
    {
        $job = $this->loadModel($id);

        //Job related this workorder

        JobActivityFlow::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
        JobArtwork::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
        JobArtworkDetail::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
        JobDecorations::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
        JobProducts::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
        JobProductDecorations::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));

        Invoice::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
        InvoiceDetail::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));

        $purchaseOrders = PurchaseOrders::model()->findAll("job_id = {$job->id}");

        foreach ($purchaseOrders as $order) {
            PurchaseOrderDetails::model()->deleteAll('po_id = :poId', array(':poId' => $order->id));
        }

        PurchaseOrders::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));

        $conPODtls = ConsolidatedPoDetail::model()->findAll("job_id = {$job->id}");

        foreach ($conPODtls as $conPO) {
            ConsolidatedPurchaseOrder::model()->delete("consolidated_po_id = :conPoId", array(':conPoId' => $conPO->id));
        }

        ConsolidatedPoDetail::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));

        $deliveryDocketDetails = DeliveryDocketDetails::model()->findAll("jobId = {$job->id}");

        foreach ($deliveryDocketDetails as $ddd) {
            DeliveryDocketLabel::model()->deleteAll('delivery_docket_dtl_id = :deliveryDocketDtlId', array(':deliveryDocketDtlId' => $ddd->id));
        }

        DeliveryDocketDetails::model()->deleteAll('jobId = :jobId', array(':jobId' => $job->id));
        DeliveryDockets::model()->deleteAll('jobId = :jobId', array(':jobId' => $job->id));

        $job->delete();

        $this->redirect(array('admin'));
    }

    public function actionDashboard()
    {


        $model = new Jobs('searchDashboard');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Jobs']))
            $model->attributes = $_GET['Jobs'];



        $this->render('dashboard', array(
            'model' => $model,
        ));
    }

    public function actionTypeHeadJobList() {

        $lists = array();

        $term = Yii::app()->request->getQuery('term');
        $q = new CDbCriteria();
        $q->addSearchCondition('jobNum', $term);        
        $results = Jobs::model()->findAll($q);
        
        foreach ($results as $data) {            
            $lists[] = array(
                'id' => $data->id,
                'number' => $data->jobNum,                
                'type' => 'JOB'                
            );
        }

        //Purchase Order result set
        $q2 = new CDbCriteria();
        $q2->addSearchCondition('poNum', $term);        
        $results2 = PurchaseOrders::model()->findAll($q2);
       
        foreach ($results2 as $data) {            
            $lists[] = array(
                'id' => $data->id,
                'number' => $data->poNum,                
                'type' => 'PO'                
            );
        }
        echo json_encode($lists);
    }
}
