<?php

class MasterCustomerController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {

        $model = $this->loadModel($id);


        $customer = new Customer();
        $customer->cusmcussno = $model->mcussno;
        $criteria = new CDbCriteria;
        $criteria->addCondition("cusmcussno='{$model->mcussno}'");


        $dataprovider = new CActiveDataProvider($customer, array(
            'criteria' => $criteria,
        ));

        $response = $model->json_response;

        $this->render('view', array(
            'model' => $model,
            'dataprovider' => $dataprovider,
            'customer' => $customer,
            'response' => $response
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new MasterCustomer;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['MasterCustomer'])) {
            $model->attributes = $_POST['MasterCustomer'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->mcuscus));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['MasterCustomer'])) {
            $model->attributes = $_POST['MasterCustomer'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->mcuscus));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);

            $customerList = Customer::model()->findAll(array('condition' => 'cusmcussno=:masterCus', 'params' => array(':masterCus' => $model->mcussno)));
            $numOfCustomers = count($customerList);
            if (!($numOfCustomers > 0)) {

                $model->delete();
            }

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('MasterCustomer');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new MasterCustomer('search');
        $model->unsetAttributes();  // clear any default values
		
		if (isset($_POST['reset_btn'])) {
            unset(Yii::app()->session['master_customer_expt_qry']);
        }
		if (isset($_POST['master-customer-exprt-btn']) && isset(Yii::app()->session['master_customer_expt_qry'])) {
            $this->exportAsExcel();
        }
		
        if (isset($_GET['MasterCustomer'])){
            $model->attributes = $_GET['MasterCustomer'];
		}
		
		if (isset($_POST['MasterCustomer'])) {
			$model->attributes = $_POST['MasterCustomer'];

			//if ($model->validate()) {
			if (isset($_POST['import_btn']) && isset($_POST['MasterCustomer']['importFile'])) {
				$model->importFile = CUploadedFile::getInstance($model, 'importFile');
				$originalFileName = $model->importFile->name;

				if ($model->importFile && $model->importFile->getExtensionName() == "xml") {
					$filenametobesave = 'files/tmp/' . time() . '.' . $model->importFile->getExtensionName();
					$model->importFile->saveAs($filenametobesave);
					$this->importFile($filenametobesave);
					Yii::app()->user->setFlash('success', "The XML file [". basename($originalFileName)."] has been uploaded successfully!");
				} elseif ($model->importFile && $model->importFile->getExtensionName() == "csv") {
					$filenametobesave = 'files/tmp/' . time() . '.' . $model->importFile->getExtensionName();
					$model->importFile->saveAs($filenametobesave);
					$this->importCSVFile($filenametobesave);
					Yii::app()->user->setFlash('success', "The CSV file [". basename($originalFileName)."] has been uploaded successfully!");
				} else {
					Yii::app()->user->setFlash('notice', "File is empty or incorrect file extensions");
				}
			}
			//}
		}

        $this->render('admin', array(
            'model' => $model,
        ));
    }
	
	protected function importCSVFile($file)
	{
		$fileHandler = fopen($file, 'r');
		if ($fileHandler) {
			$count = 0;
			while ($line = fgetcsv($fileHandler, 1000)) {
			$count++;
			if ($count < 2) { /* bypass the 1st and 2nd rows of the csv file*/
				continue;
				
			}
				try {
					$companyName = $line[0];
					$emailAddress = $line[2];
					$firstName = $line[3];
					$lastName = $line[4];
					$contactName =  $firstName . ' ' . $lastName;

					$POAddress1 = $line[6];
					$POAddress2 = $line[7];
					$POAddress3 = $line[8] . ' ' . $line[9];
					$POCity = $line[10];
					$POState = $line[11];
					$POPostalCode = $line[12];
					$POCountry = $line[13];

					$SAAddress1 = $line[15];
					$SAAddress2 = $line[16];
					$SAAddress3 = $line[17] . ' ' . $line[18];
					$SACity = $line[19];
					$SAState = $line[20];
					$SAPostalCode = $line[21];
					$SACountry = $line[22];

					$phoneNumber = $line[23];
					$faxNumber = $line[24];
					$mobileNumber = $line[25];
					$websiteURL = $line[34];
					
					if (!trim($companyName)) {
						continue;
					}
					
					$criteria=new CDbCriteria;
					$criteria->addCondition('mcusnam=:mcusnam');
					$criteria->params=array(':mcusnam'=>$companyName);
					
					$customer = MasterCustomer::model()->find($criteria);
					
					if (!$customer) {
						$customer = New MasterCustomer;
					}
					$customer->mcusnam = $companyName;
					$customer->mcussnam = $companyName;
					$customer->mcusadd1 = $POAddress1;
					$customer->mcusadd2 = $POAddress2;
					$customer->mcusadd3 = $POAddress3;
					$customer->mcustown = $POCity;
					$customer->mcusstate = $POState;
					$customer->mcuspostcode = $POPostalCode;
					
					
					if ($country = Countries::model()->find("countryname = '$POCountry'")) {
						$customer->mcuscousno = $country->id;
					}
					
					$customer->mcustel = $phoneNumber;
					$customer->mcustel2 = $mobileNumber;
					$customer->mcusfax = $faxNumber;
					$customer->mcusemail = trim($emailAddress)?:'-';
					$customer->mcuscontact = $contactName;
					
					$customer->shipAddress1 = $SAAddress1;
					$customer->shipAddress2 = $SAAddress2;
					$customer->shipAddress3 = $SAAddress3;
					$customer->shipSub = $SACity;
					$customer->shipState = $SAState;
					$customer->shipPostalCode = $SAPostalCode;
					if ($country = Countries::model()->find("countryname = '$SACountry'")) {
						$customer->shipCountryId = $country->id;
					}
					
					$customer->websiteUrl = $websiteURL;
					
					$customer->mcusentddt = date('Y-m-d');
					$customer->mcusenttime = date('H:i:s');
					
					$customer->mcusameddt = date('Y-m-d');
					$customer->mcusametime = date('H:i:s');
					
					if ($customer->save(false)) {
						$customer->mcuscus = $customer->mcussno;
						$customer->mcuscus_fref = $customer->mcussno;
						$customer->save(false);
					}
					
					continue;
					
					
					
					
				} catch (Exception $e) {
					//Illegel Offset Exception
				}
			}
		}
	}
	
	protected function importFile($file)
	{
		$xmldata = simplexml_load_file($file) or die("Failed to load xml file");
		foreach ($xmldata as $key => $value) {

			$xmlmodel = Customer::model()->find("cuscus_fref = '{$value->ACCOUNTNO}'");
			if (!$xmlmodel) {
				$xmlmodel = new Customer;
			}


			$xmlmodel->mcusnam = htmlspecialchars($value->COMPANY);
			$xmlmodel->mcuscus = htmlspecialchars($value->ACCOUNTNO);
			$xmlmodel->mcuscus_fref = htmlspecialchars($value->ACCOUNTNO);
			$xmlmodel->mcusadd1 = htmlspecialchars($value->ADDRESS1);
			$xmlmodel->mcusadd2 = htmlspecialchars($value->ADDRESS2);
			$xmlmodel->mcusadd3 = htmlspecialchars($value->ADDRESS3);
			$xmlmodel->mcustown = htmlspecialchars($value->CITY);
			$xmlmodel->mcusstate = htmlspecialchars($value->STATE);
			$xmlmodel->mcuspostcode = htmlspecialchars($value->ZIP);
			

			$xmlmodel->mcusemail = htmlspecialchars($value->UACCEMAIL);
			$xmlmodel->mcustel = htmlspecialchars($value->PHONE1);

			$xmlmodel->mcuscontact = htmlspecialchars($value->CONTACT);

			//$xmlmodel->cuscontactemail = htmlspecialchars($value->EMAIL);


			$xmlmodel->shipAddress1 = htmlspecialchars($value->UMAILADD1);
			$xmlmodel->shipAddress2 = htmlspecialchars($value->UMAILADD2);
			$xmlmodel->shipAddress3 = htmlspecialchars($value->UMAILADD3);
			$xmlmodel->shipSub = htmlspecialchars($value->UMAILSUB);
			$xmlmodel->shipState = htmlspecialchars($value->UMAILSTATE);
			$xmlmodel->shipPostalCode = htmlspecialchars($value->UMAILPCODE);

			$xmlmodel->mcusentddt = date('Y-m-d');
			$xmlmodel->mcusenttime = date('H:i:s');
			$xmlmodel->mcusameddt = date('Y-m-d');
			$xmlmodel->mcusametime = date('H:i:s');

			$xmlmodel->save();
		}
	}
	
	protected function exportAsExcel() {
        if (isset(Yii::app()->session['master_customer_expt_qry'])) {
            $query = Yii::app()->session['master_customer_expt_qry'];
			$query .= ' order by mcusnam ASC';
            
            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('masterCustomer/admin'));
        }

        $reportName = "Master Customer List";
        Yii::import('ext.phpexcel.XPHPExcel');
        $objPHPExcel = XPHPExcel::createPHPExcel();
        $objPHPExcel->getProperties()->setCreator(Yii::app()->name)
                ->setLastModifiedBy(Yii::app()->name)
                ->setTitle($reportName)
                ->setSubject($reportName)
                ->setDescription($reportName)
                ->setKeywords($reportName)
                ->setCategory($reportName);

//        $objPHPExcel->setActiveSheetIndex(0)
//                ->setCellValue('E3', Yii::app()->name)
//                ->setCellValue('E4', Yii::app()->name . " - " . $reportName)
//                ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

        $column = array();

        //if(Yii::app()->session['invr_imageFlag'] == 1)
        $column['A'] = 'Category';
        $column['B'] = 'Industry';
        $column['C'] = 'Name';        
        $column['D'] = 'Address';
        $column['E'] = 'Telephone';
        $column['F'] = 'Fax';        
        $column['G'] = 'Email';
        $column['H'] = 'Contact';
        
        



        foreach ($column as $key => $val) {
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '1', $val);
        }

        $sheet = $objPHPExcel->getActiveSheet();


        foreach ($column as $key => $val) {
            $sheet->getColumnDimension($key)->setAutoSize(true);
        }


//        $sheet->mergeCells("E3:F3");
//        $sheet->mergeCells("E4:F4");
//        $sheet->mergeCells("E5:F5");
//        $sheet->mergeCells("E6:F6");
//
//        $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
//        $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));
//
//        $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
//        $sheet->getStyle("A9:AF9")->applyFromArray(array("font" => array("bold" => true)));

        $row = 2;
        $count = 1;
        foreach ($rawData as $item) {

            $customer = $this->loadModel($item['mcussno']);
            


            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $row, $customer->category->name)
                    ->setCellValue('B' . $row, $customer->industry->name)
                    ->setCellValue('C' . $row, $item['mcusnam'])
                    ->setCellValue('D' . $row, $customer->getAddress())
					->setCellValue('E' . $row, $item['mcustel'])
                    ->setCellValue('F' . $row, $item['mcusfax'])
                    ->setCellValue('G' . $row, $item['mcusemail'])
                    ->setCellValue('H' . $row, $item['mcuscontact']);


            $row++;
            $count++;
        }

        // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="MPVS2_MasterCustomerExportList_' . date('dmY') . '.xls"');
        header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        Yii::app()->end();
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = MasterCustomer::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'master-customer-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionAdvanceRefresh() {
        if (myob_api_oauth::hasAccess()) {
            if (isset($_POST['MasterCustomer'])) {
                $url = null;
                if ($_POST['MasterCustomer']['mcusnam']) {
                    
                    $companyname = urlencode($_POST['MasterCustomer']['mcusnam']);
                    $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=CompanyName+eq+\'' . $companyname . '\'';
                    
                }else if ($_POST['MasterCustomer']['displayIdMYOB']) {
                    $displayID = urlencode($_POST['MasterCustomer']['displayIdMYOB']);
                    $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=DisplayID+eq+\'' . $displayID . '\'';
                }else if ($_POST['MasterCustomer']['lastName']) {
                    $lastName = urlencode($_POST['MasterCustomer']['lastName']);
                    $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=LastName+eq+\'' . $lastName . '\'';
                }else if ($_POST['MasterCustomer']['firstName']) {
                    $firstName = urlencode($_POST['MasterCustomer']['firstName']);
                    $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=FirstName+eq+\'' . $firstName . '\'';
                }
                
                
                $this->refreshHappen($url);
            }
        }
        $this->redirect(array('admin'));
    }

    public function actionRefresh() {
        if (myob_api_oauth::hasAccess()) {
            $myobdata = MasterCustomer::model()->findAll(array("condition" => "myob_uuid is not null and myob_uuid <> ''"));
            $datacount = count($myobdata);
            $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer?$top=1000&$skip=' . $datacount;
            $this->refreshHappen($url);
        }

        $this->redirect(array('admin'));
    }

    private function refreshHappen($url) {

        $response = myob_api_oauth::getDetails($url);

        /* write response to a file */
        $file = fopen("files/myob/response.txt", 'w');
        fwrite($file, $response);
        fclose($file);

        $decoderes = json_decode($response, true);
        if (isset($decoderes["Errors"]) || isset($decoderes["Message"])) {

            Yii::app()->user->setFlash('error', "Cannot fetch customers from MYOB! The response written to log.");
        } else if (isset($decoderes["Items"])) {
            $receivedItemCount = count($decoderes["Items"]);
            $updatedItemCount = 0;
            $newitemCount = 0;
            foreach ($decoderes["Items"] as $arr) {
                $mastercus = MasterCustomer::model()->find(array('condition' => "myob_uuid = '{$arr["UID"]}'"));
                
                
                if (!$mastercus) {
                    $mastercus = new MasterCustomer();
                    $newitemCount++;
                } else {
                    $updatedItemCount++;
                }


                $mastercus->myob_uuid = $arr["UID"];
                $mastercus->myob_row_version = $arr["RowVersion"];
                $mastercus->firstName = $arr["FirstName"];
                $mastercus->lastName = $arr["LastName"];
                $mastercus->mcusnam = $arr["CompanyName"];
                $mastercus->mcusfnam = $arr["CompanyName"];
                $mastercus->mcussnam = $arr["CompanyName"];
                $mastercus->displayIdMYOB = $arr["DisplayID"];
                $mastercus->isIndividualMYOB = $arr["IsIndividual"];

                if ($arr["Addresses"]) {

                    $addressarr = null;
                    foreach ($arr["Addresses"] as $key => $val) {
                        if (is_array($val)) {

                            $addressarr = $val;
                            break;
                        }
                    }

                    if ($addressarr) {
                        $mastercus->mcusadd1 = $addressarr["Street"];
                        $mastercus->mcustown = $addressarr["City"];
                        $mastercus->mcusstate = $addressarr["State"];
                        $mastercus->mcuspostcode = $addressarr["PostCode"];
                        $mastercus->mcustel = $addressarr["Phone1"];
                        $mastercus->mcustel2 = $addressarr["Phone2"];
                        $mastercus->mcustel3 = $addressarr["Phone3"];
                        $mastercus->mcusfax = $addressarr["Fax"];
                        $mastercus->mcusemail = $addressarr["Email"];
                        $mastercus->mcuscontact = $addressarr["ContactName"];
                    }
                }

                if ($arr["SellingDetails"]) {
                    if ($arr["SellingDetails"]["TaxCode"]) {
                        $uuid = $arr["SellingDetails"]["TaxCode"]["UID"];
                        $taxmodel = MyobTaxCode::model()->find(array('condition' => "uuid = '{$uuid}'"));
                        if ($taxmodel) {
                            $mastercus->myob_taxId = $taxmodel->id;
                        }
                        $mastercus->myob_tax_uuid = $uuid;
                    }
                    if ($arr["SellingDetails"]["FreightTaxCode"]) {
                        $uuid = $arr["SellingDetails"]["FreightTaxCode"]["UID"];
                        $taxmodel = MyobTaxCode::model()->find(array('condition' => "uuid = '{$uuid}'"));
                        if ($taxmodel) {
                            $mastercus->myob_freightTaxId = $taxmodel->id;
                        }
                        $mastercus->myob_freightTax_uuid = $uuid;
                    }
                }

                $mastercus->save(false);
                //var_dump($arr["Addresses"][0]["Street"] )."\n";
                //var_dump($arr["SellingDetails"] )."\n";
            }



            Yii::app()->user->setFlash('success', "Total [$receivedItemCount] " . ($receivedItemCount > 1 ? "contacts" : "contact") . " have been received. [$newitemCount] new " . ($newitemCount > 1 ? "contacts" : "contact") . " added and [$updatedItemCount] " . ($updatedItemCount > 1 ? "contacts" : "contact") . " updated");
        }
    }

    public function actionUploadMyob($id) {
        if (myob_api_oauth::hasAccess()) {
            $model = MasterCustomer::model()->find(array('condition'=>"mcussno = $id"));
            $json = $model->getMYOBJson();

            if (!empty($model->myob_uuid) && !empty($model->myob_row_version)) {
                //then update
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/';
                $response = myob_api_oauth::putDetails($url, $json);
            } else {
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=DisplayID+eq+\'' . $model->displayIdMYOB . '\'';
                $response = myob_api_oauth::getDetails($url);

                $decoderes = json_decode($response, true);


                if (isset($decoderes["Items"])) {
                    $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'DisplayID', $model->displayIdMYOB);
                    $model->myob_uuid = $myob_res_fields['UID'];
                    $model->myob_row_version = $myob_res_fields['RowVersion'];
                    $model->save(false);
                    $json = $model->getMYOBJson();

                    if (!empty($model->myob_uuid) && !empty($model->myob_row_version)) {
                        //if so, then update the existing record

                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/';
                        $response = myob_api_oauth::putDetails($url, $json);
                    } else {
                        //insert new
                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/';
                        $response = myob_api_oauth::postDetails($url, $json);
                    }
                }
            }


            $decoderes = json_decode($response, true);


            if (isset($decoderes["Errors"]) || isset($decoderes["Message"])) {
                $model->json_response = $response;
                $model->save(false);
                Yii::app()->user->setFlash('notice', "Cannot upload the customer to MYOB!");
            } else {
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Contact/Customer/?$filter=DisplayID+eq+\'' . $model->displayIdMYOB . '\'';
                $response = myob_api_oauth::getDetails($url);

                $model->json_response = '';
                $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'DisplayID', $model->displayIdMYOB);
                $model->myob_uuid = $myob_res_fields['UID'];
                $model->myob_row_version = $myob_res_fields['RowVersion'];
                $model->save(false);
                Yii::app()->user->setFlash('success', "The master customer has been uploaded to MYOB!");
            }




            Yii::app()->session['myob_cus'] = $id;

            $this->redirect(array('view', 'id' => $model->mcuscus));
        } else {
            //not connected to myob or session expired
            Yii::app()->user->setFlash('notice', "MYOB session has been expired! Please connect to MYOB first!");
            $this->redirect(array('view', 'id' => $model->mcuscus));
        }
    }

}
