<?php

class MyobAccountController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $model = $this->loadModel($id);

        $response = $model->json_response;

        $this->render('view', array(
            'model' => $model,
            'response' => $response
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new MyobAccount;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['MyobAccount'])) {
            $model->attributes = $_POST['MyobAccount'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['MyobAccount'])) {
            $model->attributes = $_POST['MyobAccount'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('MyobAccount');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new MyobAccount('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['MyobAccount']))
            $model->attributes = $_GET['MyobAccount'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = MyobAccount::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'myob-account-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionUploadMyob($id) {
        if (myob_api_oauth::hasAccess()) {
            $model = $this->loadModel($id);

            $json = $this->getjson($model);

            if (!empty($model->uuid) && !empty($model->row_version)) {
                //then update
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/GeneralLedger/Account/';
                $response = myob_api_oauth::putDetails($url, $json);
            } else {
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/GeneralLedger/Account';
                $response = myob_api_oauth::getDetails($url);

                $decoderes = json_decode($response, true);

                if (isset($decoderes["Items"])) {
                    $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'Name', $model->name);
                    $model->uuid = $myob_res_fields['UID'];
                    $model->row_version = $myob_res_fields['RowVersion'];
                    $json = $this->getjson($model);


                    if (!empty($model->uuid) && !empty($model->row_version)) {
                        //if so, then update the existing record

                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/GeneralLedger/Account/';
                        $response = myob_api_oauth::putDetails($url, $json);
                    } else {
                        //insert new

                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/GeneralLedger/Account/';
                        $response = myob_api_oauth::postDetails($url, $json);
                    }
                }
            }


            $decoderes = json_decode($response, true);

            if (isset($decoderes["Errors"]) || isset($decoderes["Message"])) {
                $model->json_response = $response;
                $model->save(false);
                Yii::app()->user->setFlash('notice', "Cannot upload the account to MYOB!");
            } else {
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/GeneralLedger/Account';
                $response = myob_api_oauth::getDetails($url);

                $model->json_response = '';
                $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'Name', $model->name);
                $model->uuid = $myob_res_fields['UID'];
                $model->row_version = $myob_res_fields['RowVersion'];
                $model->save(false);
                Yii::app()->user->setFlash('success', "The account has been uploaded to MYOB!");
            }




            Yii::app()->session['myob_item'] = $id;

            $this->redirect(array('view', 'id' => $id));
        } else {
            //not connected to myob or session expired
            Yii::app()->user->setFlash('notice', "MYOB session has been expired! Please connect to MYOB first!");
            $this->redirect(array('view', 'id' => $id));
        }
    }

    private function getjson($model) {


        $taxarr = array(
            "Name" => $model->name,
            "DisplayID" => $model->displayId,
            "Classification" => $model->classification,
            "Type" => $model->type,
            "Description" => $model->description,
            "Number" => $model->number,
            "OpeningBalance" => $model->openingBalance,
            "CurrentBalance" => $model->currentBalance,
        );

        if ($model->taxCodeId) {
            $taxcode = MyobTaxCode::model()->findByPk($model->taxCodeId);
            if ($taxcode->uuid) {
                $taxarr["TaxCode"] = array(
                    "UID" => $taxcode->uuid,
                );
            }
        }


        if (!empty($model->uuid) && !empty($model->row_version)) {
            $taxarr["UID"] = $model->uuid;
            $taxarr["RowVersion"] = $model->row_version;
        }


        return json_encode($taxarr);
    }

    public function actionRefresh() {
        if (myob_api_oauth::hasAccess()) {
            $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/GeneralLedger/Account';
            $response = myob_api_oauth::getDetails($url);

            $decoderes = json_decode($response, true);
            if (isset($decoderes["Items"])) {
                foreach ($decoderes["Items"] as $arr) {

                    $account = MyobAccount::model()->find(array('condition' => "uuid = '{$arr["UID"]}'"));

                    if(!$account){
                        $account = MyobAccount::model()->find(array('condition' => "displayId = '{$arr["DisplayID"]}'"));
                    }
                    if (!$account) {
                        $account = new MyobAccount();
                        
                    }

                    $account->uuid = $arr["UID"];
                    $account->name = $arr["Name"];
                    $account->displayId = $arr["DisplayID"];
                    $account->classification = $arr["Classification"];
                    $account->type = $arr["Type"];
                    $account->number = $arr["Number"];
                    $account->description = $arr["Description"];
                    $account->openingBalance = $arr["OpeningBalance"];
                    $account->currentBalance = $arr["CurrentBalance"];

                    $taxcodeuid = $arr["TaxCode"]["UID"];
                    $taxcode = MyobTaxCode::model()->find(array('condition' => "uuid ='{$taxcodeuid}'"));
                    $account->taxCodeId = $taxcode ? $taxcode->id : null;

                    $account->row_version = $arr["RowVersion"];
                    $account->save(false);
                }
            }
        }

        $this->redirect(array('admin'));
    }
	
	public function actionMYOBSyncronizeAll()
	{
		$auth = new MYOBAuth(MyobSetting::getSettings());
		if ($auth->checkAccess()) {

			$myobApiConnector = new MYOBApiConnector($auth);
			$myobApiConnector->setURLEndPoint('GeneralLedger/Account/');

			/* create syncronizer object which has the syncronizing logics */
			$synchronizer = new MYOBSynchronizer($myobApiConnector, null);
			$synchronizer->setMYOBReferenceFinder(new MYOBAccountReferenceFinder());
			/*just pull the records from MYOB and and update or insert into local DB */
			$synchronizer->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PULL);

			$synchronizer->syncronizeAll('MyobAccount', $myobApiConnector->requestedURLGet());
			
		}else{
			throw new Exception('MYOB access denied!',401);
		}

		//$this->redirect(array('view', 'id' => $id));
	}

	public function actionMYOBSyncronize()
	{
		$auth = new MYOBAuth(MyobSetting::getSettings());
		if ($auth->checkAccess()) {
			$id = (int) $_POST['id'];
			$model = $this->loadModel($id);
			
			$myobApiConnector = new MYOBApiConnector($auth);

			/* create syncronizer object which has the syncronizing logics */
			$synchronizer = new MYOBSynchronizer($myobApiConnector, $model);
			$synchronizer->setMYOBReferenceFinder(new MYOBAccountReferenceFinder());
			$model->setSynchronizer($synchronizer);

			/* do syncorize */
			if ($model->myobSynchronize($myobApiConnector)) {
				echo json_encode(array('success'=>true));
			} else {
				echo json_encode(array('success'=>false));
			}
		}

		//$this->redirect(array('view', 'id' => $id));
	}

}
