<?php

class MyobController extends RController
{

	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'rights',
				//'accessControl', // perform access control for CRUD operations
		);
	}

	public function actionPurchase()
	{

		$this->render('purchase');
	}

	public function actionIndex()
	{

		$setting = MyobSetting::getSettings();
		$auth = new MYOBAuth($setting);
		$this->render('index', array('auth' => $auth));
	}

	/*

	 * myob sign in process
	 *
	 * 
	 * 
	 */

	public function actionSignIn()
	{


		$setting = MyobSetting::getSettings();
		$auth = new MYOBAuth($setting);
		
		if ($setting->environment == MyobSetting::ENVIRONMENT_SANDBOX_ACCOUNT) {
			
			$auth->setCurlHeaderAccount(new CurlHeaderSandBoxAccount($auth));
		} else if ($setting->environment == MyobSetting::ENVIRONMENT_LIVE_ACCOUNT) {
			$auth->setCurlHeaderAccount(new CurlHeaderLiveAccount($auth));
		}



		if ($auth->checkAccess()) {
			Yii::app()->user->setFlash('success', 'You have successfully connected with MYOB Account Right!');
			$this->render('index', array('auth' => $auth));
		}




		/* After  MYOB signin process success, MYOB should redirect to this endpoint (endpoint  given when register with MYOB ) with 'code' parameter */

		if (isset($_GET['code'])) {


			try {
				if ($auth->registerToken($_GET['code'])) { /* if access token registered */
					/* there may be multiple company accounts related to this MYOB user, so we need to retireve them all and match with myob account (guide) in the settings */
					if (!$auth->setGuide($setting->myob_company_name)) {
						if (Yii::app()->user->title == 'SuperAdmin') {
							Yii::app()->user->setFlash('notice', 'Please set a guide!');
						} else {
							Yii::app()->user->setFlash('notice', 'Please set a guide! [ You need to login as SuperAdmin to set a guide]');
						}
						Yii::app()->user->setFlash('error', "Cannot set guide ( company ) with the given company name in settings [{$setting->myob_company_name}]");
						$this->redirect(array('settings'));
					}

					$this->redirect(array('index'));
				} else {

					Yii::app()->user->setFlash('error', 'MYOB local environment setup failed!');
					$this->redirect(array('index'));
				}
			} catch (Exception $ex) {
				Yii::app()->user->setFlash('error', 'MYOB local environment setup failed! [' . $ex->getMessage() . ' : @Line: ' . $ex->getLine() . ']');
				$this->redirect(array('index'));
			}
		} else {
			$this->render('index', array('auth' => $auth));
		}


//        $expiry_time = time(); // + 600; // note I ad 600 seconds so we get a refresh token before our token expires
//        if ($expiry_time < Yii::app()->session['access_token_expires']) {
//			
//            $response = $this->getURL('https://api.myob.com/accountright/', '', '', 'axekz2fjukktzk3panc4b8bn');
//
//            $this->render('index', array('response' => json_decode($response)));
//        } else {
//            $this->render('auth');
//        }
	}

	public function actionSignOut()
	{
		unset(Yii::app()->session['token_id']);
		unset(Yii::app()->session['access_token']);
		unset(Yii::app()->session['access_token_expires']);
		unset(Yii::app()->session['refresh_token']);
		unset(Yii::app()->session['myob_guid_uuid']);
		$setting = MyobSetting::getSettings();
		$auth = new MYOBAuth($setting);
		$flag = 'logoutmyob';
		$this->render('index', array(
			'auth' => $auth,
			'flag' => $flag
		));
	}

	public function actionSettings()
	{
		$model = new MyobSetting();
		$model->unsetAttributes();  // clear any default values

		if (in_array(strtolower(Yii::app()->user->title), array('superadmin'))) {
			$model->login_scenario = MyobSetting::SUPERADMIN_LOGIN;
		}
		if (isset($_POST['MyobSetting']) && isset($_POST['yt0'])) {
			
			$model->attributes = $_POST['MyobSetting'];
			$settings = $this->loadSettings();
			if ($model->validate()) {
				$file = fopen("protected/filemodels/myobsettings.csv", 'w');

				$redirectUtl = trim(preg_replace('/\s\s+/', ' ', $model->redirect_url));
				$baseUrl = trim(preg_replace('/\s\s+/', ' ', $model->base_url));

				if (in_array(strtolower(Yii::app()->user->title), array('superadmin'))) {
					fwrite($file, "environment=>" . $model->environment . "\n");
					fwrite($file, "api_key=>" . trim($model->api_key) . "\n");
					fwrite($file, "api_secret=>" . trim($model->api_secret) . "\n");
					fwrite($file, "redirect_url=>" . $redirectUtl . "\n");
					fwrite($file, "myob_company_name=>" . trim($model->myob_company_name) . "\n");
					fwrite($file, "company_username=>" . trim($model->company_username) . "\n");
					fwrite($file, "company_paassword=>" . trim($model->company_paassword) . "\n");
					fwrite($file, "base_url=>" . $baseUrl . "\n");
					fwrite($file, "access_token_expires_in=>" . (int) $model->access_token_expires_in . "\n");
					fwrite($file, "myob_guid_uuid=>" . $model->myob_guid_uuid . "\n");
				} else {
					//save already exist values
					fwrite($file, "environment=>" . trim($settings->environment) . "\n");
					fwrite($file, "api_key=>" . $settings->api_key . "\n");
					fwrite($file, "api_secret=>" . $settings->api_secret . "\n");
					fwrite($file, "redirect_url=>" . $settings->redirect_url . "\n");
					fwrite($file, "myob_company_name=>" . trim($model->myob_company_name) . "\n");
					fwrite($file, "company_username=>" . $settings->company_username . "\n");
					fwrite($file, "company_paassword=>" . $settings->company_paassword . "\n");
					fwrite($file, "base_url=>" . $settings->base_url . "\n");
					fwrite($file, "access_token_expires_in=>" . (int) $settings->access_token_expires_in . "\n");
					fwrite($file, "myob_guid_uuid=>" . $settings->myob_guid_uuid . "\n");
				}

				//model related fields
				fwrite($file, "cus_taxcode_id=>" . trim($model->cus_taxcode_id) . "\n");
				fwrite($file, "cus_freight_taxcode_id=>" . trim($model->cus_freight_taxcode_id) . "\n");

				fwrite($file, "update_products_from_myob=>" . trim($model->update_products_from_myob) . "\n");
				fwrite($file, "prd_expns_accnt_id=>" . trim($model->prd_expns_accnt_id) . "\n");
				fwrite($file, "prd_incm_accnt_id=>" . trim($model->prd_incm_accnt_id) . "\n");
				fwrite($file, "prd_buying_taxcode_id=>" . trim($model->prd_buying_taxcode_id) . "\n");
				fwrite($file, "prd_selling_taxcode_id=>" . trim($model->prd_selling_taxcode_id) . "\n");

				fwrite($file, "inv_taxcode_id=>" . trim($model->inv_taxcode_id) . "\n");
				fwrite($file, "auto_send_invoice=>" . (trim($model->auto_send_invoice) ? 1 : 0) . "\n");
				fwrite($file, "auto_send_po=>" . (trim($model->auto_send_po) ? 1 : 0) . "\n");
				fwrite($file, "inv_freight_taxcode_id=>" . trim($model->inv_freight_taxcode_id) . "\n");
				fwrite($file, "po_taxcode_id=>" . $model->po_taxcode_id . "\n");
				fwrite($file, "po_freight_taxcode_id=>" . $model->po_freight_taxcode_id . "\n");

				fwrite($file, "prd_buying_freight_taxcode_id=>" . trim($model->prd_buying_freight_taxcode_id) . "\n");
				fwrite($file, "prd_selling_freight_taxcode_id=>" . trim($model->prd_selling_freight_taxcode_id) . "\n");


				if (fclose($file)) {
					Yii::app()->user->setFlash('success', "Myob settings have been updated successfully!");
				} else {
					Yii::app()->user->setFlash('notice', "Cannot update Myob settings! please try again or contact system admin.");
				}

				$this->render('settings', array(
					'model' => $this->loadSettings(),
				));
			} else {
				Yii::app()->user->setFlash('notice', "Validation error!.");
				$this->render('settings', array(
					'model' => $model,
				));
			}
		} else {
			$this->render('settings', array(
				'model' => $this->loadSettings(),
			));
		}
	}

	public function loadSettings()
	{
		$model = new MyobSetting();
		$file = fopen("protected/filemodels/myobsettings.csv", "r");
		$propertyArr = array();
		while (!feof($file)) {
			$line = fgets($file);
			$pairs = explode('=>', $line);
			$propertyArr[$pairs[0]] = $pairs[1];
		}
		fclose($file);

		foreach ($model->attributeLabels() as $attr => $lbl) {
			$model->$attr = trim($propertyArr[$attr]);
		}


		return $model;
	}

	public function actionDirectresponse()
	{
		$model = new MyobSetting();
		$response = null;

		if (myob_api_oauth::hasAccess()) {

			$model->unsetAttributes();  // clear any default values
			if (isset($_POST['MyobSetting'])) {
				$model->attributes = $_POST['MyobSetting'];

				$url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/' . trim($model->api_url);
				$response = json_decode(myob_api_oauth::getDetails($url));
			}
		}

		$this->render('directresponse', array(
			'model' => $model,
			'response' => $response
		));
	}

	public function actionResetLocalAccount()
	{
		if (strtolower(Yii::app()->user->title) === 'superadmin') {

			if (MYOBLocalReset::doReset()) {
				Yii::app()->user->setFlash('success', "MYOB local account data has been cleared successfully!");
			} else {
				Yii::app()->user->setFlash('error', "Cannot clear MYOB local account data. Please contact admin! [ " . MYOBLocalReset::$error . " ]");
			}

			$this->redirect(array('index'));
		} else {
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
		}
	}

}
