<?php

class MyobController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionPurchase() {

        $this->render('purchase');
    }

    public function actionIndex() {

        $this->render('index');
    }

    /*

     * myob sign in process
     *
     * 
     * 
     */

    public function actionSignIn() {

        $expiry_time = time(); // + 600; // note I ad 600 seconds so we get a refresh token before our token expires
        if ($expiry_time < Yii::app()->session['access_token_expires']) {
            $response = $this->getURL('https://api.myob.com/accountright/', '', '', 'axekz2fjukktzk3panc4b8bn');

            $this->render('index', array('response' => json_decode($response)));
        } else {
            $this->render('auth');
        }
    }

    public function actionSignOut() {
        unset(Yii::app()->session['myob_guid']);
        unset(Yii::app()->session['myob_guidname']);
        unset(Yii::app()->session['access_token_expires']);
        unset(Yii::app()->session['access_token']);
        unset(Yii::app()->session['refresh_token']);
        unset(Yii::app()->session['api_access_code']);
        $this->render('settings', array(
            'model' => $this->loadSettings(),
        ));
    }

    public function actionSetguid() {
        if (isset($_GET['guid']) && !empty($_GET['guid'])) {
            Yii::app()->session['myob_guid'] = $_GET['guid'];
            Yii::app()->session['myob_guidname'] = $_GET['guidname'];
        }

        $this->redirect(array('signIn'));
    }

    public function actionSettings() {
        $model = new MyobSetting();
        $model->unsetAttributes();  // clear any default values
        if (isset($_POST['MyobSetting']) && isset($_POST['yt0'])) {
            $model->attributes = $_POST['MyobSetting'];
            $settings = $this->loadSettings();
            if ($model->validate()) {
                $file = fopen("protected/filemodels/myobsettings.csv", 'w');

                $redirectUtl = trim(preg_replace('/\s\s+/', ' ', $model->redirect_url));
                $apiUrl = trim(preg_replace('/\s\s+/', ' ', $model->api_url));
                $baseUrl = trim(preg_replace('/\s\s+/', ' ', $model->base_url));

                if (in_array(Yii::app()->user->title, array('SuperAdmin'))) {
                    fwrite($file, "api_key=>" . trim($model->api_key) . "\n");
                    fwrite($file, "api_secret=>" . trim($model->api_secret) . "\n");
                    fwrite($file, "redirect_url=>" . $redirectUtl . "\n");
                    fwrite($file, "api_url=>" . $apiUrl . "\n");
                    fwrite($file, "api_scope=>" . trim($model->api_scope) . "\n");
                    fwrite($file, "company_username=>" . trim($model->company_username) . "\n");
                    fwrite($file, "company_paassword=>" . trim($model->company_paassword) . "\n");
                    fwrite($file, "base_url=>" . $baseUrl . "\n");
                    fwrite($file, "expire_in=>" . trim($model->expire_in) . "\n");
                }else{
                    //save already exist values
                    fwrite($file, "api_key=>" . $settings->api_key . "\n");
                    fwrite($file, "api_secret=>" . $settings->api_secret . "\n");
                    fwrite($file, "redirect_url=>" . $settings->redirect_url . "\n");
                    fwrite($file, "api_url=>" . $settings->api_url . "\n");
                    fwrite($file, "api_scope=>" . $settings->api_scope . "\n");
                    fwrite($file, "company_username=>" . $settings->company_username . "\n");
                    fwrite($file, "company_paassword=>" . $settings->company_paassword . "\n");
                    fwrite($file, "base_url=>" . $settings->base_url . "\n");
                    fwrite($file, "expire_in=>" . $settings->expire_in . "\n");
                }

                //model related fields
                fwrite($file, "cus_taxcode_id=>" . trim($model->cus_taxcode_id) . "\n");
                fwrite($file, "cus_freight_taxcode_id=>" . trim($model->cus_freight_taxcode_id) . "\n");
                fwrite($file, "prd_expns_accnt_id=>" . trim($model->prd_expns_accnt_id) . "\n");
                fwrite($file, "prd_incm_accnt_id=>" . trim($model->prd_incm_accnt_id) . "\n");
                fwrite($file, "prd_buying_taxcode_id=>" . trim($model->prd_buying_taxcode_id) . "\n");
                fwrite($file, "prd_selling_taxcode_id=>" . trim($model->prd_selling_taxcode_id) . "\n");
                fwrite($file, "inv_taxcode_id=>" . trim($model->inv_taxcode_id) . "\n");


                if (fclose($file)) {
                    Yii::app()->user->setFlash('success', "Myob settings have been updated successfully!");
                } else {
                    Yii::app()->user->setFlash('notice', "Cannot update Myob settings! please try again or contact system admin.");
                }
            }
        }
        $this->render('settings', array(
            'model' => $this->loadSettings(),
        ));
    }

    public function loadSettings() {
        $model = new MyobSetting();
        $file = fopen("protected/filemodels/myobsettings.csv", "r");
        $propertyArr = array();
        while (!feof($file)) {
            $line = fgets($file);
            $pairs = explode('=>', $line);
            $propertyArr[$pairs[0]] = $pairs[1];
        }
        fclose($file);

        foreach ($model->attributeLabels() as $attr => $lbl) {
            $model->$attr = trim($propertyArr[$attr]);
        }


        return $model;
    }

    public function actionPostJson() {
        
    }

    private function getURL($url, $username = NULL, $password = NULL, $api_key) {
        //echo 'token: '.$_SESSION['access_token'];
        // build the cftoken
        $cftoken = base64_encode(':');

        // setup the session & setup curl options
        $headers = array(
            'Authorization: Bearer ' . Yii::app()->session['access_token'],
            //'x-myobapi-cftoken: ',
            'x-myobapi-key: axekz2fjukktzk3panc4b8bn',
            'x-myobapi-version: v2',
            'Content-Type: application/json'
        );



        $session = curl_init($url);
        curl_setopt($session, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($session, CURLOPT_HEADER, false);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true);

        // if there is a username present, assume we want to use it
        if ($username) {
            // pass the username and password like 'username:password' to curl
            curl_setopt($session, CURLOPT_USERPWD, $username . ":" . $password);
        }

        // get the response & close the session
        $response = curl_exec($session);
        curl_close($session);
        // return what we got
        return($response);
    }

    //to add new records
    private function postURL($url, $api_key, $put_json) {
        $username = '';
        $password = '';
        $cftoken = base64_encode($username . ':' . $password);

        $headers = array(
            'Authorization: Bearer ' . $_SESSION['access_token'],
            'x-myobapi-cftoken: ' . $cftoken,
            'x-myobapi-key: axekz2fjukktzk3panc4b8bn',
            'x-myobapi-version: v2',
            'Content-Type: application/json'
        );





        $newsession = curl_init($url);

        curl_setopt($newsession, CURLOPT_HTTPHEADER, $headers); //load all header data
        curl_setopt($newsession, CURLOPT_POST, true); //comment out this PUT line to change to a POST statement
        curl_setopt($newsession, CURLOPT_USERPWD, $username . ':' . $password);
        curl_setopt($newsession, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($newsession, CURLOPT_POSTFIELDS, $put_json);
        curl_setopt($newsession, CURLOPT_SSL_VERIFYHOST, true);
        curl_setopt($newsession, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($newsession);

        curl_close($newsession);

        return $response;
    }

//to update existing records
    private function putURL($url, $api_key, $put_json) {
        $username = '';
        $password = '';
        $cftoken = base64_encode($username . ':' . $password);

        $headers = array(
            'Authorization: Bearer ' . $_SESSION['access_token'],
            'x-myobapi-cftoken: ' . $cftoken,
            'x-myobapi-key: axekz2fjukktzk3panc4b8bn',
            'x-myobapi-version: v2',
            'Content-Type: application/json'
        );





        $newsession = curl_init($url);

        curl_setopt($newsession, CURLOPT_HTTPHEADER, $headers); //load all header data
        curl_setopt($newsession, CURLOPT_PUT, true); //comment out this PUT line to change to a POST statement
        curl_setopt($newsession, CURLOPT_USERPWD, $username . ':' . $password);
        curl_setopt($newsession, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($newsession, CURLOPT_POSTFIELD, $put_json);
        curl_setopt($newsession, CURLOPT_SSL_VERIFYHOST, true);
        curl_setopt($newsession, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($newsession);

        curl_close($newsession);

        return $response;
    }

    public function actionDirectresponse() {
        $model = new MyobSetting();
        $response = null;

        if (myob_api_oauth::hasAccess()) {

            $model->unsetAttributes();  // clear any default values
            if (isset($_POST['MyobSetting'])) {
                $model->attributes = $_POST['MyobSetting'];

                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/' . trim($model->api_url);
                $response = json_decode(myob_api_oauth::getDetails($url));
            }
        }

        $this->render('directresponse', array(
            'model' => $model,
            'response' => $response
        ));
    }

    // Uncomment the following methods and override them if needed
    /*
      public function filters()
      {
      // return the filter configuration for this controller, e.g.:
      return array(
      'inlineFilterName',
      array(
      'class'=>'path.to.FilterClass',
      'propertyName'=>'propertyValue',
      ),
      );
      }

      public function actions()
      {
      // return external action classes, e.g.:
      return array(
      'action1'=>'path.to.ActionClass',
      'action2'=>array(
      'class'=>'path.to.AnotherActionClass',
      'propertyName'=>'propertyValue',
      ),
      );
      }
     */
}
