<?php

class PdSubJobController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('@', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {

        $model = $this->loadModel($id);
        $pdsubjobdetails = PDSubJobDetail::model()->findAll(array('condition' => "PDSubJobId = $id"));
        $pdsubjoblist = new PDSubJobList();
        $pdsubjoblist->PDSubJobId = $model->id;
        $job_product_decoration_ids = array();
        foreach ($pdsubjobdetails as $record) {
            $job_product_decoration_ids[] = $record->jobProductDecorationId;
        }

        $jobproductdecorationStrIds = implode(',', $job_product_decoration_ids);
        $dataProvider = null;

        if (!empty($jobproductdecorationStrIds)) {
            $dataProvider = new CActiveDataProvider('JobProductDecorations', array(
                'criteria' => array(
                    'condition' => " id in ({$jobproductdecorationStrIds})",
                ),
                'pagination' => false,
            ));
        }
        $this->render('view', array(
            'model' => $model,
            'dataProvider' => $dataProvider,
            'pdsubjoblist' => $pdsubjoblist
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {

        $model = new PDSubJob;


        $subjobs = new SubArtworkJob('search');
        $subjobs->unsetAttributes();  // clear any default values
        if (isset($_GET['SubArtworkJob']))
            $subjobs->attributes = $_GET['SubArtworkJob'];
        $subjobs->jobCategory = 'Decoration';

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['PDSubJob']) &&
                isset($_POST['sub-artwork-job-grid_c0']) && $_POST['JobProductDecorations'] &&
                isset($_POST['SubArtworkJob'])) {
            //print_r($_POST);
            $transaction = Yii::app()->db->beginTransaction();
            $allsaved = true;
            $model->attributes = $_POST['PDSubJob'];

            $model->createdDate = date('Y-m-d');
            $model->createdBy = Yii::app()->user->id;

            if ($model->save()) {
                $productdecorationArr = $_POST['JobProductDecorations']['ids'];
                $model->PDSubJobNum = 'PDSJ' . sprintf("%06s", $model->id);
                if ($model->save()) {
                    foreach ($productdecorationArr as $key => $val) {
                        $jobprocdecomodal = JobProductDecorations::model()->findByPk($val);
                        

                        //save to activity flow
                        $activityflow = new JobActivityFlow();
                        $activityflow->job_id = $model->jobId;
                        $activityflow->wrkorder_id = $model->job->workorder_id;
                        $activityflow->wrkorderDtl_id = $jobprocdecomodal->workorderDtl_id;
                        $activityflow->type = 'Product-Decoration';
                        $activityflow->flowjob_id = $val;
                        $activityflow->activity = 'Sub Job';

                        if (!$activityflow->save()) {
                            $allsaved = false;
                            Yii::app()->user->setFlash('error', "D");
                        }
                        
                        $pdsubjobdetails = new PDSubJobDetail();
                        $pdsubjobdetails->PDSubJobId = $model->id;
                        $pdsubjobdetails->workorderId = $model->job->workorder_id;
                        $pdsubjobdetails->jobProductDecorationId = $val;
                        $pdsubjobdetails->workorderDetailsId = $jobprocdecomodal->workorderDtl_id;
                        $pdsubjobdetails->activityFlowId = $activityflow->id;
                        if (!$pdsubjobdetails->save()) {
                            $allsaved = false;
                            Yii::app()->user->setFlash('error', "C");
                        }
                    }

                    $selectedsubjoblist = $_POST['sub-artwork-job-grid_c0'];
                    $subjobduedateArr = $_POST['SubArtworkJob']['dueDate'];
                    foreach ($selectedsubjoblist as $key => $val) {
                        $pdsubjoblist = new PDSubJobList();
                        $pdsubjoblist->PDSubJobId = $model->id;
                        $pdsubjoblist->subJobId = $val;
                        $pdsubjoblist->duedate = date('Y-m-d', strtotime($subjobduedateArr[$val]));
                        $pdsubjoblist->statusId = 1; //New
                        $pdsubjoblist->statusDate = date('Y-m-d');
                        $pdsubjoblist->createdBy = Yii::app()->user->id;
                        $pdsubjoblist->createdDate = date('Y-m-d');
                        if (!$pdsubjoblist->save()) {
                            $allsaved = false;
                            Yii::app()->user->setFlash('error', "E");
                        }
                    }
                } else {
                    $allsaved = false;
                    Yii::app()->user->setFlash('error', "B");
                }
            } else {
                $allsaved = false;
                Yii::app()->user->setFlash('error', "A");
            }

            if ($allsaved) {
                $transaction->commit();
                Yii::app()->user->setFlash('success', "Product-Decoration sub job ($model->PDSubJobNum) successfully created.");
                $this->redirect(array('view', 'id' => $model->id));
            } else {
                $transaction->rollback();
                //Yii::app()->user->setFlash('error', "Cannot create Product-Decoration sub job.");
                //$this->redirect(array('jobs/view', 'id' => $model->jobId));
            }
        }

        if (isset($_GET['job_id']) && isset($_GET['jpd_ids'])) {
            $job_id = $_GET['job_id'];
            $model->jobId = $job_id;
            $job_product_decoration_ids = $_GET['jpd_ids'];
            $job = Jobs::model()->findByPk($job_id);
            $salesorder = $job->workorder;
            $jobproductdecorationStrIds = str_replace('_', ',', $job_product_decoration_ids);
            $dataProvider = null;

            if (!empty($jobproductdecorationStrIds)) {
                $dataProvider = new CActiveDataProvider('JobProductDecorations', array(
                    'criteria' => array(
                        'condition' => " id in ({$jobproductdecorationStrIds})",
                    ),
                    'pagination' => false,
                ));
            }
        }




        $this->render('create', array(
            'model' => $model,
            'job' => $job,
            'salesorder' => $salesorder,
            'dataProvider' => $dataProvider,
            'subjobs' => $subjobs,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);
        $job = Jobs::model()->findByPk($model->jobId);
        $salesorder = $job->workorder;
        $subjobs = new SubArtworkJob('search');
        $subjobs->unsetAttributes();  // clear any default values
        if (isset($_GET['SubArtworkJob']))
            $subjobs->attributes = $_GET['SubArtworkJob'];
        
        $subjobs->jobCategory = 'Decoration';

        $pdsubjobdetails = PDSubJobDetail::model()->findAll(array('condition' => "PDSubJobId = $id"));
        $pdsubjoblist = new PDSubJobList();
        $pdsubjoblist->PDSubJobId = $model->id;
        $job_product_decoration_ids = array();
        foreach ($pdsubjobdetails as $record) {
            $job_product_decoration_ids[] = $record->jobProductDecorationId;
        }

        $jobproductdecorationStrIds = implode(',', $job_product_decoration_ids);
        $dataProvider = null;

        if (!empty($jobproductdecorationStrIds)) {
            $dataProvider = new CActiveDataProvider('JobProductDecorations', array(
                'criteria' => array(
                    'condition' => " id in ({$jobproductdecorationStrIds})",
                ),
                'pagination' => false,
            ));
        }

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['PDSubJob'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $allsaved = true;
            $newmodel = new PDSubJob();
            $newmodel->attributes = $_POST['PDSubJob'];

            $model->PDSubJobName = $newmodel->PDSubJobName;
            $model->dueDate = date('Y-m-d', strtotime($newmodel->dueDate));
            $model->followUpDate = date('Y-m-d', strtotime($newmodel->followUpDate));


            if ($model->save()) {

                if (isset($_POST['sub-artwork-job-grid_c0']) && isset($_POST['SubArtworkJob'])) {
                    $selectedsubjoblist = $_POST['sub-artwork-job-grid_c0'];
                    $subjobduedateArr = $_POST['SubArtworkJob']['dueDate'];
                    foreach ($selectedsubjoblist as $key => $val) {
                        $pdsubjoblist = new PDSubJobList();
                        $pdsubjoblist->PDSubJobId = $model->id;
                        $pdsubjoblist->subJobId = $val;
                        $pdsubjoblist->duedate = date('Y-m-d', strtotime($subjobduedateArr[$val]));
                        $pdsubjoblist->statusId = 1; //New
                        $pdsubjoblist->statusDate = date('Y-m-d');
                        $pdsubjoblist->createdBy = Yii::app()->user->id;
                        $pdsubjoblist->createdDate = date('Y-m-d');
                        if (!$pdsubjoblist->save()) {
                            $allsaved = false;
                            Yii::app()->user->setFlash('error', "E");
                        }
                    }
                }
            } else {
                $allsaved = false;
                Yii::app()->user->setFlash('error', "B");
            }


            if ($allsaved) {
                $transaction->commit();
                Yii::app()->user->setFlash('success', "Product-Decoration sub job ($model->PDSubJobNum) successfully updated.");
                $this->redirect(array('view', 'id' => $model->id));
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', "Cannot update Product-Decoration sub job.");
                //$this->redirect(array('jobs/view', 'id' => $model->jobId));
            }
        }

        $this->render('update', array(
            'model' => $model,
            'job' => $job,
            'salesorder' => $salesorder,
            'dataProvider' => $dataProvider,
            'subjobs' => $subjobs,
            'pdsubjoblist' => $pdsubjoblist
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('PDSubJob');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new PDSubJob('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['PDSubJob']))
            $model->attributes = $_GET['PDSubJob'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = PDSubJob::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'pdsub-job-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
