<?php

class ProductGroupController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {


        $model = $this->loadModel($id);

        $productline = new ProductLine('searchForGroup');
        $productline->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductLine']))
            $productline->attributes = $_GET['ProductLine'];


        if (isset($_POST['product-line-grid_c0']) && isset($_POST['yt0'])) {
            $prdlineArr = $_POST['product-line-grid_c0'];
            foreach ($prdlineArr as $key => $value) {
                $prdgroupdtl = new ProductGroupDetail();
                $prdgroupdtl->product_group_id = $id;
                $prdgroupdtl->pdlsno = $value;
                $prdgroupdtl->save(false);
            }
        }

        $productGRoupDtl = new ProductGroupDetail();
        $productGRoupDtl->product_group_id = $id;


        $this->render('view', array(
            'model' => $model,
            'productline' => $productline,
            'productGRoupDtl' => $productGRoupDtl
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new ProductGroup;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['ProductGroup'])) {
            $model->attributes = $_POST['ProductGroup'];
            $model->uploadimg = CUploadedFile::getInstance($model, 'uploadimg');
            $model->created_date = date('Y-m-d');
            $model->created_by = Yii::app()->user->id;


            if ($model->save()) {
                if (!empty($model->uploadimg) && empty($model->image_url)) {
                    $model->uploadimg->saveAs(Yii::app()->basePath . '/../images/product_img/' . $model->uploadimg);
                    $model->image = $model->uploadimg;
                    $model->save();
                }
            }

            $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['ProductGroup'])) {
            $model->attributes = $_POST['ProductGroup'];

            if ($model->save()) {

                $model->uploadimg = CUploadedFile::getInstance($model, 'uploadimg');


                if (!empty($model->uploadimg)) {
                    $model->uploadimg->saveAs(Yii::app()->basePath . '/../images/product_img/' . $model->uploadimg);
                    $model->image = $model->uploadimg;
                    $model->save();
                }
            }
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);
            $dltall = ProductGroupDetail::model()->deleteAll("product_group_id = '$model->id'");
            $model->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('ProductGroup');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new ProductGroup('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductGroup']))
            $model->attributes = $_GET['ProductGroup'];


        /*
         * file import and export functionality
         * 
         */
        if (isset($_POST['reset_btn'])) {
            unset(Yii::app()->session['prd_expt_qry']);
        }

        if (isset($_POST['prd-exprt-btn']) && isset(Yii::app()->session['prd_expt_qry'])) {
            $this->exportAsExcel();
        }

        $logmessage = null;
        if (isset($_POST['ProductGroup'])) {
            $model->attributes = $_POST['ProductGroup'];

            //if ($model->validate()) {
            if (isset($_POST['import_btn']) && isset($_POST['ProductGroup']['importFile'])) {
                $model->importFile = CUploadedFile::getInstance($model, 'importFile');
                if (!empty($model->importFile)) {
                    $logmessage = $this->importFile($model);
                }
            }
            //}
        }
        /*
         * END
         */

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = ProductGroup::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'product-group-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function exportAsExcel() {
        if (isset(Yii::app()->session['prd_grp_expt_qry'])) {
            $query = Yii::app()->session['prd_grp_expt_qry'];
            $query .= ' order by id desc';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('productGroup/admin'));
        }

        $reportName = "Product Group List";
        Yii::import('ext.phpexcel.XPHPExcel');
        $objPHPExcel = XPHPExcel::createPHPExcel();
        $objPHPExcel->getProperties()->setCreator(Yii::app()->name)
                ->setLastModifiedBy(Yii::app()->name)
                ->setTitle($reportName)
                ->setSubject($reportName)
                ->setDescription($reportName)
                ->setKeywords($reportName)
                ->setCategory($reportName);

        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('E3', Yii::app()->name)
                ->setCellValue('E4', Yii::app()->name . " - " . $reportName)
                ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

        $column = array();

        //if(Yii::app()->session['invr_imageFlag'] == 1)
        $column['A'] = 'id';
        $column['B'] = 'category';
        $column['C'] = 'subcategory';
        $column['D'] = 'short_description';
        $column['E'] = 'long_description';
        $column['F'] = 'in_production';
        $column['G'] = 'in_transit';
        $column['H'] = 'image_url';
        $column['I'] = 'product_detail_url';
        $column['J'] = 'download_style_sheet_url';
        $column['K'] = 'quiz_and_answer_url';




        foreach ($column as $key => $val) {
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '9', $val);
        }

        $sheet = $objPHPExcel->getActiveSheet();


        foreach ($column as $key => $val) {
            $sheet->getColumnDimension($key)->setAutoSize(true);
        }


        $sheet->mergeCells("E3:F3");
        $sheet->mergeCells("E4:F4");
        $sheet->mergeCells("E5:F5");
        $sheet->mergeCells("E6:F6");

        $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
        $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));

        $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
        $sheet->getStyle("A9:K9")->applyFromArray(array("font" => array("bold" => true)));

        $row = 11;
        $count = 1;
        foreach ($rawData as $item) {

            $productGroup = $this->loadModel($item['id']);
            $category = ProductCategory::model()->findByPk($item['categoryId']);
            $subcategory = ProductSubCategory::model()->findByPk($item['subCategoryId']);


            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $row, $count)
                    ->setCellValue('B' . $row, ($category ? $category->name : ""))
                    ->setCellValue('C' . $row, ($subcategory ? $subcategory->name : ""))
                    ->setCellValue('D' . $row, $item['short_desc'])
                    ->setCellValue('E' . $row, $item['long_desc'])
                    ->setCellValue('F' . $row, $item['in_production'])
                    ->setCellValue('G' . $row, $item['in_transit'])
                    ->setCellValue('H' . $row, $item['image_url'])
                    ->setCellValue('I' . $row, $item['productDetailUrl'])
                    ->setCellValue('J' . $row, $item['downloadStyleSheetUrl'])
                    ->setCellValue('K' . $row, $item['quizAndAnswerUrl']);




            $row++;
            $count++;
        }

        // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="ProductGroupExportList' . date('dmY') . '.xls"');
        header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        Yii::app()->end();
    }

    public function importFile($model) {
        Yii::import('application.vendors.PHPExcel', true);

        $filenametobesave = 'files/tmp/' . time() . '.' . $model->importFile->getExtensionName();
        $model->importFile->saveAs($filenametobesave);
        try {
            if ($model->importFile->getExtensionName() == "xls") {
                $objReader = new PHPExcel_Reader_Excel5();
                $data = $objReader->load($filenametobesave);
                $objWorksheet = $data->getActiveSheet();
                $highestRow = $objWorksheet->getHighestRow();
            } else if ($model->importFile->getExtensionName() == "xlsx") {
                $inputFileType = PHPExcel_IOFactory::identify($filenametobesave);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $objReader->setReadDataOnly(true);
                $data = $objReader->load($filenametobesave);
                $objWorksheet = $data->getSheet(0);
                $highestRow = $objWorksheet->getHighestRow();
            }
        } catch (Exception $e) {
            dir("Error loading file " . pathinfo($filenametobesave, PATHINFO_BASENAME) . '": ' . $e->getMessage());
        }

        $message = array();
        //$transaction = Yii::app()->db->beginTransaction();
        //check qty title for a valid data row
        for ($i = 1; $i <= $highestRow; $i++) {


            $categoryTxt = $objWorksheet->getCellByColumnAndRow(0, $i)->getValue();

            $category = null;
            if (trim($categoryTxt)) {
                $category = $this->createOrGetCategory($categoryTxt);
            }



            $subcategoryTxt = $objWorksheet->getCellByColumnAndRow(1, $i)->getValue();

            $subcategory = null;
            if (trim($subcategoryTxt)) {
                
                $subcategory = $this->createOrGetSubcategory($category, $subcategoryTxt);
            }

            $shortDesc = $objWorksheet->getCellByColumnAndRow(2, $i)->getValue();

            $longDesc = $objWorksheet->getCellByColumnAndRow(3, $i)->getValue();

            $inProduction = $objWorksheet->getCellByColumnAndRow(4, $i)->getValue();

            $inTransit = $objWorksheet->getCellByColumnAndRow(5, $i)->getValue();

            $imgUrl = $objWorksheet->getCellByColumnAndRow(6, $i)->getValue();

            $productDetailUrl = $objWorksheet->getCellByColumnAndRow(7, $i)->getValue();

            $styleSheetUrl = $objWorksheet->getCellByColumnAndRow(8, $i)->getValue();

            $q_and_a_url = $objWorksheet->getCellByColumnAndRow(9, $i)->getValue();


            $this->createOrUpdateProductGroup($category, $subcategory, $shortDesc, $longDesc, $inProduction, $inTransit, $imgUrl, $productDetailUrl, $styleSheetUrl, $q_and_a_url);
        }
        //$transaction->rollback();
        return $message;
    }

    function createOrUpdateProductGroup($category, $subcategory, $shortDesc, $longDesc, $inProduction, $inTransit, $imgUrl, $productDetailUrl, $styleSheetUrl, $q_and_a_url) {
        $productgroup = null;
        if ($category && $subcategory && $shortDesc) {
            
            $productgroup = ProductGroup::model()->find(array('condition' => "categoryId = $category->id and subCategoryId = $subcategory->id and short_desc = '$shortDesc'"));
        } else if ($category && $shortDesc) {
            $productgroup = ProductGroup::model()->find(array('condition' => "categoryId = $category->id and short_desc = '$shortDesc'"));
        } else if ($shortDesc) {
            $productgroup = ProductGroup::model()->find(array('condition' => "short_desc = '$shortDesc'"));
        }

        if (!$productgroup && $shortDesc) {
            $productgroup = new ProductGroup();
        }

        if ($productgroup) {
            
            $productgroup->categoryId = ($category ? $category->id : null);
            $productgroup->subCategoryId = ($subcategory ? $subcategory->id : null);
            $productgroup->short_desc = $shortDesc;
            $productgroup->long_desc = $longDesc;
            $productgroup->image_url = $imgUrl;
            $productgroup->productDetailUrl = $productDetailUrl;
            $productgroup->in_production = $inProduction;
            $productgroup->in_transit = $inTransit;
            $productgroup->downloadStyleSheetUrl = $styleSheetUrl;
            $productgroup->quizAndAnswerUrl = $q_and_a_url;
            $productgroup->created_date = date('Y-m-d');
            $productgroup->created_by = Yii::app()->user->id;
            $productgroup->save(false);
        }
        
        return $productgroup;
    }

    function createOrGetCategory($text) {
        $category = ProductCategory::model()->find(array('condition' => "name = '$text'"));
        if (!$category) {
            $category = new ProductCategory();
            $category->name = $text;
            $category->createdDate = date('Y-m-d');
            $category->createdBy = Yii::app()->user->id;
            $category->save(false);
        }

        return $category;
    }

    function createOrGetSubcategory($category, $subcategoryTxt) {
        $subcategory = ProductSubCategory::model()->find(array('condition' => "productCategoryId = $category->id and name = '$subcategoryTxt'"));
        
        if (!$subcategory) {
            $subcategory = new ProductSubCategory();
            $subcategory->productCategoryId = $category->id;
            $subcategory->name = $subcategoryTxt;
            $subcategory->createdDate = date('Y-m-d');
            $subcategory->createdBy = Yii::app()->user->id;
            $subcategory->save(false);
        }

        return $subcategory;
    }

}
