<?php

class ProductLineController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'filterProducts', 'createAjax',
                    'loadCodes', 'loadDescriptions', 'searchProduct', 'createViaAjax', 'cusAllocate'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $model = $this->loadModel($id);
        $productBySize = new ProductBySize();
        $productBySize->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductBySize'])) {
            $productBySize->attributes = $_GET['ProductBySize'];
        }
        $productBySize->pdlsno = $model->pdlsno;

        $productSizes = new ProductSize();
        $productSizes->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductSize']))
            $productSizes->attributes = $_GET['ProductSize'];


        $response = $model->json_response;


        $this->render('view', array(
            'model' => $model,
            'response' => $response,
            'productBySize' => $productBySize,
            'productSizes' => $productSizes
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new ProductLine;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['ProductLine'])) {
            $model->attributes = $_POST['ProductLine'];

            $productline = ProductLine::model()->find(array('condition' => "pdlpdl = '{$model->pdlpdl}'"));

            if (empty($productline)) {
                $model->pdlflag = 1;
                $model->pdlucdnew = Yii::app()->user->username;
                $model->pdlentddt = date('Y-m-d');
                $model->pdlenttime = date('H:i:s a');
                $model->pdlucdame = Yii::app()->user->username;
                $model->uploadimg = CUploadedFile::getInstance($model, 'uploadimg');

                if ($model->save()) {
                    if (!empty($model->uploadimg) && empty($model->pdlimage1)) {
                        $model->uploadimg->saveAs(Yii::app()->basePath . '/../images/product_img/' . $model->uploadimg);
                        $model->pdlimage1 = $model->uploadimg;
                        $model->save();

                        $model->saveImageContent();
                    }

                    $product = new Product();
                    $product->prdprd = $model->pdlpdl;
                    $product->prdshodes = $model->pdlprdline;
                    $product->prddes = $model->pdldes;
                    $product->prdimage1 = $model->pdlimage1;
                    $product->prdimage2 = $model->pdlimage2;
                    $product->prdimage3 = $model->pdlimage3;
                    $product->prdflag = 1;
                    $product->prducdnew = $model->pdlucdnew;
                    $product->prdentddt = $model->pdlentddt;
                    $product->prdenttime = $model->pdlenttime;

                    $product->save(false);




                    $this->redirect(array('view', 'id' => $model->pdlsno));
                }
            } else {
                $this->render('create', array(
                    'model' => $model,
                ));
            }
        } else {
            $model->pdlcustomyn = "N";
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    public function actionCusAllocate() {
        //print_r($_POST);
        $model = new ProductLine('allocateSearch');
        $customer = new Customer();
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductLine']))
            $model->attributes = $_GET['ProductLine'];

        $customer->unsetAttributes();  // clear any default values
        if (isset($_POST['Customer']))
            $customer->attributes = $_POST['Customer'];

        if (isset($_POST['Customer']) && isset($_POST['btn_allocate_prd']) && isset($_POST['allocate-product-line-grid_c0'])) {

            foreach ($_POST['allocate-product-line-grid_c0'] as $key => $val) {
                $prdline = ProductLine::model()->findByPk($val);
                $prdline->pdlcusno = $customer->cussno;
                $prdline->save(false);
            }
        }



        $this->render('cus_allocate', array(
            'model' => $model,
            'customer' => $customer,
        ));
    }

    public function actionCreateAjax() {

        if (Yii::app()->request->isPostRequest) {
            $model = new ProductLine;
            if (isset($_POST['ProductLine'])) {
                $model->attributes = $_POST['ProductLine'];
                $productline = ProductLine::model()->find(array('condition' => "pdlpdl = '{$model->pdlpdl}'"));


                if (empty($productline)) {
                    $model->pdlflag = 1;
                    $model->pdlucdnew = Yii::app()->user->username;
                    $model->pdlentddt = date('Y-m-d');
                    $model->pdlenttime = date('H:i:s a');
                    $model->pdlucdame = Yii::app()->user->username;


                    if ($model->save()) {

                        $product = new Product();
                        $product->prdprd = $model->pdlpdl;
                        $product->prdshodes = $model->pdlprdline;
                        $product->prddes = $model->pdldes;
                        $product->prdimage1 = $model->pdlimage1;
                        $product->prdimage2 = $model->pdlimage2;
                        $product->prdimage3 = $model->pdlimage3;
                        $product->prdflag = 1;
                        $product->prducdnew = $model->pdlucdnew;
                        $product->prdentddt = $model->pdlentddt;
                        $product->prdenttime = $model->pdlenttime;

                        $product->save();
                    }
                }
            }
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['ProductLine'])) {
            $model->attributes = $_POST['ProductLine'];
            /* updated time */
            $model->pdlameddt = date('Y-m-d');
            $model->pdlametime = date('H:i:s');

            if ($model->save()) {

                $model->uploadimg = CUploadedFile::getInstance($model, 'uploadimg');


                if (!empty($model->uploadimg)) {
                    $model->uploadimg->saveAs(Yii::app()->basePath . '/../images/product_img/' . $model->uploadimg);
                    $model->pdlimage1 = $model->uploadimg;
                    $model->save();

                    $model->saveImageContent();
                }

                $product = Product::model()->find(array('condition' => "prdprd = '{$model->pdlpdl}'"));
                if (!empty($product)) {
                    $product->prdprd = $model->pdlpdl;
                    $product->prdshodes = $model->pdlprdline;
                    $product->prddes = $model->pdldes;
                    $product->prdimage1 = $model->pdlimage1;
                    $product->prdimage2 = $model->pdlimage2;
                    $product->prdimage3 = $model->pdlimage3;
                    $product->prdflag = 1;
                    $product->prducdnew = $model->pdlucdnew;
                    $product->prdentddt = $model->pdlentddt;
                    $product->prdenttime = $model->pdlenttime;



                    $product->save(false);
                } else {
                    $product = new Product();
                    $product->prdprd = $model->pdlpdl;
                    $product->prdshodes = $model->pdlprdline;
                    $product->prddes = $model->pdldes;
                    $product->prdimage1 = $model->pdlimage1;
                    $product->prdimage2 = $model->pdlimage2;
                    $product->prdimage3 = $model->pdlimage3;
                    $product->prdflag = 1;
                    $product->prducdnew = $model->pdlucdnew;
                    $product->prdentddt = $model->pdlentddt;
                    $product->prdenttime = $model->pdlenttime;

                    $product->save(false);
                }



                $this->redirect(array('view', 'id' => $model->pdlsno));
            }
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);

            if (!UsageChecker::productInUse($id)) {
                if ($product = Product::model()->find(array('condition' => "prdprd = '{$model->pdlpdl}'"))) {
                    $product->delete();
                }

                $model->delete();
            }



            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    public function actionRevokeCustomer($id) {

        // we only allow deletion via POST request
        $model = $this->loadModel($id);
        $model->pdlcusno = null;
        echo $model->save(false);


//            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
//            if (!isset($_GET['ajax']))
//                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
//        
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('ProductLine');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {



        $model = new ProductLine('search');
        if (isset($_GET['ProductLine']))
            $model->attributes = $_GET['ProductLine'];

        if (isset($_POST['reset_btn'])) {
            unset(Yii::app()->session['prd_expt_qry']);
        }

        if (isset($_POST['prd-exprt-btn']) && isset(Yii::app()->session['prd_expt_qry'])) {
            $this->exportAsExcel();
        }

        $message = null;
        if (isset($_POST['ProductLine'])) {
            $model->attributes = $_POST['ProductLine'];

            //print_r($_POST);            exit();
            //if ($model->validate()) {
            if (isset($_POST['import_btn']) && isset($_POST['ProductLine']['importFile'])) {
                $model->importFile = CUploadedFile::getInstance($model, 'importFile');
                if (!empty($model->importFile)) {
                    $message = $this->importFile($model);
                }
            }
            //}
        }

        //product delete by group, web store, supplier

        if (isset($_POST['ProductLine']) && isset($_POST['delete-product-by-btn'])) {
            $model->attributes = $_POST['ProductLine'];

            //if one of the following has value
            if (!array_filter(array($model->productGroupId, $model->webstore_uuid, $model->pdlsupsno))) {
                Yii::app()->user->setFlash('notice', "Please select at lease one options to delete products.");
            }

            if (array_filter(array($model->productGroupId, $model->webstore_uuid, $model->pdlsupsno))) {
                $transaction = Yii::app()->db->beginTransaction();
                try {
                    $productRemover = new ProductRemover();
                    $productRemover->setProductGroupId($model->productGroupId)
                            ->setWebStoreUuid($model->webstore_uuid)
                            ->setSupplierId($model->pdlsupsno)
                            ->filterProductsToBeDeleted()
                            ->backupProducts()
                            ->delete()
                            ->writeLog();
                } catch (Exception $ex) {
                     $transaction->rollback();
                }

                $transaction->commit();

                Yii::app()->user->setFlash('notice', $productRemover->logToString());
            }
        }


        $productExcelLookup = new ProductExcelLookup('search');
        $productExcelLookup->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductExcelLookup'])) {
            $productExcelLookup->attributes = $_GET['ProductExcelLookup'];
        }



        $this->render('admin', array(
            'model' => $model,
            'productExcelLookup' => $productExcelLookup,
            'message' => $message
        ));
    }

    public function actionItemUpload() {
        $model = new ProductLine('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductLine']))
            $model->attributes = $_GET['ProductLine'];

        $file = 'files/selectawards-items.csv';
        $handle = fopen($file, "r");
        if ($handle) {
            while (($line = fgets($handle)) !== false) {
                echo $line . '<br>';
            }

            fclose($handle);
        } else {
            // error opening the file.
        }

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = ProductLine::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    public function loadModelByCode($productCode) {
        $model = ProductLine::model()->find(array('condition' => 'pdlpdl=:productKey', 'params' => array(':productKey' => $productCode)));
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'product-line-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionFilterProducts() {

        $arr = array();
        $model = $this->loadModelByCode($_POST['productsku']);

        $arr['prdlineID'] = $model->pdlsno;
        $arr['longdesc'] = $model->pdldes;
        $arr['shortdesc'] = $model->pdlprdline;

        echo json_encode($arr);
    }

    public function actionLoadCodes() {
        $data = ProductLine::model()->findAll(array('order' => 'pdlpdl asc'));

        $data = CHtml::listData($data, 'pdlpdl', 'pdlpdl');
        echo CHtml::tag('option', array('value' => ''), CHtml::encode(''), true);
        foreach ($data as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
    }

    public function actionLoadDescriptions() {
        $data = ProductLine::model()->findAll(array('order' => 'pdlprdline asc'));

        $data = CHtml::listData($data, 'pdlpdl', 'pdlprdline');
        echo CHtml::tag('option', array('value' => ''), CHtml::encode(''), true);
        foreach ($data as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
    }

    public function actionSearchProduct() {

        $arr = array();
        $pdlsno = $_POST['pdslno'];
        $qty = $_POST['qty'];
        if (empty($qty) || $qty < 0) {
            $qty = 1;
        }
        $model = $this->loadModel($pdlsno);

        $arr['prdlineID'] = $model->pdlsno;
        $arr['longdesc'] = $model->pdldes;
        $arr['shortdesc'] = $model->pdlprdline;
        $arr['prdcode'] = $model->pdlpdl;
        $arr['prdimg'] = $model->getImg();
        $arr['pdluntprice'] = $model->pdluntprice;
        $arr['sellingPrice'] = $model->sellingPrice;


        $prodPriceModel = ProductPrice::model()->find(array('condition' => "pdppdlsno = {$pdlsno} and (pdpquantity <= $qty and pdpsquantity >= $qty)", 'order' => 'pdpquantity_break_level'));
        if ($prodPriceModel) {
            $arr['pdluntprice'] = $prodPriceModel->pdpprice;
            $arr['sellingPrice'] = $prodPriceModel->pdpsellprice;
        } else {
            //if no price lookup for the given qty then find the lowest one as default
            if ($model->prices) {
                foreach ($model->prices as $priceBreak) {
                    if ($priceBreak->pdpprice > 0) {
                        $arr['pdluntprice'] = $priceBreak->pdpprice;
                        $arr['sellingPrice'] = $priceBreak->pdpsellprice;
                        break;
                    }
                }
            }
        }


        $suppliermargin = $model->supplier ? $model->supplier->supmrate : $model->pdlsupmargin;
        $arr['pdlsupmargin'] = $suppliermargin ?: floatval(GlobalVars::get("SupplierMarkUp"));

        $systemFreight = floatval(GlobalVars::get("SystemFreight"));
        $arr['systemFreight'] = $systemFreight;

        $arr['usdUnitFreightCost'] = $model->usdUnitFreightCost;
        $arr['usdUnitFreightMarkupRate'] = $model->usdUnitFreightMarkupRate;
        $arr['quoteLockSellPrice'] = (int) SystemOptions::getOptions()->quoteLockSellPrice ? true : false;
        $arr['soLockSellPrice'] = (int) SystemOptions::getOptions()->soLockSellPrice ? true : false;

        echo json_encode($arr);
    }

    public function actionCreateViaAjax() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $model = new ProductLine();
            $model->attributes = $_POST['ProductLine'];
            $model->pdlflag = 1;
            $model->pdlucdnew = Yii::app()->user->username;
            $model->pdlentddt = date('Y-m-d');
            $model->pdlenttime = date('H:i:s');
            $model->pdlucdame = Yii::app()->user->username;
            $model->uploadimg = CUploadedFile::getInstance($model, 'uploadimg');
            if ($model->save()) {

                if (!empty($model->uploadimg) && empty($model->pdlimage1)) {
                    $model->uploadimg->saveAs(Yii::app()->basePath . '/../images/product_img/' . $model->uploadimg);
                    $model->pdlimage1 = $model->uploadimg;
                    $model->save();
                }

                echo json_encode(array('success' => 'true', 'message' => '', 'productId' => $model->pdlsno));
            } else {
                echo json_encode(array('success' => 'false', 'message' => CHtml::errorSummary($model)));
            }
        }
    }

    public function exportAsExcel() {
        if (isset(Yii::app()->session['prd_expt_qry'])) {
            $query = Yii::app()->session['prd_expt_qry'];
            $query .= ' ORDER BY pdlsno DESC';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('productLine/admin'));
        }

        $reportName = "Product List";
        Yii::import('ext.phpexcel.XPHPExcel');
        $objPHPExcel = XPHPExcel::createPHPExcel();
        $objPHPExcel->getProperties()->setCreator(Yii::app()->name)
                ->setLastModifiedBy(Yii::app()->name)
                ->setTitle($reportName)
                ->setSubject($reportName)
                ->setDescription($reportName)
                ->setKeywords($reportName)
                ->setCategory($reportName);

//        $objPHPExcel->setActiveSheetIndex(0)
//                ->setCellValue('E3', Yii::app()->name)
//                ->setCellValue('E4', Yii::app()->name . " - " . $reportName)
//                ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

        $column = array();

        //if(Yii::app()->session['invr_imageFlag'] == 1)
        $column['A'] = 'supplier';
        $column['B'] = 'code';
        $column['C'] = 'item';
        $column['D'] = 'name';
        $column['E'] = 'long_description';
        $column['F'] = 'item_colour';
        $column['G'] = 'item_size';
        //QTY BREAKUPS FOR COST PRICE
        $column['H'] = 'q1';
        $column['I'] = 'p1';
        $column['J'] = 'q2';
        $column['K'] = 'p2';
        $column['L'] = 'q3';
        $column['M'] = 'p3';
        $column['N'] = 'q4';
        $column['O'] = 'p4';
        $column['P'] = 'q5';
        $column['Q'] = 'p5';
        $column['R'] = 'q6';
        $column['S'] = 'p6';
        $column['T'] = 'q7';
        $column['U'] = 'p7';
        $column['V'] = 'q8';
        $column['W'] = 'p8';

        $column['X'] = 'made_of';
        $column['Y'] = 'sub_category';
        $column['Z'] = 'is_printed';
        $column['AA'] = 'printtype';
        $column['AB'] = 'Expr107';
        $column['AC'] = 'image1';
        $column['AD'] = 'image2';
        $column['AE'] = 'image3';
        $column['AF'] = 'itemsinset';
        $column['AG'] = 'iteminbox';
        $column['AH'] = 'boxdim1';
        $column['AI'] = 'boxdim2';
        $column['AJ'] = 'Expr1035';
        $column['AK'] = 'boxdim3';
        //QTY BREAKUPS FOR SELLING PRICE
        $column['AL'] = 'SQ1';
        $column['AM'] = 'SP1';
        $column['AN'] = 'SQ2';
        $column['AO'] = 'SP2';
        $column['AP'] = 'SQ3';
        $column['AQ'] = 'SP3';
        $column['AR'] = 'SQ4';
        $column['AS'] = 'SP4';
        $column['AT'] = 'SQ5';
        $column['AU'] = 'SP5';
        $column['AV'] = 'SQ6';
        $column['AW'] = 'SP6';
        $column['AX'] = 'SQ7';
        $column['AY'] = 'SP7';
        $column['AZ'] = 'SQ8';
        $column['BA'] = 'SP8';

        $column['BB'] = 'sup product code';
        $column['BC'] = 'webstore name';
        $column['BD'] = 'webstore uuid';




        foreach ($column as $key => $val) {
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '1', $val);
        }

        $sheet = $objPHPExcel->getActiveSheet();


        foreach ($column as $key => $val) {
            $sheet->getColumnDimension($key)->setAutoSize(true);
        }


//        $sheet->mergeCells("E3:F3");
//        $sheet->mergeCells("E4:F4");
//        $sheet->mergeCells("E5:F5");
//        $sheet->mergeCells("E6:F6");
//
//        $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
//        $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));
//
//        $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
//        $sheet->getStyle("A9:AF9")->applyFromArray(array("font" => array("bold" => true)));

        $row = 2;
        $count = 1;
        foreach ($rawData as $item) {

            $productline = $this->loadModel($item['pdlsno']);
            $productprices = ProductPrice::model()->findAll(array('condition' => "pdppdlsno = '{$productline->pdlsno}'", 'order' => 'pdpsno asc'));



            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $row, $productline->supplier->supsup_fref)
                    ->setCellValue('B' . $row, $item['pdlpdl'])
                    ->setCellValue('C' . $row, $item['pdlpdl'])
                    ->setCellValue('D' . $row, $item['pdlprdline'])
                    ->setCellValue('E' . $row, $item['pdldes'])
                    ->setCellValue('F' . $row, '')
                    ->setCellValue('G' . $row, '');

            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('Y' . $row, $productline->subcategoryRel->name)
                    ->setCellValue('AC' . $row, $item['pdlimage1']);

            $currentLetter = 'H';
            $sellingPriceBreakUpLetter = 'AL';
            $breakups = count($productprices);
            $breakupscount = 0;
            foreach ($productprices as $prdprice) {
                $breakupscount++;
                if ($breakups != $breakupscount) {
                    $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($currentLetter . $row, $prdprice->pdpquantity)
                            ->setCellValue(++$currentLetter . $row, $prdprice->pdpprice);

                    $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($sellingPriceBreakUpLetter . $row, $prdprice->pdpquantity)
                            ->setCellValue(++$sellingPriceBreakUpLetter . $row, $prdprice->pdpsellprice);

                    $currentLetter++;
                    $sellingPriceBreakUpLetter++;
                } else {
                    
                }
            }

            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('BB' . $row, $item['sup_product_code'])
                    ->setCellValue('BC' . $row, $item['webstore_name'])
                    ->setCellValue('BD' . $row, $item['webstore_uuid']);

            $row++;
            $count++;
        }

        // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        header('Content-Disposition: attachment;filename="'.$sitePrefix.'_ProductExportList_' . date('dmY') . '.xls"');
        header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        Yii::app()->end();
    }

    public function importFile($model) {

        $filenametobesave = 'files/tmp/' . time() . '.' . $model->importFile->getExtensionName();
        $model->importFile->saveAs($filenametobesave);

        $transaction = Yii::app()->db->beginTransaction();

        try {

            $excelImporter = new ProductExcelImporter($filenametobesave);
            $excelImporter->setColoumnsToBeRead(55)
                    ->extractData()
                    ->createSuppliers()
                    ->createCategories()
                    ->createSubcategories()
                    ->createProducts()
                    ->clearAllPriceMatrixes()
                    ->createProductCostPriceMatrixes()
                    ->createProductSellPriceMatrixes()
                    ->createProductGroups()
                    ->allocateProductsToGroups()
                    ->allocateProductGroupsToWebStores()
                    ->writeLogs();


            Yii::app()->user->setFlash('notice', $excelImporter->getLogs());

            //log crm record
            $crm = new SalesLog();
            $crm->category = SalesLog::CATEGORY_OTHER;
            $crm->comments = $excelImporter->getLogs();
            $crm->createdDtm = date("Y-m-d H:i:s");
            $crm->createdBy = Yii::app()->user->id;
            $crm->isIntrnl = 0;
            $crm->isExtrnl = 0;
            $crm->isTechnical = 1;
            $crm->save(false);
        } catch (Exception $ex) {

            $crm = new SalesLog();
            $crm->category = SalesLog::CATEGORY_OTHER;
            $crm->comments = $ex->getMessage();
            $crm->createdDtm = date("Y-m-d H:i:s");
            $crm->createdBy = Yii::app()->user->id;
            $crm->isIntrnl = 0;
            $crm->isExtrnl = 0;
            $crm->isTechnical = 1;
            $crm->save(false);
        }

        $transaction->commit();
    }

    public function actionUploadMyob($id) {
        if (myob_api_oauth::hasAccess()) {
            $model = $this->loadModel($id);

            $json = $model->getMYOBJson();


            if (!empty($model->myob_uuid) && !empty($model->myob_row_version)) {
                //then update
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Inventory/Item/';
                $response = myob_api_oauth::putDetails($url, $json);
            } else {
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Inventory/Item/?$filter=Number+eq+\'' . $model->pdlsno . '\'';
                $response = myob_api_oauth::getDetails($url);

                $decoderes = json_decode($response, true);

                if (isset($decoderes["Items"])) {
                    $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'Number', $model->pdlsno);
                    $model->myob_uuid = $myob_res_fields['UID'];
                    $model->myob_row_version = $myob_res_fields['RowVersion'];
                    $json = $model->getMYOBJson();


                    if (!empty($model->myob_uuid) && !empty($model->myob_row_version)) {
                        //if so, then update the existing record

                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Inventory/Item/';
                        $response = myob_api_oauth::putDetails($url, $json);
                    } else {
                        //insert new

                        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Inventory/Item/';
                        $response = myob_api_oauth::postDetails($url, $json);
                    }
                }
            }


            $decoderes = json_decode($response, true);

            if (isset($decoderes["Errors"]) || isset($decoderes["Message"])) {
                $model->json_response = $response;
                $model->save(false);
                Yii::app()->user->setFlash('notice', "Cannot upload the item to MYOB!");
            } else {
                $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Inventory/Item/?$filter=Number+eq+\'' . $model->pdlsno . '\'';
                $response = myob_api_oauth::getDetails($url);

                $model->json_response = '';
                $myob_res_fields = myob_api_oauth::getFieldsFromJsonResponse($response, 'Number', $model->pdlsno);
                $model->myob_uuid = $myob_res_fields['UID'];
                $model->myob_row_version = $myob_res_fields['RowVersion'];
                $model->save(false);
                Yii::app()->user->setFlash('success', "The item has been uploaded to MYOB!");
            }




            Yii::app()->session['myob_item'] = $id;

            $this->redirect(array('view', 'id' => $id));
        } else {
            //not connected to myob or session expired
            Yii::app()->user->setFlash('notice', "MYOB session has been expired! Please connect to MYOB first!");
            $this->redirect(array('view', 'id' => $id));
        }
    }

    public function actionMYOBBulkUpload() {
        if (myob_api_oauth::hasAccess()) {
            $json = $model->getMYOBBulkJson();
            //insert new

            $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . '/Inventory/Item/';
            $response = myob_api_oauth::postDetails($url, $json);
            $decoderes = json_decode($response, true);

            if (isset($decoderes["Errors"]) || isset($decoderes["Message"])) {

                Yii::app()->user->setFlash('notice', $decoderes["Message"]);
            } else {

                Yii::app()->user->setFlash('success', "The item has been uploaded to MYOB!");
            }
        }
    }

    public function actionAddProductSizes() {
        $pdlsno = $_POST['pdslno'];
        $sizesIdStr = $_POST['sizesIds'];
        $sizesIdArr = explode(',', $sizesIdStr);
        sort($sizesIdArr);
        foreach ($sizesIdArr as $id) {
            $productBySize = ProductBySize::model()->find(array('condition' => "pdlsno = $pdlsno and product_size_id = $id"));
            if (!$productBySize) {
                $productSize = ProductSize::model()->findByPk($id);
                $productBySize = new ProductBySize();
                $productBySize->pdlsno = $pdlsno;
                $productBySize->product_size_id = $id;
                $productBySize->order_number = $productSize->ordernumber;
                $productBySize->save();
            }
        }
    }

    public function actionMYOBSyncronizeAll() {

        $auth = new MYOBAuth(MyobSetting::getSettings());
        if ($auth->checkAccess()) {

            $myobApiConnector = new MYOBApiConnector($auth);
            $myobApiConnector->setURLEndPoint('Inventory/Item/');

            /* create syncronizer object which has the syncronizing logics */
            $synchronizer = new MYOBSynchronizer($myobApiConnector, null);
            $synchronizer->setMYOBReferenceFinder(new MYOBItemReferenceFinder());
            /* just pull the records from MYOB and and update or insert into local DB */
            $synchronizer->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PULL);

            $synchronizer->syncronizeAll('ProductLine', $myobApiConnector->requestedURLGet());
        } else {
            throw new Exception('MYOB access denied!', 401);
        }

        //$this->redirect(array('view', 'id' => $id));
    }

    public function actionMYOBSyncronize() {

        $auth = new MYOBAuth(MyobSetting::getSettings());
        if ($auth->checkAccess()) {
            $id = (int) $_POST['id'];
            $model = $this->loadModel($id);

            $myobApiConnector = new MYOBApiConnector($auth);

            /* create syncronizer object which has the syncronizing logics */
            $synchronizer = new MYOBSynchronizer($myobApiConnector, $model);
            $synchronizer->setMYOBReferenceFinder(new MYOBItemReferenceFinder());

            $synchronizer->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PULL);
            $model->setSynchronizer($synchronizer);
            /* do syncorize */
            if ($model->myobSynchronize($myobApiConnector)) {
                echo json_encode(array('success' => true));
            } else {
                echo json_encode(array('success' => false));
            }
        }

        //$this->redirect(array('view', 'id' => $id));
    }

    public function actionApiClient() {
        $requestURL = 'http://promosearch.gwshostingserver.com.au/apiClient/';
        $postFields = array(
            'user' => array(
                'username' => 'eranga@aranxa.com',
                'password' => 'iD0%+k-,W7;9.2wT'
            ),
            'data' => array(
                'supplier' => 'BIZ',
                'product_code' => '',
                'product_Name' => 'Elite',
                'category' => ''
            )
        );
        $curlCall = new CurlCall(new CurlHeaderJson());

        $result_arr = json_decode($curlCall->curlPost($requestURL, json_encode($postFields)), true);

        print_r($result_arr['data'][0]);

        echo '<br>';

        $rawData = Yii::app()->db->createCommand('SELECT * FROM User')->queryAll();

        print_r($rawData);
    }

}
