<?php

class ProductPriceController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
			'rights',
			//'accessControl', // perform access control for CRUD operations
		);
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'priceInQtyRange', 'createQtyBreak','saveQtyBreakFrom'
                    ,'saveQtyBreakTo','saveQtyBreakPrice','ajaxDelete', 'saveQtyBreakSellPrice'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new ProductPrice;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['ProductPrice'])) {
            $model->attributes = $_POST['ProductPrice'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->pdpsno));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['ProductPrice'])) {
            $model->attributes = $_POST['ProductPrice'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->pdpsno));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('ProductPrice');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new ProductPrice('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductPrice']))
            $model->attributes = $_GET['ProductPrice'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }
    
    public function actionPriceQtyTableHTML() {
        $tblID = $_POST['tableID'];
        $existCostPrice = $_POST['existCostPrice'];
        
        if(isset($_POST['workorderdtlID'])){
            $workorderDtlID = $_POST['workorderdtlID'];
            $workorderdtlmodel = Workorderdetails::model()->findByPk($workorderDtlID);
            $productLine = $workorderdtlmodel->product;
        }
        
        if(isset($_POST['quoteDtlID'])){
            $quoteDtlID = $_POST['quoteDtlID'];
            $quoteDtlmodel = QuatationDetails::model()->findByPk($quoteDtlID);
            $productLine = $quoteDtlmodel->productRel;
        }
        
        if(isset($_POST['itemID'])){
            $pdslno = $_POST['itemID'];
            $productLine = ProductLine::model()->findByPk($pdslno);
        }
        
        
        if (!isset($_POST['itemID']) && isset($productLine) && !empty($productLine)) {
            $qtybreaks = ProductPrice::model()->findAll(array('condition' => "pdppdlsno = '{$productLine->pdlsno}'", 'order' => "pdpsquantity ASC"));
            echo $this->renderPartial('priceQtyTableHTML', array('qtybreaks' => $qtybreaks, 'tblID' => $tblID, 'existCostPrice' => $existCostPrice), false, true);
        } else if(isset($_POST['itemID']) && isset($productLine) && !empty($productLine)){
            $qtybreaks = ProductPrice::model()->findAll(array('condition' => "pdppdlsno = '{$productLine->pdlsno}'", 'order' => "pdpsquantity ASC"));
            echo $this->renderPartial('quoteNewPriceQtyTableHTML', array('qtybreaks' => $qtybreaks, 'tblID' => $tblID, 'existCostPrice' => $existCostPrice), false, true);
        }else {
            echo '<div>No qty breaks details to show!</div>';
        }
    }
    
    public function actionAddPriceQtyTableHTML() {
        $pdslno = $_POST['id'];        
        $tblID = $_POST['tableID'];
        $qty = $_POST['qty'];
        
        $productLine = ProductLine::model()->findByPk($pdslno);
        if (!empty($productLine)) {
            $qtybreaks = ProductPrice::model()->findAll(array('condition' => "pdppdlsno = '{$productLine->pdlsno}'", 'order' => "pdpsquantity ASC"));
            echo $this->renderPartial('addPriceQtyTableHTML', array('qtybreaks' => $qtybreaks, 'tblID' => $tblID, 'qty'=>$qty), false, true);
        }else{
            echo '<div>No qty breaks details to show!</div>';
        }
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = ProductPrice::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'product-price-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionPriceInQtyRange() {
        $pricearr = array();
        $price = 0;
        if (isset($_POST)) {
            $productcode = $_POST['productsku'];
            $qty = $_POST['qty'];

            $productLine = ProductLine::model()->find(array('condition' => "pdlpdl = '{$productcode}'"));
            $productprices = ProductPrice::model()->findAll(array('condition' => "pdppdlsno = '{$productLine->pdlsno}'"));

            foreach ($productprices as $prdprice) {
                if ($qty >= $prdprice->pdpquantity && $qty <= $prdprice->pdpsquantity) {
                    $price = $prdprice->pdpprice;
                    break;
                }
            }
            $pricearr['prdprice'] = $price;
        }

        echo json_encode($pricearr);
    }

    public function actionCreateQtyBreak() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['pdlid'])) {
                $pdlid = $_POST['pdlid'];
                $productline = ProductLine::model()->findByPk($pdlid);

                $lastproductprice = ProductPrice::model()->find(array('condition' => "pdppdlsno = '{$productline->pdlsno}'", 'order' => 'pdpquantity_break_level DESC'));

                $quntitybreaklevel = 0;

                if (!empty($lastproductprice)) {
                    $quntitybreaklevel = $lastproductprice->pdpquantity_break_level + 1;
                } else {
                    $quntitybreaklevel = 1;
                }

                $productprice = new ProductPrice();
                $productprice->pdppdlsno = $productline->pdlsno;
                $productprice->pdpquantity_break_level = $quntitybreaklevel;
                $productprice->pdpucdnew = Yii::app()->user->username;
                $productprice->pdpentddt = date('Y-m-d');
                $productprice->pdpenttime = date('H:i:s a');
                $productprice->pdpucdame = Yii::app()->user->username;

                $resultArr = array();
                if ($productprice->save()) {
                    $resultArr['rowid'] = $productprice->pdpsno;
                    echo json_encode($resultArr);
                } else {
                    throw new Exception;
                }
            }
        }
    }

    public function actionSaveQtyBreakFrom() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['prdpriceid'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['prdpriceid']);
                if (!empty($model)) {
                    $model->pdpquantity = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }
    
    public function actionSaveQtyBreakTo() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['prdpriceid'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['prdpriceid']);
                if (!empty($model)) {
                    $model->pdpsquantity = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }
    
    public function actionSaveQtyBreakPrice() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['prdpriceid'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['prdpriceid']);
                if (!empty($model)) {
                    $model->pdpprice = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }
    
    public function actionSaveQtyBreakSellPrice() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['prdpriceid'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['prdpriceid']);
                if (!empty($model)) {
                    $model->pdpsellprice = floatval($_POST['value']) ;

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }
    
    public function actionAjaxDelete(){
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['pdpsno'])) {
                $pdpsno = $_POST['pdpsno'];
                $price = $this->loadModel($pdpsno);
                
                $price->delete();
            }
        }else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

}
