<?php

class PurchaseOrderDetailsController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new PurchaseOrderDetails;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['PurchaseOrderDetails'])) {
            $model->attributes = $_POST['PurchaseOrderDetails'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['PurchaseOrderDetails'])) {
            $model->attributes = $_POST['PurchaseOrderDetails'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $poDetail = $this->loadModel($id);

            $po = PurchaseOrders::model()->findByPk($poDetail->po_id);



            $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $po->id));
            $link = CHtml::link($po->poNum, $url, array('target' => '_blank'));

            $comment = "Purchase order details [{$poDetail->workorderDtl->productsku} x {$poDetail->workorderDtl->prodQty} @ each {$poDetail->workorderDtl->prodCostPrice}] has been deleted from the ({$link})";

            $transaction = Yii::app()->db->beginTransaction();
            $allSaved = true;
            if (in_array($po->poType, array(PurchaseOrders::PO_TYPE_PROUDCT))) {
                if ($allSaved = $poDetail->delete()) {

                    $jobProduct = JobProducts::model()->findByPk($poDetail->flowjob_id);
                    $jobProduct->po_id = null;
                    $jobProduct->status_id = null;
                    $allSaved = $jobProduct->save(false);

                    $jobActivity = JobActivityFlow::model()->find("flowjob_id = $jobProduct->id AND activity = '" . JobActivityFlow::JOB_ACTIVITY_PO_CREATED . "'");
                    if ($jobActivity) {
                        $allSaved = $jobActivity->delete();
                    }
                }
            } else if (in_array($po->poType, array(PurchaseOrders::PO_TYPE_PROUDCT_DECORATION))) {
                //for decoration po there may have multiple po details for each decoration, so need to extract those po details from workorder details id
                $poDecoDetails = PurchaseOrderDetails::model()->findAll("po_id = $po->id AND workorderDtl_id = $poDetail->workorderDtl_id");
                foreach ($poDecoDetails as $podtl) {
                    $jobProductDecoration = JobProductDecorations::model()->findByPk($podtl->flowjob_id);

                    $jobProductDecoration->po_id = null;
                    $jobProductDecoration->status_id = null;
                    if ($allSaved = $jobProductDecoration->save(false)) {
                        $jobActivity = JobActivityFlow::model()->find("flowjob_id = $jobProductDecoration->id AND activity = '" . JobActivityFlow::JOB_ACTIVITY_PO_CREATED . "'");
                        if ($jobActivity) {
                            $allSaved = $jobActivity->delete();
                        }
                    }

                    $allSaved = $podtl->delete();
                }
            }

            if ($allSaved) {
                SalesLog::createSalesLogTblId($po->quote_id, $po->workorder->id, $po->quoteNum, $po->job->id, SalesLog::CATEGORY_JOB, $comment, 1, 1, 1);
                SalesLog::createSalesLogTblId($po->quote_id, $po->workorder->id, $po->quoteNum, $po->id, SalesLog::CATEGORY_PURCHASE_ORDER, $comment, 1, 1, 1);
                $transaction->commit();
            } else {
                $transaction->rollback();
            }

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('PurchaseOrderDetails');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new PurchaseOrderDetails('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['PurchaseOrderDetails']))
            $model->attributes = $_GET['PurchaseOrderDetails'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = PurchaseOrderDetails::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'purchase-order-details-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionAddJobProductItems() {

        $poId = $_POST['poId'];
        $po = PurchaseOrders::model()->findByPk($poId);
        $jobProductIds = $_POST['jobProductIds'];
        $transaction = Yii::app()->db->beginTransaction();
        $allSaved = true;
        $comment = '';
        foreach ($jobProductIds as $key => $jpid) {
            $jobProduct = JobProducts::model()->findByPk($jpid);

            //check job product already exists before it add
            $poDetail = PurchaseOrderDetails::model()->find("flowjob_id = {$jobProduct->id}");

            if (!$poDetail) {
                $poDetail = new PurchaseOrderDetails();
                $poDetail->po_id = $po->id;
                $poDetail->workorderDtl_id = $jobProduct->workorderDtl_id;
                $poDetail->flowjob_id = $jobProduct->id;
                $poDetail->qty = $jobProduct->qty;
                $poDetail->notation = $jobProduct->notation;

                if ($poDetail->save(false)) {
                    $jobProduct->status_id = 5; //PO Created    
                    $jobProduct->po_id = $po->id;
                    $jobProduct->save(false);

                    $jobactivityflow = new JobActivityFlow();
                    $jobactivityflow->job_id = $po->job_id;
                    $jobactivityflow->wrkorder_id = $po->workorder_id;
                    $jobactivityflow->wrkorderDtl_id = $jobProduct->workorderDtl_id;
                    $jobactivityflow->flowjob_id = $jobProduct->id;
                    $jobactivityflow->type = JobActivityFlow::JOB_ACTIVITY_TYPE_PRODUCT;
                    $jobactivityflow->activity = JobActivityFlow::JOB_ACTIVITY_PO_CREATED;
                    $jobactivityflow->save(false);

                    $comment .= "\n Purchase order details [{$poDetail->workorderDtl->productsku} x {$poDetail->workorderDtl->prodQty} @ each {$poDetail->workorderDtl->prodCostPrice}] ";
                }
            } else {
                throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
            }
        }

        if ($allSaved) {

            $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $po->id));
            $link = CHtml::link($po->poNum, $url, array('target' => '_blank'));

            $comment .= "have been added to the ({$link})";

            SalesLog::createSalesLogTblId($po->quote_id, $po->workorder->id, $po->quoteNum, $po->job->id, SalesLog::CATEGORY_JOB, $comment, 1, 1, 1);
            SalesLog::createSalesLogTblId($po->quote_id, $po->workorder->id, $po->quoteNum, $po->id, SalesLog::CATEGORY_PURCHASE_ORDER, $comment, 1, 1, 1);

            $transaction->commit();
            echo json_encode(array('success' => true));
        } else {
            $transaction->rollback();
            echo json_encode(array('success' => true));
        }
    }

    public function actionAddJobProductDecorationItems() {
        $poId = $_POST['poId'];
        $po = PurchaseOrders::model()->findByPk($poId);
        $jobProductDecorationsArr = $_POST['JobProductDecorations'];
        $transaction = Yii::app()->db->beginTransaction();
        $allSaved = true;
        $comment = '';
        foreach ($jobProductDecorationsArr as $wdid => $jpdarr) {
            foreach ($jpdarr as $key => $jpdid) {
                $jobProductDecoration = JobProductDecorations::model()->findByPk($jpdid);

                //check job product already exists before it add
                $poDetail = PurchaseOrderDetails::model()->find("flowjob_id = {$jobProductDecoration->id}");
                if (!$poDetail) {
                    $poDetail = new PurchaseOrderDetails();
                    $poDetail->po_id = $po->id;
                    $poDetail->workorderDtl_id = $wdid;
                    $poDetail->flowjob_id = $jobProductDecoration->id;
                    $poDetail->qty = $jobProductDecoration->decoQty;
                    $poDetail->notation = $jobProductDecoration->notation;

                    if ($poDetail->save(false)) {
                        $jobProductDecoration->status_id = 5; //PO Created    
                        $jobProductDecoration->po_id = $po->id;
                        $jobProductDecoration->save(false);

                        $jobactivityflow = new JobActivityFlow();
                        $jobactivityflow->job_id = $po->job_id;
                        $jobactivityflow->wrkorder_id = $po->workorder_id;
                        $jobactivityflow->wrkorderDtl_id = $wdid;
                        $jobactivityflow->flowjob_id = $jobProductDecoration->id;
                        $jobactivityflow->type = JobActivityFlow::JOB_ACTIVITY_TYPE_PRODUCT_DECORATION;
                        $jobactivityflow->activity = JobActivityFlow::JOB_ACTIVITY_PO_CREATED;
                        $jobactivityflow->save(false);

                        $comment .= "\n Purchase order details [{$poDetail->workorderDtl->productsku} x {$poDetail->workorderDtl->prodQty} @ each {$poDetail->workorderDtl->prodCostPrice}] ";
                    }
                } else {
                    throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
                }
            }
        }

        if ($allSaved) {

            $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $po->id));
            $link = CHtml::link($po->poNum, $url, array('target' => '_blank'));

            $comment .= "have been added to the ({$link})";

            SalesLog::createSalesLogTblId($po->quote_id, $po->workorder->id, $po->quoteNum, $po->job->id, SalesLog::CATEGORY_JOB, $comment, 1, 1, 1);
            SalesLog::createSalesLogTblId($po->quote_id, $po->workorder->id, $po->quoteNum, $po->id, SalesLog::CATEGORY_PURCHASE_ORDER, $comment, 1, 1, 1);

            $transaction->commit();
            echo json_encode(array('success' => true));
        } else {
            $transaction->rollback();
            echo json_encode(array('success' => true));
        }
    }

    public function actionUpdateXeroExpensesAccount() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);
        $model->xero_account_id = $_POST['xeroExpensesAccountId'];
        $model->save(false);
    }

}
