<?php

class PurchaseOrdersController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'createEmbTapePO', 'confirm'
                    , 'purchaseArtwork', 'print', 'updatePOnotation', 'outstandingPOs'
                    , 'generateOutstandingPOsExcel', 'generateOutstandingPOsPDF', 'xeroUpdate', 'dueReport'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $model = $this->loadModel($id);

        //for old POs which has created before this function implemented, set default PO flag options from system settings
        $model->setDefaultFlag();

        //change the date view format
        $model->followupDate = date('d-m-Y', strtotime($model->followupDate));
        $model->dueDate = date('d-m-Y', strtotime($model->dueDate));

        $job = Jobs::model()->findByPk($model->job_id);

        $statusId = Status::model()->findByAttributes(array('name' => 'OPEN'))->id;
        $supOpenConsolidates = new ConsolidatedPurchaseOrder();
        $supOpenConsolidates->supplier_id = $model->supplier_id;
        $supOpenConsolidates->status_id = $statusId;
        $supOpenConsolidates->po_type = $model->poType;

        if (isset($_GET['ConsolidatedPurchaseOrder'])) {
            $model->attributes = $_GET['ConsolidatedPurchaseOrder'];
        }


        if (isset($_GET['xr'])) {
            Yii::app()->user->setFlash('success', "Purchase Order is successfully updated on Xero!");
        } else if (isset($_GET['xrerr'])) {
            Yii::app()->user->setFlash('error', $_GET['xrerr']);
        }

        if ($model->poType == 'Purchase  Embroidery Tape') {

            $artworkinventory = InventoryArtWork::model()->find("embrTapePo_id = '$model->id'");
            $artwrkjob = InternalJobs::model()->findByPk($artworkinventory->internaljob_id);

            $this->render('view', array(
                'model' => $model,
                'job' => $job,
                'artworkinventory' => $artworkinventory
            ));
        } else if ($model->poType == 'Purchase Artwork') {
            $artwork = JobArtwork::model()->findByPk($model->artwork_job_id);


            $criteria2 = new CDbCriteria;
            $criteria2->compare('job_artowk_id', $model->artwork_job_id);

            $decorationproducts = new CActiveDataProvider(new JobArtworkDetail(), array(
                'criteria' => $criteria2,
                'pagination' => false,
            ));
            $this->render('view', array(
                'model' => $model,
                'job' => $job,
                'artwork' => $artwork,
                'decorationproducts' => $decorationproducts,
            ));
        } else {
            $this->render('view', array(
                'model' => $model,
                'job' => $job,
                'supOpenConsolidates' => $supOpenConsolidates
            ));
        }
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {

        $model = new PurchaseOrders;
        /**
         * it comes here first from job, if following parameters are available
         */
        if (isset($_GET['job_activity']) && isset($_GET['job_id']) && !isset($_POST['yt0'])) {

            $followupdate = strtotime("+6 day");
            $model->followupDate = date(GlobalVars::get("DateFormat"), $followupdate);

            $dueInXDays = GlobalVars::get("DueInXDays") ?: 14;
            $dueDate = strtotime("+$dueInXDays day");
            $model->dueDate = date(GlobalVars::get("DateFormat"), $dueDate);

            $job_activity = $_GET['job_activity'];
            $job_id = $_GET['job_id'];
            $job = Jobs::model()->findByPk($job_id);

            if ($job_activity == JobActivity::model()->find('activity="Purchase Products"')->id) {

                $job_product_ids = $_GET['jp_ids'];
                $jobproductStrIds = str_replace('_', ',', $job_product_ids);

                $defailut_supplier_id = 0;
                if ($job_activity == 1) {
                    $jobsproducts = JobProducts::model()->findAll("job_id = '$job_id' AND id IN ({$jobproductStrIds})");
                    $model->poType = 'Purchase Product';
                    $model->job_id = $job_id;
                    foreach ($jobsproducts as $jp) {
                        $defailut_supplier_id = $jp->workorderDtl->prodSupp->supsno;
                    }
                } else if ($job_activity == 8) {
                    $model->poType = 'Purchase Product-Decoration';
                }

                $salesorder = $job->workorder;


                $model->supplier_id = $defailut_supplier_id;



                $dataProvider = null;

                if (!empty($jobproductStrIds)) {
                    $dataProvider = new CActiveDataProvider('JobProducts', array(
                        'criteria' => array(
                            'condition' => " id in ({$jobproductStrIds})",
                        ),
                        'pagination' => false,
                    ));
                }

                $this->render('create', array(
                    'model' => $model,
                    'salesorder' => $salesorder,
                    'dataProvider' => $dataProvider,
                ));
            }
        }




//        if create purchase order from the form
        if (isset($_POST['yt0'])) {


            if (isset($_POST['JobProducts']) && isset($_POST['PurchaseOrders']) && isset($_POST['yt0'])) {
                $transaction = Yii::app()->db->beginTransaction();
                $job_product_ids = $_POST['JobProducts']['ids'];
//                $job_product_costs = $_POST['JobProducts']['cost'];
                $job_id = null;

                foreach ($job_product_ids as $key => $val) {
                    $job_id = JobProducts::model()->findByPk($val)->job_id;
                    break;
                }



                $model->attributes = $_POST['PurchaseOrders'];

                $salesorder = Workorder::model()->findByPk($model->workorder_id);


                $model->quote_id = $salesorder->quotationId;
                $model->quoteNum = $salesorder->quotationNumber;
                $model->job_id = $job_id;
                $model->poType = 'Purchase Product';
                $deliverystatus = DeliveryStatus::model()->findByPk($model->delivery_status_id);
                if (!empty($deliverystatus)) {
                    $model->delivery_notes .= "<br>" . $deliverystatus->name . "( " . date(GlobalVars::get("DateFormat")) . " )";
                }


                if (empty($model->followupDate)) {
                    $followupdate = strtotime("+6 day");
                    $model->followupDate = date('Y-m-d', $followupdate);
                } else {
                    $model->followupDate = date('Y-m-d', strtotime($model->followupDate));
                }

                if (empty($model->dueDate)) {
                    $dueDate = strtotime("+10 day");
                    $model->dueDate = date('Y-m-d', $dueDate);
                } else {
                    $model->dueDate = date('Y-m-d', strtotime($model->dueDate));
                }


                $model->user_id = Yii::app()->user->id;
                $model->createdDtm = date("Y-m-d g:i");
                $model->status_id = 1; //New


                if ($model->save()) {

                    $POPrefix = GlobalVars::get(GlobalVars::PURCHASE_ORDER_PREFIX);

                    if ($startingNumber = GlobalVars::get(GlobalVars::PO_STARTING_NUMBER)) {
                        if (!$poNumber = GlobalVars::get(GlobalVars::PO_NEXT_NUMBER)) {
                            $poNumber = $startingNumber;
                        }
                        $compositePONumber = $POPrefix . '-' . str_pad($poNumber, 6, '0', STR_PAD_LEFT);
                        while (PurchaseOrders::model()->find("poNum = '{$compositePONumber}'")) {
                            $compositePONumber++;
                        }

                        $model->poNum = $compositePONumber;
                        $nextPONumber = ++$poNumber;
                        $sql = "UPDATE global_vars SET value = '$nextPONumber' WHERE globalVar = '" . GlobalVars::PO_NEXT_NUMBER . "'";
                        Yii::app()->db->createCommand($sql)->execute();
                    } else {
                        $model->poNum = $POPrefix . '-' . str_pad($model->id, 6, '0', STR_PAD_LEFT);
                    }

                    $po_save = $model->save();

                    if (!empty($model->delivery_status_id)) {
                        $ponote = new PurchaseOrderNotes();
                        $ponote->po_id = $model->id;
                        $ponote->delivery_note_id = $model->delivery_status_id;
                        $ponote->save();
                    }


                    $slogdetails = "";
                    $po_dtl_save = true;
                    $job_prod_save = true;
                    $job_activity_save = true;
                    $job_update = true;
                    foreach ($job_product_ids as $key => $val) {



                        $job_product = JobProducts::model()->findByPk($val);


                        $slogdetails .= !empty($job_product->workorderDtl->productsku) ? $job_product->workorderDtl->prdsrtdesc . " x {$job_product->qty}," : $job_product->workorderDtl->custmproduct . " x {$job_product->qty},";

                        $podtl = new PurchaseOrderDetails();
                        $podtl->po_id = $model->id;
                        $podtl->workorderDtl_id = $job_product->workorderDtl->id;
                        $podtl->flowjob_id = $job_product->id;
                        $podtl->qty = $job_product->qty;

                        if ((int) SystemOptions::getOptions()->enbleXero && isset($_POST['Workorderdetails']['xero_account_id'])) { // Xero must be enable in system settings to be available this value
                            $podtl->xero_account_id = $_POST['Workorderdetails']['xero_account_id'][$job_product->id];
                        }

                        if ($podtl->save()) {
                            $po_dtl_save = true;

                            $job_product->dueDate = $model->dueDate;
                            $job_product->user_id = Yii::app()->user->id;
                            $job_product->status_id = 5; //PO Created                                
                            $job_product->po_id = $model->id;
                            $job_prod_save = $job_product->save();

                            $jobactivityflow = new JobActivityFlow();
                            $jobactivityflow->job_id = $model->job_id;
                            $jobactivityflow->wrkorder_id = $model->workorder_id;
                            $jobactivityflow->wrkorderDtl_id = $job_product->workorderDtl->id;
                            $jobactivityflow->flowjob_id = $job_product->id;
                            $jobactivityflow->type = 'Product'; //All types - Product, Decoration ,Product Decoration                            
                            $jobactivityflow->activity = 'PO Created';
                            $job_activity_save = $jobactivityflow->save();
                        }
                    }

                    //save default PO flag options
                    $model->setDefaultFlag();

                    if ($model->job->status_id == 1) {
                        $model->job->status_id = 18; //Job In Progressing
                        $job_update = $model->job->save();
                    }



                    $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                    $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));
                    SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Purchase order ({$link}) is created for products ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);
                    SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$link}) is created for products ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);

                    if ($po_save == true && $po_dtl_save == true && $job_prod_save == true && $job_activity_save == true) {
                        $transaction->commit();
                    } else {
                        $transaction->rollback();
                    }

//                    if (Yii::app()->session['job_activity'] == 8) {
//                        SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Purchase order ({$model->poNum}) is created for products-decoration ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);
//                        SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$model->poNum}) is created for products-decoration ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);
//                    }
                }
            } else if (isset($_POST['JobProductDecorations']) && isset($_POST['PurchaseOrders']) && isset($_POST['yt0'])) {

                $job_product_decoration_ids = $_POST['JobProductDecorations']['ids'];
//                $job_product_decoration_costs = $_POST['JobProductDecorations']['cost'];
                $job_id = null;

                foreach ($job_product_decoration_ids as $key => $val) {
                    $job_id = JobProductDecorations::model()->findByPk($val)->job_id;
                    break;
                }



                $model->attributes = $_POST['PurchaseOrders'];

                $salesorder = Workorder::model()->findByPk($model->workorder_id);


                $model->quote_id = $salesorder->quotationId;
                $model->quoteNum = $salesorder->quotationNumber;
                $model->job_id = $job_id;
                $model->poType = 'Purchase Product-Decoration';

                $deliverystatus = DeliveryStatus::model()->findByPk($model->delivery_status_id);
                if (!empty($deliverystatus)) {
                    $model->delivery_notes .= "<br>" . $deliverystatus->name . "( " . date(GlobalVars::get("DateFormat")) . " )";
                }


                if (empty($model->followupDate)) {
                    $followupdate = strtotime("+6 day");
                    $model->followupDate = date('Y-m-d', $followupdate);
                } else {
                    $model->followupDate = date('Y-m-d', strtotime($model->followupDate));
                }

                if (empty($model->dueDate)) {
                    $dueDate = strtotime("+10 day");
                    $model->dueDate = date('Y-m-d', $dueDate);
                } else {
                    $model->dueDate = date('Y-m-d', strtotime($model->dueDate));
                }


                $model->user_id = Yii::app()->user->id;
                $model->createdDtm = date("Y-m-d g:i");
                $model->status_id = 1; //New


                if ($model->save()) {
                    $POPrefix = GlobalVars::get(GlobalVars::PURCHASE_ORDER_PREFIX);

                    if ($startingNumber = GlobalVars::get(GlobalVars::PO_STARTING_NUMBER)) {
                        if (!$poNumber = GlobalVars::get(GlobalVars::PO_NEXT_NUMBER)) {
                            $poNumber = $startingNumber;
                        }
                        $compositePONumber = $POPrefix . '-' . str_pad($poNumber, 6, '0', STR_PAD_LEFT);
                        while (PurchaseOrders::model()->find("poNum = '{$compositePONumber}'")) {
                            $compositePONumber++;
                        }

                        $model->poNum = $compositePONumber;
                        $nextPONumber = ++$poNumber;
                        $sql = "UPDATE global_vars SET value = '$nextPONumber' WHERE globalVar = '" . GlobalVars::PO_NEXT_NUMBER . "'";
                        Yii::app()->db->createCommand($sql)->execute();
                    } else {
                        $model->poNum = $POPrefix . '-' . str_pad($model->id, 6, '0', STR_PAD_LEFT);
                    }

                    $po_save = $model->save();

                    if (!empty($model->delivery_status_id)) {
                        $ponote = new PurchaseOrderNotes();
                        $ponote->po_id = $model->id;
                        $ponote->delivery_note_id = $model->delivery_status_id;
                        $ponote->save();
                    }


                    $slogdetails = "";
                    foreach ($job_product_decoration_ids as $key => $val) {



                        $job_product_decoration = JobProductDecorations::model()->findByPk($val);
//                        $originalcost = $job_product_decoration->decoCostPrice;
//                        ;
//                        $editedcost = 0;
//
//                        foreach ($job_product_decoration_costs as $keyprddtl => $valcost) {
//                            if ($val == $keyprddtl) {
//                                $editedcost = $valcost;
//                                break;
//                            }
//                        }
//
//                        if ($originalcost <> $editedcost) {
//                            $job_product_decoration->decoCostPrice = $editedcost;
//                        }



                        $slogdetails .= !empty($job_product_decoration->workorderDtl->productsku) ? $job_product_decoration->workorderDtl->prdsrtdesc . " - {$job_product_decoration->getDecorationString()} x {$job_product_decoration->decoQty}," : $job_product_decoration->workorderDtl->custmproduct . " x {$job_product_decoration->decoQty},";

                        $podtl = new PurchaseOrderDetails();
                        $podtl->po_id = $model->id;
                        $podtl->workorderDtl_id = $job_product_decoration->workorderDtl->id;
                        $podtl->flowjob_id = $job_product_decoration->id;
                        $podtl->qty = $job_product_decoration->decoQty;

                        if ((int) SystemOptions::getOptions()->enbleXero && isset($_POST['Workorderdetails']['xero_account_id'])) { // Xero must be enable in system settings to be available this value
                            $podtl->xero_account_id = $_POST['Workorderdetails']['xero_account_id'][$job_product_decoration->id];
                        }

                        if ($podtl->save()) {

                            $job_product_decoration->dueDate = $model->dueDate;
                            $job_product_decoration->user_id = Yii::app()->user->id;
                            $job_product_decoration->status_id = 5; //PO Created                                
                            $job_product_decoration->po_id = $model->id;
                            $job_product_decoration->save();

                            $jobactivityflow = new JobActivityFlow();
                            $jobactivityflow->job_id = $model->job_id;
                            $jobactivityflow->wrkorder_id = $model->workorder_id;
                            $jobactivityflow->wrkorderDtl_id = $job_product_decoration->workorderDtl->id;
                            $jobactivityflow->flowjob_id = $job_product_decoration->id;
                            $jobactivityflow->type = 'Product-Decoration'; //All types - Product, Decoration ,Product-Decoration                            
                            $jobactivityflow->activity = 'PO Created';
                            $jobactivityflow->save();
                        }
                    }

                    if ($model->job->status_id == 1) {
                        $model->job->status_id = 18; //Job In Progressing
                        $model->job->save();
                    }


                    $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                    $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));
                    SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Purchase order ({$link}) is created for products-decoration ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);
                    SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$link}) is created for products ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);


//                    if (Yii::app()->session['job_activity'] == 8) {
//                        SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Purchase order ({$model->poNum}) is created for products-decoration ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);
//                        SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$model->poNum}) is created for products-decoration ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);
//                    }
                }
            }
            $this->redirect(array('view', 'id' => $model->id));
        }


        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);
    }

    private function getTodayPOCount() {
        $pos = PurchaseOrders::model()->findAll("DATE_FORMAT(createdDtm, '%Y-%m-%d') = CURDATE()");
        return count($pos);
    }

    private function getPOCount($quotenumber) {
        $pos = PurchaseOrders::model()->findAll("quoteNum = '{$quotenumber}'");
        return count($pos);
    }

    public function actionCreateEmbTapePO() {
        //print_r($_POST);
        $model = new PurchaseOrders();

        if (isset($_GET['id']) && (isset($_GET['type']) && $_GET['type'] == 'po_emb_tape') && !isset($_POST['yt0'])) {
            //get id is inventory artwork id

            $artworkinventory = InventoryArtWork::model()->findByPk($_GET['id']);
            $internaljob = InternalJobs::model()->findByPk($artworkinventory->internaljob_id);
            //$artworkinventory = InventoryArtWork::model()->find("internaljob_id = '{$internaljob->id}'");
            //$artwrkjob = InternalJobs::model()->findByPk($_GET['id']);
            $job = Jobs::model()->findByPk($internaljob->job_id);

            $this->render('_form_embtape', array(
                'model' => $model,
                'job' => $job,
                'artworkinventory' => $artworkinventory
            ));
        }



        if (isset($_POST['PurchaseOrders']) && isset($_POST['yt0'])) {
            $model->attributes = $_POST['PurchaseOrders'];

            $artworkinventory = InventoryArtWork::model()->findByPk($model->inventoryArtworkID);

            $artwrkjob = InternalJobs::model()->findByPk($artworkinventory->internaljob_id);
            $job = Jobs::model()->findByPk($artworkinventory->job_id);

            $model->job_id = $job->id;
            $model->workorder_id = $job->workorder_id;
            $model->quote_id = $job->quote_id;
            $model->quoteNum = $job->quoteNum;

            $model->poType = 'Purchase Embroidery Tape';
            $model->image = $artworkinventory->image;

            $model->user_id = Yii::app()->user->id;
            $model->status_id = 1; //New
            $model->createdDtm = date("Y-m-d g:i");

            if ($model->save()) {
                $model->poNum = 'POGG' . (8000 + $model->id);
                $model->save();

                if (!empty($artwrkjob)) {
                    $artwrkjob->status_id = 12; //Emb PO Created
                    $artwrkjob->save();


                    $interjobdtls = InternalJobsDetails::model()->findAll("internalJob_id = '{$artwrkjob->id}'");





                    foreach ($interjobdtls as $dtl) {

                        $podtls = new PurchaseOrderDetails();
                        $podtls->po_id = $model->id;
                        $podtls->workorderDtl_id = $dtl->wrkordrDtl_id;
                        $wrkorderdtl = Workorderdetails::model()->findByPk($dtl->wrkordrDtl_id);
                        $podtls->qty = $wrkorderdtl->decoQty;
                        $podtls->save();

                        $activityflow = new JobActivityFlow();
                        $activityflow->job_id = $job->id;
                        $activityflow->wrkorder_id = $job->workorder_id;
                        $activityflow->wrkorderDtl_id = $dtl->wrkordrDtl_id;
                        $activityflow->type = 'Decoration';
                        $activityflow->activity = 'PO Emb Tape';

                        $activityflow->save();

                        $jobdecoration = JobDecorations::model()->find("internalJob_id = '{$artwrkjob->id}' and workorderDtl_id = '{$dtl->wrkordrDtl_id}'");

                        $jobdecoration->status_id = 12; //Emb Tape PO Created
                        $jobdecoration->save();
                    }
                } else {
                    $jobdecorations = JobDecorations::model()->findAll("decoJobType = 'Purchase Artwork' and po_id = '{$artworkinventory->po_id}'");
                    foreach ($jobdecorations as $deco) {
                        $podtls = new PurchaseOrderDetails();
                        $podtls->po_id = $model->id;
                        $podtls->workorderDtl_id = $deco->workorderDtl_id;
                        $wrkorderdtl = Workorderdetails::model()->findByPk($deco->workorderDtl_id);
                        $podtls->qty = $wrkorderdtl->decoQty;
                        $podtls->save();

                        $activityflow = new JobActivityFlow();
                        $activityflow->job_id = $job->id;
                        $activityflow->wrkorder_id = $job->workorder_id;
                        $activityflow->wrkorderDtl_id = $deco->workorderDtl_id;
                        $activityflow->type = 'Decoration';
                        $activityflow->activity = 'PO Emb Tape';

                        $activityflow->save();

                        $deco->status_id = 12; //Emb Tape PO Created
                        $deco->save();
                    }
                }


                $artworkinventory->embrTapePo_id = $model->id;
                $artworkinventory->save();

                $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));

                $urlart = Yii::app()->createUrl('inventoryArtWork/view', array("id" => $artworkinventory->id));
                $linkart = CHtml::link($artworkinventory->artworkcode, $urlart, array('target' => '_blank'));

                SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->quotationNumber, 'Job', "Embroidery tape purchase order ({$link}) is created for artwork ({$linkart}) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate);
            }
            $this->redirect(array('view', 'id' => $model->id));
        }
    }

    public function actionPurchaseArtwork() {

        $model = new PurchaseOrders();

        if (isset($_POST['PurchaseOrders']) && isset($_POST['yt0'])) {
            $transaction = Yii::app()->db->beginTransaction();

            $model->attributes = $_POST['PurchaseOrders'];
            $artwork_job_id = $_POST['PurchaseOrders']['artwork_job_id'];
            $model->artwork_job_id = $artwork_job_id;
            $artwork = JobArtwork::model()->findByPk($artwork_job_id);
            $jobartworkdtls = JobArtworkDetail::model()->findAll(array('condition' => "job_artowk_id = '{$artwork_job_id}'"));

            //$workodrdtls = $_POST['Workorderdetails'];
            $job = Jobs::model()->findByPk($artwork->job_id);

            $model->workorder_id = $job->workorder_id;
            $model->quote_id = $job->quote_id;
            $model->quoteNum = $job->quoteNum;

            $model->poType = 'Purchase Artwork';

            if (empty($model->followupDate)) {
                $followupdate = strtotime("+6 day");
                $model->followupDate = date('Y-m-d', $followupdate);
            } else {
                $model->followupDate = date('Y-m-d', strtotime($model->followupDate));
            }

            if (empty($model->dueDate)) {
                $dueDate = strtotime("+10 day");
                $model->dueDate = date('Y-m-d', $dueDate);
            } else {
                $model->dueDate = date('Y-m-d', strtotime($model->dueDate));
            }


            $model->status_id = 1; //New
            $model->user_id = Yii::app()->user->id;
            $model->createdDtm = date(GlobalVars::MYSQL_DATETIME_FORMAT);

            $savemodel = false;
            $saveartwork = false;
            $savepodtl = false;
            $savedecodtl = false;
            $savejob = false;
            if ($model->save()) {
                $model->poNum = 'POGG' . (8000 + $model->id);
                $savemodel = $model->save();

                $artwork->jobType = JobArtwork::JOB_TYPE_PURCHASE_ARTOWRK;
                $artwork->job_status_id = 5;
                $artwork->po_id = $model->id;
                $saveartwork = $artwork->save();

                $slogdetails = "";
                foreach ($jobartworkdtls as $dtl) {

                    $jobdecoration = JobDecorations::model()->findByPk($dtl->job_decoration_id);
                    $podtl = new PurchaseOrderDetails();
                    $podtl->po_id = $model->id;
                    $podtl->workorderDtl_id = $jobdecoration->workorderDtl_id;
                    $wrkdtl = $jobdecoration->workorderDtl;
                    $podtl->qty = $jobdecoration->decoQty;
                    $podtl->flowjob_id = $dtl->job_decoration_id;
                    $savepodtl = $podtl->save();

                    $slogdetails .= !empty($wrkdtl->productsku) ? $wrkdtl->prdsrtdesc . " x {$wrkdtl->prodQty}," : $wrkdtl->custmproduct . " x {$wrkdtl->prodQty},";




                    $jobdecoration->decoJobType = 'Purchase Artwork';
                    $jobdecoration->po_id = $model->id;
                    $jobdecoration->followupDate = $model->followupDate;
                    $jobdecoration->duedate = $model->dueDate;
                    $jobdecoration->status_id = 14; //Artwork PO Created
                    $jobdecoration->user_id = Yii::app()->user->id;
                    $jobdecoration->createdDtm = date('Y-m-d H:s:i');

                    $savedecodtl = $jobdecoration->save();
                }

                $job->status_id = 18; //Job In Progressing
                $savejob = $job->save();


                $artworkrul = Yii::app()->createUrl('jobArtwork/view', array("id" => $artwork->id));
                $artworklink = CHtml::link($artwork->artworkjobNum, $artworkrul, array('target' => '_blank'));

                $logtextartwrk = "Type of Artwork Job ({$artworklink}) is changed to Purchase Artwork";

                SalesLog::createSalesLog($model->job->workorder->quotationId, $model->job->workorder->id, $model->job->workorder->quotationNumber, 'Job', $logtextartwrk, 1, 1, 1);
                SalesLog::createTblLog($model->id, 'JobArtwork', $logtextartwrk);


                $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));


                $logtext = "Artwork purchase order ({$link}) is created for the artwork ($artworklink) and for the items ($slogdetails) and expected on {$model->dueDate}";
                SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', $logtext, 1, 1, 1, $model->followupDate);
                SalesLog::createTblLog($artwork->id, 'JobArtwork', $logtext);
            }
            if (in_array(true, array($saveartwork, $savedecodtl, $savejob, $savemodel, $savepodtl))) {
                $transaction->commit();
                $this->redirect(array('view', 'id' => $model->id));
            } else {
                $transaction->rollback();
            }
        } else if (isset($_GET['id']) && !isset($_POST['yt0'])) {

            $artworkjobid = $_GET['id'];



            $model->artwork_job_id = $artworkjobid;



            $artwork = JobArtwork::model()->findByPk($artworkjobid);
            $model->job_id = $artwork->job_id;

            $criteria2 = new CDbCriteria;
            $criteria2->compare('job_artowk_id', $artworkjobid);

            $decorationproducts = new CActiveDataProvider(new JobArtworkDetail(), array(
                'criteria' => $criteria2,
                'pagination' => false,
            ));

            $this->render('_form_artwork', array(
                'model' => $model,
                'artwork' => $artwork,
                'decorationproducts' => $decorationproducts
            ));
        }
    }

    private $image_path = '/images/artwork/';

    private function saveImage($model) {


        ////////////////
        $uploadedFile = CUploadedFile::getInstance($model, 'image');

        //print_r($uploadedFile);
        $path = '';

        if (is_object($uploadedFile)) {
            $fileName = $uploadedFile->getName();

            $model->image = $fileName;

            $path = Yii::app()->basePath . "/.." . $this->image_path . $fileName;



            $uploadedFile->saveAs($path);


            //$image = Yii::app()->image->load($path);
            //$image->resize(250, 250);
            //$image->save();
        }


        return $model;
    }

    public function actionConfirm($id) {
        $model = $this->loadModel($id);
        if (in_array($model->status_id, array(Status::SYS_STATUS_NEW))) {
            $model->status_id = Status::SYS_STATUS_CONFIRMED;
            if ($model->save()) {
                Yii::app()->user->setFlash('success', "Purchase Order {$model->poNum} has been confirmed!");

                $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));

                $currentuser = User::model()->findByPk(Yii::app()->user->id)->username;
                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Purchase order ({$link}) has been confirmed by {$currentuser}", 1, 1, 1);
                SalesLog::createSalesLogTblId($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, $model->id, SalesLog::CATEGORY_PURCHASE_ORDER, "Purchase order ({$link}) has been confirmed by {$currentuser}", 1, 1, 1);
            }
        }
        $this->redirect(array('admin'));
    }
    
    public function actionComplete($id) {
        $model = $this->loadModel($id);
        if (in_array($model->status_id, array(Status::SYS_STATUS_NEW, Status::SYS_STATUS_CONFIRMED))) {
            $model->status_id = Status::SYS_STATUS_ORDER_COMPLETED; //completed
            if ($model->save()) {
                Yii::app()->user->setFlash('success', "Purchase Order {$model->poNum} has been completed!");

                $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));

                $currentuser = User::model()->findByPk(Yii::app()->user->id)->username;
                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Purchase order ({$link}) has been completed by {$currentuser}", 1, 1, 1);
                SalesLog::createSalesLogTblId($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, $model->id, SalesLog::CATEGORY_PURCHASE_ORDER, "Purchase order ({$link}) has been completed by {$currentuser}", 1, 1, 1);
            }
        }
        $this->redirect(array('admin'));
    }

    var $no_column_width = 5;
    var $img_column_width = 20;
    var $prod_column_width = 20;
    var $deco_column_width = 30;
    var $qty_column_width = 5;
    var $cost_column_width = 10;
    var $amnt_column_width = 10;
    var $show_custmizedtl = true;
    var $show_notes = true;
    var $cutmz_column_width = 45;
    var $notes_column_width = 55;

    public function actionPrint($id) {


        $model = $this->loadModel($id);

        if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration', 'Purchase Product-OtherCost', 'Purchase Artwork'))) {
            //this method is developed on 2006-07-28 by eranga
            //for now this new PDF generated method has applied only for purchase product-decoration
            $htmlcontent = null;
            if (in_array($model->poType, array('Purchase Product'))) {
                $htmlcontent = $this->renderInternal('protected/views/purchaseOrders/po_jprd_pdf_html.php', array('model' => $model), true);
            } else if (in_array($model->poType, array('Purchase Product-Decoration'))) {
                $htmlcontent = $this->renderInternal('protected/views/purchaseOrders/po_jprd_deco_pdf_html.php', array('model' => $model), true);
            } else if (in_array($model->poType, array('Purchase Product-OtherCost'))) {
                $htmlcontent = $this->renderInternal('protected/views/purchaseOrders/po_jprd_othercost_pdf_html.php', array('model' => $model), true);
            } else if (in_array($model->poType, array('Purchase Artwork'))) {
                $htmlcontent = $this->renderInternal('protected/views/purchaseOrders/po_jartwrk_pdf_html.php', array('model' => $model), true);
            }

            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);

            $mpdf = new MpsPurchaseOrderPdf;
            $mpdf->setMode(MpsPdf::MODE_CONTENT_GENERATOR)
             ->setModel($model)
             ->generate( $htmlcontent )
             ->output("{$sitePrefix}_PurchaseOrder_{$model->poNum}"); 
        }
    }

    var $rowtype = 0;
    var $count = 0;
    var $totalQty = 0;
    var $totalCost = 0;
    var $totalAmount = 0;

    private function getPurchaseProductHtml($model, $podtl, $show_price, $show_deco) {

        $record = Workorderdetails::model()->findByPk($podtl->workorderDtl_id);

        $html = '';

        // $count = 0;
        //$productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $record->productsku)));
        //$decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $record->decprtnam)));
        $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $record->id)));



        //$rowcolor = "background-color:#DDD;";

        $html .= '<tr style="width:100%;" nobr="true">            
                <td style="border-bottom:1px solid #000;">
                    <table style="width:100%;">
                            <tr   style="width:100%;">
                                <td style="width: 5%;"> ' . $this->count . ' </td>
                                <td style="width: 20%;">';
        $html .= '<img src="' . $record->getImg() . '"  width="50" height="50"/>';
//        if (!empty($record->image) && file_exists("images/product_img/" . $record->image)) {
//            $html .= '<img src="images/product_img/' . $record->image . '" width="50" height="50"/>';
//        } else {
//            $html .= '&nbsp;';
//        }
        $html .= '</td><td style="width: ' . $this->prod_column_width . '%;"><div class="prodecs">';



        if (!empty($record->productsku)) {

            $html .= trim($record->productsku . '<br>' . $record->prdsrtdesc);
        } else {

            $html .= trim($record->custmproduct);
        }
        $html .= '</div>';



        $html .= '</td>';

        if ($show_deco == true) {
            //decoration column start
            $html .= '<td style="width: ' . $this->deco_column_width . '%;">';

            if (!empty($record->decprtnam)) {

                $html .= $record->decdesc;
            } else {

                $html .= $record->customdecoration;
            }

            $html .= '</td>';
        }
        //decoration column end
        $this->totalQty += $record->prodQty;
        $html .= '<td style="width: ' . $this->qty_column_width . '%;text-align: center;">
                                    ' . $record->prodQty . '
                                </td>';

        $price = 0;

        if ($model->poType == 'Purchase Product') {
            $price = $record->prodCostPrice;
            $this->totalCost += $record->prodCostPrice;
        } else if ($model->poType == 'Purchase Product-Decoration') {
            $this->totalCost += $record->decoCostPrice;
            $price = $record->decoCostPrice;
        }
        $this->totalAmount += ($price * $record->prodQty);
        if ($show_price == true) {
            $html .= '<td style="width: 10%;text-align: right;">
                                   ' . number_format($price, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($price * $record->prodQty, 2) . '
                                </td>';
        }

        $html .= '</tr>
                            <tr  style="width:100%;">
                                <td colspan="10" style="width:100%;">
                                    <div  style="width:100%;">
                                        <table style="width:100%;">';


        $html .= '<tr style="width:100%;">
                                                <td style="width:100%;">';
        if ($this->show_custmizedtl != false || $this->show_notes != false) {
            $html .= '<table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">';
            if ($this->show_custmizedtl == true)
                $html .= '<th style="width:' . $this->cutmz_column_width . '%;text-align:center;" >Customisation Details</th>';

            if ($this->show_notes == true)
                $html .= '<th style="width:' . $this->notes_column_width . '%;text-align:center;" >Notes</th>';
            $html .= '<th></th>';

            $html .= '</tr>
                                                        <tr style="width:100%;">';
            if ($this->show_custmizedtl == true)
                $html .= '<td style="width:' . $this->cutmz_column_width . '%;text-align:center;" >' . $record->customizationDetails . '</td>';
            if ($this->show_notes == true)
                $html .= '<td style="width:' . $this->notes_column_width . '%;text-align:center;" >' . $record->notes . '</td>';

            $html .= '<td ></td>';
            $html .= '</tr>';
            $html .= '</table>';
        }
        $html .= '</td></tr>';

        $html .= '<tr style="width:100%">
                                                <td style="width:100%">
                                                    <div  style="width:100%;">
                                                        <table   style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:10%;text-align:center;">#</th>
                                                            <th style="width:30%;text-align:center;">Size</th>
                                                            <th style="width:30%;text-align:center;">Quantity</th>
                                                            <th style="width:30%;text-align:center;">Colour</th>
                                                            
                                            </tr>';


        $countrow = 0;
        foreach ($workordersizeqtycolors as $row) {
            $countrow++;

            $html .= '<tr style="width:100%;" >
                                                    <td style="width:10%;text-align:center;">' . $countrow . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['size'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['qty'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['color'] . '</td>
                                                    
                                                </tr>';
        }

        $html .= ' </table></div></td></tr></table></div></td> </tr> </table>                        
                        </td>
                    </tr>';

        return $html;
    }

    private function getPurchaseProductDecorationHtml($model, $podtl, $show_price, $show_deco, $iscommondeco, $commomdecodescription) {

        $record = Workorderdetails::model()->findByPk($podtl->workorderDtl_id);

        $html = '';

        $count = 0;


        $productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $record->productsku)));
        $decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $record->decprtnam)));
        $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $record->id)));



        $rowcolor = "background-color:#DDD;";

        $html .= '<tr style="width:100%;" nobr="true">            
                <td style="border-bottom:1px solid #000;">
                    <table style="width:100%;">
                            <tr   style="width:100%;">
                                <td style="width: 5%;"> ' . $this->count . ' </td>
                                <td style="width: 20%;">';

        $html .= '<img src="' . $record->getImg() . '" width="50" height="50"/>';
        $html .= '</td>
                                <td style="width: ' . $this->prod_column_width . '%;"><div class="prodecs">';



        if (!empty($record->productsku)) {

            $html .= trim($record->productsku . '<br>' . $record->prdsrtdesc);
        } else {

            $html .= trim($record->custmproduct);
        }
        $html .= '</div>';



        $html .= '</td>';

        if ($show_deco == true) {
            //decoration column start
            $html .= '<td style="width: ' . $this->deco_column_width . '%;">';

            if ($iscommondeco == true) {
                $html .= $commomdecodescription;
            } else {
                if (!empty($record->decprtnam)) {

                    $html .= $record->decdesc;
                } else {

                    $html .= $record->customdecoration;
                }
            }


            $html .= '</td>';
        }
        //decoration column end

        $html .= '<td style="width: ' . $this->qty_column_width . '%;text-align: center;">
                                    ' . $record->prodQty . '
                                </td>';

        $price = 0;

        if ($model->poType == 'Purchase Product') {
            $price = $record->prodCostPrice;
        } else if ($model->poType == 'Purchase Product-Decoration') {
            $price = $record->decoCostPrice;
        }

        if ($show_price == true) {
            $html .= '<td style="width: 10%;text-align: right;">
                                   ' . number_format($price, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($price * $record->prodQty, 2) . '
                                </td>';
        }

        $html .= '</tr>
                            <tr  style="width:100%;">
                                <td colspan="10" style="width:100%;">
                                    <div  style="width:100%;">
                                        <table style="width:100%;">';

        if ($iscommondeco == false) {
            $html .= '<tr style="width:100%;">
                                                <td style="width:100%;">';



            if ($this->show_custmizedtl != false || $this->show_notes != false) {
                $html .= '<table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">';
                if ($this->show_custmizedtl == true)
                    $html .= '<th style="width:' . $this->cutmz_column_width . '%;text-align:center;" >Customisation Details</th>';

                if ($this->show_notes == true)
                    $html .= '<th style="width:' . $this->notes_column_width . '%;text-align:center;" >Notes</th>';
                $html .= '<th></th>';

                $html .= '</tr>
                                                        <tr style="width:100%;">';
                if ($this->show_custmizedtl == true)
                    $html .= '<td style="width:' . $this->cutmz_column_width . '%;text-align:center;" >' . $record->customizationDetails . '</td>';
                if ($this->show_notes == true)
                    $html .= '<td style="width:' . $this->notes_column_width . '%;text-align:center;" >' . $record->notes . '</td>';


                $html .= '<td ></td>';
                $html .= '</tr>';
                $html .= '</table>';
            }

            $html .= '</td></tr>';
        }
        $html .= '<tr style="width:100%">
                                                <td style="width:100%">
                                                    <div  style="width:100%;">
                                                        <table   style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:10%;text-align:center;">#</th>
                                                            <th style="width:30%;text-align:center;">Size</th>
                                                            <th style="width:30%;text-align:center;">Quantity</th>
                                                            <th style="width:30%;text-align:center;">Colour</th>
                                                            
                                            </tr>';


        $countrow = 0;
        foreach ($workordersizeqtycolors as $row) {
            $countrow++;

            $html .= '<tr style="width:100%;" >
                                                    <td style="width:10%;text-align:center;">' . $countrow . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['size'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['qty'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['color'] . '</td>
                                                    
                                                </tr>';
        }

        $html .= ' </table></div></td></tr></table></div></td> </tr> </table>                        
                        </td>
                    </tr>';

        return $html;
    }

    /* generate outstanding excel */

    public function actionGenerateOutstandingPOsExcel() {
        if (isset(Yii::app()->session['outstandingreport_query'])) {
            $query = Yii::app()->session['outstandingreport_query'];
            $query .= ' order by dueDate ASC';
            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('outstandingPOs'));


            Yii::import('ext.phpexcel.XPHPExcel');
            $objPHPExcel = XPHPExcel::createPHPExcel();
            $objPHPExcel->getProperties()->setCreator($this->pageTitle)
                    ->setLastModifiedBy($this->pageTitle)
                    ->setTitle("Outstanding PO List")
                    ->setSubject("Outstanding PO List")
                    ->setDescription("Outstanding PO List")
                    ->setKeywords("Outstanding PO List")
                    ->setCategory("Outstanding PO List");

            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('E3', $this->pageTitle)
                    ->setCellValue('E4', $this->pageTitle . " - Outstanding PO List")
                    ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

            $column = array();

            //if(Yii::app()->session['invr_imageFlag'] == 1)
            $column['A'] = 'No';
            $column['B'] = 'Due Date';
            $column['C'] = 'PO No';
            $column['D'] = 'Job No';
            $column['E'] = 'Supplier';
            $column['F'] = 'Notes';
            $column['G'] = 'Follow-up Date';
            $column['H'] = 'Created Date';
            $column['I'] = 'PO Type';
            $column['J'] = 'Status';

            foreach ($column as $key => $val) {
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '9', $val);
            }

            $sheet = $objPHPExcel->getActiveSheet();


            foreach ($column as $key => $val) {
                $sheet->getColumnDimension($key)->setAutoSize(true);
            }

            $sheet->mergeCells("E3:F3");
            $sheet->mergeCells("E4:F4");
            $sheet->mergeCells("E5:F5");
            $sheet->mergeCells("E6:F6");

            $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
            $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));

            $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
            $sheet->getStyle("A9:J9")->applyFromArray(array("font" => array("bold" => true)));

            $row = 11;
            $count = 1;
            foreach ($rawData as $item) {
                $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A' . $row, $count)
                        ->setCellValue('B' . $row, date(GlobalVars::get("DateFormat"), strtotime($item['dueDate'])))
                        ->setCellValue('C' . $row, $item['poNum'])
                        ->setCellValue('D' . $row, Jobs::model()->findByPk($item['job_id'])->jobNum)
                        ->setCellValue('E' . $row, Supplier::model()->findByPk($item['supplier_id'])->supnam)
                        ->setCellValue('F' . $row, $item['notation'])
                        ->setCellValue('G' . $row, date(GlobalVars::get("DateFormat"), strtotime($item['followupDate'])))
                        ->setCellValue('H' . $row, date(GlobalVars::get("DateFormat"), strtotime($item['createdDtm'])))
                        ->setCellValue('I' . $row, $item['poType'])
                        ->setCellValue('J' . $row, Status::model()->findByPk($item['status_id'])->name);

                $row++;
                $count++;
            }

            // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            header('Content-Disposition: attachment;filename="'.$sitePrefix.'_OutstandingPOList_' . date('dmY') . '.xls"');
            header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');

            Yii::app()->end();
        }
    }

    public function actionGenerateOutstandingPOsPDF() {

        if (isset(Yii::app()->session['outstandingreport_query'])) {
            $query = Yii::app()->session['outstandingreport_query'];
            $query .= ' order by dueDate ASC';
            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('outstandingPOs'));

            $htmlcontent = $this->renderInternal('protected/views/purchaseOrders/outstanding_po_pdf.php', array('rawData' => $rawData), true);

            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            $pdfCreator = new PlainPDFCreator(array(
                'title' => 'Outstanding Purchase Orders',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => "{$sitePrefix}_OutstandingPOList_" . date('dmY') . ".pdf"
            ));

            $pdfCreator->generate();
        }
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['PurchaseOrders'])) {
            $model->attributes = $_POST['PurchaseOrders'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);
            $job = Jobs::model()->findByPk($model->job_id);
            $transaction = Yii::app()->db->beginTransaction();

            //this facade will handle all the subsystems that need to delete the PO correctly
            $poDeleteFacade = new PurchaseOrderDeleteFacade();
            $response = array();
            $deleted = $poDeleteFacade->deleteOrder($model, $response);

            if ($deleted) {
                $transaction->commit();
            } else {
                $transaction->rollback();
            }

            Yii::app()->user->setFlash($response['type'], $response['message']);

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(array('jobs/view', 'id' => $job->id));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('PurchaseOrders');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new PurchaseOrders('search');        
        if (isset($_GET['PurchaseOrders']))
            $model->attributes = $_GET['PurchaseOrders'];

        if (isset($_GET['pastdue']) && $_GET['pastdue'] == 1)
            $model->filterPastDue = true;

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    public function actionDueReport() {
        $model = new PurchaseOrders('searchDue(7)');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['PurchaseOrders']))
            $model->attributes = $_GET['PurchaseOrders'];

        $this->render('due_report', array(
            'model' => $model,
        ));
    }

    public function actionOutstandingPOs() {
        // print_r($_POST);
        $model = new PurchaseOrders('searchoutstadingpos');
        $model->unsetAttributes();  // clear any default values

        if (isset($_POST['PurchaseOrders'])) {
            //print_r($_POST);
            $model->attributes = $_POST['PurchaseOrders'];
//            $model->createddatefrom = $_POST['PurchaseOrders']['createddatefrom'];
//            $model->createddateto = $_POST['PurchaseOrders']['createddateto'];
//            
//            $model->followupdatefrom = $_POST['PurchaseOrders']['followupdatefrom'];
//            $model->followupdateto = $_POST['PurchaseOrders']['followupdateto'];
//            
//            $model->expecteddatefrom = $_POST['PurchaseOrders']['expecteddatefrom'];
//            $model->expecteddateto = $_POST['PurchaseOrders']['expecteddateto'];
        }

        if (isset($_GET['PurchaseOrders'])) {
            $model->attributes = $_GET['PurchaseOrders'];
        }


        if (isset($_POST['yt0']) && $_POST['yt0'] == 'Reset') {
            $model->createddatefrom = '';
            $model->createddateto = '';
            $model->followupdatefrom = '';
            $model->followupdateto = '';
            $model->expecteddatefrom = '';
            $model->expecteddateto = '';
        }

        $this->render('outstanding_pos', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = PurchaseOrders::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'purchase-orders-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionUpdatePOnotation() {
        $data = array();
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $id = $_POST['id'];
            $notes = $_POST['value'];

            $model = PurchaseOrders::model()->findByPk($id);
            $model->notation = $notes;
            if ($model->save()) {
                $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$link}) notes are updated as \"{$notes}\"", 1, 1, 1);

                $data['success'] = true;
            } else {
                $data['success'] = false;
            }
        }

        echo json_encode($data);
    }

    public function actionUpdateFollowUpStatus() {
        $data = array();
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $id = $_POST['id'];
            $followup_status_id = $_POST['value'];
            $followupmodel = FollowupStatus::model()->findByPk($followup_status_id);

            //if cannot find the follow status by the $followup_status_id (value), must terminate the process
            if (!$followupmodel) {
                throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
            }

            $model = PurchaseOrders::model()->findByPk($id);
            $model->followup_status_id = $followup_status_id;

            $model->mapFollowupStatusForSystemStatus();




            if ($model->save()) {
                $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));

                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$link}) follow-up status has been updated as \"{$followupmodel->status}\"", 1, 1, 1);

                $data['success'] = true;
            } else {
                $data['success'] = false;
            }
        }

        echo json_encode($data);
    }
    
    public function actionUpdateSupplier() {
        $data = array();
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $id = $_POST['id'];
            $supplier_id = $_POST['value'];
            $supplier = Supplier::model()->findByPk($supplier_id);

            //if cannot find the follow status by the $followup_status_id (value), must terminate the process
            if (!$supplier) {
                exit();
            }

            $model = PurchaseOrders::model()->findByPk($id);
            $model->supplier_id = $supplier_id;

            if ($model->save()) {
                $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));

                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$link}) supplier has been updated to {$supplier->supnam}", 1, 1, 1);

                $data['success'] = true;
            } else {
                $data['success'] = false;
            }
        }

        echo json_encode($data);
    }

    public function actionXeroUpdate($id) {
        require 'vendor/autoload.php';

        $storage = new StorageClass();
        if ($storage->getHasExpired()) {
            $this->redirect(array('xeroSetting/settings'));
        }

        $model = $this->loadModel($id);
        if ($model->poType == 'Purchase Product-Decoration') {
            $modelDetial = PurchaseOrderDetails::model()->findAll(array('condition' => "po_id = '$id'", 'group' => 'workorderDtl_id'));
        } else {
            $modelDetial = PurchaseOrderDetails::model()->findAll(array('condition' => "po_id = '$id'"));
        }

        $this->render('xero_private', array(
            'model' => $model,
            'modelDetial' => $modelDetial,
            'show_price' => $show_price
        ));
    }

    public function actionExportPOXML($id) {
        $id = $_GET['id'];
        $model = $this->loadModel($id);


        $dirpath = 'files/poxml';
        if (!file_exists($dirpath)) {
            mkdir($dirpath, 0777);
        }

        $xmlWidget = new XMLWidget();
        $xmlWidget->model = $model;
        $xmloutput = $xmlWidget->runPurchaseOrder();
        $fileResource = $dirpath . '/' . "{$model->poNum}.xml";
        file_put_contents($fileResource, $xmloutput);

        if (file_exists($fileResource)) {
            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
            Yii::app()->getRequest()->sendFile("{$sitePrefix}_PurchaseOrder_{$model->poNum}.xml", file_get_contents($fileResource));
        }
    }

    public function actionCreateDecorarationPO() {
        $flashMessage = "Cannot create purchase order!. Please try again!";
        if (!isset($_POST['PurchaseOrders']) && isset(Yii::app()->session['deco_ids_of_job_decoration_create_po'])) {
            $jobId = $_GET['jobId'];
            $job = Jobs::model()->findByPk($jobId);
            $model = new PurchaseOrders();
            $model->job_id = $job->id;
            $model->workorder_id = $job->workorder_id;
            $model->quote_id = $job->quote_id;
            $model->quoteNum = $job->quoteNum;
            $model->poType = 'Purchase Product-Decoration';

            $followupdate = strtotime("+6 day");
            $model->followupDate = date(GlobalVars::get("DateFormat"), $followupdate);

            $dueInXDays = GlobalVars::get("DueInXDays") ?: 14;
            $dueDate = strtotime("+$dueInXDays day");
            $model->dueDate = date(GlobalVars::get("DateFormat"), $dueDate);

            $jobProductMultiDecorationArr = json_decode(Yii::app()->session['deco_ids_of_job_decoration_create_po'], true);


            foreach ($jobProductMultiDecorationArr as $workOrderDetailId => $decoArr) {
                foreach ($decoArr as $key => $jpdid) {
                    $jpd = JobProductDecorations::model()->findByPk($jpdid);
                    $decoration = Decoration::model()->find("decprtnam = '$jpd->decprtnam'");
                    if ($decoration && $decoration->supplier) {


                        $model->supplier_id = $decoration->supplier->supsno;
                        break;
                    }
                }
            }

            $this->render('create_product_multi_deco', array(
                'model' => $model,
                'jobProductMultiDecorationArr' => $jobProductMultiDecorationArr
            ));
        } else if (isset($_POST['PurchaseOrders']) && isset($_POST['yt0']) && isset($_POST['JobProductDecorations'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $saved = true;
            $model = new PurchaseOrders();
            $model->attributes = $_POST['PurchaseOrders'];

            if (!$model->supplier_id) {
                $flashMessage = "Supplier is required!";
                $saved = false;
            }



            if (empty($model->followupDate)) {
                $followupdate = strtotime("+6 day");
                $model->followupDate = date('Y-m-d', $followupdate);
            } else {
                $model->followupDate = date('Y-m-d', strtotime($model->followupDate));
            }

            if (empty($model->dueDate)) {
                $dueDate = strtotime("+10 day");
                $model->dueDate = date('Y-m-d', $dueDate);
            } else {
                $model->dueDate = date('Y-m-d', strtotime($model->dueDate));
            }


            $model->user_id = Yii::app()->user->id;
            $model->createdDtm = date("Y-m-d H:i:s");
            $model->status_id = 1; //New
            if ($model->save()) {
                $POPrefix = GlobalVars::get(GlobalVars::PURCHASE_ORDER_PREFIX);

                if ($startingNumber = GlobalVars::get(GlobalVars::PO_STARTING_NUMBER)) {
                    if (!$poNumber = GlobalVars::get(GlobalVars::PO_NEXT_NUMBER)) {
                        $poNumber = $startingNumber;
                    }
                    $compositePONumber = $POPrefix . '-' . str_pad($poNumber, 6, '0', STR_PAD_LEFT);
                    while (PurchaseOrders::model()->find("poNum = '{$compositePONumber}'")) {
                        $compositePONumber++;
                    }

                    $model->poNum = $compositePONumber;
                    $nextPONumber = ++$poNumber;
                    $sql = "UPDATE global_vars SET value = '$nextPONumber' WHERE globalVar = '" . GlobalVars::PO_NEXT_NUMBER . "'";
                    Yii::app()->db->createCommand($sql)->execute();
                } else {
                    $model->poNum = $POPrefix . '-' . str_pad($model->id, 6, '0', STR_PAD_LEFT);
                }
                $saved = $model->save(false);

                $jobDecoLineArr = $_POST['JobProductDecorations'];
                $slogdetails = "";
                foreach ($jobDecoLineArr as $workOrderDetailId => $decoArr) {

                    foreach ($decoArr as $key => $jpdId) {
                        $job_product_decoration = JobProductDecorations::model()->findByPk($jpdId);

                        $slogdetails .= !empty($job_product_decoration->workorderDtl->productsku) ? $job_product_decoration->workorderDtl->prdsrtdesc . " - {$job_product_decoration->getDecorationString()} x {$job_product_decoration->decoQty}," : $job_product_decoration->workorderDtl->custmproduct . " x {$job_product_decoration->decoQty},";


                        $podtl = new PurchaseOrderDetails();
                        $podtl->po_id = $model->id;
                        $podtl->workorderDtl_id = $job_product_decoration->workorderDtl->id;
                        $podtl->flowjob_id = $job_product_decoration->id;
                        $podtl->qty = $job_product_decoration->decoQty;

                        if ((int) SystemOptions::getOptions()->enbleXero && isset($_POST['Workorderdetails']['xero_account_id'])) { // Xero must be enable in system settings to be available this value
                            $podtl->xero_account_id = $_POST['Workorderdetails']['xero_account_id'][$job_product_decoration->id];
                        }

                        if ($podtl->save(false)) {

                            $job_product_decoration->dueDate = $model->dueDate;
                            $job_product_decoration->user_id = Yii::app()->user->id;
                            $job_product_decoration->status_id = 5; //PO Created                                
                            $job_product_decoration->po_id = $model->id;
                            $job_product_decoration->po_detail_id = $podtl->id;
                            if (!$job_product_decoration->save(false)) {
                                $saved = false;
                            }

                            $jobactivityflow = new JobActivityFlow();
                            $jobactivityflow->job_id = $model->job_id;
                            $jobactivityflow->wrkorder_id = $model->workorder_id;
                            $jobactivityflow->wrkorderDtl_id = $job_product_decoration->workorderDtl->id;
                            $jobactivityflow->flowjob_id = $job_product_decoration->id;
                            $jobactivityflow->type = 'Product-Decoration'; //All types - Product, Decoration ,Product-Decoration                            
                            $jobactivityflow->activity = 'PO Created';
                            if (!$jobactivityflow->save(false)) {
                                $saved = false;
                            }
                        } else {
                            $saved = false;
                        }
                    }
                }


                //save default PO flag options
                $model->setDefaultFlag();

                $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));
                if (!SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Purchase order ({$link}) is created for products-decoration ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate)) {
                    $saved = false;
                }
                if (!SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$link}) is created for products ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate)) {
                    $saved = false;
                }
            } else {
                $saved = false;
            }

            if ($saved) {
                $transaction->commit();
                $this->redirect(array('view', 'id' => $model->id));
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', $flashMessage);
                $jobProductMultiDecorationArr = json_decode(Yii::app()->session['deco_ids_of_job_decoration_create_po'], true);
                $this->render('create_product_multi_deco', array(
                    'model' => $model,
                    'jobProductMultiDecorationArr' => $jobProductMultiDecorationArr
                ));
            }
        } else {
            $this->redirect(array('jobs/view', 'id' => $_GET['jobId']));
        }
    }


    public function actionCreateOtherCostPO() {
        $flashMessage = "Cannot create purchase order!. Please try again!";
        if (!isset($_POST['PurchaseOrders']) && isset(Yii::app()->session['othercost_ids_of_job_othercost_create_po'])) {
            $jobId = $_GET['jobId'];
            $job = Jobs::model()->findByPk($jobId);
            $model = new PurchaseOrders();
            $model->job_id = $job->id;
            $model->workorder_id = $job->workorder_id;
            $model->quote_id = $job->quote_id;
            $model->quoteNum = $job->quoteNum;
            $model->poType = 'Purchase Product-OtherCost';

            $followupdate = strtotime("+6 day");
            $model->followupDate = date(GlobalVars::get("DateFormat"), $followupdate);

            $dueInXDays = GlobalVars::get("DueInXDays") ?: 14;
            $dueDate = strtotime("+$dueInXDays day");
            $model->dueDate = date(GlobalVars::get("DateFormat"), $dueDate);

            $jobProductMultiOtherCostArr = json_decode(Yii::app()->session['othercost_ids_of_job_othercost_create_po'], true);


            /**
             * Set Supplier
             */
            foreach ($jobProductMultiOtherCostArr as $workOrderDetailId => $otherCostArr) {
                foreach ($otherCostArr as $key => $jpocId) {
                    $jpoc = JobProductOtherCost::model()->findByPk($jpocId);
                    
                    /*
                    $workorderOtherCost = WorkorderOtherCost::model()->find("decprtnam = '$jpd->decprtnam'");
                    if ($workorderOtherCost && $workorderOtherCost->supplier) {

                        $model->supplier_id = $workorderOtherCost->supplier->supsno;
                        break;
                    }
                    */
                }
            }

            $this->render('create_product_multi_othercost', array(
                'model' => $model,
                'jobProductMultiOtherCostArr' => $jobProductMultiOtherCostArr
            ));
        } else if (isset($_POST['PurchaseOrders']) && isset($_POST['yt0']) && isset($_POST['JobProductOtherCost'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $saved = true;
            $model = new PurchaseOrders();
            $model->attributes = $_POST['PurchaseOrders'];

            if (!$model->supplier_id) {
                $flashMessage = "Supplier is required!";
                $saved = false;
            }



            if (empty($model->followupDate)) {
                $followupdate = strtotime("+6 day");
                $model->followupDate = date('Y-m-d', $followupdate);
            } else {
                $model->followupDate = date('Y-m-d', strtotime($model->followupDate));
            }

            if (empty($model->dueDate)) {
                $dueDate = strtotime("+10 day");
                $model->dueDate = date('Y-m-d', $dueDate);
            } else {
                $model->dueDate = date('Y-m-d', strtotime($model->dueDate));
            }


            $model->user_id = Yii::app()->user->id;
            $model->createdDtm = date("Y-m-d H:i:s");
            $model->status_id = 1; //New
            if ($model->save()) {
                $POPrefix = GlobalVars::get(GlobalVars::PURCHASE_ORDER_PREFIX);

                if ($startingNumber = GlobalVars::get(GlobalVars::PO_STARTING_NUMBER)) {
                    if (!$poNumber = GlobalVars::get(GlobalVars::PO_NEXT_NUMBER)) {
                        $poNumber = $startingNumber;
                    }
                    $compositePONumber = $POPrefix . '-' . str_pad($poNumber, 6, '0', STR_PAD_LEFT);
                    while (PurchaseOrders::model()->find("poNum = '{$compositePONumber}'")) {
                        $compositePONumber++;
                    }

                    $model->poNum = $compositePONumber;
                    $nextPONumber = ++$poNumber;
                    $sql = "UPDATE global_vars SET value = '$nextPONumber' WHERE globalVar = '" . GlobalVars::PO_NEXT_NUMBER . "'";
                    Yii::app()->db->createCommand($sql)->execute();
                } else {
                    $model->poNum = $POPrefix . '-' . str_pad($model->id, 6, '0', STR_PAD_LEFT);
                }
                $saved = $model->save(false);

                $jobOtherCostLineArr = $_POST['JobProductOtherCost'];
                $slogdetails = "";
                foreach ($jobOtherCostLineArr as $workOrderDetailId => $otherCostArr) {

                    foreach ($otherCostArr as $key => $jpocId) {
                        $job_product_othercost = JobProductOtherCost::model()->findByPk($jpocId);                       

                        $podtl = new PurchaseOrderDetails();
                        $podtl->po_id = $model->id;
                        $podtl->workorderDtl_id = $job_product_othercost->workorderDtl->id;
                        $podtl->flowjob_id = $job_product_othercost->id;
                        $podtl->qty = $job_product_othercost->quantity;

                         // Xero must be enable in system settings to be available this value
                        if ((int) SystemOptions::getOptions()->enbleXero && isset($_POST['Workorderdetails']['xero_account_id'])) {
                            $podtl->xero_account_id = $_POST['Workorderdetails']['xero_account_id'][$job_product_othercost->id];
                        }

                        if ($podtl->save(false)) {

                            
                            $job_product_othercost->status_id = 5; //PO Created                                
                            $job_product_othercost->po_id = $model->id;
                            $job_product_othercost->po_detail_id = $podtl->id;
                            if (!$job_product_othercost->save(false)) {
                                $saved = false;
                            }

                            $jobactivityflow = new JobActivityFlow();
                            $jobactivityflow->job_id = $model->job_id;
                            $jobactivityflow->wrkorder_id = $model->workorder_id;
                            $jobactivityflow->wrkorderDtl_id = $job_product_othercost->workorderDtl->id;
                            $jobactivityflow->flowjob_id = $job_product_othercost->id;
                            $jobactivityflow->type = 'Product-OtherCost'; //All types - Product, Decoration ,Product-Decoration, Product-OtherCost                            
                            $jobactivityflow->activity = 'PO Created';
                            if (!$jobactivityflow->save(false)) {
                                $saved = false;
                            }
                        } else {
                            $saved = false;
                        }
                    }
                }


                //save default PO flag options
                $model->setDefaultFlag();

                $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
                $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));
                if (!SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'Job', "Purchase order ({$link}) is created for products-decoration ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate)) {
                    $saved = false;
                }
                if (!SalesLog::createSalesLogWithFollowup($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$link}) is created for products ($slogdetails) and expected on {$model->dueDate}", 1, 1, 1, $model->followupDate)) {
                    $saved = false;
                }
            } else {
                $saved = false;
            }

            if ($saved) {
                $transaction->commit();
                $this->redirect(array('view', 'id' => $model->id));
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', $flashMessage);
                $jobProductMultiOtherCostArr = json_decode(Yii::app()->session['othercost_ids_of_job_othercost_create_po'], true);
                $this->render('create_product_multi_deco', array(
                    'model' => $model,
                    'jobProductMultiOtherCostArr' => $jobProductMultiOtherCostArr
                ));
            }
        } else {
            $this->redirect(array('jobs/view', 'id' => $_GET['jobId']));
        }
    }

    public function actionMYOBSyncronize() {

        $auth = new MYOBAuth(MyobSetting::getSettings());
        if ($auth->checkAccess()) {
            $id = (int) $_POST['id'];
            $model = $this->loadModel($id);


            /* check each product item and do the needfull for MYOB */

            foreach ($model->rel_po_dtl() as $detailRecord) {
                $product = $detailRecord->workorderDtl->product;

                $myobApiConnectorPrd = new MYOBApiConnector($auth);
                $synchronizerPrd = new MYOBSynchronizer($myobApiConnectorPrd, $product);
                $synchronizerPrd->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PUSH);
                $synchronizerPrd->setMYOBReferenceFinder(new MYOBItemReferenceFinder());
                $product->setSynchronizer($synchronizerPrd);
                $product->myobSynchronize($myobApiConnectorPrd);
            }

            $myobApiConnector = new MYOBApiConnector($auth);

            /* create syncronizer object which has the syncronizing logics */
            $synchronizer = new MYOBSynchronizer($myobApiConnector, $model);
            $synchronizer->setMYOBReferenceFinder(new MYOBPurchaseOrderReferenceFinder());
            /* we only push invoices to MYOB and just update the myob references of the local records */
            $synchronizer->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PUSH);
            $model->setSynchronizer($synchronizer);

            /* do syncorize */
            if ($model->myobSynchronize($myobApiConnector)) {
                echo json_encode(array('success' => true));
            } else {
                echo json_encode(array('success' => false));
            }
        }

        //$this->redirect(array('view', 'id' => $id));
    }

    /**
     * Invoices will only be pushed to MYOB! it won't sync into local from MYOB but update the MYOB references of the invoices
     * This action can be called by automatically ( as set in the settings) or manually
     * it will checks the invoices which doesn't have MYOB references and try to push them into MYOB
     */
    public function actionMYOBSyncronizeAll() {

        $auth = new MYOBAuth(MyobSetting::getSettings());

        if ($auth->checkAccess()) {

            $myobPOQueue = PurchaseOrders::model()->findAll(array('condition' => "myob_uuid IS NULL OR myob_uuid = ''", 'order' => 'id DESC', 'limit' => 100));


            $myobApiConnector = new MYOBApiConnector($auth);


            $totalTobeSync = count($myobPOQueue);
            $count = 0;
            foreach ($myobPOQueue as $model) {
                $count++;

                /* check each product item and do the needfull for MYOB */

                foreach ($model->rel_po_dtl() as $detailRecord) {
                    $product = $detailRecord->workorderDtl->product;

                    $myobApiConnectorPrd = new MYOBApiConnector($auth);
                    $synchronizerPrd = new MYOBSynchronizer($myobApiConnectorPrd, $product);
                    $synchronizerPrd->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PUSH);
                    $synchronizerPrd->setMYOBReferenceFinder(new MYOBItemReferenceFinder());
                    $product->setSynchronizer($synchronizerPrd);
                    $product->myobSynchronize($myobApiConnectorPrd);
                }

                /* create syncronizer object which has the syncronizing logics */
                $synchronizer = new MYOBSynchronizer($myobApiConnector, $model);

                $synchronizer->setMYOBReferenceFinder(new MYOBPurchaseOrderReferenceFinder());

                /* we only push invoices to MYOB and just update the myob references of the local records */
                $synchronizer->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PUSH);
                $model->setSynchronizer($synchronizer);

                /* do syncorize */
                $syncInfo = '';
                if ($model->myobSynchronize($myobApiConnector)) {
                    /* do something when success */
                }
                /* out put count streaming */
                echo $count . '/' . $totalTobeSync . '~'; /* "~" streaming seperator for the javascript spliting */
                echo str_pad('', 4096) . "\n";
                ob_flush();
                flush();
            }
        } else {
            throw new Exception('Access Denied!', 404);
        }

        //$this->redirect(array('view', 'id' => $id));
    }

    public function actionMyobQueue() {
        $model = new PurchaseOrders('searchMyobQueue');
        $model->unsetAttributes();
        if (isset($_GET['PurchaseOrders'])) {
            $model->attributes = $_GET['PurchaseOrders'];
        }


        $this->render('myob_queue', array(
            'model' => $model,
        ));
    }

    public function actionOnDateChange() {
        if (Yii::app()->request->isAjaxRequest) {
            $model = $this->loadModel(intval($_POST['id']));
            $attribute = $_POST['attribute'];
            $dateValue = $_POST['value'];
            $model->{$attribute} = date('Y-m-d', strtotime($dateValue));


            if ($model->save()) {

                SalesLog::createSalesLogTblId($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, $model->id, FollowupStatus::STATUS_TYPE_PURCHASE_ORDER, "{$attribute} of the PO [{$model->poNum}] is changed to [{$dateValue}]", 1, 1, 1);

                echo json_encode(array('success' => 1));
            } else {
                echo json_encode(array('success' => 0));
            }
        }
    }

    public function actionUpdatePurchaseOrderFlags() {
        $id = $_POST['id'];
        //whatever available here that means those attributes have been selected
        $flags = $_POST['flags'];

        $model = $this->loadModel($id);
        if (!$model->flag) {
            //save default PO flag options
            $model->setDefaultFlag();
        } else {
            //reset all flags to null
            foreach ($model->flag->attributes as $attr => $value) {
                //by pass id and po_id attribute and attributes which has no values
                if (!in_array($attr, array('id', 'po_id', 'po_type')) && $value) {
                    $model->flag->$attr = null;
                }
            }

            $model->flag->save();
        }
        //to populate new flag relation
        $model->refresh();
        //set new flags from the front-end updated options
        foreach ($flags as $attr) {

            $model->flag->$attr = 1;
        }

        if ($model->flag->save()) {
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => false));
        }
    }

    public function actionFetchPurchaseOrderFlags() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);

        $flags = array();

        if ($model->flag) {
            foreach ($model->flag->attributes as $attr => $value) {
                //by pass id and po_id attribute and attributes wich has no value
                if (!in_array($attr, array('id', 'po_id', 'po_type')) && $value) {
                    $flags[] = $attr;
                }
            }
        }



        echo json_encode(array('flags' => $flags));
    }
    
    public function actionXeroQueue() {

        $model = new PurchaseOrders('searchXeroQueue');
        $model->unsetAttributes();
        if (isset($_GET['Invoice'])) {
            $model->attributes = $_GET['Invoice'];
        }

        $this->render('xero_queue', array(
            'model' => $model,
        ));
    }

    public function actionToggleXeroQueue($id) {
        $model = $this->loadModel($id);

        $model->xero_in_queue = !$model->xero_in_queue;


        //if invoice is being revoked from the queue then also set the TO BE SENT  flag to false;
        if (!$model->xero_in_queue) {
            $model->xero_to_be_sent = 0;
        }

        $success = $model->save(false);

        $comment = '';
        $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
        $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));
        if ($model->xero_in_queue) {
            $comment = "Purchase order ({$link}) has been added to the Xero queue";
        } else {
            $comment = "Purchase order ({$link}) has been revoked from the Xero queue";
        }


        SalesLog::createSalesLogTblId(
                $model->quote_id, $model->job->workorder->id, $model->quoteNum, $model->id, 'PurchaseOrder', $comment, 1, 1, 1
        );

        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            echo json_encode(array('success' => $success));
        } else {
            $this->redirect(array('xeroQueue'));
        }
    }

    public function actionToggleXeroSync() {
        $id = $_POST['id'];
        $xeroSync = $_POST['xeroSync'];
        $model = $this->loadModel($id);


        $model->xero_to_be_sent = $xeroSync;

        $success = $model->save(false);

        $comment = '';
        $url = Yii::app()->createUrl('purchaseOrders/view', array("id" => $model->id));
        $link = CHtml::link($model->poNum, $url, array('target' => '_blank'));
        if ($model->xero_to_be_sent) {
            $comment = "Purchase order ({$link}) has been selected for the Xero sync";
        } else {
            $comment = "Purchase order ({$link}) has been revoked from the Xero sync";
        }


        SalesLog::createSalesLogTblId(
                $model->quote_id, $model->job->workorder->id, $model->quoteNum, $model->id, 'PurchaseOrder', $comment, 1, 1, 1
        );

        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            echo json_encode(array('success' => $success));
        } else {
            $this->redirect(array('myobQueue', 'id' => $model->id));
        }
    }

    public function actionXeroQueuePush() {
        $storage = new StorageClass();
        if ($storage->getHasExpired()) {            
            if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
                echo json_encode(array('success' => false, 'type' => 'auth'));
                exit();
            } else {
                Yii::app()->user->setFlash('success', "Authentication Error!");
                $this->redirect(array('xeroQueue'));
            }
        }

        // get $xeroTenantId 
        $storage = new StorageClass();
        $xeroTenantId = (string) $storage->getSession()['tenant_id'];

        //get xero api instance with required configs
        $xeroApiInstance = XeroAPI::getApiInstance();

        $purchaseOrdersToBeSynced = PurchaseOrders::model()->findAll(array('condition' => "xero_in_queue = 1 AND xero_to_be_sent = 1"));


        $messages = [];
        foreach ($purchaseOrdersToBeSynced as $purchaseOrder) {



            $xeroPurchaseOrderApi = new XeroPurchaseOrderApi($xeroApiInstance);
            if ($purchaseOrder->xeroPurchaseOrderID) {
                if (!$xeroPurchaseOrderApi->updateXero($purchaseOrder->xeroPurchaseOrderID, $xeroPurchaseOrderApi->getOrder($purchaseOrder))) {

                    $comment = "Purchase order [$purchaseOrder->poNum} uploading to Xero failed! [{$xeroPurchaseOrderApi->getErrorMessage()}]";
                    $messages[] = $comment;

                    SalesLog::createSalesLogTblId($purchaseOrder->quote_id, $purchaseOrder->job->workorder->id, $purchaseOrder->quoteNum, $purchaseOrder->job->id, 'Job', $comment, 1, 0, 1);
                    SalesLog::createSalesLogTblId($purchaseOrder->quote_id, $purchaseOrder->job->workorder->id, $purchaseOrder->quoteNum, $purchaseOrder->id, 'PurchaseOrder', $comment, 1, 0, 1);
                } else {
                    $purchaseOrder->xero_in_queue = null;
                    $purchaseOrder->xero_to_be_sent = null;
                    $purchaseOrder->save(false);
                }
            }

            if (!$purchaseOrder->xeroPurchaseOrderID) {
                $xeroPurchaseOrder = $xeroPurchaseOrderApi->getOrder($purchaseOrder);

                

                if ($purchaseOrder->xeroPurchaseOrderID = $xeroPurchaseOrderApi->createXero($xeroPurchaseOrder)) {

                    $purchaseOrder->xero_in_queue = null;
                    $purchaseOrder->xero_to_be_sent = null;
                    $purchaseOrder->save(false);

                    $comment = "PurchaseOrder [$purchaseOrder->poNum} has been pushed to Xero successfully!";
                    $messages[] = $comment;
                    SalesLog::createSalesLogTblId($purchaseOrder->quote_id, $purchaseOrder->job->workorder->id, $purchaseOrder->quoteNum, $purchaseOrder->job->id, 'Job', $comment, 1, 0, 1);
                    SalesLog::createSalesLogTblId($purchaseOrder->quote_id, $purchaseOrder->job->workorder->id, $purchaseOrder->quoteNum, $purchaseOrder->id, 'PurchaseOrder', $comment, 1, 0, 1);
                } else {                   
                    $comment = "PurchaseOrder [$purchaseOrder->poNum} uploading to Xero failed! [{$xeroPurchaseOrderApi->getErrorMessage()}]";
                    $messages[] = $comment;
                    SalesLog::createSalesLogTblId($purchaseOrder->quote_id, $purchaseOrder->job->workorder->id, $purchaseOrder->quoteNum, $purchaseOrder->job->id, 'Job', $comment, 1, 0, 1);
                    SalesLog::createSalesLogTblId($purchaseOrder->quote_id, $purchaseOrder->job->workorder->id, $purchaseOrder->quoteNum, $purchaseOrder->id, 'PurchaseOrder', $comment, 1, 0, 1);
                }
            }
        }



        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            echo json_encode(array('success' => true, 'messages' => $messages));
        } else {
            Yii::app()->user->setFlash('success', "Invoice bulk uploading has been done!");
            $this->redirect(array('xeroQueue'));
        }
    }

}
