<?php

class QuatationController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'getQuoteId', 'getUnitSellingPrice',
                    'processQuotations', 'ajaxFiledUpdate', 'updateQuoteName', 'updateQuoteComent',
                    'postquoteDetail', 'postquoteHeader', 'print', 'fetchTotalValues', 'updateQuoteField', 'checkWorkingQuote'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {

        $model = $this->loadModel($id);

        //cross checking and fixing the line total amount if mismatch
        $model->recalculateLineTotals();

        $quoteDetails = new QuatationDetails();
        $quoteDetails->quoteid = $model->id;

        if (!$model->is_viewed) {
            $model->is_viewed = 1;
            $model->first_viewed_by = Yii::app()->user->id;
            $model->save(false);
        }


        if (!Refiner::getdatetext($model->dueDate, GlobalVars::get("DateFormat"))) {

            $dueinXdays = GlobalVars::get(GlobalVars::DUE_IN_X_DAYS);
            $model->dueDate = date('Y-m-d', strtotime('+ ' . $dueinXdays . ' days'));

            $model->save(false);
        }


        if ($flupslog = $model->getFollowupSalesLog()) {
            $model->followupDate = $flupslog->followupDtm;
        }

        //set followup date

        if (!Refiner::getdatetext($model->followupDate, GlobalVars::get("DateFormat"))) {
            $followupXdays = GlobalVars::get(GlobalVars::FOLLOW_UP_IN_X_DAYS);
            $model->followupDate = date('Y-m-d', strtotime('+ ' . $followupXdays . ' days'));
            if ($flupslog) {
                $flupslog->followupDtm = $model->followupDate;
                $flupslog->save(false);
            }
        }

        //reset date formats for view calender 
        $model->dueDate = date(GlobalVars::get("DateFormat"), strtotime($model->dueDate));
        $model->followupDate = date(GlobalVars::get("DateFormat"), strtotime($model->followupDate));

        $this->render('view', array(
            'model' => $model,
            'quoteDetails' => $quoteDetails,
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public $avg_sysfreight;

    public function actionCreate() {



        $model = new Quatation;
        $quotedetails = null;
        $quotedecoration = null;
        $selectproducts = new ProductLine('searchForSelectPopup');
        $selectdeco = new Decoration('searchForSelectPopup');
        $selectcustomers = new Customer('search');
        $othercost = new OtherCostType();




        if (!isset($_POST['Quatation']) && !isset(Yii::app()->session['new_quote'])) {

            $model = new Quatation();
            $quotedetails = new QuatationDetails();
            $quotedecoration = new QuoteProductDecoration();

            $duedate = Refiner::getdatetext($model->dueDate, GlobalVars::get("DateFormat"));
            if (!$duedate) {
                $dueinXdays = GlobalVars::get(GlobalVars::DUE_IN_X_DAYS);
                $model->dueDate = date('Y-m-d', strtotime('+ ' . $dueinXdays . ' days'));

                $model->dueDate = date(GlobalVars::get("DateFormat"), strtotime($model->dueDate));
            } else {
                $model->dueDate = date(GlobalVars::get("DateFormat"), strtotime($model->dueDate));
            }


            //$model->systemfreight = 1.03;
            $model->quotecreatedby = Yii::app()->user->id;
            $model->quotecreated = date('Y-m-d H:i:s');
            $model->ws_date = date('Y-m-d H:i:s');
            if ($model->save()) {

                $model->quoteno = $model->generateQuoteNumber();

                $model->status = 1; //New
                $model->save();

                Yii::app()->session['new_quote'] = $model->id;
            }


            $user = User::model()->findByPk(Yii::app()->user->id);

            $url = Yii::app()->createUrl('quatation/view', array("id" => $model->id));
            $link = CHtml::link($model->quoteno, $url, array('target' => '_blank'));

            SalesLog::createSalesLog($model->id, null, $model->quoteno, 'Quotation', "New quote is created ({$link}) by {$user->username}", 0, 1, 1);
            //SalesLog::createCustomerLog($model->id, null, $model->quoteno, 'Quotation', "New quote is created ({$link}) by {$user->username}", 0, 1, 1);
        } else if (!isset($_POST['Quatation']) && isset(Yii::app()->session['new_quote'])) {
            $id = Yii::app()->session['new_quote'];
            $model = $this->loadModel($id);

            $duedate = Refiner::getdatetext($model->dueDate, GlobalVars::get("DateFormat"));
            if (!$duedate) {
                $dueinXdays = GlobalVars::get(GlobalVars::DUE_IN_X_DAYS);
                $model->dueDate = date('Y-m-d', strtotime('+ ' . $dueinXdays . ' days'));
                $model->save(false);
                $model->dueDate = date(GlobalVars::get("DateFormat"), strtotime($model->dueDate));
            }

            $quotedetails = new QuatationDetails();
            $quotedecoration = new QuoteProductDecoration();

            Yii::app()->session['try_new_quote'] += 1;
            Yii::app()->user->setFlash('notice', "Please save this quote before creating a new one!");
        }

        $selectproducts->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductLine']))
            $selectproducts->attributes = $_GET['ProductLine'];

        $selectdeco->unsetAttributes();  // clear any default values
        if (isset($_GET['Decoration']))
            $selectdeco->attributes = $_GET['Decoration'];

        $selectcustomers->unsetAttributes();  // clear any default values   
        if (isset($_GET['Customer']))
            $selectcustomers->attributes = $_GET['Customer'];

        $othercost->unsetAttributes();  // clear any default values   
        if (isset($_GET['OtherCostType']))
            $othercost->attributes = $_GET['OtherCostType'];

        if (isset($_POST['Customer'])) {
            $selectcustomers->attributes = $_POST['Customer'];
            $selectcustomers->save();
        }

        $selectQuoteDetails = new QuatationDetails('searchForSelectPopup');
        $selectQuoteDetails->unsetAttributes();  // clear any default values
        if (isset($_GET['QuatationDetails']))
            $selectQuoteDetails->attributes = $_GET['QuatationDetails'];

        //GWS API data fileter and provider
        $postFields = GwsProductApi::getDefaultPostFields();

        $gwsProductApiFilter = new GwsProductApiFilterForm;
        $gwsProductApiFilter->unsetAttributes();  // clear any default values
        if (isset($_GET['GwsProductApiFilterForm'])) {
            $gwsProductApiFilter->attributes = $_GET['GwsProductApiFilterForm'];
            // validate user input and redirect to the previous page if valid
            if ($gwsProductApiFilter->validate()) {
                $postFields['data'] = array(
                    'supplier' => $gwsProductApiFilter->supplier,
                    'product_code' => $gwsProductApiFilter->product_code,
                    'product_Name' => $gwsProductApiFilter->product_Name,
                    'category' => $gwsProductApiFilter->category
                );
            }
        }



        $gwsProductApiDataProvider = GwsProductApi::dataProvider($postFields);



        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (($_POST['Quatation']) && isset($_POST['quotedtfnsh'])) {
            $id = Yii::app()->session['new_quote'];
            $model = $this->loadModel($id);

            $duedate = Refiner::getdatetext($model->dueDate, GlobalVars::get("DateFormat"));
            if (!$duedate) {
                $dueinXdays = GlobalVars::get(GlobalVars::DUE_IN_X_DAYS);
                $model->dueDate = date('Y-m-d', strtotime('+ ' . $dueinXdays . ' days'));
                $model->save(false);
            }

            unset(Yii::app()->session['new_quote']);
            unset(Yii::app()->session['try_new_quote']);

            Yii::app()->user->setFlash('success', "Quotation [$model->quoteno] has been saved successfully!");
            $this->redirect(array('admin'));
        }

        $model->ws_user_id = Yii::app()->user->id;

        $this->render('create', array(
            'model' => $model,
            'quotedetails' => $quotedetails,
            'quotedecoration' => $quotedecoration,
            'selectproducts' => $selectproducts,
            'selectdeco' => $selectdeco,
            'selectcustomers' => $selectcustomers,
            'othercost' => $othercost,
            'selectQuoteDetails' => $selectQuoteDetails,
            'gwsProductApiFilter' => $gwsProductApiFilter,
            'gwsProductApiDataProvider' => $gwsProductApiDataProvider
        ));
    }

    public function actionProcessQuotations() {
        try {

            $webServiceClient = new WebServiceQuoteBuilderClient();
            $webServiceClient->processQuotations();

            $message = implode('<br>', $webServiceClient->getMessages());

            if ($message) {
                Yii::app()->user->setFlash('notice', $message);
            }
        } catch (Exception $ex) {
            Yii::app()->user->setFlash('notice', $ex->getMessage());
        }

        $this->redirect(array('admin'));
    }

    public function actionCreateCopy($id) {
        if (Yii::app()->request->isPostRequest) {
            $transaction = Yii::app()->db->beginTransaction();
            $allsaved = true;
            $originalQuote = $this->loadModel($id);
            $quoteCopy = new Quatation();
            $quoteCopy->setAttributes($originalQuote->attributes);
            unset($quoteCopy->id);
            unset($quoteCopy->quoteno);
            unset($quoteCopy->trap);

            $quoteCopy->systemfreight = 1.03;
            $quoteCopy->status = 1;
            $quoteCopy->quotecreatedby = Yii::app()->user->id;
            $quoteCopy->quotecreated = date('Y-m-d H:i:s');
            $quoteCopy->originalQuoteId = $originalQuote->id;
            if ($quoteCopy->save(false)) {

                $quoteCopy->quoteno = $quoteCopy->generateQuoteNumber();

                if (!$quoteCopy->save(false)) {
                    $allsaved = false;
                }
            } else {
                $allsaved = false;
            }

            if ($allsaved == true) {
                foreach ($originalQuote->RelDtls as $quoteProd) {
                    //copy product details
                    $quotedtlCopy = new QuatationDetails();
                    $quotedtlCopy->setAttributes($quoteProd->attributes);

                    unset($quotedtlCopy->id);
                    unset($quotedtlCopy->customer_accepted);

                    $quotedtlCopy->quoteid = $quoteCopy->id;
                    if (!$quotedtlCopy->save(false))
                        $allsaved = false;

                    //copy deco details
                    if ($allsaved == true && $multideco = $quoteProd->rel_multi_deco()) {
                        foreach ($multideco as $decorecord) {
                            $quoteDecoCopy = new QuoteProductDecoration();
                            $quoteDecoCopy->setAttributes($decorecord->attributes);
                            unset($quoteDecoCopy->id);
                            unset($quoteDecoCopy->quataiondetailsid);

                            $quoteDecoCopy->quoteid = $quoteCopy->id;
                            $quoteDecoCopy->quataiondetailsid = $quotedtlCopy->id;
                            if (!$quoteDecoCopy->save(false)) {
                                $allsaved = false;
                            }
                        }
                    }

                    //copy deco details
                    if ($allsaved == true && $otherCosts = $quoteProd->rel_other_costs()) {
                        foreach ($otherCosts as $costData) {
                            $costCopy = new QuoteOtherCost();
                            $costCopy->setAttributes($costData->attributes);
                            unset($costCopy->id);
                            unset($costCopy->quote_id);
                            unset($costCopy->quote_detail_id);

                            $costCopy->quote_id = $quoteCopy->id;
                            $costCopy->quote_detail_id = $quotedtlCopy->id;
                            if (!$costCopy->save(false)) {
                                $allsaved = false;
                            }
                        }
                    }
                }
            }

            if ($allsaved == true) {
                $transaction->commit();
                $url = Yii::app()->createUrl('quatation/view', array("id" => $quoteCopy->id));
                $link = CHtml::link($quoteCopy->quoteno, $url, array('target' => '_blank'));
                //$user = User::model()->findByPk($quoteCopy->quotecreatedby);
                SalesLog::createSalesLog($quoteCopy->id, null, $quoteCopy->quoteno, 'Quotation', "New quotation ({$link}) is created as a copy of the quote ({$originalQuote->quoteno})", 0, 1, 1);
                Yii::app()->user->setFlash('success', "New quotation ({$link}) has been successfully created as a copy of the quote ({$originalQuote->quoteno})");
                $this->redirect(array('admin'));
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', "Cannot create a copy from the quote({$originalQuote->quoteno}). Please try again!");

                $this->redirect(array('view', 'id' => $id));
            }
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        //cross checking and fixing the line total amount if mismatch
        $model->recalculateLineTotals();

        if (isset($model->customer)) {
            $model->cusnam = $model->customer->cusnam;
        }

        $othercost = new OtherCostType();
        $othercost->unsetAttributes();  // clear any default values
        if (isset($_GET['OtherCostType']))
            $othercost->attributes = $_GET['OtherCostType'];


        $quotedetails = new QuatationDetails();
        $quotedecoration = new QuoteProductDecoration();

        $selectproducts = new ProductLine('searchForSelectPopup');
        $selectproducts->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductLine']))
            $selectproducts->attributes = $_GET['ProductLine'];

        $selectdeco = new Decoration('searchForSelectPopup');
        $selectdeco->unsetAttributes();
        if (isset($_GET['Decoration']))
            $selectdeco->attributes = $_GET['Decoration'];
        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);
        $selectcustomers = new Customer('search');
        $selectcustomers->unsetAttributes();  // clear any default values   
        if (isset($_GET['Customer']))
            $selectcustomers->attributes = $_GET['Customer'];

        $selectQuoteDetails = new QuatationDetails('searchForSelectPopup');
        $selectQuoteDetails->unsetAttributes();  // clear any default values
        if (isset($_GET['QuatationDetails']))
            $selectQuoteDetails->attributes = $_GET['QuatationDetails'];

        if (isset($_POST['Customer'])) {
            $selectcustomers->attributes = $_POST['Customer'];
            $selectcustomers->save();
        }

        //GWS API data fileter and provider
        $postFields = GwsProductApi::getDefaultPostFields();

        $gwsProductApiFilter = new GwsProductApiFilterForm;
        $gwsProductApiFilter->unsetAttributes();  // clear any default values
        if (isset($_GET['GwsProductApiFilterForm'])) {
            $gwsProductApiFilter->attributes = $_GET['GwsProductApiFilterForm'];
            // validate user input and redirect to the previous page if valid
            if ($gwsProductApiFilter->validate()) {
                $postFields['data'] = array(
                    'supplier' => $gwsProductApiFilter->supplier,
                    'product_code' => $gwsProductApiFilter->product_code,
                    'product_Name' => $gwsProductApiFilter->product_Name,
                    'category' => $gwsProductApiFilter->category
                );
            }
        }



        $gwsProductApiDataProvider = GwsProductApi::dataProvider($postFields);



        if (isset($_POST['Quatation']) && !isset($_POST['quotedtfnsh'])) {
            $model->attributes = $_POST['Quatation'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        else if (($_POST['Quatation']) && isset($_POST['quotedtfnsh'])) {

            if (isset(Yii::app()->session['new_quote'])) {


                unset(Yii::app()->session['new_quote']);
                unset(Yii::app()->session['try_new_quote']);
            }


            Yii::app()->user->setFlash('success', "Quotation [$model->quoteno] has been saved successfully!");
            $this->redirect(array('admin'));
        }

        if (empty($model->ws_user_id)) {
            $model->ws_user_id = Yii::app()->user->id;
        }

        if (!$model->is_viewed) {
            $model->is_viewed = 1;
            $model->first_viewed_by = Yii::app()->user->id;
            $model->save(false);
        }

        $duedate = Refiner::getdatetext($model->dueDate, GlobalVars::get("DateFormat"));
        if (!$duedate) {
            $dueinXdays = GlobalVars::get(GlobalVars::DUE_IN_X_DAYS);
            $model->dueDate = date('Y-m-d', strtotime('+ ' . $dueinXdays . ' days'));
            $model->save(false);
            $model->dueDate = date(GlobalVars::get("DateFormat"), strtotime($model->dueDate));
        } else {
            $model->dueDate = date(GlobalVars::get("DateFormat"), strtotime($model->dueDate));
        }

        $this->render('update', array(
            'model' => $model,
            'model' => $model,
            'quotedetails' => $quotedetails,
            'quotedecoration' => $quotedecoration,
            'selectproducts' => $selectproducts,
            'selectdeco' => $selectdeco,
            'selectcustomers' => $selectcustomers,
            'othercost' => $othercost,
            'selectQuoteDetails' => $selectQuoteDetails,
            'gwsProductApiFilter' => $gwsProductApiFilter,
            'gwsProductApiDataProvider' => $gwsProductApiDataProvider
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);

            $workorders = Workorder::model()->findAll("quotationId = '$model->id'");
            if (count($workorders) == 0) {
                QuatationDetails::model()->deleteAll("quoteid = '$model->id'");
                QuoteProductDecoration::model()->deleteAll("quoteid = '$model->id'");
                $model->delete();
            }


            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    public function actionCancel($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);

            $workorders = Workorder::model()->findAll("quotationId = '$model->id' and status_id <> 3");
            if (count($workorders) == 0) {
                if (isset(Yii::app()->session['new_quote_id'])) {
                    if (Yii::app()->session['new_quote_id'] == $model->id) {
                        unset(Yii::app()->session['new_quote_id']);
                    }
                }
                $model->status = 3;
                if ($model->save(false)) {
                    Yii::app()->user->setFlash('success', "Quotation {$model->quoteno} has been successfully cancelled!");
                }
            } else {
                Yii::app()->user->setFlash('notice', "Cannot cancel the quotation {$model->quoteno}. There are sales order(s) that depends on this quotation");
            }


            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Quatation');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {

        if (isset(Yii::app()->session['new_quote_id'])) {
            $quotenum = Quatation::model()->findByPk(Yii::app()->session['new_quote_id'])->quoteno;
            Yii::app()->user->setFlash('notice', "Quotation {$quotenum} was not saved properly. Please finish the quote editing.");
        }

        $model = new Quatation('search');
        if (isset($_GET['Quatation'])) {
            $model->attributes = $_GET['Quatation'];
        }

        if (isset($_GET['dtrng']) && $_GET['dtrng'] == Quatation::FILTER_THIS_WEEK)
            $model->dateFilterType = Quatation::FILTER_THIS_WEEK;


        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Quatation::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'quatation-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionGetQuoteId() {
        if (Yii::app()->request->isPostRequest) {
            if (isset($_POST['productDetailID'])) {
                $product = QuatationDetails::model()->find(array('condition' => 'id=:ID', 'params' => array(':ID' => $_POST['productDetailID'])));
                $data = array();
                $data['quotationID'] = $product->quoteid;

                echo json_encode($data);
            }
        }
    }

    public function actionAjaxFiledUpdate() {

        $data = array();
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $compositeID = $_POST['id'];
            $idsplit = explode('_', $compositeID);
            $tableKey = $idsplit[1];
            $field = $_POST['field'];
            $value = $_POST['value'];
            try {

                $quote = $this->loadModel($tableKey);

                if (!empty($field) && !empty($tableKey) && !empty($value)) {
                    $affectedrows = Yii::app()->db
                            ->createCommand("UPDATE quatation SET {$field} = '{$value}' WHERE id = '{$tableKey}' LIMIT 1")
                            ->execute();

                    $data['success'] = $affectedrows > 0 ? true : false;
                    $url = Yii::app()->createUrl('quatation/view', array("id" => $tableKey));
                    $link = CHtml::link($quote->quoteno, $url, array('target' => '_blank'));
                    $slog = SalesLog::model()->find("quoteId = '{$tableKey}' and category = 'Quotation' and comments like '%Comments on ({$link}) are updated as%'");

                    if (!empty($slog)) {
                        $slog->comments = "Comments on ({$link}) are updated as \"{$value}\"";
                        $slog->save();
                    } else {

                        $quote = $this->loadModel($tableKey);
                        SalesLog::createSalesLog($tableKey, null, $quote->quoteno, 'Quotation', "Comments on ({$link}) are updated as \"{$value}\"", 0, 1, 1);
                    }
                } else {
                    $data['success'] = false;
                }
            } catch (Exception $e) {
                Yii::log($e->getMessage(), 'error', 'system.*');
            }
        } else {
            $data['success'] = false;
        }

        echo json_encode($data);
    }

    public function actionUpdateQuoteField() {
        $data = array();
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $id = $_POST['id'];
            $field = $_POST['field'];
            $value = $_POST['value'];

            $quote = $this->loadModel($id);



            /**
             * Save relation model values
             * look for relational join dot (.) which is come with $field attribute. Example : customer.cusnam
             * explode by dot .() will give model name and field name of the model
             * check if the main model (in this case quote) has the relation then save with the value
             * 
             */
            if (strpos($field, '.') !== false) {
                $fieldName = $field;
                $arr = explode('.', $field);
                if ($quote->{$arr[0]}) {
                    $quote->{$arr[0]}->{$arr[1]} = $value;
                    $saved = $quote->{$arr[0]}->save(false);
                }
            } else {

                if (in_array($field, array('cus_fref', 'cussno'))) {
                    $criteria = new CDbCriteria;

                    $criteria->addCondition("$field = '{$value}'");
                    $customer = Customer::model()->find($criteria);
                    if (!$customer) {
                        throw new Exception('Customer not found exception', 404);
                    }

                    //echo json_encode(array("customer $customer->cuscus_fref"));
                    //exit();
                    $quote->cus_fref = $customer->cuscus_fref;
                    $quote->shipAddress1 = $customer->shipAddress1;
                    $quote->shipAddress2 = $customer->shipAddress2;
                    $quote->shipAddress3 = $customer->shipAddress3;
                    $quote->shipSub = $customer->shipSub;
                    $quote->shipState = $customer->shipState;
                    $quote->shipPostalCode = $customer->shipPostalCode;

                    $saved = $quote->save();
                } elseif ($field == 'followupStatus') {

                    if ($quote->getFollowupStatusId() != $value) {
                        //add crm status
                        $salesLog = new SalesLog();
                        $salesLog->quoteId = $quote->id;
                        $salesLog->quoteNum = $quote->quoteno;
                        $salesLog->category = 'Quotation';


                        $salesLog->tbl_id = $quote->id;
                        $salesLog->followupSts_id = $value;
                        if ($salesLog->save(false)) {
                            $saved = true;
                            $value = FollowupStatus::model()->findByPk($value)->status;
                        }
                    }
                } else if ($field == 'dueDate') {
                    //don't sync SO or Job with quote due date, because of there might have more than one SO and Jobs for a particular quote
                    $formateddate = date('Y-m-d', strtotime($value));
                    $saved = Quatation::model()->updateByPk($id, array(
                        "$field" => $formateddate
                    ));
                } else {


                    $saved = Quatation::model()->updateByPk($id, array(
                        "$field" => $value
                    ));
                }

                if ($field == 'ws_user_id') {

                    $salesperson = SalesPerson::model()->findByPk($value);
                    if (!empty($salesperson)) {
                        $field = 'ws_user';
                        $value = $salesperson->name;
                    } else {
                        $value = '';
                    }
                    $saved = Quatation::model()->updateByPk($id, array(
                        "$field" => $value
                    ));
                }

                $quote2 = new Quatation();
                $attrLabels = $quote2->attributeLabels();
                $fieldName = $attrLabels[$field];
            }

            if ($saved) {
                $url = Yii::app()->createUrl('quatation/view', array("id" => $quote->id));
                $link = CHtml::link($quote->quoteno, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($id, null, $quote->quoteno, 'Quotation', "Quotation ({$link}) {$fieldName} is updated as \"{$value}\"", 0, 1, 1);
                $data['success'] = true;
            } else {
                $data['success'] = false;
            }
        }

        echo json_encode($data);
    }

    public function actionUpdateQuoteName() {
        $data = array();
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $id = $_POST['id'];
            $quotename = $_POST['value'];

            $model = Quatation::model()->findByPk($id);
            $model->quotename = $quotename;
            if ($model->save()) {
                $url = Yii::app()->createUrl('quatation/view', array("id" => $model->id));
                $link = CHtml::link($model->quoteno, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($id, null, $model->quoteno, 'Quotation', "Quotation ({$link}) name is updated as \"{$quotename}\"", 0, 1, 1);
                $data['success'] = true;
            } else {
                $data['success'] = false;
            }
        }

        echo json_encode($data);
    }

    public function actionUpdateQuoteComent() {
        $data = array();
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $id = $_POST['id'];
            $comment = $_POST['value'];

            $model = Quatation::model()->findByPk($id);
            $model->quotecomments = $comment;
            if ($model->save()) {
                $url = Yii::app()->createUrl('quatation/view', array("id" => $model->id));
                $link = CHtml::link($model->quoteno, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($id, null, $model->quoteno, 'Quotation', "Quotation ({$link}) comments are updated as \"{$comment}\"", 0, 1, 1);
                $data['success'] = true;
            } else {
                $data['success'] = false;
            }
        }

        echo json_encode($data);
    }

    public function actionPostquoteHeader() {
        if (Yii::app()->request->isAjaxRequest) {
            $model = $this->loadModel($_POST['Quatation']['id']);
            $model->attributes = $_POST['Quatation'];
            if (!empty($model->ws_user_id)) {
                $user = User::model()->findByPk($model->ws_user_id);
                $model->ws_user = $user->username;
            }

            if ($model->save()) {
                if (!empty($model->customer)) {
                    $url = Yii::app()->createUrl('quatation/view', array("id" => $model->id));
                    $link = CHtml::link($model->quoteno, $url, array('target' => '_blank'));
                    $slog = SalesLog::model()->find(array('condition' => "comments = 'New Quotation ($link) is created' and tbl_id = '{$model->customer->cussno}'"));
                    if (empty($slog)) {
                        SalesLog::createCustomerLog($model->customer->cussno, 'Customer', "New Quotation ($link) is created");
                    }
                }

                echo 'success';
            } else {
                throw new CHttpException(400, 'Cannot update the quotation model.');
            }
        }
    }

    public function actionPostquoteDetail() {

        if (Yii::app()->request->isAjaxRequest) {

            $quoteDetialBuilder = new OnlineQuoteDetailBuilder();

            $quoteDetialBuilder->setDetail($_POST);

            $uploadImageFile = CUploadedFile::getInstance(new QuatationDetails(), 'productimg');
            if ($uploadImageFile) {
                $quoteDetialBuilder->setImage($uploadImageFile, '');
            }



            $othercosts = isset($_POST['othercost']) ? $_POST['othercost'] : null;
            $othercostIds = isset($_POST['othercostid']) ? $_POST['othercostid'] : null;

            if ($othercosts && count($othercosts) > 0) {

                foreach ($othercosts as $key => $value) {
                    $othercostId = $othercostIds[$key];

                    $quoteDetialBuilder->setOtherCost(array('other_cost_id' => $othercostId, 'cost' => $value));
                }
            }


            if (isset($_POST['QuoteProductDecoration'])) {
                $addNewLineArr = $_POST['QuoteProductDecoration'];
                foreach ($addNewLineArr as $key => $value) {

                    $quoteDetialBuilder->setDecoration($value);
                }
            }

            $orderDetail = $quoteDetialBuilder->build();
            $quotedetail = $orderDetail->getDetail();
            echo $quotedetail->getHtmlRow();
        }
    }

    private function getHtmlRow($record) {
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        $alldetails = QuatationDetails::model()->findAll(array('condition' => "quoteid = '{$record->quoteid}'"));
        $quotedecodetail = QuoteProductDecoration::model()->find(array('condition' => "quataiondetailsid = '{$record->id}'"));
        //$decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $quotedecodetail->decprtnam)));

        $count = count($alldetails);
        //$rowtype = $count % 2;

        $html .= '<tr  id="quote_row_' . $record->id . '" >';

        $html .= '<td class="maincell">';
        $html .= '<table class="maintbl">';
        $html .= '<tr  id="mainrow_' . $record->id . '" >';
        $html .= ' <td class="counter"><div class="counter-no">'
                . '<input value="' . intval($record->lineOrder) . '" type="text" name="QuatationDetails[lineOrder]" id="detail-line-order-row-' . $record->id . '" style="width: 15px;" onchange="updateDetailField(\'' . $record->id . '\', \'lineOrder\', this.value);"/>'
                . '</div>'
                . '<input class="quote-line-select" detail-id="' . $record->id . '" type="checkbox" id="detail_select_row_' . $record->id . '"  />'
                . '</td>';
        $html .= '<td class="column2">';
        $html .= CHtml::image($record->getImg(), '', array('width' => 75, 'height' => 75, 'id' => 'imgid-' . $record->id, 'class' => 'quote-dtl-img', 'style' => 'cursor: pointer;', 'title' => 'click to change the image'));
        $html .= '<form style="display: none;" name="photo" id="imageUploadForm" enctype="multipart/form-data"  method="post">
                        <input type="file" style="widows:0; height:0;" class="ImageBrowse" hidden="hidden" name="QuatationDetails[productimg]" />  
                        <input type="text"  hidden="hidden" name="QuatationDetails[id]" value="' . $record->id . '" />  
                    </form>';
        $html .= ' </td>';
        $html .= ' <td class="column2">';




        if (!empty($record->productsku) && !empty($record->productRel)) {
            $html .= CHtml::link($record->productsku, array("productLine/view", "id" => $record->productRel->pdlsno), array("target" => "_blank", 'title' => "click here to see full product spec"));
        } else {
            echo '<br>';
        }


        $html .= '<textarea style="width: 95%;" id="productname_' . $record->id . '" name="QuatationDetails[productname]" onchange="updateDetailField(' . $record->id . ', \'productname\', this.value);">';
        $html .= $record->productname;
        $html .= "</textarea>";





        $html .= ' </td>';
        $html .= '<td class="column3">';


        $html .= '<br><textarea style="width: 95%;" id="productdescription_' . $record->id . '" name="QuatationDetails[productdescription]" onchange="updateDetailField(' . $record->id . ', \'productdescription\', this.value);">';
        $html .= $record->productdescription;
        $html .= '</textarea>';


        $html .= '</td>';
        $html .= '<td class="column4">';



        $html .= '<div id="multideco_' . $record->id . '">';
        $html .= $record->getMultiDecoHtml();
        $html .= '</div>';
        $html .= '<a href="#" style="width: 95%;"   data-toggle="modal" onclick="showEditMultiDecoModal(' . $record->id . ');return false;">Edit Decorations</a>';





        $html .= '</td>';
        $html .= '<td style="width:10%;">';
        $html .= '<br><input style="width: 95%;text-align:center;" type="text" value="' . $record->qty . '" id="qty_' . $record->id . '" name="QuatationDetails[qty]"  onchange="calLinePrices(' . $record->id . ');"/>';
        $html .= '</td>';

        $html .= '<td style="width:12%;">';

        $html .= '<a href="#" style="width: 95%;" data-toggle="modal" onclick="showEditPriceModal(' . $record->id . ');return false;">Edit Price</a>';
        $html .= '<input style="width: 95%;text-align:right;" type="text" value="' . round($record->sellunitprice_ex_vat, $roundingPrecision) . '" id="sellunitpriceExVat_' . $record->id . '" readonly="readonly"/>';


        $html .= '</td>';
        $html .= '<td style="width:10%;">';
        $html .= '<br><input style="width: 95%;text-align:right;" type="text" value="' . (round($record->sellunitprice_ex_vat, $roundingPrecision) * $record->qty) . '" id="selltotExVat_' . $record->id . '"  readonly="readonly"/>';


        $html .= '</td>  ';

        $html .= '</tr>';

        $html .= '<tr>';
        $html .= '<td colspan="4"><table>';

        $html .= '<tr style="background-color: #EDEDED;"> <td>Custom Colour</td></tr>';

        $html .= '<tr> <td>';
        $html .= '<input 
                                    style="width: 95%;text-align: left;" 
                                    type="text" value="' . $record->customColor . '" 
                                    id="customColor_' . $record->id . '"
                                    onchange="updateDetailField(' . $record->id . ', \'customColor\', this.value);" />';


        $html .= '</td></tr>';

        $html .= '</table>';
        $html .= '</td>';
        $html .= '<td colspan="4">';
        $html .= '<table><tr style="background-color: #EDEDED;"> <td>Custom Note</td>';
        $html .= '</tr>';
        $html .= '<tr><td><input 
                                    style="width: 95%;text-align: left;" 
                                    type="text" value="' . $record->customNote . '" 
                                    id="customNote_' . $record->id . '"
                                    onchange="updateDetailField(' . $record->id . ', \'customNote\', this.value);" /></td>';
        $html .= '</tr>';
        $html .= '</table>';
        $html .= '</td>';
        $html .= '</tr>';

        $html .= '</table>';
        $html .= '<div id="savemessage_' . $record->id . '"  style="color: rgb(0, 255, 0);display: none;">Changes are saved</div>';
        $html .= '</td>';

        $html .= '</tr>';

        return $html;
    }

    public function actionPrint($id) {
        $total_details = isset($_GET['totaldetails']) == true ? $_GET['totaldetails'] : 0;

        $showProdCode = isset($_GET['showProdCode']) ? $_GET['showProdCode'] : 0;
        $incGST = isset($_GET['incGST']) ? $_GET['incGST'] : 0;
        $withGrp = isset($_GET['withGrp']) ? $_GET['withGrp'] : 0;

        $model = $this->loadModel($id);



//        if (in_array($model->status_id, array(2, 6)) == true) {
//            $sotype = 'ORDER CONFIRMATION';
//        }
        $url = Yii::app()->createUrl('quatation/view', array("id" => $model->id));
        $link = CHtml::link($model->quoteno, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'Quotation ({$link}) is printed'");

        if (empty($slog)) {

            SalesLog::createSalesLog($model->id, $model->id, $model->quoteno, 'Quotation', "Quotation ({$link}) is printed", 1, 1, 1);
        }

        $htmlcontent = $this->renderInternal('protected/views/quatation/quotePdf_html.php', array(
            'model' => $model,
             'total_details' => $total_details,
             'showProdCode' => $showProdCode,
                'incGST' => $incGST,
                'withGrp' => $withGrp  
            ), true);

        /**
         * Client class to print quote pdf
         */
        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);        

        $mpdf = new MpsQuotePdf;
        $mpdf->setMode(MpsPdf::MODE_CONTENT_GENERATOR)
        ->setModel($model)
        ->generate( $htmlcontent)
        ->output("{$sitePrefix}_Quotation_{$model->quoteno}");
    }

    public function actionFetchTotalValues() {
        if (isset($_POST) && $_POST['id'] > 0) {
            $id = $_POST['id'];
            $model = $this->loadModel($id);
            $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
            $subTotal = PriceCalculator::getSubTotal($model);
            $gstTotal = GGCalculator::truncate_number(PriceCalculator::getGSTTotal($model), $roundingPrecision);

            $formatSubTotal = number_format($subTotal, $roundingPrecision);
            $formatGSTTotal = number_format($gstTotal, $roundingPrecision);
            $formattTotal = number_format(($subTotal + $gstTotal), $roundingPrecision);

            $totamtarr = array();
            $totamtarr['subTotal'] = $formatSubTotal;
            $totamtarr['gstTotal'] = $formatGSTTotal;
            $totamtarr['total'] = $formattTotal;

            echo json_encode($totamtarr);
        }
    }

    public function actionCheckWorkingQuote() {

        if (isset($_POST['CHECK_QUOTE'])) {
            $arr = array();
            if (isset(Yii::app()->session['new_quote_id'])) {
                $arr['has_quote'] = true;
            } else {
                $arr['has_quote'] = false;
            }
            echo json_encode($arr);
        } else {
            throw new CHttpException(404, 'Error in check for working quotation');
        }
    }

    public function actionStatusReport() {


        $model = new Quatation('searchStatus');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Quatation']))
            $model->attributes = $_GET['Quatation'];

        if (isset($_POST['reset_btn'])) {
            unset(Yii::app()->session['quote_sts_selcted']);
            unset(Yii::app()->session['quote_sts_datefrom']);
            unset(Yii::app()->session['quote_sts_dateto']);
        }

        if (isset($_POST['Quatation']) && isset($_POST['Quatation']['followupStatus']) && isset($_POST['go_btn'])) {
            $postStatusesArr = $_POST['Quatation']['followupStatus'];
            Yii::app()->session['quote_sts_selcted'] = implode(',', $postStatusesArr);
        }

        if (isset($_POST['Quatation']['datefrom']) && !empty($_POST['Quatation']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['quote_sts_datefrom'] = date('Y-m-d', strtotime($_POST['Quatation']['datefrom']));
        }

        if (isset(Yii::app()->session['quote_sts_datefrom'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['quote_sts_datefrom']));
        }



        if (isset($_POST['Quatation']['dateto']) && !empty($_POST['Quatation']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['quote_sts_dateto'] = date('Y-m-d', strtotime($_POST['Quatation']['dateto']));
        }

        if (isset(Yii::app()->session['quote_sts_dateto'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['quote_sts_dateto']));
        }




        $this->render('statusReport', array(
            'model' => $model,
        ));
    }

    public function actionGenerateStatusExcel() {
        if (isset(Yii::app()->session['quote_sts_qry'])) {
            $query = Yii::app()->session['quote_sts_qry'];
            $query .= ' order by ws_date DESC';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('statusReport'));
        }

        $reportName = "Quotation Status Report";
        Yii::import('ext.phpexcel.XPHPExcel');
        $objPHPExcel = XPHPExcel::createPHPExcel();
        $objPHPExcel->getProperties()->setCreator(Yii::app()->name)
                ->setLastModifiedBy(Yii::app()->name)
                ->setTitle($reportName)
                ->setSubject($reportName)
                ->setDescription($reportName)
                ->setKeywords($reportName)
                ->setCategory($reportName);

        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('E3', Yii::app()->name)
                ->setCellValue('E4', Yii::app()->name . " - " . $reportName)
                ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

        $column = array();

        //if(Yii::app()->session['invr_imageFlag'] == 1)
        $column['A'] = 'No';
        $column['B'] = 'Date';
        $column['C'] = 'Quotation Number';
        $column['D'] = 'Quotation Name';
        $column['E'] = 'Master Customer';
        $column['F'] = 'Customer';
        $column['G'] = 'Comments';
        $column['H'] = 'Sales Person';
        $column['I'] = 'Follow-up Status';


        foreach ($column as $key => $val) {
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '9', $val);
        }

        $sheet = $objPHPExcel->getActiveSheet();


        foreach ($column as $key => $val) {
            $sheet->getColumnDimension($key)->setAutoSize(true);
        }

        $sheet->mergeCells("E3:F3");
        $sheet->mergeCells("E4:F4");
        $sheet->mergeCells("E5:F5");
        $sheet->mergeCells("E6:F6");

        $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
        $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));

        $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
        $sheet->getStyle("A9:I9")->applyFromArray(array("font" => array("bold" => true)));

        $row = 11;
        $count = 1;
        foreach ($rawData as $item) {
            $quote = $this->loadModel($item['id']);
            $mastercus = '';
            $customer = '';
            if (!empty($quote->customer)) {
                $customer = $quote->customer->cusnam;
                if (!empty($quote->customer->master)) {
                    $mastercus = $quote->customer->master->mcusnam;
                }
            }

            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $row, $count)
                    ->setCellValue('B' . $row, date(GlobalVars::get("DateFormat"), strtotime($item['ws_date'])))
                    ->setCellValue('C' . $row, $item['quoteno'])
                    ->setCellValue('D' . $row, $item['quotename'])
                    ->setCellValue('E' . $row, $mastercus)
                    ->setCellValue('F' . $row, $customer)
                    ->setCellValue('G' . $row, $item['quotecomments'])
                    ->setCellValue('H' . $row, $item['ws_user'])
                    ->setCellValue('I' . $row, $quote->getFollowupStatus());


            $row++;
            $count++;
        }

        // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        header('Content-Disposition: attachment;filename="'.$sitePrefix.'_QuoteStatusReport_' . date('dmY') . '.xls"');
        header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        Yii::app()->end();
    }

    public function actionGenerateStatusPDF() {
        if (isset(Yii::app()->session['quote_sts_qry'])) {
            $query = Yii::app()->session['quote_sts_qry'];
            $query .= ' order by ws_date DESC';

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData))
                $this->redirect(array('statusReport'));

            $htmlcontent = $this->renderInternal('protected/views/quatation/quote_status_report_html.php', array('rawData' => $rawData), true);



            $pdfCreator = new CommonPDFCreator(array(
                'title' => 'Quotation Status Report',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => "MPVS2_QuotationStatusReport_" . date('dmY') . ".pdf"
            ));

            $pdfCreator->generate();
        }
    }

    public function actionSalesperson() {
        //print_r($_POST);
        $model = new Quatation('searchSperson');
        $model->unsetAttributes();  // clear any default values
        $model->spersonDateFlag = 1;
        if (isset($_GET['Quatation']))
            $model->attributes = $_GET['Quatation'];

        if (isset($_POST['reset_btn'])) {

            unset(Yii::app()->session['sperson_selcted']);
            unset(Yii::app()->session['sperson_datefrom']);
            unset(Yii::app()->session['sperson_dateto']);
            unset(Yii::app()->session['sperson_date_type_flag']);
            unset(Yii::app()->session['sperson_query']);
        }

        if (isset($_POST['Quatation']) && isset($_POST['go_btn'])) {
            if (isset($_POST['Quatation']['ws_user_id'])) {
                $postSPersonsArr = $_POST['Quatation']['ws_user_id'];

                Yii::app()->session['sperson_selcted'] = implode(',', $postSPersonsArr);
                // Yii::app()->session['sperson_selcted'] = $_POST['Quatation']['ws_user_id'];
            }


            if (isset($_POST['Quatation']['spersonDateFlag'])) {
                Yii::app()->session['sperson_date_type_flag'] = $_POST['Quatation']['spersonDateFlag'];
            }
        }


        if (isset($_POST['Quatation']['datefrom']) && !empty($_POST['Quatation']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['sperson_datefrom'] = date('Y-m-d', strtotime($_POST['Quatation']['datefrom']));
        }

        if (isset(Yii::app()->session['sperson_datefrom'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['sperson_datefrom']));
        }

        if (isset($_POST['Quatation']['dateto']) && !empty($_POST['Quatation']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['sperson_dateto'] = date('Y-m-d', strtotime($_POST['Quatation']['dateto']));
        }

        if (isset(Yii::app()->session['sperson_dateto'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['sperson_dateto']));
        }


        if (isset(Yii::app()->session['sperson_date_type_flag'])) {
            $model->spersonDateFlag = Yii::app()->session['sperson_date_type_flag'];
        }

        if (isset(Yii::app()->session['sperson_selcted'])) {
            $model->ws_user_id = Yii::app()->session['sperson_selcted'];
        }


        $this->render('quote_by_saleperson', array(
            'model' => $model,
        ));
    }

    public function actionSalespersonV2() {
        //print_r($_POST);
        $model = new Quatation('searchSpersonV2');
        $model->unsetAttributes();  // clear any default values
        $model->spersonDateFlag = 1;
        if (isset($_GET['Quatation']))
            $model->attributes = $_GET['Quatation'];

        if (isset($_POST['reset_btn'])) {

            unset(Yii::app()->session['sperson_sts_selcted']);
            unset(Yii::app()->session['sperson_selcted_v2']);
            unset(Yii::app()->session['sperson_datefrom_v2']);
            unset(Yii::app()->session['sperson_dateto_v2']);
            unset(Yii::app()->session['sperson_date_type_flag_v2']);
            unset(Yii::app()->session['sperson_query_v2']);
        }

        if (isset($_POST['Quatation']) && isset($_POST['go_btn'])) {
            if (isset($_POST['Quatation']['ws_user_id'])) {
                $postSPersonsArr = $_POST['Quatation']['ws_user_id'];

                Yii::app()->session['sperson_selcted_v2'] = implode(',', $postSPersonsArr);
                // Yii::app()->session['sperson_selcted'] = $_POST['Quatation']['ws_user_id'];
            }

            if (isset($_POST['Quatation']['followupStatus'])) {
                $postStatusArr = $_POST['Quatation']['followupStatus'];

                Yii::app()->session['sperson_sts_selcted'] = implode(',', $postStatusArr);
                // Yii::app()->session['sperson_selcted'] = $_POST['Quatation']['ws_user_id'];
            }


            if (isset($_POST['Quatation']['spersonDateFlag'])) {
                Yii::app()->session['sperson_date_type_flag_v2'] = $_POST['Quatation']['spersonDateFlag'];
            }
        }


        if (isset($_POST['Quatation']['datefrom']) && !empty($_POST['Quatation']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['sperson_datefrom_v2'] = date('Y-m-d', strtotime($_POST['Quatation']['datefrom']));
        }

        if (isset(Yii::app()->session['sperson_datefrom_v2'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['sperson_datefrom_v2']));
        }

        if (isset($_POST['Quatation']['dateto']) && !empty($_POST['Quatation']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['sperson_dateto_v2'] = date('Y-m-d', strtotime($_POST['Quatation']['dateto']));
        }

        if (isset(Yii::app()->session['sperson_dateto_v2'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['sperson_dateto_v2']));
        }


        if (isset(Yii::app()->session['sperson_date_type_flag_v2'])) {
            $model->spersonDateFlag = Yii::app()->session['sperson_date_type_flag_v2'];
        }

        if (isset(Yii::app()->session['sperson_selcted_v2'])) {
            $model->ws_user_id = Yii::app()->session['sperson_selcted_v2'];
        }


        $this->render('quote_by_saleperson_v2', array(
            'model' => $model,
        ));
    }

    public function actionPrintSalespersonPDF() {
        if (isset(Yii::app()->session['sperson_query'])) {

            $query = Yii::app()->session['sperson_query'];

            $rawData = Yii::app()->db->createCommand($query)->queryAll();

            if (empty($rawData)) {
                $this->redirect(array('salesperson'));
            }

            $priceClmFlag = isset($_GET['priceClmFlag']) ? $_GET['priceClmFlag'] : 'price';

            $htmlcontent = $this->renderInternal('protected/views/quatation/sperson_quote_html.php', array('rawData' => $rawData), true);

            $timestamp = time();
            $pdfCreator = new DefalutHeaderPDFCreator(array(
                'title' => 'Quotes By Salespersons',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO} / {nb}',
                'outputFileName' => "Quotes_By_Salespersons{$timestamp}.pdf"
            ));

            $pdfCreator->generate();
        }
    }

    public function actionPrintSalespersonPDFV2() {
        if (isset(Yii::app()->session['sperson_query_v2'])) {

            $query = Yii::app()->session['sperson_query_v2'];

            $rawData = Yii::app()->db->createCommand($query)->queryAll();

            if (empty($rawData)) {
                $this->redirect(array('salespersonV2'));
            }

            /**
             * Init flags
             */
            $priceClmFlag = isset($_GET['priceClmFlag']) ? $_GET['priceClmFlag'] : 'price';




            $htmlcontent = $this->renderInternal('protected/views/quatation/sperson_quote_html_v2.php', array('rawData' => $rawData), true);


            $timestamp = time();
            $pdfCreator = new DefalutHeaderPDFCreator(array(
                'title' => 'Quotes By Salespersons',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO} / {nb}',
                'outputFileName' => "Quotes_By_SalespersonsV2{$timestamp}.pdf"
            ));

            $pdfCreator->generate();
        }
    }

    public function actionSalespersonExcelV2() {
        if (isset(Yii::app()->session['sperson_query_v2'])) {
            $query = Yii::app()->session['sperson_query_v2'];

            $rawData = Yii::app()->db->createCommand($query)->queryAll();
            if (empty($rawData)) {
                $this->redirect(array('salespersonV2'));
            }

            $priceClmFlag = isset($_GET['priceClmFlag']) ? $_GET['priceClmFlag'] : 'price';



            $reportName = "Quotation Status Report V2";
            Yii::import('ext.phpexcel.XPHPExcel');
            $objPHPExcel = XPHPExcel::createPHPExcel();
            $objPHPExcel->getProperties()->setCreator(Yii::app()->name)
                    ->setLastModifiedBy(Yii::app()->name)
                    ->setTitle($reportName)
                    ->setSubject($reportName)
                    ->setDescription($reportName)
                    ->setKeywords($reportName)
                    ->setCategory($reportName);

            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('E3', Yii::app()->name)
                    ->setCellValue('E4', Yii::app()->name . " - " . $reportName)
                    ->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));


            $priceClmName = "Quote Price";
            if ($priceClmFlag == 'estimate') {
                $priceClmName = "Sales Estimate";
            }

            $column = array();

            //if(Yii::app()->session['invr_imageFlag'] == 1)
            $column['A'] = 'Sales Person';
            $column['B'] = 'Created Date';
            $column['C'] = 'Quote #';
            $column['D'] = $priceClmName;
            $column['E'] = 'Customer';
            $column['F'] = 'Follow-up Status';
            $column['G'] = 'Due Date';



            foreach ($column as $key => $val) {
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '9', $val);
            }

            $sheet = $objPHPExcel->getActiveSheet();


            foreach ($column as $key => $val) {
                $sheet->getColumnDimension($key)->setAutoSize(true);
            }

            $sheet->mergeCells("E3:F3");
            $sheet->mergeCells("E4:F4");
            $sheet->mergeCells("E5:F5");
            $sheet->mergeCells("E6:F6");

            $sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
            $sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));

            $sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
            $sheet->getStyle("A9:G9")->applyFromArray(array("font" => array("bold" => true)));

            $salesPersonArray = array();

            foreach ($rawData as $item) {

                if (empty($item['ws_user_id'])) {
                    $item['ws_user_id'] = 'x';
                }
                if (array_key_exists($item['ws_user_id'], $salesPersonArray)) {
                    $salesPersonArray[$item['ws_user_id']] += 1;
                } else {
                    $salesPersonArray[$item['ws_user_id']] = 1;
                }
            }


            $row = 11;
            $count = 1;
            $allTotalExGST = 0;
            $lineCount = 0;
            foreach ($salesPersonArray as $key => $value) {
                $lineCount += 1;
                $mergecount = 0;
                $subjobtotal = 0;

                foreach ($rawData as $item) {
                    if (empty($item['ws_user_id'])) {
                        $item['ws_user_id'] = 'x';
                    }
                    if ($key == $item['ws_user_id']) {
                        $count += 1;


                        $count += 1;
                        $quote = $this->loadModel($item['id']);


                        if (!$quote) {
                            throw new Exception('Quote not found exception!');
                        }

                        $salesperson = $item['ws_user_id'] ? SalesPerson::model()->findByPk($item['ws_user_id'])->name : '';


                        $customerText = $quote->customer ? $quote->customer->cusnam : '';
                        $customerContactName = ' : ' . ($quote->customer ? $quote->customer->cuscontact : '' ) . '';


                        $quotenumber = $quote->quoteno;

                        $quotetotal = $quote->getTotalWithoutGST();




                        $priceClmValue = $quotetotal;
                        if ($priceClmFlag == 'estimate') {
                            $priceClmValue = $item["salesEstimate"];

                            $subjobtotal += $item["salesEstimate"];
                        } else {
                            $subjobtotal += $quotetotal;
                        }

                        if ($mergecount == 0) {

                            $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $row, $salesperson)
                                    ->setCellValue('B' . $row, date(GlobalVars::get("DateFormat"), strtotime($quote->quotecreated)))
                                    ->setCellValueExplicit('C' . $row, $quotenumber, PHPExcel_Cell_DataType::TYPE_STRING)
                                    ->setCellValue('D' . $row, number_format($priceClmValue, 2))
                                    ->setCellValue('E' . $row, $customerText . $customerContactName)
                                    ->setCellValue('F' . $row, $quote->getFollowupStatus())
                                    ->setCellValue('G' . $row, Refiner::getdatetext($item["dueDate"], GlobalVars::get("DateFormat")));
                        } else {
                            $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $row, "")
                                    ->setCellValue('B' . $row, date(GlobalVars::get("DateFormat"), strtotime($quote->quotecreated)))
                                    ->setCellValueExplicit('C' . $row, $quotenumber, PHPExcel_Cell_DataType::TYPE_STRING)
                                    ->setCellValue('D' . $row, number_format($priceClmValue, 2))
                                    ->setCellValue('E' . $row, $customerText . $customerContactName)
                                    ->setCellValue('F' . $row, $quote->getFollowupStatus())
                                    ->setCellValue('G' . $row, Refiner::getdatetext($item["dueDate"], GlobalVars::get("DateFormat")));
                        }

                        $row++;
                        $count++;

                        $mergecount++;
                    }
                }

                /**
                 * Subtotal of each salesperson
                 */
                $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A' . $row, "Subtotal : " . number_format($subjobtotal, 2))
                        ->setCellValue('B' . $row, "")
                        ->setCellValue('C' . $row, "")
                        ->setCellValue('D' . $row, "")
                        ->setCellValue('E' . $row, "")
                        ->setCellValue('F' . $row, "")
                        ->setCellValue('G' . $row, "");
                $row++;
                $count++;
                $allTotalExGST += $subjobtotal;
            }

            $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $row, "Total : " . number_format($allTotalExGST, 2))
                    ->setCellValue('B' . $row, "")
                    ->setCellValue('C' . $row, "")
                    ->setCellValue('D' . $row, "")
                    ->setCellValue('E' . $row, "")
                    ->setCellValue('F' . $row, "")
                    ->setCellValue('G' . $row, "");
            // Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="Quotes_By_SalespersonsV2_' . date('dmY') . '.xls"');
            header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');

            Yii::app()->end();
        } else {
            $this->redirect(array('salespersonV2'));
        }
    }

    public function actionSaveNewOtherCost() {
        $othercostidArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : array();
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : array();
        $quantity = $_POST['quantity'];

        $linetype = 0;
        $html = "";
        $count = 0;
        $otherCostTotal = 0;
        foreach ($othercostidArr as $key => $val) {
            $othercost = OtherCostType::model()->findByPk($val);
            $cost = $othercostArr[$key];




            $count++;
            $linetype = $count % 2;
            $currentrow = "oc_row_" . $count;

            $qty_based_html = '';
            $qty_based_attr = '';
            $unit_cost = $cost;
            if ($othercost->devide_by_qty) {
                $qty_based_attr = 'qtybsd="true"';
                $qty_based_html = '<br><font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                $unit_cost = round(($unit_cost / $quantity), 2);
            }

            $otherCostTotal += $unit_cost;
            $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
            $html .= '<tr ' . $rowclass . ' id="oc_row_' . $count . '">';
            $html .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $val . '" /></td>';
            $html .= '<td >' . $othercost->cost_group_rel->name . '</td>';
            $html .= '<td >' . $othercost->name . $qty_based_html . '</td>';
            $html .= '<td ><input ' . $qty_based_attr . '  name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
            $html .= '<td >' . number_format($unit_cost, 2) . '</td>';
            $html .= '<td ><a href="#" onclick="deleteOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
            $html .= '</tr>';
        }

        $html .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="vfgrert" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';



        echo json_encode(array('html' => $html, 'otherCostTotal' => $otherCostTotal));
    }

    public function actionSaveEditOtherCost() {
        $othercostidArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : array();
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : array();
        $quantity = $_POST['quantity'];

        $linetype = 0;
        $html = "";
        $count = 0;
        $otherCostTotal = 0;
        foreach ($othercostidArr as $key => $val) {
            $othercost = OtherCostType::model()->findByPk($val);
            $cost = $othercostArr[$key];




            $count++;
            $linetype = $count % 2;
            $currentrow = "oc_row_" . $count;

            $qty_based_html = '';
            $qty_based_attr = '';
            $unit_cost = $cost;
            if ($othercost->devide_by_qty) {
                $qty_based_attr = 'qtybsd="true"';
                $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                $unit_cost = round(($unit_cost / $quantity), 2);
            }

            $otherCostTotal += $unit_cost;
            $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
            $html .= '<tr ' . $rowclass . ' id="oc_row_' . $count . '">';
            $html .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $val . '" /></td>';
            $html .= '<td >' . $othercost->cost_group_rel->name . '</td>';
            $html .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
            $html .= '<td ><input ' . $qty_based_attr . '  name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
            $html .= '<td >' . number_format($unit_cost, 2) . '</td>';
            $html .= '<td ><a href="#" onclick="deleteEditOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
            $html .= '</tr>';
        }

        $html .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="plokij" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';



        echo json_encode(array('html' => $html, 'otherCostTotal' => $otherCostTotal));
    }

    public function actionAddOtherCostsForNewDtl() {
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : array();
        $othercostidArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : array();
        $quantity = $_POST['quantity'];
        $storedOtherCostIds = !empty($_POST['storedOtherCostIds']) ? explode(',', $_POST['storedOtherCostIds']) : array();
        $newlySelectedOtherCostIds = explode(',', $_POST['newlySelectedOtherCostIds']);

        $count = 0;
        foreach ($storedOtherCostIds as $key => $value) {
            $count++;
            if (($key2 = array_search($value, $newlySelectedOtherCostIds)) !== false) {
                unset($newlySelectedOtherCostIds[$key2]);
            }
        }

        foreach ($othercostidArr as $key => $value) {

            if (($key2 = array_search($value, $newlySelectedOtherCostIds)) !== false) {
                unset($newlySelectedOtherCostIds[$key2]);
            }
        }

        foreach ($othercostidArr as $key => $value) {

            if (($key2 = array_search($value, $storedOtherCostIds)) !== false) {
                unset($storedOtherCostIds[$key2]);
            }
        }

        $allIds = array_merge($storedOtherCostIds, $newlySelectedOtherCostIds, $othercostidArr);


        $allIds = array_filter($allIds);

        $linetype = 0;
        $html = "";
        $otherCostTotal = 0;
        foreach ($allIds as $key => $val) {
            $othercost = OtherCostType::model()->findByPk($val);
            $cost = $othercost->default_cost;


            if (!empty($othercostidArr)) {
                foreach ($othercostidArr as $key2 => $value2) {
                    if ($value2 == $val) {
                        $cost = $othercostArr[$key2];
                    }
                }
            }
            $count++;
            $linetype = $count % 2;
            $currentrow = "oc_row_" . $count;

            $qty_based_html = '';
            $qty_based_attr = '';
            $unit_cost = $cost;
            if ($othercost->devide_by_qty) {
                $qty_based_attr = 'qtybsd="true"';
                $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                $unit_cost = $unit_cost / $quantity;
            }
            $otherCostTotal += $unit_cost;

            $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
            $html .= '<tr ' . $rowclass . ' id="oc_row_' . $count . '">';
            $html .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $val . '" /></td>';
            $html .= '<td >' . $othercost->cost_group_rel->name . '</td>';
            $html .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
            $html .= '<td ><input ' . $qty_based_attr . '  name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
            $html .= '<td >' . number_format($unit_cost, 2) . '</td>';
            $html .= '<td ><a href="#" onclick="deleteOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
            $html .= '</tr>';
        }

        $html .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="vfgrert" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';


        $otherCostIdStr = implode(',', $allIds);

        echo json_encode(array('html' => $html, 'otherCostIdStr' => $otherCostIdStr));
    }

    public function actionAddOtherCostsForEditDtl() {
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : array();
        $othercostidArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : array();
        $quoteDtlId = $_POST['quoteDtlId'];
        $newlySelectedOtherCostIds = explode(',', $_POST['newlySelectedOtherCostIds']);

        $quoteDtl = QuatationDetails::model()->findByPk($quoteDtlId);
        $othercosts = QuoteOtherCost::model()->findAll(array('condition' => "quote_detail_id = $quoteDtlId"));

        $othercostsDBSavedIdArr = array();
        foreach ($othercosts as $data) {
            $othercostsDBSavedIdArr[] = $data->other_cost_id;
        }


        $diff = array_diff($othercostsDBSavedIdArr, $othercostidArr);

        foreach ($diff as $key => $value) {

            if (($key = array_search($value, $othercostsDBSavedIdArr)) !== false) {
                unset($othercostsDBSavedIdArr[$key]);
            }
        }


        foreach ($othercostsDBSavedIdArr as $key => $value) {

            if (($key = array_search($value, $newlySelectedOtherCostIds)) !== false) {
                unset($newlySelectedOtherCostIds[$key]);
            }
        }


        $count = 0;
        $linetype = 0;
        $otherCostHtml = "";
        $otherCostTotal = 0;
        foreach ($othercosts as $data) {
            if (in_array($data->other_cost_id, $othercostsDBSavedIdArr)) {
                $cost = $data->cost;
                if (!empty($othercostidArr) && count($othercostidArr) > 0) {
                    foreach ($othercostidArr as $key => $value) {
                        if ($value == $data->other_cost_id) {
                            $cost = $othercostArr[$key];
                        }
                    }
                }

                $count++;
                $linetype = $count % 2;
                $currentrow = "edit_oc_row_" . $count;
                $othercost = OtherCostType::model()->findByPk($data->other_cost_id);
                $qty_based_html = '';
                $qty_based_attr = '';
                $unit_cost = $cost;
                if ($othercost->devide_by_qty) {
                    $qty_based_attr = 'qtybsd="true"';
                    $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                    $unit_cost = $unit_cost / $quoteDtl->qty;
                }
                $otherCostTotal += $unit_cost;

                $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
                $otherCostHtml .= '<tr ' . $rowclass . ' id="edit_oc_row_' . $count . '">';
                $otherCostHtml .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $data->other_cost_id . '" /></td>';
                $otherCostHtml .= '<td >' . $othercost->cost_group_rel->name . '</td>';
                $otherCostHtml .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
                $otherCostHtml .= '<td ><input ' . $qty_based_attr . ' name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
                $otherCostHtml .= '<td >' . number_format($unit_cost, 2) . '</td>';
                $otherCostHtml .= '<td ><a href="#" onclick="deleteEditOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
                $otherCostHtml .= '</tr>';
            }
        }

        foreach ($newlySelectedOtherCostIds as $key => $val) {
            $othercost = OtherCostType::model()->findByPk($val);
            $cost = $othercost->default_cost;
            foreach ($othercostidArr as $key2 => $value2) {
                if ($value2 == $val) {
                    $cost = $othercostArr[$key2];
                }
            }
            $count++;
            $linetype = $count % 2;
            $currentrow = "edit_oc_row_" . $count;

            $qty_based_html = '';
            $qty_based_attr = '';
            $unit_cost = $cost;
            if ($othercost->devide_by_qty) {
                $qty_based_attr = 'qtybsd="true"';
                $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                $unit_cost = $unit_cost / $quoteDtl->qty;
            }
            $otherCostTotal += $unit_cost;
            $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
            $otherCostHtml .= '<tr ' . $rowclass . ' id="edit_oc_row_' . $count . '">';
            $otherCostHtml .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $val . '" /></td>';
            $otherCostHtml .= '<td >' . $othercost->cost_group_rel->name . '</td>';
            $otherCostHtml .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
            $otherCostHtml .= '<td ><input ' . $qty_based_attr . ' name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
            $otherCostHtml .= '<td >' . number_format($unit_cost, 2) . '</td>';
            $otherCostHtml .= '<td ><a href="#" onclick="deleteEditOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
            $otherCostHtml .= '</tr>';
        }

        $otherCostHtml .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="plokij" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';


        echo json_encode(array('otherCostHtml' => $otherCostHtml, '$diff' => $diff));
    }

    public function actionUnconvertedQuoteReport() {
        $model = new Quatation('searchUnconvertedQuotes');
        $model->unsetAttributes();  // clear any default values

        if (isset($_GET['Quatation']))
            $model->attributes = $_GET['Quatation'];

        if (isset($_POST['reset_btn'])) {


            unset(Yii::app()->session['unconquote_datefrom']);
            unset(Yii::app()->session['unconquote_dateto']);

            unset(Yii::app()->session['unconquote_query']);
        }




        if (isset($_POST['Quatation']['datefrom']) && !empty($_POST['Quatation']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['unconquote_datefrom'] = date('Y-m-d', strtotime($_POST['Quatation']['datefrom']));
        }

        if (isset(Yii::app()->session['unconquote_datefrom'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['unconquote_datefrom']));
        }

        if (isset($_POST['Quatation']['dateto']) && !empty($_POST['Quatation']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['unconquote_dateto'] = date('Y-m-d', strtotime($_POST['Quatation']['dateto']));
        }

        if (isset(Yii::app()->session['unconquote_dateto'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['unconquote_dateto']));
        }





        $this->render('unconverted_quote_report', array(
            'model' => $model,
        ));
    }

    public function actionPrintUnconvertedQuotePDF() {

        if (isset(Yii::app()->session['unconquote_query'])) {

            $query = Yii::app()->session['unconquote_query'];

            $rawData = Yii::app()->db->createCommand($query)->queryAll();

            if (empty($rawData)) {
                $this->redirect(array('unconvertedQuoteReport'));
            }


            $htmlcontent = $this->renderInternal('protected/views/quatation/unconverted_quote_html.php', array('rawData' => $rawData), true);

            $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);

            $pdfCreator = new PlainPDFCreator(array(
                'title' => 'Unconverted Quotes',
                'content' => $htmlcontent,
                'pageNumber' => '{PAGENO}',
                'outputFileName' => $sitePrefix . '_UnconvertedQuoteReport_' . date('dmY')
            ));

            $pdfCreator->generate();
        } else {
            $this->redirect(array('unconvertedQuoteReport'));
        }
    }

    public function actionCopyLine() {
        if (!isset($_POST['quoteId']) && !isset($_POST['quoteDetalIdStr'])) {
            throw new Exception('Bad Request!', 400);
        }

        $quote = $this->loadModel(intval($_POST['quoteId']));

        $quoteDetalIdArr = explode(',', $_POST['quoteDetalIdStr']);

        if (count($quoteDetalIdArr) == 0) {
            throw new Exception('Bad Request!', 400);
        }

        $criteria = new CDbCriteria;
        $criteria->addInCondition('id', $quoteDetalIdArr);
        $quoteDetails = QuatationDetails::model()->findAll($criteria);

        $transaction = Yii::app()->db->beginTransaction();
        $allsaved = true;
        $htmlResults = array();
        foreach ($quoteDetails as $data) {

            $copyLineQuoteDetail = new QuatationDetails();
            $copyLineQuoteDetail->attributes = $data->attributes;
            unset($copyLineQuoteDetail->id);
            if ($copyLineQuoteDetail->save()) {

                $quoteDecorations = $data->rel_multi_deco();
                if (count($quoteDecorations)) {
                    foreach ($quoteDecorations as $deco) {
                        $copyLineQuoteDecoration = new QuoteProductDecoration();
                        $copyLineQuoteDecoration->attributes = $deco->attributes;
                        $copyLineQuoteDecoration->quataiondetailsid = $copyLineQuoteDetail->id;
                        unset($copyLineQuoteDecoration->id);
                        $allsaved = $copyLineQuoteDecoration->save();
                    }
                }

                $quoteSizeQtyColours = $data->rel_size_qty_colors();
                if (count($quoteSizeQtyColours)) {
                    foreach ($quoteSizeQtyColours as $sizeqtycol) {
                        $copyLineSizeQtyColour = new QuotationDetailsSizeQtyColor();
                        $copyLineSizeQtyColour->attributes = $sizeqtycol->attributes;
                        $copyLineSizeQtyColour->quote_detail_id = $copyLineQuoteDetail->id;
                        unset($copyLineSizeQtyColour->id);
                        $allsaved = $copyLineSizeQtyColour->save();
                    }
                }

                $otherCosts = $data->rel_other_costs();
                if (count($otherCosts)) {
                    foreach ($otherCosts as $cost) {
                        $copyLineOtherCost = new QuoteOtherCost();
                        $copyLineOtherCost->attributes = $cost->attributes;
                        $copyLineOtherCost->quote_detail_id = $copyLineQuoteDetail->id;
                        unset($copyLineOtherCost->id);
                        $allsaved = $copyLineOtherCost->save();
                    }
                }
            } else {
                $allsaved = false;
            }
            $htmlResults[$copyLineQuoteDetail->id] = $this->getHtmlRow($copyLineQuoteDetail);
        }

        if (!$allsaved) {
            $transaction->rollback();
            throw new Exception("Cannot copy line(s)!", 304); //Not modified
        } else {
            $transaction->commit();
            echo json_encode($htmlResults);
        }
    }

    /**
     * Delete all related data sequence including the quote itself ( quote, workorder, job, invoice , DO, PO )
     */
    public function actionDeleteSequence($id) {
        $model = $this->loadModel($id);

        QuatationDetails::model()->deleteAll('quoteid = :quoteid', array(':quoteid' => $model->id));
        QuoteProductDecoration::model()->deleteAll('quoteid = :quoteid', array(':quoteid' => $model->id));
        QuotationDetailsSizeQtyColor::model()->deleteAll('quote_id = :quoteid', array(':quoteid' => $model->id));
        QuoteOtherCost::model()->deleteAll('quote_id = :quoteid', array(':quoteid' => $model->id));

        $workorders = Workorder::model()->findAll("quotationId = {$model->id}");

        foreach ($workorders as $workorder) {
            $workorderDetails = Workorderdetails::model()->findAll("workorderId = {$workorder->id}");
            foreach ($workorderDetails as $wrkdtl) {
                Workorderdetailssizecolor::model()->deleteAll('workOrderDetailsId = :workOrderDetailsId', array(':workOrderDetailsId' => $wrkdtl->id));
            }
            Workorderdetails::model()->deleteAll('workorderId = :workorderId', array(':workorderId' => $workorder->id));
            WorkorderDetailsDecoration::model()->deleteAll('work_order_id = :workorderId', array(':workorderId' => $workorder->id));
            WorkorderOtherCost::model()->deleteAll('workorder_id = :workorderId', array(':workorderId' => $workorder->id));

            //Job related this workorder
            $job = Jobs::model()->find("workorder_id = {$workorder->id}");
            if ($job) {
                JobActivityFlow::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
                JobArtwork::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
                JobArtworkDetail::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
                JobDecorations::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
                JobProducts::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
                JobProductDecorations::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));

                Invoice::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));
                InvoiceDetail::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));

                $purchaseOrders = PurchaseOrders::model()->findAll("job_id = {$job->id}");

                foreach ($purchaseOrders as $order) {
                    PurchaseOrderDetails::model()->deleteAll('po_id = :poId', array(':poId' => $order->id));
                }

                PurchaseOrders::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));

                $conPODtls = ConsolidatedPoDetail::model()->findAll("job_id = {$job->id}");

                foreach ($conPODtls as $conPO) {
                    ConsolidatedPurchaseOrder::model()->delete("consolidated_po_id = :conPoId", array(':conPoId' => $conPO->id));
                }

                ConsolidatedPoDetail::model()->deleteAll('job_id = :jobId', array(':jobId' => $job->id));

                $deliveryDocketDetails = DeliveryDocketDetails::model()->findAll("wrkorderId = {$workorder->id}");

                foreach ($deliveryDocketDetails as $ddd) {
                    DeliveryDocketLabel::model()->deleteAll('delivery_docket_dtl_id = :deliveryDocketDtlId', array(':deliveryDocketDtlId' => $ddd->id));
                }

                DeliveryDocketDetails::model()->deleteAll('wrkorderId = :wrkorderId', array(':wrkorderId' => $workorder->id));
                DeliveryDockets::model()->deleteAll('wrkorderId = :wrkorderId', array(':wrkorderId' => $workorder->id));

                $job->delete();
            }
        }

        Workorder::model()->deleteAll('quotationId = :quotationId', array(':quotationId' => $model->id));

        $model->delete();

        $this->redirect(array('admin'));
    }

    public function actionDashboard() {


        $model = new Quatation('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Quatation']))
            $model->attributes = $_GET['Quatation'];



        $this->render('dashboard', array(
            'model' => $model,
        ));
    }

    public function actionLoadFollowUpdateModel() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);
        echo $this->getFollowupDropDownHTML($model);
    }

    private function getFollowupDropDownHTML($model) {
        $listdata = FollowupStatus::model()->findAll(array('condition' => "type = 'Quotation'", 'order' => 'status'));
        $html = '<form id="flwup-stsup-form"><b>Quote : ' . $model->quoteno . '</b>&nbsp;<select id="quote-follow-up-update" quoteid="' . $model->id . '" name="Quatation[followupStatus]">';
        $html .= '<option value="0">Select Status</option>';
        foreach ($listdata as $data) {
            if ($model->getFollowupStatusId() == $data->id) {
                $html .= '<option value="' . $data->id . '" selected>' . $data->status . '</option>';
            } else {
                $html .= '<option value="' . $data->id . '">' . $data->status . '</option>';
            }
        }
        $html .= '</select></form>';

        $html .= '<div id="upstats-msg" style="display:none;"><img src="images/loading.gif" width="25" height="25"/>&nbsp;Quote follow-up status updating...</div>';
        $html .= '<div id="upstats-msg-done" style="display:none;color:green;font-weight:bold;">&nbsp;Quote follow-up status updated!</div>';
        $html .= '<div id="upstats-msg-error" style="display:none;"><img src="images/updaterror.png" width="25" height="25"/>&nbsp;Cannot update quote follow-up status!</div>';

        return $html;
    }

     public function actionUpdateAjaxStatus() {         
        $arr = array();
        if (Yii::app()->request->isAjaxRequest) {
            $id = $_POST['Quatation']['id'];
            $model = $this->loadModel($id);

            if (isset($_POST['Quatation']['followupStatus']) && $model->followupStatus != $_POST['Quatation']['followupStatus']) {
                $arr['followupStatus'] = $_POST['Quatation']['followupStatus'];

                $model->followupStatus = $_POST['Quatation']['followupStatus'];

                //add crm status
                $salesLog = new SalesLog();
                $salesLog->quoteId = $model->id;               
                $salesLog->quoteNum = $model->quoteno;

                $salesLog->category = 'Quotation';
                $salesLog->tbl_id = $model->id;
                $salesLog->followupSts_id = $model->followupStatus;
                if ($salesLog->save(false)) {
                    $model->save(false);
                    $arr['success'] = 'true';
                    $statusname = trim(FollowupStatus::model()->findByPk($model->followupStatus)->status);
                    
                    SalesLog::createSalesLog($model->id, null, $model->quoteno, 'Quotation', "Status is changed to $statusname", 1, 1, 1);

                    echo json_encode(array('success' => true));
                    exit;
                } 
            } 
        } 


        echo json_encode(array('success' => false));
        exit;
    }

    /**
     * Fron-end or outside request for a quote
     */

    public function actionResolve() {
        if(!isset($_GET['id'], $_GET['date'], $_GET['time'])) {
           throw new CHttpException(400, 'Bad request! Some parameter are missing.');
        }

        $quoteNumber = htmlspecialchars($_GET['id']);
        $date = htmlspecialchars($_GET['date']);
        $time = htmlspecialchars($_GET['time']);

        //fisrt find quote in quote table
        $quotation = Quatation::model()->find(
            array(
                'condition' => 'quoteno = :quoteNumber AND ws_date = :quoteTimestamp',
                'params' => array(':quoteNumber' => $quoteNumber, ':quoteTimestamp' => "{$date} {$time}")
                )
           );

        if($quotation) {
           $this->redirect(array('view', 'id' => $quotation->id));
           exit;
        }   

        //try to refresh quote from web service data
        if ($webservice = WebService::model()->find(array('condition' => "ws_date = '{$date}' AND ws_time = '{$time}'"))) {
           $quoteBuilder = new WebServiceQuoteBuilder();

           if ($quoteBuilder->build($webservice->toArray()) && $quotation = $quoteBuilder->getQuotation()) {
               if($quotation) {
                   $this->redirect(array('view', 'id' => $quotation->id));
                   exit;
                }   
           }
        }

        Yii::app()->user->setFlash('notice', "Cannot resolve the request for the quote number {$quoteNumber}");
        $this->redirect(array('admin'));

    }

}
