<?php

class QuatationDetailsController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'deleteSalesLine', 'getVatPercentage'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new QuatationDetails;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['QuatationDetails'])) {
            $model->attributes = $_POST['QuatationDetails'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['QuatationDetails'])) {
            $model->attributes = $_POST['QuatationDetails'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    public function actionDeleteMultipleRecords() {
        if (Yii::app()->request->isPostRequest) {
//            $transaction = Yii::app()->db->beginTransaction();

            $arrids = json_decode(stripslashes($_POST['quoteDtlArr']));



            if (!empty($arrids)) {
                $criteria = new CDbCriteria;
                $criteria->addInCondition('id', $arrids);
                QuatationDetails::model()->deleteAll($criteria);

                $criteria2 = new CDbCriteria;
                $criteria2->addInCondition('quataiondetailsid', $arrids);
                QuoteProductDecoration::model()->deleteAll($criteria2);

                $criteria3 = new CDbCriteria;
                $criteria3->addInCondition('quote_detail_id', $arrids);
                QuoteOtherCost::model()->deleteAll($criteria3);
            }
        } else {

            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
        }
    }

    public function actionDeleteSalesLine() {

        if (Yii::app()->request->isPostRequest) {
            $transaction = Yii::app()->db->beginTransaction();
            $model = $this->loadModel($_POST['id']);
            $modelDecorate = QuoteProductDecoration::model()->findByPk($model->id);
            $arr = array();
            if ($modelDecorate->delete()) {
                if ($model->delete()) {

                    $arr['status'] = 'success';
                    //$transaction->commit();
                    //echo json_encode($arr);
                } else {
                    $arr['status'] = 'failed';
                    //$transaction->rollback();
                    //echo json_encode($arr);
                }
            } else {
                $arr['status'] = 'failed';
                //$transaction->rollback();
                //echo json_encode($arr);
            }
            echo json_encode($arr);
            $transaction->rollback();
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('QuatationDetails');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new QuatationDetails('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['QuatationDetails']))
            $model->attributes = $_GET['QuatationDetails'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = QuatationDetails::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'quatation-details-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionGetVatPercentage() {
        if (Yii::app()->request->isPostRequest) {

            if (isset($_POST['productDetailID'])) {
                $productDetailsID = $_POST['productDetailID'];
                $sql = "select productvat from quatationdetails where id = '$productDetailsID' limit 1";
                $result = Yii::app()->db->createCommand($sql)->queryRow();



                echo json_encode($result);
            }
        }
    }

    //2017-03-06
    public function actionCalLinePirces() {

        $id = $_POST['id'];
        $qty = $_POST['qty'];
        $qtyPriceOption = $_POST['qtyPriceOption']; //Use the cost price entered = 1, Look up the current cost price = 2
        $result = array();

        if (!empty($qty)) {

            $model = $this->loadModel($id);
            $product = $model->productRel;

            $arr = array();
            $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
            if (empty($roundingPrecision)) {
                $roundingPrecision = 2;
            }

            $itmQty = $qty;

            //if qtyPriceOption equal 2 then Look up the current cost price
            if (in_array($qtyPriceOption, array(2))) {
                $prodPriceModel = ProductPrice::model()->find(array('condition' => "pdppdlsno = '{$product->pdlsno}' and (pdpquantity <= $itmQty and pdpsquantity >= $itmQty)", 'order' => 'pdpquantity_break_level'));
                //check qty break avaliable 
                if ($prodPriceModel) {
                    $model->productexunitprice = $prodPriceModel->pdpprice;
                }
            }

            $prodCostPrice = round($model->productexunitprice, $roundingPrecision);




            $prodMarkupRate = $model->supmarg;
            $prodMarkedUpPrice = $prodMarkupRate ? ($prodCostPrice * $prodMarkupRate) : $prodCostPrice;
            $prodDiscPercntg = $model->customerdicspcn;
            $prodDiscRate = round(($prodDiscPercntg / 100), strlen($prodDiscPercntg));
            $prodDiscountedPrice = $prodDiscRate ? ($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)) : $prodMarkedUpPrice;
            $usdFreight = $model->prodctfrieght;
            //new freght mark-ups 2018-10-10
            $usdFreghtUnitCost = round(($usdFreight / $itmQty), $roundingPrecision);
            $usdFreghtUnitMarkUpRate = $model->productFrieghtMarkUpRate ?: 1;
            $productFrieghtUnitCostWithMarkup = ($usdFreghtUnitCost * $usdFreghtUnitMarkUpRate);


            $prodUsdFreigtedPrice = $prodDiscountedPrice + round(($productFrieghtUnitCostWithMarkup), $roundingPrecision);
            $otherCostTotal = $model->other_cost;
            $otherCostMarkupRate = $model->other_cost_markup_rate;



            $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? round(($otherCostTotal * $otherCostMarkupRate), $roundingPrecision) : $otherCostTotal;

            $freightRate = $model->system_freight;

            $decorationTotal = 0;

            foreach ($model->rel_multi_deco() as $data) {

                $decoCalArr = $data->getDecorationCalculations(
                        array(
                            'decorationunitval' => $data->decorationunitval,
                            'supmarg' => $data->supmarg,
                            'logosetupcharge' => $data->logosetupcharge,
                            'decorationqty' => $qty,
                            'logoSetupMarkupRate' => $data->logoSetupMarkupRate
                ));

                $data->decorationqty = $qty;
                $data->supmargMarkedUpPrice = $decoCalArr['supmargMarkedUpPrice'];
                $data->logoSetupUnitCost = $decoCalArr['logoSetupUnitCost'];
                $data->logoSetupUnitCostWithMarkup = $decoCalArr['logoSetupUnitCostWithMarkup'];
                $data->save(false);

                $decorationTotal += $decoCalArr['supmargMarkedUpPrice'] + $decoCalArr['logoSetupUnitCostWithMarkup'];
            }


            if ($model->lockSellPrice) {
                $t = $model->sellunitprice_ex_vat - ($decorationTotal + $otherCostMarkedUpPrice); //total product price
                $mk_d = $t - ($usdFreight ? (round(($usdFreight / $qty), $roundingPrecision) * $usdFreghtUnitMarkUpRate) : 0); // marked up + discount without usd freight cost

                /*
                 * Equation to find product cost price
                 * c = product cost price
                 * m = product cost marked up price + discount
                 * r = product cost  marked up rate
                 * d = discount percentage
                 * 
                 * c = m * 100 / r * (100 - d) 
                 * 
                 * Equation for product markup rate
                 * 
                 * r = ( ( m * 100 ) / c) / (100 - d)
                 */

                $prodcutCostMarkUpRate = round(((round((( $mk_d * 100) / $prodCostPrice), 2)) / ( 100 - $prodDiscPercntg)), 4);
                $productCostMarkupPercentage = $this->getMarginOutOfMarkupMultiplier($prodcutCostMarkUpRate);


                $model->supmarg = $prodcutCostMarkUpRate;
                $model->supmargPercentage = $productCostMarkupPercentage;
            } else {
                $subTotal = $prodUsdFreigtedPrice + $otherCostMarkedUpPrice + $decorationTotal;
                $subTotalWithSetup = $subTotal;


                $total = ($freightRate ? round(($subTotalWithSetup * $freightRate), $roundingPrecision) : $subTotalWithSetup);



                $GST = GlobalVars::get(GlobalVars::GST);
                $sellPriceIncGST = $total * $GST;


                $model->qty = $itmQty;
                $model->productFrieghtUnitCost = $usdFreghtUnitCost;
                $model->productFrieghtUnitCostWithMarkup = $productFrieghtUnitCostWithMarkup;



                $model->sellunitprice_ex_vat = round($total, $roundingPrecision);
                $model->sellunitprice_in_vat = round($sellPriceIncGST, $roundingPrecision);
                $model->selltot_ex_vat = round(($model->sellunitprice_ex_vat * $model->qty), $roundingPrecision);
                $model->selltot_in_vat = round(($model->sellunitprice_in_vat * $model->qty), $roundingPrecision);
            }





            if ($model->save(false)) {


                echo json_encode(array('sellPriceExGST' => $model->sellunitprice_ex_vat, 'totExVat' => $model->selltot_ex_vat));
            }
        }
    }

    public function actionCalculateFullTotal() {
        $id = $_POST['id'];
        $type = $_POST['type'];
        $quote = null;
        if ($type == 'MDL') {
            $quote = Quatation::model()->findByPk($id);
        } else {
            $model = $this->loadModel($id);
            $quote = $model->quotationRel;
        }

        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }

        $subTotal = PriceCalculator::getSubTotal($quote);
        $gstTotal = PriceCalculator::getGSTTotal($quote);
        $totamtarr = array();
        $totamtarr['subTotal'] = number_format($subTotal, $roundingPrecision);
        $totamtarr['gstTotal'] = number_format($gstTotal, $roundingPrecision);
        $totamtarr['total'] = number_format(($subTotal + $gstTotal), $roundingPrecision);

        echo json_encode($totamtarr);
    }

    private function getSupplierMargin($model) {

        $sellPriceExGST = $model->sellunitprice_ex_vat;
        $prodCost = $model->productexunitprice;
        $decoCost = !empty($model->RelDeco) ? $model->RelDeco->decorationunitval : 0;
        $totalCost = $prodCost + $decoCost;
        $suppmarg = $sellPriceExGST / $totalCost;

        return $suppmarg;
    }

    private function getMarginOutOfMarkupMultiplier($rate) {
        if (in_array(floatval($rate), array(0, 0.0, null))) {
            return 0;
        }

        $markup_decimal_value = $rate;
        $hold_value = $markup_decimal_value * 100;
        $hold_value2 = $hold_value - 100;
        $new_margin_percentate = ($hold_value2 / $markup_decimal_value);

        return intval(round($new_margin_percentate));
    }

    /**
     * @description calculate prices based on already saved data and return to show on the calculation screen
     * @return array data for calculation screen 
     */
    public function actionFetchDetailsPrices() {
        if (isset($_POST['id'])) {
            $id = $_POST['id'];
            $model = $this->loadModel($id);

            //array for response values
            $arr = array();
            //set default rounding precision based on system defined var
            $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
            if (empty($roundingPrecision)) {
                $roundingPrecision = 2;
            }


            //set basic prices from the model
            $itmQty = $model->qty;
            $prodCostPrice = round($model->productexunitprice, $roundingPrecision);
            $prodMarkupRate = round($model->supmarg, 4);
            $prodMarkupPercentage = $model->supmargPercentage ?: $this->getMarginOutOfMarkupMultiplier($model->supmarg);
            //if markup rate is zero then marked up price must be zero
            $prodMarkedUpPrice = $prodMarkupRate ? ($prodCostPrice * $prodMarkupRate) : 0;
            $prodDiscPercntg = $model->customerdicspcn;
            $prodDiscRate = $prodDiscPercntg ? round(($prodDiscPercntg / 100), 4) : 0; // if discount available get the discount rate by deviding 100
            //product price after applying discount
            $prodDiscountedPrice = $prodDiscRate ? ($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)) : $prodMarkedUpPrice;
            $usdFreight = $model->prodctfrieght;
            $usdFreightUnit = $model->productFrieghtUnitCost;
            $usdFreightMarkupRate = $model->productFrieghtMarkUpRate;
            $usdFreightMarkupPercentage = $model->productFrieghtMarkUpPercentage ?: $this->getMarginOutOfMarkupMultiplier($model->productFrieghtMarkUpRate);
            $usdFreightUnitWithMarkedUp = $model->productFrieghtUnitCostWithMarkup;




            $prodUsdFreigtedPrice = $prodDiscountedPrice + $usdFreightUnitWithMarkedUp;
            $otherCostTotal = $model->other_cost;
            $otherCostMarkupRate = $model->other_cost_markup_rate;
            $otherCostMarkUpPercentage = $model->otherCostMarkupPercentage ?: $this->getMarginOutOfMarkupMultiplier($model->other_cost_markup_rate);


            //if markup rate is zero then marked up price must be zero
            $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? ($otherCostTotal * $otherCostMarkupRate) : 0;


            $decorationTotal = 0;
            $decoCostPrice = 0;

            foreach ($model->rel_multi_deco() as $data) {

                $decoCostPrice += ($data->decorationunitval + $data->logoSetupUnitCost);
                $decorationTotal += $data->supmargMarkedUpPrice + $data->logoSetupUnitCostWithMarkup;
            }

            $subTotal = $model->sellunitprice_ex_vat; // round($prodUsdFreigtedPrice + $otherCostMarkedUpPrice + $decorationTotal, $roundingPrecision);
            $subTotalWithSetup = $subTotal;
            $freightRate = $model->system_freight;
            $systemFreightPercentage = $model->systemFreightPercentage ?: $this->getMarginOutOfMarkupMultiplier($model->system_freight);

            $total = ($freightRate ? ($subTotalWithSetup * $freightRate) : $subTotalWithSetup);



            $othercosts = QuoteOtherCost::model()->findAll(array('condition' => "quote_detail_id = $id"));

            $count = 0;
            $linetype = 0;
            $otherCostHtml = "";

            foreach ($othercosts as $data) {

                $count++;
                $linetype = $count % 2;
                $currentrow = "edit_oc_row_" . $count;
                $othercost = OtherCostType::model()->findByPk($data->other_cost_id);
                $qty_based_html = '';
                $qty_based_attr = '';
                $unit_cost = $data->cost;
                if ($othercost->devide_by_qty) {
                    $qty_based_attr = 'qtybsd="true"';
                    $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                    $unit_cost = $data->cost / $itmQty;
                }
                $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
                $otherCostHtml .= '<tr ' . $rowclass . ' id="edit_oc_row_' . $count . '">';
                $otherCostHtml .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $data->other_cost_id . '" /></td>';
                $otherCostHtml .= '<td >' . $othercost->cost_group_rel->name . '</td>';
                $otherCostHtml .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
                $otherCostHtml .= '<td ><input ' . $qty_based_attr . ' name="othercost[]" value="' . $data->cost . '" tabindex="' . $count . '"/></td>';
                $otherCostHtml .= '<td >' . number_format($unit_cost, 2) . '</td>';
                $otherCostHtml .= '<td ><a href="#" onclick="deleteEditOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
                $otherCostHtml .= '</tr>';
            }

            $otherCostHtml .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="plokij" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';




            $grossProfit = $total - ($prodCostPrice + $usdFreightUnit + $decoCostPrice + $otherCostTotal);
            $grossProfitPercentage = $total ? round(($grossProfit / $total) * 100, 2) : 0;

            $arr['prodCostPrice'] = $prodCostPrice;
            $arr['prodMarkupRate'] = $prodMarkupRate;
            $arr['prodMarkupPercentage'] = round($prodMarkupPercentage, 4);
            $arr['prodMarkedUpPrice'] = $prodMarkedUpPrice;
            $arr['prodDiscRate'] = $prodDiscRate;
            $arr['prodDiscPercntg'] = $prodDiscPercntg;
            $arr['prodDiscountedPrice'] = $prodDiscountedPrice;

            $arr['usdFreight'] = $usdFreight;
            $arr['prodUsdFreigtedPrice'] = $prodUsdFreigtedPrice;


            $arr['otherCostTotal'] = $otherCostTotal;
            $arr['otherCostMarkUpRate'] = $otherCostMarkupRate;
            $arr['otherCostMarkUpPercentage'] = $otherCostMarkUpPercentage;
            $arr['otherCostMarkedUpPrice'] = $otherCostMarkedUpPrice;
            $arr['subTotal'] = $subTotal;
            $arr['itmQty'] = $itmQty;

            $arr['subTotalWithSetup'] = $subTotalWithSetup;
            $arr['freightRate'] = $freightRate;
            $arr['freightPercentage'] = $systemFreightPercentage;
            $arr['total'] = $total;
            $arr['aFLockSellPrice'] = $model->lockSellPrice;

            $arr['otherCostHtml'] = $otherCostHtml;

            //new usd freight values for product
            $arr['usdFreightUnit'] = $usdFreightUnit;
            $arr['usdFreightMarkupRate'] = $usdFreightMarkupRate;
            $arr['usdFreightMarkupPercentage'] = $usdFreightMarkupPercentage;
            $arr['usdFreightUnitWithMarkedUp'] = $usdFreightUnitWithMarkedUp;


            $arr['totalCostPrice'] = ($prodCostPrice + $usdFreightUnit + $decoCostPrice + $otherCostTotal);
            $arr['grossProfitPercentage'] = $grossProfitPercentage;
            $arr['grossProfit'] = $grossProfit;
            $arr['totalGrossProfit'] = $grossProfit * $itmQty;
            $arr['lineTotal'] = $total * $itmQty;

            $arr['systemTaxRateId'] = $model->systemTaxRateId;




            $arr['multiDecoCalScreenHtml'] = $this->getMultiDecoCalScreenHtmlInputs($model);


            echo json_encode($arr);
        } else {
            throw new CHttpException(403, 'error in get prices.');
        }
    }

    //Get the multiple decorations html inputs for given quotation detail

    private function getMultiDecoCalScreenHtmlInputs($quoteDetail) {
        $html = "<table style='width:100%;'>";
        $html .= "<tr style='width:100%;'>";
        $html .= "<th style='width: 5%;text-align:center;'>No</th>";
        $html .= "<th style='width: 30%;text-align:center;'>Code</th>";
        $html .= "<th style='width: 20%;text-align:center;'>Unit Price</th>";
        $html .= "<th style='width: 25%;text-align:center;'>Mark-Up</th>";
        $html .= "<th style='width: 15%;text-align:center;'>Marked-Up Price</th>";
        $html .= "<th style='width: 5%;text-align:center;'>&nbsp;</th>";
        $html .= "</tr>";
        $html .= "<tbody>";

        $count = 0;

        $decorationTotal = 0;

        foreach ($quoteDetail->rel_multi_deco() as $data) {
            $count++;
            $decoCalArr = $data->getDecorationCalculations(
                    array(
                        'decorationunitval' => $data->decorationunitval,
                        'supmarg' => $data->supmarg,
                        'supmargPercentage' => $data->supmargPercentage,
                        'logosetupcharge' => $data->logosetupcharge,
                        'decorationqty' => $data->decorationqty,
                        'logoSetupMarkupRate' => $data->logoSetupMarkupRate,
                        'logoSetupMarkupPercentage' => $data->logoSetupMarkupPercentage
            ));


            $decorationTotal += $decoCalArr['supmargMarkedUpPrice'] + $decoCalArr['logoSetupUnitCostWithMarkup'];


            $data->supmargPercentage = $data->supmargPercentage ?: $this->getMarginOutOfMarkupMultiplier($data->supmarg);
            $data->logoSetupMarkupPercentage = $data->logoSetupMarkupPercentage ?: $this->getMarginOutOfMarkupMultiplier($data->logoSetupMarkupRate);

            $supplierHtml = $data->supRel ? $data->supRel->getSupplierLink() : '';
            if (!$supplierHtml) {
                //set default supplier from decoration table
                $supplierHtml = ($data->decoRel ? $data->decoRel->getSupplierLink() : '');
            }

            $html .= "<tr style='width:100%;border-bottom:1px solid #eee;'>";
            $html .= "<td style='width:5%;'>{$count}</td>";
            $html .= "<td   colspan='4'>";
            $html .= "<table style='width:100%;'>";

            $html .= "<tr style='width:100%;'>";
            $html .= "<td style='width: 30%;'><input type='hidden' name='QuoteProductDecoration[{$data->id}][decprtnam]' value='{$data->decprtnam}' /><div style='font-size:8.5pt;'>{$data->decprtnam}</div><div style='font-size:7.5pt;'>{$data->decorationdescription}</div><div style='font-size:8.5pt;'>{$supplierHtml}</div></td>";
            $html .= "<td style='width:20%;text-align:right;'><input type='text' name='QuoteProductDecoration[{$data->id}][decorationunitval]' value='{$decoCalArr['decorationunitval']}' style='width:90%;text-align:center;'/></td>";
            $html .= "<td style='width: 25%;text-align:right;'>"
                    . "<input title='rate' mark-up='rate' type='text' name='QuoteProductDecoration[{$data->id}][supmarg]' value='{$decoCalArr['supmarg']}' style='width:30%;text-align:center;margin-right:2px;'/>"
                    . "<input title='percentage(%)' mark-up='percentage'  type='text'  style='text-align: center;width: 30%;' name='QuoteProductDecoration[{$data->id}][supmargPercentage]' value='{$data->supmargPercentage}' />  (%)"
                    . "</td>";

            $html .= "<td style='width: 20%;text-align:right;'><input type='text' name='QuoteProductDecoration[{$data->id}][supmargMarkedUpPrice]' value='{$decoCalArr['supmargMarkedUpPrice']}' readonly='true' style='width:90%;text-align:right;'/></td>";
            $html .= "</tr>";
            $html .= "<tr style='width:100%;'>";
            $html .= "<td style='width:30%;'>LogoSetup : <input type='text' name='QuoteProductDecoration[{$data->id}][logosetupcharge]' value='{$decoCalArr['logosetupcharge']}' style='width:40%;text-align:center;'/></td>";
            $html .= "<td style='width: 20%;text-align:right;'><input type='text' name='QuoteProductDecoration[{$data->id}][logoSetupUnitCost]' value='{$decoCalArr['logoSetupUnitCost']}' style='width:90%;text-align:center;'/></td>";
            $html .= "<td style='width: 25%;text-align:right;'>"
                    . "<input title='rate' mark-up='rate' type='text' name='QuoteProductDecoration[{$data->id}][logoSetupMarkupRate]' value='{$decoCalArr['logoSetupMarkupRate']}' style='width:30%;text-align:center;margin-right:2px;'/>"
                    . "<input title='percentage(%)' mark-up='percentage'  type='text'  style='text-align: center;width: 30%;' name='QuoteProductDecoration[{$data->id}][logoSetupMarkupPercentage]' value='{$data->logoSetupMarkupPercentage}' />  (%)"
                    . "</td>";
            $html .= "<td style='width: 20%;text-align:right;'><input type='text' name='QuoteProductDecoration[{$data->id}][logoSetupUnitCostWithMarkup]' value='{$decoCalArr['logoSetupUnitCostWithMarkup']}' readonly='true' style='width:90%;text-align:right;' /></td>";
            $html .= "</tr>";

            $html .= "</table>";
            $html .= "</td>";
            $html .= "<td style='width: 5%;text-align:right;vertical-align:middle;cursor:pointer;'><img src='images/cross-delete-icon.png' width='15px;' title='Delete Decoration' onclick='deleteEditCalDeco({$data->id});'></td>";
            $html .= "</tr>";
        }



        $html .= "<tr style='width:100%;'>";
        $html .= "<td colspan='2' style='text-align:left;'><button type='button' class='btn btn-default' onclick='showEditCalDecorationPopup();'>Add Decoration</button></td>";
        $html .= "<td colspan='2' style='text-align:right;'>Decoration Total : </td><td><input  name='af_edit_decoration_total' id='af_edit_decoration_total' type='text' value='{$decorationTotal}' readonly='true' style='width:90%;text-align:right;' /></td>";
        $html .= "</tr>";

        $html .= "</tbody>";
        $html .= "</table>";

        return $html;
    }

    public function actionDoPricePlayingCal() {
        $arr = array();
        $arr['error_message'] = "";
        $id = $_POST['quoteDtlId'];
        $model = $this->loadModel($id);
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }

        $prodCostPrice = floatval($_POST['af_edit_cost_price']);
        $prodMarkupRate = floatval($_POST['af_edit_prd_markup']);
        $prodDiscPercntg = floatval($_POST['af_discount_percntg']);
        $usdFreight = floatval($_POST['af_usd_freight']);
        $usdFreightMarkUpRate = floatval($_POST['af_usd_freight_markup_rate']);
        $lockSellPrice = isset($_POST['aFLockSellPrice']) ? intval($_POST['aFLockSellPrice']) : 0;
        $afEditSubTotalWithSetup = floatval($_POST['af_edit_subtotal_with_setup']);



        $itmQty = intval($_POST['af_edit_itm_qty']) ? intval($_POST['af_edit_itm_qty']) : 0;


        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;


        $decoCostPrice = 0;
        if (isset($_POST['QuoteProductDecoration'])) {
            $editedLineArr = $_POST['QuoteProductDecoration'];
            foreach ($editedLineArr as $key => $value) {

                $quoteDetailDeco = QuoteProductDecoration::model()->findByPk($key);
                $decoCalArr = $quoteDetailDeco->getDecorationCalculations(
                        array(
                            'decorationunitval' => $value['decorationunitval'],
                            'supmarg' => $value['supmarg'],
                            'logosetupcharge' => $value['logosetupcharge'],
                            'decorationqty' => $itmQty,
                            'logoSetupMarkupRate' => $value['logoSetupMarkupRate']
                ));


                $arr['multiDecoLines'][] = array(
                    "QuoteProductDecoration[$key][supmargMarkedUpPrice]" => $decoCalArr['supmargMarkedUpPrice'],
                    "QuoteProductDecoration[$key][logoSetupUnitCost]" => $decoCalArr['logoSetupUnitCost'],
                    "QuoteProductDecoration[$key][logoSetupUnitCostWithMarkup]" => $decoCalArr['logoSetupUnitCostWithMarkup'],
                );


                $decoCostPrice += ($value['decorationunitval'] + $decoCalArr['logoSetupUnitCost']);
                $totalDecoSupMarginMarkupPrice += $decoCalArr['supmargMarkedUpPrice'];
                $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logoSetupUnitCostWithMarkup'];
            }
        }

        $freightRate = $_POST['af_freight_rate'];


        $otherCostTotal = floatval($_POST['af_edit_othercost_total']);
        $otherCostMarkupRate = floatval($_POST['af_edit_othercost_markup_rate']);


        //if markup rate is zero then marked up price must be zero
        $prodMarkedUpPrice = $prodMarkupRate ? round(($prodCostPrice * $prodMarkupRate), $roundingPrecision) : 0;

        $prodDiscRate = round(($prodDiscPercntg / 100), strlen($prodDiscPercntg));
        $prodDiscountedPrice = $prodDiscRate ? round(($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)), $roundingPrecision) : $prodMarkedUpPrice;

        $usdFreightUnitCost = round(($usdFreight / $itmQty), $roundingPrecision);
        $usdFreightUnitCostWithMarkedUp = $usdFreightUnitCost * $usdFreightMarkUpRate;

        $prodUsdFreightedPrice = $prodDiscountedPrice + round(($usdFreightUnitCostWithMarkedUp), $roundingPrecision);



        //if markup rate zero then markedup price must be zero
        $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? round(($otherCostTotal * $otherCostMarkupRate), $roundingPrecision) : 0;



        $subTotal = $prodUsdFreightedPrice + $otherCostMarkedUpPrice + ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice);
        $subTotalWithSetup = $subTotal;


        $total = $freightRate ? round(($subTotalWithSetup * $freightRate), $roundingPrecision) : $subTotalWithSetup;

        $grossProfit = $total - ($prodCostPrice + $usdFreightUnitCost + $decoCostPrice + $otherCostTotal);
        $grossProfitPercentage = $total ? round(($grossProfit / $total) * 100, 2) : 0;


        //new freight values 2018-10-10
        $arr['lockSellPrice'] = $lockSellPrice;
        $arr['prodCostPrice'] = $prodCostPrice;
        $arr['prodMarkupRate'] = $prodMarkupRate;
        $arr['usdFreightUnitCost'] = $usdFreightUnitCost;
        $arr['usdFreightUnitCostWithMarkedUp'] = $usdFreightUnitCostWithMarkedUp;


        $arr['prodDiscountedPrice'] = $prodDiscountedPrice;
        $arr['prodUsdFreightedPrice'] = $prodUsdFreightedPrice;

        $arr['otherCostMarkedUpPrice'] = $otherCostMarkedUpPrice;

        $arr['subTotal'] = $subTotal;
        $arr['subTotalWithSetup'] = $subTotalWithSetup;
        $arr['total'] = $total;
        $arr['totalCost'] = ($prodCostPrice + $usdFreightUnitCost + $decoCostPrice + $otherCostTotal);
        $arr['totalDecoSupMarginMarkupPrice'] = $totalDecoSupMarginMarkupPrice;
        $arr['totalDecoLogosetupUnitMarkupPrice'] = $totalDecoLogosetupUnitMarkupPrice;
        $arr['decorationTotal'] = ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice);
        $arr['grossProfitPercentage'] = $grossProfitPercentage;
        $arr['grossProfit'] = $grossProfit;
        $arr['totalGrossProfit'] = $grossProfit * $itmQty;
        $arr['lineTotal'] = $total * $itmQty;


        echo json_encode($arr);
    }

    public function actionCloneLineByQuantity() {
        $id = $_POST['quoteDetailId'];
        $quantity = $_POST['quantity'];
        $model = $this->loadModel($id);
        $cloneModel = new QuatationDetails();
        $cloneModel->attributes = $model->attributes;
        $cloneModel->id = null;
        $cloneModel->qty = $quantity;
        if ($allsaved = $cloneModel->save(false)) {


            $quoteDecorations = $model->rel_multi_deco();
            if (count($quoteDecorations)) {
                foreach ($quoteDecorations as $deco) {
                    $copyLineQuoteDecoration = new QuoteProductDecoration();
                    $copyLineQuoteDecoration->attributes = $deco->attributes;
                    $copyLineQuoteDecoration->quataiondetailsid = $cloneModel->id;
                    $copyLineQuoteDecoration->decorationqty = $quantity;
                    unset($copyLineQuoteDecoration->id);
                    $allsaved = $copyLineQuoteDecoration->save();
                }
            }

            $quoteSizeQtyColours = $model->rel_size_qty_colors();
            if (count($quoteSizeQtyColours)) {
                foreach ($quoteSizeQtyColours as $sizeqtycol) {
                    $copyLineSizeQtyColour = new QuotationDetailsSizeQtyColor();
                    $copyLineSizeQtyColour->attributes = $sizeqtycol->attributes;
                    $copyLineSizeQtyColour->quote_detail_id = $cloneModel->id;
                    unset($copyLineSizeQtyColour->id);
                    $allsaved = $copyLineSizeQtyColour->save();
                }
            }

            $otherCosts = $model->rel_other_costs();
            if (count($otherCosts)) {
                foreach ($otherCosts as $cost) {
                    $copyLineOtherCost = new QuoteOtherCost();
                    $copyLineOtherCost->attributes = $cost->attributes;
                    $copyLineOtherCost->quote_detail_id = $cloneModel->id;
                    unset($copyLineOtherCost->id);
                    $allsaved = $copyLineOtherCost->save();
                }
            }

            if ($allsaved) {
                $cloneModel->recalculateLinePrice();
                echo json_encode(array(
                    'status' => 'success',
                    'newLineId' => $cloneModel->id,
                    'quantity' => $cloneModel->qty,
                    'newLineHTML' => $cloneModel->getHtmlRow()
                ));
            }
        }
    }

    public function actionUpdateDetailsPricesByTotExGST() {
        $quoteDtlId = $_POST['quoteDtlId'];

        $prodCostPrice = $_POST['af_edit_cost_price'];
        $prodMarkupRate = $_POST['af_edit_prd_markup'];
        $prodMarkupPercentage = $_POST['af_edit_prd_markup_percentage'];
        $prodDiscPercntg = $_POST['af_discount_percntg'];
        $prodUsdFreight = $_POST['af_usd_freight'];

        //new freight mark-up values 2018-10-10
        $prodUsdFreightMarkupRate = $_POST['af_usd_freight_markup_rate'];
        $prodUsdFreightMarkupPercentage = $_POST['af_usd_freight_markup_percentage'];
        $prodUsdFreightUnitCost = $_POST['af_usd_freight_unit_cost'];
        $prodUsdFreightUnitMarkedupPrice = $_POST['af_usd_freight_unit_markedup_price'];



        $itmQty = $_POST['af_edit_itm_qty'] ?: 0;
        $freightRate = $_POST['af_freight_rate'];
        $freightPercentage = $_POST['af_freight_percentage'];
        $total = $_POST['af_edit_total'];
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : null;
        $othercostIdArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : null;
        $otherCostTotal = $_POST['af_edit_othercost_total'];
        $otherCostMarkupRate = floatval($_POST['af_edit_othercost_markup_rate']);
        $otherCostMarkupPercentage = floatval($_POST['af_edit_othercost_markup_percentage']);



        $lineTaxRateId = $_POST['af_edit_tax_rate_id']; //system tax code
        $systemTaxRate = SystemTaxCode::model()->findByPk($lineTaxRateId);

        $decoArr = array();
        if (isset($_POST['QuoteProductDecoration'])) {
            $editedLineArr = $_POST['QuoteProductDecoration'];
            foreach ($editedLineArr as $key => $attrArr) {

                $quoteDetailDeco = QuoteProductDecoration::model()->findByPk($key);
                foreach ($attrArr as $field => $value) {
                    $quoteDetailDeco->$field = $value;
                }
                $quoteDetailDeco->decorationqty = $itmQty;
                if ($quoteDetailDeco->save(false)) {
                    $decoArr[] = $quoteDetailDeco->attributes;
                }
            }
        }



        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }
        $pricesarr = array();
        $model = $this->loadModel($quoteDtlId);
        $oldAtttributes = $model->attributes;
        $GST = GlobalVars::get(GlobalVars::GST);
        $sellPriceIncGST = $systemTaxRate ? ($total * $systemTaxRate->rate) : ($total * $GST);


        $model->productexunitprice = $prodCostPrice;
        $model->supmarg = $prodMarkupRate;
        $model->supmargPercentage = $prodMarkupPercentage;
        $model->customerdicspcn = $prodDiscPercntg;
        $model->qty = $itmQty;



        $model->prodctfrieght = $prodUsdFreight;
        //new freight mark-up values
        $model->productFrieghtUnitCost = $prodUsdFreightUnitCost;
        $model->productFrieghtMarkUpRate = $prodUsdFreightMarkupRate;
        $model->productFrieghtMarkUpPercentage = $prodUsdFreightMarkupPercentage;
        $model->productFrieghtUnitCostWithMarkup = $prodUsdFreightUnitMarkedupPrice;

        $model->system_freight = $freightRate;
        $model->systemFreightPercentage = $freightPercentage;
        $model->other_cost = $otherCostTotal;
        $model->other_cost_markup_rate = $otherCostMarkupRate;
        $model->otherCostMarkupPercentage = $otherCostMarkupPercentage;

        $model->sellunitprice_ex_vat = round($total, $roundingPrecision);
        $model->sellunitprice_in_vat = round($sellPriceIncGST, $roundingPrecision);
        $model->selltot_ex_vat = round(($model->sellunitprice_ex_vat * $model->qty), $roundingPrecision);
        $model->selltot_in_vat = round(($model->sellunitprice_in_vat * $model->qty), $roundingPrecision);
        $model->lockSellPrice = isset($_POST['aFLockSellPrice']) ? intval($_POST['aFLockSellPrice']) : 0;

        $model->systemTaxRateId = ($systemTaxRate ? $systemTaxRate->id : null);



        $pricesarr['sellPriceExVat'] = $model->sellunitprice_ex_vat;
        $pricesarr['sellPriceIncVat'] = $model->sellunitprice_in_vat;
        $pricesarr['totExVat'] = $model->selltot_ex_vat;
        $pricesarr['totIncVat'] = $model->selltot_in_vat;
        $pricesarr['quantity'] = $model->qty;





        if ($model->save(false)) {




            $modifeidArrWithLabel = AttributeCompare::compare($model->attributes, $oldAtttributes, $model->attributeLabels());


            $oldArrWithLabel = AttributeCompare::compare($oldAtttributes, $model->attributes, $model->attributeLabels());




            if ($modifeidArrWithLabel) {

                SalesLog::jsonLog(
                        array(
                            'quoteId' => $model->quoteid,
                            'workorderId' => null,
                            'quoteNum' => $model->quotationRel->quoteno,
                            'category' => 'Quotation',
                            'comments' => 'Item prices [' . $model->productsku . ' - ' . $model->productname . '] have been updated <br /> From ' . json_encode($oldArrWithLabel) . ' <br /> To ' . json_encode($modifeidArrWithLabel),
                            'json_record' => json_encode(array('old' => $oldAtttributes, 'new' => $model->attributes)),
                            'isIntrnl' => 1,
                            'isExtrnl' => 1,
                            'isTechnical' => 1
                        )
                );
            }


            if ($othercostIdArr && count($othercostIdArr) > 0) {
                $quoteOtherCosts = QuoteOtherCost::model()->find(array('condition' => "quote_detail_id = $quoteDtlId"));


                foreach ($othercostIdArr as $key => $value) {
                    $quoteOtherCost = QuoteOtherCost::model()->find(array('condition' => "quote_detail_id = $quoteDtlId and other_cost_id = $value"));

                    if ($quoteOtherCost) {
                        $quoteOtherCost->cost = $othercostArr[$key];
                        $quoteOtherCost->save();
                    } else {
                        $quoteOtherCost = new QuoteOtherCost();
                        $quoteOtherCost->quote_id = $model->quoteid;
                        $quoteOtherCost->quote_detail_id = $quoteDtlId;
                        $quoteOtherCost->other_cost_id = $value;
                        $quoteOtherCost->cost = $othercostArr[$key];
                        $quoteOtherCost->created_by = Yii::app()->user->id;
                        $quoteOtherCost->created_date = date('Y-m-d');
                        $quoteOtherCost->save();
                    }
                }

                //delete other cost

                $quoteOtherCosts = QuoteOtherCost::model()->findAll(array('condition' => "quote_detail_id = $quoteDtlId"));

                foreach ($quoteOtherCosts as $data) {

                    if (!in_array($data->other_cost_id, $othercostIdArr)) {
                        $data->delete();
                    }
                }
            } else {
                $criteria = new CDbCriteria;
                $criteria->addCondition("quote_detail_id = $quoteDtlId");
                QuoteOtherCost::model()->deleteAll($criteria);
            }


            $model->quotationRel->save(false);
            $pricesarr['success'] = true;
        } else {
            $pricesarr['success'] = false;
        }

        echo json_encode($pricesarr);
    }

    public function actionUpdateField() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id']) && isset($_POST['attr']) && isset($_POST['val'])) {
                $id = $_POST['id'];
                $attr = $_POST['attr'];
                $val = $_POST['val'];

                switch ($attr) {
                    case 'decorationdescription':
                        $decodetl = QuoteProductDecoration::model()->find(array('condition' => "quataiondetailsid = $id"));
                        if (!empty($decodetl)) {
                            $decodetl->decorationdescription = $val;
                            $decodetl->save(false);
                        }

                        break;
                    default:
                        $updated = QuatationDetails::model()->updateByPk($id, array(
                            "$attr" => htmlspecialchars($val)
                        ));
                        break;
                }
            }
        }
    }

    public function actionDoAddNewPricePlayingCal() {
        $arr = array();
        $arr['error_message'] = "";
        $id = $_POST['quoteDtlId'];

        $defaultMarkUpRate = GlobalVars::get(GlobalVars::GST);
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }

        $prodCostPrice = floatval($_POST['adnew_cost_price']);
        $prodSellPrice = floatval($_POST['adnew_sell_price']);
        $prodMarkupRate = floatval($_POST['adnew_prd_markup']);
        $prodDiscPercntg = floatval($_POST['adnew_discount_percntg']);
        $usdFreight = floatval($_POST['adnew_usd_freight']);
        $usdFreightMarkUpRate = floatval($_POST['adnew_usd_freight_markup_rate']);
        $lockSellPrice = isset($_POST['lockSellPrice']) ? intval($_POST['lockSellPrice']) : 0;
        $addNewSubTotalWithSetup = floatval($_POST['adnew_edit_subtotal_with_setup']);



        $itmQty = intval($_POST['adnew_edit_itm_qty']) ?: 1;



        $freightRate = floatval($_POST['adnew_freight_rate']);

        $otherCostTotal = floatval($_POST['adnew_othercost_total']);
        $otherCostMarkupRate = floatval($_POST['adnew_othercost_markup_rate']);

        $prodCode = $_POST['adnew_prd_code'];


        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;

        $decoCostPrice = 0;
        if (isset($_POST['QuoteProductDecoration'])) {
            $addNewLineArr = $_POST['QuoteProductDecoration'];
            foreach ($addNewLineArr as $key => $value) {


                $decoCalArr = QuoteProductDecoration::getAddNewDecorationCalculations(
                                array(
                                    'decorationunitval' => $value['decorationunitval'],
                                    'supmarg' => $value['supmarg']?:$defaultMarkUpRate,
                                    'logosetupcharge' => $value['logosetupcharge'],
                                    'decorationqty' => $itmQty,
                                    'logoSetupMarkupRate' => $value['logoSetupMarkupRate'] ?:$defaultMarkUpRate
                ));


                $arr['multiDecoLines'][] = array(
                    "QuoteProductDecoration[$key][supmargMarkedUpPrice]" => $decoCalArr['supmargMarkedUpPrice'],
                    "QuoteProductDecoration[$key][logoSetupUnitCost]" => $decoCalArr['logoSetupUnitCost'],
                    "QuoteProductDecoration[$key][logoSetupUnitCostWithMarkup]" => $decoCalArr['logoSetupUnitCostWithMarkup'],
                );

                $decoCostPrice += ($value['decorationunitval'] + $decoCalArr['logoSetupUnitCost']);
                $totalDecoSupMarginMarkupPrice += $decoCalArr['supmargMarkedUpPrice'];
                $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logoSetupUnitCostWithMarkup'];
            }
        }






        $prodMarkedUpPrice = floatval($prodMarkupRate) ? round(($prodCostPrice * $prodMarkupRate), $roundingPrecision) : 0;

        /** lock sell price calculations */
        if ($lockSellPrice && ($prodMarkedUpPrice <= $prodSellPrice)) {
            /* if $prodSellPrice is available that means it comes when product select from the grid */

            $prodMarkupRate = $prodCostPrice ? round(($prodSellPrice / $prodCostPrice), 4) : 0;
            $prodMarkedUpPrice = round(($prodCostPrice * $prodMarkupRate), 2);
        } else if ($lockSellPrice && $addNewSubTotalWithSetup) {

            $prodMarkupRate = $prodCostPrice ? round(($addNewSubTotalWithSetup / $prodCostPrice), 4) : 0;

            $prodMarkedUpPrice = round(($prodCostPrice * $prodMarkupRate), 2);
        }

        /** End - lock sell price calculations */
        $prodDiscRate = round(($prodDiscPercntg / 100), strlen($prodDiscPercntg));
        $prodDiscountedPrice = floatval($prodDiscRate) ? round(($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)), $roundingPrecision) : $prodMarkedUpPrice;

        $usdFreightUnitCost = $itmQty ? round(($usdFreight / $itmQty), $roundingPrecision) : $usdFreight;
        $usdFreightUnitCostWithMarkedUp = $usdFreightUnitCost * $usdFreightMarkUpRate;

        $prodUsdFreightedPrice = $prodDiscountedPrice + round(($usdFreightUnitCostWithMarkedUp), $roundingPrecision);


        $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? round(($otherCostTotal * $otherCostMarkupRate), $roundingPrecision) : 0;


        $subTotal = $prodUsdFreightedPrice + $otherCostMarkedUpPrice + ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice);
        $subTotalWithSetup = $subTotal;

        $total = $freightRate > 0 ? round(($subTotalWithSetup * $freightRate), $roundingPrecision) : $subTotalWithSetup;

        $grossProfit = $total - ($prodCostPrice + $usdFreightUnitCost + $decoCostPrice + $otherCostTotal);
        $grossProfitPercentage = $total ? round(($grossProfit / $total) * 100, 2) : 0;

        $arr['prodCostPrice'] = $prodCostPrice ?:'';
        $arr['lockSellPrice'] = $lockSellPrice;
        $arr['prodMarkupRate'] = $prodMarkupRate ?:$defaultMarkUpRate;
        $arr['prodDiscountedPrice'] = $prodDiscountedPrice ?:'';
        $arr['prodUsdFreightedPrice'] = $prodUsdFreightedPrice ?:'';

        $arr['subTotal'] = round($subTotal, $roundingPrecision) ?:'';
        $arr['subTotalWithSetup'] = round($subTotalWithSetup, $roundingPrecision) ?:'';
        $arr['total'] = round($total, $roundingPrecision) ?:'';
        $arr['lineTotal'] = round(($arr['total'] * $itmQty), $roundingPrecision) ?:'';
        $arr['quantity'] = $itmQty;
        $arr['usdFreightUnitCost'] = $usdFreightUnitCost ?:'';
        $arr['usdFreightUnitCostWithMarkedUp'] = $usdFreightUnitCostWithMarkedUp ?:'';

        $arr['totalDecoSupMarginMarkupPrice'] = $totalDecoSupMarginMarkupPrice ?:'';
        $arr['totalDecoLogosetupUnitMarkupPrice'] = $totalDecoLogosetupUnitMarkupPrice ?:'';
        $arr['decorationTotal'] = ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice) ?:'';

        $arr['otherCostMarkedUpPrice'] = $otherCostMarkedUpPrice ?:'';
        $arr['otherCostMarkedUpRate'] = $otherCostMarkupRate ?:$defaultMarkUpRate;

        $arr['totalCost'] = ($prodCostPrice + $usdFreightUnitCost + $decoCostPrice + $otherCostTotal) ?:'';
        $arr['grossProfitPercentage'] = $grossProfitPercentage ?:'';
        $arr['grossProfit'] = round($grossProfit, $roundingPrecision) ?:'';
        $arr['totalGrossProfit'] = $arr['grossProfit'] * $itmQty ?:'';


        echo json_encode($arr);
    }

    public function actionEditMultiDeco() {
        $id = $_POST['quoteDetailID'];

        echo json_encode(array('html' => $this->getEditMultiDecoHtml($id)));
    }

    private function getEditMultiDecoHtml($id) {
        $quoteProductDecoDetails = QuoteProductDecoration::model()->findAll(array('condition' => "quataiondetailsid = {$id}"));
        $html = "<table style='width=100%;'>";
        $html .= "<tr style='width=100%;background-color:#ccc;'><th style='width=20%;text-align:center;'>Code</th><th style='width=45%;text-align:center;'>Description</th><th style='width=25%;text-align:center;'>Unit Cost</th><th style='width=10%;text-align:center;'>&nbsp;</th></tr>";
        $html .= "<tr style='width=100%;display:none;'><td colspan='4'><input type='hidden' name='quoteDetailID' value='{$id}'/></td></tr>";
        foreach ($quoteProductDecoDetails as $data) {
            $supplierHtml = $data->supRel ? $data->supRel->getSupplierLink() : '';
            if (!$supplierHtml) {
                //set default supplier from decoration table
                $supplierHtml = ($data->decoRel ? $data->decoRel->getSupplierLink() : '');
            }

            $html .= "<tr id='editmultidecotr_{$data->id}' style='width=100%;border-bottom:1px solid #ccc;'>"
                    . "<td colspan='3'>"
                    . "<table style='width=100%;'>"
                    . "<tr style='width=100%;'>"
                    . "<td>{$data->decprtnam}</td>"
                    . "<td>"
                    . "<input style='width=200px;' type='text' name='QuoteProductDecoration[{$data->id}][decorationdescription]' value='{$data->decorationdescription}'/><br>"
                    . $supplierHtml
                    . "</td>"
                    . "<td><input style='width=120px;text-align:center;' type='text' name='QuoteProductDecoration[{$data->id}][decorationunitval]' value='{$data->decorationunitval}' /></td>"
                    . "</tr>"
                    . "<tr style='width=100%;'>"
                    . "<td>Logo Setup</td>"
                    . "<td><input class='editdeco-logosetupcharge' data-attr='{$data->id}' style='width=200px;' type='text' name='QuoteProductDecoration[{$data->id}][logosetupcharge]' value='{$data->logosetupcharge}' /></td>"
                    . "<td><input class='editdeco-logosetup-unit' data-attr='{$data->id}' style='width=120px;text-align:center;' type='text' name='QuoteProductDecoration[{$data->id}][logoSetupUnitCost]' value='{$data->logoSetupUnitCost}' readonly='true'/></td>"
                    . "</tr>"
                    . "<tr style='width=100%;'>"
                    . "<td colspan='3'>"
                    . "<table style='width=100%;'>"
                    . "<tr style='width=100%;'>"
                    . "<th style='text-align:center;'>Customisation Details</th>"
                    . "</tr>"
                    . "<tr style='width=100%;'>"
                    . "<td><textarea style='width:95%;' rows='1'  name='QuoteProductDecoration[{$data->id}][customization_detail]'>{$data->customization_detail}</textarea></td>"
                    . "</tr>"
                    . "</table>"
                    . "</td>"
                    . "</tr>"
                    . "</table>"
                    . "</td>"
                    . "<td>"
                    . "<table style='width: 100%;cursor: pointer;font-size:8pt;' onclick='deleteMultiDecoItem({$data->id});return false;'>
					<tr>
						<td style='width: 30%;'><span class='sodtlicon fa fa-trash-o'></span></td>
						<td>Delete Item</td>
					</tr>
					</table>
			  </td>"
                    . "</tr>";
        }

        $html .= "</table>";

        return $html;
    }

    public function actionSaveEditMultiDeco() {
        // $quoteProductDecoDetails = QuoteProductDecoration::model()->findAll(array('condition' => "quataiondetailsid = {$_POST['quoteDetailID']}"));

        $quoteDetail = QuatationDetails::model()->findByPk($_POST['quoteDetailID']);
        if (isset($_POST['QuoteProductDecoration'])) {
            $editedLineArr = $_POST['QuoteProductDecoration'];
            $existIds = array_keys($editedLineArr);

            $criteria = new CDbCriteria;
            $criteria->addCondition("quataiondetailsid = {$_POST['quoteDetailID']}");
            $criteria->addNotInCondition('id', $existIds);
            QuoteProductDecoration::model()->deleteAll($criteria);



            foreach ($editedLineArr as $key => $dtlline) {
                $quoteProductDecoDetail = QuoteProductDecoration::model()->findByPk($key);
                foreach ($dtlline as $field => $value) {
                    $quoteProductDecoDetail->$field = $value;
                }

                $quoteProductDecoDetail->save(false);
            }
        } else {
            $criteria = new CDbCriteria;
            $criteria->addCondition("quataiondetailsid = {$_POST['quoteDetailID']}");
            $criteria->addNotInCondition('id', $existIds);
            QuoteProductDecoration::model()->deleteAll($criteria);
        }

        if (isset($_POST['Decoration'])) {

            $addedDecoArr = $_POST['Decoration'];

            foreach ($addedDecoArr as $key => $decoLine) {
                $decoration = Decoration::model()->findByPk($key);

                $quoteProductDecoDetail = new QuoteProductDecoration();
                $quoteProductDecoDetail->quoteid = $quoteDetail->quoteid;
                $quoteProductDecoDetail->productsku = $quoteDetail->productsku;
                $quoteProductDecoDetail->quataiondetailsid = $quoteDetail->id;
                $quoteProductDecoDetail->ws_id = $quoteDetail->ws_id;
                $quoteProductDecoDetail->decprtnam = $decoration->decprtnam;

                $quoteProductDecoDetail->decorationqty = $quoteDetail->qty;
                $quoteProductDecoDetail->decorationdescription = $decoLine['decnam'];
                $quoteProductDecoDetail->decorationunitval = $decoLine['decuntprice'];
                $quoteProductDecoDetail->customization_detail = $decoLine['customization_detail'];

                $quoteProductDecoDetail->customerdicspcn = $quoteDetail->quotationRel->customer->cusdispcn;
                $quoteProductDecoDetail->maindecorationid = $decoration->decmaintypsno;
                $quoteProductDecoDetail->decorationvat = floatval(GlobalVars::get(GlobalVars::GST));
                $quoteProductDecoDetail->logosetupcharge = $decoration->declogo_setup_charges;
                $quoteProductDecoDetail->supref = $decoration->supplier ? $decoration->supplier->supsup_fref : null;
                $quoteProductDecoDetail->supmarg = $decoration->supplier ? $decoration->supplier->supmrate : null;
                $quoteProductDecoDetail->logoSetupMarkupRate = $decoration->logoSetupUnitMarkupRate;

                $quoteProductDecoDetail->save(false);
            }
        }

        $quoteDetail->refresh();

        echo json_encode(array('html' => $quoteDetail->getMultiDecoHtml()));
    }

    public function actionGetMultiDecoHtml() {
        
        $quoteDetail = QuatationDetails::model()->findByPk($_POST['quoteDetailID']);
         
         
         echo json_encode(array('html' => $quoteDetail->getMultiDecoHtml()));
    }

    public function actionGetMultiDecoLineHtml() {
        $decoarr = array_filter($_POST['decoIds']);
        $html = "";
        foreach ($decoarr as $key => $value) {
            $decoration = Decoration::model()->findByPk($value);

            $html .= "<tr id='temperydeco_{$value}' style='width=100%;border-bottom:1px solid #ccc;'>"
                    . "<td colspan='3'>"
                    . "<table style='width=100%;'>"
                    . "<tr style='width=100%;'>"
                    . "<td>{$decoration->decprtnam}</td>"
                    . "<td>"
                    . "<input style='width=200px;' type='text' name='Decoration[{$value}][decnam]' value='{$decoration->decnam}'/><br>"
                    . $decoration->getSupplierLink()
                    . "</td>"
                    . "<td><input style='width=120px;text-align:center;' type='text' name='Decoration[{$value}][decuntprice]' value='{$decoration->decuntprice}'/></td>"
                    . "</tr>"
                    . "<tr style='width=100%;'>"
                    . "<td>Logo Setup</td>"
                    . "<td><input style='width=200px;' type='text' value='{$decoration->declogo_setup_charges}' readonly='true'/></td>"
                    . "<td><input style='width=120px;text-align:center;' type='text'  value='0' readonly='true'/></td>"
                    . "</tr>"
                    . "<tr style='width=100%;'>"
                    . "<td colspan='3'>"
                    . "<table style='width=100%;'>"
                    . "<tr style='width=100%;'>"
                    . "<th style='text-align:center;'>Customisation Details</th>"
                    . "</tr>"
                    . "<tr style='width=100%;'>"
                    . "<td><textarea style='width:95%;' rows='1'  name='Decoration[{$value}][customization_detail]'></textarea></td>"
                    . "</tr>"
                    . "</table>"
                    . "</td>"
                    . "</tr>"
                    . "</table>"
                    . "</td>"
                    . "<td>"
                    . "<table style='width: 100%;cursor: pointer;font-size:8pt;' onclick='deleteTemporyDeco({$value});return false;'>
					<tr>
						<td style='width: 30%;'><span class='sodtlicon fa fa-trash-o'></span></td>
						<td>Delete Item</td>
					</tr>
					</table>
			  </td>"
                    . "</tr>";
        }

        echo json_encode(array('html' => $html));
    }

    public function actionGetNewMultiDecorationsHtml() {
        $decoString = $_POST['decoString'];
        $quantity = $_POST['qty'];

        $decorations = Decoration::model()->findAll(array('condition' => "decsno in ($decoString)"));

        $htmlNewDecoInputs = $this->getNewDocorationInputHtml($decorations);
        $htmlNewDecoDescriptions = $this->getNewDocorationDecsriptionHtml($decorations);


        echo json_encode(array('htmlNewDecoInputs' => $htmlNewDecoInputs, 'htmlNewDecoDescriptions' => $htmlNewDecoDescriptions));
    }

    private function getNewDocorationInputHtml($decorations) {
        $html = "";

        foreach ($decorations as $data) {
            $html .= "<input type='text'  name='QuoteProductDecoration[][decsno]' value='{$data->decsno}' />";
        }

        return $html;
    }

    private function getNewDocorationDecsriptionHtml($decorations) {
        $html = "<ul>";

        foreach ($decorations as $data) {
            $html .= "<li>{$data->decnam}</li>";
        }

        $html .= "</ul>";

        return $html;
    }

    public function actionGetAddNewMultiDecorationCalScreenHtml() {
        $decorationsPostArr = $_POST['QuoteProductDecoration'];
        //print_r($decorationsPostArr);
        //exit();
        $quantity = $_POST['QuatationDetails']['qty'];
//		$decoIdArr = array();
//		foreach ($decorationsPostArr as $key => $value) {
//			$decoIdArr[] = $value['decsno'];
//		}
//		$criteria = new CDbCriteria;
//		$criteria->addInCondition('decsno', $decoIdArr);
//		$decorations = Decoration::model()->findAll($criteria);
        echo json_encode(array('html' => $this->getAddNewMultiDecorationCalScreenHtml($decorationsPostArr, $quantity)));
    }

    private function getAddNewMultiDecorationCalScreenHtml($decorationsPostArr, $quantity) {
        $html = "<table style='width:100%;'>";
        $html .= "<tr style='width:100%;'>";
        $html .= "<th style='width: 5%;text-align:center;'>No</th>";
        $html .= "<th style='width: 30%;text-align:center;'>Code</th>";
        $html .= "<th style='width: 20%;text-align:center;'>Unit Price</th>";
        $html .= "<th style='width: 25%;text-align:center;'>Mark-Up</th>";
        $html .= "<th style='width: 20%;text-align:center;'>Marked-Up Price</th>";
        $html .= "</tr>";
        $html .= "<tbody>";

        $count = 0;

        $decorationTotal = 0;
        $defaultMarkupRate = GlobalVars::get(GlobalVars::GST) ?:'';
        foreach ($decorationsPostArr as $key => $value) {
            $data = Decoration::model()->findByPk($value['decsno']);

            if (isset($value['decprtnam'])) {
                //already added deco to calscreen
                $decoCalArr = QuoteProductDecoration::getAddNewDecorationCalculations(
                                array(
                                    'decorationunitval' => $value['decorationunitval'] ?:'',
                                    'supmarg' => $value['supmarg'] ?: $defaultMarkupRate,
                                    'logosetupcharge' => $value['logosetupcharge'] ?:'',
                                    'decorationqty' => $quantity,
                                    'logoSetupMarkupRate' => $value['logoSetupMarkupRate'] ?: $defaultMarkupRate
                ));
            } else {

                $decoCalArr = QuoteProductDecoration::getAddNewDecorationCalculations(
                                array(
                                    'decorationunitval' => $data->decuntprice ?:'',
                                    'supmarg' => ($data->supplier ? ($data->supplier->supmrate?: $defaultMarkupRate) : $defaultMarkupRate),
                                    'logosetupcharge' => $data->declogo_setup_charges,
                                    'decorationqty' => $quantity,
                                    'logoSetupMarkupRate' => ($data->logoSetupUnitMarkupRate ?: $defaultMarkupRate)
                ));
            }

            $supplierHtml = $data->supplier ? $data->supplier->getSupplierLink() : '';

            $decorationTotal += $decoCalArr['supmargMarkedUpPrice'] + $decoCalArr['logoSetupUnitCostWithMarkup'];
            $supmargPercentage = $this->getMarginOutOfMarkupMultiplier($decoCalArr['supmarg']) ?: $defaultMarkupRate;
            $logoSetupMarkupPercentage = $this->getMarginOutOfMarkupMultiplier($decoCalArr['logoSetupMarkupRate']) ?: $defaultMarkupRate;

            $html .= "<tr style='width:100%;border-bottom:1px solid #eee;'>";
            $html .= "<td style='width:5%;'>" . ($count + 1) . "</td>";
            $html .= "<td   colspan='4'>";
            $html .= "<table style='width:100%;'>";

            $html .= "<tr style='width:100%;'>";
            $html .= "<td style='width: 35%;'><input type='hidden' name='QuoteProductDecoration[{$count}][decprtnam]' value='{$data->decprtnam}' /><div style='font-size:8.5pt;'>{$data->decprtnam}</div><div style='font-size:7.5pt;'>{$data->decnam}</div><div style='font-size:8.5pt;'>{$supplierHtml}</div></td>";
            $html .= "<td style='width:20%;text-align:right;'><input placeholder='0.00' type='text' name='QuoteProductDecoration[{$count}][decorationunitval]' value='{$decoCalArr['decorationunitval']}' style='width:90%;text-align:center;'/></td>";
            $html .= "<td style='width: 20%;text-align:right;'>"
                    . "<input placeholder='0.00' title='rate' mark-up='rate' type='text' name='QuoteProductDecoration[{$count}][supmarg]' value='{$decoCalArr['supmarg']}' style='width:30%;text-align:center;margin-right:2px;'/>"
                    . "<input placeholder='0.00' title='percentage(%)' mark-up='percentage'  type='text'  style='text-align: center;width: 30%;' name='QuoteProductDecoration[{$count}][supmargPercentage]' value='{$supmargPercentage}' />  (%)"
                    . "</td>";
            $html .= "<td style='width: 20%;text-align:right;'><input placeholder='0.00' type='text' name='QuoteProductDecoration[{$count}][supmargMarkedUpPrice]' value='{$decoCalArr['supmargMarkedUpPrice']}' readonly='true' style='width:90%;text-align:right;'/></td>";
            $html .= "</tr>";
            $html .= "<tr style='width:100%;'>";
            $html .= "<td style='width:35%;'>LogoSetup : <input placeholder='0.00' type='text' name='QuoteProductDecoration[{$count}][logosetupcharge]' value='{$decoCalArr['logosetupcharge']}' style='width:40%;text-align:center;'/></td>";
            $html .= "<td style='width: 20%;text-align:right;'><input placeholder='0.00' type='text' name='QuoteProductDecoration[{$count}][logoSetupUnitCost]' value='{$decoCalArr['logoSetupUnitCost']}' style='width:90%;text-align:center;'/></td>";
            $html .= "<td style='width: 20%;text-align:right;'>"
                    . "<input placeholder='0.00' title='rate' mark-up='rate' type='text' name='QuoteProductDecoration[{$count}][logoSetupMarkupRate]' value='{$decoCalArr['logoSetupMarkupRate']}' style='width:30%;text-align:center;margin-right:2px;'/>"
                    . "<input placeholder='0.00' title='percentage(%)' mark-up='percentage'  type='text'  style='text-align: center;width: 30%;' name='QuoteProductDecoration[{$count}][logoSetupMarkupPercentage]' value='{$logoSetupMarkupPercentage}' />  (%)"
                    . "</td>";
            $html .= "<td style='width: 20%;text-align:right;'><input placeholder='0.00' type='text' name='QuoteProductDecoration[{$count}][logoSetupUnitCostWithMarkup]' value='{$decoCalArr['logoSetupUnitCostWithMarkup']}' readonly='true' style='width:90%;text-align:right;' /></td>";
            $html .= "</tr>";

            $html .= "</table>";
            $html .= "</td>";
            $html .= "</tr>";

            $count++;
        }



        $html .= "<tr style='width:100%;'>";
        $html .= "<td colspan='4' style='text-align:right;'>Decoration Total : </td><td><input placeholder='0.00' name='addnew_decoration_total'  id='addnew_decoration_total' type='text' value='{$decorationTotal}' readonly='true' style='width:90%;text-align:right;' /></td>";
        $html .= "</tr>";

        $html .= "</tbody>";
        $html .= "</table>";

        return $html;
    }

    public function actionAddDecorationToEditCalscreen() {
        $quoteDetailId = $_POST['quoteDtlId'];
        $decorationArr = $_POST['decoIds'];

        $quoteDetail = QuatationDetails::model()->findByPk($quoteDetailId);

        $savedArr = array();
        foreach ($decorationArr as $key => $decoId) {
            $decoration = Decoration::model()->findByPk($decoId);

            $quoteProductDecoDetail = new QuoteProductDecoration();
            $quoteProductDecoDetail->quoteid = $quoteDetail->quoteid;
            $quoteProductDecoDetail->productsku = $quoteDetail->productsku;
            $quoteProductDecoDetail->quataiondetailsid = $quoteDetail->id;
            $quoteProductDecoDetail->ws_id = $quoteDetail->ws_id;
            $quoteProductDecoDetail->decprtnam = $decoration->decprtnam;

            $quoteProductDecoDetail->decorationqty = $quoteDetail->qty;
            $quoteProductDecoDetail->decorationdescription = $decoration->decnam;
            $quoteProductDecoDetail->decorationunitval = $decoration->decuntprice;
            $quoteProductDecoDetail->customization_detail = $decoration->decnam;

            $quoteProductDecoDetail->customerdicspcn = $quoteDetail->quotationRel->customer->cusdispcn;
            $quoteProductDecoDetail->maindecorationid = $decoration->decmaintypsno;
            $quoteProductDecoDetail->decorationvat = floatval(GlobalVars::get(GlobalVars::GST));
            $quoteProductDecoDetail->logosetupcharge = $decoration->declogo_setup_charges;
            $quoteProductDecoDetail->supref = $decoration->supplier ? $decoration->supplier->supsup_fref : null;
            $quoteProductDecoDetail->supmarg = $decoration->supplier ? $decoration->supplier->supmrate : null;
            $quoteProductDecoDetail->logoSetupMarkupRate = $decoration->logoSetupUnitMarkupRate;


            if ($quoteProductDecoDetail->save(false)) {
                $savedArr[] = 1;
                SalesLog::jsonLog(
                        array(
                            'quoteId' => $quoteDetail->quoteid,
                            'workorderId' => null,
                            'quoteNum' => $quoteDetail->quotationRel->quoteno,
                            'category' => 'Quotation',
                            'comments' => "Decoration [{$decoration->decnam}] has been added to the quote detail of [{$quoteDetail->quotationRel->quoteno}][{$quoteDetail->productsku}]",
                            'json_record' => '',
                            'isIntrnl' => 1,
                            'isExtrnl' => 1,
                            'isTechnical' => 1
                        )
                );
            }
        }

        if ($savedArr) {
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => false));
        }
    }

    public function actionDeleteDecoratoinFromEditCalscreen() {
        $quoteDetailId = $_POST['quoteDtlId'];
        $quoteProductDecoId = $_POST['quoteProductDecoId'];

        $quoteProductDecoration = QuoteProductDecoration::model()->find(array('condition' => "id = {$quoteProductDecoId} AND quataiondetailsid = {$quoteDetailId}"));
        $quote = Quatation::model()->findByPk($quoteProductDecoration->quoteid);
        
        $commit = "Decoration [{$quoteProductDecoration->decorationdescription}] has been deleted from the quote detail of [{$quote->quoteno}][{$quoteProductDecoration->productsku}]";
        $deleted = 0;
        if ($quoteProductDecoration) {
            if ($deleted = $quoteProductDecoration->delete()) {
                SalesLog::jsonLog(
                        array(
                            'quoteId' => $quote->id,
                            'workorderId' => null,
                            'quoteNum' => $quote->quoteno,
                            'category' => 'Quotation',
                            'comments' => $commit,
                            'json_record' => '',
                            'isIntrnl' => 1,
                            'isExtrnl' => 1,
                            'isTechnical' => 1
                        )
                );
            }
        }
        
        if ($deleted) {
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => false));
        }
    }

    public function actionDoMarginPlayingCalForProductCost() {

        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }

        $isSellPriceLocked = boolval($_POST['aFLockSellPrice']);

        $freightRate = floatval($_POST['af_freight_rate']);

        $productCost = floatval($_POST['af_edit_cost_price']);

        $usdFreight = floatval($_POST['af_usd_freight']);
        $usdFreightUnitPrice = floatval($_POST['af_usd_freight_unit_cost']);
        $usdFreightMarkedUpRate = floatval($_POST['af_usd_freight_markup_rate']);

        $subTotalWithSetupUnit = floatval($_POST['af_edit_subtotal_with_setup']);


        $decorationTotal = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['af_edit_decoration_total']) : 0; //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO

        $otherCostTotal = floatval($_POST['af_edit_othercost_total']);
        $otherCostMarkupRate = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['af_edit_othercost_markup_rate']) : 0;  //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        $otherCostTotalMarkedUp = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['af_edit_othercost_markedup_price']) : 0; //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        //$setupUnitPrice = $_POST['af_unit_setup_charge'];



        $itemQty = intval($_POST['af_edit_itm_qty']);
        $discountPercentage = floatval($_POST['af_discount_percntg']);
        $prodcutCostMarkedUp = floatval($_POST['af_edit_prd_markup']);


        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;


        $decoCostPrice = 0;
        if (isset($_POST['QuoteProductDecoration'])) {
            $editedLineArr = $_POST['QuoteProductDecoration'];
            foreach ($editedLineArr as $key => $value) {

                $quoteDetailDeco = QuoteProductDecoration::model()->findByPk($key);
                $decoCalArr = $quoteDetailDeco->getDecorationCalculations(
                        array(
                            'decorationunitval' => $value['decorationunitval'],
                            'supmarg' => ( ($subTotalWithSetupUnit && $productCost) ? $value['supmarg'] : 0), //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO  //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
                            'logosetupcharge' => $value['logosetupcharge'],
                            'decorationqty' => $itemQty,
                            'logoSetupMarkupRate' => ( ($subTotalWithSetupUnit && $productCost) ? $value['logoSetupMarkupRate'] : 0) //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO  //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
                ));


                $arr['multiDecoLines'][] = array(
                    "QuoteProductDecoration[$key][supmarg]" => ( ($subTotalWithSetupUnit && $productCost) ? $value['supmarg'] : 0),
                    "QuoteProductDecoration[$key][supmargMarkedUpPrice]" => $decoCalArr['supmargMarkedUpPrice'],
                    "QuoteProductDecoration[$key][logoSetupUnitCost]" => $decoCalArr['logoSetupUnitCost'],
                    "QuoteProductDecoration[$key][logoSetupMarkupRate]" => ( ($subTotalWithSetupUnit && $productCost) ? $value['logoSetupMarkupRate'] : 0),
                    "QuoteProductDecoration[$key][logoSetupUnitCostWithMarkup]" => $decoCalArr['logoSetupUnitCostWithMarkup'],
                );


                $decoCostPrice += ($value['decorationunitval'] + $decoCalArr['logoSetupUnitCost']);
                $totalDecoSupMarginMarkupPrice += $decoCalArr['supmargMarkedUpPrice'];
                $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logoSetupUnitCostWithMarkup'];
            }
        }




        if ($subTotalWithSetupUnit && $productCost) {

        $t = $subTotalWithSetupUnit - ($decorationTotal + $otherCostTotalMarkedUp); //total product price
        $mk_d = $t - ($usdFreight ? (round(($usdFreight / $itemQty), $roundingPrecision) * $usdFreightMarkedUpRate) : 0); // marked up + discount without usd freight cost

        /*
         * Equation to find product cost price
         * c = product cost price
         * m = product cost marked up price + discount
         * r = product cost  marked up rate
         * d = discount percentage
         * 
         * c = m * 100 / r * (100 - d) 
         * 
         * Equation for product markup rate
         * 
         * r = ( ( m * 100 ) / c) / (100 - d)
         */

            $prodcutCostMarkUpRate = round(((round(( $productCost ? ( ( $mk_d * 100) / $productCost ) : 0), 2)) / ( (100 - $discountPercentage) ? (100 - $discountPercentage) : 100 )), 4);
        }

        //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO
        //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        if (!$subTotalWithSetupUnit || !$productCost) {
            $prodcutCostMarkUpRate = 0;
            $usdFreightMarkedUpRate = 0;
            $discountPercentage = 0;
        }

        $prodcutCostMarkedUp = $productCost * $prodcutCostMarkUpRate;
        $prodcutCostMarkedUpWithDiscount = $prodcutCostMarkedUp * (100 - $discountPercentage) / 100;

        //$productSectionTotal = $prodcutCostMarkedUpWithDiscount + (round(($usdFreight / $itemQty), $roundingPrecision));

        $productCostMarkupPercentage = $this->getMarginOutOfMarkupMultiplier($prodcutCostMarkUpRate);
        $subTotal = $subTotalWithSetupUnit;
        $grandTotal = $freightRate ? round(($subTotalWithSetupUnit * $freightRate), $roundingPrecision) : $subTotalWithSetupUnit;

        $grossProfit = $subTotal - ($productCost + $usdFreightUnitPrice + $decoCostPrice + $otherCostTotal);
        $grossProfitPercentage = $subTotal ? round(($grossProfit / $subTotal) * 100, 2) : 0;

        $arr['product_total'] = round($t, $roundingPrecision);
        $arr['discounted_price'] = round($mk_d, $roundingPrecision);
        $arr['product_cost_markup_rate'] = $prodcutCostMarkUpRate;
        $arr['productCostMarkupPercentage'] = $productCostMarkupPercentage;
        $arr['product_cost_markedup_with_discount'] = round($prodcutCostMarkedUpWithDiscount, 2);
        $arr['product_section_total'] = round($t, 2);
        $arr['subTotal'] = round($subTotal, 2);
        $arr['sub_total_with_setup_unit'] = round($subTotalWithSetupUnit, 2);
        $arr['grand_total'] = $grandTotal;
        $arr['decoCostTotal'] = $decoCostPrice;
        $arr['lineTotal'] = round(($grandTotal * $itemQty), 2);
        $arr['decorationTotal'] = ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice) ?: $decorationTotal;
        $arr['grossProfitPercentage'] = $grossProfitPercentage;
        $arr['grossProfit'] = $grossProfit;
        $arr['totalGrossProfit'] = $grossProfit * $itemQty;
        echo json_encode($arr);
    }

    public function actionDoAddNewMarginPlayingCalForProductCost() {

        $arr = array();
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }

        //$grandTotalWithFreight = $_POST['adnew_edit_total'];
        $freightRate = floatval($_POST['adnew_freight_rate']);

        $productCost = floatval($_POST['adnew_cost_price']);

        $usdFreight = floatval($_POST['adnew_usd_freight']);
        $usdFreightUnitPrice = floatval($_POST['adnew_usd_freight_unit_cost']);
        $usdFreightMarkedUpRate = floatval($_POST['adnew_usd_freight_markup_rate']);

        $subTotalWithSetupUnit = floatval($_POST['adnew_edit_subtotal_with_setup']);


        $decorationTotal = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['addnew_decoration_total']) : 0; //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO

        $otherCostTotal = floatval($_POST['adnew_othercost_total']);
        $otherCostMarkupRate = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['adnew_edit_othercost_markup_rate']) : 0;  //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        $otherCostTotalMarkedUp = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['adnew_edit_othercost_markedup_price']) : 0; //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        //$setupUnitPrice = $_POST['adnew_unit_setup_charge'];


        $itemQty = intval($_POST['adnew_edit_itm_qty']);
        $discountPercentage = floatval($_POST['adnew_discount_percntg']);
        //$prodcutCostMarkedUp = $_POST['adnew_prd_markup'];
        //$freightRate = $_POST['adnew_freight_rate'];
        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;

        $decoCostPrice = 0;
        if (isset($_POST['QuoteProductDecoration'])) {
            $addNewLineArr = $_POST['QuoteProductDecoration'];
            foreach ($addNewLineArr as $key => $value) {


                $decoCalArr = QuoteProductDecoration::getAddNewDecorationCalculations(
                                array(
                                    'decorationunitval' => $value['decorationunitval'],
                                    'supmarg' => ( ($subTotalWithSetupUnit && $productCost) ? $value['supmarg'] : 0), //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO  //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
                                    'logosetupcharge' => $value['logosetupcharge'],
                                    'decorationqty' => $itemQty,
                                    'logoSetupMarkupRate' => ( ($subTotalWithSetupUnit && $productCost) ? $value['logoSetupMarkupRate'] : 0) //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO  //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
                ));


                $arr['multiDecoLines'][] = array(
                    "QuoteProductDecoration[$key][supmarg]" => ( ($subTotalWithSetupUnit && $productCost) ? $value['supmarg'] : 0),
                    "QuoteProductDecoration[$key][supmargMarkedUpPrice]" => $decoCalArr['supmargMarkedUpPrice'],
                    "QuoteProductDecoration[$key][logoSetupUnitCost]" => $decoCalArr['logoSetupUnitCost'],
                    "QuoteProductDecoration[$key][logoSetupMarkupRate]" => ( ($subTotalWithSetupUnit && $productCost) ? $value['logoSetupMarkupRate'] : 0),
                    "QuoteProductDecoration[$key][logoSetupUnitCostWithMarkup]" => $decoCalArr['logoSetupUnitCostWithMarkup'],
                );

                $decoCostPrice += ($value['decorationunitval'] + $decoCalArr['logoSetupUnitCost']);
                $totalDecoSupMarginMarkupPrice += $decoCalArr['supmargMarkedUpPrice'];
                $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logoSetupUnitCostWithMarkup'];
            }
        }

        if ($subTotalWithSetupUnit && $productCost) {
            
        $t = $subTotalWithSetupUnit - ($decorationTotal + $otherCostTotalMarkedUp); //total product price
        $mk_d = $t - ($usdFreight ? (round(($usdFreight / $itemQty), $roundingPrecision) * $usdFreightMarkedUpRate) : 0); // marked up + discount without usd freight cost

        /*
         * Equation to find product cost price
         * c = product cost price
         * m = product cost marked up price + discount
         * r = product cost  marked up rate
         * d = discount percentage
         * 
         * c = m * 100 / r * (100 - d) 
         * 
         * Equation for product markup rate
         * 
         * r = ( ( m * 100 ) / c) / (100 - d)
         * 
         */

        $prodcutCostMarkUpRate = $productCost ? round(((round((( $mk_d * 100) / $productCost), 2)) / ( 100 - $discountPercentage)), 4) : 0;
        }

        //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO
        //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        if (!$subTotalWithSetupUnit || !$productCost) {
            $prodcutCostMarkUpRate = 0;
            $usdFreightMarkedUpRate = 0;
            $discountPercentage = 0;
        }

        $prodcutCostMarkedUp = $productCost * $prodcutCostMarkUpRate;
        $prodcutCostMarkedUpWithDiscount = $prodcutCostMarkedUp * (100 - $discountPercentage) / 100;

        //$productSectionTotal = $prodcutCostMarkedUpWithDiscount + (round(($usdFreight / $itemQty), $roundingPrecision));

        $productCostMarkupPercentage = $this->getMarginOutOfMarkupMultiplier($prodcutCostMarkUpRate);
        $subTotal = $subTotalWithSetupUnit;
        $grandTotal = $freightRate ? round(($subTotalWithSetupUnit * $freightRate), $roundingPrecision) : $subTotalWithSetupUnit;

        $grossProfit = $subTotal - ($productCost + $usdFreightUnitPrice + $decoCostPrice + $otherCostTotal);
        $grossProfitPercentage = $subTotal ? round(($grossProfit / $subTotal) * 100, 2) : 0;


        $arr['product_total'] = round($t, $roundingPrecision);
        $arr['discounted_price'] = round($mk_d, $roundingPrecision);
        $arr['product_cost_markup_rate'] = $prodcutCostMarkUpRate;
        $arr['productCostMarkupPercentage'] = $productCostMarkupPercentage;
        $arr['product_cost_markedup_with_discount'] = round($prodcutCostMarkedUpWithDiscount, 2);
        $arr['product_section_total'] = round($t, 2);
        $arr['subTotal'] = round($subTotal, 2);
        $arr['sub_total_with_setup_unit'] = round($subTotalWithSetupUnit, 2);
        $arr['grand_total'] = $grandTotal;
        $arr['decoCostTotal'] = $decoCostPrice;
        $arr['lineTotal'] = round(($grandTotal * $itemQty), 2);
        $arr['decorationTotal'] = ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice) ?: $decorationTotal;
        $arr['grossProfitPercentage'] = $grossProfitPercentage;
        $arr['grossProfit'] = $grossProfit;
        $arr['totalGrossProfit'] = $grossProfit * $itemQty;
        echo json_encode($arr);
    }

    /**
     * Update image via ajax
     * 
     * @param file QuatationDetails[image] image stream
     * @param integer QuatationDetails[id] id of the detail
     * 
     * @return array json
     */
    public function actionUpdateImage() {



        $model = $this->loadModel($_POST['QuatationDetails']['id']);
        if (!$model) {
            throw new Exception('Active record not found exception!', 400);
            exit();
        }
        $model->productimg = $_POST['QuatationDetails']['productimg'];



        $uploadImageFile = CUploadedFile::getInstance($model, 'productimg');





        $renameImage = time() . '.' . $uploadImageFile->getExtensionName();

        if ($uploadImageFile->saveAs('images/product_img/' . $renameImage)) {
            $model->productimg = $renameImage;
            $model->save(false);
            echo json_encode(array('status' => true, 'image_file' => 'images/product_img/' . $renameImage));
            exit();
        }

        throw new Exception('Cannot update image!', 304);
        exit();
    }

    public function actionAddDetailsFromQuoteItems() {
        if (isset($_POST['quoteId']) && isset($_POST['quoteDetailId'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $originalQuoteDetail = QuatationDetails::model()->findByPk($_POST['quoteDetailId']);
            $masterQuote = Quatation::model()->findByPk($_POST['quoteId']);
            $quoteNumber = $masterQuote->quoteno;
            $quoteDetail = QuatationDetails::createItemCopy($_POST['quoteId'], $_POST['quoteDetailId']);

            if ($quoteDetail) {
                $transaction->commit();


                SalesLog::createSalesLog($masterQuote->id, null, $quoteNumber, 'Quotation', "New quote details is added to quote ({$quoteNumber}) from quote {$quoteDetail->quotationRel->quoteno}", 1, 0, 1);

                echo $quoteDetail->getHtmlRow();
            } else {
                $transaction->rollback();
            }
        }
    }

    public function actionFetchPriceLookupHtml() {

        if (isset($_POST['quoteDetailId']) && $quoteDetailId = $_POST['quoteDetailId']) {
            $model = $this->loadModel($quoteDetailId);
            if ($model->product_source == ProductLine::PRODUCT_SOURCE_GWS_API) {
                $postFields = GwsProductApi::getDefaultPostFields();
                $postFields['data'] = array(
                    'supplier' => '',
                    'product_code' => $model->productsku,
                    'product_Name' => '',
                    'category' => ''
                );
                
                $apiProductData = GwsProductApi::productData($postFields);
                $html = GwsProductApi::extractPriceBreaksIntoTable($apiProductData[0]);
            } else  {
                //ProductLine::PRODUCT_SOURCE_LOCAL_DB
                $html = $model->productRel->getHtmlPriceLookUpCalScreen();
            }

            echo json_encode(array('html' => $html, 'productCode' => $model->productsku));
        } else if (isset($_POST['productCode']) && $productCode = $_POST['productCode']) {
            //check product code already available
            $productLine = ProductLine::model()->find("pdlpdl = '{$productCode}'");
            //for new cal screen
            if (
                    ($productLine && $productLine->product_source == ProductLine::PRODUCT_SOURCE_GWS_API) 
                    || (isset($_POST['productSource']) && $_POST['productSource'] == ProductLine::PRODUCT_SOURCE_GWS_API)
                    ) {
                $postFields = GwsProductApi::getDefaultPostFields();
                $postFields['data'] = array(
                    'supplier' => '',
                    'product_code' => $productCode,
                    'product_Name' => '',
                    'category' => ''
                );
                
                $apiProductData = GwsProductApi::productData($postFields);
                $html = GwsProductApi::extractPriceBreaksIntoTable($apiProductData[0]);
            } else {
                //$productLine = ProductLine::model()->find("pdlpdl = '{$productCode}'");
                $html = $productLine->getHtmlPriceLookUpCalScreen();
            }
            
            echo json_encode(array('html' => $html, 'productCode' => $productCode));
        }
    }

    public function actionUpdateByAtrribute() {
        $id = $_POST['id'];
        $attribute = $_POST['attr'];
        $attrVal = $_POST['attrVal'];

        $model = $this->loadModel($id);
        $model->{$attribute} = $attrVal;
        if ($model->save()) {
            echo json_encode(array('status' => true));
        } else {
            echo json_encode(array('status' => false));
}
    }

    public function actionFetchDetailFlags() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);

        $flags = array();

        if ($model->hide_on_pdf) {

            //send flags which have value

            $flags[] = 'hide_on_pdf';
        }



        echo json_encode(array('flags' => $flags));
    }
    
    public function actionUpdateDetailFlags() {
        $id = $_POST['id'];
        //whatever available here that means those attributes have been selected
        $flags = isset($_POST['flags']) ? $_POST['flags'] : array();
        $offFlags = isset($_POST['offFlags']) ? $_POST['offFlags'] : array();

        $model = $this->loadModel($id);
       
        //set new flags from the front-end updated options
        
        foreach ($flags as $attr) {

            $model->$attr = 1;
        }
        
        //turn off if there is no flags
        foreach ($offFlags as $attr) {

            $model->$attr = 0;
        }

        if ($model->save()) {
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => false));
        }
    }
    
    public function actionOnFlagsLabelsHtml() {
        $id = $_POST['id'];
        $model = $this->loadModel($id);

        $html = $model->getOnFlagsLabelsHtml();
        
        

        echo json_encode(array('html' => $html));
    }

}
