<?php

class QuoteAcceptController extends Controller
{

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		array(
			'allow', // allow admin user to perform 'admin' and 'delete' actions
			'actions' => array('index', 'onlineAccept', 'checkout', 'paypalCheckout'),
			'users' => array('*'),
		);
	}

	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column2';

	public function actionIndex($id)
	{
		$onlineAcceptenceLog = QuoteOnlineAcceptenceLog::getLogBySecret($id);

		//check if the scecret exist
		if (!$onlineAcceptenceLog) {
			$this->render('error');
			exit;
		}

		//check if the link is still active		
		if ($onlineAcceptenceLog && in_array($onlineAcceptenceLog->link_active, array(QuoteOnlineAcceptenceLog::LINK_STATUS_INACTIVE))) {
			$this->render('error');
			exit;
		}


		if ($quoteId = QuoteOnlineAcceptenceLog::validateLinkSecret($id)) {

			$quote = Quatation::model()->findByPk($quoteId);
			$quote_template = $this->renderInternal('protected/views/quoteAccept/quote_template.php', array('model' => $quote), true);
			$this->render('index', array(
				'quote' => $quote,
				'quote_template' => $quote_template
			));
			exit;
		}


		if ($onlineAcceptenceLog->enable_pay_later) {

			$checkoutMode = isset($_GET['payment']) ? htmlspecialchars(trim($_GET['payment'])) : null;



			if ($checkoutMode && $checkoutMode == 'paylater') {

				$onlineAcceptenceLog->status_id = QuoteOnlineAcceptenceLog::LOG_STATUS_PAY_LATER;
				$onlineAcceptenceLog->save(false);

				$quote = Quatation::model()->findByPk($onlineAcceptenceLog->quote_id);

				SalesLog::createSalesLog($quote->id, null, $quote->quoteno, SalesLog::CATEGORY_QUOTATION, "Customer has decided to pay later via online acceptance.", 1, 0, 1);

				$quote_template = $this->renderInternal('protected/views/quoteAccept/quote_template_checkout.php', array('model' => $quote), true);
				$this->render('paylater', array(
					'quote' => $quote,
					'quote_template' => $quote_template
				));
				exit;
			}
		}

		if ($quoteId = QuoteOnlineAcceptenceLog::validateLinkSecretForCheckOut($id)) {
			$quote = Quatation::model()->findByPk($quoteId);
			$quote_template = $this->renderInternal('protected/views/quoteAccept/quote_template_checkout.php', array('model' => $quote), true);
			$this->render('checkout', array(
				'quote' => $quote,
				'quote_template' => $quote_template
			));
			exit;
		}



		//if no condition met show error page
		$this->render('error');
	}

	public function actionOnlineAccept()
	{



		if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
			//check acceptance secert validaion
			$acceptType = $_POST['accepttype'];
			$linkSecret = $_POST['linkSecret'];
			$comment = $_POST['comment'];
			if ($quoteId = QuoteOnlineAcceptenceLog::validateLinkSecret($linkSecret)) {

				$transaction = Yii::app()->db->beginTransaction();

				$quotation = Quatation::model()->findByPk($quoteId);

				if (intval($acceptType) == QuoteOnlineAcceptenceLog::LOG_STATUS_ACCEPT) {
					//extract selected quantity breaks when accepting the quote
					//variable to hold form data query string
					$formData = null;
					//parse query string to  $formData as array
					parse_str($_POST['formData'], $formData);
					foreach ($formData['QuatationDetails']['qtybrk'] as $quoteDetailId => $qtyBrk) {
						$quoteDetail = QuatationDetails::model()->findByPk($quoteDetailId);
						if ($quoteDetail) {
							$quoteDetail->customer_accepted = 1;
							if ($quoteDetail->save(false)) {
								$comment .= '<br/>[ product : ' . $quoteDetail->productsku . ' x ' . $quoteDetail->qty . ' Qty ] is accepted.';
							}
						}
					}
				}


				//create new acceptace log
				//$lastAcceptLogAttributes = $quotation->onlineAcceptenceLog->attributes;

				//$lastAcceptLogAttributes['link_active'] = QuoteOnlineAcceptenceLog::LINK_STATUS_INACTIVE;

				$acceptTypeMessageOnSuccess = '';
				$acceptTypeMessageOnFail = '';
				switch (intval($acceptType)) {
					case QuoteOnlineAcceptenceLog::LOG_STATUS_ACCEPT:
						$quotation->onlineAcceptenceLog->status_id  = QuoteOnlineAcceptenceLog::LOG_STATUS_ACCEPT;

						$acceptTypeMessageOnSuccess = 'Online Quote Accepted!';
						$acceptTypeMessageOnFail = 'Online quote Acceptance failed! Please contact admin or try again later!';
						break;

					case QuoteOnlineAcceptenceLog::LOG_STATUS_DECLINE:
						$quotation->onlineAcceptenceLog->link_active = QuoteOnlineAcceptenceLog::LINK_STATUS_INACTIVE;
						$quotation->onlineAcceptenceLog->status_id = QuoteOnlineAcceptenceLog::LOG_STATUS_DECLINE;
						$acceptTypeMessageOnSuccess = 'Online Quote Declined!';
						$acceptTypeMessageOnFail = 'Online quote decline failed! Please contact admin or try again later!';

						break;
				}


				$quotation->onlineAcceptenceLog->cutomer_comment = $comment;

				$quotation->onlineAcceptenceLog->user_data = json_encode($_SERVER);

				$quotation->onlineAcceptenceLog->save(false);

				//diasable all other logs' links related this quote

				//QuoteOnlineAcceptenceLog::dasableAllLinks($quotation->id);

				//set follow-up and system status based on the acceptance status
				$quotation->updateFollowUpStatusByOnlineAcceptance(intval($acceptType));
				SalesLog::addFollowUp(array(
					'category' => SalesLog::CATEGORY_QUOTATION,
					'tbl_id' => $quotation->id,
					'followupSts_id' => $quotation->followupStatus
				));


				if ($quotation->save(false)) {

					SalesLog::createSalesLog($quotation->id, null, $quotation->quoteno, SalesLog::CATEGORY_QUOTATION, $acceptTypeMessageOnSuccess, 1, 0, 1);

					$transaction->commit();
					//response array
					echo json_encode(array(
						'status' => 1, //success
						'message' => $acceptTypeMessageOnSuccess,
						'linkSecret' => $linkSecret,
						'quoteId' => $quotation->id
					));
				} else {
					$transaction->rollback();
					//response array
					echo json_encode(array(
						'status' => 0, //failed
						'message' => $acceptTypeMessageOnFail
					));
				}
			} else {
				//response array
				echo json_encode(array(
					'status' => 0, //failed
					'message' => 'The request is not validated! Please don\'t repeat this request again!'
				));
			}
		} else {
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
		}
	}


	public function actionCheckout($id)
	{
		if ($quoteId = QuoteOnlineAcceptenceLog::validateLinkSecret($id)) {
			$quote = Quatation::model()->findByPk($quoteId);
			$quote_template = $this->renderInternal('protected/views/quoteAccept/quote_template.php', array('model' => $quote), true);
			$this->render('checkout', array(
				'quote' => $quote,
				'quote_template' => $quote_template
			));
		} else {
			$this->render('error');
		}
	}

	/*
     * this will receive the paypal response object with other customised details
     */

	public function actionPaypalCheckout()
	{
		$response = array();
		$secret = $_POST['quoteLinkSecret'];
		$paypalResponseArr = $_POST['paypalResponseJson'];
		$acceptanceLog = QuoteOnlineAcceptenceLog::getLogBySecret($secret);
		$quotation = Quatation::model()->findByPk($acceptanceLog->quote_id);
		//first check whether the paypal trasaction was success and keep the record

		if (in_array($paypalResponseArr['status'], array('COMPLETED', 'CREATED', 'SAVED', 'APPROVED', 'VOIDED', 'PAYER_ACTION_REQUIRED'))) {

			//payment was success and disable the link
			$acceptanceLog->link_active = QuoteOnlineAcceptenceLog::LINK_STATUS_INACTIVE;
			$acceptanceLog->status_id = QuoteOnlineAcceptenceLog::LOG_STATUS_PAID;
			$acceptanceLog->save(false);

			//keep payment records
			$paypalPayment = new WorkorderPaypalPayment();
			$paypalPayment->quote_id = $quotation->id;
			$paypalPayment->workorder_id = null; // update later
			$paypalPayment->payment_id = $paypalResponseArr['id'];
			$paypalPayment->payment_status = $paypalResponseArr['status'];

			$paypalPayment->payer_id = $paypalResponseArr['payer']['payer_id'];
			$paypalPayment->payer_given_name = $paypalResponseArr['payer']['name']['given_name'];
			$paypalPayment->payer_surname = $paypalResponseArr['payer']['name']['surname'];
			$paypalPayment->payer_email = $paypalResponseArr['payer']['email_address'];

			$paypalPayment->purchase_units_reference_id = $paypalResponseArr['purchase_units'][0]['reference_id'];
			$paypalPayment->purchase_units_amount_currency_code = $paypalResponseArr['purchase_units'][0]['amount']['currency_code'];
			$paypalPayment->purchase_units_amount_value = $paypalResponseArr['purchase_units'][0]['amount']['value'];

			$paypalPayment->paypal_response_json = json_encode($paypalResponseArr);

			$paypalPayment->created_at = date('Y-m-d H:i:s', strtotime($paypalResponseArr['create_time']));
			$paypalPayment->created_by = Yii::app()->user->id;

			$paypalPayment->save();




			try {
				//trying to create SO from the quote with accepted lines
				$transaction = Yii::app()->db->beginTransaction();


				$orderCreator = new WorkOrderConvertor($quotation);
				$orderCreator->setOrderConvertType(WorkOrderConvertor::ORDER_CONVERT_TYPE_ACCEPT_LINE);
				//SWorkOrder wraps the original workorder model
				$sOrder = $orderCreator->getOrder();

				//Get the active model object from the SWorkOrder
				$workorder = $sOrder->getOrderModel();

				if ($workorder) {

					$paypalPayment->workorder_id = $workorder->id;
					$paypalPayment->save();

					$transaction->commit();
				} else {
					$transaction->rollback();
				}
			} catch (Exception $ex) {

				$response['error'] = $ex->getMessage();
			}

			$response['status'] = $paypalResponseArr['status'];
		} else {
			$response['status'] = isset($paypalResponseArr['status']) ? $paypalResponseArr['status'] : 'EXCEPTION';
		}

		echo json_encode($response);
	}
}
