<?php

class SalesLogController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'log', 'quotelog'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {

        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new SalesLog;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['SalesLog'])) {
            $model->attributes = $_POST['SalesLog'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    public function actionQuotelog($id) {
        $quote = Quatation::model()->findByPk($id);
        $model = new SalesLog();
        $model->quoteId = $quote->id;
        $this->render('quotelog', array(
            'quotation' => $quote,
            'model' => $model,
        ));
    }

    public function actionLog() {

        if (Yii::app()->request->isPostRequest) {
            $model = new SalesLog('search');
            if (isset($_POST['SalesLog'])) {
                $model->attributes = $_POST['SalesLog'];
                $model->followupDtm = date('Y-m-d', strtotime($model->followupDtm));
                $model->save(false);
            }
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    public function actionUpdateLog() {

        if (Yii::app()->request->isPostRequest) {
            $model = new SalesLog('search');
            if (isset($_POST['SalesLog'])) {
                $model->attributes = $_POST['SalesLog'];
                
                $updateModel = $this->loadModel($model->id);
                $updateModel->isIntrnl = $model->isIntrnl;
                $updateModel->isExtrnl = 1;
                $updateModel->comments = $model->comments;
                $updateModel->followupDtm = date('Y-m-d', strtotime($model->followupDtm));
                $updateModel->createdDtm = date('Y-m-d', strtotime($model->createdDtm));
                $updateModel->followupSts_id = $model->followupSts_id;
                
                if($updateModel->save()) {
                    echo json_encode(array('status' => true));
                    exit();
                }
                
            }            
        } 
        
        echo json_encode(array('status' => false));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['SalesLog'])) {
            $model->attributes = $_POST['SalesLog'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('SalesLog');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new SalesLog('search');

        $quote = new Quatation();

        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['SalesLog']))
            $model->attributes = $_GET['SalesLog'];

        $this->render('admin', array(
            'model' => $model,
            'quotation' => $quote,
        ));
    }

    public function actionCustomerFollowUp() {
        $model = new SalesLog('cusfollowup');



        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['SalesLog']))
            $model->attributes = $_GET['SalesLog'];

        $model->category = 'Customer';
        $model->isIntrnl = 0;

        if (!isset($_GET['type'])) {
            $model->createdBy = Yii::app()->user->id;
        }


        $this->render('customer_followup', array(
            'model' => $model,
        ));
    }

    public function actionFollowedUp($id) {
        $model = $this->loadModel($id);
        if ($model->followedUp == true) {
            $model->followedUp = 0;
        } else {
            $model->followedUp = 1;
        }
        if ($model->save(false)) {
            if ($model->followedUp == 1) {
                $txtcmnt = $model->comments;
                $flpmdl = FollowupStatus::model()->findByPk($model->followupSts_id);
                if (!empty($flpmdl)) {
                    $txtcmnt .= ' - ' . $flpmdl->status;
                }
                $linkId = CHtml::link($model->id, array('salesLog/view', 'id' => $model->id), array('target' => '_blank'));
                $comment = "[ID : " . $linkId . "]<br>[ " . $txtcmnt . " ] has completed";
                SalesLog::createSalesLogTblId($model->quoteId, $model->workorderId, $model->quoteNum, $model->tbl_id, $model->category, $comment, 1, 0, 1);
            }
            echo true;
        } else {
            echo false;
        }
    }

    public function actionFetchData($id) {
        $model = $this->loadModel($id);
        $model->followupDtm = date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime($model->followupDtm));
        $model->createdDtm = date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime($model->createdDtm));

        echo json_encode($model->attributes);
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = SalesLog::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'sales-log-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }
    
    public function actionPurchaseOrderReport() {
        $model = new SalesLog('searchPO');
        
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['SalesLog']))
            $model->attributes = $_GET['SalesLog'];
        
        $this->render('po_report', array(           
            'model' => $model,
        ));
    }

}
