<?php

class SalesPersonController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new SalesPerson;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['SalesPerson'])) {
            $model->attributes = $_POST['SalesPerson'];
            $model->uploadSignatureImage = CUploadedFile::getInstance($model, 'uploadSignatureImage');
            if ($model->save()) {
                if ($model->uploadSignatureImage) {
                    $model->uploadSignatureImage->saveAs('images/salesperson/' . $model->uploadSignatureImage);
                    $model->signature_image = $model->uploadSignatureImage;
                    $model->save(false);
                }
                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['SalesPerson'])) {
            $model->attributes = $_POST['SalesPerson'];
            $model->uploadSignatureImage = CUploadedFile::getInstance($model, 'uploadSignatureImage');
            if ($model->save()) {
                if ($model->uploadSignatureImage) {
                    $model->uploadSignatureImage->saveAs('images/salesperson/' . $model->uploadSignatureImage);
                    $model->signature_image = $model->uploadSignatureImage;
                    $model->save(false);
                }
                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            //delete only if sales person not been used by a quote
            if (!Quatation::model()->find("ws_user_id=:salesPersonID", array(':salesPersonID' => $id))) {
                $this->loadModel($id)->delete();
            }


            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('SalesPerson');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new SalesPerson('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['SalesPerson']))
            $model->attributes = $_GET['SalesPerson'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = SalesPerson::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'sales-person-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionQuotationSummary() {
        //print_r($_POST);
        $model = new SalesPerson('searchQuoteSum');
        $model->unsetAttributes();  // clear any default values
        $model->reportDateFlag = 1;
        if (isset($_GET['SalesPerson']))
            $model->attributes = $_GET['SalesPerson'];

        if (isset($_POST['reset_btn'])) {

            unset(Yii::app()->session['qs_sperson_selcted']);
            unset(Yii::app()->session['qs_sperson_datefrom']);
            unset(Yii::app()->session['qs_sperson_dateto']);
            unset(Yii::app()->session['qs_sperson_date_type_flag']);
            unset(Yii::app()->session['qs_sperson_query']);
        }

        if (isset($_POST['SalesPerson']) && isset($_POST['go_btn'])) {
            if (isset($_POST['SalesPerson']['id'])) {
                $postSPersonsArr = $_POST['SalesPerson']['id'];

                Yii::app()->session['qs_sperson_selcted'] = implode(',', $postSPersonsArr);
            }


            if (isset($_POST['SalesPerson']['reportDateFlag'])) {
                Yii::app()->session['qs_sperson_date_type_flag'] = $_POST['SalesPerson']['reportDateFlag'];
            }
        }


        if (isset($_POST['SalesPerson']['datefrom']) && !empty($_POST['SalesPerson']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['qs_sperson_datefrom'] = date('Y-m-d', strtotime($_POST['SalesPerson']['datefrom']));
        }

        if (isset(Yii::app()->session['qs_sperson_datefrom'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['qs_sperson_datefrom']));
        }

        if (isset($_POST['SalesPerson']['dateto']) && !empty($_POST['SalesPerson']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['qs_sperson_dateto'] = date('Y-m-d', strtotime($_POST['SalesPerson']['dateto']));
        }

        if (isset(Yii::app()->session['qs_sperson_dateto'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['qs_sperson_dateto']));
        }


        if (isset(Yii::app()->session['qs_sperson_date_type_flag'])) {
            $model->reportDateFlag = Yii::app()->session['qs_sperson_date_type_flag'];
        }

        if (isset(Yii::app()->session['qs_sperson_selcted'])) {
            $model->id = Yii::app()->session['qs_sperson_selcted'];
        }


        $this->render('quote_summary_report', array(
            'model' => $model,
        ));
    }

    public function actionQuotationSummaryPDF() {
        if (isset(Yii::app()->session['qs_sperson_query'])) {

            $query = Yii::app()->session['qs_sperson_query'];

            $rawData = Yii::app()->db->createCommand($query)->queryAll();

            if (empty($rawData)) {
                $this->redirect(array('salesperson'));
            }

            $estimateShow = isset($_GET['estimateShow']) ? filter_var($_GET['estimateShow'], FILTER_VALIDATE_BOOLEAN) : false;



            $pdfPageTitle = $this->pageTitle . ' - Quotation Summary By Salespersons';
            $htmlcontent = $this->renderInternal('protected/views/salesPerson/quote_summary_html.php', array('rawData' => $rawData, 'estimateShow' => $estimateShow), true);



            require_once 'vendor/autoload.php';
            $mPDF1 = new \Mpdf\Mpdf(
                    array(// More info: http://mpdf1.com/manual/index.php?tid=184
                'mode' => '', //  This parameter specifies the mode of the new document.
                'format' => 'A4', // format A4, A5, ...
                'default_font_size' => 0, // Sets the default document font size in points (pt)
                'default_font' => '', // Sets the default font-family for the new document.
                'mgl' => 10, // margin_left. Sets the page margins for the new document.
                'mgr' => 10, // margin_right
                'mgt' => 27, // margin_top
                'mgb' => 10, // margin_bottom
                'mgh' => 5, // margin_header
                'mgf' => 15, // margin_footer
                'orientation' => 'P', // landscape or portrait orientation
                    )
            );


            $mPDF1->SetHTMLHeader('<img src="images/pdf_default_header.jpg" style="width:100%;"/>', 'O', true);

            //$mPDF1->SetImportUse();
            //$pagecount = $mPDF1->SetSourceFile('images/template/bladonwa_common_template.pdf');
            //$tplId = $mPDF1->ImportPage($pagecount);
            //$mPDF1->SetPageTemplate($tplId);

            $mPDF1->SetTitle($pdfPageTitle);

            $mPDF1->AddPage('P', // L - landscape, P - portrait 
                    '', '', '', '', 5, // margin_left
                    5, // margin right
                    25, // margin top
                    25, // margin bottom
                    0, // margin header
                    2); // margin footer

            $mPDF1->defaultfooterline = 0;
            $mPDF1->setFooter('{PAGENO} / {nb}');

            $mPDF1->WriteHTML($htmlcontent);
            $timestamp = time();
            $mPDF1->Output("Quotes_Summary_By_Salespersons{$timestamp}.pdf", 'I');
        } else {
            $this->redirect(array('quotationSummary'));
        }
    }

}
