<?php

class SignOffTermsController extends RController
{

	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'rights',
				//'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view'),
				'users' => array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update'),
				'users' => array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete', 'filterSignOffs'),
				'users' => array('@'),
			),
			array('deny', // deny all users
				'users' => array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model' => $this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new SignOffTerms;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['SignOffTerms'])) {
			$model->attributes = $_POST['SignOffTerms'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id));
		}

		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['SignOffTerms'])) {
			$model->attributes = $_POST['SignOffTerms'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id));
		}

		$this->render('update', array(
			'model' => $model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider = new CActiveDataProvider('SignOffTerms');
		$this->render('index', array(
			'dataProvider' => $dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new SignOffTerms('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['SignOffTerms'])) {
			$model->attributes = $_GET['SignOffTerms'];
		}
			

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = SignOffTerms::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'sign-off-terms-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionFilterSignOffs()
	{
		$sign_off_id = (int) $_POST['signoff_id'];
		$modelName = $_POST['model'];
		$modelId = (int) $_POST['model_id'];
		
		$model = $this->loadModel($sign_off_id);
		$arr = array();
		 
		switch ($model->sign_off_id) {
			case SignOffTerms::BUILT_IN_TERM_SHIPPING_ADDRESS:
				if ($modelName === 'PurchaseOrder') {
					$po = PurchaseOrders::model()->findByPk($modelId);
					$job = $po->job;
					$shippingAddress = $job->shipAddress1 . ' ' . $job->shipAddress2 . ' ' . $job->shipAddress3 . "\n" . $job->shipSub . "\n" . $job->shipState . ' ' . $job->shipPostalCode;
					
					$model->term = trim($shippingAddress) ?"SHIPPING ADDRESS\n\n" .$shippingAddress:'---------- Please update shipping address for this job ------------';
				}
				break;
				case SignOffTerms::BUILT_IN_TERM_OFFICE_ADDRESS:
					if ($modelName === 'PurchaseOrder') {
					$po = PurchaseOrders::model()->findByPk($modelId);
					$job = $po->job;
					$shippingAddress = $job->customer->cusadd1 . ' ' . $job->customer->cusadd2 . ' ' . $job->customer->cusadd3 . "\n" . $job->customer->custown . "\n" . $job->customer->cusstate . ' ' . $job->customer->cuspostcode;
					
					$model->term = trim($shippingAddress) ?"OFFICE ADDRESS\n\n" .$shippingAddress:'---------- Please update office address for this job ------------';
				}


				break;
			
		}


		$arr['signoff_code'] = $model->sign_off_id;
		$arr['signoff_term'] = $model->term;

		echo json_encode($arr);
	}

}
