<?php

class SiteController extends Controller {

    public $layout = '//layouts/column2';
    public function filters() {
        return array('accessControl');
    }

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform these actions
                'actions' => array('login', 'logout', 'forgot', 'error'),
                'users' => array('*'),
            ),
            array('allow', // allow all users to perform these actions
                'actions' => array('login', 'index', 'logout', 'view', 'admin'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('dashboard'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Declares class-based actions.
     */
//    public function actions() {
//        return array(
//            // captcha action renders the CAPTCHA image displayed on the contact page
//            'captcha' => array(
//                'class' => 'CCaptchaAction',
//                'backColor' => 0xFFFFFF,
//            ),
//            // page action renders "static" pages stored under 'protected/views/site/pages'
//            // They can be accessed via: index.php?r=site/page&view=FileName
//            'page' => array(
//                'class' => 'CViewAction',
//            ),
//        );
//    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        // renders the view file 'protected/views/site/index.php'
        // using the default layout 'protected/views/layouts/main.php'
        $this->render('index');
    }

    /**
     * This is the action to handle external exceptions.
     */
    public function actionError() {
         $error = Yii::app()->errorHandler->error;
        if ($error)
            $this->render('error', array('error' => $error));
        else
            throw new CHttpException(404, 'Page not found.');
    }

    /**
     * Displays the contact page
     */
    public function actionContact() {
        $model = new ContactForm;
        if (isset($_POST['ContactForm'])) {
            $model->attributes = $_POST['ContactForm'];
            if ($model->validate()) {
                $name = '=?UTF-8?B?' . base64_encode($model->name) . '?=';
                $subject = '=?UTF-8?B?' . base64_encode($model->subject) . '?=';
                $headers = "From: $name <{$model->email}>\r\n" .
                        "Reply-To: {$model->email}\r\n" .
                        "MIME-Version: 1.0\r\n" .
                        "Content-Type: text/plain; charset=UTF-8";

                mail(Yii::app()->params['adminEmail'], $subject, $model->body, $headers);
                Yii::app()->user->setFlash('contact', 'Thank you for contacting us. We will respond to you as soon as possible.');
                $this->refresh();
            }
        }
        $this->render('contact', array('model' => $model));
    }

    /**
     * Displays the login page
     */
    public function actionLogin() {
        $model = new LoginForm;

        // if it is ajax validation request
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        // collect user input data
        if (isset($_POST['LoginForm'])) {            
            

            $tracking = new Tracking();
            $tracking->accesstime = date('Y-m-d H:i:s');
            $tracking->accessip   = $_SERVER["REMOTE_ADDR"];
            $tracking->server_json = json_encode($_SERVER);

            $model->attributes = $_POST['LoginForm'];
            // validate user input and redirect to the previous page if valid
            if ($model->validate() && $model->login()) {

                $tracking->username   = $model->username;
                $tracking->title      = Yii::app()->user->title;
                $tracking->action     = 'Logged In';
                $tracking->save(false);
                
                $this->redirect(Yii::app()->user->returnUrl);
            } else {

                $tracking->username   = $model->username;
                $tracking->title      =  'Guest';
                $tracking->action     = 'Attempt to Log In';
                $tracking->save(false);
            }

            
        }

        //if user already logged
        if (!Yii::app()->user->isGuest) {

            $this->redirect(Yii::app()->user->returnUrl);
        }
        // display the login form
        $this->render('login', array('model' => $model));
    }

    public function actionForgot() {
        $transaction = Yii::app()->db->beginTransaction();
        $model = new LoginForm;



        // collect user input data
        if (isset($_POST['LoginForm'])) {
            $model->attributes = $_POST['LoginForm'];
            // validate user input and redirect to the previous page if valid
            if (!empty($model->email)) {
                $username = trim($model->email);
                $user = User::model()->find(array('condition' => "username = '{$username}' and email = '{$username}' and title = 'Customer'"));
                if (!empty($user) && $user->title == 'Customer') {
                    $newpassword = User::generateRandomPassword();

                    $user->password = md5($newpassword);
                    if ($user->save(false)) {
                        $recipient = 'rajaera@gmail.com'; //$model->customer->cusemail;
                        $ccrecipients = ''; //
                        $mailer = Yii::app()->MultiMailer->to($recipient, 'Recipient');
                        //$mailer = Yii::app()->MultiMailer->to('rajaera@gmail.com', 'Recipient');
                        $globalvar = GlobalVars::model()->find(array('condition' => "globalVar = 'AdminEmail'"));
                        if (!empty($globalvar)) {
                            $ccrecipients = $globalvar->value;
                            $mailer->cc($ccrecipients);
                        }

                        $mailer->subject("Retrieve New Password");

                        $mailbody .= "<p>Your new password is : {$newpassword}</p>";
                        $mailer->body($mailbody);

                        if ($mailer->send()) {
                            $trackmail = Emails::trackSave($recipient, $ccrecipients, $mailbody);
                            $model->ispwretrive = true;
                            $transaction->commit();
                        } else {
                            $transaction->rollback();
                        }
                    } else {
                        $transaction->rollback();
                    }
                } else {
                    $model->username = $user->title;
                    $transaction->rollback();
                }

//                if(Yii::app()->user->title == 'Customer'){
//                    $this->redirect(array('workorder/cusAdmin'));
//                }else{
//                    $this->redirect(Yii::app()->user->returnUrl);
//                }
//                
            }
        }
        // display the login form
        $this->render('forgot', array('model' => $model));
    }

    /**
     * Logs out the current user and redirect to homepage.
     */
    public function actionLogout() {
        Yii::app()->user->logout();
//		$this->redirect(Yii::app()->homeUrl);
        $this->redirect(array('site/login'));
    }

}
