<?php

require 'vendor/autoload.php';

// Use this class to deserialize error caught
use XeroAPI\XeroPHP\AccountingObjectSerializer;

class SupplierController extends RController
{

	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'rights',
				//'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view'),
				'users' => array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'view'),
				'users' => array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete', 'view'),
				'users' => array('@'),
			),
			array('deny', // deny all users
				'users' => array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model' => $this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Supplier;
		$model->supmrate = GlobalVars::get("SupplierMarkUp");

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Supplier'])) {
			$model->attributes = $_POST['Supplier'];
			if ($model->save(false)) {

				$model->supsup = $model->supsno;
				$model->supsup_fref = $model->supsup_fref ?: $model->supsno;
				$model->supentddt = date("Y-m-d");
				$model->supenttime = date("Y-m-d");
				$model->supameddt = date("H:i:s");
				$model->supametime = date("H:i:s");

				$this->redirect(array('view', 'id' => $model->supsno));
			}
		}

		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Supplier'])) {
			$model->attributes = $_POST['Supplier'];
			if (empty($model->supmrate))
				$model->supmrate = GlobalVars::get("SupplierMarkUp");

			/* update edited date time */
			$model->supameddt = date('Y-m-d');
			$model->supametime = date('H:i:s');

			if ($model->save())
				$this->redirect(array('view', 'id' => $model->supsno));
		}

		$this->render('update', array(
			'model' => $model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider = new CActiveDataProvider('Supplier');
		$this->render('index', array(
			'dataProvider' => $dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Supplier('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Supplier']))
			$model->attributes = $_GET['Supplier'];

		if (isset($_POST['reset_btn'])) {
			unset(Yii::app()->session['sup_expt_qry']);
		}

		if (isset($_POST['sup-exprt-btn']) && isset(Yii::app()->session['sup_expt_qry'])) {
			$this->exportAsExcel();
		}


		$message = null;
		if (isset($_POST['Supplier'])) {
			$model->attributes = $_POST['Supplier'];

			//if ($model->validate()) {
			if (isset($_POST['import_btn']) && isset($_POST['Supplier']['importFile'])) {
				$model->importFile = CUploadedFile::getInstance($model, 'importFile');
				if (!empty($model->importFile)) {
					$message = $this->importFile($model);
				}
			}
			//}
		}

		$this->render('admin', array(
			'model' => $model, 'message' => $message
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Supplier::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'supplier-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function importFile($model)
	{
		Yii::import('application.vendors.PHPExcel', true);

		if (!file_exists('files/tmp/')) {
			mkdir('files/tmp/', 0777);
		}

		$filenametobesave = 'files/tmp/' . time() . '.' . $model->importFile->getExtensionName();
		$model->importFile->saveAs($filenametobesave);
		try {
			if ($model->importFile->getExtensionName() == "xls") {
				$objReader = new PHPExcel_Reader_Excel5();
				$data = $objReader->load($filenametobesave);
				$objWorksheet = $data->getActiveSheet();
				$highestRow = $objWorksheet->getHighestRow();
			} else if ($model->importFile->getExtensionName() == "xlsx") {
				$inputFileType = PHPExcel_IOFactory::identify($filenametobesave);
				$objReader = PHPExcel_IOFactory::createReader($inputFileType);
				$objReader->setReadDataOnly(true);
				$data = $objReader->load($filenametobesave);
				$objWorksheet = $data->getSheet(0);
				$highestRow = $objWorksheet->getHighestRow();
			}
		} catch (Exception $e) {
			dir("Error loading file " . pathinfo($filenametobesave, PATHINFO_BASENAME) . '": ' . $e->getMessage());
		}

		$message = array();
		//$transaction = Yii::app()->db->beginTransaction();
		//check qty title for a valid data row
		for ($i = 1; $i <= $highestRow; $i++) {


			$suppliercode = $objWorksheet->getCellByColumnAndRow(0, $i)->getCalculatedValue();

			$supname = $objWorksheet->getCellByColumnAndRow(1, $i)->getCalculatedValue();

			$supAddr = $objWorksheet->getCellByColumnAndRow(2, $i)->getCalculatedValue();

			$supPostCode = $objWorksheet->getCellByColumnAndRow(3, $i)->getCalculatedValue();

			$supCity = $objWorksheet->getCellByColumnAndRow(4, $i)->getCalculatedValue();

			$supState = $objWorksheet->getCellByColumnAndRow(5, $i)->getCalculatedValue();

			$supTel = $objWorksheet->getCellByColumnAndRow(6, $i)->getCalculatedValue();

			$supContact = $objWorksheet->getCellByColumnAndRow(7, $i)->getCalculatedValue();

			$supEmail = $objWorksheet->getCellByColumnAndRow(8, $i)->getCalculatedValue();

			if (trim($suppliercode) && trim($supname)) {

				$supplier = Supplier::model()->find(array('condition' => "supsup_fref = '$suppliercode'"));
				if (!$supplier) {
					$supplier = new Supplier();

					$supplier->supsup_fref = $suppliercode;
					$supplier->supnam = $supname;
					$supplier->supad1 = $supAddr;
					$supplier->suppostcode = $supPostCode;
					$supplier->suptown = $supCity;
					$supplier->supstate = $supState;
					$supplier->suptel = $supTel;
					$supplier->supcontact = $supContact;
					$supplier->supemail = $supEmail;
					if ($supplier->save(false)) {
						
						$supplier->supsup = $supplier->supsno;
						$supplier->supsup_fref = $supplier->supsup_fref ?: $supplier->supsno;
						$supplier->supentddt = date("Y-m-d");
						$supplier->supenttime = date("Y-m-d");
						$supplier->supameddt = date("H:i:s");
						$supplier->supametime = date("H:i:s");
						
						$message['supplier_ok'] .= "New supplier [$suppliercode] has been created.<br>";
					} else {
						$message['supplier_error'] .= "cannot create supplier for code [$suppliercode].<br>";
					}
				} else {
					$supplier->supnam = $supname;
					$supplier->supad1 = $supAddr;
					$supplier->suppostcode = $supPostCode;
					$supplier->suptown = $supCity;
					$supplier->supstate = $supState;
					$supplier->suptel = $supTel;
					$supplier->supcontact = $supContact;
					$supplier->supemail = $supEmail;
					if ($supplier->save(false)) {
						
						$supplier->supsup = $supplier->supsno;
						$supplier->supsup_fref = $supplier->supsup_fref ?: $supplier->supsno;
						$supplier->supentddt = date("Y-m-d");
						$supplier->supenttime = date("Y-m-d");
						$supplier->supameddt = date("H:i:s");
						$supplier->supametime = date("H:i:s");
						
						$message['supplier_ok'] .= "Supplier [$suppliercode] has been updated.<br>";
					}
				}
			} else {
				$message['supplier_issue'] .= "Cannot create supplier. No supplier code or name given on line [$i].<br>";
			}
		}
		//$transaction->rollback();
		return $message;
	}

	public function exportAsExcel()
	{
		if (isset(Yii::app()->session['sup_expt_qry'])) {
			$query = Yii::app()->session['sup_expt_qry'];
			$query .= ' order by supnam asc';

			$rawData = Yii::app()->db->createCommand($query)->queryAll();
			if (empty($rawData))
				$this->redirect(array('supplier/admin'));
		}

		$reportName = "Supplier List";
		Yii::import('ext.phpexcel.XPHPExcel');
		$objPHPExcel = XPHPExcel::createPHPExcel();
		$objPHPExcel->getProperties()->setCreator(Yii::app()->name)
				->setLastModifiedBy(Yii::app()->name)
				->setTitle($reportName)
				->setSubject($reportName)
				->setDescription($reportName)
				->setKeywords($reportName)
				->setCategory($reportName);

		$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('E3', Yii::app()->name)
				->setCellValue('E4', Yii::app()->name . " - " . $reportName)
				->setCellValue('E6', 'Created Date : ' . date(GlobalVars::get("DateFormat"), strtotime('now')));

		$column = array();

		//if(Yii::app()->session['invr_imageFlag'] == 1)
		$column['A'] = 'Supplier Reference';
		$column['B'] = 'Name';
		$column['C'] = 'Address';
		$column['D'] = 'Postal Code';
		$column['E'] = 'City';
		$column['F'] = 'State';
		$column['G'] = 'Telephone';
		$column['H'] = 'Contact';
		$column['I'] = 'Email';
		$column['J'] = 'Margin Rate';
		$column['K'] = 'Web Site';




		foreach ($column as $key => $val) {
			$objPHPExcel->setActiveSheetIndex(0)->setCellValue($key . '9', $val);
		}

		$sheet = $objPHPExcel->getActiveSheet();


		foreach ($column as $key => $val) {
			$sheet->getColumnDimension($key)->setAutoSize(true);
		}


		$sheet->mergeCells("E3:F3");
		$sheet->mergeCells("E4:F4");
		$sheet->mergeCells("E5:F5");
		$sheet->mergeCells("E6:F6");

		$sheet->getStyle("E3")->applyFromArray(array("font" => array("bold" => true, "size" => "14px")));
		$sheet->getStyle("E4")->applyFromArray(array("font" => array("bold" => true)));

		$sheet->getStyle("B2")->applyFromArray(array("font" => array("bold" => true)));
		$sheet->getStyle("A9:K9")->applyFromArray(array("font" => array("bold" => true)));

		$row = 11;
		$count = 1;
		foreach ($rawData as $item) {

			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A' . $row, $item['supsup_fref'])
					->setCellValue('B' . $row, $item['supnam'])
					->setCellValue('C' . $row, $item['supad1'] . "," . $item['supad2'] . "," . $item['supad3'])
					->setCellValue('D' . $row, $item['suppostcode'])
					->setCellValue('E' . $row, $item['suptown'])
					->setCellValue('F' . $row, $item['supstate'])
					->setCellValue('G' . $row, $item['suptel'])
					->setCellValue('H' . $row, $item['supcontact'])
					->setCellValue('I' . $row, $item['supemail'])
					->setCellValue('J' . $row, $item['supmrate'])
					->setCellValue('K' . $row, $item['orderingWebsite']);




			$row++;
			$count++;
		}

		// Redirect output to a clientÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢s web browser (Excel5)
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="MPVS2_SupplierExportList_' . date('dmY') . '.xls"');
		header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
		header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
		header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');

		Yii::app()->end();
	}

	public function actionMYOBSyncronizeAll()
	{

		$auth = new MYOBAuth(MyobSetting::getSettings());
		if ($auth->checkAccess()) {

			$myobApiConnector = new MYOBApiConnector($auth);
			$myobApiConnector->setURLEndPoint('Contact/Supplier/');

			/* create syncronizer object which has the syncronizing logics */
			$synchronizer = new MYOBSynchronizer($myobApiConnector, null);
			/* should set appropriate finder reference or object */
			$synchronizer->setMYOBReferenceFinder(new MYOBSupplierReferenceFinder());
			/* just pull the records from MYOB and and update or insert into local DB */
			$synchronizer->setSynchronizeType(MYOBSynchronizer::SYNCHRONIZE_TYPE_PULL);
			$synchronizer->syncronizeAll('Supplier', $myobApiConnector->requestedURLGet());
		} else {
			throw new Exception('MYOB access denied!', 401);
}

		//$this->redirect(array('view', 'id' => $id));
	}

	public function actionMYOBSyncronize()
	{

		$auth = new MYOBAuth(MyobSetting::getSettings());
		if ($auth->checkAccess()) {
			$id = (int) $_POST['id'];
			$model = $this->loadModel($id);

			$myobApiConnector = new MYOBApiConnector($auth);

			/* create syncronizer object which has the syncronizing logics */
			$synchronizer = new MYOBSynchronizer($myobApiConnector, $model);
			$synchronizer->setMYOBReferenceFinder(new MYOBSupplierReferenceFinder());
			$model->setSynchronizer($synchronizer);

			/* do syncorize */
			if ($model->myobSynchronize($myobApiConnector)) {
				echo json_encode(array('success' => true));
			} else {
				echo json_encode(array('success' => false));
			}
		}

		//$this->redirect(array('view', 'id' => $id));
	}

}
