<?php

class SystemOptionsController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform these actions
                'actions' => array('login', 'logout', 'forgot'),
                'users' => array('*'),
            ),
            array('allow', // allow all users to perform these actions
                'actions' => array('login', 'index', 'logout', 'view', 'admin'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('dashboard'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Declares class-based actions.
     */
//    public function actions() {
//        return array(
//            // captcha action renders the CAPTCHA image displayed on the contact page
//            'captcha' => array(
//                'class' => 'CCaptchaAction',
//                'backColor' => 0xFFFFFF,
//            ),
//            // page action renders "static" pages stored under 'protected/views/site/pages'
//            // They can be accessed via: index.php?r=site/page&view=FileName
//            'page' => array(
//                'class' => 'CViewAction',
//            ),
//        );
//    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        // renders the view file 'protected/views/site/index.php'
        // using the default layout 'protected/views/layouts/main.php'
        $this->render('index');
    }

    public function actionOptions() {

        $model = new SystemOptions();
        $model->unsetAttributes();  // clear any default values
        if (isset($_POST['SystemOptions'])) {

            $model->attributes = $_POST['SystemOptions'];

            $oldLogoImage = SystemOptions::getOptions()->logoImage; 
            $oldDefaultPdfLogoImage = SystemOptions::getOptions()->defaultPdfLogoImage;            

            if ($model->validate()) {

                //capture logo image
                $model->logoImageUploadInstance = CUploadedFile::getInstance($model, 'logoImageUploadInstance');

                if(!file_exists('images/logos/')) {
                    mkdir('images/logos/');
                }                

                if ($model->logoImageUploadInstance) {
                    $model->logoImageUploadInstance->saveAs(Yii::app()->basePath . '/../images/logos/' . $model->logoImageUploadInstance);                    
                }

                //capture pdf logo image
                $model->defaultPdfLogoUploadInstance = CUploadedFile::getInstance($model, 'defaultPdfLogoUploadInstance');

                if(!file_exists('images/logos/')) {
                    mkdir('images/logos/');
                }                

                if ($model->defaultPdfLogoUploadInstance) {
                    $model->defaultPdfLogoUploadInstance->saveAs(Yii::app()->basePath . '/../images/logos/' . $model->defaultPdfLogoUploadInstance);                    
                }

                $file = fopen("protected/filemodels/systemoptions.csv", 'w');

                fwrite($file, "quoteToJob=>" . $model->quoteToJob . "\n");
                fwrite($file, "showPageID=>" . $model->showPageID . "\n");
                fwrite($file, "jobDueUrgentAuto=>" . $model->jobDueUrgentAuto . "\n");
                fwrite($file, "enbleXero=>" . $model->enbleXero . "\n");
                fwrite($file, "enableMyob=>" . $model->enableMyob . "\n");

                fwrite($file, "defaultImagePath=>" . $model->defaultImagePath . "\n");
                fwrite($file, "salesPersonSignatureOnQuotePDF=>" . $model->salesPersonSignatureOnQuotePDF . "\n");
                fwrite($file, "quoteLockSellPrice=>" . $model->quoteLockSellPrice . "\n");
                fwrite($file, "soLockSellPrice=>" . $model->soLockSellPrice . "\n");

                fwrite($file, "quoteAcceptanceLinkSent=>" . $model->quoteAcceptanceLinkSent . "\n");
                fwrite($file, "quoteAcceptanceLinkAccept=>" . $model->quoteAcceptanceLinkAccept . "\n");
                fwrite($file, "quoteAcceptanceLinkDecline=>" . $model->quoteAcceptanceLinkDecline . "\n");

                fwrite($file, "soAcceptanceLinkSent=>" . $model->soAcceptanceLinkSent . "\n");
                fwrite($file, "soAcceptanceLinkAccept=>" . $model->soAcceptanceLinkAccept . "\n");
                fwrite($file, "soLockSellPrice=>" . $model->soAcceptanceLinkDecline . "\n");

                fwrite($file, "webstoreOrderAcceptanceLinkSent=>" . $model->webstoreOrderAcceptanceLinkSent . "\n");
                fwrite($file, "webstoreOrderAcceptanceLinkAccept=>" . $model->webstoreOrderAcceptanceLinkAccept . "\n");
                fwrite($file, "webstoreOrderAcceptanceLinkDecline=>" . $model->webstoreOrderAcceptanceLinkDecline . "\n");

                fwrite($file, "ftpProductRemoteServerDIR=>" . $model->ftpProductRemoteServerDIR . "\n");
                fwrite($file, "ftpProductRemoteServerFtpIP=>" . $model->ftpProductRemoteServerFtpIP . "\n");
                fwrite($file, "ftpProductRemoteServerFtpUser=>" . $model->ftpProductRemoteServerFtpUser . "\n");
                fwrite($file, "ftpProductRemoteServerFtpPassword=>" . $model->ftpProductRemoteServerFtpPassword . "\n");
                fwrite($file, "ftpLocalDirToSaveExcelFiles=>" . $model->ftpLocalDirToSaveExcelFiles . "\n");

                fwrite($file, "maxWebServiceQuoteExecutePerOneRefresh=>" . ($model->maxWebServiceQuoteExecutePerOneRefresh > 0 ? $model->maxWebServiceQuoteExecutePerOneRefresh : 3) . "\n");


                fwrite($file, "show_product_cost=>" . $model->show_product_cost . "\n");
                fwrite($file, "show_decoration=>" . $model->show_decoration . "\n");
                fwrite($file, "show_decoration_cost=>" . $model->show_decoration_cost . "\n");
                fwrite($file, "show_customisation_details=>" . $model->show_customisation_details . "\n");
                fwrite($file, "show_notes=>" . $model->show_notes . "\n");
                fwrite($file, "show_job_info=>" . $model->show_job_info . "\n");
                fwrite($file, "show_website_ordering_info=>" . $model->show_website_ordering_info . "\n");
                fwrite($file, "show_price_on_pdf=>" . $model->show_price_on_pdf . "\n");
                fwrite($file, "show_logo_setup=>" . $model->show_logo_setup . "\n");
                fwrite($file, "show_so_customisation=>" . $model->show_so_customisation . "\n");

                fwrite($file, "gwsApiRequestUrl=>" . $model->gwsApiRequestUrl . "\n");
                fwrite($file, "gwsApiUsername=>" . $model->gwsApiUsername . "\n");
                fwrite($file, "gwsApiPassword=>" . $model->gwsApiPassword . "\n");
                
                fwrite($file, "poFollowupStatusForCancel=>" . $model->poFollowupStatusForCancel . "\n");
                fwrite($file, "poFollowupStatusForCompleted=>" . $model->poFollowupStatusForCompleted . "\n");
                
                fwrite($file, "payment_type_id=>" . $model->payment_type_id . "\n");
                fwrite($file, "payment_type_days=>" . $model->payment_type_days . "\n");
                

                if($model->logoImageUploadInstance) {
                    fwrite($file, "logoImage=>" . $model->logoImageUploadInstance . "\n");
                } else {
                    fwrite($file, "logoImage=>" . $oldLogoImage . "\n");
                }

                if($model->defaultPdfLogoUploadInstance) {
                    fwrite($file, "defaultPdfLogoImage=>" . $model->defaultPdfLogoUploadInstance . "\n");
                } else {
                    fwrite($file, "defaultPdfLogoImage=>" . $oldDefaultPdfLogoImage . "\n");
                }

                fwrite($file, "enablePaypalPayment=>" . $model->enablePaypalPayment . "\n");
                fwrite($file, "paypalClientId=>" . $model->paypalClientId . "\n");
                fwrite($file, "paypalCurrency=>" . trim($model->paypalCurrency) . "\n");

                if (fclose($file)) {
                    Yii::app()->user->setFlash('success', "System options have been updated successfully!");
                } else {
                    Yii::app()->user->setFlash('notice', "Cannot update system options! please try again or contact system admin.");
                }
            } else {
                $validtionErrorText = '';

                foreach($model->errors as $attribute => $error){
                    $validtionErrorText = "$attribute: " . implode(',', $error) . "<br>";
                }

                Yii::app()->user->setFlash('error', "Cannot update system options. Validation Failed!. [{$validtionErrorText}]");
            }
        }

        $savedModel = $this->loadModel();
        if ($savedModel->showPageID == 1) {

            Yii::app()->session['view_identity_on'] = true;
        } else {
            unset(Yii::app()->session['view_identity_on']);
        }
        $this->render('_form', array(
            'model' => $savedModel,
        ));
    }

    public function loadModel() {
        return SystemOptions::getOptions();
    }

    /*
     * Refresh FTP products
     */

    public function actionFtpProductRead() {
        $systemOptions = SystemOptions::getOptions();
        $config = array(
            'ftp_server_dir' => trim($systemOptions->ftpProductRemoteServerDIR),
            'local_dir' => trim($systemOptions->ftpLocalDirToSaveExcelFiles),
            'remote_ftp_location_configs' => array(
                'ftp_server' => trim($systemOptions->ftpProductRemoteServerFtpIP),
                'ftp_user' => trim($systemOptions->ftpProductRemoteServerFtpUser),
                'ftp_password' => trim($systemOptions->ftpProductRemoteServerFtpPassword)
            )
        );
        $ftpProductReader = new FTPProductReader($config);
        $ftpProductReader->read();

        Yii::app()->user->setFlash('success', "Products have been refreshed via FTP!");
    }

    public function actionRemoteImageSaverClient() {
        
        $searchableProduct = new RemoteImageProductSearchable();
        $searchableProduct->primaryKey = 'pdlsno';
        $searchableProduct->dbImageFieldName = 'pdlimage1';

        $searchableQuoteDetail = new RemoteImageQuotationDetailSearchable();
        $searchableQuoteDetail->primaryKey = 'id';
        $searchableQuoteDetail->dbImageFieldName = 'productimg';

        $searchableSODetail = new RemoteImageWorkOrderDetailSearchable();
        $searchableSODetail->primaryKey = 'id';
        $searchableSODetail->dbImageFieldName = 'image';


        $remoteImageSaver = new RemoteImageSaver();
        $remoteImageSaver->addSearchable($searchableProduct)
                ->addSearchable($searchableQuoteDetail)
                ->addSearchable($searchableSODetail)
                ->saveRemoteToLocal();
    }

}
