<?php

class WebServiceController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
			'rights',
			//'accessControl', // perform access control for CRUD operations
		);
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update', 'processQuote'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {


        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new WebService;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['WebService'])) {
            $model->attributes = $_POST['WebService'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->ws_id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['WebService'])) {
            $model->attributes = $_POST['WebService'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->ws_id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('WebService');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new WebService('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['WebService']))
            $model->attributes = $_GET['WebService'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    public function actionProcessQuote() {

        //print_r($_POST);

        if (isset($_POST['WebService'])) {
            if (isset($_POST['WebService']['ws_quoteno'])) {
                //print_r($_POST['WebService']['ws_quoteno']);
                $this->generateQuatationViaWSData($_POST['WebService']['ws_quoteno']);
                $this->redirect(array('quatation/admin'));
            }
        }

        $model = new WebService();

        $this->render('processQuote', array(
            'model' => $model,
        ));
    }

    private $_quatation = null;
    private $_lastProduct = null;

    public function generateQuatationViaWSData($quatationno) {

        $quatationmodel = Quatation::model()->find(array("condition" => "quoteno = '{$quatationno}' "));

        if (!empty($quatationmodel)) {
            $this->_quatation = $quatationmodel;
        }

        //get all records related to this quatation number
        $recordIds = Yii::app()->db->createCommand("select ws_id from ws_data where ws_quoteno = '{$quatationno}' order by ws_id asc")->queryAll();


        $lastproductid = null;
        foreach ($recordIds as $id) {

            $wsData = Yii::app()->db->createCommand("select ws_data,ws_clientid,ws_date,ws_time,ws_user from ws_data where ws_id = '{$id['ws_id']}'")->queryRow();

            //create quatation only if not yet created
            if ($this->_quatation == null) 
                $this->_saveQuatation($id['ws_id'], $wsData['ws_clientid'], $quatationno, $wsData['ws_date'], $wsData['ws_time'], $wsData['ws_user']);

            $dataArr = explode('#', $wsData['ws_data']);

            if (sizeOf($dataArr) > 4 && $dataArr[4] == 'P') {
                $lastproductid = $dataArr[0];
                $this->_saveQuatationWithProduct($id['ws_id'], $dataArr);
            }

            if (sizeOf($dataArr) > 4 && $dataArr[4] == 'D') {
                //print_r($dataArr);
                $this->_saveQuatationWithDecoration($id['ws_id'], $dataArr);
            }

            if (sizeOf($dataArr) > 4 && $dataArr[4] == 'C') {

                $this->_updateQuatationWithComments($dataArr[3]);
            }
        }
    }

    private function _saveQuatation($wsdataid, $cusref, $quatationno, $wsdate, $wstime, $wsuser) {
        if ($this->_quatation == null) {
            $this->_quatation = new Quatation;

            $this->_quatation->ws_id = $wsdataid;
            $this->_quatation->quoteno = $quatationno;
            $this->_quatation->cus_fref = $cusref;

            $this->_quatation->quotecreatedby = Yii::app()->user->id;
            $this->_quatation->quotecreated = date("Y-m-d g:i"); // current date & time
            $this->_quatation->ws_date = strtotime($wsdate . ' ' . $wstime);
            $this->_quatation->ws_user = $wsuser;

            $this->_quatation->save();
        }
    }

    private function _saveQuatationWithProduct($ws_id, $productArr) {


        if ($this->_quatation != null && sizeof($productArr) >= 24) {


            $this->_quatation->systemfreight = floatval($productArr[19]); //System freight value

            $this->_lastProduct = new QuatationDetails;
            $this->_lastProduct->quoteid = $this->_quatation->id;
            $this->_lastProduct->ws_id = $ws_id;
            $this->_lastProduct->productsku = $productArr[0];
            $this->_lastProduct->qty = intval($productArr[1]);
            $this->_lastProduct->productexunitprice = floatval($productArr[2]);
            $this->_lastProduct->productname = $productArr[3];
            $this->_lastProduct->sup_fref = $productArr[5];
            $this->_lastProduct->supmarg = floatval($productArr[8]);
            $this->_lastProduct->customerdicspcn = floatval($productArr[7]);
            $this->_lastProduct->productimg = $productArr[12];
            $this->_lastProduct->iscustomprodct = ($productArr[18] == 'yes' ? 1 : 0);
            $this->_lastProduct->productdescription = $productArr[14];
            $this->_lastProduct->prodctfrieght = floatval((is_numeric($productArr[16]) ? $productArr[16] : 0) );
            $this->_lastProduct->productvat = floatval((is_numeric($productArr[17]) ? $productArr[17] : 0 ));
            $this->_lastProduct->supname = $productArr[20];
            $this->_lastProduct->sellunitprice_ex_vat = floatval((is_numeric($productArr[21]) ? $productArr[21] : 0));
            $this->_lastProduct->sellunitprice_in_vat = floatval((is_numeric($productArr[22]) ? $productArr[22] : 0));
            $this->_lastProduct->selltot_ex_vat = floatval((is_numeric($productArr[23]) ? $productArr[23] : 0));
            $this->_lastProduct->selltot_in_vat = floatval((is_numeric($productArr[24]) ? $productArr[24] : 0));

            $this->_lastProduct->save(false);
        }
    }

    private function _saveQuatationWithDecoration($ws_id, $decorationArr) {
        //print_r($decorationArr[16] . '<br/>');
        if ($this->_quatation != null && $this->_lastProduct != null) {

            $decoration = new QuoteProductDecoration;

            $decoration->ws_id = $ws_id;
            $decoration->quoteid = $this->_quatation->id;
            $decoration->productsku = $this->_lastProduct->productsku;
            $decoration->quataiondetailsid = $this->_lastProduct->id;
            $decoration->decprtnam = $decorationArr[0];
            $decoration->decorationdescription = $decorationArr[3];
            $decoration->decorationqty = intval((is_numeric($decorationArr[1]) ? $decorationArr[1] : 0));
            $decoration->decorationunitval = floatval((is_numeric($decorationArr[2]) ? $decorationArr[2] : 0));
            $decoration->logosetupcharge = floatval((is_numeric($decorationArr[6]) ? $decorationArr[6] : 0));
            $decoration->customerdicspcn = floatval((is_numeric($decorationArr[7]) ? $decorationArr[7] : 0));
            $decoration->maindecorationid = $decorationArr[9];
            $decoration->decorationfreightval = floatval((is_numeric($decorationArr[16]) ? $decorationArr[16] : 0));
            $decoration->decorationvat = floatval((is_numeric($decorationArr[17]) ? $decorationArr[17] : 0));


            $decoration->save();
        }
    }

    private function _updateQuatationWithComments($comment) {
        if ($this->_quatation != null && $this->_quatation->id > 0) {
            $this->_quatation->quotecomments = $comment;
            $this->_quatation->save();
        }
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = WebService::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'web-service-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
