<?php

class WebStoreController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        
        $model = $this->loadModel($id);
        $pricelist = new WebstorePriceList();
        $pricelist->webstoreId = $model->id;
        
        $productGroup = new ProductGroup();
        $productGroup->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductGroup']))
            $productGroup->attributes = $_GET['ProductGroup'];
        
        
        
        if (isset($_GET['WebstorePriceList']))
            $pricelist->attributes = $_GET['WebstorePriceList'];
        
        if(isset($_POST['selct-prod-webstr-btn']) && isset($_POST['choose-from-product-group-grid_c0']) && isset($_POST['ProductGroup'])){
            $selectedProductGRoupIDArr = $_POST['choose-from-product-group-grid_c0'];
            foreach ($selectedProductGRoupIDArr as $key=>$val){
                $webstoreproductgroup = new WebstoreProductGroup();
                $webstoreproductgroup->webstoreId = $model->id;
                $webstoreproductgroup->product_group_id = $val;
                $webstoreproductgroup->created_date = date('Y-m-d', strtotime('now'));
                $webstoreproductgroup->created_by = Yii::app()->user->id;
                $webstoreproductgroup->save();
            }
        }
        
        
        $productcategory = new ProductCategory('searchWebStoreOrder');
        
        $productcategory->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductCategory']))
            $productcategory->attributes = $_GET['ProductCategory'];
        
        $webstoreproductgroup = new WebstoreProductGroup();
        $webstoreproductgroup->webstoreId = $id;
        
        $this->render('view', array(
            'model' => $model,
            'productGroup'=>$productGroup,
            'webstoreproductgroup'=>$webstoreproductgroup,
            'pricelist'=>$pricelist,
            'productcategory'=>$productcategory
            
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        //print_r($_POST);
        $model = new WebStore;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);
        
        if (isset($_POST['WebStore'])) {
            $model->unsetAttributes();  // clear any default values
            $model->attributes = $_POST['WebStore'];
            $uploadedFile = CUploadedFile::getInstance($model, 'imagelogo');
            
            $model->imagelogo = $uploadedFile->name;
            $model->createdDate = date('Y-m-d', strtotime('now'));
            $model->createdBy = Yii::app()->user->id;
            
            $uuid= Yii::app()->db->createCommand('select UUID()')->queryScalar();
            $model->uuid = $uuid;
            if($model->save()){
                $this->redirect(array('view', 'id' => $model->id));
            }
            
                    
            
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['WebStore'])) {
            $model->attributes = $_POST['WebStore'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('WebStore');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new WebStore('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['WebStore']))
            $model->attributes = $_GET['WebStore'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }
    
    public function actionDashboard() {
        $userId = Yii::app()->user->id;
        $user = User::model()->findByPk($userId);
        $model = $this->loadModel($user->webstoreId);
        
        $htmlcontentFile = 'files/webstore/dashboard/adminTemplate.html';
        $htmlcontent = file_get_contents($htmlcontentFile);

        $this->render('dashboard', array(
            'model' => $model,
            'adminTemplate'=>$htmlcontent,
        ));
    }
    
    public function actionManageTemplate() {
        $model = new WebStore('search');
        $htmlcontentFile = 'files/webstore/dashboard/adminTemplate.html';
        
        $model->unsetAttributes();  // clear any default values
        if (isset($_POST['WebStore']) && isset($_POST['wysiwyg_save_btn'])){
            $model->attributes = $_POST['WebStore'];
            file_put_contents($htmlcontentFile, $model->wysiwygContent);
        }
            

        
        $model->wysiwygContent = file_get_contents($htmlcontentFile);
        
        
        
        $this->render('manageTemplate', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = WebStore::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'web-store-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }
    
    
    public function actionUpdateCheckBoxSetings() {
        $webstoreId = $_POST['webstoreId'];
        $checked = $_POST['checked'];
        $attr = $_POST['attr'];
        
        $model = $this->loadModel($webstoreId);
        $model->$attr = $checked;
        $model->save(false);
        
        
    }
    
    
    public function actionUpdateWebStoreField() {
        $webstoreId = $_POST['webstoreId'];
        $field = $_POST['field'];
        $val = $_POST['val'];
        
        $model = $this->loadModel($webstoreId);
        
        $model->$field = $val;
        
        
        if($model->save(false)){
            echo json_encode(array('success'=>'true'));
        }else{
            echo json_encode(array('success'=>'false'));
        }
    }
    
    
    

}
