<?php

class WebstoreOrderController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $model = $this->loadModel($id);



        if ($model->estimatedDeliveryDate) {
            $model->estimatedDeliveryDate = date(GlobalVars::get("DateFormat"), strtotime($model->estimatedDeliveryDate));
        }


        $this->render('view', array(
            'model' => $model,
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new WebstoreOrder;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['WebstoreOrder'])) {
            $model->attributes = $_POST['WebstoreOrder'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['WebstoreOrder'])) {
            $model->attributes = $_POST['WebstoreOrder'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('WebstoreOrder');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new WebstoreOrder('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['WebstoreOrder']))
            $model->attributes = $_GET['WebstoreOrder'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = WebstoreOrder::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'webstore-order-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionUpdateHeader() {
        $id = $_POST['id'];
        $dateval = $_POST['dateval'];
        $model = $this->loadModel($id);
        $model->estimatedDeliveryDate = date('Y-m-d', strtotime($dateval));
        $model->save(false);
    }

    public function actionProcessOrder($id) {
        
    }

    private function processOnInventoryJob($order) {
        $quote = $order->createQuote(2);
        if ($quote) {
            $workorder = $quote->createWorkOrder();
            if ($workorder) {
                return $workorder->createJob();
            }
        }

        return null;
    }

    private function processOnDemandJob($order) {

        $quote = $order->createQuote(1);
        if ($quote) {
            $workorder = $quote->createWorkOrder();
            if ($workorder) {
                return $workorder->createJob();
            }
        }

        return null;
    }

    public function actionCompleteOrder($id) {
        $model = $this->loadModel($id);
        $status = Status::model()->find(array('condition' => "name = 'Order Completed'"));
        $model->statusId = $status->id;
        if ($model->save(false)) {
            Yii::app()->user->setFlash('success', "Web order [$model->orderNumber] has been completed successfully!");
        } else {
            Yii::app()->user->setFlash('error', "Cannot complete web order [$model->orderNumber].");
        }

        $this->redirect(array('view', 'id' => $model->id));
    }

    public function actionCancel($id) {
        $model = $this->loadModel($id);
        $status = Status::model()->find(array('condition' => "name = 'Cancelled'"));
        $model->statusId = $status->id;
        if ($model->save(false)) {
            if ($model->on_inventory_job_id) {

                $invoices = Invoice::model()->findAll(array('condition' => "job_id = $model->on_inventory_job_id"));
                foreach ($invoices as $data) {
                    Inventory::model()->deleteAll("invoice_id = $data->id");
                }
            }


            Yii::app()->user->setFlash('success', "Web order [$model->orderNumber] has been cancelled successfully!");
        } else {
            Yii::app()->user->setFlash('error', "Cannot cancel the web order [$model->orderNumber].");
        }

        $this->redirect(array('view', 'id' => $model->id));
    }

    public function actionReject($id) {

        $order = $this->loadModel($id);
        $status = Status::model()->find(array('condition' => "name = 'Rejected'"));
        $order->statusId = $status->id;
        $order->statusUpdatedAt = date('Y-m-d');
        $order->statusChangedBy = Yii::app()->user->id;
        if ($order->save(false)) {
            $webstore = WebStore::model()->findByPk($order->webstore_id);
            $webuser = WebstoreUser::model()->findByPk($order->webstore_user_id);
            $customer = Customer::model()->findByPk($webuser->customer_id);

            //Inventory qty added
            $orderDetails = WebstoreOrderDetail::model()->findAll(array('condition' => "webstoreOrderId = $order->id"));
            foreach ($orderDetails as $dtl) {

                $product = ProductLine::model()->findByPk($dtl->productId);
                $product->qty_on_hand += $dtl->requestQty;
                $product->qty_available += $dtl->requestQty;
                $product->save(false);
            }


            if ($customer->cusemail) {
                $mailer = Yii::app()->MultiMailer->to($customer->cusemail, 'Recipient');
                $mailer->subject($webstore->name);
                $bodyhtml = '<h3>Order Reject [ ' . $order->orderNumber . ' ]</h3><p>Your order [ ' . $order->orderNumber . ' ] has been rejected.</p>';


                $mailer->body($bodyhtml);
                if ($mailer->send()) {
                    
                }
            }
            Yii::app()->user->setFlash('success', "Order [$order->orderNumber] has been rejected successfully!");
            $this->redirect(array('admin'));
        } else {
            Yii::app()->user->setFlash('error', "Cannot reject the web order. Some error occured!");
            $this->redirect(array('view', 'id' => $order->id));
        }

        $this->redirect(array('view', 'id' => $order->id));
    }

    public function actionApprove($id) {
        $order = $this->loadModel($id);
        $status = Status::model()->find(array('condition' => "name = 'Approved'"));
        $order->statusId = $status->id;
        $order->statusUpdatedAt = date('Y-m-d');
        $order->statusChangedBy = Yii::app()->user->id;
        if ($order->save(false)) {
            $webstore = WebStore::model()->findByPk($order->webstore_id);
            $webuser = WebstoreUser::model()->findByPk($order->webstore_user_id);
            $customer = Customer::model()->findByPk($webuser->customer_id);
            if ($customer->cusemail) {
                $mailer = Yii::app()->MultiMailer->to($customer->cusemail, 'Recipient');
                $mailer->subject($webstore->name);
                $bodyhtml = '<h3>Order Approval [ ' . $order->orderNumber . ' ]</h3><p>Your order [ ' . $order->orderNumber . ' ] has been approved.</p>';
                if ($order->estimatedDeliveryDate) {
                    $estimatedDeliverDate = date(GlobalVars::get("DateFormat"), strtotime($order->estimatedDeliveryDate));
                    $bodyhtml .= ' Estimated delivery date is ' . $estimatedDeliverDate;
                }
                $mailer->body($bodyhtml);
                if ($mailer->send()) {
                    
                }
            }
            Yii::app()->user->setFlash('success', "Order [$order->orderNumber] has been approved successfully!");
        } else {
            Yii::app()->user->setFlash('error', "Cannot approve the web order. Some error occured!");
        }

        $this->redirect(array('view', 'id' => $order->id));
    }

    public function actionCreateJob($id) {
        $transaction = Yii::app()->db->beginTransaction();
        $dataSaved = true;
        $order = $this->loadModel($id);


        $webstore = WebStore::model()->findByPk($order->webstore_id);
        $jobIdArr = array();



        $backorderdtls = WebstoreOrderDetail::model()->findAll(array('condition' => "webstoreOrderId = $order->id and isBackOrder = 1"));





        if (count($backorderdtls) > 0) {
            $quote = $order->createQuote($backorderdtls, 1);
            if ($quote) {

                $workorder = $quote->createWorkOrder();
                if ($workorder) {

                    $job = $workorder->createJob();
                    if ($job) {

                        $jobIdArr["BackOrder"] = $job->id;
                        $message .= "Job [$job->jobNum] has been created for back order.</br>";

                        if ($webstore->autoCreateInvoice) {
                            $invoice = $job->createInvoice();
                            if ($invoice) {
                                $message .= "Invoice [$invoice->invoiceNum] has been created for back order.</br>";
                            } else {
                                $error_message .= "Failed to  create the invoice for back order.<br>";
                                $dataSaved = false;
                            }
                        }
                    } else {
                        $error_message .= "Failed to  create the job for back order.<br>";
                        $dataSaved = false;
                    }
                } else {
                    $error_message .= "Failed to  create the workorder for back order.<br>";
                    $dataSaved = false;
                }
            } else {
                $error_message .= "Failed to  create the quotation for back order.<br>";
                $dataSaved = false;
            }
        }



        $inventoryorderdtls = WebstoreOrderDetail::model()->findAll(array('condition' => "webstoreOrderId = $order->id and (isBackOrder <> 1 or isBackOrder is null)"));

        if (count($inventoryorderdtls) > 0) {

            $quote = $order->createQuote($inventoryorderdtls, 0);
            if ($quote) {

                $workorder = $quote->createWorkOrder();
                if ($workorder) {

                    $job = $workorder->createJob();
                    if ($job) {

                        $jobIdArr["inventory"] = $job->id;
                        $message .= "Job [$job->jobNum] has been created for inventory order.</br>";

                        if ($webstore->autoCreateInvoice) {
                            $invoice = $job->createInvoice();
                            if ($invoice) {

                                $message .= "Invoice [$invoice->invoiceNum] has been created for inventory order.</br>";
                            } else {
                                $error_message .= "Failed to  create the invoice for inventory order.<br>";
                                $dataSaved = false;
                            }
                        }
                    } else {
                        $error_message .= "Failed to  create the job for inventory order.<br>";
                        $dataSaved = false;
                    }
                } else {
                    $error_message .= "Failed to  create the workorder for inventory order.<br>";
                    $dataSaved = false;
                }
            } else {
                $error_message .= "Failed to  create the quotation for inventory order.<br>";
                $dataSaved = false;
            }
        }

        $statusConvertedJob = Status::model()->find(array('condition' => "name = 'Converted to Job'"));
        $order->jobId = isset($jobIdArr["inventory"]) ? $jobIdArr["inventory"] : null;
        $order->backOrderJobId = isset($jobIdArr["BackOrder"]) ? $jobIdArr["BackOrder"] : null;
        $order->statusId = $statusConvertedJob->id;
        $order->statusUpdatedAt = date('Y-m-d');
        $order->statusChangedBy = Yii::app()->user->id;
        if (!$order->save(false)) {

            $error_message .= "Order is not saved properly.<br>";
            $dataSaved = false;
        }




        if ($dataSaved) {
            $transaction->commit();
            Yii::app()->user->setFlash('success', $message);
        } else {
            $transaction->rollBack();

            Yii::log($error_message, 'warning', 'system.backend.WebstoreOrderController.actionCreateJob');

            Yii::app()->user->setFlash('error', $error_message);
        }


        $this->redirect(array('view', 'id' => $order->id));
    }

    public function actionUpdateField() {
        $data = array();
        $id = $_POST['id'];
        $field = $_POST['field'];
        $value = $_POST['value'];

        $saved = true;

        if ($field == 'estimatedDeliveryDate') {
            //don't sync SO or Job with quote due date, because of there might have more than one SO and Jobs for a particular quote
            $formateddate = date('Y-m-d', strtotime($value));
            $saved = WebstoreOrder::model()->updateByPk($id, array(
                "$field" => $formateddate
            ));
            $data['success'] = true;
            echo json_encode($data);
        } else {

            $model = $this->loadModel($id);

            if ($field === 'postal_code_freight_charge') {
                $model->$field = floatval(str_replace(',', '', $value));
            } else {
                $model->$field = $value;
            }



            if ($model->save(false)) {

                //recalculate freight based on location only when following fields are changed
                if (in_array($field, array('isThirdpartyDelivery', 'postalCode', 'postalCode1', 'suburb', 'suburb2'))) {
                    $model->reCalculateFreight();
                }
                //optional parameter to send
                if (in_array($model->postal_code_freight_charge, array(0, 0.00, 0.0, null, '', ""))) {
                    $has_freight = "no";
                } else {
                    $has_freight = "yes";
                }
                //anyway recalculate grand total
                $grandTotal = ($model->totalExGst * $model->gstRate) + $model->postal_code_freight_charge;

                echo json_encode(array('success' => 'true', 'has_freight' => $has_freight, 'postal_code_freight_charge' => number_format($model->postal_code_freight_charge, 2), 'grand_total' => number_format($grandTotal, 2)));
            }
        }
    }

    public function actionPrint($id) {


        $model = $this->loadModel($id);
        $job = Jobs::model()->findByPk($model->jobId);
        $url = Yii::app()->createUrl('webstoreOrder/view', array("id" => $model->id));
        $link = CHtml::link($model->orderNumber, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'Web Order ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($job->quote_id, $job->workorder->id, $job->quoteNum, 'WebOrder', "Web Order ({$link}) is printed", 1, 1, 1);
        }

        
        $htmlcontent = $this->renderInternal('protected/views/webstoreOrder/weborder_html.php', array('model' => $model), true);
        
        $pdfCreator = new CommonPDFCreator(array(
				'title' => 'Web Order',
				'content' => $htmlcontent,
				'pageNumber' => '{PAGENO}',
				'outputFileName' => $model->orderNumber . "_". time().".pdf"
			));
        
        $pdfCreator->generate();	
    }

}
