<?php

class WebstorePriceListController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new WebstorePriceList;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['WebstorePriceList'])) {
            $model->attributes = $_POST['WebstorePriceList'];
            $fileName = CUploadedFile::getInstance($model, 'uploadFile');
            $imageName = CUploadedFile::getInstance($model, 'uploadImage');
            $model->createdDate = date('Y-m-d');
            $model->createdBy = Yii::app()->user->id;
            if ($model->save()) {
                $dirpath_pricelist = Yii::app()->basePath . '/../files/pricelist/' . $model->webstoreId;

                if (!file_exists($dirpath_pricelist))
                    mkdir($dirpath_pricelist, 0777, true);

                $dirpath_img = Yii::app()->basePath . '/../images/pricelistimg/' . $model->webstoreId;

                if (!file_exists($dirpath_img))
                    mkdir($dirpath_img, 0777, true);



                $pricelistname = 'pl' . time() . $model->id;
                $pricelistfilename = $pricelistname . '.' . $fileName->getExtensionName();

                $fileName->saveAs($dirpath_pricelist . '/' . $pricelistfilename);

                $pricelistimgname = $pricelistname . '.' . $imageName->getExtensionName();

                $imageName->saveAs($dirpath_img . '/' . $pricelistimgname);

                $model->fileName = $pricelistfilename;
                $model->imageName = $pricelistimgname;
                $model->save();

                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);
        

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['WebstorePriceList'])) {
            $model->attributes = $_POST['WebstorePriceList'];
            $fileName = CUploadedFile::getInstance($model, 'uploadFile');
            $imageName = CUploadedFile::getInstance($model, 'uploadImage');
            $model->createdDate = date('Y-m-d');
            $model->createdBy = Yii::app()->user->id;
            if ($model->save()) {

                $pricelistname = 'pl' . time() . $model->id;

                if ($fileName) {
                    //file upload
                    $dirpath_pricelist = Yii::app()->basePath . '/../files/pricelist/' . $model->webstoreId;

                    if (!file_exists($dirpath_pricelist))
                        mkdir($dirpath_pricelist, 0777, true);

                    if ($model->fileName) {
                        if (file_exists($dirpath_pricelist . '/' . $model->fileName)) {
                            unlink($dirpath_pricelist . '/' . $model->fileName);
                        }
                    }

                    $pricelistfilename = $pricelistname . '.' . $fileName->getExtensionName();

                    $model->fileName = $pricelistfilename;

                    $fileName->saveAs($dirpath_pricelist . '/' . $pricelistfilename);
                }

                //image upload


                if ($imageName) {
                    $dirpath_img = Yii::app()->basePath . '/../images/pricelistimg/' . $model->webstoreId;

                    if (!file_exists($dirpath_img))
                        mkdir($dirpath_img, 0777, true);

                    if ($model->imageName) {
                        if (file_exists($dirpath_img . '/' . $model->imageName)) {
                            unlink($dirpath_img . '/' . $model->imageName);
                        }
                    }

                    $pricelistimgname = $pricelistname . '.' . $imageName->getExtensionName();

                    $imageName->saveAs($dirpath_img . '/' . $pricelistimgname);


                    $model->imageName = $pricelistimgname;
                }


                $model->save();

                $this->redirect(array('view', 'id' => $model->id));
            }
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('WebstorePriceList');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new WebstorePriceList('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['WebstorePriceList']))
            $model->attributes = $_GET['WebstorePriceList'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = WebstorePriceList::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'webstore-price-list-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionDownloadFile($id) {

        $model = $this->loadModel($id);

        $dirpath_pricelist = Yii::app()->basePath . '/../files/pricelist/' . $model->webstoreId . '/' . $model->fileName;



        if (file_exists($dirpath_pricelist)) {
            Yii::app()->getRequest()->sendFile($model->fileName, file_get_contents($dirpath_pricelist));
        }
    }

}
