<?php

class WebstoreUserController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {

        $model = $this->loadModel($id);

        $userstore = new WebstoreUserStore();
        $userstore->web_user_id = $model->id;

        $websrore = new WebStore();
        if (isset($_GET['WebStore'])) {
            $websrore->attributes = $_GET['WebStore'];
        }
        
        $websroreUserBudgets = new WebstoreUserBudget();
        if (isset($_GET['WebstoreUserBudget'])) {
            $websroreUserBudgets->attributes = $_GET['WebstoreUserBudget'];
        }


        $this->render('view', array(
            'model' => $model,
            'userstore' => $userstore,
            'websrore' => $websrore,
            'websroreUserBudgets' => $websroreUserBudgets
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new WebstoreUser;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['WebstoreUser'])) {
            $model->attributes = $_POST['WebstoreUser'];
            $model->password ? $model->password = md5($model->password) : null;
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);
        $oldPassword = $model->password;


        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['WebstoreUser'])) {
            
            $model->attributes = $_POST['WebstoreUser'];
            if ($oldPassword == $model->password) {
                $model->password = $oldPassword;
            } else {
                $model->password = md5($model->password);
            }

            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('WebstoreUser');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {

        $model = new WebstoreUser('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['WebstoreUser']))
            $model->attributes = $_GET['WebstoreUser'];


        $logmessage = null;
        if (isset($_POST['WebstoreUser'])) {
            $model->attributes = $_POST['WebstoreUser'];

            //if ($model->validate()) {
            if (isset($_POST['import_btn']) && isset($_POST['WebstoreUser']['importFile'])) {
                if (isset($_POST['WebstoreUser']['webstore_user_store_id']) && count($_POST['WebstoreUser']['webstore_user_store_id']) > 0) {
                    $user_web_stores = $_POST['WebstoreUser']['webstore_user_store_id'];

                    $model->importFile = CUploadedFile::getInstance($model, 'importFile');
                    if (!empty($model->importFile)) {
                        $logmessage = $this->importFile($model, $user_web_stores);
                        if (!empty($logmessage['webstore_user_msg'])) {
                            Yii::app()->user->setFlash('success', "Customers have been imported successfully! Please refer to the below import log detail.");
                        }

                        if (!empty($logmessage['customer_msg'])) {
                            Yii::app()->user->setFlash('notice', "There are some issues in your import file! Please refer to the below import log detail.");
                        }

                        if (!empty($logmessage['webstore_user_error'])) {
                            Yii::app()->user->setFlash('error', "There are some errors in your import file! Please refer to the below import log detail.");
                        }
                    }
                } else {
                    Yii::app()->user->setFlash('notice', "You should select at least one web store to import customer list.");
                }
            }
            //}
        }

        $this->render('admin', array(
            'model' => $model, 'logmessage' => $logmessage
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = WebstoreUser::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'webstore-user-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function importFile($model, $user_web_stores) {
        Yii::import('application.vendors.PHPExcel', true);

        $filenametobesave = 'files/tmp/' . time() . '.' . $model->importFile->getExtensionName();
        $model->importFile->saveAs($filenametobesave);
        try {
            if ($model->importFile->getExtensionName() == "xls") {
                $objReader = new PHPExcel_Reader_Excel5();
                $data = $objReader->load($filenametobesave);
                $objWorksheet = $data->getActiveSheet();
                $highestRow = $objWorksheet->getHighestRow();
            } else if ($model->importFile->getExtensionName() == "xlsx") {
                $inputFileType = PHPExcel_IOFactory::identify($filenametobesave);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $objReader->setReadDataOnly(true);
                $data = $objReader->load($filenametobesave);
                $objWorksheet = $data->getSheet(0);
                $highestRow = $objWorksheet->getHighestRow();
            }
        } catch (Exception $e) {
            dir("Error loading file " . pathinfo($filenametobesave, PATHINFO_BASENAME) . '": ' . $e->getMessage());
        }

        $message = array();
        //$transaction = Yii::app()->db->beginTransaction();
        //check qty title for a valid data row
        for ($i = 1; $i <= $highestRow; $i++) {

            //customer display id must be consisted of both alpha and numeric characters
            $myobCustomerDisplayId = trim($objWorksheet->getCellByColumnAndRow(0, $i)->getValue());
            if (ctype_alnum($myobCustomerDisplayId)) {
                //check if alpha or numeric
                if (!ctype_alpha($myobCustomerDisplayId) && !ctype_digit($myobCustomerDisplayId)) {
                    //check for both alpha and numeric

                    $lastName = htmlspecialchars(trim($objWorksheet->getCellByColumnAndRow(1, $i)->getValue()), ENT_QUOTES);
                    $customerPassword = trim($objWorksheet->getCellByColumnAndRow(2, $i)->getValue());
                    if (!$customerPassword) {
                        $message['webstore_user_error'] .= "<br>Password not found for the customr on line [{$i}]: $myobCustomerDisplayId";
                        continue;
                    }

                    $masterCustomer = MasterCustomer::model()->find(array('condition' => "displayIdMYOB = '$myobCustomerDisplayId'"));
                    $customer = null;
                    if ($masterCustomer) {
                        $customer = Customer::model()->find(array('condition' => "myob_uuid = '$masterCustomer->myob_uuid'"));
                    } else {
                        $message['customer_msg'] .= "<br>Coudn't found the master customer for card ID : $myobCustomerDisplayId";
                    }

                    $webuser = null;
                    if ($customer) {
                        $webuser = WebstoreUser::model()->find(array('condition' => "customer_id = $customer->cussno"));
                    } else {
                        $message['customer_msg'] .= "<br>Coudn't found the customer for card ID : $myobCustomerDisplayId";
                    }
                    if (!$webuser) {
                        $webuser = WebstoreUser::model()->find(array('condition' => "username = '{$myobCustomerDisplayId}' and companyName = '{$lastName}'"));
                    }

                    if (!$webuser) {
                        $webuser = new WebstoreUser();
                        $webuser->username = $myobCustomerDisplayId;
                        $webuser->password = md5($customerPassword);
                        $webuser->customer_id = $customer ? $customer->cussno : null;
                        $webuser->companyName = $lastName;
                        if ($webuser->save(false)) {
                            foreach ($user_web_stores as $key => $value) {
                                $webstoreuserstore = new WebstoreUserStore();
                                $webstoreuserstore->web_user_id = $webuser->id;
                                $webstoreuserstore->webstore_id = $value;
                                $webstoreuserstore->save(false);
                            }
                            $message['webstore_user_msg'] .= "<br>New customer login has been created : $lastName [{$myobCustomerDisplayId}]";
                        }
                    } else {
                        $webuser->username = $myobCustomerDisplayId;
                        $webuser->password = md5($customerPassword);
                        $webuser->customer_id = $customer ? $customer->cussno : null;
                        $webuser->companyName = $lastName;
                        if ($webuser->save(false)) {
                            foreach ($user_web_stores as $key => $value) {
                                $webstoreuserstore = WebstoreUserStore::model()->find(array('condition' => "web_user_id = $webuser->id and webstore_id = $value"));
                                if (!$webstoreuserstore) {
                                    $webstoreuserstore = new WebstoreUserStore();
                                    $webstoreuserstore->web_user_id = $webuser->id;
                                    $webstoreuserstore->webstore_id = $value;
                                    $webstoreuserstore->save(false);
                                }
                            }
                            $message['webstore_user_msg'] .= "<br>Customer login has been updated for the customer : $lastName [{$myobCustomerDisplayId}]";
                        }
                    }
                }
            } else {
                $message['webstore_user_error'] .= "<br>Found incorrect format of username on line [{$i}]: $myobCustomerDisplayId";
            }
        }
        //$transaction->rollback();
        return $message;
    }

    public function actionAddWebstores() {

        $webcusId = $_POST['webcusid'];
        $webstoreIds = $_POST['webstoreIds'];

        if (isset($_POST['webstoreIds']) && count($webstoreIds)) {
            
            foreach ($webstoreIds as $key => $val) {
                $storeUserStore = WebstoreUserStore::model()->find(array('condition' => "web_user_id = {$webcusId} and webstore_id = {$val}"));
                if (!$storeUserStore) {
                    $storeUserStore = new WebstoreUserStore();
                    $storeUserStore->web_user_id = $webcusId;
                    $storeUserStore->webstore_id = $val;
                    $storeUserStore->save();
                }
            }
        }
        
        echo json_encode(array('success' => true));
    }

}
