<?php

class WorkOrderAcceptController extends Controller
{
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		array('allow', // allow admin user to perform 'admin' and 'delete' actions
			'actions' => array('index', 'onlineAccept'),
			'users' => array('*'),
		);
	}

	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column2';

	public function actionIndex($id)
	{
		if ($workOrderId = WorkorderOnlineAcceptenceLog::validateLinkSecret($id)) {
			$workOrder = Workorder::model()->findByPk($workOrderId);
			$so_template = $this->renderInternal('protected/views/workOrderAccept/so_template.php', array('model' => $workOrder), true);
			$this->render('index', array(
				'workOrder' => $workOrder,
				'so_template' => $so_template
			));
		} else {
			$this->render('error');
		}
	}

	public function actionOnlineAccept()
	{
		if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
			//check acceptance secert validaion
			$acceptType = $_POST['accepttype'];
			$linkSecret = $_POST['linkSecret'];
			$comment = $_POST['comment'];
			if ($workOrderId = WorkorderOnlineAcceptenceLog::validateLinkSecret($linkSecret)) {

				$transaction = Yii::app()->db->beginTransaction();

				$workOrder = Workorder::model()->findByPk($workOrderId);
				
				//create new acceptace log
				$lastAcceptLogAttributes = $workOrder->onlineAcceptenceLog->attributes;

				$lastAcceptLogAttributes['link_active'] = WorkorderOnlineAcceptenceLog::LINK_STATUS_INACTIVE;

				$acceptTypeMessageOnSuccess;
				$acceptTypeMessageOnFail;
				switch (intval($acceptType)) {
					case WorkorderOnlineAcceptenceLog::LOG_STATUS_ACCEPT:
						$lastAcceptLogAttributes['status_id'] = WorkorderOnlineAcceptenceLog::LOG_STATUS_ACCEPT;
						$acceptTypeMessageOnSuccess = 'Online SO Accepted!';
						$acceptTypeMessageOnFail = 'Online SO acceptance failed! Please contact admin or try again later!';
						break;

					case WorkorderOnlineAcceptenceLog::LOG_STATUS_DECLINE:
						$lastAcceptLogAttributes['status_id'] = WorkorderOnlineAcceptenceLog::LOG_STATUS_DECLINE;
						$acceptTypeMessageOnSuccess = 'Online SO Declined!';
						$acceptTypeMessageOnFail = 'Online SO decline failed! Please contact admin or try again later!';

						break;
				}

				
				$lastAcceptLogAttributes['cutomer_comment'] = $comment;
				
				$lastAcceptLogAttributes['user_data'] = json_encode($_SERVER);
				
				

				$logId = WorkorderOnlineAcceptenceLog::write($lastAcceptLogAttributes);		

				$workOrder->so_online_acceptence_log_id = $logId;
				
				//diasable all other logs' links related this quote
				
				WorkorderOnlineAcceptenceLog::dasableAllLinks($workOrder->id);
				
				if ($workOrder->save(false)) {
					$transaction->commit();
					//response array
					echo json_encode(array(
						'status' => 1, //success
						'message' => $acceptTypeMessageOnSuccess
					));
				} else {
					$transaction->rollback();
					//response array
					echo json_encode(array(
						'status' => 0, //failed
						'message' => $acceptTypeMessageOnFail
					));
				}
			} else {
				//response array
				echo json_encode(array(
					'status' => 0, //failed
					'message' => 'The request is not validated! Please don\'t repeat this request again!'
				));
			}
		} else {
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
		}
	}

	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}