<?php

class WorkorderController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'admin', 'delete', 'confirm', 'cancel',
                    'converttoJob', 'print', 'sendToaApproval', 'editWorkorder', 'sendSOToConfirm'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'confirm', 'cancel', 'converttoJob', 'print',
                    'sendToaApproval', 'editWorkorder', 'saveWorkorderDetails', 'fullQtyDiff', 'uploadAjaxHeader',
                    'cusAdmin', 'cusReject', 'cusApproval'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        if (isset($_GET['quoteID'])) {
            $quotation = Quatation::model()->findByPk($_GET['quoteID']);
            if (!$quotation) {
                throw new CHttpException(404, 'The requested page does not exist.');
            }

            if (!$quotation->customer) {
                Yii::app()->user->setFlash('notice', "Please ensure that you have entered <b>customer details</b> of the quotation, before converting it to sales order!");
                $this->redirect(array('quatation/view', 'id' => $quotation->id));
            }

            if (!count($quotation->RelDtls)) {
                Yii::app()->user->setFlash('notice', "Please ensure that you have entered <b>at least one item</b> for the quotation, before converting it to sales order!");
                $this->redirect(array('quatation/view', 'id' => $quotation->id));
            }
        }

        $orderConvertType = isset($_GET['mode']) ? $_GET['mode'] : 1;        

        //init factory method and call
        $orderCreator = new WorkOrderConvertor($quotation);
        $orderCreator->setOrderConvertType($orderConvertType);
        //SWorkOrder wraps the original workorder model
        $sOrder = $orderCreator->getOrder();

        //Get the active model object from the SWorkOrder
        if ($workorder = $sOrder->getOrderModel()) {

            if(SystemOptions::getOptions()->quoteToJob) {
                //convert quote direclty into a job
                $workorder->status_id = Status::model()->find(array('condition' => 'name=:status', 'params' => array(':status' => 'Confirmed')))->id;

                if($workorder->save(false)) {
                    $this->redirect(array('converttoJob', 'id' => $workorder->id));
                }
            }

            $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $workorder->id));
            $link = CHtml::link($workorder->salesorderNumber, $url, array('target' => '_blank'));
            SalesLog::createSalesLog($quotation->id, $workorder->id, $quotation->quoteno, 'Quotation', "Sales order ({$link}) is created ", 0, 1, 1);

            Yii::app()->user->setFlash('success', "Sales order  ($workorder->salesorderNumber) is successfully created.");
        } else {

            Yii::app()->user->setFlash('error', "Cannot create a sales order from quote : ($quotation->quoteno)! Try again or contact admin!");
        }



        $this->redirect(array('editWorkorder', 'id' => $workorder->id));
    }

    public function actionEditWorkorder($id) {
        $workorder = $this->loadModel($id);
        
        //cross checking and fixing the line total amount if mismatch
        $workorder->recalculateLineTotals();


        $quotation = $workorder->quotation; // Quatation::model()->findByPk($workorder->quotationId);
        $workoderDetails = new Workorderdetails;
        $workoderDetails->workorderId = $workorder->id;

        $selectproducts = new ProductLine('searchForSelectPopup');
        //$selectproducts->unsetAttributes();  // clear any default values
        if (isset($_GET['ProductLine']))
            $selectproducts->attributes = $_GET['ProductLine'];

        $selectdeco = new Decoration('searchForSelectPopup');
        $selectdeco->unsetAttributes();  // clear any default values
        if (isset($_GET['Decoration']))
            $selectdeco->attributes = $_GET['Decoration'];

        $othercost = new OtherCostType('search');
        $othercost->unsetAttributes();  // clear any default values
        if (isset($_GET['OtherCostType']))
            $othercost->attributes = $_GET['OtherCostType'];

        $selectQuoteDetails = new QuatationDetails('searchForSelectPopup');
        $selectQuoteDetails->unsetAttributes();  // clear any default values
        if (isset($_GET['QuatationDetails']))
            $selectQuoteDetails->attributes = $_GET['QuatationDetails'];

        //GWS API data fileter and provider
        $postFields = GwsProductApi::getDefaultPostFields();

        $gwsProductApiFilter = new GwsProductApiFilterForm;
        $gwsProductApiFilter->unsetAttributes();  // clear any default values
        if (isset($_GET['GwsProductApiFilterForm'])) {
            $gwsProductApiFilter->attributes = $_GET['GwsProductApiFilterForm'];
            // validate user input and redirect to the previous page if valid
            if ($gwsProductApiFilter->validate()) {
                $postFields['data'] = array(
                    'supplier' => $gwsProductApiFilter->supplier,
                    'product_code' => $gwsProductApiFilter->product_code,
                    'product_Name' => $gwsProductApiFilter->product_Name,
                    'category' => $gwsProductApiFilter->category
                );
            }
        }



        $gwsProductApiDataProvider = GwsProductApi::dataProvider($postFields);

        $duedate = trim($workorder->dueDate);
        if (empty($duedate)) {
            $dueinXdays = GlobalVars::get("DueInXDays");
            $duedate = strtotime("+$dueinXdays day");
            $workorder->dueDate = date(GlobalVars::get("DateFormat"), $duedate);
        } else {
            $workorder->dueDate = date(GlobalVars::get("DateFormat"), strtotime($duedate));
        }

        $this->render('workorder', array(
            'model' => $quotation,
            'workorder' => $workorder,
            'workoderDetails' => $workoderDetails,
            'selectproducts' => $selectproducts,
            'selectdeco' => $selectdeco,
            'othercost' => $othercost,
            'selectQuoteDetails' => $selectQuoteDetails,
            'gwsProductApiFilter' => $gwsProductApiFilter,
            'gwsProductApiDataProvider' => $gwsProductApiDataProvider
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Workorder'])) {
            $model->attributes = $_POST['Workorder'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    public function actionUploadAjaxHeader() {



        if (Yii::app()->request->isAjaxRequest) {

            try {

                if (!isset($_POST['model-id']) || !intval($_POST['model-id'], 10)) {
                    Yii::log(json_encode($_POST), 'warning', 'system.*');
                    throw new Exception('Bad request model-id!', 400);
                }

                if (!isset($_POST['attr-model-field-pair'])) {
                    Yii::log(json_encode($_POST), 'warning', 'system.*');
                    throw new Exception('Bad request attr-model-field-pair!', 400);
                }

                if (!isset($_POST['attr-value'])) {
                    Yii::log(json_encode($_POST), 'warning', 'system.*');
                    throw new Exception('Bad request attr-value!', 400);
                }

                $modelId = $_POST['model-id'];
                $attrModelFieldPair = $_POST['attr-model-field-pair'];
                $attrPairArr = explode('-', $attrModelFieldPair);
                $value = htmlspecialchars($_POST['attr-value']);




                if (count($attrPairArr) !== 2) {
                    throw new Exception('Bad request attr-model-field-pair not matched! [' . json_encode($attrPairArr) . ']', 400);
                }

                $field = $attrPairArr[1];

                $model = $this->loadModel($modelId); //workorder


                if ($attrPairArr[0] === 'workorder' && !in_array($field, array('dueDate', 'followupStatus'))) {

                    $saved = Workorder::model()->updateByPk($modelId, array(
                        "$field" => $value
                    ));
                } elseif ($attrPairArr[0] === 'customer') {

                    if (!$model->customer) {
                        throw new Exception('Customer not found exception', 404);
                    }

                    $saved = Customer::model()->updateByPk($model->customer->cussno, array(
                        "$field" => $value
                    ));
                }



                $arr = array();

                if ($attrPairArr[0] === 'workorder') {

                    if ($field === 'ws_user_id' && $model->ws_user_id !== $value) {
                        $model->ws_user_id = $value;

                        $salesperson = SalesPerson::model()->findByPk($model->ws_user_id);

                        if (!empty($salesperson)) {
                            $model->ws_user = $salesperson->name;
                            $job = Jobs::model()->find(array('condition' => "workorder_id = '{$modelId}'"));
                            if (!empty($job)) {
                                $job->ws_user = $salesperson->name;
                                $job->ws_user_id = $model->ws_user_id;
                                $job->save(false);

                                SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Job', "Sales person is changed to $salesperson->name", 1, 1, 1);
                                SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Sales person is changed to $model->ws_user", 1, 1, 1);
                            }
                        }

                        $model->save();
                    }

                    if ($field === 'prd_cordinator_id' && $model->prd_cordinator_id !== $value) {

                        $cordinatorname = User::model()->findByPk($value)->username;
                        SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Production Coordinator is changed to $cordinatorname", 1, 1, 1);

                        $job = Jobs::model()->find(array('condition' => "workorder_id = '{$modelId}'"));

                        if (!empty($job)) {
                            $job->prd_cordinator_id = $value;
                            $job->save(false);

                            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Job', "Production Coordinator is changed to $cordinatorname", 1, 1, 1);
                        }
                    }

                    if ($field === 'customerpono' && $model->customerpono !== $value) {

                        SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Customer PO# is changed to $value", 1, 1, 1);

                        $job = Jobs::model()->find(array('condition' => "workorder_id = '{$modelId}'"));

                        if (!empty($job)) {
                            $job->customerpono = $value;
                            $job->save(false);

                            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Job', "Customer PO# is changed to $model->customerpono", 1, 1, 1);
                        }
                    }



                    if ($field === 'dueDate' && $model->dueDate !== $value) {
                        $dueDate = date(GlobalVars::get("DateFormat"), strtotime($value));

                        $model->dueDate = date('Y-m-d', strtotime($dueDate));


                        SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Due Date is changed to $dueDate", 1, 1, 1);

                        $job = Jobs::model()->find(array('condition' => "workorder_id = '{$modelId}'"));

                        if (!empty($job)) {
                            $job->dueDate = $model->dueDate;
                            $job->save(false);

                            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Job', "Due Date is changed to $dueDate", 1, 1, 1);
                        }

                        $model->save();
                    }



                    if ($field === 'followupStatus' && $model->followupStatus !== $value) {
                        $model->followupStatus = $value;

                        //add crm status
                        $salesLog = new SalesLog();
                        $salesLog->quoteId = $model->quotationId;
                        $salesLog->workorderId = $model->id;
                        $salesLog->quoteNum = $model->quotationNumber;

                        $salesLog->category = 'SalesOrder';
                        $salesLog->tbl_id = $model->id;
                        $salesLog->followupSts_id = $model->followupStatus;
                        if ($salesLog->save(false)) {

                            $statusname = FollowupStatus::model()->findByPk($model->followupStatus)->status;
                            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Status is changed to $statusname", 1, 1, 1);
                        }

                        $model->save();
                    }
                }



                echo json_encode(array('success' => true));
            } catch (Exception $e) {
                echo $e->getLine() . ' : ' . $e->getMessage();
                exit();
            }
        }
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Workorder');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new Workorder('search');        
        if (isset($_GET['Workorder']))
            $model->attributes = $_GET['Workorder'];

        if (isset($_GET['newso']))
            $model->status_id = $_GET['newso'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    public function actionCusAdmin() {
        $model = new Workorder('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Workorder']))
            $model->attributes = $_GET['Workorder'];

        $usr = User::model()->findByPk(Yii::app()->user->id);
        $customer = Customer::model()->find(array('condition' => "cussno = '$usr->cussno'"));

        $model->status_id = 4; //Pending Approval
        $model->cus_fref = $customer->cuscus_fref;

        //-------------------------------------Artwork--------------------------------/
        $cusjobs = Jobs::model()->findAll(array('condition' => "cus_fref = '{$customer->cuscus_fref}'"));
        $cusIDs = array();
        $cusIDStr = '';
        foreach ($cusjobs as $job) {
            $cusIDs[] = $job->id;
        }

        if (count($cusIDs) > 0) {
            $cusIDStr = implode(',', $cusIDs);
        }


        $criteria = new CDbCriteria;
        if (!empty($cusIDStr))
            $criteria->addCondition("job_id in ($cusIDStr)");
        $criteria->addCondition("job_status_id = 4");
        $dataproviderArtworkJob = new CActiveDataProvider(new JobArtwork(), array(
            'criteria' => $criteria,
        ));


        $this->render('cusadmin', array(
            'model' => $model,
            'dataproviderArtworkJob' => $dataproviderArtworkJob
        ));
    }

    public function actionCusApproval($id) {
        $model = $this->loadModel($id);
        $user = User::model()->findByPk(Yii::app()->user->id);


        if ($model->quotation->customer->cussno != $user->cussno) {

            $this->render('error');
        } else {
            $model->status_id = 22; //Approved By Client
            if ($model->save(false)) {
                $mailer = Yii::app()->MultiMailer->to($model->quotation->customer->cusemail, 'Recipient');
                $globalvar = GlobalVars::model()->find(array('condition' => "globalVar = 'AdminEmail'"));
                if (!empty($globalvar)) {
                    $adminEmail = $globalvar->value;
                    $mailer->cc($adminEmail);
                }

                $mailer->subject("Sales Order Approved : $model->salesorderNumber");


                $mailbody = 'Thank you for the approval';

                $mailer->body($mailbody);

                if ($mailer->send()) {
                    Yii::app()->user->setFlash('success', "Email sent for the approval");
                }
                Yii::app()->user->setFlash('success', "Sales order successfully approved  message! {$model->salesorderNumber}");

                $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->id));
                $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "Sales order ({$link}) is approved by the customer ", 0, 1, 1);
                SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Sales order ({$link}) is approved by the customer ", 0, 1, 1);
                $this->redirect(array('workorder/cusAdmin'));
            } else {
                $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->id));
                $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "Customer was trying to approve the Sales order ({$link}) but failed due to technical error. ", 0, 1, 1);
                SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Customer was trying to approve the Sales order ({$link}) but failed due to technical error. ", 0, 1, 1);

                Yii::app()->user->setFlash('error', "Cannot approval SO message! contact the admin {$model->salesorderNumber}");
                $this->redirect(array('workorder/cusAdmin'));
            }
        }
    }

    public function actionCusReject($id) {

        $model = $this->loadModel($id);
        $user = User::model()->findByPk(Yii::app()->user->id);
        if ($model->quotation->customer->cussno != $user->cussno) {

            $this->render('error');
        }

        if (isset($_POST['Workorder']) && isset($_POST['yt0'])) {
            if (isset($_POST['Workorder']['cusRejectionTxt']) && !empty($_POST['Workorder']['cusRejectionTxt'])) {
                $workorderID = $_POST['Workorder']['id'];
                $resontoreject = trim($_POST['Workorder']['cusRejectionTxt']);

                $model = $this->loadModel($workorderID);
                $model->status_id = 23; //Rejected By Client
                if ($model->save(false)) {
                    Yii::app()->user->setFlash('success', "Sales order successfully rejecetd  message! {$model->salesorderNumber}");
                    $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->id));
                    $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
                    SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "Sales order ({$link}) is rejecetd due to '{$resontoreject}' ", 0, 1, 1);
                    SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Sales order ({$link}) is rejecetd due to '{$resontoreject}", 0, 1, 1);
                    $this->redirect(array('workorder/cusAdmin'));
                } else {
                    $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->id));
                    $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
                    SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "Customer was trying to reject the Sales order ({$link}) but failed due to technical error. ", 0, 1, 1);
                    SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Customer was trying to reject the Sales order ({$link}) but failed due to technical error. ", 0, 1, 1);

                    Yii::app()->user->setFlash('error', "Cannot reject SO message! contact the admin {$model->salesorderNumber}");
                    $this->redirect(array('workorder/cusAdmin'));
                }
            } else {
                Yii::app()->user->setFlash('error', "Please mention a reason for rejection.");
            }
        }

        $this->render('_cusRejectForm', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Workorder::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'workorder-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionConfirm($id) {

        $model = $this->loadModel($id);
        if (!empty($model)) {
            //Confirmed
            $model->status_id = Status::model()->find(array('condition' => 'name=:status', 'params' => array(':status' => 'Confirmed')))->id;
            $floupsts = FollowupStatus::model()->find(array('condition' => "type = 'SalesOrder' and status = 'SO Confirmed'"));
            if (empty($floupsts)) {
                Yii::app()->user->setFlash('error', "Connot confirm the work order (Quotation : {$model->quotationNumber}). Follow-up status is not available. Please contact admin!");
                $this->redirect(array('admin'));
            }
            if ($model->save()) {
                //add crm status
                $salesLog = new SalesLog();
                $salesLog->quoteId = $model->quotationId;
                $salesLog->workorderId = $model->id;
                $salesLog->quoteNum = $model->quotationNumber;

                $salesLog->category = 'SalesOrder';
                $salesLog->tbl_id = $model->id;
                $salesLog->followupSts_id = $floupsts->id;
                if ($salesLog->save(false)) {
                    $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->id));
                    $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
                    SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Sales order ({$link}) is confirmed ", 0, 1, 1);
                    Yii::app()->user->setFlash('success', "Work order ($model->id)(Quotation : {$model->quotationNumber}) successfully confirmed.");
                }
                //end add crm
            } else {
                Yii::app()->user->setFlash('error', "Connot confirm the work order (Quotation : {$model->quotationNumber}). Please try again.");
            }
            $this->redirect(array('admin'));
        }
    }

    public function actionSendToaApproval($id) {
        $model = $this->loadModel($id);
        $model->status_id = Status::model()->find(array('condition' => 'name=:status', 'params' => array(':status' => 'Pending Approval')))->id;

        if ($model->save()) {
            $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->id));
            $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "Sales order ({$link}) is approved ", 0, 1, 1);
            Yii::app()->user->setFlash('success', "Work order (Quotation : {$model->quotationNumber}) has been sent to approval.");
        } else {
            Yii::app()->user->setFlash('error', "Connot send the work order (Quotation : {$model->quotationNumber}) to approval. Please try again.");
        }
        $this->redirect(array('admin'));
    }

    public function actionCancel($id) {
        if (in_array(Yii::app()->user->title, array('Administrator', 'Coordinator'))) {
            $model = $this->loadModel($id);
            if (!empty($model)) {
                //Confirmed
                $model->status_id = 3;
                $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->id));
                $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
                if ($model->save()) {

                    SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "Sales order ({$link}) is cancelled ", 0, 1, 1);
                    Yii::app()->user->setFlash('success', "Work order (Quotation : {$model->quotationNumber}) successfully cancelled.");
                } else {

                    SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Cancelling sales order ({$link}) is failed", 1, 0, 1);
                    Yii::app()->user->setFlash('error', "Connot cancel the work order (Quotation : {$model->quotationNumber}). Please try again.");
                }
                $this->redirect(array('admin'));
            }
        } else {
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
        }
    }

    public function actionConverttoJob() {
        $transaction = Yii::app()->db->beginTransaction();
        $allsaved = true;
        $id = $_GET['id'];

        $model = $this->loadModel($id);
        $floupsts = FollowupStatus::model()->find(array('condition' => "type = 'SalesOrder' and status = 'SO Converted to Job'"));
        if (empty($floupsts)) {
            $transaction->rollback();
            Yii::app()->user->setFlash('error', "Cannot convert {$model->salesorderNumber} to a job. Follow-up status is not available. Please contact admin!");
            $this->redirect(array('admin'));
        }

        $isurgent = (isset($_GET['urgent']) ? $_GET['urgent'] : 20);
        //create only one job for each workorder and quoatation
        //first check if a job already created for this workorder
        /* GET JOB OBJECT */
        $job = $this->processJobConvertion($model);


        if (!empty($job)) {

            $model->status_id = 6; //Converted to Job
            $allsaved = $model->save();

            //add crm status
            $salesLog = new SalesLog();
            $salesLog->quoteId = $model->quotationId;
            $salesLog->workorderId = $model->id;
            $salesLog->quoteNum = $model->quotationNumber;

            $salesLog->category = 'SalesOrder';
            $salesLog->tbl_id = $model->id;
            $salesLog->followupSts_id = $floupsts->id;
            if ($salesLog->save(false)) {
                
            }


            $urljob = Yii::app()->createUrl('jobs/view', array("id" => $job->id));
            $linkjob = CHtml::link($job->jobNum, $urljob, array('target' => '_blank'));

            $urlso = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->id));
            $linkso = CHtml::link($model->salesorderNumber, $urlso, array('target' => '_blank'));

            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Sales order ({$linkso}) is converted to a job ({$linkjob})", 1, 0, 1);
            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Job', "New job ({$linkjob}) is created ", 1, 0, 1);
            if ($isurgent == 19) {

                SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Job', "Job ({$linkjob}) is Urgent ", 1, 0, 1);
            }
            $transaction->commit();
        } else {

            Yii::app()->user->setFlash('error', "Cannot convert {$model->salesorderNumber} to a job. Please try again or contact admin.");
            $transaction->rollback();
            $this->redirect(array('workorder/admin'));
        }


        $this->redirect(array('jobs/admin'));
    }

    private function processJobConvertion($workorder) {
        $quotation = $workorder->quotation;
        $customer = $quotation->customer;
        $allsaved = true;
        $job = Jobs::model()->find(array('condition' => "workorder_id= {$workorder->id}"));

        if (empty($job)) {
            $job = new Jobs();
            $job->workorder_id = $workorder->id;
            $job->quote_id = $quotation->id;
            $job->quoteNum = $quotation->quoteno;
            $job->jobNum = 'JOB-' . $quotation->quoteno . '-' . $workorder->id;
            $job->jobname = $quotation->quotename;
            $job->cus_fref = $quotation->cus_fref;
            $job->mastercusno = $customer->cusmcussno;
            $job->createdDtm = date('Y-m-d H:i:s');
            $job->user_id = Yii::app()->user->id;
            $job->urgent_status = 20;
            $job->status_id = 1; //New
            $job->ws_user = $workorder->ws_user;
            $job->ws_user_id = $workorder->ws_user_id;
            $job->prd_cordinator_id = $workorder->prd_cordinator_id;
            $job->customerpono = $workorder->customerpono;

            //COPY SHIPPING ADDRESS
            $job->shipContactName = $workorder->shipContactName;
            $job->shipSendVia = $workorder->shipSendVia;
            $job->shipAddress1 = $workorder->shipAddress1;
            $job->shipAddress2 = $workorder->shipAddress2;
            $job->shipAddress3 = $workorder->shipAddress3;
            $job->shipSub = $workorder->shipSub;
            $job->shipState = $workorder->shipState;
            $job->shipPostalCode = $workorder->shipPostalCode;

            $duedate = Refiner::getdatetext($workorder->dueDate, 'Y-m-d');
            if (!empty($duedate)) {
                $job->dueDate = date('Y-m-d', strtotime($workorder->dueDate));
            } else {
                $job->dueDate = date('Y-m-d H:i:s', strtotime('+ ' . GlobalVars::get('DueInXDays') . ' days'));
            }

            //$job->orderTypeId = $workorder->orderTypeId;

            if ($job->save()) {

                if (!empty($job->orderTypeId)) {
                    $weborder = WebstoreOrder::model()->find(array('condition' => "quoteId = {$job->quote_id}"));
                    if (!empty($weborder)) {
                        $weborder->workorderId = $job->workorder_id;
                        $weborder->jobId = $job->id;
                        $weborder->statusId = 6; //Converted to Job
                        if ($weborder->save(false)) {
                            //success
                        } else {
                            $allsaved = false;
                        }
                    }
                }

                $wrkorderdtls = Workorderdetails::model()->findAll("workorderId = '$job->workorder_id'");

                foreach ($wrkorderdtls as $dtl) {
                    if (!empty($dtl->productsku) || !empty($dtl->prdsrtdesc) || !empty($dtl->prdlngdesc)) {
                        $job_product = new JobProducts();
                        $job_product->lineOrder = $dtl->lineOrder;
                        $job_product->job_id = $job->id;
                        $job_product->workorderDtl_id = $dtl->id;
                        $job_product->qty = $dtl->prodQty;
                        $job_product->prodCostPrice = $dtl->prodCostPrice;
                        $job_product->status_id = 1; //New
                        $job_product->user_id = Yii::app()->user->id;

                        if ($job_product->save()) {
                            //success
                        } else {
                            $allsaved = false;
                        }
                    }

                    $workOrderDecoDetails = $dtl->rel_multi_deco();

                    if (count($workOrderDecoDetails) > 0) {
                        foreach ($workOrderDecoDetails as $data) {

                            $job_decoration = new JobDecorations();
                            $job_decoration->lineOrder = $dtl->lineOrder;
                            $job_decoration->job_id = $job->id;
                            $job_decoration->workorderDtl_id = $dtl->id;
                            $job_decoration->decprtnam = $data->decprtnam;
                            $job_decoration->decdesc = $data->decdesc;
                            $job_decoration->customdecoration = $data->customdecoration;
                            $job_decoration->decoQty = $data->quantity;
                            $job_decoration->decoCostPrice = $data->cost_price;
                            $job_decoration->decosupref = $data->supref;
                            $job_decoration->customizationDetails = $data->customization_detail;
                            $job_decoration->status_id = 1; //New
                            $job_decoration->user_id = Yii::app()->user->id;
                            $job_decoration->createdDtm = date('Y-m-d H:i:s');
                            $job_decoration->work_order_detail_decoration_id = $data->id;
                            $job_decoration->logo_setup = $data->logo_setup;
                            $job_decoration->save(false);


                            $job_product_decoration = new JobProductDecorations();
                            $job_product_decoration->lineOrder = $dtl->lineOrder;
                            $job_product_decoration->job_id = $job->id;
                            $job_product_decoration->workorderDtl_id = $dtl->id;
                            $job_product_decoration->decprtnam = $data->decprtnam;
                            $job_product_decoration->decdesc = $data->decdesc;
                            $job_product_decoration->customdecoration = $data->customdecoration;
                            $job_product_decoration->decoQty = $data->quantity;
                            $job_product_decoration->decoCostPrice = $data->cost_price;
                            $job_product_decoration->decosupref = $data->supref;
                            $job_product_decoration->customizationDetails = $data->customization_detail;
                            $job_product_decoration->user_id = Yii::app()->user->id;
                            $job_product_decoration->status_id = 1; //New

                            $job_product_decoration->work_order_detail_decoration_id = $data->id;
                            $job_product_decoration->logo_setup = $data->logo_setup;

                            $job_product_decoration->save(false);
                        }
                    }

                    $workOrderOtherCosts = WorkorderOtherCost::model()->findAll(array('condition' => "workorder_id = {$workorder->id} AND workorder_detail_id = {$dtl->id}"));

                    foreach($workOrderOtherCosts as $wooc) {
                        $jobProductOtherCost = new JobProductOtherCost;
                        $jobProductOtherCost->job_id = $job->id;
                        $jobProductOtherCost->workorder_detail_id = $dtl->id;
                        $jobProductOtherCost->workorder_id = $workorder->id;
                        $jobProductOtherCost->other_cost_type_id = $wooc->other_cost_id;
                        
                        $otherCostType = OtherCostType::model()->findByPk($wooc->other_cost_id);
                        $otherCostGroup = OtherCostGroup::model()->findByPk($otherCostType->other_cost_group_id);
                        $jobProductOtherCost->other_cost_id = $wooc->other_cost_id;
                        $jobProductOtherCost->other_cost_group_id = $otherCostType->other_cost_group_id;
                        $jobProductOtherCost->other_cost_name = $otherCostType->name;
                        $jobProductOtherCost->other_cost_group_name =  $otherCostGroup->name;
                        $jobProductOtherCost->is_qty_based = $otherCostType->devide_by_qty;
                        $jobProductOtherCost->cost_price = $wooc->cost;
                        $jobProductOtherCost->quantity = $dtl->prodQty;
                        $jobProductOtherCost->workorder_other_cost_id = $wooc->id;
                        $jobProductOtherCost->save(false);

                    }

                }
            } else {
                $allsaved = false;
            }
        }

        //Trying to copy workorder related attachments into job
        FileInventory::copyAttachments($workorder->id, 'WORKORDER', $job->id, 'JOB');

        if ($allsaved == true) {

            return $job;
        } else {

            return null;
        }
    }

    private function createJobFlow($jobID, $workorderID) {
        $workorderDtl = Workorderdetails::model()->findAll("workorderId = '$workorderID'");

        foreach ($workorderDtl as $dtl) {
            $jobproduct = new JobProducts();
            $jobproduct->job_id = $jobID;
            $jobproduct->workorderDtl_id = $dtl->id;
            $jobproduct->qty = $dtl->prodQty;
            $jobproduct->save();
        }
    }

    public function trackJobDetails($jobid, $jobdtlid, $stusid, $stuschngby, $stuschngdtm) {
        $jobtrack = new JobTrack();
        $jobtrack->jobid = $jobid;
        $jobtrack->jobdtlid = $jobdtlid;
        $jobtrack->stusid = $stusid;
        $jobtrack->stuschngby = $stuschngby;
        $jobtrack->stuschngdtm = $stuschngdtm;

        return $jobtrack->save();
    }

    public $show_product_details = 0;
    public $show_custmz_details = 0;
    public $show_notes = 0;
    public $show_prices = 0;

    public function actionPrint($id) {
        $this->show_product_details = isset($_GET['prddshow']) == true ? $_GET['prddshow'] : 0;
        $this->show_custmz_details = isset($_GET['cutmz_show']) == true ? $_GET['cutmz_show'] : 0;
        $this->show_notes = isset($_GET['notes_show']) == true ? $_GET['notes_show'] : 0;
        $this->show_prices = isset($_GET['prices_show']) == true ? $_GET['prices_show'] : 0;
        $model = $this->loadModel($id);

        $user = User::model()->findByPk(Yii::app()->user->id);


        if (Yii::app()->user->title == 'Customer') {
            if ($model->quotation->customer->cussno != $user->cussno) {

                $this->render('error');
            }
        }


        $sotype = 'ORDER CONFIRMATION';

//        if (in_array($model->status_id, array(2, 6)) == true) {
//            $sotype = 'ORDER CONFIRMATION';
//        }
        $url = Yii::app()->createUrl('Workorder/print', array("id" => $model->id));
        $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = '$sotype ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "$sotype ({$link}) is printed", 1, 1, 1);
            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "$sotype ({$link}) is printed", 1, 1, 1);
        }

        $htmlcontent = $this->renderInternal('protected/views/workorder/so_pdf_html.php', array('model' => $model,
            'show_product_details' => $this->show_product_details,
            'show_custmz_details' => $this->show_custmz_details,
            'show_notes' => $this->show_notes,
            'show_prices' => $this->show_prices,
                ), true);

        $sitePrefix = GlobalVars::get(GlobalVars::SITE_PREFIX);
        $pdfCreator = new CommonPDFCreator(array(
            'title' => 'Order Confirmation',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "{$sitePrefix}_OrderConfirmation_" . $model->salesorderNumber . ".pdf"
        ));

        $pdfCreator->generate();
    }

    public function actionPrintWorkWear($id) {
        $this->show_product_details = isset($_GET['prddshow']) == true ? $_GET['prddshow'] : 0;
        $this->show_custmz_details = isset($_GET['cutmz_show']) == true ? $_GET['cutmz_show'] : 0;
        $this->show_notes = isset($_GET['notes_show']) == true ? $_GET['notes_show'] : 0;
        $this->show_prices = isset($_GET['prices_show']) == true ? $_GET['prices_show'] : 0;
        $model = $this->loadModel($id);

        $user = User::model()->findByPk(Yii::app()->user->id);


        if (Yii::app()->user->title == 'Customer') {
            if ($model->quotation->customer->cussno != $user->cussno) {

                $this->render('error');
            }
        }


        $sotype = 'ORDER CONFIRMATION';

//        if (in_array($model->status_id, array(2, 6)) == true) {
//            $sotype = 'ORDER CONFIRMATION';
//        }
        $url = Yii::app()->createUrl('Workorder/print', array("id" => $model->id));
        $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = '$sotype ({$link}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "$sotype ({$link}) is printed", 1, 1, 1);
            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "$sotype ({$link}) is printed", 1, 1, 1);
        }
        $htmlcontent = $this->renderInternal('protected/views/workorder/so_pdf_html.php', array('model' => $model,
            'show_product_details' => $this->show_product_details,
            'show_custmz_details' => $this->show_custmz_details,
            'show_notes' => $this->show_notes,
            'show_prices' => $this->show_prices,
                ), true);

        $pdfCreator = new CommonPDFCreator(array(
            'title' => 'Order Confirmation - WorkWare',
            'content' => $htmlcontent,
            'pageNumber' => '{PAGENO}',
            'outputFileName' => "{$model->salesorderNumber}.pdf"
        ));

        $pdfCreator->generate();
    }

    public function actionSendSOToConfirm($id) {
        $transaction = Yii::app()->db->beginTransaction();
        $model = $this->loadModel($id);
        $allsaved = true;

        //create logins for the customer
        $proposedUsername = $model->customer->cusemail;

        $user = User::model()->find(array('condition' => "username = '{$proposedUsername}' and title = 'Customer'"));
        $logintext = '';
        if (empty($user)) {
            $user = new User();

            $user->username = $proposedUsername;
            $generatedPassword = User::generateRandomPassword();
            $user->password = md5($generatedPassword);
            $user->title = 'Customer';
            $user->email = $model->customer->cusemail;
            $user->cussno = $model->customer->cussno;
            if ($user->save()) {
                $authassignment = new AuthAssignment();
                $authassignment->itemname = 'Customer';
                $authassignment->userid = $user->id;
                $authassignment->data = 'N;';
                if ($authassignment->save()) {
                    $logintext = "Please use following login details to get in to the system<br>Username : $proposedUsername<br>Password:$generatedPassword";
                } else {
                    $allsaved = false;
                }
            } else {
                $allsaved = false;
            }
        } else {
            $logintext = 'Please use your login details to log in to our system and to do approval things';
        }



        $recipient = $model->customer->cusemail;
        $ccrecipients = ''; //
        $mailer = Yii::app()->MultiMailer->to($recipient, 'Recipient');
        //$mailer = Yii::app()->MultiMailer->to('rajaera@gmail.com', 'Recipient');
        $globalvar = GlobalVars::model()->find(array('condition' => "globalVar = 'AdminEmail'"));
        if (!empty($globalvar)) {
            $ccrecipients = $globalvar->value;
            $mailer->cc($ccrecipients);
        }

        $mailer->subject("Goodgear Confirmation for : $model->salesorderNumber");


        $accessurl = Yii::app()->getBaseUrl(true) . '/' . Yii::app()->createUrl('workorderdetails/cusView', array('id' => $id));
        $mailbody = '<h1>Confirmation for ' . $model->salesorderNumber . '</h1>';
        $mailbody .= '<p>Please confirm or reject this sales order : <a href="' . $accessurl . '">' . $model->salesorderNumber . '</a>. click <a href="' . $accessurl . '">here</a> to see the sales order and do actions.</p>';
        $mailbody .= '<p>' . $logintext . '</p>';
        $mailbody .= '<p>For more details call : 000-0000-0000</p>';
        $mailer->body($mailbody);

        $fileinventory = $model->generatePDF(true);
        $mailer->attachment('files/' . $fileinventory->filename);

        $model->status_id = 4; //Pending Approval
        if ($model->save(false)) {

            if ($mailer->send()) {
                $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->id));
                $link = CHtml::link($model->salesorderNumber, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "Sales order ({$link}) has been sent to custoemr for approval", 0, 1, 1);
                SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "Sales order ({$link}) has been sent to custoemr for approval", 0, 1, 1);

                //save email
                $trackmail = Emails::trackSave($recipient, $ccrecipients, $mailbody);
                //end track email

                if ($allsaved == true) {
                    $transaction->commit();
                    $this->redirect(array('workorderdetails/admin', 'wid' => $id, 'send' => '1'));
                } else {
                    $transaction->rollback();
                    Yii::app()->user->setFlash('error', "Error in sending SO to approval.  {$model->salesorderNumber}");
                    $this->redirect(array('workorderdetails/admin', 'wid' => $id, 'send' => '0'));
                }
            } else {
                $transaction->rollback();
                Yii::app()->user->setFlash('error', "Error in sending SO to approval.  {$model->salesorderNumber}");
                $this->redirect(array('workorderdetails/admin', 'wid' => $id, 'send' => '0'));
            }
        } else {
            $transaction->rollback();
            Yii::app()->user->setFlash('error', "Error in sending SO to approval.  {$model->salesorderNumber}");
            $this->redirect(array('workorderdetails/admin', 'wid' => $id, 'send' => '0'));
        }
    }

    public function actionSaveWorkorderDetails() {
        $arr = array();

        echo json_encode($arr);
    }

    public function actionFullQtyDiff() {
        if (isset($_POST)) {
            $model = $this->loadModel($_POST['id']);
            $arr = $model->qtysizebreakdiffresult();

            echo json_encode($arr);
        }
    }

    public function actionStatusReport() {


        $model = new Workorder('searchStatus');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Workorder']))
            $model->attributes = $_GET['Workorder'];

        if (isset($_POST['reset_btn'])) {
            unset(Yii::app()->session['so_sts_selcted']);
            unset(Yii::app()->session['so_sts_datefrom']);
            unset(Yii::app()->session['so_sts_dateto']);
        }

        if (isset($_POST['Workorder']) && isset($_POST['Workorder']['followupStatus']) && isset($_POST['go_btn'])) {
            $postStatusesArr = $_POST['Workorder']['followupStatus'];

            Yii::app()->session['so_sts_selcted'] = implode(',', $postStatusesArr);
        }

        if (isset($_POST['Workorder']['datefrom']) && !empty($_POST['Workorder']['datefrom']) && isset($_POST['go_btn'])) {
            Yii::app()->session['so_sts_datefrom'] = date('Y-m-d', strtotime($_POST['Workorder']['datefrom']));
        }

        if (isset(Yii::app()->session['so_sts_datefrom'])) {
            $model->datefrom = date('d-m-Y', strtotime(Yii::app()->session['so_sts_datefrom']));
        }



        if (isset($_POST['Workorder']['dateto']) && !empty($_POST['Workorder']['dateto']) && isset($_POST['go_btn'])) {
            Yii::app()->session['so_sts_dateto'] = date('Y-m-d', strtotime($_POST['Workorder']['dateto']));
        }

        if (isset(Yii::app()->session['so_sts_dateto'])) {
            $model->dateto = date('d-m-Y', strtotime(Yii::app()->session['so_sts_dateto']));
        }




        $this->render('statusReport', array(
            'model' => $model,
        ));
    }

    public function actionAddOtherCostsForNewDtl() {
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : array();
        $othercostidArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : array();
        $quantity = $_POST['quantity'];
        $storedOtherCostIds = !empty($_POST['storedOtherCostIds']) ? explode(',', $_POST['storedOtherCostIds']) : array();
        $newlySelectedOtherCostIds = explode(',', $_POST['newlySelectedOtherCostIds']);


        foreach ($storedOtherCostIds as $key => $value) {

            if (($key2 = array_search($value, $newlySelectedOtherCostIds)) !== false) {
                unset($newlySelectedOtherCostIds[$key2]);
            }
        }

        foreach ($othercostidArr as $key => $value) {

            if (($key2 = array_search($value, $newlySelectedOtherCostIds)) !== false) {
                unset($newlySelectedOtherCostIds[$key2]);
            }
        }

        foreach ($othercostidArr as $key => $value) {

            if (($key2 = array_search($value, $storedOtherCostIds)) !== false) {
                unset($storedOtherCostIds[$key2]);
            }
        }

        $allIds = array_merge($storedOtherCostIds, $newlySelectedOtherCostIds, $othercostidArr);

        $allIds = array_filter($allIds);


        $linetype = 0;
        $html = "";
        $count = 0;
        $otherCostTotal = 0;
        foreach ($allIds as $key => $val) {
            $othercost = OtherCostType::model()->findByPk($val);
            $cost = $othercost->default_cost;


            if (!empty($othercostidArr)) {
                foreach ($othercostidArr as $key2 => $value2) {
                    if ($value2 == $val) {
                        $cost = $othercostArr[$key2];
                    }
                }
            }

            $count++;
            $linetype = $count % 2;
            $currentrow = "oc_row_" . $count;

            $qty_based_html = '';
            $qty_based_attr = '';
            $unit_cost = $cost;
            if ($othercost->devide_by_qty) {
                $qty_based_attr = 'qtybsd="true"';
                $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                $unit_cost = $unit_cost / $quantity;
            }

            $otherCostTotal += $unit_cost;
            $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
            $html .= '<tr ' . $rowclass . ' id="oc_row_' . $count . '">';
            $html .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $val . '" /></td>';
            $html .= '<td >' . $othercost->cost_group_rel->name . '</td>';
            $html .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
            $html .= '<td ><input ' . $qty_based_attr . '  name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
            $html .= '<td >' . number_format($unit_cost, 2) . '</td>';
            $html .= '<td ><a href="#" onclick="deleteOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
            $html .= '</tr>';
        }

        $html .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="vfgrert" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';


        $otherCostIdStr = implode(',', $allIds);

        echo json_encode(array('html' => $html, 'otherCostIdStr' => $otherCostIdStr));
    }

    public function actionAddOtherCostsForEditDtl() {
        
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : array();
        $othercostidArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : array();
        $workorderDtlId = $_POST['workorderDtlId'];
        $newlySelectedOtherCostIds = explode(',', $_POST['newlySelectedOtherCostIds']);

        $workorderDtl = Workorderdetails::model()->findByPk($workorderDtlId);
        $othercosts = WorkorderOtherCost::model()->findAll(array('condition' => "workorder_detail_id = $workorderDtlId"));

        $othercostsDBSavedIdArr = array();
        foreach ($othercosts as $data) {
            $othercostsDBSavedIdArr[] = $data->other_cost_id;
        }

        $diff = array_diff($othercostsDBSavedIdArr, $othercostidArr);

        foreach ($diff as $key => $value) {

            if (($key = array_search($value, $othercostsDBSavedIdArr)) !== false) {
                unset($othercostsDBSavedIdArr[$key]);
            }
        }


        foreach ($othercostsDBSavedIdArr as $key => $value) {

            if (($key = array_search($value, $newlySelectedOtherCostIds)) !== false) {
                unset($newlySelectedOtherCostIds[$key]);
            }
        }


        $count = 0;
        $linetype = 0;
        $otherCostHtml = "";
        $otherCostTotal = 0;
        foreach ($othercosts as $data) {
            if (in_array($data->other_cost_id, $othercostsDBSavedIdArr)) {
                $cost = $data->cost;
                if (!empty($othercostidArr) && count($othercostidArr) > 0) {
                    foreach ($othercostidArr as $key => $value) {
                        if ($value == $data->other_cost_id) {
                            $cost = $othercostArr[$key];
                        }
                    }
                }

                $count++;
                $linetype = $count % 2;
                $currentrow = "edit_oc_row_" . $count;
                $othercost = OtherCostType::model()->findByPk($data->other_cost_id);
                $qty_based_html = '';
                $qty_based_attr = '';
                $unit_cost = $cost;
                if ($othercost->devide_by_qty) {
                    $qty_based_attr = 'qtybsd="true"';
                    $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                    $unit_cost = $unit_cost / $workorderDtl->prodQty;
                }

                $otherCostTotal += $unit_cost;
                $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
                $otherCostHtml .= '<tr ' . $rowclass . ' id="edit_oc_row_' . $count . '">';
                $otherCostHtml .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $data->other_cost_id . '" /></td>';
                $otherCostHtml .= '<td >' . $othercost->cost_group_rel->name . '</td>';
                $otherCostHtml .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
                $otherCostHtml .= '<td ><input ' . $qty_based_attr . ' name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
                $otherCostHtml .= '<td >' . number_format($unit_cost, 2) . '</td>';
                $otherCostHtml .= '<td ><a href="#" onclick="deleteEditOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
                $otherCostHtml .= '</tr>';
            }
        }



        foreach ($newlySelectedOtherCostIds as $key => $val) {
            $othercost = OtherCostType::model()->findByPk($val);
            $cost = $othercost->default_cost;
            foreach ($othercostidArr as $key2 => $value2) {
                if ($value2 == $val) {
                    $cost = $othercostArr[$key2];
                }
            }

            $count++;
            $linetype = $count % 2;
            $currentrow = "edit_oc_row_" . $count;

            $qty_based_html = '';
            $qty_based_attr = '';
            $unit_cost = $cost;
            if ($othercost->devide_by_qty) {
                $qty_based_attr = 'qtybsd="true"';
                $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                $unit_cost = $unit_cost / $workorderDtl->prodQty;
            }
            $otherCostTotal += $unit_cost;
            $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
            $otherCostHtml .= '<tr ' . $rowclass . ' id="edit_oc_row_' . $count . '">';
            $otherCostHtml .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $val . '" /></td>';
            $otherCostHtml .= '<td >' . $othercost->cost_group_rel->name . '</td>';
            $otherCostHtml .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
            $otherCostHtml .= '<td ><input ' . $qty_based_attr . ' name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
            $otherCostHtml .= '<td >' . number_format($unit_cost, 2) . '</td>';
            $otherCostHtml .= '<td ><a href="#" onclick="deleteEditOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
            $otherCostHtml .= '</tr>';
        }

        $otherCostHtml .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="plokij" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';


        echo json_encode(array('otherCostHtml' => $otherCostHtml));
    }

    public function actionSaveEditOtherCost() {
        $othercostidArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : array();
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : array();
        $quantity = $_POST['quantity'];

        $linetype = 0;
        $html = "";
        $count = 0;
        $otherCostTotal = 0;
        foreach ($othercostidArr as $key => $val) {
            $othercost = OtherCostType::model()->findByPk($val);
            $cost = $othercostArr[$key];




            $count++;
            $linetype = $count % 2;
            $currentrow = "oc_row_" . $count;

            $qty_based_html = '';
            $qty_based_attr = '';
            $unit_cost = $cost;
            if ($othercost->devide_by_qty) {
                $qty_based_attr = 'qtybsd="true"';
                $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                $unit_cost = round(($unit_cost / $quantity), 2);
            }

            $otherCostTotal += $unit_cost;
            $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
            $html .= '<tr ' . $rowclass . ' id="oc_row_' . $count . '">';
            $html .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $val . '" /></td>';
            $html .= '<td >' . $othercost->cost_group_rel->name . '</td>';
            $html .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
            $html .= '<td ><input ' . $qty_based_attr . '  name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
            $html .= '<td >' . number_format($unit_cost, 2) . '</td>';
            $html .= '<td ><a href="#" onclick="deleteEditOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
            $html .= '</tr>';
        }

        $html .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="vfgrert" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';



        echo json_encode(array('html' => $html, 'otherCostTotal' => $otherCostTotal));
    }

    public function actionSaveNewOtherCost() {
        $othercostidArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : array();
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : array();
        $quantity = $_POST['quantity'];

        $linetype = 0;
        $html = "";
        $count = 0;
        $otherCostTotal = 0;
        foreach ($othercostidArr as $key => $val) {
            $othercost = OtherCostType::model()->findByPk($val);
            $cost = $othercostArr[$key];




            $count++;
            $linetype = $count % 2;
            $currentrow = "oc_row_" . $count;

            $qty_based_html = '';
            $qty_based_attr = '';
            $unit_cost = $cost;
            if ($othercost->devide_by_qty) {
                $qty_based_attr = 'qtybsd="true"';
                $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';
                $unit_cost = round(($unit_cost / $quantity), 2);
            }

            $otherCostTotal += $unit_cost;
            $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
            $html .= '<tr ' . $rowclass . ' id="oc_row_' . $count . '">';
            $html .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $val . '" /></td>';
            $html .= '<td >' . $othercost->cost_group_rel->name . '</td>';
            $html .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
            $html .= '<td ><input ' . $qty_based_attr . '  name="othercost[]" value="' . round($cost, 2) . '" tabindex="' . $count . '"/></td>';
            $html .= '<td >' . number_format($unit_cost, 2) . '</td>';
            $html .= '<td ><a href="#" onclick="deleteOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
            $html .= '</tr>';
        }

        $html .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="vfgrert" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';



        echo json_encode(array('html' => $html, 'otherCostTotal' => $otherCostTotal));
    }

    public function actionUpdateSurcharge() {
        $id = $_POST['id'];
        $surcharge_id = $_POST['surcharge_id'];
        $surcharge_rate = $_POST['surcharge_rate'];

        $command = Yii::app()->db->createCommand();
        $command->update('workorder', array(
            'surcharge_id' => $surcharge_id,
            'surcharge_rate' => $surcharge_rate,
                ), 'id=:id', array(':id' => $id));
    }

    public function actionCopyLine() {
        if (!isset($_POST['workorderId']) && !isset($_POST['workorderDetalIdStr'])) {
            throw new Exception('Bad Request!', 400);
}

        //$quote = $this->loadModel(intval($_POST['quoteId']));

        $quoteDetalIdArr = explode(',', $_POST['workorderDetalIdStr']);

        if (count($quoteDetalIdArr) == 0) {
            throw new Exception('Bad Request!', 400);
        }

        $criteria = new CDbCriteria;
        $criteria->addInCondition('id', $quoteDetalIdArr);
        $workorderDetails = Workorderdetails::model()->findAll($criteria);

        $transaction = Yii::app()->db->beginTransaction();
        $allsaved = true;
        $htmlResults = array();
        foreach ($workorderDetails as $data) {

            $copyLineWorkorderDetail = new Workorderdetails();
            $copyLineWorkorderDetail->attributes = $data->attributes;
            unset($copyLineWorkorderDetail->id);
            if ($copyLineWorkorderDetail->save()) {

                $workorderDecorations = $data->rel_multi_deco();
                if (count($workorderDecorations)) {
                    foreach ($workorderDecorations as $deco) {
                        $copyLineWorkorderDecoration = new WorkorderDetailsDecoration();
                        $copyLineWorkorderDecoration->attributes = $deco->attributes;
                        $copyLineWorkorderDecoration->workorder_detail_id = $copyLineWorkorderDetail->id;
                        unset($copyLineWorkorderDecoration->id);
                        $allsaved = $copyLineWorkorderDecoration->save();
                    }
                }

                $workorderSizeQtyColours = $data->rel_size_qty_colors();
                if (count($workorderSizeQtyColours)) {
                    foreach ($workorderSizeQtyColours as $sizeqtycol) {
                        $copyLineSizeQtyColour = new WorkorderdetailssizecolorController();
                        $copyLineSizeQtyColour->attributes = $sizeqtycol->attributes;
                        $copyLineSizeQtyColour->workOrderDetailsId = $copyLineWorkorderDetail->id;
                        unset($copyLineSizeQtyColour->id);
                        $allsaved = $copyLineSizeQtyColour->save();
                    }
                }

                $otherCosts = $data->rel_other_costs();
                if (count($otherCosts)) {
                    foreach ($otherCosts as $cost) {
                        $copyLineOtherCost = new WorkorderOtherCost();
                        $copyLineOtherCost->attributes = $cost->attributes;
                        $copyLineOtherCost->workorder_detail_id = $copyLineWorkorderDetail->id;
                        unset($copyLineOtherCost->id);
                        $allsaved = $copyLineOtherCost->save();
                    }
                }
            } else {
                $allsaved = false;
            }
            $htmlResults[$copyLineWorkorderDetail->id] = $data->getHtmlRow();
        }

        if (!$allsaved) {
            $transaction->rollback();
            throw new Exception("Cannot copy line(s)!", 304); //Not modified
        } else {
            $transaction->commit();
            echo json_encode($htmlResults);
        }
    }

}
