<?php

class WorkorderdetailsController extends RController
{

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';
    private $_workorder = null;

    /**
     * @return array action filters
     */
    public function filters()
    {
        return array(
            'rights', // perform access control for CRUD operations
            'workorderContext + admin',
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'create', 'update', 'deleteAjax', 'uploadPost', 'admin',
                    'updateCustomizedDetails', 'updateNotes', 'updateProductQty', 'uploadPost', 'delete',
                    'updateDecorateQty', 'updateUnitPriceExVat', 'updateUnitPriceIncVat',
                    'updateTotalExVat', 'updateTotalIncVat', 'updateCustomProduct', 'updateCustomDecoration',
                    'uploadImg', 'filterDesc', 'updateProductShortDescription', 'updateProductLongDescription',
                    'updateDecorationName', 'filterDecoration', 'deleteMultipleAjax', 'ajaxQtyDiff',
                    'addWorkOrderDetail', 'cusView', 'fetchDetailsPrices', 'updateDetailsFields'
                ),
                'users' => array('@'),
            ),
            array(
                'allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'deleteAjax', 'uploadPost'),
                'users' => array('@'),
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id)
    {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    public function actionCusView($id)
    {
        //$wid = $_GET['wid'];

        $model = new Workorderdetails('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Workorderdetails']))
            $model->attributes = $_GET['Workorderdetails'];

        $model->workorderId = $id;

        $workorder = Workorder::model()->findByPk($id);
        $user = User::model()->findByPk(Yii::app()->user->id);

        $renderpage = 'cusview';
        if ($workorder->quotation->customer->cussno != $user->cussno) {
            $renderpage = 'error';
        }

        $this->render($renderpage, array(
            'model' => $model,
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate()
    {
        $model = new Workorderdetails;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Workorderdetails'])) {
            $model->attributes = $_POST['Workorderdetails'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id)
    {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Workorderdetails'])) {
            $model->attributes = $_POST['Workorderdetails'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    public function actionUpdateCustomDecoration()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->customdecoration = $_POST['value'];

                    if ($model->save()) {

                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionUpdateCustomProduct()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->custmproduct = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionUpdateCustomizedDetails()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel(intval($_POST['id']));
                $transaction = Yii::app()->db->beginTransaction();
                $allsaved = true;
                if (!empty($model)) {
                    $model->customizationDetails = htmlspecialchars($_POST['value']);

                    $jobdecoration = JobDecorations::model()->find(array('condition' => "workorderDtl_id = '{$model->id}'"));
                    if (!empty($jobdecoration)) {
                        $jobdecoration->customizationDetails = $model->customizationDetails;
                        $allsaved = $jobdecoration->save(false);
                    }

                    $jobProductDecoration = JobProductDecorations::model()->find(array('condition' => "workorderDtl_id = '{$model->id}'"));
                    if (!empty($jobProductDecoration)) {
                        $jobProductDecoration->customizationDetails = $model->customizationDetails;
                        $allsaved = $jobProductDecoration->save(false);
                    }


                    if ($model->save(false) && $allsaved == true) {
                        $transaction->commit();
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        $transaction->rollback();                        
                    }
                }
            }
        }
    }

    public function actionUpdateNotes()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel(intval($_POST['id']));
                if (!empty($model)) {
                    $model->notes = htmlspecialchars($_POST['value']);

                    if ($model->save(false)) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } 
                }
            }
        }
    }

    public function actionUpdateProductQty()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (filter_input(INPUT_POST, 'id') && filter_input(INPUT_POST, 'value')) {
                $id = filter_input(INPUT_POST, 'id');
                $valueX = filter_input(INPUT_POST, 'value');
                $resultArr = array();
                $model = $this->loadModel($id);
                $transaction = Yii::app()->db->beginTransaction();
                $allsaved = true;
                if (!empty($model)) {
                    $model->prodQty = $valueX;
                    $model->decoQty = $valueX;


                    $jobproduct = JobProducts::model()->find(array('condition' => "workorderDtl_id = '{$model->id}'"));
                    if (!empty($jobproduct)) {
                        $jobproduct->qty = $model->prodQty;
                        $jobproduct->save(false);
                    }


                    $jobdecoration = JobDecorations::model()->find(array('condition' => "workorderDtl_id = '{$model->id}'"));
                    if (!empty($jobdecoration)) {
                        $jobdecoration->decoQty = $model->decoQty;
                        $allsaved = $jobdecoration->save(false);
                    }

                    //JobDecorations::model()->updateAll(array('decdesc' => $model->decdesc), "workorderDtl_id = '{$model->id}' and decprtnam = '{$model->decprtnam}'");

                    $jobProductDecoration = JobProductDecorations::model()->find(array('condition' => "workorderDtl_id = '{$model->id}'"));
                    if (!empty($jobProductDecoration)) {
                        $jobProductDecoration->decoQty = $model->decoQty;
                        $allsaved = $jobProductDecoration->save(false);
                    }


                    //PurchaseOrderDetails::model()->updateAll(array('qty' => $model->prodQty), "workorderDtl_id = '{$model->id}'");

                    if ($model->save(false) && $allsaved == true) {
                        $transaction->commit();
                        $qtydiff = $model->qtyDiff();
                        $resultArr['status'] = 'success';
                        $resultArr['qtydiff'] = $qtydiff;
                        echo json_encode($resultArr);
                    } else {
                        $transaction->rollback();
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionAjaxQtyDiff()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if ($model) {


                    $qtydiff = $model->qtyDiff();

                    $resultArr['qtydiff'] = $qtydiff;
                    $resultArr['workorderID'] = $model->workorderId;
                    echo json_encode($resultArr);
                }
            }
        }
    }

    public function actionUpdateDecorateQty()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->decoQty = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionUpdateUnitPriceExVat()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->sellPriceExVat = $_POST['value'];
                    $invoicedtl = InvoiceDetail::model()->find(array('condition' => "workorder_id = '{$model->workorderId}' and wrkorderDtl_id = '{$model->id}'"));
                    if (!empty($invoicedtl)) {
                        $invoicedtl->sellPriceExVat = $model->sellPriceExVat;
                        $invoicedtl->totExVat = $model->sellPriceExVat * $invoicedtl->qty;
                        $invoicedtl->save();


                        $allinvoicedtls = InvoiceDetail::model()->findAll(array('condition' => "invoice_id = '{$invoicedtl->invoice_id}'"));
                        $alltotexvat = 0;
                        foreach ($allinvoicedtls as $dtl) {
                            $alltotexvat += $dtl->totExVat;
                        }

                        $invoice = Invoice::model()->findByPk($invoicedtl->invoice_id);
                        $invoice->amountExVat = $alltotexvat;
                        $invoice->save();
                    }
                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionUpdateUnitPriceIncVat()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->sellPriceIncVat = $_POST['value'];
                    $invoicedtl = InvoiceDetail::model()->find(array('condition' => "workorder_id = '{$model->workorderId}' and wrkorderDtl_id = '{$model->id}'"));
                    if (!empty($invoicedtl)) {
                        $invoicedtl->sellPriceIncVat = $model->sellPriceIncVat;
                        $invoicedtl->totIncVat = $model->sellPriceIncVat * $invoicedtl->qty;
                        $invoicedtl->save();

                        $allinvoicedtls = InvoiceDetail::model()->findAll(array('condition' => "invoice_id = '{$invoicedtl->invoice_id}'"));
                        $alltotincvat = 0;
                        foreach ($allinvoicedtls as $dtl) {
                            $alltotincvat += $dtl->totIncVat;
                        }

                        $invoice = Invoice::model()->findByPk($invoicedtl->invoice_id);
                        $invoice->amountIncVat = $alltotincvat;
                        $invoice->save();
                    }
                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionUpdateTotalExVat()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->totExVat = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionUpdateTotalIncVat()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->totIncVat = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id)
    {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex()
    {
        $dataProvider = new CActiveDataProvider('Workorderdetails');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin()
    {

        $wid = $_GET['wid'];

        $workorder = Workorder::model()->findByPk($wid);
        //cross checking and fixing the line total amount if mismatch
        $workorder->recalculateLineTotals();

        $model = new Workorderdetails('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Workorderdetails']))
            $model->attributes = $_GET['Workorderdetails'];

        $model->workorderId = $wid;

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id)
    {
        $model = Workorderdetails::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'workorderdetails-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionDeleteAjax()
    {

        if (Yii::app()->request->isPostRequest) {
            $transaction = Yii::app()->db->beginTransaction();
            $model = $this->loadModel($_POST['id']);
            $detailID = $model->id;
            $workOrderID = $model->workorder->id;
            $SONumber = $model->workorder->salesorderNumber;
            $quoteID = $model->workorder->quotationId;
            $quoteNumber = $model->workorder->quotationNumber;
            $salesdetail = $this->getSalesDetailFromModel($model);

            $invoiceDetails = InvoiceDetail::model()->findAll(array('condition' => "wrkorderDtl_id = '{$detailID}'"));

            $podtls = PurchaseOrderDetails::model()->findAll(array('condition' => "workorderDtl_id = '{$detailID}'"));
            $artwrkDtls = JobArtworkDetail::model()->findAll(array('condition' => "workorder_detial_id = '{$detailID}'"));
            if (!$podtls && !$artwrkDtls && !$invoiceDetails) {

                $arrids = array($detailID);

                $criteria = new CDbCriteria;
                $criteria->addInCondition('id', $arrids);
                Workorderdetails::model()->deleteAll($criteria);

                $criteriaDeco = new CDbCriteria;
                $criteriaDeco->addInCondition('workorder_detail_id', $arrids);
                WorkorderDetailsDecoration::model()->deleteAll($criteriaDeco);

                $criteriaOtherCost = new CDbCriteria;
                $criteriaOtherCost->addInCondition('workorder_detail_id', $arrids);
                WorkorderOtherCost::model()->deleteAll($criteriaOtherCost);

                $criteria2 = new CDbCriteria;
                $criteria2->addInCondition('workOrderDetailsId', $arrids);
                Workorderdetailssizecolor::model()->deleteAll($criteria2);

                $criteria3 = new CDbCriteria;
                $criteria3->addInCondition('workorderDtl_id', $arrids);
                JobProducts::model()->deleteAll($criteria3);

                $criteria4 = new CDbCriteria;
                $criteria4->addInCondition('workorderDtl_id', $arrids);
                JobDecorations::model()->deleteAll($criteria4);

                $criteria5 = new CDbCriteria;
                $criteria5->addInCondition('workorderDtl_id', $arrids);
                JobProductDecorations::model()->deleteAll($criteria5);

                $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $workOrderID));
                $link = CHtml::link($SONumber, $url, array('target' => '_blank'));


                SalesLog::createSalesLog($quoteID, $workOrderID, $quoteNumber, 'SalesOrder', "Sales details ({$salesdetail}) is deleted from Sales Order ({$link})", 1, 0, 1);


                $transaction->commit();
                echo json_encode(array('status' => 'success', 'message' => ''));
            } else {

                $poNumbers = '';
                if ($podtls) {
                    $poNumberArr = array();
                    foreach ($podtls as $podtl) {
                        $poNumberArr[] = $podtl->rel_po()->poNum;
                    }
                    $poNumbers = $poNumberArr ? '[ ' . implode(',', $poNumberArr) . ' ]' : '';
                }

                $invoiceNumbers = '';
                if ($invoiceDetails) {
                    $invoiceNumberArr = array();
                    foreach ($invoiceDetails as $invdtl) {
                        $invoiceNumberArr[] = $invdtl->rel_model()->invoiceNum;
                    }

                    $invoiceNumbers = $invoiceNumberArr ? '[ ' . implode(',', $invoiceNumberArr) . ' ]' : '';
                }

                $transaction->rollback();
                $message = 'Item(s) you are trying to delete are in use on an invoice or purchase order! Please remove the invoice ' . $invoiceNumbers . ' or purchase orders ' . $poNumbers . ' first and try again!';

                echo json_encode(array('status' => 'warning', 'message' => $message));
            }
        } else {
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
        }
    }

    public function actionDeleteMultipleAjax()
    {
        if (Yii::app()->request->isPostRequest) {
            //            $transaction = Yii::app()->db->beginTransaction();

            $arrids = json_decode(stripslashes($_POST['wororderDtlArr']));

            if (!$arrids) {
                throw new CHttpException(400, 'Invalid request. Please do not repeat this request again. 1');
            }
            $transaction = Yii::app()->db->beginTransaction();

            $criteriapos = new CDbCriteria;
            $criteriapos->addInCondition('workorderDtl_id', $arrids);
            $podtls = PurchaseOrderDetails::model()->findAll($criteriapos);

            $criteriaInvoice = new CDbCriteria;
            $criteriaInvoice->addInCondition('wrkorderDtl_id', $arrids);
            $invoiceDtls = InvoiceDetail::model()->findAll($criteriaInvoice);

            $criteriaArtwkrs = new CDbCriteria;
            $criteriaArtwkrs->addInCondition('workorder_detial_id', $arrids);
            $artworkDtls = JobArtworkDetail::model()->findAll($criteriaArtwkrs);

            if (!$podtls && !$artworkDtls && !$invoiceDtls) {
                $criteria = new CDbCriteria;
                $criteria->addInCondition('id', $arrids);
                Workorderdetails::model()->deleteAll($criteria);

                $criteria2 = new CDbCriteria;
                $criteria2->addInCondition('workOrderDetailsId', $arrids);
                Workorderdetailssizecolor::model()->deleteAll($criteria2);

                $criteria3 = new CDbCriteria;
                $criteria3->addInCondition('workorderDtl_id', $arrids);
                JobProducts::model()->deleteAll($criteria3);

                $criteria4 = new CDbCriteria;
                $criteria4->addInCondition('workorderDtl_id', $arrids);
                JobDecorations::model()->deleteAll($criteria4);

                $criteria5 = new CDbCriteria;
                $criteria5->addInCondition('workorderDtl_id', $arrids);
                JobProductDecorations::model()->deleteAll($criteria5);

                $transaction->commit();
                echo json_encode(array('status' => 'success', 'message' => ''));
            } else {
                $poNumbers = '';
                if ($podtls) {
                    $poNumberArr = array();
                    foreach ($podtls as $podtl) {
                        $poNumberArr[] = $podtl->rel_po()->poNum;
                    }
                    $poNumbers = $poNumberArr ? '[ ' . implode(',', $poNumberArr) . ' ]' : '';
                }

                $invoiceNumbers = '';
                if ($invoiceDtls) {
                    $invoiceNumberArr = array();
                    foreach ($invoiceDtls as $invdtl) {
                        $invoiceNumberArr[] = $invdtl->rel_model()->invoiceNum;
                    }

                    $invoiceNumbers = $invoiceNumberArr ? '[ ' . implode(',', $invoiceNumberArr) . ' ]' : '';
                }

                $transaction->rollback();
                $message = 'Item(s) you are trying to delete are in use on an invoice or purchase order! Please remove the invoice ' . $invoiceNumbers . ' or purchase orders ' . $poNumbers . ' first and try again!';
                echo json_encode(array('status' => 'warning', 'message' => $message));
            }
        } else {
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again. 3');
        }
    }

    public function actionUploadPost()
    {

        if (Yii::app()->request->isAjaxRequest) {
            $model = new Workorderdetails;
            $model->attributes = $_POST['Workorderdetails'];

            if (!empty($model->decprtnam) || !empty($model->customdecoration))
                $model->decoQty = $model->prodQty;

            $model->totExVat = $model->prodQty * $model->sellPriceExVat;
            $model->totIncVat = $model->prodQty * $model->sellPriceIncVat;


            //for image saving purpose
            $rnd = rand(123456789, 9876543210);
            $timeStamp = time();
            $uploadedFile = CUploadedFile::getInstance($model, 'image');

            if ($uploadedFile != null) {
                $fileName = "{$rnd}-{$timeStamp}-{$uploadedFile}";
                $model->image = $fileName;
            } else if ($uploadedFile == null || empty($model->image)) {
                $product = Product::model()->find("prdprd = '$model->productsku'");

                if (!empty($product) && !empty($product->prdimage1)) {
                    ///$imgfilename = basename($product->prdimage1);
                    ///copy($product->prdimage1, Yii::app()->basePath . '/../images/product_img/' . $imgfilename);

                    $model->image = $product->prdimage1;
                }
            }
            //end of image ready purpose

            $sizeArr = $_POST['Workorderdetailssizecolor']['size'];
            $quantityArr = $_POST['Workorderdetailssizecolor']['qty'];
            $colorArr = $_POST['Workorderdetailssizecolor']['color'];


            if ($model->save()) {

                $this->createJobFlow($model);

                if (!empty($uploadedFile)) {
                    $uploadedFile->saveAs(Yii::app()->basePath . '/../images/product_img/' . $fileName); // save images in given destination folder
                }

                //save work order size qty color details
                try {
                    foreach ($sizeArr as $key => $value) {
                        if (!empty($value)) {
                            $modelsizeqtycolor = new Workorderdetailssizecolor;
                            $modelsizeqtycolor->workOrderDetailsId = $model->id;
                            $modelsizeqtycolor->qty = sizeof($quantityArr) >= $key ? $quantityArr[$key] : 0;
                            $modelsizeqtycolor->size = $value;
                            $modelsizeqtycolor->color = sizeof($colorArr) >= $key ? $colorArr[$key] : 0;

                            $modelsizeqtycolor->save();
                        }
                    }
                } catch (Exception $e) {
                }

                $salesdetail = $this->getSalesDetailFromModel($model);
                $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->workorder->id));
                $link = CHtml::link($model->workorder->salesorderNumber, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'SalesOrder', "New sales details ({$salesdetail}) is added to Sales Order({$link})", 1, 0, 1);

                echo $this->getHtml($model);

                /*
                  $resultarr = array();
                  $resultarr = $model->attributes;

                  $productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $model->productsku)));
                  $decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $model->decprtnam)));
                  $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $model->id)));

                  $resultarr['pdlprdline'] = !empty($productline) ? $productline->pdlprdline : null;
                  $resultarr['pdlpdl'] = !empty($productline) ? $productline->pdlpdl : null;
                  $resultarr['decnam'] = !empty($decoration) ? $decoration->decnam : null;

                  $count = 0;
                  foreach ($workordersizeqtycolors as $row) {

                  $resultarr['sizeqtycolor'][$count]['id'] = $row['id'];
                  $resultarr['sizeqtycolor'][$count]['workOrderDetailsId'] = $row['workOrderDetailsId'];
                  $resultarr['sizeqtycolor'][$count]['size'] = $row['size'];
                  $resultarr['sizeqtycolor'][$count]['qty'] = $row['qty'];
                  $resultarr['sizeqtycolor'][$count]['color'] = $row['color'];

                  $count++;
                  }

                  echo json_encode($resultarr);
                 * 
                 */
            }
        }
    }

    private $allsavedword = true;

    public function actionAddWorkOrderDetail()
    {




        if (Yii::app()->request->isAjaxRequest) {
            $transaction = Yii::app()->db->beginTransaction();



            $model = new Workorderdetails;
            $model->attributes = $_POST['Workorderdetails'];

            //select product details according to the product source - LOCAL_DB or GWS_API
            $product_source = ProductLine::PRODUCT_SOURCE_LOCAL_DB;
            if ($_POST['adnew_prd_source'] == ProductLine::PRODUCT_SOURCE_LOCAL_DB) {
                $productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:productKey', 'params' => array(':productKey' => $_POST['adnew_prd_code'])));
                if (!$productline) {
                    //cannot complete the request
                    throw new Exception("Product Not Found", 404);
                }

                $productName = $productline->pdlprdline;
                $productLongDesc = $productline->pdldes;
                $productSupplierCode = $productline->supplier->supsup_fref;
                $productImage = $productline->getImgField();
                $productSupplierName = $productline->supplier->supnam;
            } else if ($_POST['adnew_prd_source'] == ProductLine::PRODUCT_SOURCE_GWS_API) {
                $product_source = ProductLine::PRODUCT_SOURCE_GWS_API;
                $postFields = GwsProductApi::getDefaultPostFields();
                $postFields['data'] = array(
                    'supplier' => '',
                    'product_code' => $_POST['adnew_prd_code'],
                    'product_Name' => '',
                    'category' => ''
                );

                $productData = GwsProductApi::productData($postFields);
                if (isset($productData[0]) && $product = $productData[0]) {
                    $productName = $product['pro_code'];
                    $productLongDesc = $product['long_desc'];
                    $productSupplierCode = $product['supplier'];
                    $productImage = GwsProductApi::getImageFile($product);
                    $productSupplierName = $product['supplier_name'];
                } else {
                    //cannot complete the request
                    throw new Exception("Product Not Found", 404);
                }
            }


            $model->productsku = $_POST['adnew_prd_code'];

            $model->prodsupref = $productSupplierCode;


            $sql = "select COUNT(1) as lineCount from workorderdetails where workorderId = $model->workorderId";
            $result = Yii::app()->db->createCommand($sql)->queryRow();

            $model->lineOrder = (intval($result['lineCount']) + 1);

            $model->prodQty = $_POST['adnew_edit_itm_qty'];
            $model->prodCostPrice = $_POST['adnew_cost_price'];
            $model->prod_supmarg = $_POST['adnew_prd_markup'];
            $model->prod_usd_freight = $_POST['adnew_usd_freight'];
            $model->prod_discount_pcntg = $_POST['adnew_discount_percntg'];
            $model->productFrieghtUnitCost = $_POST['adnew_usd_freight_unit_cost'];
            $model->productFrieghtMarkUpRate = $_POST['adnew_usd_freight_markup_rate'];
            $model->productFrieghtUnitCostWithMarkup = $_POST['adnew_usd_freight_unit_markedup_price'];

            $model->other_cost = $_POST['adnew_othercost_total'];
            $model->other_cost_markup_rate = $_POST['adnew_othercost_markup_rate'];

            $model->system_freight = $_POST['adnew_freight_rate'];

            $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
            $gst = floatval(GlobalVars::get('GST'));
            $model->systemTaxRateId = $_POST['adnew_tax_rate_id']; //system tax code
            if ($model->systemTaxRateId) {
                $gst = SystemTaxCode::model()->findByPk($model->systemTaxRateId)->rate;
            }

            $model->sellPriceIncVat = $model->sellPriceExVat * $gst;
            $model->totIncVat = round($model->totExVat * $gst, $roundingPrecision);

            $model->lockSellPrice = isset($_POST['lockSellPrice']) ? intval($_POST['lockSellPrice']) : 0;
            $model->product_source = $product_source;

            $model->linetypeId = 1;
            $model->createdby = Yii::app()->user->id;
            $model->createddate = date("Y-m-d g:i");



            //save image
            $rnd = rand(123456789, 9876543210);
            $timeStamp = time();
            $uploadedFile = CUploadedFile::getInstance($model, 'image');

            if ($uploadedFile != null) {
                $fileName = "{$rnd}-{$timeStamp}-{$uploadedFile}";
                $model->image = $fileName;


                $uploadedFile->saveAs('../images/product_img/' . $fileName); // save images in given destination folder
            }



            if ($model->save(false)) {

                $job = Jobs::model()->find(array('condition' => "workorder_id = {$model->workorderId}"));

                $othercosts = isset($_POST['othercost']) ? $_POST['othercost'] : null;
                $othercostIds = isset($_POST['othercostid']) ? $_POST['othercostid'] : null;

                if ($othercosts && count($othercosts) > 0) {

                    foreach ($othercosts as $key => $value) {
                        $othercostId = $othercostIds[$key];

                        $otherCostType = OtherCostType::model()->findByPk($othercostId);
                        $otherCostGroup = OtherCostGroup::model()->findByPk($otherCostType->other_cost_group_id);

                        $workOrderOtherCost = new WorkorderOtherCost();
                        $workOrderOtherCost->workorder_id = $model->workorderId;
                        $workOrderOtherCost->workorder_detail_id = $model->id;
                        $workOrderOtherCost->other_cost_id = $othercostId;
                        $workOrderOtherCost->cost = $value;
                        $workOrderOtherCost->created_by = Yii::app()->user->id;
                        $workOrderOtherCost->created_date = date('Y-m-d');
                        $workOrderOtherCost->save(false);

                        $jobProductOtherCost = new JobProductOtherCost();
                        $jobProductOtherCost->job_id = $job->id;
                        $jobProductOtherCost->workorder_detail_id = $model->id;
                        $jobProductOtherCost->workorder_id = $model->workorderId;
                        $jobProductOtherCost->other_cost_type_id = $othercostId;
                        $jobProductOtherCost->other_cost_id = $othercostId;
                        $jobProductOtherCost->other_cost_group_id = $otherCostGroup ? $otherCostGroup->id : null;
                        $jobProductOtherCost->other_cost_group_name =  $otherCostGroup ? $otherCostGroup->name : null;
                        $jobProductOtherCost->other_cost_name = $otherCostType->name;
                        $jobProductOtherCost->is_qty_based = $otherCostType->devide_by_qty;
                        $jobProductOtherCost->cost_price = $workOrderOtherCost->cost;
                        $jobProductOtherCost->quantity = $model->prodQty;
                        $jobProductOtherCost->workorder_other_cost_id = $workOrderOtherCost->id;
                        $jobProductOtherCost->save();
                        
                    }
                }



                $totalDecoSupMarginMarkupPrice = 0;
                $totalDecoLogosetupUnitMarkupPrice = 0;
                $addedDecoDetailsArr = array();
                if (isset($_POST['WorkorderDetailsDecoration'])) {

                    $addNewLineArr = $_POST['WorkorderDetailsDecoration'];



                    foreach ($addNewLineArr as $key => $value) {

                        if (isset($value['decprtnam']) && $value['decprtnam']) {



                            $totalDecoSupMarginMarkupPrice += $value['sup_markedup_price'];
                            $totalDecoLogosetupUnitMarkupPrice += $value['logo_setup_unit_markedup_price'];

                            //Create quotaton decoration detail
                            $workOrderDecoDetail = new WorkorderDetailsDecoration();

                            $workOrderDecoDetail->decprtnam = $value['decprtnam'];

                            $decoration = $workOrderDecoDetail->decprtnam ? Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $workOrderDecoDetail->decprtnam))) : null;




                            $workOrderDecoDetail->work_order_id = $model->workorderId;
                            $workOrderDecoDetail->workorder_detail_id = $model->id;
                            $workOrderDecoDetail->decoration_id = $decoration->decsno;
                            $workOrderDecoDetail->decdesc = $decoration->decnam;
                            $workOrderDecoDetail->quantity = $model->prodQty;
                            $workOrderDecoDetail->cost_price = $value['cost_price'];
                            $workOrderDecoDetail->sup_margin = $value['sup_margin'];
                            $workOrderDecoDetail->sup_markedup_price = $value['sup_markedup_price'];
                            $workOrderDecoDetail->logo_setup = $value['logo_setup'];
                            $workOrderDecoDetail->logo_setup_unit_price = $value['logo_setup_unit_price'];
                            $workOrderDecoDetail->logo_setup_markup_rate = $value['logo_setup_markup_rate'];
                            $workOrderDecoDetail->logo_setup_unit_markedup_price = $value['logo_setup_unit_markedup_price'];
                            $workOrderDecoDetail->supref = $decoration->supplier->supsup_fref;

                            $workOrderDecoDetail->created_at = date('Y-m-d');
                            $workOrderDecoDetail->created_by = Yii::app()->user->id;


                            if ($workOrderDecoDetail->save(false)) {
                                $addedDecoDetailsArr[] = $workOrderDecoDetail->id;
                            }
                        }
                    }
                }


                //here copy details to jobproduct,jobdecoration and jobproductdecoration tables
                $this->createJobFlow($model, $addedDecoDetailsArr);
                $salesdetail = $this->getSalesDetailFromModel($model);
                $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $model->workorder->id));
                $link = CHtml::link($model->workorder->salesorderNumber, $url, array('target' => '_blank'));
                SalesLog::createSalesLog($model->workorder->quotationId, $model->workorder->id, $model->workorder->quotationNumber, 'SalesOrder', "New sales details ({$salesdetail}) is added to Sales Order ({$link})", 1, 0, 1);

                echo $this->getHtml($model);
            } else {
                $this->allsavedword = false;
            }

            if ($this->allsavedword == true) {
                $transaction->commit();
            } else {
                $transaction->rollback();
            }
        }
    }

    private function createJobFlow($dtl, $addedDecoDetailsArr)
    {
        //$dtl is reffred to Workorderdetails
        $job = Jobs::model()->find("workorder_id = '$dtl->workorderId'");

        if (!empty($job) && !empty($dtl)) {
            if (!empty($dtl->productsku) || !empty($dtl->prdsrtdesc) || !empty($dtl->prdlngdesc)) {
                $job_product = new JobProducts();
                $job_product->job_id = $job->id;
                $job_product->workorderDtl_id = $dtl->id;
                $job_product->qty = $dtl->prodQty;
                $job_product->prodCostPrice = $dtl->prodCostPrice;
                $job_product->status_id = 1; //New
                $job_product->user_id = Yii::app()->user->id;

                $this->allsavedword = $job_product->save();
            }


            if (count($addedDecoDetailsArr) > 0) {
                $criteria = new CDbCriteria;
                $criteria->addInCondition('id', $addedDecoDetailsArr);
                $workOrderDecorations = WorkorderDetailsDecoration::model()->findAll($criteria);
                foreach ($workOrderDecorations as $data) {
                    $job_decoration = new JobDecorations();
                    $job_decoration->job_id = $job->id;
                    $job_decoration->workorderDtl_id = $dtl->id;
                    $job_decoration->decprtnam = $data->decprtnam;
                    $job_decoration->decdesc = $data->decdesc;
                    $job_decoration->customdecoration = $data->customdecoration;
                    $job_decoration->decoQty = $data->quantity;
                    $job_decoration->decoCostPrice = $data->cost_price;
                    $job_decoration->decosupref = $data->supref;
                    $job_decoration->customizationDetails = $dtl->customizationDetails;
                    $job_decoration->status_id = 1; //New
                    $job_decoration->user_id = Yii::app()->user->id;
                    $job_decoration->createdDtm = date('Y-m-d H:i:s');
                    $job_decoration->work_order_detail_decoration_id = $data->id;
                    $this->allsavedword = $job_decoration->save(false);

                    $job_product_decoration = new JobProductDecorations();
                    $job_product_decoration->job_id = $job->id;
                    $job_product_decoration->workorderDtl_id = $dtl->id;
                    $job_product_decoration->decprtnam = $data->decprtnam;
                    $job_product_decoration->decdesc = $data->decdesc;
                    $job_product_decoration->customdecoration = $data->customdecoration;
                    $job_product_decoration->decoQty = $data->quantity;
                    $job_product_decoration->decoCostPrice = $data->cost_price;
                    $job_product_decoration->decosupref = $data->supref;
                    $job_product_decoration->customizationDetails = $dtl->customizationDetails;
                    $job_product_decoration->user_id = Yii::app()->user->id;
                    $job_product_decoration->status_id = 1; //New

                    $job_product_decoration->work_order_detail_decoration_id = $data->id;

                    $this->allsavedword = $job_product_decoration->save(false);
                }
            }
        }
    }

    private function getSalesDetailFromModel($model)
    {
        $salesdetail = "{";
        if (!empty($model->productsku)) {
            $salesdetail .= $model->prdsrtdesc . " ({$model->productsku})";
        }

        if (!empty($model->custmproduct)) {
            $salesdetail .= $model->custmproduct;
        }

        if (!empty($model->decprtnam)) {
            $salesdetail .= " - " . $model->decdesc;
        }

        if (!empty($model->customdecoration)) {
            $salesdetail .= " - " . $model->customdecoration;
        }

        $salesdetail .= "} x " . $model->prodQty . " in qty";

        return $salesdetail;
    }

    private function getHtml($record)
    {
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        $html = '';

        $allrecords = Workorderdetails::model()->findAll(array('condition' => "workorderId = '{$record->workorderId}'"));
        $count = count($allrecords);


        $productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $record->productsku)));
        //$decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $record->decprtnam)));
        $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $record->id)));


        //$rowtype = $count % 2;



        $html .= '<tr class="maindetailrow"  id="row_' . $record->id . '"   >            
                <td class="maincell">
                    <table class="maintbl">
                            <tr id="mainrow_' . $record->id . '"  >
                                <td style="width: 3%;text-align: center;"> 
                                <input value="' . intval($record->lineOrder) . '" type="text" name="QuatationDetails[lineOrder]" id="detail-line-order-row-' . $record->id . '" style="width: 15px;" onchange="saveLineOrder(' . $record->id . ', this.value);"/>
                                <input type="checkbox" id="delete_row_' . $record->id . '" onchange="addtoDelete(' . $record->id . ');" />    
                                </td>
                                <td style="width: 26%;text-align: center;"><div class="prodecs">';



        if (!empty($record->productsku) && !empty($record->product)) {
            $html .= CHtml::link($record->productsku, array("productLine/view", "id" => $record->product->pdlsno), array("target" => "_blank", 'title' => "click here to see full product spec")) . '<br>';
        }
        //if (!empty($record->prdsrtdesc)) {
        $html .= '<textarea id="productsku_' . $record->id . '" onchange="saveproductsku(' . $record->id . ',this.value)" cols="3" rows="3">';
        $html .= trim($record->prdsrtdesc);
        $html .= '</textarea>';
        $html .= '<a href="#" onclick="saveproductsku(' . $record->id . ',this.value);return false;">Save</a>';
        //        } else {
        //            $html .= '<textarea id="customprod_' . $record->id . '" onchange="savecustomprod(' . $record->id . ',this.value);" >';
        //            $html .= trim($record->custmproduct);
        //            $html .= '</textarea>';
        //        }
        $html .= '</div>';


        $html .= '<div class="viewlongdesc" id="viewlongdesc_' . $record->id . '" onclick="viewlongdecription(' . $record->id . ');">View long description</div>';
        $html .= '<div class="prolngdesc" id="prodlngdesc_' . $record->id . '">';
        $html .= '<textarea onchange="saveprodlngdes(' . $record->id . ',' . $productline->pdlsno . ',this.value);" cols="3" rows="10" >';
        $html .= $record->prdlngdesc;
        $html .= '</textarea>';
        $html .= '<a href="#" onclick="saveprodlngdes(' . $record->id . ',' . $productline->pdlsno . ',this.value);return false;" >Save</a>';
        $html .= '</div>';



        $html .= '</td><td style="width: 26.5%;text-align: center;">';


        $html .= '<div id="multideco_' . $record->id . '">';
        $html .= $record->getMultiDecoHtml();
        $html .= '</div>';
        $html .= '<a href="#" style="width: 95%;"   data-toggle="modal" onclick="showEditMultiDecoModal(' . $record->id . ');return false;">Edit Decorations</a>';






        $html .= '</td>
                                <td style="width: 11%;">
                                    <br>
                                    <input style="width: 95%;text-align: center;"  id="prodqty_' . $record->id . '" name="QuatationDetails[qty]" type="text" value="' . $record->prodQty . '"  onchange="saveprodcutqty(' . $record->id . ',this.value);" />
                                </td>
                                
                                <td style="width: 12.5%;">
                                    <a href="#" style="width: 95%;text-align: center;"   data-toggle="modal" onclick="showEditPriceModal(' . $record->id . ');return false;">Edit Price</a>
                                    <input style="width: 95%;text-align: center;"  id="sellpriceexvat_' . $record->id . '" name="QuatationDetails[sellunitprice_ex_vat]" type="text" value="' . round($record->sellPriceExVat, $roundingPrecision) . '"  disabled="true"/>
                                        
                                </td>
                                
                                <td style="width: 12.5%;">
                                <br>
                                    <input style="width: 95%;text-align: right;"  id="totexvat_' . $record->id . '" disabled="disabled" name="QuatationDetails[selltot_ex_vat]" type="text" value="' . (round($record->sellPriceExVat, $roundingPrecision) * $record->prodQty) . '"  />
                                </td>
                                                               
                                <td class="button-column" >
                                    <table id="moredtl_imgnode_' . $record->id . '" style="width: 100%;cursor: pointer;" onclick="subrowvisible(' . $record->id . ');" >
											<tr>
												<td style="width: 30%;"><span class="sodtlicon fa fa-plus-circle"></span></td>
												<td>Add Size/Dec/Customizations</td>
											</tr>
										</table>							
										
										<hr />
										<table style="width: 100%;cursor: pointer;" onclick="deleteRecord(' . $record->id . ');return false;" >
											<tr>
												<td style="width: 30%;"><span class="sodtlicon fa fa-trash-o"></span></td>
												<td>Delete Item</td>
											</tr>
										</table>	
                                </td> 
                            </tr>
                            <tr class="subrow" id="subrow_' . $record->id . '" >
                                <td colspan="9" >
                                    <div id="subrowdiv_' . $record->id . '" >
                                        <table class="fullwidth">
                                            <tr class="fullwidth">
                                                <td class="fullwidth">
                                                    <table  class="subrowgrid fullwidth">
                                                        <tr >
                                                            <th class="column3" >Customization Details</th>
                                                            <th class="column3" >Notes</th>
                                                            <th class="column2half" >Imagery</th>
                                                            <th class="column1half" >Size/Colors</th>
                                                        </tr>
                                                        <tr >
                                                            <td class="column3" ><textarea onchange="savecutomizeddetails(' . $record->id . ', this.value);"  >' . $record->customizationDetails . '</textarea></td>
                                                            <td class="column3" ><textarea onchange="savenotes(' . $record->id . ', this.value);">' . $record->notes . '</textarea></td>
                                                            <td class="column2half centercls" >';


        if (!empty($record->image)) {


            $html .= '<img src="' . $record->getImg() . '" />';
        } else {

            $html .= '';
        }




        $html .= '</td><td class="column1half"><div  >';


        $html .= '<form id="uploadimgform_' . $record->id . '" action="" method="post" enctype="multipart/form-data">';

        $html .= '<input id="uploadimgfile_' . $record->id . '" type="file" name="file" id="file" required style="display: none;" onchange="imageChoosed(' . $record->id . ',this.files[0].name);" />';

        $html .= '</form><div id="saveimg_' . $record->id . '" class="saveimg" onclick="saveimg(' . $record->id . ');" style="background-color:#32cd32;">Save Image</div>';

        $html .= '<div id="uploadimg_' . $record->id . '" class="uploadimg" onclick=uploadimg(' . $record->id . '); style="background-color:#32cd32;">Upload Image</div>
                                                                    </div>
                                                                    

                                                            <div id="viewsizecolor_' . $record->id . '" class="viewsizecolor" onclick="visiblesizeqtycolorDBTable(' . $record->id . ');" style="background-color:#32cd32;">View Size/Colors</div>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td> 
                                            </tr>
                                            <tr class="fullwidth">
                                                <td class="fullwidth">
                                                    <div class="fullwidth sizeqtycolordiv" id="sizeqtycolorDB_tbl_container_' . $record->id . '" >
                                                        <table  id="sizeqtycolorDB_tbl_' . $record->id . '" >
                                                        <tr>
                                                            <th class="column1">#</th>
                                                            <th class="column2half">Size</th>
                                                            <th class="column2half">Quantity</th>
                                                            <th class="column2half">Color</th>
                                                            <th class="column1half"><div  onclick="addsizeqtycolorDBrow(' . $record->id . ');" style="background-color:#32cd32;">+Add Row</div></th>
                                            </tr>';


        $countrow = 0;
        foreach ($workordersizeqtycolors as $row) {
            $countrow++;

            $html .= '<tr id="sizeqtycolorDBrow_' . $row['id'] . '" >
                                                    <td class="column1">' . $countrow . '</td>
                                                    <td class="column2half">' . $row['size'] . '</td>
                                                    <td class="column2half">' . $row['qty'] . '</td>
                                                    <td class="column2half">' . $row['color'] . '</td>
                                                    <td class="column1half">
                                                    <a href="#" onclick="editsizeqtycolorDBrowAjaxcall(' . $row['id'] . ');return false;">Edit</a>&nbsp;|&nbsp;
                                                    <a href="#"  onclick="deletesizeqtycolorDBrow(' . $row['id'] . ');return false;">Delete</a></td>
                                                </tr>';
        }

        $html .= ' </table>
                    <div id="sizeQtyClrSaveChangesBtn_' . $record->id . '" style="border: 1px solid #fff;background-color:#32cd32;float: right;color: #fff;border-radius: 15px;padding:2px 4px;font-weight: bold;font-size:0.8m;margin-right: 3%;cursor: pointer;display: none;" onclick="savedtlrow(' . $record->id . ');">Save Changes</div>
                                                        
                    </div></td></tr></table></div></td> </tr> </table>
                        <div id="savemessage_' . $record->id . '" class="savemessage">Changes are saved</div>
                         <div class="addproductdtl" onclick="subrowvisible(' . $record->id . ');" title="Add Product Details">Add Product Details</div>   
                        </td>
                    </tr>';
        $html .= '<tr id="lineOptionRow_' . $record->id . '">
                                        <td colspan="8" style="text-align: left;">' . CHtml::button('Line Options:', array('class' => 'lineOptionRow', 'lineOptionRowId' => $record->id)) . '
                                            <div id="flagLabelTextDiv_' . $record->id . '" style="display: inline-block;">' . $record->getOnFlagsLabelsHtml() . '</div>
                                        </td>
                                    </tr>';

        return $html;
    }

    public function actionUploadImg()
    {
        if (Yii::app()->request->isAjaxRequest) {
            $model = $this->loadModel($_POST['Workorderdetails']['id']);
            $model->image = $_POST['Workorderdetails']['image'];

            $rnd = rand(123456789, 9876543210);
            $timeStamp = time();
            $uploadedFile = CUploadedFile::getInstance($model, 'image');

            if ($uploadedFile != null) {
                $fileName = "{$rnd}-{$timeStamp}-{$uploadedFile}";
                $model->image = $fileName;
            }


            $uploadfilepath = '';
            if ($model->save()) {
                if (!empty($uploadedFile)) {
                    $uploadfilepath = Yii::app()->basePath . '/../images/product_img/' . $fileName;
                    $uploadedFile->saveAs($uploadfilepath); // save images in given destination folder
                }

                echo $model->getImg();
            } else {
                echo 'error';
            }
        } else {
            echo 'error';
        }
    }

    public function actionFilterDecoration()
    {

        $arr = array();
        $decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $_POST['decprtnam'])));

        $arr['decorateDesc'] = $decoration->decnam;
        $arr['decprtnam'] = $decoration->decprtnam;


        echo json_encode($arr);
    }

    public function actionFilterDesc()
    {

        $arr = array();
        $productLine = ProductLine::model()->find(array('condition' => 'pdlpdl=:productKey', 'params' => array(':productKey' => $_POST['productsku'])));

        $arr['prdlineID'] = $productLine->pdlsno;
        $arr['longdesc'] = $productLine->pdldes;
        $arr['shortdesc'] = $productLine->pdlprdline;

        echo json_encode($arr);
    }

    public function actionUpdateProductShortDescription()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['wrkorddtlID'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['wrkorddtlID']);
                if ($model) {
                    $model->prdsrtdesc = htmlspecialchars(trim($_POST['value']));

                    if ($model->save(false)) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    }
                }
            }
        }
    }

    public function actionUpdateProductLongDescription()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['wrkorddtlID'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['wrkorddtlID']);
                if (!empty($model)) {
                    $model->prdlngdesc = htmlspecialchars(trim($_POST['value']));

                    if ($model->save(false)) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } 
                }
            }
        }
    }

    public function actionUpdateDecorationName()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['wrkorddtlID'], $_POST['value'])) {
                $resultArr = array();
                $transaction = Yii::app()->db->beginTransaction();
                $allsaved = true;
                $model = $this->loadModel($_POST['wrkorddtlID']);

                if (!empty($model)) {
                    $model->decdesc = trim($_POST['value']);

                    $jobdecoration = JobDecorations::model()->find(array('condition' => "workorderDtl_id = '{$model->id}'"));
                    $job = Jobs::model()->find(array('condition' => "workorder_id = $model->workorderId"));
                    if (!empty($jobdecoration)) {
                        $jobdecoration->decdesc = $model->decdesc;
                        $allsaved = $jobdecoration->save(false);
                    } else {

                        if (!empty($job)) {
                            $job_decoration = new JobDecorations();
                            $job_decoration->job_id = $job->id;
                            $job_decoration->workorderDtl_id = $model->id;
                            $job_decoration->decprtnam = $model->decprtnam;
                            $job_decoration->decdesc = $model->decdesc;
                            $job_decoration->customdecoration = $model->customdecoration;
                            $job_decoration->decoQty = $model->decoQty;
                            $job_decoration->decoCostPrice = $model->decoCostPrice;
                            $job_decoration->decosupref = $model->decosupref;
                            $job_decoration->customizationDetails = $model->customizationDetails;
                            $job_decoration->status_id = 1; //New
                            $job_decoration->user_id = Yii::app()->user->id;
                            $job_decoration->createdDtm = date('Y-m-d H:i:s');
                            $allsaved = $job_decoration->save();
                        }
                    }

                    $jobProductDecoration = JobProductDecorations::model()->find(array('condition' => "workorderDtl_id = '{$model->id}'"));
                    if (!empty($jobProductDecoration)) {
                        $jobProductDecoration->decdesc = $model->decdesc;
                        $allsaved = $jobProductDecoration->save(false);
                    } else {
                        if (!empty($job)) {
                            $job_product_decoration = new JobProductDecorations();
                            $job_product_decoration->job_id = $job->id;
                            $job_product_decoration->workorderDtl_id = $model->id;
                            $job_product_decoration->decprtnam = $model->decprtnam;
                            $job_product_decoration->decdesc = $model->decdesc;
                            $job_product_decoration->customdecoration = $model->customdecoration;
                            $job_product_decoration->decoQty = $model->decoQty;
                            $job_product_decoration->decoCostPrice = $model->decoCostPrice;
                            $job_product_decoration->decosupref = $model->decosupref;
                            $job_product_decoration->customizationDetails = $model->customizationDetails;
                            $job_product_decoration->user_id = Yii::app()->user->id;
                            $job_product_decoration->status_id = 1; //New

                            $allsaved = $job_product_decoration->save();
                        }
                    }

                    //JobProductDecorations::model()->updateAll(array('decdesc' => $model->decdesc), "workorderDtl_id = '{$model->id}' and decprtnam = '{$model->decprtnam}'");

                    if ($model->save(false) && $allsaved == true) {
                        $transaction->commit();
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        $transaction->rollback();
                        throw new Exception;
                    }
                }
            }
        }
    }

    protected function loadWorkOrder($workorderid)
    {
        //if the supplier property null, create it based on input id
        if ($this->_workorder == null) {
            $this->_workorder = Workorder::model()->findByPk($workorderid);
            if ($this->_workorder == null) {
                throw new CHttpException(404, 'The requested supplier does not exist.');
            }
        }
        return $this->_workorder;
    }

    public function filterWorkorderContext($filterChain)
    {
        //set the supplier identifier based on GET input request variables 
        if (isset($_GET['wid']))
            $this->loadWorkOrder($_GET['wid']);
        else
            throw new CHttpException(403, 'Must specify a supplier before performing this action.');

        //complete the running of other filters and execute the requested action
        $filterChain->run();
    }

    public function actionGetQtyDiff()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['wrkorddtlID'])) {
                $id = $_POST['wrkorddtlID'];
                $model = $this->loadModel($id);

                $arr = array();

                $arr['qtydiff'] = $model->qtyDiff();

                echo json_encode($arr);
            } else {
                throw new CHttpException(403, 'error in get qty difference.');
            }
        } else {
            throw new CHttpException(403, 'error in get qty difference.');
        }
    }

    private function getRateOutOfPercentage($percentage)
    {
        if (!$percentage)
            return 0;
        return (($percentage + 100) / 100);
    }

    private function getMarginOutOfMarkupMultiplier($rate)
    {
        if (in_array(floatval($rate), array(0, 0.0, null))) {
            return 0;
        }

        $markup_decimal_value = $rate;
        $hold_value = $markup_decimal_value * 100;
        $hold_value2 = $hold_value - 100;
        if (floatval($markup_decimal_value) != 0.0) {
            $new_margin_percentate = ($hold_value2 / $markup_decimal_value);
        } else {
            $new_margin_percentate = $hold_value2;
        }


        return intval($new_margin_percentate);
    }

    public function actionFetchDetailsPrices()
    {
        if (isset($_POST['id'])) {
            $id = $_POST['id'];
            $model = $this->loadModel($id);

            $arr = array();
            $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
            if (empty($roundingPrecision)) {
                $roundingPrecision = 2;
            }


            $itmQty = $model->prodQty;
            $prodCostPrice = round($model->prodCostPrice, $roundingPrecision);
            $prodMarkupRate = round($model->prod_supmarg, 4);

            $prodMarkupPercentage = $model->supmargPercentage ?: $this->getMarginOutOfMarkupMultiplier($model->prod_supmarg);

            //if markup rate zero then set price must be zero
            $prodMarkedUpPrice = $prodMarkupRate ? round(($prodCostPrice * $prodMarkupRate), $roundingPrecision) : 0;
            $prodDiscPercntg = $model->prod_discount_pcntg;
            $prodDiscRate = round(($prodDiscPercntg / 100), strlen($prodDiscPercntg));
            $prodDiscountedPrice = $prodDiscRate ? round(($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)), $roundingPrecision) : $prodMarkedUpPrice;
            $usdFreight = $model->prod_usd_freight;
            $usdFreightUnit = $model->productFrieghtUnitCost;
            $usdFreightMarkupRate = $model->productFrieghtMarkUpRate;
            $usdFreightMarkupPercentage = $model->productFrieghtMarkUpPercentage ?: $this->getMarginOutOfMarkupMultiplier($model->productFrieghtMarkUpRate);
            $usdFreightUnitWithMarkedUp = $model->productFrieghtUnitCostWithMarkup;




            $prodUsdFreigtedPrice = $prodDiscountedPrice + round($usdFreightUnitWithMarkedUp, $roundingPrecision);
            $otherCostTotal = $model->other_cost;
            $otherCostMarkupRate = $model->other_cost_markup_rate;
            $otherCostMarkUpPercentage = $model->otherCostMarkupPercentage ?: $this->getMarginOutOfMarkupMultiplier($model->other_cost_markup_rate);



            //if markup rate zero then set price must be zero
            $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? round(($otherCostTotal * $otherCostMarkupRate), $roundingPrecision) : 0;


            $decorationTotal = 0;
            $decoCostPrice = 0;

            foreach ($model->rel_multi_deco() as $data) {

                $decoCostPrice += ($data->cost_price + $data->logo_setup_unit_price);
                $decorationTotal += $data->sup_markedup_price + $data->logo_setup_unit_markedup_price;
            }


            $subTotal = $model->sellPriceExVat; //$prodUsdFreigtedPrice + $otherCostMarkedUpPrice + $decorationTotal;
            $subTotalWithSetup = $subTotal;
            $freightRate = $model->system_freight;
            $systemFreightPercentage = $model->systemFreightPercentage ?: $this->getMarginOutOfMarkupMultiplier($model->system_freight);

            if (!$freightRate) {
                $freightRate = floatval(GlobalVars::get("SystemFreight"));
            }



            $total = $freightRate ? round(($subTotalWithSetup * $freightRate), $roundingPrecision) : $subTotalWithSetup;


            $othercosts = WorkorderOtherCost::model()->findAll(array('condition' => "workorder_detail_id = $id"));

            $count = 0;
            $linetype = 0;
            $otherCostHtml = "";


            foreach ($othercosts as $data) {

                $count++;
                $linetype = $count % 2;
                $currentrow = "edit_oc_row_" . $count;
                $othercost = OtherCostType::model()->findByPk($data->other_cost_id);
                $qty_based_html = '';
                $qty_based_attr = '';
                $unit_cost = $data->cost;
                if ($othercost->devide_by_qty) {
                    $qty_based_attr = 'qtybsd="true"';
                    $qty_based_html = '<font style="font-size:0.7em;color: #880000;">Quantity Based</font>';

                    $unit_cost = $data->cost / $itmQty;
                }
                $rowclass = ($linetype == 1 ? 'class="customodd"' : 'class="customeven"');
                $otherCostHtml .= '<tr ' . $rowclass . ' id="edit_oc_row_' . $count . '">';
                $otherCostHtml .= '<td style="display:none;"><input class="othercostid" name="othercostid[]" value="' . $data->other_cost_id . '" /></td>';
                $otherCostHtml .= '<td >' . $othercost->cost_group_rel->name . '</td>';
                $otherCostHtml .= '<td >' . $othercost->name . '<br>' . $qty_based_html . '</td>';
                $otherCostHtml .= '<td ><input ' . $qty_based_attr . ' name="othercost[]" value="' . $data->cost . '" tabindex="' . $count . '"/></td>';
                $otherCostHtml .= '<td >' . number_format($unit_cost, 2) . '</td>';
                $otherCostHtml .= '<td ><a href="#" onclick="deleteEditOtherCostRow(\'' . $currentrow . '\');return false;">Delete</a></td>';
                $otherCostHtml .= '</tr>';
            }

            $otherCostHtml .= '<tr><td colspan="2" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">Total</td><td class="plokij" style="text-align:center;font-weight:bold;border-top:1px solid #ddd;">' . number_format($otherCostTotal, 2) . '</td><td style="border-top:1px solid #ddd;">&nbsp;</td></tr>';



            $grossProfit = $total - ($prodCostPrice + $usdFreightUnit + $decoCostPrice + $otherCostTotal);
            $grossProfitPercentage = $total ? round(($grossProfit / $total) * 100, 2) : $total;


            $arr['prodCostPrice'] = $prodCostPrice;
            $arr['prodMarkupRate'] = $prodMarkupRate;
            $arr['prodMarkupPercentage'] = round($prodMarkupPercentage, 4);
            $arr['prodMarkedUpPrice'] = $prodMarkedUpPrice;
            $arr['prodDiscPercntg'] = $prodDiscPercntg;
            $arr['prodDiscountedPrice'] = $prodDiscountedPrice;
            $arr['usdFreight'] = $usdFreight;
            $arr['prodUsdFreigtedPrice'] = $prodUsdFreigtedPrice;

            $arr['otherCostTotal'] = $otherCostTotal;
            $arr['otherCostMarkUpRate'] = $otherCostMarkupRate;
            $arr['otherCostMarkUpPercentage'] = $otherCostMarkUpPercentage;
            $arr['otherCostMarkedUpPrice'] = $otherCostMarkedUpPrice;
            $arr['subTotal'] = $subTotal;
            $arr['itmQty'] = $itmQty;

            $arr['subTotalWithSetup'] = $subTotalWithSetup;
            $arr['freightRate'] = $freightRate;
            $arr['freightPercentage'] = $systemFreightPercentage;
            $arr['total'] = $total;
            $arr['aFLockSellPrice'] = $model->lockSellPrice;

            $arr['otherCostHtml'] = $otherCostHtml;

            //new usd freight values for product
            $arr['usdFreightUnit'] = $usdFreightUnit;
            $arr['usdFreightMarkupRate'] = $usdFreightMarkupRate;
            $arr['usdFreightMarkupPercentage'] = $usdFreightMarkupPercentage;
            $arr['usdFreightUnitWithMarkedUp'] = $usdFreightUnitWithMarkedUp;

            $arr['multiDecoCalScreenHtml'] = $this->getMultiDecoCalScreenHtmlInputs($model);

            $arr['totalCostPrice'] = ($prodCostPrice + $usdFreightUnit + $decoCostPrice + $otherCostTotal);
            $arr['grossProfitPercentage'] = $grossProfitPercentage;
            $arr['grossProfit'] = $grossProfit;
            $arr['totalGrossProfit'] = $grossProfit * $itmQty;

            $arr['systemTaxRateId'] = $model->systemTaxRateId;




            echo json_encode($arr);
        } else {
            throw new CHttpException(403, 'error in get prices.');
        }
    }

    //Get the multiple decorations html inputs for given quotation detail

    private function getMultiDecoCalScreenHtmlInputs($workOrderDetail)
    {
        $html = "<table style='width:100%;'>";
        $html .= "<tr style='width:100%;'>";
        $html .= "<th style='width: 5%;text-align:center;'>No</th>";
        $html .= "<th style='width: 30%;text-align:center;'>Code</th>";
        $html .= "<th style='width: 20%;text-align:center;'>Unit Price</th>";
        $html .= "<th style='width: 25%;text-align:center;'>Mark-Up</th>";
        $html .= "<th style='width: 20%;text-align:center;'>Marked-Up Price</th>";
        $html .= "</tr>";
        $html .= "<tbody>";

        $count = 0;

        $decorationTotal = 0;

        foreach ($workOrderDetail->rel_multi_deco() as $data) {
            $count++;
            $decoCalArr = $data->getDecorationCalculations(
                array(
                    'cost_price' => $data->cost_price,
                    'sup_margin' => $data->sup_margin,
                    'logo_setup' => $data->logo_setup,
                    'quantity' => $data->quantity,
                    'logo_setup_markup_rate' => $data->logo_setup_markup_rate
                )
            );

            $supplierHtml = $data->supRel ? $data->supRel->getSupplierLink() : '';
            if (!$supplierHtml) {
                //set default supplier from decoration table
                $supplierHtml = ($data->decoRel ? $data->decoRel->getSupplierLink() : '');
            }

            $supMargingPercentage = $data->supmargPercentage ?: $this->getMarginOutOfMarkupMultiplier($data->sup_margin);
            $logoSetupMarkupPercentage = $data->logoSetupMarkupPercentage ?: $this->getMarginOutOfMarkupMultiplier($data->logo_setup_markup_rate);

            $decorationTotal += $decoCalArr['sup_markedup_price'] + $decoCalArr['logo_setup_unit_markedup_price'];

            $html .= "<tr style='width:100%;border-bottom:1px solid #eee;'>";
            $html .= "<td style='width:5%;'>{$count}</td>";
            $html .= "<td   colspan='4'>";
            $html .= "<table style='width:100%;'>";

            $html .= "<tr style='width:100%;'>";
            $html .= "<td style='width: 30%;'><input type='hidden' name='WorkorderDetailsDecoration[{$data->id}][decprtnam]' value='{$data->decprtnam}' /><div style='font-size:8.5pt;'>{$data->decprtnam}</div><div style='font-size:7.5pt;'>{$data->decdesc}</div><div style='font-size:8.5pt;'>{$supplierHtml}</div></td>";
            $html .= "<td style='width:20%;text-align:right;'><input type='text' name='WorkorderDetailsDecoration[{$data->id}][cost_price]' value='{$decoCalArr['cost_price']}' style='width:90%;text-align:center;'/></td>";
            $html .= "<td style='width: 25%;text-align:right;'>"
                . "<input mark-up='rate' type='text' name='WorkorderDetailsDecoration[{$data->id}][sup_margin]' value='{$decoCalArr['sup_margin']}' style='width:30%;text-align:center;margin-right:2px;'/>"
                . "<input title='percentage(%)' mark-up='percentage'  type='text'  style='text-align: center;width: 30%;' name='WorkorderDetailsDecoration[{$data->id}][supmargPercentage]' value='{$supMargingPercentage}' />  (%)"
                . "</td>";
            $html .= "<td style='width: 20%;text-align:right;'><input type='text' name='WorkorderDetailsDecoration[{$data->id}][sup_markedup_price]' value='{$decoCalArr['sup_markedup_price']}' readonly='true' style='width:90%;text-align:right;'/></td>";
            $html .= "</tr>";
            $html .= "<tr style='width:100%;'>";
            $html .= "<td style='width:30%;'>LogoSetup : <input type='text' name='WorkorderDetailsDecoration[{$data->id}][logo_setup]' value='{$decoCalArr['logo_setup']}' style='width:40%;text-align:center;'/></td>";
            $html .= "<td style='width: 20%;text-align:right;'><input type='text' name='WorkorderDetailsDecoration[{$data->id}][logo_setup_unit_price]' value='{$decoCalArr['logo_setup_unit_price']}' style='width:90%;text-align:center;'/></td>";
            $html .= "<td style='width: 25%;text-align:right;'>"
                . "<input mark-up='rate' type='text' name='WorkorderDetailsDecoration[{$data->id}][logo_setup_markup_rate]' value='{$decoCalArr['logo_setup_markup_rate']}' style='width:30%;text-align:center;margin-right:2px;'/>"
                . "<input title='percentage(%)' mark-up='percentage'  type='text'  style='text-align: center;width: 30%;' name='WorkorderDetailsDecoration[{$data->id}][logoSetupMarkupPercentage]' value='{$logoSetupMarkupPercentage}' />  (%)"
                . "</td>";
            $html .= "<td style='width: 20%;text-align:right;'><input type='text' name='WorkorderDetailsDecoration[{$data->id}][logo_setup_unit_markedup_price]' value='{$decoCalArr['logo_setup_unit_markedup_price']}' readonly='true' style='width:90%;text-align:right;' /></td>";
            $html .= "</tr>";

            $html .= "</table>";
            $html .= "</td>";
            $html .= "</tr>";
        }



        $html .= "<tr style='width:100%;'>";
        $html .= "<td colspan='4' style='text-align:right;'>Decoration Total : </td><td><input name='af_edit_decoration_total' id='af_edit_decoration_total' type='text' value='{$decorationTotal}' readonly='true' style='width:90%;text-align:right;' /></td>";
        $html .= "</tr>";

        $html .= "</tbody>";
        $html .= "</table>";

        return $html;
    }

    public function actionUpdateDetailsFields()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id']) && isset($_POST['field']) && isset($_POST['value'])) {
                $id = $_POST['id'];
                $fieldname = $_POST['field'];
                $value = $_POST['value'];

                $updated = Workorderdetails::model()->updateByPk($id, array(
                    "$fieldname" => $value
                ));

                if ($fieldname == 'prodCostPrice') {
                    $jobproduct = JobProducts::model()->find(array('condition' => "workorderDtl_id = '{$id}'"));
                    if (!empty($jobproduct)) {
                        $jobproduct->prodCostPrice = $value;
                        $jobproduct->save(false);
                    }
                }

                if ($fieldname == 'decoCostPrice') {
                    $jobproductdeco = JobProductDecorations::model()->find(array('condition' => "workorderDtl_id = '{$id}'"));
                    if (!empty($jobproductdeco)) {
                        $jobproductdeco->decoCostPrice = $value;
                        $jobproductdeco->save(false);
                    }
                }

                $arr = array();

                $arr['success'] = $updated;


                echo json_encode($arr);
            } else {
                throw new CHttpException(403, 'error in get prices.');
            }
        } else {
            throw new CHttpException(403, 'error in get prices.');
        }
    }

    public function actionUpdateFailed()
    {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $workorderDtlID = $_POST['id'];
            $fieldname = $_POST['field'];
            $value = $_POST['value'];
            $workorderDtl = Workorderdetails::model()->findByPk($workorderDtlID);

            $attrLabels = $workorderDtl->attributeLabels();
            $attrLabelName = $attrLabels[$fieldname];

            $sodtl = $workorderDtl->productsku . ' ' . $workorderDtl->prdsrtdesc . ' - ' . $workorderDtl->decprtnam . ' - ' . $workorderDtl->decdesc . ' X Qty : ' . $workorderDtl->prodQty;

            $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $workorderDtl->workorder->id));
            $link = CHtml::link($workorderDtl->workorder->salesorderNumber, $url, array('target' => '_blank'));
            $commentlog = "Update Failed : [{$link}] [{$sodtl}]  with value [{$value}] for field [{$attrLabelName}] (Please ignore if updated)";
            SalesLog::createSalesLog($workorderDtl->workorder->quotationId, $workorderDtl->workorder->id, $workorderDtl->workorder->quotationNumber, 'Quotation', $commentlog, 1, 0, 1);
            $job = Jobs::model()->find(array('condition' => "workorder_id = '{$workorderDtl->workorder->id}'"));
            if (!empty($job)) {
                SalesLog::createSalesLog($job->quote_id, $workorderDtl->workorder->id, $job->quoteNum, 'Job', $commentlog, 1, 0, 1);
            }
        }
    }

    public function actionCalSellPriceExGST()
    {

        $id = $_POST['id'];
        $qty = $_POST['qty'];
        $qtyPriceOption = $_POST['qtyPriceOption']; //Use the cost price entered = 1, Look up the current cost price = 2
        $result = array();

        if ($qty) {

            $model = $this->loadModel($id);
            $product = $model->product;
            $arr = array();
            $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
            if (empty($roundingPrecision)) {
                $roundingPrecision = 2;
            }


            $itmQty = $qty;
            //if qtyPriceOption equal 2 then Look up the current cost price
            if (in_array($qtyPriceOption, array(2))) {
                $prodPriceModel = ProductPrice::model()->find(array('condition' => "pdppdlsno = '{$product->pdlsno}' and (pdpquantity <= $itmQty and pdpsquantity >= $itmQty)", 'order' => 'pdpquantity_break_level'));
                if ($prodPriceModel) {
                    $model->prodCostPrice = $prodPriceModel->pdpprice;
                }
            }

            $prodCostPrice = round($model->prodCostPrice, $roundingPrecision);
            $prodMarkupRate = $model->prod_supmarg;
            if (!$prodMarkupRate) {
                $prodMarkupRate = $model->prodSupp->supmrate;
            }
            $prodMarkedUpPrice = $prodMarkupRate ? ($prodCostPrice * $prodMarkupRate) : $prodCostPrice;
            $prodDiscPercntg = $model->prod_discount_pcntg;
            $prodDiscRate = round(($prodDiscPercntg / 100), strlen($prodDiscPercntg));
            $prodDiscountedPrice = $prodDiscRate ? ($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)) : $prodMarkedUpPrice;
            $usdFreight = $model->prod_usd_freight;

            //new freght mark-ups 2018-10-10
            $usdFreghtUnitCost = round(($usdFreight / $itmQty), $roundingPrecision);
            $usdFreghtUnitMarkUpRate = $model->productFrieghtMarkUpRate ?: 1;
            $productFrieghtUnitCostWithMarkup = round(($usdFreghtUnitCost * $usdFreghtUnitMarkUpRate), $roundingPrecision);



            $prodUsdFreigtedPrice = $prodDiscountedPrice + round($productFrieghtUnitCostWithMarkup, $roundingPrecision);
            $otherCostTotal = $model->other_cost;
            $otherCostMarkupRate = $model->other_cost_markup_rate;

            $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? round(($otherCostTotal * $otherCostMarkupRate), $roundingPrecision) : $otherCostTotal;

            $freightRate = $model->system_freight;

            $decorationTotal = 0;

            foreach ($model->rel_multi_deco() as $data) {

                $decoCalArr = $data->getDecorationCalculations(
                    array(
                        'cost_price' => $data->cost_price,
                        'sup_margin' => $data->sup_margin,
                        'logo_setup' => $data->logo_setup,
                        'quantity' => $qty,
                        'logo_setup_markup_rate' => $data->logo_setup_markup_rate
                    )
                );

                $data->quantity = $qty;
                $data->sup_markedup_price = $decoCalArr['sup_markedup_price'];
                $data->logo_setup_unit_price = $decoCalArr['logo_setup_unit_price'];
                $data->logo_setup_unit_markedup_price = $decoCalArr['logo_setup_unit_markedup_price'];
                $data->save(false);

                $decorationTotal += $decoCalArr['sup_markedup_price'] + $decoCalArr['logo_setup_unit_markedup_price'];
            }

            if ($model->lockSellPrice) {
                $t = $model->sellPriceExVat - ($decorationTotal + $otherCostMarkedUpPrice); //total product price
                $mk_d = $t - ($usdFreight ? (round(($usdFreight / $qty), $roundingPrecision) * $usdFreghtUnitMarkUpRate) : 0); // marked up + discount without usd freight cost

                /*
                 * Equation to find product cost price
                 * c = product cost price
                 * m = product cost marked up price + discount
                 * r = product cost  marked up rate
                 * d = discount percentage
                 * 
                 * c = m * 100 / r * (100 - d) 
                 * 
                 * Equation for product markup rate
                 * 
                 * r = ( ( m * 100 ) / c) / (100 - d)
                 */

                $prodcutCostMarkUpRate = round(((round((($mk_d * 100) / $prodCostPrice), 2)) / (100 - $prodDiscPercntg)), 4);
                $productCostMarkupPercentage = $this->getMarginOutOfMarkupMultiplier($prodcutCostMarkUpRate);


                $model->prod_supmarg = $prodcutCostMarkUpRate;
                $model->supmargPercentage = $productCostMarkupPercentage;
            } else {



                $subTotal = $prodUsdFreigtedPrice + $otherCostMarkedUpPrice + $decorationTotal;
                $subTotalWithSetup = $subTotal;

                if (!$freightRate) {
                    $freightRate = floatval(GlobalVars::get("SystemFreight"));
                }

                $model->sellPriceExVat = $freightRate ? round(($subTotalWithSetup * $freightRate), $roundingPrecision) : $subTotalWithSetup;

                $GST = GlobalVars::get(GlobalVars::GST);
                $model->sellPriceIncVat = $model->sellPriceExVat * $GST;
            }

            $model->prodQty = $qty;
            $model->decoQty = $qty;

            $model->totExVat = round(($model->sellPriceExVat * $qty), $roundingPrecision);
            $model->totIncVat = round(($model->sellPriceIncVat * $qty), $roundingPrecision);

            $model->productFrieghtUnitCost = $usdFreghtUnitCost;
            $model->productFrieghtUnitCostWithMarkup = $productFrieghtUnitCostWithMarkup;




            if ($model->save(false)) {

                //update job product, job decoration and job product-decoration tables for qty
                $this->updateJobQty($model);

                $result['success'] = true;
                $result['sellPriceExGST'] = $model->sellPriceExVat;
                $result['sellPriceIncVat'] = $model->sellPriceIncVat;
                $result['totExVat'] = $model->totExVat;
                $result['totIncVat'] = $model->totIncVat;
                $result['quantity'] = $qty;
            }
        } else {
            $result['success'] = false;
            $result['message'] = 'Quantity does not changed!';
        }

        echo json_encode($result);
    }

    private function updateJobQty($workorderDetail)
    {
        $jobproduct = JobProducts::model()->find(array('condition' => "workorderDtl_id = '{$workorderDetail->id}'"));
        if ($jobproduct) {
            $jobproduct->qty = $workorderDetail->prodQty;
            $jobproduct->save(false);
        }


        //        $jobdecoration = JobDecorations::model()->find(array('condition' => "workorderDtl_id = '{$workorderDetail->id}'"));
        //        if (!empty($jobdecoration)) {
        //            $jobdecoration->decoQty = $workorderDetail->decoQty;
        //            $jobdecoration->save(false);
        //        }
        //JobDecorations::model()->updateAll(array('decdesc' => $model->decdesc), "workorderDtl_id = '{$model->id}' and decprtnam = '{$model->decprtnam}'");
        //        $jobProductDecoration = JobProductDecorations::model()->find(array('condition' => "workorderDtl_id = '{$workorderDetail->id}'"));
        //        if (!empty($jobProductDecoration)) {
        //            $jobProductDecoration->decoQty = $workorderDetail->decoQty;
        //            $jobProductDecoration->save(false);
        //        }

        $invoicedetail = InvoiceDetail::model()->find(array("condition" => "workorder_id = $workorderDetail->workorderId and wrkorderDtl_id = $workorderDetail->id"));
        if ($invoicedetail) {
            $invoicedetail->qty = $workorderDetail->prodQty;
            $invoicedetail->sellPriceExVat = $workorderDetail->sellPriceExVat;
            $invoicedetail->sellPriceIncVat = $workorderDetail->sellPriceIncVat;
            $invoicedetail->totExVat = $workorderDetail->totExVat;
            $invoicedetail->totIncVat = $workorderDetail->totIncVat;
            if ($invoicedetail->save(false)) {
                $invoicedetail->rel_model()->refreshTotal();
            }
        }
    }

    private function getSupplierMargin($model)
    {
        $prodCost = $model->prodCostPrice;
        $decoCost = $model->decoCostPrice;
        $sellPriceExGST = $model->sellPriceExVat;
        $totalCost = $prodCost + $decoCost;

        $suppmarg = 0;
        if (!empty($totalCost)) {
            $suppmarg = $sellPriceExGST / $totalCost;
        }


        return $suppmarg;
    }

    public function actionFetchCostPriceByQty()
    {
        $qty = $_POST['qty'];
        $pdslno = $_POST['pdslno'];
        $decsno = $_POST['decsno'];
        $pricesArr = array();
        $pricesArr['prdCostPrice'] = 0;
        $pricesArr['decoCostPrice'] = 0;
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (!empty($pdslno)) {
            $product = ProductLine::model()->findByPk($pdslno);
            $prodPriceModel = ProductPrice::model()->find(array('condition' => "pdppdlsno = '{$pdslno}' and (pdpquantity <= $qty and pdpsquantity >= $qty)", 'order' => 'pdpquantity_break_level'));
            if (!empty($product) && !empty($prodPriceModel)) {
                $pricesArr['prdCostPrice'] = round($prodPriceModel->pdpprice, $roundingPrecision);
            } else if (!empty($product)) {
                $pricesArr['prdCostPrice'] = round($product->pdluntprice, $roundingPrecision);
            } else {
                $pricesArr['prdCostPrice'] = 0;
            }
        }

        if (!empty($decsno)) {
            $decoration = Decoration::model()->findByPk($decsno);
            $decoPriceModel = DecorationPrice::model()->find(array('condition' => "dcpdecsno = '{$decsno}' and (dcpquantity <= $qty and dcpsquantity >= $qty)", 'order' => 'dcpquantity_break_level'));
            if (!empty($decoration) && !empty($decoPriceModel)) {
                $pricesArr['decoCostPrice'] = round($decoPriceModel->dcpprice, $roundingPrecision);
            } else if (!empty($decoration)) {
                $pricesArr['decoCostPrice'] = round($decoration->decuntprice, $roundingPrecision);
            } else {
                $pricesArr['decoCostPrice'] = 0;
            }
        }

        echo json_encode($pricesArr);
    }

    public function actionCalculateFullTotal()
    {
        $id = $_POST['id'];
        $type = $_POST['type'];
        $workorder = null;
        if ($type == 'DTL') {
            $model = $this->loadModel($id);
            $workorder = $model->workorder;
        } else if ($type == 'MDL') {
            $workorder = Workorder::model()->findByPk($id);
        }



        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        $subTotal = PriceCalculator::getSubTotal($workorder);
        $subTotalWithSurcharge = $workorder->surcharge_rate ? ($subTotal * $workorder->surcharge_rate) : $subTotal;
        $gstTotal = round(PriceCalculator::getGSTTotal($workorder), $roundingPrecision);
        $totamtarr = array();
        $totamtarr['subTotal'] = number_format($subTotal, $roundingPrecision);
        $totamtarr['subTotalWithSurcharge'] = number_format($subTotalWithSurcharge, $roundingPrecision);
        $totamtarr['gstTotal'] = number_format($gstTotal, $roundingPrecision);
        $totamtarr['total'] = number_format(($subTotalWithSurcharge + $gstTotal), $roundingPrecision);
        //$totamtarr['amtTotExGST'] = round($amtTotExGST, $roundingPrecision);
        //$totamtarr['amtTotIncGST'] = round($amtTotIncGST, $roundingPrecision);

        echo json_encode($totamtarr);
    }

    public function actionDoPricePlayingCal()
    {

        $arr = array();
        $arr['error_message'] = "";

        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }

        $prodCostPrice = floatval($_POST['af_edit_cost_price']);
        $prodMarkupRate = floatval($_POST['af_edit_prd_markup']);
        $prodDiscPercntg = floatval($_POST['af_discount_percntg']);
        $usdFreight = floatval($_POST['af_usd_freight']);
        $usdFreightMarkUpRate = floatval($_POST['af_usd_freight_markup_rate']);
        $lockSellPrice = isset($_POST['aFLockSellPrice']) ? intval($_POST['aFLockSellPrice']) : 0;
        $afEditSubTotalWithSetup = floatval($_POST['af_edit_subtotal_with_setup']);




        $itmQty = intval($_POST['af_edit_itm_qty']) ? intval($_POST['af_edit_itm_qty']) : 0;


        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;

        $decoCostPrice = 0;
        if (isset($_POST['WorkorderDetailsDecoration'])) {
            $editedLineArr = $_POST['WorkorderDetailsDecoration'];
            foreach ($editedLineArr as $key => $value) {

                $workOrderDeco = WorkorderDetailsDecoration::model()->findByPk($key);
                $decoCalArr = $workOrderDeco->getDecorationCalculations(
                    array(
                        'cost_price' => $value['cost_price'],
                        'sup_margin' => $value['sup_margin'],
                        'logo_setup' => $value['logo_setup'],
                        'quantity' => $itmQty,
                        'logo_setup_markup_rate' => $value['logo_setup_markup_rate']
                    )
                );


                $arr['multiDecoLines'][] = array(
                    "WorkorderDetailsDecoration[$key][sup_markedup_price]" => $decoCalArr['sup_markedup_price'],
                    "WorkorderDetailsDecoration[$key][logo_setup_unit_price]" => $decoCalArr['logo_setup_unit_price'],
                    "WorkorderDetailsDecoration[$key][logo_setup_unit_markedup_price]" => $decoCalArr['logo_setup_unit_markedup_price'],
                );

                $decoCostPrice += $value['cost_price'] + $decoCalArr['logo_setup_unit_price'];
                $totalDecoSupMarginMarkupPrice += $decoCalArr['sup_markedup_price'];
                $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logo_setup_unit_markedup_price'];
            }
        }



        $freightRate = floatval($_POST['af_freight_rate']);

        $otherCostTotal = floatval($_POST['af_edit_othercost_total']);
        $otherCostMarkupRate = floatval($_POST['af_edit_othercost_markup_rate']);





        $prodMarkedUpPrice = $prodMarkupRate ? round(($prodCostPrice * $prodMarkupRate), $roundingPrecision) : $prodCostPrice;

        /** lock sell price calculations */
        if ($lockSellPrice && $afEditSubTotalWithSetup) {

            $prodMarkupRate = $prodCostPrice ? round(($afEditSubTotalWithSetup / $prodCostPrice), 4) : 0;

            $prodMarkedUpPrice = round(($prodCostPrice * $prodMarkupRate), 2);
        }

        /** End - lock sell price calculations */
        $prodDiscRate = round(($prodDiscPercntg / 100), strlen($prodDiscPercntg));
        $prodDiscountedPrice = $prodDiscRate ? round(($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)), $roundingPrecision) : $prodMarkedUpPrice;

        $usdFreightUnitCost = round(($usdFreight / $itmQty), $roundingPrecision);
        $usdFreightUnitCostWithMarkedUp = $usdFreightUnitCost * $usdFreightMarkUpRate;

        $prodUsdFreightedPrice = $prodDiscountedPrice + round(($usdFreightUnitCostWithMarkedUp), $roundingPrecision);






        $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? round(($otherCostTotal * $otherCostMarkupRate), $roundingPrecision) : $otherCostTotal;


        $subTotal = $prodUsdFreightedPrice + $otherCostMarkedUpPrice + ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice);
        $subTotalWithSetup = $subTotal;


        $total = $freightRate ? round(($subTotalWithSetup * $freightRate), $roundingPrecision) : $subTotalWithSetup;

        $grossProfit = $total - ($prodCostPrice + $usdFreightUnitCost + $decoCostPrice + $otherCostTotal);
        $grossProfitPercentage = $total ? round(($grossProfit / $total) * 100, 2) : 0;


        //new freight values 2018-10-10
        $arr['lockSellPrice'] = $lockSellPrice;
        $arr['prodCostPrice'] = $prodCostPrice;
        $arr['prodMarkupRate'] = $prodMarkupRate;
        $arr['usdFreightUnitCost'] = $usdFreightUnitCost;
        $arr['usdFreightUnitCostWithMarkedUp'] = $usdFreightUnitCostWithMarkedUp;


        $arr['prodDiscountedPrice'] = $prodDiscountedPrice;
        $arr['prodUsdFreightedPrice'] = $prodUsdFreightedPrice;

        $arr['otherCostMarkedUpPrice'] = $otherCostMarkedUpPrice;

        $arr['subTotal'] = $subTotal;
        $arr['subTotalWithSetup'] = $subTotalWithSetup;
        $arr['total'] = $total;

        $arr['totalDecoSupMarginMarkupPrice'] = $totalDecoSupMarginMarkupPrice;
        $arr['totalDecoLogosetupUnitMarkupPrice'] = $totalDecoLogosetupUnitMarkupPrice;
        $arr['decorationTotal'] = ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice);

        $arr['totalCostPrice'] = ($prodCostPrice + $usdFreightUnitCost + $decoCostPrice + $otherCostTotal);
        $arr['grossProfitPercentage'] = $grossProfitPercentage;
        $arr['grossProfit'] = $grossProfit;
        $arr['totalGrossProfit'] = $grossProfit * $itmQty;




        echo json_encode($arr);
    }

    public function actionCloneLineByQuantity()
    {
        $id = $_POST['quoteDetailId'];
        $quantity = $_POST['quantity'];
        $model = $this->loadModel($id);
        $cloneModel = new Workorderdetails();
        $cloneModel->attributes = $model->attributes;
        $cloneModel->id = null;
        $cloneModel->prodQty = $quantity;
        $cloneModel->decoQty = $quantity;
        if ($allsaved = $cloneModel->save(false)) {


            $decorations = $model->rel_multi_deco();
            if (count($decorations)) {
                foreach ($decorations as $deco) {
                    $copyLineDecoration = new WorkorderDetailsDecoration();
                    $copyLineDecoration->attributes = $deco->attributes;
                    $copyLineDecoration->quantity = $quantity;
                    $copyLineDecoration->workorder_detail_id = $cloneModel->id;
                    unset($copyLineDecoration->id);
                    $allsaved = $copyLineDecoration->save();
                }
            }

            $sizeQtyColours = $model->rel_size_qty_colors();
            if (count($sizeQtyColours)) {
                foreach ($sizeQtyColours as $sizeqtycol) {
                    $copyLineSizeQtyColour = new Workorderdetailssizecolor();
                    $copyLineSizeQtyColour->attributes = $sizeqtycol->attributes;
                    $copyLineSizeQtyColour->workOrderDetailsId = $cloneModel->id;
                    unset($copyLineSizeQtyColour->id);
                    $allsaved = $copyLineSizeQtyColour->save();
                }
            }

            $otherCosts = $model->rel_other_costs();
            if (count($otherCosts)) {
                foreach ($otherCosts as $cost) {
                    $copyLineOtherCost = new WorkorderOtherCost();
                    $copyLineOtherCost->attributes = $cost->attributes;
                    $copyLineOtherCost->workorder_detail_id = $cloneModel->id;
                    unset($copyLineOtherCost->id);
                    $allsaved = $copyLineOtherCost->save();
                }
            }

            if ($allsaved) {
                $cloneModel->recalculateLinePrice();
                echo json_encode(array(
                    'status' => 'success',
                    'newLineId' => $cloneModel->id,
                    'quantity' => $cloneModel->prodQty,
                    'newLineHTML' => $cloneModel->getHtmlRow()
                ));
            }
        }
    }

    public function actionUpdateDetailsPricesByTotExGST()
    {
        $id = $_POST['id'];

        $wokroderDetail = Workorderdetails::model()->findByPk($id);

        if (!$wokroderDetail) {
            throw new Exception('Item not found!', 404);
        }

        $job = Jobs::model()->find(array('condition' => "workorder_id = {$wokroderDetail->workorderId}"));

        $prodCostPrice = $_POST['af_edit_cost_price'];
        $prodMarkupRate = $_POST['af_edit_prd_markup'];
        $prodMarkupPercentage = $_POST['af_edit_prd_markup_percentage'];
        $prodDiscPercntg = $_POST['af_discount_percntg'];
        $prodUsdFreight = $_POST['af_usd_freight'];

        //new freight mark-up values 2018-10-10
        $prodUsdFreightMarkupRate = $_POST['af_usd_freight_markup_rate'];
        $prodUsdFreightMarkupPercentage = $_POST['af_usd_freight_markup_percentage'];
        $prodUsdFreightUnitCost = $_POST['af_usd_freight_unit_cost'];
        $prodUsdFreightUnitMarkedupPrice = $_POST['af_usd_freight_unit_markedup_price'];

        $itmQty = $_POST['af_edit_itm_qty'] ?: 0;
        $freightRate = $_POST['af_freight_rate'];
        $freightPercentage = $_POST['af_freight_percentage'];
        $total = $_POST['af_edit_total'];
        $othercostArr = isset($_POST['othercost']) ? $_POST['othercost'] : null;
        $othercostIdArr = isset($_POST['othercostid']) ? $_POST['othercostid'] : null;
        $otherCostTotal = $_POST['af_edit_othercost_total'];
        $otherCostMarkupRate = floatval($_POST['af_edit_othercost_markup_rate']);
        $otherCostMarkupPercentage = floatval($_POST['af_edit_othercost_markup_percentage']);

        $lineTaxRateId = $_POST['af_edit_tax_rate_id']; //system tax code
        $systemTaxRate = SystemTaxCode::model()->findByPk($lineTaxRateId);


        if (isset($_POST['WorkorderDetailsDecoration'])) {
            $editedLineArr = $_POST['WorkorderDetailsDecoration'];
            foreach ($editedLineArr as $key => $attrArr) {

                $workOrderDeco = WorkorderDetailsDecoration::model()->findByPk($key);
                foreach ($attrArr as $field => $value) {
                    $workOrderDeco->$field = $value;
                }
                $workOrderDeco->quantity = $itmQty;
                if ($workOrderDeco->save(false)) {

                    if ($job) {
                        $jobdeco = JobDecorations::model()->find(array('condition' => "work_order_detail_decoration_id = {$workOrderDeco->id} AND workorderDtl_id = {$workOrderDeco->workorder_detail_id} AND decprtnam = '{$workOrderDeco->decprtnam}'"));

                        if ($jobdeco) {
                            $jobdeco->decoQty = $workOrderDeco->quantity;
                            $jobdeco->qty = $workOrderDeco->quantity;
                            $jobdeco->decoCostPrice = $workOrderDeco->cost_price;
                            $jobdeco->save(false);
                        }


                        $jobproductdeco = JobProductDecorations::model()->find(array('condition' => "work_order_detail_decoration_id = {$workOrderDeco->id} AND workorderDtl_id = {$workOrderDeco->workorder_detail_id} AND decprtnam = '{$workOrderDeco->decprtnam}'"));
                        if ($jobproductdeco) {
                            $jobproductdeco->decoQty = $workOrderDeco->quantity;
                            $jobproductdeco->qty = $workOrderDeco->quantity;
                            $jobproductdeco->decoCostPrice = $workOrderDeco->cost_price;
                            $jobproductdeco->logo_setup = $workOrderDeco->logo_setup;
                            $jobproductdeco->save(false);
                        }
                    }
                }
            }
        }

        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        $pricesarr = array();
        $model = $this->loadModel($id);
        $oldAtttributes = $model->attributes;
        $GST = GlobalVars::get(GlobalVars::GST);
        $sellPriceIncGST = $systemTaxRate ? ($total * $systemTaxRate->rate) : ($total * $GST);


        $model->prodCostPrice = $prodCostPrice;

        $model->prodQty = $itmQty;
        $model->decoQty = $itmQty;
        $model->prod_discount_pcntg = $prodDiscPercntg;
        $model->prod_supmarg = $prodMarkupRate;
        $model->supmargPercentage = $prodMarkupPercentage;


        $model->prod_usd_freight = $prodUsdFreight;
        $model->system_freight = $freightRate;
        $model->systemFreightPercentage = $freightPercentage;
        $model->sellPriceExVat = $total;
        $model->sellPriceIncVat = $sellPriceIncGST;
        $model->totExVat = $model->sellPriceExVat * $itmQty;
        $model->totIncVat = $model->sellPriceIncVat * $itmQty;
        $model->other_cost = $otherCostTotal;
        $model->other_cost_markup_rate = $otherCostMarkupRate;
        $model->otherCostMarkupPercentage = $otherCostMarkupPercentage;

        //new freight mark-up values
        $model->productFrieghtUnitCost = $prodUsdFreightUnitCost;
        $model->productFrieghtMarkUpRate = $prodUsdFreightMarkupRate;
        $model->productFrieghtMarkUpPercentage = $prodUsdFreightMarkupPercentage;
        $model->productFrieghtUnitCostWithMarkup = $prodUsdFreightUnitMarkedupPrice;
        $model->lockSellPrice = isset($_POST['aFLockSellPrice']) ? intval($_POST['aFLockSellPrice']) : 0;

        $model->systemTaxRateId = ($systemTaxRate ? $systemTaxRate->id : null);


        if ($job) {
            $jobproduct = JobProducts::model()->find(array('condition' => "workorderDtl_id = '{$id}'"));
            if (!empty($jobproduct)) {
                $jobproduct->prodCostPrice = $prodCostPrice;
                $jobproduct->qty = $itmQty;
                $jobproduct->save(false);
            }
        }



        $pricesarr['sellPriceExVat'] = number_format($model->sellPriceExVat, $roundingPrecision);
        $pricesarr['sellPriceIncVat'] = number_format($model->sellPriceIncVat, $roundingPrecision);
        $pricesarr['totExVat'] = number_format($model->totExVat, $roundingPrecision);
        $pricesarr['totIncVat'] = number_format($model->totIncVat, $roundingPrecision);
        $pricesarr['quantity'] = $itmQty;

        if ($model->save()) {

            $modifeidArrWithLabel = AttributeCompare::compare($model->attributes, $oldAtttributes, $model->attributeLabels());


            $oldArrWithLabel = AttributeCompare::compare($oldAtttributes, $model->attributes, $model->attributeLabels());

            if ($modifeidArrWithLabel) {

                SalesLog::jsonLog(
                    array(
                        'quoteId' => $model->workorder->quotationId,
                        'workorderId' => $model->workorder->id,
                        'quoteNum' => $model->workorder->quotationNumber,
                        'category' => 'SalesOrder',
                        'comments' => 'Item prices [' . $model->productsku . ' - ' . $model->prdsrtdesc . '] have been updated <br /> From ' . json_encode($oldArrWithLabel) . ' <br /> To ' . json_encode($modifeidArrWithLabel),
                        'json_record' => json_encode(array('old' => $oldAtttributes, 'new' => $model->attributes)),
                        'isIntrnl' => 1,
                        'isExtrnl' => 1,
                        'isTechnical' => 1
                    )
                );
            }

            if ($othercostIdArr && count($othercostIdArr) > 0) {
                $workOrderOtherCosts = WorkorderOtherCost::model()->find(array('condition' => "workorder_detail_id = $id"));

                foreach ($othercostIdArr as $key => $value) {
                    $workOrderOtherCost = WorkorderOtherCost::model()->find(array('condition' => "workorder_detail_id = $id and other_cost_id = $value"));
                    if ($workOrderOtherCost) {
                        $workOrderOtherCost->cost = $othercostArr[$key];
                        $workOrderOtherCost->save();
                    } else {
                        $workOrderOtherCost = new WorkorderOtherCost();
                        $workOrderOtherCost->workorder_id = $model->workorderId;
                        $workOrderOtherCost->workorder_detail_id = $id;
                        $workOrderOtherCost->other_cost_id = $value;
                        $workOrderOtherCost->cost = $othercostArr[$key];
                        $workOrderOtherCost->created_by = Yii::app()->user->id;
                        $workOrderOtherCost->created_date = date('Y-m-d');
                        $workOrderOtherCost->save();
                    }

                    if ($job) {
                        $otherCostType = OtherCostType::model()->findByPk($value);
                        $otherCostGroup = OtherCostGroup::model()->findByPk($otherCostType->other_cost_group_id);
                        //job other cost
                        $jobProductOtherCost = JobProductOtherCost::model()->find(array('condition' => "workorder_detail_id = {$id} AND other_cost_id = {$value}"));
                        if ($jobProductOtherCost) {
                            $jobProductOtherCost->cost_price = $workOrderOtherCost->cost;
                            $jobProductOtherCost->other_cost_group_id = $otherCostGroup ? $otherCostGroup->id : null;
                            $jobProductOtherCost->other_cost_group_name =  $otherCostGroup ? $otherCostGroup->name : null;
                            $jobProductOtherCost->save();
                        } else {
                            $jobProductOtherCost = new JobProductOtherCost();
                            $jobProductOtherCost->job_id = $job->id;
                            $jobProductOtherCost->workorder_detail_id = $id;
                            $jobProductOtherCost->workorder_id = $wokroderDetail->workorderId;
                            $jobProductOtherCost->other_cost_type_id = $value;
                            $jobProductOtherCost->other_cost_id = $value;
                            $jobProductOtherCost->other_cost_group_id = $otherCostGroup ? $otherCostGroup->id : null;
                            $jobProductOtherCost->other_cost_group_name =  $otherCostGroup ? $otherCostGroup->name : null;
                            $jobProductOtherCost->other_cost_name = $otherCostType->name;
                            $jobProductOtherCost->is_qty_based = $otherCostType->devide_by_qty;
                            $jobProductOtherCost->cost_price = $workOrderOtherCost->cost;
                            $jobProductOtherCost->quantity = $itmQty;
                            $jobProductOtherCost->workorder_other_cost_id = $workOrderOtherCost->id;
                            $jobProductOtherCost->save();
                        }
                    }
                }

                //delete other cost and

                $workOrderOtherCosts = WorkorderOtherCost::model()->findAll(array('condition' => "workorder_detail_id = $id"));

                foreach ($workOrderOtherCosts as $data) {

                    if (!in_array($data->other_cost_id, $othercostIdArr)) {

                        $jobProductOtherCost = JobProductOtherCost::model()->find(array('condition' => "workorder_detail_id = {$id} AND other_cost_id = {$data->other_cost_id}"));
                        if (!$jobProductOtherCost) {
                            $data->delete();
                        }

                        if ($jobProductOtherCost && !$jobProductOtherCost->po_id) {
                            $jobProductOtherCost->delete();
                            $data->delete();
                        }
                    }
                }
            } else {

                $jobProductOtherCosts = JobProductOtherCost::model()->findAll(array('condition' => "workorder_detail_id = {$id}"));

                if(count($jobProductOtherCosts)) {
                    foreach($jobProductOtherCosts as $jpoc) {
                        if(!$jpoc->po_id) {
                            $wooc = WorkorderOtherCost::model()->findByPk($jpoc->workorder_other_cost_id);
                            if($wooc) {
                                $wooc->delete();
                            }
                        }
                    }
                } else {
                    $criteria = new CDbCriteria;
                    $criteria->addCondition("workorder_detail_id = $id");
                    WorkorderOtherCost::model()->deleteAll($criteria);
                }
                
            }

            //update purchase orders qty, if available
            $poSQL = "UPDATE purchase_order_details SET qty = $itmQty WHERE workorderDtl_id = $id";
            $poComnd = Yii::app()->db->createCommand($poSQL);
            $poComnd->execute();

            $pricesarr['success'] = true;
        } else {
            $pricesarr['success'] = false;
        }

        echo json_encode($pricesarr);
    }

    public function actionEditMultiDeco()
    {
        $id = $_POST['workOrderDetailID'];

        echo json_encode(array('html' => $this->getEditMultiDecoHtml($id)));
    }

    private function getEditMultiDecoHtml($id)
    {
        $workorderDecoDetails = WorkorderDetailsDecoration::model()->findAll(array('condition' => "workorder_detail_id = {$id}"));
        $html = "<table style='width=100%;'>";
        $html .= "<tr style='width=100%;background-color:#ccc;'><th style='width=20%;text-align:center;'>Code</th><th style='width=45%;text-align:center;'>Description</th><th style='width=25%;text-align:center;'>Unit Cost</th><th style='width=10%;text-align:center;'>&nbsp;</th></tr>";
        $html .= "<tr style='width=100%;display:none;'><td colspan='4'><input type='hidden' name='workOrderDetailID' value='{$id}'/></td></tr>";
        foreach ($workorderDecoDetails as $data) {
            $supplierHtml = $data->supRel ? $data->supRel->getSupplierLink() : '';
            if (!$supplierHtml) {
                //set default supplier from decoration table
                $supplierHtml = ($data->decoRel ? $data->decoRel->getSupplierLink() : '');
            }
            $html .= "<tr id='editmultidecotr_{$data->id}' style='width=100%;border-bottom:1px solid #ccc;'>"
                . "<td colspan='3'>"
                . "<table style='width=100%;'>"
                . "<tr style='width=100%;'>"
                . "<td>{$data->decprtnam}</td>"
                . "<td>"
                . "<input style='width=200px;' type='text' name='WorkorderDetailsDecoration[{$data->id}][decdesc]' value='{$data->decdesc}'/><br>"
                . $supplierHtml
                . "</td>"
                . "<td><input style='width=120px;text-align:center;' type='text' name='WorkorderDetailsDecoration[{$data->id}][cost_price]' value='{$data->cost_price}'/></td>"
                . "</tr>"
                . "<tr style='width=100%;'>"
                . "<td>Logo Setup</td>"
                . "<td><input class='editdeco-logosetupcharge' data-attr='{$data->id}' style='width=200px;' type='text' name='WorkorderDetailsDecoration[{$data->id}][logo_setup]' value='{$data->logo_setup}'/></td>"
                . "<td><input class='editdeco-logosetup-unit' data-attr='{$data->id}' style='width=120px;text-align:center;' type='text' name='WorkorderDetailsDecoration[{$data->id}][logo_setup_unit_price]' value='{$data->logo_setup_unit_price}' readonly='true'/></td>"
                . "</tr>"
                . "<tr style='width=100%;'>"
                . "<td colspan='3'>"
                . "<table style='width=100%;'>"
                . "<tr style='width=100%;'>"
                . "<th style='text-align:center;'>Customisation Details</th>"
                . "</tr>"
                . "<tr style='width=100%;'>"
                . "<td><textarea style='width:95%;' rows='1'  name='WorkorderDetailsDecoration[{$data->id}][customization_detail]'>{$data->customization_detail}</textarea></td>"
                . "</tr>"
                . "</table>"
                . "</td>"
                . "</tr>"
                . "</table>"
                . "</td>"
                . "<td>"
                . "<table style='width: 100%;cursor: pointer;font-size:8pt;' onclick='deleteMultiDecoItem({$data->id});return false;'>
					<tr>
						<td style='width: 30%;'><span class='sodtlicon fa fa-trash-o'></span></td>
						<td>Delete Item</td>
					</tr>
					</table>
			  </td>"
                . "</tr>";



            //            $html .= "<td>{$data->decprtnam}</td>";
            //            $html .= "<td><input style='width=200px;' type='text' name='WorkorderDetailsDecoration[{$data->id}][decdesc]' value='{$data->decdesc}'/></td>";
            //            $html .= "<td><input style='width=120px;text-align:center;' type='text' name='WorkorderDetailsDecoration[{$data->id}][cost_price]' value='{$data->cost_price}'/></td>";
            //            $html .= "<td><a href='' onclick='deleteMultiDecoItem({$data->id});return false;'>Delete</a></td>";
            //$html .= "</tr>";
        }

        $html .= "</table>";

        return $html;
    }

    public function actionSaveEditMultiDeco()
    {
        // $quoteProductDecoDetails = QuoteProductDecoration::model()->findAll(array('condition' => "quataiondetailsid = {$_POST['quoteDetailID']}"));

        $workOrderDetail = Workorderdetails::model()->findByPk($_POST['workOrderDetailID']);

        if (isset($_POST['WorkorderDetailsDecoration'])) {
            $editedLineArr = $_POST['WorkorderDetailsDecoration'];
            //existing ids
            $existIds = array_keys($editedLineArr);

            $criteria = new CDbCriteria;
            $criteria->addCondition("workorder_detail_id = {$_POST['workOrderDetailID']}");

            $criteria->addNotInCondition('id', $existIds);

            //find not exsitsing ids related to the above workorder_detail_id
            $decorationsToBeDeleted = WorkorderDetailsDecoration::model()->findAll($criteria);



            foreach ($decorationsToBeDeleted as $wdd) {
                if (UsageChecker::workorderDecorationInUse($wdd->id)) {
                    throw new Exception('Cannot delete items! some items are in use!', 400);
                }
            }

            //delete not exsitsing ids related to the above workorder_detail_id
            foreach ($decorationsToBeDeleted as $wdd) {
                if ($jpd = JobProductDecorations::model()->find("work_order_detail_decoration_id = $wdd->id")) {
                    $jpd->delete();
                }

                if ($jd = JobDecorations::model()->find("work_order_detail_decoration_id = $wdd->id")) {
                    $jd->delete();
                }
            }
            WorkorderDetailsDecoration::model()->deleteAll($criteria);






            foreach ($editedLineArr as $key => $dtlline) {
                $workOrderDecoDetail = WorkorderDetailsDecoration::model()->findByPk($key);
                $jobProductDecoration = JobProductDecorations::model()->find("work_order_detail_decoration_id = $key");
                $jobDecoration = JobDecorations::model()->find("work_order_detail_decoration_id = $key");

                $job = Jobs::model()->find(" workorder_id = {$workOrderDetail->workorder->id}");

                if (!$jobDecoration) {
                    $job_decoration = new JobDecorations();
                    $job_decoration->lineOrder = $workOrderDetail->lineOrder;
                    $job_decoration->job_id = $job->id;
                    $job_decoration->workorderDtl_id = $workOrderDetail->id;
                    $job_decoration->decprtnam = $workOrderDecoDetail->decprtnam;
                    $job_decoration->decdesc = $workOrderDecoDetail->decdesc;
                    $job_decoration->customdecoration = $workOrderDecoDetail->customdecoration;
                    $job_decoration->decoQty = $workOrderDecoDetail->quantity;
                    $job_decoration->decoCostPrice = $workOrderDecoDetail->cost_price;
                    $job_decoration->decosupref = $workOrderDecoDetail->supref;
                    $job_decoration->customizationDetails = $workOrderDecoDetail->customization_detail;
                    $job_decoration->status_id = 1; //New
                    $job_decoration->user_id = Yii::app()->user->id;
                    $job_decoration->createdDtm = date('Y-m-d H:i:s');
                    $job_decoration->work_order_detail_decoration_id = $workOrderDecoDetail->id;
                    $job_decoration->save(false);
                }

                if (!$jobProductDecoration) {
                    $job_product_decoration = new JobProductDecorations();
                    $job_product_decoration->lineOrder = $workOrderDetail->lineOrder;
                    $job_product_decoration->job_id = $job->id;
                    $job_product_decoration->workorderDtl_id = $workOrderDetail->id;
                    $job_product_decoration->decprtnam = $workOrderDecoDetail->decprtnam;
                    $job_product_decoration->decdesc = $workOrderDecoDetail->decdesc;
                    $job_product_decoration->customdecoration = $workOrderDecoDetail->customdecoration;
                    $job_product_decoration->decoQty = $workOrderDecoDetail->quantity;
                    $job_product_decoration->decoCostPrice = $workOrderDecoDetail->cost_price;
                    $job_product_decoration->decosupref = $workOrderDecoDetail->supref;
                    $job_product_decoration->customizationDetails = $workOrderDecoDetail->customization_detail;
                    $job_product_decoration->user_id = Yii::app()->user->id;
                    $job_product_decoration->status_id = 1; //New

                    $job_product_decoration->work_order_detail_decoration_id = $workOrderDecoDetail->id;

                    $job_product_decoration->save(false);
                }

                foreach ($dtlline as $field => $value) {
                    $workOrderDecoDetail->$field = $value;

                    /*
                     * Update date job details if available
                     */
                    if ($jobProductDecoration) {
                        switch ($field) {
                            case 'decdesc':
                                $jobProductDecoration->decdesc = $value;
                                break;
                            case 'cost_price':
                                $jobProductDecoration->decoCostPrice = $value;
                                break;
                            case 'customization_detail':
                                $jobProductDecoration->customizationDetails = $value;
                                break;
                        }
                    }
                    if ($jobDecoration) {
                        switch ($field) {
                            case 'decdesc':
                                $jobDecoration->decdesc = $value;
                                break;
                            case 'cost_price':
                                $jobDecoration->decoCostPrice = $value;
                                break;
                            case 'customization_detail':
                                $jobDecoration->customizationDetails = $value;
                                break;
                        }
                    }
                }

                $workOrderDecoDetail->save(false);
                if ($jobProductDecoration) {
                    $jobProductDecoration->save(false);
                }
                if ($jobDecoration) {
                    $jobDecoration->save(false);
                }
            }
        } else {
            //if just items are deleted and save comes here
            $criteria = new CDbCriteria;
            $criteria->addCondition("workorder_detail_id = {$_POST['workOrderDetailID']}");

            //find exsitsing ids related to the above workorder_detail_id
            $decorationsToBeDeleted = WorkorderDetailsDecoration::model()->findAll($criteria);



            foreach ($decorationsToBeDeleted as $wdd) {
                if (UsageChecker::workorderDecorationInUse($wdd->id)) {
                    throw new Exception('Cannot delete items! some items are in use!', 400);
                }
            }

            //delete not exsitsing ids related to the above workorder_detail_id
            foreach ($decorationsToBeDeleted as $wdd) {
                if ($jpd = JobProductDecorations::model()->find("work_order_detail_decoration_id = $wdd->id")) {
                    $jpd->delete();
                }

                if ($jd = JobDecorations::model()->find("work_order_detail_decoration_id = $wdd->id")) {
                    $jd->delete();
                }
            }
            WorkorderDetailsDecoration::model()->deleteAll($criteria);
        }

        if (isset($_POST['Decoration'])) {

            $addedDecoArr = $_POST['Decoration'];

            foreach ($addedDecoArr as $key => $decoLine) {
                $decoration = Decoration::model()->findByPk($key);

                $workorderDeco = new WorkorderDetailsDecoration();
                $workorderDeco->work_order_id = $workOrderDetail->workorderId;
                $workorderDeco->workorder_detail_id = $workOrderDetail->id;
                $workorderDeco->decoration_id = $decoration->decsno;
                $workorderDeco->decprtnam = $decoration->decprtnam;
                $workorderDeco->decdesc = $decoLine['decnam'];
                $workorderDeco->quantity = $workOrderDetail->prodQty;
                $workorderDeco->cost_price = $decoLine['decuntprice'];
                $workorderDeco->customization_detail = $decoLine['customization_detail'];


                $workorderDeco->sup_margin = $decoration->supplier ? $decoration->supplier->supmrate : null;
                $workorderDeco->logo_setup = $decoration->declogo_setup_charges;
                $workorderDeco->logo_setup_unit_price = $decoration->declogo_setup_charges ? round(($decoration->declogo_setup_charges / $workOrderDetail->prodQty), 2) : 0;
                $workorderDeco->logo_setup_markup_rate = $decoration->logoSetupUnitMarkupRate;
                $workorderDeco->logo_setup_unit_markedup_price = $workorderDeco->logo_setup_markup_rate ? ($workorderDeco->logo_setup_unit_price * $workorderDeco->logo_setup_markup_rate) : $workorderDeco->logo_setup_unit_price;

                $workorderDeco->supref = $decoration->supplier ? $decoration->supplier->supsno : null;
                $workorderDeco->created_at = date('Y-m-d');
                $workorderDeco->created_by = Yii::app()->user->id;
                if ($workorderDeco->save(false)) {

                    $job = Jobs::model()->find(" workorder_id = {$workOrderDetail->workorder->id}");

                    $job_decoration = new JobDecorations();
                    $job_decoration->lineOrder = $workOrderDetail->lineOrder;
                    $job_decoration->job_id = $job->id;
                    $job_decoration->workorderDtl_id = $workOrderDetail->id;
                    $job_decoration->decprtnam = $workorderDeco->decprtnam;
                    $job_decoration->decdesc = $workorderDeco->decdesc;
                    $job_decoration->customdecoration = $workorderDeco->customdecoration;
                    $job_decoration->decoQty = $workorderDeco->quantity;
                    $job_decoration->decoCostPrice = $workorderDeco->cost_price;
                    $job_decoration->decosupref = $workorderDeco->supref;
                    $job_decoration->customizationDetails = $workorderDeco->customization_detail;
                    $job_decoration->status_id = 1; //New
                    $job_decoration->user_id = Yii::app()->user->id;
                    $job_decoration->createdDtm = date('Y-m-d H:i:s');
                    $job_decoration->work_order_detail_decoration_id = $workorderDeco->id;
                    $job_decoration->save(false);


                    $job_product_decoration = new JobProductDecorations();
                    $job_product_decoration->lineOrder = $workOrderDetail->lineOrder;
                    $job_product_decoration->job_id = $job->id;
                    $job_product_decoration->workorderDtl_id = $workOrderDetail->id;
                    $job_product_decoration->decprtnam = $workorderDeco->decprtnam;
                    $job_product_decoration->decdesc = $workorderDeco->decdesc;
                    $job_product_decoration->customdecoration = $workorderDeco->customdecoration;
                    $job_product_decoration->decoQty = $workorderDeco->quantity;
                    $job_product_decoration->decoCostPrice = $workorderDeco->cost_price;
                    $job_product_decoration->decosupref = $workorderDeco->supref;
                    $job_product_decoration->customizationDetails = $workorderDeco->customization_detail;
                    $job_product_decoration->user_id = Yii::app()->user->id;
                    $job_product_decoration->status_id = 1; //New

                    $job_product_decoration->work_order_detail_decoration_id = $workorderDeco->id;

                    $job_product_decoration->save(false);
                }
            }
        }
        $workOrderDetail = Workorderdetails::model()->findByPk($_POST['workOrderDetailID']);

        echo json_encode(array('html' => $workOrderDetail->getMultiDecoHtml()));
    }

    public function actionGetMultiDecoLineHtml()
    {
        $decoarr = array_filter($_POST['decoIds']);
        $html = "";
        foreach ($decoarr as $key => $value) {
            $decoration = Decoration::model()->findByPk($value);


            $html .= "<tr id='temperydeco_{$value}' style='width=100%;border-bottom:1px solid #ccc;'>"
                . "<td colspan='3'>"
                . "<table style='width=100%;'>"
                . "<tr style='width=100%;'>"
                . "<td>{$decoration->decprtnam}</td>"
                . "<td><input style='width=200px;' type='text' name='Decoration[{$value}][decnam]' value='{$decoration->decnam}'/></td>"
                . "<td><input style='width=120px;text-align:center;' type='text' name='Decoration[{$value}][decuntprice]' value='{$decoration->decuntprice}'/></td>"
                . "</tr>"
                . "<tr style='width=100%;'>"
                . "<td colspan='3'>"
                . "<table style='width=100%;'>"
                . "<tr style='width=100%;'>"
                . "<th style='text-align:center;'>Customisation Details</th>"
                . "</tr>"
                . "<tr style='width=100%;'>"
                . "<td><textarea style='width:95%;' rows='1'  name='Decoration[{$value}][customization_detail]'></textarea></td>"
                . "</tr>"
                . "</table>"
                . "</td>"
                . "</tr>"
                . "</table>"
                . "</td>"
                . "<td>"
                . "<table style='width: 100%;cursor: pointer;font-size:8pt;' onclick='deleteTemporyDeco({$value});return false;'>
					<tr>
						<td style='width: 30%;'><span class='sodtlicon fa fa-trash-o'></span></td>
						<td>Delete Item</td>
					</tr>
					</table>
			  </td>"
                . "</tr>";
        }

        echo json_encode(array('html' => $html));
    }

    public function actionGetNewMultiDecorationsHtml()
    {
        $decoString = $_POST['decoString'];
        $quantity = $_POST['qty'];

        $decorations = Decoration::model()->findAll(array('condition' => "decsno in ($decoString)"));

        $htmlNewDecoInputs = $this->getNewDocorationInputHtml($decorations);
        $htmlNewDecoDescriptions = $this->getNewDocorationDecsriptionHtml($decorations);


        echo json_encode(array('htmlNewDecoInputs' => $htmlNewDecoInputs, 'htmlNewDecoDescriptions' => $htmlNewDecoDescriptions));
    }

    private function getNewDocorationInputHtml($decorations)
    {
        $html = "";

        foreach ($decorations as $data) {
            $html .= "<input type='text'  name='WorkorderDetailsDecoration[][decsno]' value='{$data->decsno}' />";
        }

        return $html;
    }

    private function getNewDocorationDecsriptionHtml($decorations)
    {
        $html = "<ul>";

        foreach ($decorations as $data) {
            $html .= "<li>{$data->decnam}</li>";
        }

        $html .= "</ul>";

        return $html;
    }

    public function actionGetAddNewMultiDecorationCalScreenHtml()
    {
        $decorationsPostArr = $_POST['WorkorderDetailsDecoration'];

        $quantity = $_POST['Workorderdetails']['prodQty'];
        //		$decoIdArr = array();
        //		foreach ($decorationsPostArr as $key => $value) {
        //			$decoIdArr[] = $value['decsno'];
        //		}
        //		$criteria = new CDbCriteria;
        //		$criteria->addInCondition('decsno', $decoIdArr);
        //		$decorations = Decoration::model()->findAll($criteria);
        echo json_encode(array('html' => $this->getAddNewMultiDecorationCalScreenHtml($decorationsPostArr, $quantity)));
    }

    private function getAddNewMultiDecorationCalScreenHtml($decorationsPostArr, $quantity)
    {
        $html = "<table style='width:100%;'>";
        $html .= "<tr style='width:100%;'>";
        $html .= "<th style='width: 5%;text-align:center;'>No</th>";
        $html .= "<th style='width: 30%;text-align:center;'>Code</th>";
        $html .= "<th style='width: 20%;text-align:center;'>Unit Price</th>";
        $html .= "<th style='width: 25%;text-align:center;'>Mark-Up</th>";
        $html .= "<th style='width: 20%;text-align:center;'>Marked-Up Price</th>";
        $html .= "</tr>";
        $html .= "<tbody>";

        $count = 0;

        $decorationTotal = 0;

        foreach ($decorationsPostArr as $key => $value) {


            $data = Decoration::model()->findByPk($value['decsno']);

            if (isset($value['decprtnam'])) {
                //already added deco to calscreen				

                $decoCalArr = WorkorderDetailsDecoration::getAddNewDecorationCalculations(
                    array(
                        'cost_price' => $value['cost_price'],
                        'sup_margin' => $value['sup_margin'],
                        'logo_setup' => $value['logo_setup'],
                        'quantity' => $quantity,
                        'logo_setup_markup_rate' => $value['logo_setup_markup_rate']
                    )
                );
            } else {

                $decoCalArr = WorkorderDetailsDecoration::getAddNewDecorationCalculations(
                    array(
                        'cost_price' => $data->decuntprice,
                        'sup_margin' => ($data->supplier ? $data->supplier->supmrate : 0),
                        'logo_setup' => $data->declogo_setup_charges,
                        'quantity' => $quantity,
                        'logo_setup_markup_rate' => ($data->logoSetupUnitMarkupRate ?: 0)
                    )
                );
            }


            $supplierHtml = $data->supplier ? $data->supplier->getSupplierLink() : '';




            $decorationTotal += $decoCalArr['sup_markedup_price'] + $decoCalArr['logo_setup_unit_markedup_price'];
            $supmargPercentage = $decoCalArr['sup_margin'] ? $this->getMarginOutOfMarkupMultiplier($decoCalArr['sup_margin']) : 0;
            $logoSetupMarkupPercentage = $decoCalArr['logo_setup_markup_rate'] ? $this->getMarginOutOfMarkupMultiplier($decoCalArr['logo_setup_markup_rate']) : 0;

            $html .= "<tr style='width:100%;border-bottom:1px solid #eee;'>";
            $html .= "<td style='width:5%;'>" . ($count + 1) . "</td>";
            $html .= "<td   colspan='4'>";
            $html .= "<table style='width:100%;'>";

            $html .= "<tr style='width:100%;'>";
            $html .= "<td style='width: 30%;'><input type='hidden' name='WorkorderDetailsDecoration[{$count}][decprtnam]' value='{$data->decprtnam}' /><div style='font-size:8.5pt;'>{$data->decprtnam}</div><div style='font-size:7.5pt;'>{$data->decnam}</div><div style='font-size:8.5pt;'>{$supplierHtml}</div></td>";
            $html .= "<td style='width:20%;text-align:right;'><input type='text' name='WorkorderDetailsDecoration[{$count}][cost_price]' value='{$decoCalArr['cost_price']}' style='width:90%;text-align:center;'/></td>";
            $html .= "<td style='width: 25%;text-align:right;'>"
                . "<input mark-up='rate' type='text' name='WorkorderDetailsDecoration[{$count}][sup_margin]' value='{$decoCalArr['sup_margin']}' style='width:30%;text-align:center;margin-right:2px;'/>"
                . "<input title='percentage(%)' mark-up='percentage'  type='text'  style='text-align: center;width: 30%;' name='WorkorderDetailsDecoration[{$count}][supmargPercentage]' value='{$supmargPercentage}' />  (%)"
                . "</td>";
            $html .= "<td style='width: 20%;text-align:right;'><input type='text' name='WorkorderDetailsDecoration[{$count}][sup_markedup_price]' value='{$decoCalArr['sup_markedup_price']}' readonly='true' style='width:90%;text-align:right;'/></td>";
            $html .= "</tr>";
            $html .= "<tr style='width:100%;'>";
            $html .= "<td style='width:30%;'>LogoSetup : <input type='text' name='WorkorderDetailsDecoration[{$count}][logo_setup]' value='{$decoCalArr['logo_setup']}' style='width:40%;text-align:center;'/></td>";
            $html .= "<td style='width: 20%;text-align:right;'><input type='text' name='WorkorderDetailsDecoration[{$count}][logo_setup_unit_price]' value='{$decoCalArr['logo_setup_unit_price']}' style='width:90%;text-align:center;'/></td>";
            $html .= "<td style='width: 25%;text-align:right;'>"
                . "<input mark-up='rate' type='text' name='WorkorderDetailsDecoration[{$count}][logo_setup_markup_rate]' value='{$decoCalArr['logo_setup_markup_rate']}' style='width:30%;text-align:center;margin-right:2px;'/>"
                . "<input title='percentage(%)' mark-up='percentage'  type='text'  style='text-align: center;width: 30%;' name='WorkorderDetailsDecoration[{$count}][logoSetupMarkupPercentage]' value='{$logoSetupMarkupPercentage}' />  (%)"
                . "</td>";
            $html .= "<td style='width: 20%;text-align:right;'><input type='text' name='WorkorderDetailsDecoration[{$count}][logo_setup_unit_markedup_price]' value='{$decoCalArr['logo_setup_unit_markedup_price']}' readonly='true' style='width:90%;text-align:right;' /></td>";
            $html .= "</tr>";

            $html .= "</table>";
            $html .= "</td>";
            $html .= "</tr>";
            $count++;
        }



        $html .= "<tr style='width:100%;'>";
        $html .= "<td colspan='4' style='text-align:right;'>Decoration Total : </td><td><input name='addnew_decoration_total' id='addnew_decoration_total' type='text' value='{$decorationTotal}' readonly='true' style='width:90%;text-align:right;' /></td>";
        $html .= "</tr>";

        $html .= "</tbody>";
        $html .= "</table>";

        return $html;
    }

    public function actionDoAddNewPricePlayingCal()
    {
        $arr = array();
        $arr['error_message'] = "";


        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }

        $prodCostPrice = floatval($_POST['adnew_cost_price']);
        $prodSellPrice = floatval($_POST['adnew_sell_price']);
        $prodMarkupRate = floatval($_POST['adnew_prd_markup']);
        $prodDiscPercntg = floatval($_POST['adnew_discount_percntg']);
        $usdFreight = floatval($_POST['adnew_usd_freight']);
        $usdFreightMarkUpRate = $_POST['adnew_usd_freight_markup_rate'];
        $lockSellPrice = isset($_POST['lockSellPrice']) ? intval($_POST['lockSellPrice']) : 0;
        $addNewSubTotalWithSetup = floatval($_POST['adnew_edit_subtotal_with_setup']);



        $itmQty = intval($_POST['adnew_edit_itm_qty']) ?: 1;



        $freightRate = floatval($_POST['adnew_freight_rate']);

        $otherCostTotal = floatval($_POST['adnew_othercost_total']);
        $otherCostMarkupRate = floatval($_POST['adnew_othercost_markup_rate']);

        $prodCode = $_POST['adnew_prd_code'];


        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;

        $decoCostPrice = 0;

        if (isset($_POST['WorkorderDetailsDecoration'])) {
            $addNewLineArr = $_POST['WorkorderDetailsDecoration'];
            foreach ($addNewLineArr as $key => $value) {


                $decoCalArr = WorkorderDetailsDecoration::getAddNewDecorationCalculations(
                    array(
                        'cost_price' => $value['cost_price'],
                        'sup_margin' => $value['sup_margin'],
                        'logo_setup' => $value['logo_setup'],
                        'quantity' => $itmQty,
                        'logo_setup_markup_rate' => $value['logo_setup_markup_rate']
                    )
                );


                $arr['multiDecoLines'][] = array(
                    "WorkorderDetailsDecoration[$key][sup_markedup_price]" => $decoCalArr['sup_markedup_price'],
                    "WorkorderDetailsDecoration[$key][logo_setup_unit_price]" => $decoCalArr['logo_setup_unit_price'],
                    "WorkorderDetailsDecoration[$key][logo_setup_unit_markedup_price]" => $decoCalArr['logo_setup_unit_markedup_price'],
                );


                $decoCostPrice += $value['cost_price'] + $decoCalArr['logo_setup_unit_price'];
                $totalDecoSupMarginMarkupPrice += $decoCalArr['sup_markedup_price'];
                $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logo_setup_unit_markedup_price'];
            }
        }

        //if markup rate zero then set price must be zero
        $prodMarkedUpPrice = floatval($prodMarkupRate) ? round(($prodCostPrice * $prodMarkupRate), $roundingPrecision) : 0;

        /** lock sell price calculations */
        if ($lockSellPrice && ($prodMarkedUpPrice <= $prodSellPrice)) {
            /* if $prodSellPrice is available that means it comes when product select from the grid */

            $prodMarkupRate = $prodCostPrice ? round(($prodSellPrice / $prodCostPrice), 4) : 0;
            $prodMarkedUpPrice = round(($prodCostPrice * $prodMarkupRate), 2);
        } else if ($lockSellPrice && $addNewSubTotalWithSetup) {

            $prodMarkupRate = $prodCostPrice ? round(($addNewSubTotalWithSetup / $prodCostPrice), 4) : 0;

            $prodMarkedUpPrice = round(($prodCostPrice * $prodMarkupRate), 2);
        }

        /** End - lock sell price calculations */
        $prodDiscRate = round(($prodDiscPercntg / 100), strlen($prodDiscPercntg));
        $prodDiscountedPrice = floatval($prodDiscRate) ? round(($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)), $roundingPrecision) : $prodMarkedUpPrice;

        $usdFreightUnitCost = round(($usdFreight / $itmQty), $roundingPrecision);
        $usdFreightUnitCostWithMarkedUp = $usdFreightUnitCost * $usdFreightMarkUpRate;

        $prodUsdFreightedPrice = $prodDiscountedPrice + round(($usdFreightUnitCostWithMarkedUp), $roundingPrecision);

        $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? round(($otherCostTotal * $otherCostMarkupRate), $roundingPrecision) : $otherCostTotal;


        $subTotal = $prodUsdFreightedPrice + $otherCostMarkedUpPrice + ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice);
        $subTotalWithSetup = $subTotal;


        $total = $freightRate > 0 ? round(($subTotalWithSetup * $freightRate), $roundingPrecision) : $subTotalWithSetup;


        $grossProfit = $total - ($prodCostPrice + $usdFreightUnitCost + $decoCostPrice + $otherCostTotal);
        $grossProfitPercentage = $total ? round(($grossProfit / $total) * 100, 2) : 0;

        $arr['lockSellPrice'] = $lockSellPrice;
        $arr['prodMarkupRate'] = $prodMarkupRate;
        $arr['prodDiscountedPrice'] = $prodDiscountedPrice;
        $arr['prodUsdFreightedPrice'] = $prodUsdFreightedPrice;

        $arr['subTotal'] = $subTotal;
        $arr['subTotalWithSetup'] = $subTotalWithSetup;
        $arr['total'] = $total;
        $arr['lineTotal'] = round(($total * $itmQty), 2);
        $arr['quantity'] = $itmQty;
        $arr['usdFreightUnitCost'] = $usdFreightUnitCost;
        $arr['usdFreightUnitCostWithMarkedUp'] = $usdFreightUnitCostWithMarkedUp;

        $arr['totalDecoSupMarginMarkupPrice'] = $totalDecoSupMarginMarkupPrice;
        $arr['totalDecoLogosetupUnitMarkupPrice'] = $totalDecoLogosetupUnitMarkupPrice;
        $arr['decorationTotal'] = ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice);


        $arr['otherCostMarkedUpPrice'] = $otherCostMarkedUpPrice;
        $arr['otherCostMarkedUpRate'] = $otherCostMarkupRate;

        $arr['totalCostPrice'] = ($prodCostPrice + $usdFreightUnitCost + $decoCostPrice + $otherCostTotal);
        $arr['grossProfitPercentage'] = $grossProfitPercentage;
        $arr['grossProfit'] = $grossProfit;
        $arr['totalGrossProfit'] = $grossProfit * $itmQty;


        echo json_encode($arr);
    }

    public function actionSaveLineOrder()
    {
        $wrkorddtlID = intval($_POST['wrkorddtlID']);
        $value = intval($_POST['value']);

        $updated = Workorderdetails::model()->updateByPk($wrkorddtlID, array(
            "lineOrder" => $value
        ));
    }

    public function actionDoMarginPlayingCalForProductCost()
    {
        $arr = array();
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }


        $freightRate = floatval($_POST['af_freight_rate']);

        $productCost = floatval($_POST['af_edit_cost_price']);

        $usdFreight = floatval($_POST['af_usd_freight']);
        $usdFreightUnitPrice = floatval($_POST['af_usd_freight_unit_cost']);
        $usdFreightMarkedUpRate = floatval($_POST['af_usd_freight_markup_rate']);

        $subTotalWithSetupUnit = floatval($_POST['af_edit_subtotal_with_setup']);


        $decorationTotal = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['af_edit_decoration_total']) : 0; //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO


        $otherCostTotal = floatval($_POST['af_edit_othercost_total']);
        $otherCostMarkupRate = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['af_edit_othercost_markup_rate']) : 0;  //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        $otherCostTotalMarkedUp = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['af_edit_othercost_markedup_price']) : 0; //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        //$setupUnitPrice = $_POST['af_unit_setup_charge'];



        $itemQty = intval($_POST['af_edit_itm_qty']);
        $discountPercentage = floatval($_POST['af_discount_percntg']);
        $prodcutCostMarkedUp = floatval($_POST['af_edit_prd_markup']);

        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;


        $decoCostPrice = 0;
        if (isset($_POST['WorkorderDetailsDecoration'])) {
            $editedLineArr = $_POST['WorkorderDetailsDecoration'];
            foreach ($editedLineArr as $key => $value) {

                $workOrderDeco = WorkorderDetailsDecoration::model()->findByPk($key);
                $decoCalArr = $workOrderDeco->getDecorationCalculations(
                    array(
                        'cost_price' => $value['cost_price'],
                        'sup_margin' => (($subTotalWithSetupUnit && $productCost) ? $value['sup_margin'] : 0), //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO  //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
                        'logo_setup' => $value['logo_setup'],
                        'quantity' => $itemQty,
                        'logo_setup_markup_rate' => (($subTotalWithSetupUnit && $productCost) ? $value['logo_setup_markup_rate'] : 0) //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO  //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
                    )
                );


                $arr['multiDecoLines'][] = array(
                    "WorkorderDetailsDecoration[$key][sup_margin]" => (($subTotalWithSetupUnit && $productCost) ? $value['sup_margin'] : 0),
                    "WorkorderDetailsDecoration[$key][sup_markedup_price]" => $decoCalArr['sup_markedup_price'],
                    "WorkorderDetailsDecoration[$key][logo_setup_unit_price]" => $decoCalArr['logo_setup_unit_price'],
                    "WorkorderDetailsDecoration[$key][logo_setup_markup_rate]" => (($subTotalWithSetupUnit && $productCost) ? $value['logo_setup_markup_rate'] : 0),
                    "WorkorderDetailsDecoration[$key][logo_setup_unit_markedup_price]" => $decoCalArr['logo_setup_unit_markedup_price'],
                );

                $decoCostPrice += $value['cost_price'] + $decoCalArr['logo_setup_unit_price'];
                $totalDecoSupMarginMarkupPrice += $decoCalArr['sup_markedup_price'];
                $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logo_setup_unit_markedup_price'];
            }
        }

        if ($subTotalWithSetupUnit && $productCost) {
            $t = $subTotalWithSetupUnit - ($decorationTotal + $otherCostTotalMarkedUp); //total product price
            $mk_d = $t - ($usdFreight ? (round(($usdFreight / $itemQty), $roundingPrecision) * $usdFreightMarkedUpRate) : 0); // marked up + discount without usd freight cost

            /*
             * Equation to find product cost price
             * c = product cost price
             * m = product cost marked up price + discount
             * r = product cost  marked up rate
             * d = discount percentage
             * 
             * c = m * 100 / r * (100 - d) 
             * 
             * Equation for product markup rate
             * 
             * r = ( ( m * 100 ) / c) / (100 - d)
             */

            $prodcutCostMarkUpRate = round(((round((( $mk_d * 100) / $productCost), 2)) / ( (100 - $discountPercentage ? 100 - $discountPercentage : 100) )), 4);
        }

        //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO
        //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        if (!$subTotalWithSetupUnit || !$productCost) {
            $prodcutCostMarkUpRate = 0;
            $usdFreightMarkedUpRate = 0;
            $discountPercentage = 0;
        }

        $prodcutCostMarkedUp = $productCost * $prodcutCostMarkUpRate;
        $prodcutCostMarkedUpWithDiscount = $prodcutCostMarkedUp * (100 - $discountPercentage) / 100;

        //$productSectionTotal = $prodcutCostMarkedUpWithDiscount + (round(($usdFreight / $itemQty), $roundingPrecision));

        $productCostMarkupPercentage = $this->getMarginOutOfMarkupMultiplier($prodcutCostMarkUpRate);
        $subTotal = $subTotalWithSetupUnit;
        $grandTotal = $freightRate ? round(($subTotalWithSetupUnit * $freightRate), $roundingPrecision) : $subTotalWithSetupUnit;

        $grossProfit = $subTotal - ($productCost + $usdFreightUnitPrice + $decoCostPrice + $otherCostTotal);
        $grossProfitPercentage = $subTotal ? round(($grossProfit / $subTotal) * 100, 2) : 0;

        $arr['product_total'] = round($t, $roundingPrecision);
        $arr['discounted_price'] = round($mk_d, $roundingPrecision);
        $arr['product_cost_markup_rate'] = $prodcutCostMarkUpRate;
        $arr['productCostMarkupPercentage'] = $productCostMarkupPercentage;
        $arr['product_cost_markedup_with_discount'] = round($prodcutCostMarkedUpWithDiscount, 2);
        $arr['product_section_total'] = round($t, 2);
        $arr['subTotal'] = round($subTotal, 2);
        $arr['sub_total_with_setup_unit'] = round($subTotalWithSetupUnit, 2);
        $arr['grand_total'] = $grandTotal;
        $arr['decoCostTotal'] = $decoCostPrice;
        $arr['lineTotal'] = round(($grandTotal * $itemQty), 2);
        $arr['decorationTotal'] = ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice) ?: $decorationTotal;
        $arr['grossProfitPercentage'] = $grossProfitPercentage;
        $arr['grossProfit'] = $grossProfit;
        $arr['totalGrossProfit'] = $grossProfit * $itemQty;

        echo json_encode($arr);
    }

    public function actionDoAddNewMarginPlayingCalForProductCost()
    {

        $arr = array();
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        if (empty($roundingPrecision)) {
            $roundingPrecision = 2;
        }

        //$grandTotalWithFreight = $_POST['adnew_edit_total'];
        $freightRate = floatval($_POST['adnew_freight_rate']);

        $productCost = floatval($_POST['adnew_cost_price']);

        $usdFreight = floatval($_POST['adnew_usd_freight']);
        $usdFreightUnitPrice = floatval($_POST['adnew_usd_freight_unit_cost']);
        $usdFreightMarkedUpRate = floatval($_POST['adnew_usd_freight_markup_rate']);

        $subTotalWithSetupUnit = floatval($_POST['adnew_edit_subtotal_with_setup']);


        $decorationTotal = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['addnew_decoration_total']) : 0; //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO


        $otherCostTotal = floatval($_POST['adnew_othercost_total']);
        $otherCostMarkupRate = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['adnew_edit_othercost_markup_rate']) : 0;  //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        $otherCostTotalMarkedUp = ($subTotalWithSetupUnit && $productCost) ? floatval($_POST['adnew_edit_othercost_markedup_price']) : 0; //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        //$setupUnitPrice = $_POST['adnew_unit_setup_charge'];




        $itemQty = floatval($_POST['adnew_edit_itm_qty']);
        $discountPercentage = floatval($_POST['adnew_discount_percntg']);
        //$prodcutCostMarkedUp = $_POST['adnew_prd_markup'];
        //$freightRate = $_POST['adnew_freight_rate'];
        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;

        $decoCostPrice = 0;
        if (isset($_POST['WorkorderDetailsDecoration'])) {
            $addNewLineArr = $_POST['WorkorderDetailsDecoration'];
            foreach ($addNewLineArr as $key => $value) {


                $decoCalArr = WorkorderDetailsDecoration::getAddNewDecorationCalculations(
                    array(
                        'cost_price' => $value['cost_price'],
                        'sup_margin' => (($subTotalWithSetupUnit && $productCost) ? $value['supmarg'] : 0), //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO  //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
                        'logo_setup' => $value['logo_setup'],
                        'quantity' => $itemQty,
                        'logo_setup_markup_rate' => (($subTotalWithSetupUnit && $productCost) ? $value['logoSetupMarkupRate'] : 0) //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO  //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
                    )
                );


                $arr['multiDecoLines'][] = array(
                    "WorkorderDetailsDecoration[$key][sup_margin]" => (($subTotalWithSetupUnit && $productCost) ? $value['sup_margin'] : 0),
                    "WorkorderDetailsDecoration[$key][sup_markedup_price]" => $decoCalArr['sup_markedup_price'],
                    "WorkorderDetailsDecoration[$key][logo_setup_unit_price]" => $decoCalArr['logo_setup_unit_price'],
                    "WorkorderDetailsDecoration[$key][logo_setup_markup_rate]" => (($subTotalWithSetupUnit && $productCost) ? $value['logo_setup_markup_rate'] : 0),
                    "WorkorderDetailsDecoration[$key][logo_setup_unit_markedup_price]" => $decoCalArr['logo_setup_unit_markedup_price'],
                );


                $decoCostPrice += $value['cost_price'] + $decoCalArr['logo_setup_unit_price'];
                $totalDecoSupMarginMarkupPrice += $decoCalArr['sup_markedup_price'];
                $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logo_setup_unit_markedup_price'];
            }
        }

        if ($subTotalWithSetupUnit && $productCost) {


            $t = $subTotalWithSetupUnit - ($decorationTotal + $otherCostTotalMarkedUp); //total product price
            $mk_d = $t - ($usdFreight ? (round(($usdFreight / $itemQty), $roundingPrecision) * $usdFreightMarkedUpRate) : 0); // marked up + discount without usd freight cost

            /*
             * Equation to find product cost price
             * c = product cost price
             * m = product cost marked up price + discount
             * r = product cost  marked up rate
             * d = discount percentage
             * 
             * c = m * 100 / r * (100 - d) 
             * 
             * Equation for product markup rate
             * 
             * r = ( ( m * 100 ) / c) / (100 - d)
             * 
             */

            $prodcutCostMarkUpRate = $productCost ? round(((round((($mk_d * 100) / $productCost), 2)) / (100 - $discountPercentage)), 4) : 0;
        }

        //SELL PRICE LOCKED - FIRST SCENARIO - SELL PRICE ZERO
        //SELL PRICE LOCKED - THIRD SCENARIO - COST PRICE ZERO
        if (!$subTotalWithSetupUnit || !$productCost) {
            $prodcutCostMarkUpRate = 0;
            $usdFreightMarkedUpRate = 0;
            $discountPercentage = 0;
        }

        $prodcutCostMarkedUp = $productCost * $prodcutCostMarkUpRate;
        $prodcutCostMarkedUpWithDiscount = $prodcutCostMarkedUp * (100 - $discountPercentage) / 100;

        //$productSectionTotal = $prodcutCostMarkedUpWithDiscount + (round(($usdFreight / $itemQty), $roundingPrecision));

        $productCostMarkupPercentage = $this->getMarginOutOfMarkupMultiplier($prodcutCostMarkUpRate);
        $subTotal = $subTotalWithSetupUnit;
        $grandTotal = $freightRate ? round(($subTotalWithSetupUnit * $freightRate), $roundingPrecision) : $subTotalWithSetupUnit;

        $grossProfit = $subTotal - ($productCost + $usdFreightUnitPrice + $decoCostPrice + $otherCostTotal);
        $grossProfitPercentage = $subTotal ? round(($grossProfit / $subTotal) * 100, 2) : 0;


        $arr['product_total'] = round($t, $roundingPrecision);
        $arr['discounted_price'] = round($mk_d, $roundingPrecision);
        $arr['product_cost_markup_rate'] = $prodcutCostMarkUpRate;
        $arr['productCostMarkupPercentage'] = $productCostMarkupPercentage;
        $arr['product_cost_markedup_with_discount'] = round($prodcutCostMarkedUpWithDiscount, 2);
        $arr['product_section_total'] = round($t, 2);
        $arr['subTotal'] = round($subTotal, 2);
        $arr['sub_total_with_setup_unit'] = round($subTotalWithSetupUnit, 2);
        $arr['grand_total'] = $grandTotal;
        $arr['decoCostTotal'] = $decoCostPrice;
        $arr['lineTotal'] = round(($grandTotal * $itemQty), 2);
        $arr['decorationTotal'] = ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice) ?: $decorationTotal;
        $arr['grossProfitPercentage'] = $grossProfitPercentage;
        $arr['grossProfit'] = $grossProfit;
        $arr['totalGrossProfit'] = $grossProfit * $itemQty;

        echo json_encode($arr);
    }

    public function actionAddDetailsFromQuoteItems()
    {
        if (isset($_POST['workorderId']) && isset($_POST['quoteDetailId'])) {
            $transaction = Yii::app()->db->beginTransaction();
            $quoteDetail = QuatationDetails::model()->findByPk($_POST['quoteDetailId']);
            $workorderDetails = Workorderdetails::createDetailByQuoteItem($_POST['workorderId'], $quoteDetail);

            if ($workorderDetails) {
                $transaction->commit();

                $salesdetail = $this->getSalesDetailFromModel($workorderDetails);
                $url = Yii::app()->createUrl('workorderdetails/admin', array("wid" => $workorderDetails->workorder->id));
                $link = CHtml::link($workorderDetails->workorder->salesorderNumber, $url, array('target' => '_blank'));
                $quoteNumber = $workorderDetails->workorder->quotation->quoteno;
                SalesLog::createSalesLog($workorderDetails->workorder->quotationId, $workorderDetails->workorder->id, $workorderDetails->workorder->quotationNumber, 'SalesOrder', "New sales details ({$salesdetail}) is added to Sales Order ({$link}) from quote {$quoteNumber}", 1, 0, 1);

                echo $this->getHtml($workorderDetails);
            } else {
                $transaction->rollback();
            }
        }
    }

    public function actionFetchPriceLookupHtml()
    {

        if (isset($_POST['workorderDetailId']) && $workorderDetailId = $_POST['workorderDetailId']) {
            $model = $this->loadModel($workorderDetailId);
            if ($model->product_source == ProductLine::PRODUCT_SOURCE_GWS_API) {
                $postFields = GwsProductApi::getDefaultPostFields();
                $postFields['data'] = array(
                    'supplier' => '',
                    'product_code' => $model->productsku,
                    'product_Name' => '',
                    'category' => ''
                );

                $apiProductData = GwsProductApi::productData($postFields);
                $html = GwsProductApi::extractPriceBreaksIntoTable($apiProductData[0]);
            } else {

                $html = $model->product->getHtmlPriceLookUpCalScreen();
            }

            echo json_encode(array('html' => $html, 'productCode' => $model->productsku));
        } else if (isset($_POST['productCode']) && $productCode = $_POST['productCode']) {
            //for new cal screen
            //for new cal screen
            if (isset($_POST['productSource']) && $_POST['productSource'] == ProductLine::PRODUCT_SOURCE_GWS_API) {
                $postFields = GwsProductApi::getDefaultPostFields();
                $postFields['data'] = array(
                    'supplier' => '',
                    'product_code' => $productCode,
                    'product_Name' => '',
                    'category' => ''
                );

                $apiProductData = GwsProductApi::productData($postFields);
                $html = GwsProductApi::extractPriceBreaksIntoTable($apiProductData[0]);
            } else {
                $productLine = ProductLine::model()->find("pdlpdl = '{$productCode}'");
                $html = $productLine->getHtmlPriceLookUpCalScreen();
            }

            echo json_encode(array('html' => $html, 'productCode' => $productCode));
        }
    }

    public function actionUpdateByAtrribute()
    {
        $id = $_POST['id'];
        $attribute = $_POST['attr'];
        $attrVal = $_POST['attrVal'];

        $model = $this->loadModel($id);
        $model->{$attribute} = $attrVal;
        if ($model->save()) {
            echo json_encode(array('status' => true));
        } else {
            echo json_encode(array('status' => false));
        }
    }

    public function actionFetchDetailFlags()
    {
        $id = $_POST['id'];
        $model = $this->loadModel($id);

        $flags = array();

        if ($model->hide_on_pdf) {

            //send flags which have value

            $flags[] = 'hide_on_pdf';
        }



        echo json_encode(array('flags' => $flags));
    }

    public function actionUpdateDetailFlags()
    {
        $id = $_POST['id'];
        //whatever available here that means those attributes have been selected
        $flags = isset($_POST['flags']) ? $_POST['flags'] : array();
        $offFlags = isset($_POST['offFlags']) ? $_POST['offFlags'] : array();

        $model = $this->loadModel($id);

        //set new flags from the front-end updated options

        foreach ($flags as $attr) {

            $model->$attr = 1;
        }

        //turn off if there is no flags
        foreach ($offFlags as $attr) {

            $model->$attr = 0;
        }

        if ($model->save()) {
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => false));
        }
    }

    public function actionOnFlagsLabelsHtml()
    {
        $id = $_POST['id'];
        $model = $this->loadModel($id);

        $html = $model->getOnFlagsLabelsHtml();



        echo json_encode(array('html' => $html));
    }
}
