<?php

class WorkorderdetailssizecolorController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete', 'deleteAjax', 'createRecordAjax', 'updateSize', 'updateQty', 'updateColor'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new Workorderdetailssizecolor;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Workorderdetailssizecolor'])) {
            $model->attributes = $_POST['Workorderdetailssizecolor'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Workorderdetailssizecolor'])) {
            $model->attributes = $_POST['Workorderdetailssizecolor'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    public function actionUpdateSize() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->size = $_POST['value'];

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionUpdateQty() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    $model->qty = intval($_POST['value']);

                    if ($model->save()) {
                        $workorderdtl = Workorderdetails::model()->findByPk($model->workOrderDetailsId);
                        $qtydiff = $workorderdtl->qtyDiff();

                        $resultArr['status'] = 'success';
                        $resultArr['qtydiff'] = $qtydiff;
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    public function actionUpdateColor() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'], $_POST['value'])) {
                $resultArr = array();
                $model = $this->loadModel($_POST['id']);
                if (!empty($model)) {
                    
                    $model->color = trim($_POST['value']);

                    if ($model->save()) {
                        $resultArr['status'] = 'success';
                        echo json_encode($resultArr);
                    } else {
                        throw new Exception;
                    }
                }
            }
        }
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    public function actionDeleteAjax() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            $model = $this->loadModel($_POST['id']);
            $arr = array();
            $arr['wrkodrdtlID'] = $model->workOrderDetailsId;

            if ($model->delete()) {
                $workodrdtl = Workorderdetails::model()->findByPk($arr['wrkodrdtlID']);
                $arr['qtydiff'] = $workodrdtl->qtyDiff();
                echo json_encode($arr);
            } else {
                throw new CHttpException(400, 'error in delete');
            }
        }
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Workorderdetailssizecolor');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new Workorderdetailssizecolor('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Workorderdetailssizecolor']))
            $model->attributes = $_GET['Workorderdetailssizecolor'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = Workorderdetailssizecolor::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'workorderdetailssizecolor-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionCreateRecordAjax() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if ($workorderdetailsID = $_POST['id']) {
                $previSize = $_POST['copysize'];
                $previQty = $_POST['copyqty'];
                $previColor = $_POST['copycolor'];

                $lastSizeQtyColorRecord = Workorderdetailssizecolor::model()->find(array('condition'=>"workOrderDetailsId = $workorderdetailsID", 'order'=>'id DESC'));

                $sizeqtycolormodel = new Workorderdetailssizecolor;
				if ($lastSizeQtyColorRecord) {
					$sizeqtycolormodel->attributes = $lastSizeQtyColorRecord->attributes;
                                        $sizeqtycolormodel->color = $previColor;
					unset($sizeqtycolormodel->id);
				} else {
                $sizeqtycolormodel->workOrderDetailsId = $workorderdetailsID;
				}

				if ($sizeqtycolormodel->save(false)) {
                    
                    echo json_encode(array('rowid' => $sizeqtycolormodel->id));
                }
                
            }
        }
    }

    public function actionGetWorkorderDetailID() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'])) {

                $rowid = $_POST['id'];
                $resultArr = array();
                $sizeqtycolorrow = Workorderdetailssizecolor::model()->findByPk($_POST['id']);


                $resultArr['wodtlID'] = $sizeqtycolorrow->workOrderDetailsId;
                $resultArr['qty'] = $sizeqtycolorrow->qty ?:'';
                $resultArr['size'] = $sizeqtycolorrow->size?:'';
                $resultArr['color'] = $sizeqtycolorrow->color?:'';
                
                $prevrecord = Workorderdetailssizecolor::model()->find(array('condition'=>"workOrderDetailsId = $sizeqtycolorrow->workOrderDetailsId and id < $rowid", 'order'=>'id asc'));
                
                if(!empty($prevrecord))
                    $resultArr['prevRawID'] = $prevrecord->id;
                else $resultArr['prevRawID'] = 0;
                
                echo json_encode($resultArr);
            } else {
                throw new Exception;
            }
        }
    }

    public function actionFetchRowHtmlByDtlID() {
        if (Yii::app()->request->isPostRequest && Yii::app()->request->isAjaxRequest) {
            if (isset($_POST['id'])) {

                $wrkordrdtlID = $_POST['id'];
                $sizeqtycolorrow = Workorderdetailssizecolor::model()->findAll(array('condition' => "workOrderDetailsId = '{$wrkordrdtlID}'"));
                
                $html = '';
                $countrow = 0;
                foreach ($sizeqtycolorrow as $row){
                    $countrow++;
                    $html .= "<tr id='sizeqtycolorDBrow_$row->id' >";
                    $html .= '<td class="column1">'.$countrow.'</td>';
                    $html .= '<td class="column2half">'.$row->size.'</td>
                              <td class="column2half">'.$row->qty.'</td>
                              <td class="column2half">'.$row->color.'</td>';
                    $html .= '<td class="column1half">
                                <a href="#" onclick="editsizeqtycolorDBrowAjaxcall('.$row->id.');return false;">Edit</a>&nbsp;|&nbsp;
                                <a href="#" onclick="deletesizeqtycolorDBrow('.$row->id.');return false;" >Delete</a>                                                                           
                               </td>';
                    $html .= '</tr>';
                }
                echo $html;
            }
        }
    }
	
	
	public function actionValidateQtyMismatch()
	{
		if ($workorderdetailsID = intval($_POST['workorderdetailsID'])) {
			$workorderDetail = Workorderdetails::model()->findByPk($workorderdetailsID);
			$maxQty = $workorderDetail->prodQty; // this qty cannot be exceeded
			
			$sql = "SELECT SUM(qty) as currentSizeBreakQtyTotal FROM workorderdetailssizecolor WHERE workOrderDetailsId = $workorderdetailsID";
			$result = Yii::app()->db->createCommand($sql)->queryRow();
			$currentSizeBreakQtyTotal = $result['currentSizeBreakQtyTotal'];
			
			
			
			if ($maxQty > $currentSizeBreakQtyTotal) {
				echo json_encode(array('message' => 'DECEED', 'balance' => ($maxQty - $currentSizeBreakQtyTotal), '$maxQty' => $maxQty));
			} else if($maxQty == $currentSizeBreakQtyTotal) {
				echo json_encode(array('message' => '', 'balance' => 0, '$maxQty' => $maxQty));
			} else {
				echo json_encode(array('message' => 'EXCEEDED', 'balance' => ($currentSizeBreakQtyTotal - $maxQty), '$maxQty' => $maxQty));
			}
		}
	}

}
