<?php

class XeroSettingController extends RController {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights',
                //'accessControl', // perform access control for CRUD operations
        );
    }

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform these actions
                'actions' => array('login', 'logout', 'forgot'),
                'users' => array('*'),
            ),
            array('allow', // allow all users to perform these actions
                'actions' => array('login', 'index', 'logout', 'view', 'admin'),
                'users' => array('@'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('dashboard'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Declares class-based actions.
     */
//    public function actions() {
//        return array(
//            // captcha action renders the CAPTCHA image displayed on the contact page
//            'captcha' => array(
//                'class' => 'CCaptchaAction',
//                'backColor' => 0xFFFFFF,
//            ),
//            // page action renders "static" pages stored under 'protected/views/site/pages'
//            // They can be accessed via: index.php?r=site/page&view=FileName
//            'page' => array(
//                'class' => 'CViewAction',
//            ),
//        );
//    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        // renders the view file 'protected/views/site/index.php'
        // using the default layout 'protected/views/layouts/main.php'
        $this->render('index');
    }

    public function actionSettings() {


        $model = new XeroSetting();
        $model->unsetAttributes();  // clear any default values
        if (isset($_POST['XeroSetting']) && isset($_POST['yt0'])) {
            
            $previuosModel = XeroSetting::getSetting();

            $model->attributes = $_POST['XeroSetting'];

            //if ($model->validate()) {

                $file = fopen("protected/filemodels/xerosettings.csv", 'w');

                if (in_array(Yii::app()->user->title, array('SuperAdmin', 'superadmin'))) {
                    fwrite($file, "clientId=>" . $model->clientId . "\n");
                    fwrite($file, "clientSecret=>" . $model->clientSecret . "\n");
                    fwrite($file, "redirectUri=>" . $model->redirectUri . "\n");
                    fwrite($file, "urlAuthorize=>" . $model->urlAuthorize . "\n");
                    fwrite($file, "urlAccessToken=>" . $model->urlAccessToken . "\n");
                    fwrite($file, "urlResourceOwnerDetails=>" . $model->urlResourceOwnerDetails . "\n");

                    fwrite($file, "shortDesc=>" . $model->shortDesc . "\n");
                    fwrite($file, "longDesc=>" . $model->longDesc . "\n");
                    fwrite($file, "sendInvAutoXero=>" . $model->sendInvAutoXero . "\n");
                    fwrite($file, "defalutInvoiceAccountId=>" . trim($model->defalutInvoiceAccountId) . "\n");
                    fwrite($file, "defalutPOAccountId=>" . trim($model->defalutPOAccountId) . "\n");
                } else {
                    fwrite($file, "clientId=>" . $previuosModel->clientId . "\n");
                    fwrite($file, "clientSecret=>" . $previuosModel->clientSecret . "\n");
                    fwrite($file, "redirectUri=>" . $previuosModel->redirectUri . "\n");
                    fwrite($file, "urlAuthorize=>" . $previuosModel->urlAuthorize . "\n");
                    fwrite($file, "urlAccessToken=>" . $previuosModel->urlAccessToken . "\n");
                    fwrite($file, "urlResourceOwnerDetails=>" . $previuosModel->urlResourceOwnerDetails . "\n");
                    
                    fwrite($file, "shortDesc=>" . $model->shortDesc . "\n");
                    fwrite($file, "longDesc=>" . $model->longDesc . "\n");
                    fwrite($file, "sendInvAutoXero=>" . $model->sendInvAutoXero . "\n");
                    fwrite($file, "defalutInvoiceAccountId=>" . trim($model->defalutInvoiceAccountId) . "\n");
                    fwrite($file, "defalutPOAccountId=>" . trim($model->defalutPOAccountId) . "\n");
                }




                if (fclose($file)) {
                    Yii::app()->user->setFlash('success', "Xero settings have been updated successfully!");
                } else {
                    Yii::app()->user->setFlash('notice', "Cannot update Xero settings! please try again or contact system admin.");
                }
            //}
        }
        $this->render('_form', array(
            'model' => $this->loadModel(),
        ));
    }

    public function loadModel() {
        return XeroSetting::getSetting();
    }

    public function actionAuthorization() {
        ini_set('display_errors', 'On');
        require 'vendor/autoload.php';
        //require_once('storage.php');
        // Storage Class uses sessions for storing access token (demo only)
        // you'll need to extend to your Database for a scalable solution
        $storage = new StorageClass();

        session_start();



        $provider = new \League\OAuth2\Client\Provider\GenericProvider(XeroSetting::getGenericProviderOptions());

        // Scope defines the data your app has permission to access.
        // Learn more about scopes at https://developer.xero.com/documentation/oauth2/scopes
        $options = [
            'scope' => ['openid email profile offline_access accounting.settings accounting.transactions accounting.contacts accounting.journals.read accounting.reports.read accounting.attachments']
        ];

        // This returns the authorizeUrl with necessary parameters applied (e.g. state).
        $authorizationUrl = $provider->getAuthorizationUrl($options);

        // Save the state generated for you and store it to the session.
        // For security, on callback we compare the saved state with the one returned to ensure they match.
        $_SESSION['oauth2state'] = $provider->getState();

        // Redirect the user to the authorization URL.
        $url = str_replace(PHP_EOL, '', $authorizationUrl);
        header('Location: ' . $url);
        exit();
    }

    public function actionCallback() {
        ini_set('display_errors', 'On');
        require 'vendor/autoload.php';
        //require_once('storage.php');
        // Storage Classe uses sessions for storing token > extend to your DB of choice
        $storage = new StorageClass();

        $provider = new \League\OAuth2\Client\Provider\GenericProvider(XeroSetting::getGenericProviderOptions());

        // If we don't have an authorization code then get one
        if (!isset($_GET['code'])) {
            echo "Something went wrong, no authorization code found";
            exit("Something went wrong, no authorization code found");

            // Check given state against previously stored one to mitigate CSRF attack
        } elseif (empty($_GET['state']) || ($_GET['state'] !== $_SESSION['oauth2state'])) {
            echo "Invalid State";
            unset($_SESSION['oauth2state']);
            exit('Invalid state');
        } else {

            try {
                // Try to get an access token using the authorization code grant.
                $accessToken = $provider->getAccessToken('authorization_code', [
                    'code' => $_GET['code']
                ]);

                $config = XeroAPI\XeroPHP\Configuration::getDefaultConfiguration()->setAccessToken((string) $accessToken->getToken());

                $config->setHost("https://api.xero.com");
                $identityInstance = new XeroAPI\XeroPHP\Api\IdentityApi(
                        new GuzzleHttp\Client(), $config
                );

                $result = $identityInstance->getConnections();

                // Save my tokens, expiration tenant_id
                $storage->setToken(
                        $accessToken->getToken(), $accessToken->getExpires(), $result[0]->getTenantId(), $accessToken->getRefreshToken(), $accessToken->getValues()["id_token"]
                );

                //header('Location: ' . './authorizedResource.php');
                $this->redirect(array('authorizedResource'));
                exit();
            } catch (\League\OAuth2\Client\Provider\Exception\IdentityProviderException $e) {
                echo "Callback failed";
                exit();
            }
        }
    }

    public function actionAuthorizedResource() {
        $this->render('_authorized');
    }

}
