<?php
require 'vendor/autoload.php';
// Use this class to deserialize error caught
use XeroAPI\XeroPHP\AccountingObjectSerializer;


class XeroSupplierController extends RController
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			  'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new XeroSupplier;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['XeroSupplier']))
		{
			$model->attributes=$_POST['XeroSupplier'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->supsno));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['XeroSupplier']))
		{
			$model->attributes=$_POST['XeroSupplier'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->supsno));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('XeroSupplier');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new XeroSupplier('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['XeroSupplier']))
			$model->attributes=$_GET['XeroSupplier'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=XeroSupplier::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='xero-supplier-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	
	public function actionSyncXero()
	{
		
		$storage = new StorageClass();
		if ($storage->getHasExpired()) {
			$this->redirect(array('xeroSetting/settings'));
		}



// Storage Classe uses sessions for storing token > extend to your DB of choice
		$storage = new StorageClass();
		$xeroTenantId = (string) $storage->getSession()['tenant_id'];

		if ($storage->getHasExpired()) {
			$provider = new \League\OAuth2\Client\Provider\GenericProvider(XeroSetting::getGenericProviderOptions());

			$newAccessToken = $provider->getAccessToken('refresh_token', [
				'refresh_token' => $storage->getRefreshToken()
			]);

			// Save my token, expiration and refresh token
			$storage->setToken(
					$newAccessToken->getToken(), $newAccessToken->getExpires(), $xeroTenantId, $newAccessToken->getRefreshToken(), $newAccessToken->getValues()["id_token"]);
		}

		$config = XeroAPI\XeroPHP\Configuration::getDefaultConfiguration()->setAccessToken((string) $storage->getSession()['token']);
		$config->setHost("https://api.xero.com/api.xro/2.0");

		$apiInstance = new XeroAPI\XeroPHP\Api\AccountingApi(
				new GuzzleHttp\Client(), $config
		);

		try {
			
			$this->xeroSupplierRecursive($apiInstance, $xeroTenantId);
			
		} catch (\XeroAPI\XeroPHP\ApiException $e) {
			$error = AccountingObjectSerializer::deserialize(
							$e->getResponseBody(), '\XeroAPI\XeroPHP\Models\Accounting\Error', []
			);
			$message = "ApiException - " . $error->getElements()[0]["validation_errors"][0]["message"];
			//print_r($error->getElements()[0]["validation_errors"]);
			//$this->redirect(array('invoice/view','id'=>$model->id, 'xrerr'=>$message));
		}
		
		$this->redirect(array('admin'));
	}

	/**
	 * @return \XeroAPI\XeroPHP\Models\Accounting\Contacts
	 */
	public $pageCount = 1;

	
	private function xeroSupplierRecursive(XeroAPI\XeroPHP\Api\AccountingApi $apiInstance, $xeroTenantId)
	{
		$xeroContacts = $apiInstance->getContacts($xeroTenantId, null, 'IsSupplier=true', null, null, $this->pageCount, null);
		
		

		if ($contacts = $xeroContacts->getContacts()) {
			foreach ($contacts as $contact) {

				$criteria = new CDbCriteria;
				if ($contact->getContactId()) {
					$criteria->addCondition("xeroContactID = '{$contact->getContactId()}' ");
				}

				$supplier = XeroSupplier::model()->find($criteria);
				if (!$supplier) {
					$criteria = new CDbCriteria;
					$criteria->addCondition("LOWER(supnam) = :supnam"); 
					$criteria->params = array(':supnam' => strtolower($contact->getName()));
					$customer = Supplier::model()->find($criteria);
				}
				if (!$supplier) {
					$supplier = new XeroSupplier();
				}
				$supplier->supnam = $contact->getName();
				foreach ($contact->getAddresses() as $address) {
					if ($address->getAddressType() == 'POBOX') {
						$supplier->supad1 = $address->getAddressLine1();
						$supplier->supad2 = $address->getAddressLine2();
						$supplier->supad3 = $address->getAddressLine3() . ' ' . $address->getAddressLine4();
						$supplier->suptown = $address->getCity();
						$supplier->supstate = $address->getRegion();
						$supplier->suppostcode = $address->getPostalCode();
					} 
				}

				foreach ($contact->getPhones() as $phone) {
					if ($phone->getPhoneType() == 'DEFAULT') {
						$supplier->suptel = $phone->getPhoneNumber();
					} else if ($phone->getPhoneType() == 'FAX') {
						$supplier->supfax = $phone->getPhoneNumber();
					}
				}



				$supplier->supemail = $contact->getEmailAddress();
				$supplier->supcontact = $contact->getFirstName() . ' ' . $contact->getLastName();
				$supplier->xeroContactID = $contact->getContactId();

				if ($supplier->save(false)) {					
					
				}
			}
			$this->pageCount++;
			$this->xeroSupplierRecursive($apiInstance, $xeroTenantId);
		} else {
			return null;
		}
	}
}
